#include "main.h"
#include "char.h"
#include "gfx.h"
#include "map.h"
#include "game.h"
#include "scroller.h"

int scroller_active;
static int pos;
static int monsters;

void
scroller_init (void)
{
	pos = 0;
	monsters = 0;
	scroller_active = 1;
}

void
scroller_frame (void)
{
	pos++;
	
	if (!(pos % (FPS / 2)))
	{
		monsters++;
	}

	if (monsters < 68)
	{
		int v = 250;
		if (monsters >= 64)
			v = 250 + 250 * (63 - monsters) / 5;
		if (!(pos % (FPS / 2)))
		{
			if (monsters > 16 || (monsters & 1) || monsters == 8 || monsters == 12)
				play_sample (step, v, 128, 1000, 0);
		}
		if (monsters > 16 && !(pos % FPS))
		{
			play_sample (victory, v, 128, 500 * rnd (1,3), 0);
		}
		if (monsters > 24 && !((pos + FPS / 2) % FPS))
		{
			play_sample (gold, v, 128, 1000 * rnd (1,3), 0);
		}
		if (monsters > 32 && !((pos + FPS / 4) % FPS))
		{
			play_sample (human[rnd (0, 6)], v, 128 + rnd (-50, 50), 1000, 0);
		}
		if (monsters > 32 && !((pos + 3 * FPS / 4) % FPS))
		{
			play_sample (creature[rnd (0, 6)], v, 128  + rnd (-50, 50), 1000, 0);
		}
	}
	else
	{
		if (!(pos % (FPS / 2)) && monsters == 68)
		{
			play_sample (intro, 250, 128 - 50, 1001, 0);
			play_sample (intro, 250, 128 + 50, 999, 0);
		}
		
		if (!(pos % (FPS / 2)) && monsters == 80)
		{
			play_sample (levelup, 250, 128, 2000, 0);
			play_sample (levelup, 250, 128, 1000, 0);
		}
	}
}

void
scroller_render (void)
{
	int i;
	int y;
	int c = makecol (255, 255, 255);
	clear_to_color (page, makecol (0, 0, 0));
	text_mode (-1);
	
	y = SCREEN_H / 2 - pos;
	textprintf_centre (page, font, 320, y += FPS / 2, c, "The sword of Fargoal!!");
	textprintf_centre (page, font, 320, y += FPS / 2, c, "created by Jeff McCord");
	textprintf_centre (page, font, 320, y += FPS / 2, c, "released by Epyx in 1983");
			
	draw_sprite (page, tiles[SPOT_SWORD], 320 - 8, SCREEN_H - pos);
	
	y = SCREEN_H + 3 * FPS - pos;
	
	textprintf_centre (page, font, 320, y += FPS / 2, c, "presented by");
	textprintf_centre (page, font, 320, y += FPS / 2, c, "Paul Pridham");
	textprintf_centre (page, font, 320, y += FPS / 2, c, "and");
	textprintf_centre (page, font, 320, y += FPS / 2, c, "Elias Pschernig");
	
	textprintf_centre (page, font, 320, SCREEN_H + 7 * FPS - pos,
		makecol (255, 255, 255), "Starring");
	
	for (i = 1; i <= 20; i++)
	{
		y = SCREEN_H + (8 + i) * FPS - pos;
		draw_sprite (page, anims[i], 160, y);
		textprintf (page, font, 320, y, makecol (255, 255, 255), "%s", char_names[i]);
		textprintf (page, font, 480, y, makecol (255, 0, 0), "%i slain", list[1].slain_foes[i]);
	}
	
	y = SCREEN_H + (8 + 25) * FPS - pos;
	draw_sprite (page, anims[0], 320 - sprite_w / 2, y);
	
	if (monsters > 86)
		textprintf_centre (page, font, 320, SCREEN_H / 2, c, "The End");
	
	blit (page, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

void
scroller_exit (void)
{
	scroller_active = 0;
}
