#include "main.h"
#include "char.h"

#define TOP 90

#define MAP_W 40
#define MAP_H 25

typedef enum SPOT SPOT;

enum SPOT
{
	SPOT_VOID = 0,
	SPOT_FLOOR,
	SPOT_WALL,
	SPOT_UP,
	SPOT_DOWN,
	SPOT_TEMPLE,
	SPOT_GOLD,
	SPOT_PIT,
	SPOT_ROPE,
	SPOT_BEACON,
	SPOT_TREASURE,
	SPOT_CEILING,
	SPOT_SWORD,
	SPOT_STASH,
	SPOT_MARKER = 256
};


extern int tw, th;
extern int swordlev;

extern int spawnpoints;
extern int spawnx[5];
extern int spawny[5];

extern int temple_x;
extern int temple_y;

void map_put_spot (int x, int y, SPOT s);
void map_put_char (int x, int y, int id);
void map_put_info (int x, int y, int info);

SPOT map_get_spot (int x, int y);
int map_get_char (int x, int y);
int map_get_info (int x, int y);

void map_enter (SPOT what, int whereto);
void map_draw (void);
void map_init (void);

void map_seen (int x, int y, int r);
void map_hide_completely (void);

void map_crash (void);

void DR_add (int l, int t, int r, int b);
void map_blit_DRs (void);
int map_check_DRs (int l, int t, int r, int b);
extern int DR_n;

void map_load (PACKFILE *file);
void map_save (PACKFILE *file);
