/*
	TODO:
	
	+ Fargoal map algorithm: 
		+ 10 random rooms, 10 corridors up to length of 12 
		for each turn, for each room, and each corridor stops once it's hit a 
		second space. Corridor turns are triggered either randomly or at the 
		map boundary. 
		* Note: It's possible to get stuck on a Fargoal map, if the map has
		unconnected sections and you either begin the game in a section with 
		no down stairs, or you teleport into a section with no down or up 
		stairs and can't teleport back out
	
	+ Random gold and items
		30 r=5:d=6:c=47:gosub210:r=l:d=3:c=0:gosub210
		210 x=int(r*rnd(1)+d):fori=1tox:gosub144:poken,c:next:return

*/
#include "map.h"
#include "game.h"
#include "gfx.h"

/* Tile dimensions. */
int tw = 16, th = 12;

/* We are wasting memory and everything could be stuffed into a single byte? Who cares. */
static SPOT spots[MAP_H][MAP_W];
static int chars[MAP_H][MAP_W];
static int seen[MAP_H][MAP_W];
static int info[MAP_H][MAP_W];	// e.g. amount of gold, trap depth

int spawnpoints;
int spawnx[5];
int spawny[5];

int temple_x;
int temple_y;

int swordlev;

/* Simple minded dirty rectangles system. */
int DR_n = 0;
int DR_l[100];
int DR_t[100];
int DR_r[100];
int DR_b[100];

void
map_put_spot (int x, int y, SPOT s)
{
	spots[y][x] = s;
	DR_add (x, y - 1, x, y);
}


static void
map_put_random_stuff(SPOT s, int inf, int *rx, int *ry)
{
	int x, y;

	do
	{
		x = rnd (1, MAP_W - 2);
		y = rnd (1, MAP_H - 2);
	}while (spots[y][x] != SPOT_FLOOR);

	spots[y][x] = s;
	map_put_info (x, y, inf);
	
	if (rx)
		*rx = x;
	if (ry)
		*ry = y;
}


void
map_put_char (int x, int y, int id)
{
	int overlap;
	overlap = (sprite_h + th - 1) / th - 1;
	chars[y][x] = id;
	DR_add (x - 1, y - overlap, x + 1, y);
}

void
map_put_info (int x, int y, int inf)
{
	info[y][x] = inf;
}

SPOT
map_get_spot (int x, int y)
{
	return spots[y][x];
}

int
map_get_char (int x, int y)
{
	return chars[y][x];
}

int
map_get_info (int x, int y)
{
	return info[y][x];
}

void
map_init (void)
{
}

static void
_room (int x1, int y1, int x2, int y2, int what)
{
	int x, y;

	for (y = y1; y <= y2; y++)
	{
		for (x = x1; x <= x2; x++)
		{
			if (x > 0 && y > 0 && x < MAP_W - 1 && y < MAP_H - 1)
				spots[y][x] = what;
		}
	}
}

static void
_attach (int x1, int y1, int x2, int y2, SPOT what, int *ax, int *ay)
{
	int x = x1;
	int y = y1;

	while ((x != x2 || y != y2) && spots[y][x] != what)
	{
		int dx = 0, dy = 0;

		if (x < x2)
			dx = 1;
		if (x > x2)
			dx = -1;
		if (y < y2)
			dy = 1;
		if (y > y2)
			dy = -1;
		if (dx && dy)
		{
			int f = rnd (0, 1);

			if (f)
				dx = 0;
			else
				dy = 0;
		}
		x += dx;
		y += dy;
	}
	*ax = x;
	*ay = y;
}

static void
_path (int x1, int y1, int x2, int y2, SPOT what)
{
	int x = x1;
	int y = y1;

	while (x != x2 || y != y2)
	{
		int i;
		int l = rnd (1, 4);
		int dx = 0, dy = 0;

		if (x < x2)
			dx = 1;
		if (x > x2)
			dx = -1;
		if (y < y2)
			dy = 1;
		if (y > y2)
			dy = -1;
		if (dx && dy)
		{
			int f = rnd (0, 1);

			if (f)
				dx = 0;
			else
				dy = 0;
		}
		for (i = 0; i < l; i++)
		{
			spots[y][x] = what;
			x += dx;
			y += dy;
			if (x == x2 && y == y2)
				break;
			if (!(x > 0 && y > 0 && x < MAP_W - 1 && y < MAP_H - 1))
			{
				x -= dx;
				y -= dy;
				break;
			}
		}
	}
	spots[y][x] = what;
}

static void
_corridor (int x, int y, SPOT where, SPOT what, int *ex, int *ey)
{
	int d, dx = 0, dy = 0;
	static int ddx[] = { 0, 1, 0, -1 };
	static int ddy[] = { 1, 0, -1, 0 };
	int l = rnd (10, 70);
	int i;
	int s = 0;

	for (i = 0; i < l; i++)
	{
		if (s)
			s--;
		else
		{
			d = rnd (0, 3);
			dx = ddx[d];
			dy = ddy[d];
			s = rnd (2, 8);
		}

		spots[y][x] = what;

		x += dx;
		y += dy;

		if (x > 0 && y > 0 && x < MAP_W - 1 && y < MAP_H - 1 && spots[y + dy][x + dx] == where && spots[y + dy + dx][x + dx + dy] == where && spots[y + dy - dx][x + dx - dy] == where && spots[y + dx][x + dy] == where && spots[y - dx][x - dy] == where)
		{

		}
		else
		{
			x -= dx;
			y -= dy;
			s = 0;
		}
	}
	*ex = x;
	*ey = y;
}

static void
map_wide (void)
{
	int sx[15], sy[15];
	int l = 2, t = 2, mx = MAP_W / 2, my = MAP_H / 2, r = MAP_W - 3, b = MAP_H - 3;
	int i;
	int n, m;
	int x, y;

	/* Random room positions. */
	sx[0] = rnd (l, r);
	sy[0] = rnd (t, b);

	sx[1] = rnd (l, mx);
	sy[1] = rnd (t, my);

	sx[2] = rnd (mx, r);
	sy[2] = rnd (t, my);

	sx[3] = rnd (l, mx);
	sy[3] = rnd (my, b);

	sx[4] = rnd (mx, r);
	sy[4] = rnd (my, b);

	n = rnd (2, 7);

	for (i = 5; i < n; i++)
	{
		sx[i] = rnd (l, r);
		sy[i] = rnd (t, b);
	}

	/* Place rooms. */
	for (i = 0; i < n; i++)
	{
		_room (sx[i] - rnd (1, 4), sy[i] - rnd (1, 4), sx[i] + rnd (1, 4), sy[i] + rnd (1, 4), SPOT_FLOOR);
	}

	/* Connect rooms. */
	for (i = 0; i < n; i++)
	{
		int j = i < n - 1 ? i + 1 : 0;
		int ax, ay;
		int ax2, ay2;

		_attach (sx[i], sy[i], sx[j], sy[j], SPOT_WALL, &ax, &ay);
		spots[ay][ax] = SPOT_UP;
		_attach (sx[j], sy[j], sx[i], sy[i], SPOT_WALL, &ax2, &ay2);
		spots[ay2][ax2] = SPOT_DOWN;
		_path (ax, ay, ax2, ay2, SPOT_FLOOR);
	}

	
	/* Some random corridors*/
	m = rnd (2, 7);
	for (i = 0; i < m; i++)
	{
		int ex, ey;
		int f = rnd (0, 3);

		do
		{
			x = rnd (1, MAP_W - 2);
			y = rnd (4, MAP_H - 2);
		}
		while (spots[y][x] != SPOT_WALL);

		switch (f)
		{

			case 0:
				y = MAP_H - 2;
				break;
			case 1:
				x = 1;
				break;
			case 2:
				y = 4;
				break;
			case 3:
				x = MAP_W - 2;
				break;
		}
		_corridor (x, y, SPOT_WALL, SPOT_FLOOR, &ex, &ey);
		{
			/* Avoid dead ends */
			int j;
			j = rnd (0, n - 1);
			_path (ex, ey, sx[j], sy[j], SPOT_FLOOR);
			j = rnd (0, n - 1);
			_path (x, y, sx[j], sy[j], SPOT_FLOOR);
		}
	}
}

/*
	Algorithm:

	Rooms:
		- Each room is ranges from 3 to 7 tiles wide and the same range for
		height
		- x position is between dungeon right wall - room width, and the left 
		wall
		- y position is between bottom dungeon wall - room height, and the top 
		wall
		- A position is stored for each room which is the center of the room

	Corridors:
		- 10 corridors with random turning stretches of lengths between 4 to 12
		and each is spawned in the center of a room
		- During the run, a corridor stops once it's hit a second space. 
		Corridor turns are triggered either randomly or at the map boundary
		- When a corridor picks a direction to turn, it can't go back the way
		it came
*/
static void map_fargoal(void)
{
	int i;

	struct
	{
		int x, y;
	}room_center[10];

	struct
	{
		int x, y;
	}dirs[]={
		{1, 0},		// right
		{0, 1},		// down
		{0, -1},	// up
		{-1, 0}		// left
	};

	// Rooms
	for(i=0; i<10; i++)
	{
		int w, h, x, y;


		w=rnd(3, 7);
		h=rnd(3, 7);

		x=rnd(1, MAP_W-2-w);
		y=rnd(1, MAP_H-2-h);

		room_center[i].x=x+w/2;
		room_center[i].y=y+h/2;

		_room(x, y, x+w, y+h, SPOT_FLOOR);
	}

	// Corridors

	/*
	15 fori=1to10
	16 n=r(i):z=int(4*rnd(1)+1):goto19
	*/
	for(i=0; i<10; i++)
	{
		int stone=1; // 1 for initial, 2 for has hit stone, 0 for hit floor
		int x=room_center[i].x;
		int y=room_center[i].y;
		int run, j=0;
		
		int dir, last=-1, skip=TRUE;

		dir=rnd(0,3); 

		/*
			17 ifj>1thenv=z
			18 z=int(4*rnd(1)+1):ifz=v(v)then18
			19 f=1:y1=int(9*rnd(1)+5):j=1
		*/		
		while(stone)
		{
			// 17
			if(!skip)
			{
				if(j>1)
					last=dir;

				do 
					dir=rnd(0,3); 
				while(dir==3-last);
			}
			else
			{
				skip=FALSE;
			}

			// 19
			stone=1;
			run=rnd(0, 8)+5;
			j=1;

			do
			{
				int m_x, m_y;

				// 20 m=n+d(z):p=peek(m):ifp=36thenf=2
				m_x=x+dirs[dir].x;
				m_y=y+dirs[dir].y;

				if(spots[m_y][m_x]!=SPOT_FLOOR)
					stone=2;
				
				/*
				21 ifm<7104orm>7983then17
				22 gosub137:ifx<1orx>38then17
				*/
				if(m_x<1||m_x>MAP_W-2||m_y<1||m_y>MAP_H-2)
				{
					// We're on the edge
					break;
				}
				
				// 23 iff=2andp=32then26
				// If we hit a space after hitting stone
				if(stone==2 && spots[m_y][m_x]==SPOT_FLOOR)
				{
					stone=0;
					break;
				}

				/*
				24 pokem,c:n=m:j=j+1:ifj=y1then17
				25 goto20
				*/
				spots[m_y][m_x]=SPOT_FLOOR;
				
				x=m_x;
				y=m_y;

				j++;
			}while(j!=run);
		}
	
	// 26 next
	}
}

static void
map_sword (void)
{
	int x, y;
	int x2, y2;
	int dir, last;
	struct
	{
		int x, y;
	} dirs[] = {
		{1, 0},
		{0, -1},
		{-1, 0},
		{0, 1}
	};
	//  469 fori=0to24:poke7063+i*40,32:next:fori=7984to8023:pokei,32:next:gosub132
	for (y = 0; y < 25; y++)
		map_put_spot (39, y, SPOT_FLOOR);
	for (x = 0; x < 40; x++)
		map_put_spot (x, 24, SPOT_FLOOR);
	
	//	468 c=36:d=32:n=7105:poken,4:poke251,17:poke252,29:poke3650,5:poke3651,5:sys3616
	x = 1;
	y = 2;
	_room(17, 10, 21, 14, SPOT_FLOOR);
	map_put_spot (x, y, SPOT_MARKER + 4);
	
	while (1)
	{
		while (1)
		{
			//  470 j=int(4*rnd(1)):x=j
			dir = rnd (0, 3);
			last = dir;
			while (1)
			{
				//  471 b=n+c(j):ifpeek(b)=cthenpokeb,j:poken+c(j)/2,d:n=b:goto470
				x2 = x + dirs[dir].x * 2;
				y2 = y + dirs[dir].y * 2;
												
				if (x2 > 0 && y2 > 0 && x2 < MAP_W - 1 && y2 < MAP_H - 1 &&
					map_get_spot (x2, y2) == SPOT_WALL)
				{
					map_put_spot (x2, y2, SPOT_MARKER + dir);
					map_put_spot (x + dirs[dir].x, y + dirs[dir].y, SPOT_FLOOR);
					x = x2;
					y = y2;
					break;
				}
			
				//  472 j=(j+1)*-(j<3):ifj<>xthen471
				dir++;
				if (dir == 4)
					dir = 0;
				if (dir == last)
					goto breakbreak;
			}
		}
	breakbreak:
		//  473 j=peek(n):poken,d:ifj<4thenn=n-c(j):goto470
		dir = map_get_spot (x, y);
		map_put_spot (x, y, SPOT_FLOOR);
		if (dir >= SPOT_MARKER && dir <= SPOT_MARKER + 3)
		{
			dir -= SPOT_MARKER;
			x -= dirs[dir].x * 2;
			y -= dirs[dir].y * 2;
		}
		else
			break;
	}
	//  474 x=int(4*rnd(1)):pokeh(x),0:ifsf=0thenpoke7523,37
	dir = rnd (0, 3);
	switch (dir)
	{
		case 0: map_put_spot (16, 12, SPOT_TREASURE); break;
		case 1: map_put_spot (22, 12, SPOT_TREASURE); break;
		case 2: map_put_spot (19, 9, SPOT_TREASURE); break;
		case 3: map_put_spot (19, 15, SPOT_TREASURE); break;
	}
	if (!list[1].sword)
		map_put_spot (19, 12, SPOT_SWORD);
	//  475 fori=1to24:poke7063+i*40,36:next:fori=7984to8023:pokei,36:next:goto28
	for (y = 0; y < 25; y++)
		map_put_spot (39, y, SPOT_WALL);
	for (x = 0; x < 40; x++)
		map_put_spot (x, 24, SPOT_WALL);
	
}

static int floodmap[MAP_H][MAP_W];
static int
do_flood (int x, int y)
{
	if (x > 0 && y > 0 && x < MAP_W - 1 && y < MAP_H - 1 &&
		!floodmap[y][x] && map_get_spot (x, y) != SPOT_WALL)
	{
		int i, j;
		SPOT s = map_get_spot (x, y);
		if (s == SPOT_UP || s == SPOT_DOWN || s == SPOT_PIT || s == SPOT_ROPE)
			return 1;
		floodmap[y][x] = 1;
		for (i = -1; i <= 1; i++)
			for (j = -1; j <= 1; j++)
			{
				if (do_flood (x + i, y + j))
					return 1;
			}
		
	}
	return 0;
}

static int
flood (int x, int y)
{
	memset (&floodmap, 0, sizeof floodmap);
	return do_flood (x, y);
}


void
map_enter (SPOT what, int howfar)
{
	int i, x, y, lev;
	int n, m;
again:
	lev = list[1].current_level;
	char_num = 2;

	if (lev > list[1].deepest_level)
		list[1].deepest_level = lev;

	{
		for (i = 0; i < 6; i++)
		{
			list[1].spells[i].active = 0;
		}
	}
	list[1].beaconx = 0;
	list[1].beacony = 0;

	spawnpoints = 0;

	for (y = 0; y < MAP_H; y++)
	{
		for (x = 0; x < MAP_W; x++)
		{
			spots[y][x] = SPOT_WALL;
			chars[y][x] = 0;
			seen[y][x] = (list[1].map & (1 << lev)) ? 1 : 0;
			info[y][x] = 0;
		}
	}

	/* maps 5, 10, 15, 20.. use our special map. */
	if (lev == swordlev)
	{
		map_sword ();
	}
	else if (!extensions_dungeons || (lev % 5))
	{
		map_fargoal();
	}
	else
	{
		map_wide ();
	}

	/* The hero. */
	//   37 gosub144:sys3596:sys3392:poken,k:o=n-d%:pokeo,a:gosub138:pokev3,1:gosub146
	map_put_random_stuff (what, howfar, &x, &y);
	list[1].x=x;
	list[1].y=y;
	chars[y][x] = 1;
	
	/* Temple. */
	//    28 gosub144:poken,38:b3=n-d%
	map_put_random_stuff (SPOT_TEMPLE, 0, &temple_x, &temple_y);
	
	/* Stairs down. */
	//    29 u%=int(2*rnd(1)+2):fori=1tou%:gosub144:poken,35:v%(i)=n:next
	n = rnd (2, 3);
	for (i = 0; i <= n; i++)
		map_put_random_stuff (SPOT_DOWN, 0, &spawnx[i], &spawny[i]);
	spawnpoints = n;
		
	/* Some random gold and treasures. */
	//	30 r=5:d=6:c=47:gosub210:r=l:d=3:c=0:gosub210
	//  210 x=int(r*rnd(1)+d):fori=1tox:gosub144:poken,c:next:return
	n = rnd (0, 4) + 6;	
	for(i = 0; i <= n; i++)
		map_put_random_stuff (SPOT_GOLD, 0, NULL, NULL);

	n = MIN (25, rnd (0, lev - 1) + 3);
	for(i = 0; i<= n; i++)
		map_put_random_stuff (SPOT_TREASURE, 0, NULL, NULL);

	monster_init();
	
	/* Human monsters. */
	//   31 a%=int(3*rnd(1)):forj=0toa%:gosub144:n%(j)=n:q%(j)=32:gosub320:poken,b(j):d%(j)=1
   	//   32 sn=j+1:gosub140:poke2041+j,x2+32:poke53288+j,o%(x2):next
	/* At least one and at most 3 human monsters. 
	   Note how monster_strength from the previous level is re-used!
	 */
	n = rnd (0, 2);
	for (i = 0; i <= n; i++)
	{
		map_put_random_stuff (SPOT_VOID, 0, &x, &y);
		chars[y][x] = monster_create (2, monster_strength, x, y);
	}
	
	monster_strength = lev;
	
	/* Creature monsters. */
	//   33 b%=int(3*rnd(1)+1):v%=a%+b%:ifv%>5thenb%=5-a%
	//   34 l%=l:v%=l:forj=0tob%:gosub144:m%(j)=n:p%(j)=32:gosub310:poken,a(j)
   	//   35 sn=j+a%+2:gosub140:poke2042+a%+j,x2+32:poke53289+a%+j,o%(x2):next
	/* At least 2 and at most 4 human monsters. */
	m = rnd (1, 3);
	/* The line below makes no sense at all ??? */
	if (m + n > 5)
		m = 5 - n;

	for (i = 0; i <= m; i++)
	{
		map_put_random_stuff (SPOT_VOID, 0, &x, &y);
		chars[y][x] = monster_create (1, monster_strength, x, y);
	}
	
	/* Up stairs. */
	//   36 v%(0)=0:ifl>1orsf=1thengosub144:poken,34:v%(0)=n
	if (lev > 1 || list[1].sword)
	{
		map_put_random_stuff (SPOT_UP, 0,
			&spawnx[spawnpoints], &spawny[spawnpoints]);
		spawnpoints++;
	}
	
	
	monster_max = monster_count ();
	
	/* Clean up markers. */
	for (y = 0; y < MAP_H; y++)
	{
		for (x = 0; x < MAP_W; x++)
		{
			if (map_get_spot (x, y) == SPOT_VOID)
			{
				map_put_spot (x, y, SPOT_FLOOR);
			}
		}
	}

	map_seen (list[1].x, list[1].y, 1);

	message (FPS * 2, NULL, "Entering level %i.", list[1].current_level);
	
	if (list[1].map & (1 << lev))
	{
		//  131 t%(i1)=0:gosub113:print"(home)treasure map!!":gosub423:pokev3,255:pokeo+d%,k:i1=tm:goto39
		list[1].map &= ~(1 << lev);
		message (0, NULL, "Treasure map!!");
	}

	DR_n = 0;
	/* redraw 6 rows above as well.. */
	DR_add (0, -6, MAP_W - 1, MAP_H - 1);
	
	global_steps = MAX (1, 20 - list[1].current_level); /* Make monsters wait a moment. */
	
	if (extensions_dungeons)
	{
		for (y = 0; y < MAP_H; y++)
		{
			for (x = 0; x < MAP_W; x++)
			{
				if (map_get_spot (x, y) != SPOT_WALL && !flood (x, y))
				{
					message (0, NULL, "The goddess of luck intervenes!!");
					goto again;
				}
			}
		}
	}
	
}

void
map_seen (int x, int y, int rad)
{
	int i, j;
	int overlap;
	int t = y - rad;
	int l = x - rad;
	int r = x + rad;
	int b = y + rad;
	int foundc = 0;

	if (l < 0)
		l = 0;
	if (r > MAP_W - 1)
		r = MAP_W - 1;
	if (b > MAP_H - 1)
		b = MAP_H - 1;
	for (i = MAX (0, t); i <= b; i++)
	{
		for (j = l; j <= r; j++)
		{
			seen[i][j] = 1;
			if (chars[i][j])
				foundc = 1;
		}
	}
	/* A character might get visible, then everything occluded by it has to
	 * be redrawn. */
	if (foundc)
	{
		overlap = (sprite_h + th - 1) / th - 1;
		DR_add (l - 1, t - overlap, r + 1, b);
	}
	else
	{
		DR_add (l, t - 1, r, b);
	}
}

void
map_hide_completely (void)
{
	memset (seen, 0, sizeof seen);
	DR_add (0, -1, MAP_W - 1, MAP_H - 1);
	
	map_seen(list[1].x, list[1].y, 1);
}


void map_crash (void)
{
	int i, type;
	int x, y;

	for(i=0; i<1000; i++)
	{
		x=rnd(0, MAP_W-1);
		y=rnd(0, MAP_H-1);

		type=rnd(0, 6);

		if(type<2)
		{
			spots[y][x]=SPOT_WALL;
		}
		else if(type<4)
		{
			spots[y][x]=SPOT_FLOOR;
		}
		else if(type<5)
		{
			spots[y][x]=SPOT_CEILING;
		}
		else
		{
			spots[y][x]=SPOT_PIT;
		}
	}
}


void
DR_add (int l, int t, int r, int b)
{
	int i = DR_n;

	if (l < 0)
		l = 0;
	if (r > MAP_W - 1)
		r = MAP_W - 1;
	if (b > MAP_H - 1)
		b = MAP_H - 1;
	DR_l[i] = l;
	DR_t[i] = t;
	DR_r[i] = r;
	DR_b[i] = b;
	DR_n++;
	if (DR_n == 100)
	{
		DR_l[i] = 0;
		DR_t[i] = -6;
		DR_r[i] = MAP_W - 1;
		DR_b[i] = MAP_H - 1;
		DR_n = 1;
	}
}

static void
_char_draw (int x, int y)
{
	int id = chars[y][x];
	if (id)
	{
		TYPE type = list[id].type;
		
		if (!extensions_overlapfight && list[id].fighting)
		{
			int e = list[id].fighting;
			int back, front;
			float back_step, front_step;

			if (list[id].attacked)
			{
				back = id;
				front = e;
			}
			else
			{
				back = e;
				front = id;
			}
				
			back_step=(float)list[back].step/(extensions_speed?1:2);
			front_step=(float)list[front].step/(extensions_speed?1:2);


			draw_sprite (page, anims[list[back].type],
				x * tw + tw / 2 - sprite_w / 2 - list[back].dx * back_step,
				TOP + y * th + th - sprite_h - list[back].dy * back_step * 3 / 4);
			draw_sprite (page, anims[list[front].type],
				x * tw + tw / 2 - sprite_w / 2 - list[front].dx * front_step,
				TOP + y * th + th - sprite_h - list[front].dy * front_step * 3 / 4);
		}
		else
		if (type != CHAR_ASSASSIN || !list[id].spells[SPELL_INVISIBILITY].active)
		{
			float st;

			st=(float)list[id].step/(extensions_speed?1:2);

			draw_sprite (page, anims[type],
				x * tw + tw / 2 - sprite_w / 2 - list[id].dx * st,
				TOP + y * th + th - sprite_h - list[id].dy * st * 3 / 4);
		}
	}
}

/**
 * Redraws the map tiles in the given region.
 * o Also possibly overlapping wall tiles from one position below b have
 *   to be checked.
 * o For characters, positions 2 more to the left and right, 1 more to the top,
 *   and 4 more to the bottom have to be checked, because they might overlap
 *   with the specified region and would get overdrawn otherwise.
 * o Finally, floor tiles can be overlapping in the current code as well, so
 *   there we need to check for overlap from 1 tile below now.
 *
 * How does it work? It's quite simple.
 *
 * We have 3 things to draw:
 *
 * 1. Tiles (Floor)
 * 2. Objects (Walls/Items)
 * 3. Entities (Characters/Sprites)
 *
 * Right now, to make it easy for artists, the first 2 are contained in the
 * same tilesheet, and we treat everything as object, but fill the complete
 * map with SPOT_FLOOR before drawing.
 *
 * This is interleaved with an objects layer, which consists of SPOT_DOWN,
 * SPOT_PIT and SPOT_TEMPLE, as they most notably contain floor in the main
 * theme graphics. This wouldn't be needed with a separation of tiles and
 * objects.
 *
 * Next comes the objects interleaved with entities. Here we draw all the
 * objects except the above 3, and the entities.
 *
 */
static void
DR_map_draw (int l, int t, int r, int b)
{
	int x, y;
	int overlap;
	
	/* Draws the area above the map. Still a relict from the time when
	 * the map was as big as the screen, and now useful because characters
	 * and walls overlap with this area.
	 */
	if (t < 0)
	{
		int b_ = MIN (-1, b);
		blit (title, page, l * tw, TOP + t * th, l * tw, TOP + t * th,
			(1 + r - l) * tw, (1 + b_ - t) * th);
		t = 0;
	}
		
	/* Draws floor layer, considering overlap from the 3 special tiles. */
	b = MIN (b + 1, MAP_H - 1);
	for (y = t; y <= b; y++)
	{
		for (x = l; x <= r; x++)
		{
			if (seen[y][x])
			{
				SPOT s = spots[y][x];
				blit (tiles[SPOT_FLOOR], page, 0, th, x * tw, TOP + y * th, tw, th);
				
				if (tileset == 2 || s == SPOT_DOWN || s ==SPOT_PIT || s == SPOT_TEMPLE || s == SPOT_STASH)
					draw_sprite (page, tiles[s], x * tw, TOP + y * th - th);
			}
			else
			{
				blit (tiles[SPOT_VOID], page, 0, th, x * tw, TOP + y * th, tw, th);
			}
		}
	}
	
	/* Draw walls/objects/entities layer.
	 * Walls can be overlapping in from the tile 1 more down.
	 * Entities can overlap from tiles below, 2 to the left or right,
	 * or 1 from the top.
	 */
	overlap = (sprite_h + th - 1) / th - 1;
	b = MIN (b + overlap, MAP_H - 1); /* +1 already above */
	l = MAX (l - 2, 0);
	r = MIN (r + 2, MAP_W - 1);
	t = MAX (t - 1, 0);
	for (y = t; y <= b; y++)
	{
		for (x = l; x <= r; x++)
		{
			if (seen[y][x])
			{
				int ch = chars[y][x];
				if (list[ch].step && list[ch].dy == 1)
					_char_draw (x, y);
			}
		}
		for (x = l; x <= r; x++)
		{
			if (seen[y][x])
			{
				SPOT s = spots[y][x];
				if (s > 1)
				{
					if (tileset != 2 && s != SPOT_DOWN && s != SPOT_PIT && s != SPOT_TEMPLE && s != SPOT_STASH)
						draw_sprite (page, tiles[s], x * tw, TOP + y * th - th);
					else
						masked_blit (tiles[s], page, 0, 0, x * tw, TOP + y * th - th, tw, th);
				}
			}
			else
			{
				draw_sprite (page, tiles[SPOT_VOID], x * tw, TOP + y * th - th);
			}
		}
		for (x = l; x <= r; x++)
		{
			if (seen[y][x])
			{
				int ch = chars[y][x];
				if (!list[ch].step || list[ch].dy != 1)
					_char_draw (x, y);
			}
		}
	}
}

void
map_draw (void)
{
	int i;
	for (i = 0; i < DR_n; i++)
	{
		set_clip (page, DR_l[i] * tw, TOP + DR_t[i] * th, (DR_r[i] + 1) * tw - 1, TOP + (DR_b[i] + 1) * th - 1);
		DR_map_draw (DR_l[i], DR_t[i], DR_r[i], DR_b[i]);
	}
	set_clip (page, 0, 0, page->w, page->h);
}

void
map_blit_DRs (void)
{
	int i;

	for (i = 0; i < DR_n; i++)
	{
		blit (page, screen, DR_l[i] * tw, TOP + DR_t[i] * th, DR_l[i] * tw, TOP + DR_t[i] * th, (1 + DR_r[i] - DR_l[i]) * tw, (1 + DR_b[i] - DR_t[i]) * th);
	}

	DR_n = 0;
}

/**
 * Check if any DR overlaps the given region.
 */
int
map_check_DRs (int l, int t, int r, int b)
{
	int i;

	for (i = 0; i < DR_n; i++)
	{
		if (DR_l[i] <= r && DR_r[i] >= l && DR_t[i] <= b && DR_b[i] >= t)
		{
			return 1;
		}
	}
	return 0;
}

void
map_save (PACKFILE *file)
{
	int x, y;
	
	for (y = 0; y < MAP_H; y++)
	{
		for (x = 0; x < MAP_W; x++)
		{
			pack_iputl (spots[y][x], file);
			pack_iputl (chars[y][x], file);
			pack_iputl (seen[y][x], file);
			pack_iputl (info[y][x], file);
		}
	}
}


void
map_load (PACKFILE *file)
{
	int x, y;
	
	for (y = 0; y < MAP_H; y++)
	{
		for (x = 0; x < MAP_W; x++)
		{
			spots[y][x] = pack_igetl (file);
			chars[y][x] = pack_igetl (file);
			seen[y][x] = pack_igetl (file);
			info[y][x] = pack_igetl (file);
		}
	}
}
