Docs.data = {"guides":[{"items":[{"name":"getting_started","title":"Getting Started with Ext JS 4","description":"This introduction to Ext JS 4 explains how you can get started with creating your first application."},{"name":"upgrade","title":"Upgrade Guide","description":"Learn what's new in Ext JS 4.0 and how to upgrade your existing applications"}],"title":"Overview"},{"items":[{"name":"class_system","title":"The Class System","description":"This manual is intended for any developer who wants to create new or extend existing classes with the new class system in Ext JS 4.x."},{"name":"application_architecture","title":"MVC Application Architecture","description":"Ext JS 4 comes with a new application architecture that not only organizes your code but reduces the amount you have to write."},{"name":"layouts_and_containers","title":"Layouts and Containers","description":"The layout system handles the sizing and positioning of every component in your application."},{"name":"components","title":"Components","description":"A simple example, and videos, about how to create components in Ext JS."},{"name":"data","title":"The Data Package","description":"The data package is what loads and saves all of the data in your application."},{"name":"drag_and_drop","title":"Drag and Drop","description":"This guide explains how to use the drag and drop system."},{"name":"localization","title":"Localization","description":"This guide explains how to localize your application for multiple languages."},{"name":"keyboard_nav","title":"Keyboard Navigation","description":"This guide explains how to use the keyboard navigation system."}],"title":"Concepts"},{"items":[{"name":"grid","title":"The Grid Component","description":"The grid provides a great way to view lots of data at once, formatted exactly how you need it."},{"name":"tree","title":"Trees","description":"Tree and grid now both extend from the same base class. All of the benefits of grid can now be used on trees."},{"name":"drawing_and_charting","title":"Drawing and Charting","description":"The drawing and charting packages enable you to create cross browser and cross device graphics in a versatile way."},{"name":"forms","title":"The Form Package","description":"The Form package enables you to create powerful forms backed with the Ext Data package"},{"name":"theming","title":"Theming","description":"This guide explains how to use the theming system to customize the look and feel of your application."}],"title":"Components"},{"items":[{"name":"mvc_pt1","title":"App Architecture Part 1","description":"Part 1 of a 4 part series explaining how to use Ext JS 4's Application Architecture. This part is all about planning your app"},{"name":"mvc_pt2","title":"App Architecture Part 2","description":"In this article we start creating our Models, Views, Controllers and Stores"},{"name":"mvc_pt3","title":"App Architecture Part 3","description":"In this part of the series, we will continue implementing controller logic inside of the application’s MVC architecture."},{"name":"direct_grid_pt1","title":"Ext Direct and Grid Part 1","description":"How to link an Ext Grid to a PHP / MySQL backend with Ext Direct"},{"name":"direct_grid_pt2","title":"Ext Direct and Grid Part 2","description":"Adding CRUD operations to the Ext Grid using Ext Direct"},{"name":"editable_grid","title":"Editable Grid + Node.js","description":"Creating an Editable Grid backed with Node.js and MongoDB"}],"title":"Tutorials"}],"search":[{"type":"cls","member":"Array","cls":"Array","xtypes":{}},{"type":"property","member":"length","id":"property-length","cls":"Array"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Array"},{"type":"method","member":"concat","id":"method-concat","cls":"Array"},{"type":"method","member":"join","id":"method-join","cls":"Array"},{"type":"method","member":"pop","id":"method-pop","cls":"Array"},{"type":"method","member":"push","id":"method-push","cls":"Array"},{"type":"method","member":"reverse","id":"method-reverse","cls":"Array"},{"type":"method","member":"shift","id":"method-shift","cls":"Array"},{"type":"method","member":"slice","id":"method-slice","cls":"Array"},{"type":"method","member":"sort","id":"method-sort","cls":"Array"},{"type":"method","member":"splice","id":"method-splice","cls":"Array"},{"type":"method","member":"toString","id":"method-toString","cls":"Array"},{"type":"method","member":"unshift","id":"method-unshift","cls":"Array"},{"type":"cls","member":"Boolean","cls":"Boolean","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Boolean"},{"type":"method","member":"toString","id":"method-toString","cls":"Boolean"},{"type":"method","member":"valueOf","id":"method-valueOf","cls":"Boolean"},{"type":"cls","member":"Date","cls":"Date","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Date"},{"type":"method","member":"getDate","id":"method-getDate","cls":"Date"},{"type":"method","member":"getDay","id":"method-getDay","cls":"Date"},{"type":"method","member":"getFullYear","id":"method-getFullYear","cls":"Date"},{"type":"method","member":"getHours","id":"method-getHours","cls":"Date"},{"type":"method","member":"getMilliseconds","id":"method-getMilliseconds","cls":"Date"},{"type":"method","member":"getMinutes","id":"method-getMinutes","cls":"Date"},{"type":"method","member":"getMonth","id":"method-getMonth","cls":"Date"},{"type":"method","member":"getSeconds","id":"method-getSeconds","cls":"Date"},{"type":"method","member":"getTime","id":"method-getTime","cls":"Date"},{"type":"method","member":"getTimezoneOffset","id":"method-getTimezoneOffset","cls":"Date"},{"type":"method","member":"getUTCDate","id":"method-getUTCDate","cls":"Date"},{"type":"method","member":"getUTCDay","id":"method-getUTCDay","cls":"Date"},{"type":"method","member":"getUTCFullYear","id":"method-getUTCFullYear","cls":"Date"},{"type":"method","member":"getUTCHours","id":"method-getUTCHours","cls":"Date"},{"type":"method","member":"getUTCMilliseconds","id":"method-getUTCMilliseconds","cls":"Date"},{"type":"method","member":"getUTCMinutes","id":"method-getUTCMinutes","cls":"Date"},{"type":"method","member":"getUTCMonth","id":"method-getUTCMonth","cls":"Date"},{"type":"method","member":"getUTCSeconds","id":"method-getUTCSeconds","cls":"Date"},{"type":"method","member":"setDate","id":"method-setDate","cls":"Date"},{"type":"method","member":"setFullYear","id":"method-setFullYear","cls":"Date"},{"type":"method","member":"setHours","id":"method-setHours","cls":"Date"},{"type":"method","member":"setMilliseconds","id":"method-setMilliseconds","cls":"Date"},{"type":"method","member":"setMinutes","id":"method-setMinutes","cls":"Date"},{"type":"method","member":"setMonth","id":"method-setMonth","cls":"Date"},{"type":"method","member":"setSeconds","id":"method-setSeconds","cls":"Date"},{"type":"method","member":"setTime","id":"method-setTime","cls":"Date"},{"type":"method","member":"setUTCDate","id":"method-setUTCDate","cls":"Date"},{"type":"method","member":"setUTCFullYear","id":"method-setUTCFullYear","cls":"Date"},{"type":"method","member":"setUTCHours","id":"method-setUTCHours","cls":"Date"},{"type":"method","member":"setUTCMilliseconds","id":"method-setUTCMilliseconds","cls":"Date"},{"type":"method","member":"setUTCMinutes","id":"method-setUTCMinutes","cls":"Date"},{"type":"method","member":"setUTCMonth","id":"method-setUTCMonth","cls":"Date"},{"type":"method","member":"setUTCSeconds","id":"method-setUTCSeconds","cls":"Date"},{"type":"method","member":"toDateString","id":"method-toDateString","cls":"Date"},{"type":"method","member":"toLocaleDateString","id":"method-toLocaleDateString","cls":"Date"},{"type":"method","member":"toLocaleString","id":"method-toLocaleString","cls":"Date"},{"type":"method","member":"toLocaleTimeString","id":"method-toLocaleTimeString","cls":"Date"},{"type":"method","member":"toString","id":"method-toString","cls":"Date"},{"type":"method","member":"toTimeString","id":"method-toTimeString","cls":"Date"},{"type":"method","member":"toUTCString","id":"method-toUTCString","cls":"Date"},{"type":"method","member":"valueOf","id":"method-valueOf","cls":"Date"},{"type":"method","member":"UTC","id":"static-method-UTC","cls":"Date"},{"type":"method","member":"now","id":"static-method-now","cls":"Date"},{"type":"method","member":"parse","id":"static-method-parse","cls":"Date"},{"type":"cls","member":"Function","cls":"Function","xtypes":{}},{"type":"property","member":"length","id":"property-length","cls":"Function"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Function"},{"type":"method","member":"apply","id":"method-apply","cls":"Function"},{"type":"method","member":"call","id":"method-call","cls":"Function"},{"type":"method","member":"toString","id":"method-toString","cls":"Function"},{"type":"cls","member":"Number","cls":"Number","xtypes":{}},{"type":"property","member":"NEGATIVE_INFINITY","id":"property-NEGATIVE_INFINITY","cls":"Number"},{"type":"property","member":"POSITIVE_INFINITY","id":"property-POSITIVE_INFINITY","cls":"Number"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Number"},{"type":"method","member":"toExponential","id":"method-toExponential","cls":"Number"},{"type":"method","member":"toFixed","id":"method-toFixed","cls":"Number"},{"type":"method","member":"toLocaleString","id":"method-toLocaleString","cls":"Number"},{"type":"method","member":"toPrecision","id":"method-toPrecision","cls":"Number"},{"type":"method","member":"toString","id":"method-toString","cls":"Number"},{"type":"method","member":"valueOf","id":"method-valueOf","cls":"Number"},{"type":"property","member":"MAX_VALUE","id":"static-property-MAX_VALUE","cls":"Number"},{"type":"property","member":"MIN_VALUE","id":"static-property-MIN_VALUE","cls":"Number"},{"type":"property","member":"NaN","id":"static-property-NaN","cls":"Number"},{"type":"cls","member":"Object","cls":"Object","xtypes":{}},{"type":"property","member":"constructor","id":"property-constructor","cls":"Object"},{"type":"property","member":"prototype","id":"property-prototype","cls":"Object"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Object"},{"type":"method","member":"hasOwnProperty","id":"method-hasOwnProperty","cls":"Object"},{"type":"method","member":"isPrototypeOf","id":"method-isPrototypeOf","cls":"Object"},{"type":"method","member":"propertyIsEnumerable","id":"method-propertyIsEnumerable","cls":"Object"},{"type":"method","member":"toLocaleString","id":"method-toLocaleString","cls":"Object"},{"type":"method","member":"toString","id":"method-toString","cls":"Object"},{"type":"method","member":"valueOf","id":"method-valueOf","cls":"Object"},{"type":"cls","member":"RegExp","cls":"RegExp","xtypes":{}},{"type":"property","member":"global","id":"property-global","cls":"RegExp"},{"type":"property","member":"ignoreCase","id":"property-ignoreCase","cls":"RegExp"},{"type":"property","member":"lastIndex","id":"property-lastIndex","cls":"RegExp"},{"type":"property","member":"multiline","id":"property-multiline","cls":"RegExp"},{"type":"property","member":"source","id":"property-source","cls":"RegExp"},{"type":"method","member":"constructor","id":"method-constructor","cls":"RegExp"},{"type":"method","member":"exec","id":"method-exec","cls":"RegExp"},{"type":"method","member":"test","id":"method-test","cls":"RegExp"},{"type":"method","member":"toString","id":"method-toString","cls":"RegExp"},{"type":"cls","member":"String","cls":"String","xtypes":{}},{"type":"property","member":"length","id":"property-length","cls":"String"},{"type":"method","member":"constructor","id":"method-constructor","cls":"String"},{"type":"method","member":"charAt","id":"method-charAt","cls":"String"},{"type":"method","member":"charCodeAt","id":"method-charCodeAt","cls":"String"},{"type":"method","member":"concat","id":"method-concat","cls":"String"},{"type":"method","member":"fromCharCode","id":"method-fromCharCode","cls":"String"},{"type":"method","member":"indexOf","id":"method-indexOf","cls":"String"},{"type":"method","member":"lastIndexOf","id":"method-lastIndexOf","cls":"String"},{"type":"method","member":"localeCompare","id":"method-localeCompare","cls":"String"},{"type":"method","member":"match","id":"method-match","cls":"String"},{"type":"method","member":"replace","id":"method-replace","cls":"String"},{"type":"method","member":"search","id":"method-search","cls":"String"},{"type":"method","member":"slice","id":"method-slice","cls":"String"},{"type":"method","member":"split","id":"method-split","cls":"String"},{"type":"method","member":"substr","id":"method-substr","cls":"String"},{"type":"method","member":"substring","id":"method-substring","cls":"String"},{"type":"method","member":"toLocaleLowerCase","id":"method-toLocaleLowerCase","cls":"String"},{"type":"method","member":"toLocaleUpperCase","id":"method-toLocaleUpperCase","cls":"String"},{"type":"method","member":"toLowerCase","id":"method-toLowerCase","cls":"String"},{"type":"method","member":"toString","id":"method-toString","cls":"String"},{"type":"method","member":"toUpperCase","id":"method-toUpperCase","cls":"String"},{"type":"method","member":"valueOf","id":"method-valueOf","cls":"String"},{"type":"cls","member":"Action","cls":"Ext.Action","xtypes":{}},{"type":"cfg","member":"disabled","id":"cfg-disabled","cls":"Ext.Action"},{"type":"cfg","member":"handler","id":"cfg-handler","cls":"Ext.Action"},{"type":"cfg","member":"hidden","id":"cfg-hidden","cls":"Ext.Action"},{"type":"cfg","member":"iconCls","id":"cfg-iconCls","cls":"Ext.Action"},{"type":"cfg","member":"itemId","id":"cfg-itemId","cls":"Ext.Action"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.Action"},{"type":"cfg","member":"text","id":"cfg-text","cls":"Ext.Action"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.Action"},{"type":"method","member":"disable","id":"method-disable","cls":"Ext.Action"},{"type":"method","member":"each","id":"method-each","cls":"Ext.Action"},{"type":"method","member":"enable","id":"method-enable","cls":"Ext.Action"},{"type":"method","member":"execute","id":"method-execute","cls":"Ext.Action"},{"type":"method","member":"getIconCls","id":"method-getIconCls","cls":"Ext.Action"},{"type":"method","member":"getText","id":"method-getText","cls":"Ext.Action"},{"type":"method","member":"hide","id":"method-hide","cls":"Ext.Action"},{"type":"method","member":"isDisabled","id":"method-isDisabled","cls":"Ext.Action"},{"type":"method","member":"isHidden","id":"method-isHidden","cls":"Ext.Action"},{"type":"method","member":"setDisabled","id":"method-setDisabled","cls":"Ext.Action"},{"type":"method","member":"setHandler","id":"method-setHandler","cls":"Ext.Action"},{"type":"method","member":"setHidden","id":"method-setHidden","cls":"Ext.Action"},{"type":"method","member":"setIconCls","id":"method-setIconCls","cls":"Ext.Action"},{"type":"method","member":"setText","id":"method-setText","cls":"Ext.Action"},{"type":"method","member":"show","id":"method-show","cls":"Ext.Action"},{"type":"cls","member":"Button","cls":"Ext.button.Button","xtypes":{"widget":["button"]}},{"type":"property","member":"disabled","id":"property-disabled","cls":"Ext.button.Button"},{"type":"property","member":"hidden","id":"property-hidden","cls":"Ext.button.Button"},{"type":"property","member":"menu","id":"property-menu","cls":"Ext.button.Button"},{"type":"property","member":"pressed","id":"property-pressed","cls":"Ext.button.Button"},{"type":"property","member":"template","id":"property-template","cls":"Ext.button.Button"},{"type":"cfg","member":"allowDepress","id":"cfg-allowDepress","cls":"Ext.button.Button"},{"type":"cfg","member":"arrowAlign","id":"cfg-arrowAlign","cls":"Ext.button.Button"},{"type":"cfg","member":"arrowCls","id":"cfg-arrowCls","cls":"Ext.button.Button"},{"type":"cfg","member":"autoWidth","id":"cfg-autoWidth","cls":"Ext.button.Button"},{"type":"cfg","member":"baseCls","id":"cfg-baseCls","cls":"Ext.button.Button"},{"type":"cfg","member":"baseParams","id":"cfg-baseParams","cls":"Ext.button.Button"},{"type":"cfg","member":"clickEvent","id":"cfg-clickEvent","cls":"Ext.button.Button"},{"type":"cfg","member":"cls","id":"cfg-cls","cls":"Ext.button.Button"},{"type":"cfg","member":"disabled","id":"cfg-disabled","cls":"Ext.button.Button"},{"type":"cfg","member":"enableToggle","id":"cfg-enableToggle","cls":"Ext.button.Button"},{"type":"cfg","member":"focusCls","id":"cfg-focusCls","cls":"Ext.button.Button"},{"type":"cfg","member":"handleMouseEvents","id":"cfg-handleMouseEvents","cls":"Ext.button.Button"},{"type":"cfg","member":"handler","id":"cfg-handler","cls":"Ext.button.Button"},{"type":"cfg","member":"hidden","id":"cfg-hidden","cls":"Ext.button.Button"},{"type":"cfg","member":"href","id":"cfg-href","cls":"Ext.button.Button"},{"type":"cfg","member":"icon","id":"cfg-icon","cls":"Ext.button.Button"},{"type":"cfg","member":"iconAlign","id":"cfg-iconAlign","cls":"Ext.button.Button"},{"type":"cfg","member":"iconCls","id":"cfg-iconCls","cls":"Ext.button.Button"},{"type":"cfg","member":"menu","id":"cfg-menu","cls":"Ext.button.Button"},{"type":"cfg","member":"menuActiveCls","id":"cfg-menuActiveCls","cls":"Ext.button.Button"},{"type":"cfg","member":"menuAlign","id":"cfg-menuAlign","cls":"Ext.button.Button"},{"type":"cfg","member":"minWidth","id":"cfg-minWidth","cls":"Ext.button.Button"},{"type":"cfg","member":"overCls","id":"cfg-overCls","cls":"Ext.button.Button"},{"type":"cfg","member":"overflowText","id":"cfg-overflowText","cls":"Ext.button.Button"},{"type":"cfg","member":"params","id":"cfg-params","cls":"Ext.button.Button"},{"type":"cfg","member":"pressed","id":"cfg-pressed","cls":"Ext.button.Button"},{"type":"cfg","member":"pressedCls","id":"cfg-pressedCls","cls":"Ext.button.Button"},{"type":"cfg","member":"preventDefault","id":"cfg-preventDefault","cls":"Ext.button.Button"},{"type":"cfg","member":"repeat","id":"cfg-repeat","cls":"Ext.button.Button"},{"type":"cfg","member":"scale","id":"cfg-scale","cls":"Ext.button.Button"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.button.Button"},{"type":"cfg","member":"tabIndex","id":"cfg-tabIndex","cls":"Ext.button.Button"},{"type":"cfg","member":"text","id":"cfg-text","cls":"Ext.button.Button"},{"type":"cfg","member":"textAlign","id":"cfg-textAlign","cls":"Ext.button.Button"},{"type":"cfg","member":"toggleGroup","id":"cfg-toggleGroup","cls":"Ext.button.Button"},{"type":"cfg","member":"toggleHandler","id":"cfg-toggleHandler","cls":"Ext.button.Button"},{"type":"cfg","member":"tooltip","id":"cfg-tooltip","cls":"Ext.button.Button"},{"type":"cfg","member":"tooltipType","id":"cfg-tooltipType","cls":"Ext.button.Button"},{"type":"cfg","member":"type","id":"cfg-type","cls":"Ext.button.Button"},{"type":"method","member":"getTemplateArgs","id":"method-getTemplateArgs","cls":"Ext.button.Button"},{"type":"method","member":"getText","id":"method-getText","cls":"Ext.button.Button"},{"type":"method","member":"hasVisibleMenu","id":"method-hasVisibleMenu","cls":"Ext.button.Button"},{"type":"method","member":"hideMenu","id":"method-hideMenu","cls":"Ext.button.Button"},{"type":"method","member":"setHandler","id":"method-setHandler","cls":"Ext.button.Button"},{"type":"method","member":"setIcon","id":"method-setIcon","cls":"Ext.button.Button"},{"type":"method","member":"setIconCls","id":"method-setIconCls","cls":"Ext.button.Button"},{"type":"method","member":"setParams","id":"method-setParams","cls":"Ext.button.Button"},{"type":"method","member":"setScale","id":"method-setScale","cls":"Ext.button.Button"},{"type":"method","member":"setText","id":"method-setText","cls":"Ext.button.Button"},{"type":"method","member":"setTextAlign","id":"method-setTextAlign","cls":"Ext.button.Button"},{"type":"method","member":"setTooltip","id":"method-setTooltip","cls":"Ext.button.Button"},{"type":"method","member":"showMenu","id":"method-showMenu","cls":"Ext.button.Button"},{"type":"method","member":"toggle","id":"method-toggle","cls":"Ext.button.Button"},{"type":"event","member":"click","id":"event-click","cls":"Ext.button.Button"},{"type":"event","member":"menuhide","id":"event-menuhide","cls":"Ext.button.Button"},{"type":"event","member":"menushow","id":"event-menushow","cls":"Ext.button.Button"},{"type":"event","member":"menutriggerout","id":"event-menutriggerout","cls":"Ext.button.Button"},{"type":"event","member":"menutriggerover","id":"event-menutriggerover","cls":"Ext.button.Button"},{"type":"event","member":"mouseout","id":"event-mouseout","cls":"Ext.button.Button"},{"type":"event","member":"mouseover","id":"event-mouseover","cls":"Ext.button.Button"},{"type":"event","member":"toggle","id":"event-toggle","cls":"Ext.button.Button"},{"type":"cls","member":"ButtonToggleManager","cls":"Ext.ButtonToggleManager","xtypes":{}},{"type":"method","member":"getPressed","id":"method-getPressed","cls":"Ext.ButtonToggleManager"},{"type":"cls","member":"Cycle","cls":"Ext.button.Cycle","xtypes":{"widget":["cycle"]}},{"type":"property","member":"menu","id":"property-menu","cls":"Ext.button.Cycle"},{"type":"cfg","member":"changeHandler","id":"cfg-changeHandler","cls":"Ext.button.Cycle"},{"type":"cfg","member":"forceIcon","id":"cfg-forceIcon","cls":"Ext.button.Cycle"},{"type":"cfg","member":"items","id":"cfg-items","cls":"Ext.button.Cycle"},{"type":"cfg","member":"prependText","id":"cfg-prependText","cls":"Ext.button.Cycle"},{"type":"cfg","member":"showText","id":"cfg-showText","cls":"Ext.button.Cycle"},{"type":"method","member":"getActiveItem","id":"method-getActiveItem","cls":"Ext.button.Cycle"},{"type":"method","member":"setActiveItem","id":"method-setActiveItem","cls":"Ext.button.Cycle"},{"type":"method","member":"toggleSelected","id":"method-toggleSelected","cls":"Ext.button.Cycle"},{"type":"event","member":"change","id":"event-change","cls":"Ext.button.Cycle"},{"type":"cls","member":"Split","cls":"Ext.button.Split","xtypes":{"widget":["splitbutton"]}},{"type":"cfg","member":"arrowHandler","id":"cfg-arrowHandler","cls":"Ext.button.Split"},{"type":"cfg","member":"arrowTooltip","id":"cfg-arrowTooltip","cls":"Ext.button.Split"},{"type":"method","member":"setArrowHandler","id":"method-setArrowHandler","cls":"Ext.button.Split"},{"type":"event","member":"arrowclick","id":"event-arrowclick","cls":"Ext.button.Split"},{"type":"cls","member":"Component","cls":"Ext.Component","xtypes":{"widget":["component","box"]}},{"type":"property","member":"floatParent","id":"property-floatParent","cls":"Ext.Component"},{"type":"property","member":"zIndexManager","id":"property-zIndexManager","cls":"Ext.Component"},{"type":"cfg","member":"autoScroll","id":"cfg-autoScroll","cls":"Ext.Component"},{"type":"cfg","member":"draggable","id":"cfg-draggable","cls":"Ext.Component"},{"type":"cfg","member":"floating","id":"cfg-floating","cls":"Ext.Component"},{"type":"cfg","member":"maintainFlex","id":"cfg-maintainFlex","cls":"Ext.Component"},{"type":"cfg","member":"resizable","id":"cfg-resizable","cls":"Ext.Component"},{"type":"cfg","member":"resizeHandles","id":"cfg-resizeHandles","cls":"Ext.Component"},{"type":"cfg","member":"toFrontOnShow","id":"cfg-toFrontOnShow","cls":"Ext.Component"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.Component"},{"type":"method","member":"bubble","id":"method-bubble","cls":"Ext.Component"},{"type":"method","member":"cloneConfig","id":"method-cloneConfig","cls":"Ext.Component"},{"type":"method","member":"findParentBy","id":"method-findParentBy","cls":"Ext.Component"},{"type":"method","member":"findParentByType","id":"method-findParentByType","cls":"Ext.Component"},{"type":"method","member":"focus","id":"method-focus","cls":"Ext.Component"},{"type":"method","member":"getBox","id":"method-getBox","cls":"Ext.Component"},{"type":"method","member":"getPosition","id":"method-getPosition","cls":"Ext.Component"},{"type":"method","member":"getXType","id":"method-getXType","cls":"Ext.Component"},{"type":"method","member":"hide","id":"method-hide","cls":"Ext.Component"},{"type":"method","member":"initComponent","id":"method-initComponent","cls":"Ext.Component"},{"type":"method","member":"setAutoScroll","id":"method-setAutoScroll","cls":"Ext.Component"},{"type":"method","member":"setPagePosition","id":"method-setPagePosition","cls":"Ext.Component"},{"type":"method","member":"setPosition","id":"method-setPosition","cls":"Ext.Component"},{"type":"method","member":"show","id":"method-show","cls":"Ext.Component"},{"type":"method","member":"showAt","id":"method-showAt","cls":"Ext.Component"},{"type":"method","member":"updateBox","id":"method-updateBox","cls":"Ext.Component"},{"type":"cls","member":"ButtonGroup","cls":"Ext.container.ButtonGroup","xtypes":{"widget":["buttongroup"]}},{"type":"cfg","member":"baseCls","id":"cfg-baseCls","cls":"Ext.container.ButtonGroup"},{"type":"cfg","member":"columns","id":"cfg-columns","cls":"Ext.container.ButtonGroup"},{"type":"cfg","member":"frame","id":"cfg-frame","cls":"Ext.container.ButtonGroup"},{"type":"cfg","member":"layout","id":"cfg-layout","cls":"Ext.container.ButtonGroup"},{"type":"cls","member":"Container","cls":"Ext.container.Container","xtypes":{"widget":["container"]}},{"type":"method","member":"getChildByElement","id":"method-getChildByElement","cls":"Ext.container.Container"},{"type":"cls","member":"Viewport","cls":"Ext.container.Viewport","xtypes":{"widget":["viewport"]}},{"type":"cfg","member":"allowDomMove","id":"cfg-allowDomMove","cls":"Ext.container.Viewport"},{"type":"cfg","member":"applyTo","id":"cfg-applyTo","cls":"Ext.container.Viewport"},{"type":"cfg","member":"autoHeight","id":"cfg-autoHeight","cls":"Ext.container.Viewport"},{"type":"cfg","member":"autoWidth","id":"cfg-autoWidth","cls":"Ext.container.Viewport"},{"type":"cfg","member":"deferHeight","id":"cfg-deferHeight","cls":"Ext.container.Viewport"},{"type":"cfg","member":"height","id":"cfg-height","cls":"Ext.container.Viewport"},{"type":"cfg","member":"hideParent","id":"cfg-hideParent","cls":"Ext.container.Viewport"},{"type":"cfg","member":"monitorResize","id":"cfg-monitorResize","cls":"Ext.container.Viewport"},{"type":"cfg","member":"renderTo","id":"cfg-renderTo","cls":"Ext.container.Viewport"},{"type":"cfg","member":"width","id":"cfg-width","cls":"Ext.container.Viewport"},{"type":"cls","member":"DD","cls":"Ext.dd.DD","xtypes":{}},{"type":"property","member":"scroll","id":"property-scroll","cls":"Ext.dd.DD"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.dd.DD"},{"type":"method","member":"alignElWithMouse","id":"method-alignElWithMouse","cls":"Ext.dd.DD"},{"type":"method","member":"applyConfig","id":"method-applyConfig","cls":"Ext.dd.DD"},{"type":"method","member":"autoOffset","id":"method-autoOffset","cls":"Ext.dd.DD"},{"type":"method","member":"b4Drag","id":"method-b4Drag","cls":"Ext.dd.DD"},{"type":"method","member":"b4MouseDown","id":"method-b4MouseDown","cls":"Ext.dd.DD"},{"type":"method","member":"cachePosition","id":"method-cachePosition","cls":"Ext.dd.DD"},{"type":"method","member":"setDelta","id":"method-setDelta","cls":"Ext.dd.DD"},{"type":"method","member":"setDragElPos","id":"method-setDragElPos","cls":"Ext.dd.DD"},{"type":"cls","member":"DDProxy","cls":"Ext.dd.DDProxy","xtypes":{}},{"type":"property","member":"centerFrame","id":"property-centerFrame","cls":"Ext.dd.DDProxy"},{"type":"property","member":"resizeFrame","id":"property-resizeFrame","cls":"Ext.dd.DDProxy"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.dd.DDProxy"},{"type":"method","member":"createFrame","id":"method-createFrame","cls":"Ext.dd.DDProxy"},{"type":"method","member":"initFrame","id":"method-initFrame","cls":"Ext.dd.DDProxy"},{"type":"property","member":"dragElId","id":"static-property-dragElId","cls":"Ext.dd.DDProxy"},{"type":"cls","member":"DDTarget","cls":"Ext.dd.DDTarget","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.dd.DDTarget"},{"type":"cls","member":"DragDrop","cls":"Ext.dd.DragDrop","xtypes":{}},{"type":"property","member":"available","id":"property-available","cls":"Ext.dd.DragDrop"},{"type":"property","member":"config","id":"property-config","cls":"Ext.dd.DragDrop"},{"type":"property","member":"defaultPadding","id":"property-defaultPadding","cls":"Ext.dd.DragDrop"},{"type":"property","member":"groups","id":"property-groups","cls":"Ext.dd.DragDrop"},{"type":"property","member":"hasOuterHandles","id":"property-hasOuterHandles","cls":"Ext.dd.DragDrop"},{"type":"property","member":"id","id":"property-id","cls":"Ext.dd.DragDrop"},{"type":"property","member":"ignoreSelf","id":"property-ignoreSelf","cls":"Ext.dd.DragDrop"},{"type":"property","member":"invalidHandleClasses","id":"property-invalidHandleClasses","cls":"Ext.dd.DragDrop"},{"type":"property","member":"invalidHandleIds","id":"property-invalidHandleIds","cls":"Ext.dd.DragDrop"},{"type":"property","member":"invalidHandleTypes","id":"property-invalidHandleTypes","cls":"Ext.dd.DragDrop"},{"type":"property","member":"isTarget","id":"property-isTarget","cls":"Ext.dd.DragDrop"},{"type":"property","member":"maintainOffset","id":"property-maintainOffset","cls":"Ext.dd.DragDrop"},{"type":"property","member":"moveOnly","id":"property-moveOnly","cls":"Ext.dd.DragDrop"},{"type":"property","member":"padding","id":"property-padding","cls":"Ext.dd.DragDrop"},{"type":"property","member":"primaryButtonOnly","id":"property-primaryButtonOnly","cls":"Ext.dd.DragDrop"},{"type":"property","member":"xTicks","id":"property-xTicks","cls":"Ext.dd.DragDrop"},{"type":"property","member":"yTicks","id":"property-yTicks","cls":"Ext.dd.DragDrop"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.dd.DragDrop"},{"type":"method","member":"addInvalidHandleClass","id":"method-addInvalidHandleClass","cls":"Ext.dd.DragDrop"},{"type":"method","member":"addInvalidHandleId","id":"method-addInvalidHandleId","cls":"Ext.dd.DragDrop"},{"type":"method","member":"addInvalidHandleType","id":"method-addInvalidHandleType","cls":"Ext.dd.DragDrop"},{"type":"method","member":"addToGroup","id":"method-addToGroup","cls":"Ext.dd.DragDrop"},{"type":"method","member":"applyConfig","id":"method-applyConfig","cls":"Ext.dd.DragDrop"},{"type":"method","member":"clearConstraints","id":"method-clearConstraints","cls":"Ext.dd.DragDrop"},{"type":"method","member":"clearTicks","id":"method-clearTicks","cls":"Ext.dd.DragDrop"},{"type":"method","member":"constrainTo","id":"method-constrainTo","cls":"Ext.dd.DragDrop"},{"type":"method","member":"endDrag","id":"method-endDrag","cls":"Ext.dd.DragDrop"},{"type":"method","member":"getDragEl","id":"method-getDragEl","cls":"Ext.dd.DragDrop"},{"type":"method","member":"getEl","id":"method-getEl","cls":"Ext.dd.DragDrop"},{"type":"method","member":"init","id":"method-init","cls":"Ext.dd.DragDrop"},{"type":"method","member":"initTarget","id":"method-initTarget","cls":"Ext.dd.DragDrop"},{"type":"method","member":"isLocked","id":"method-isLocked","cls":"Ext.dd.DragDrop"},{"type":"method","member":"isValidHandleChild","id":"method-isValidHandleChild","cls":"Ext.dd.DragDrop"},{"type":"method","member":"lock","id":"method-lock","cls":"Ext.dd.DragDrop"},{"type":"method","member":"onAvailable","id":"method-onAvailable","cls":"Ext.dd.DragDrop"},{"type":"method","member":"onDrag","id":"method-onDrag","cls":"Ext.dd.DragDrop"},{"type":"method","member":"onDragDrop","id":"method-onDragDrop","cls":"Ext.dd.DragDrop"},{"type":"method","member":"onDragEnter","id":"method-onDragEnter","cls":"Ext.dd.DragDrop"},{"type":"method","member":"onDragOut","id":"method-onDragOut","cls":"Ext.dd.DragDrop"},{"type":"method","member":"onDragOver","id":"method-onDragOver","cls":"Ext.dd.DragDrop"},{"type":"method","member":"onInvalidDrop","id":"method-onInvalidDrop","cls":"Ext.dd.DragDrop"},{"type":"method","member":"onMouseDown","id":"method-onMouseDown","cls":"Ext.dd.DragDrop"},{"type":"method","member":"onMouseUp","id":"method-onMouseUp","cls":"Ext.dd.DragDrop"},{"type":"method","member":"removeFromGroup","id":"method-removeFromGroup","cls":"Ext.dd.DragDrop"},{"type":"method","member":"removeInvalidHandleClass","id":"method-removeInvalidHandleClass","cls":"Ext.dd.DragDrop"},{"type":"method","member":"removeInvalidHandleId","id":"method-removeInvalidHandleId","cls":"Ext.dd.DragDrop"},{"type":"method","member":"removeInvalidHandleType","id":"method-removeInvalidHandleType","cls":"Ext.dd.DragDrop"},{"type":"method","member":"resetConstraints","id":"method-resetConstraints","cls":"Ext.dd.DragDrop"},{"type":"method","member":"setDragElId","id":"method-setDragElId","cls":"Ext.dd.DragDrop"},{"type":"method","member":"setHandleElId","id":"method-setHandleElId","cls":"Ext.dd.DragDrop"},{"type":"method","member":"setInitPosition","id":"method-setInitPosition","cls":"Ext.dd.DragDrop"},{"type":"method","member":"setOuterHandleElId","id":"method-setOuterHandleElId","cls":"Ext.dd.DragDrop"},{"type":"method","member":"setPadding","id":"method-setPadding","cls":"Ext.dd.DragDrop"},{"type":"method","member":"setXConstraint","id":"method-setXConstraint","cls":"Ext.dd.DragDrop"},{"type":"method","member":"setYConstraint","id":"method-setYConstraint","cls":"Ext.dd.DragDrop"},{"type":"method","member":"startDrag","id":"method-startDrag","cls":"Ext.dd.DragDrop"},{"type":"method","member":"toString","id":"method-toString","cls":"Ext.dd.DragDrop"},{"type":"method","member":"unlock","id":"method-unlock","cls":"Ext.dd.DragDrop"},{"type":"method","member":"unreg","id":"method-unreg","cls":"Ext.dd.DragDrop"},{"type":"cls","member":"DragDropManager","cls":"Ext.dd.DragDropManager","xtypes":{}},{"type":"property","member":"INTERSECT","id":"property-INTERSECT","cls":"Ext.dd.DragDropManager"},{"type":"property","member":"POINT","id":"property-POINT","cls":"Ext.dd.DragDropManager"},{"type":"property","member":"clickPixelThresh","id":"property-clickPixelThresh","cls":"Ext.dd.DragDropManager"},{"type":"property","member":"clickTimeThresh","id":"property-clickTimeThresh","cls":"Ext.dd.DragDropManager"},{"type":"property","member":"mode","id":"property-mode","cls":"Ext.dd.DragDropManager"},{"type":"property","member":"preventDefault","id":"property-preventDefault","cls":"Ext.dd.DragDropManager"},{"type":"property","member":"stopPropagation","id":"property-stopPropagation","cls":"Ext.dd.DragDropManager"},{"type":"property","member":"useCache","id":"property-useCache","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"getBestMatch","id":"method-getBestMatch","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"getCss","id":"method-getCss","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"getDDById","id":"method-getDDById","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"getElement","id":"method-getElement","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"getLocation","id":"method-getLocation","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"getPosX","id":"method-getPosX","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"getPosY","id":"method-getPosY","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"getRelated","id":"method-getRelated","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"getScrollLeft","id":"method-getScrollLeft","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"getScrollTop","id":"method-getScrollTop","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"getStyle","id":"method-getStyle","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"handleWasClicked","id":"method-handleWasClicked","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"isDragDrop","id":"method-isDragDrop","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"isHandle","id":"method-isHandle","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"isLegalTarget","id":"method-isLegalTarget","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"isLocked","id":"method-isLocked","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"isTypeOfDD","id":"method-isTypeOfDD","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"lock","id":"method-lock","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"moveToEl","id":"method-moveToEl","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"numericSort","id":"method-numericSort","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"refreshCache","id":"method-refreshCache","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"regDragDrop","id":"method-regDragDrop","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"regHandle","id":"method-regHandle","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"startDrag","id":"method-startDrag","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"stopEvent","id":"method-stopEvent","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"swapNode","id":"method-swapNode","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"unlock","id":"method-unlock","cls":"Ext.dd.DragDropManager"},{"type":"method","member":"verifyEl","id":"method-verifyEl","cls":"Ext.dd.DragDropManager"},{"type":"cls","member":"DragDropManager.ElementWrapper","cls":"Ext.dd.DragDropManager.ElementWrapper","xtypes":{}},{"type":"property","member":"css","id":"property-css","cls":"Ext.dd.DragDropManager.ElementWrapper"},{"type":"property","member":"el","id":"property-el","cls":"Ext.dd.DragDropManager.ElementWrapper"},{"type":"property","member":"id","id":"property-id","cls":"Ext.dd.DragDropManager.ElementWrapper"},{"type":"cls","member":"DragSource","cls":"Ext.dd.DragSource","xtypes":{}},{"type":"cfg","member":"animRepair","id":"cfg-animRepair","cls":"Ext.dd.DragSource"},{"type":"cfg","member":"ddGroup","id":"cfg-ddGroup","cls":"Ext.dd.DragSource"},{"type":"cfg","member":"dropAllowed","id":"cfg-dropAllowed","cls":"Ext.dd.DragSource"},{"type":"cfg","member":"dropNotAllowed","id":"cfg-dropNotAllowed","cls":"Ext.dd.DragSource"},{"type":"cfg","member":"repairHighlightColor","id":"cfg-repairHighlightColor","cls":"Ext.dd.DragSource"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.dd.DragSource"},{"type":"method","member":"afterDragDrop","id":"method-afterDragDrop","cls":"Ext.dd.DragSource"},{"type":"method","member":"afterDragEnter","id":"method-afterDragEnter","cls":"Ext.dd.DragSource"},{"type":"method","member":"afterDragOut","id":"method-afterDragOut","cls":"Ext.dd.DragSource"},{"type":"method","member":"afterDragOver","id":"method-afterDragOver","cls":"Ext.dd.DragSource"},{"type":"method","member":"afterInvalidDrop","id":"method-afterInvalidDrop","cls":"Ext.dd.DragSource"},{"type":"method","member":"afterValidDrop","id":"method-afterValidDrop","cls":"Ext.dd.DragSource"},{"type":"method","member":"beforeDragDrop","id":"method-beforeDragDrop","cls":"Ext.dd.DragSource"},{"type":"method","member":"beforeDragEnter","id":"method-beforeDragEnter","cls":"Ext.dd.DragSource"},{"type":"method","member":"beforeDragOut","id":"method-beforeDragOut","cls":"Ext.dd.DragSource"},{"type":"method","member":"beforeDragOver","id":"method-beforeDragOver","cls":"Ext.dd.DragSource"},{"type":"method","member":"beforeInvalidDrop","id":"method-beforeInvalidDrop","cls":"Ext.dd.DragSource"},{"type":"method","member":"getDragData","id":"method-getDragData","cls":"Ext.dd.DragSource"},{"type":"method","member":"getProxy","id":"method-getProxy","cls":"Ext.dd.DragSource"},{"type":"method","member":"hideProxy","id":"method-hideProxy","cls":"Ext.dd.DragSource"},{"type":"method","member":"onBeforeDrag","id":"method-onBeforeDrag","cls":"Ext.dd.DragSource"},{"type":"method","member":"onStartDrag","id":"method-onStartDrag","cls":"Ext.dd.DragSource"},{"type":"cls","member":"DragTracker","cls":"Ext.dd.DragTracker","xtypes":{}},{"type":"property","member":"active","id":"property-active","cls":"Ext.dd.DragTracker"},{"type":"property","member":"dragTarget","id":"property-dragTarget","cls":"Ext.dd.DragTracker"},{"type":"cfg","member":"autoStart","id":"cfg-autoStart","cls":"Ext.dd.DragTracker"},{"type":"cfg","member":"constrainTo","id":"cfg-constrainTo","cls":"Ext.dd.DragTracker"},{"type":"cfg","member":"delegate","id":"cfg-delegate","cls":"Ext.dd.DragTracker"},{"type":"cfg","member":"overCls","id":"cfg-overCls","cls":"Ext.dd.DragTracker"},{"type":"cfg","member":"preventDefault","id":"cfg-preventDefault","cls":"Ext.dd.DragTracker"},{"type":"cfg","member":"stopEvent","id":"cfg-stopEvent","cls":"Ext.dd.DragTracker"},{"type":"cfg","member":"tolerance","id":"cfg-tolerance","cls":"Ext.dd.DragTracker"},{"type":"cfg","member":"trackOver","id":"cfg-trackOver","cls":"Ext.dd.DragTracker"},{"type":"method","member":"getDragTarget","id":"method-getDragTarget","cls":"Ext.dd.DragTracker"},{"type":"method","member":"getOffset","id":"method-getOffset","cls":"Ext.dd.DragTracker"},{"type":"method","member":"initEl","id":"method-initEl","cls":"Ext.dd.DragTracker"},{"type":"method","member":"onBeforeStart","id":"method-onBeforeStart","cls":"Ext.dd.DragTracker"},{"type":"method","member":"onDrag","id":"method-onDrag","cls":"Ext.dd.DragTracker"},{"type":"method","member":"onEnd","id":"method-onEnd","cls":"Ext.dd.DragTracker"},{"type":"method","member":"onStart","id":"method-onStart","cls":"Ext.dd.DragTracker"},{"type":"event","member":"beforestart","id":"event-beforestart","cls":"Ext.dd.DragTracker"},{"type":"event","member":"drag","id":"event-drag","cls":"Ext.dd.DragTracker"},{"type":"event","member":"dragend","id":"event-dragend","cls":"Ext.dd.DragTracker"},{"type":"event","member":"dragstart","id":"event-dragstart","cls":"Ext.dd.DragTracker"},{"type":"event","member":"mousedown","id":"event-mousedown","cls":"Ext.dd.DragTracker"},{"type":"event","member":"mousemove","id":"event-mousemove","cls":"Ext.dd.DragTracker"},{"type":"event","member":"mouseout","id":"event-mouseout","cls":"Ext.dd.DragTracker"},{"type":"event","member":"mouseover","id":"event-mouseover","cls":"Ext.dd.DragTracker"},{"type":"event","member":"mouseup","id":"event-mouseup","cls":"Ext.dd.DragTracker"},{"type":"cls","member":"DragZone","cls":"Ext.dd.DragZone","xtypes":{}},{"type":"property","member":"dragData","id":"property-dragData","cls":"Ext.dd.DragZone"},{"type":"cfg","member":"containerScroll","id":"cfg-containerScroll","cls":"Ext.dd.DragZone"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.dd.DragZone"},{"type":"method","member":"afterRepair","id":"method-afterRepair","cls":"Ext.dd.DragZone"},{"type":"method","member":"getDragData","id":"method-getDragData","cls":"Ext.dd.DragZone"},{"type":"method","member":"getRepairXY","id":"method-getRepairXY","cls":"Ext.dd.DragZone"},{"type":"method","member":"onInitDrag","id":"method-onInitDrag","cls":"Ext.dd.DragZone"},{"type":"cls","member":"DropTarget","cls":"Ext.dd.DropTarget","xtypes":{}},{"type":"cfg","member":"ddGroup","id":"cfg-ddGroup","cls":"Ext.dd.DropTarget"},{"type":"cfg","member":"dropAllowed","id":"cfg-dropAllowed","cls":"Ext.dd.DropTarget"},{"type":"cfg","member":"dropNotAllowed","id":"cfg-dropNotAllowed","cls":"Ext.dd.DropTarget"},{"type":"cfg","member":"overClass","id":"cfg-overClass","cls":"Ext.dd.DropTarget"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.dd.DropTarget"},{"type":"method","member":"notifyDrop","id":"method-notifyDrop","cls":"Ext.dd.DropTarget"},{"type":"method","member":"notifyEnter","id":"method-notifyEnter","cls":"Ext.dd.DropTarget"},{"type":"method","member":"notifyOut","id":"method-notifyOut","cls":"Ext.dd.DropTarget"},{"type":"method","member":"notifyOver","id":"method-notifyOver","cls":"Ext.dd.DropTarget"},{"type":"cls","member":"DropZone","cls":"Ext.dd.DropZone","xtypes":{}},{"type":"method","member":"getTargetFromEvent","id":"method-getTargetFromEvent","cls":"Ext.dd.DropZone"},{"type":"method","member":"notifyDrop","id":"method-notifyDrop","cls":"Ext.dd.DropZone"},{"type":"method","member":"notifyEnter","id":"method-notifyEnter","cls":"Ext.dd.DropZone"},{"type":"method","member":"notifyOut","id":"method-notifyOut","cls":"Ext.dd.DropZone"},{"type":"method","member":"notifyOver","id":"method-notifyOver","cls":"Ext.dd.DropZone"},{"type":"method","member":"onContainerDrop","id":"method-onContainerDrop","cls":"Ext.dd.DropZone"},{"type":"method","member":"onContainerOver","id":"method-onContainerOver","cls":"Ext.dd.DropZone"},{"type":"method","member":"onNodeDrop","id":"method-onNodeDrop","cls":"Ext.dd.DropZone"},{"type":"method","member":"onNodeEnter","id":"method-onNodeEnter","cls":"Ext.dd.DropZone"},{"type":"method","member":"onNodeOut","id":"method-onNodeOut","cls":"Ext.dd.DropZone"},{"type":"method","member":"onNodeOver","id":"method-onNodeOver","cls":"Ext.dd.DropZone"},{"type":"cls","member":"Registry","cls":"Ext.dd.Registry","xtypes":{}},{"type":"method","member":"getHandle","id":"method-getHandle","cls":"Ext.dd.Registry"},{"type":"method","member":"getHandleFromEvent","id":"method-getHandleFromEvent","cls":"Ext.dd.Registry"},{"type":"method","member":"getTarget","id":"method-getTarget","cls":"Ext.dd.Registry"},{"type":"method","member":"getTargetFromEvent","id":"method-getTargetFromEvent","cls":"Ext.dd.Registry"},{"type":"method","member":"register","id":"method-register","cls":"Ext.dd.Registry"},{"type":"method","member":"unregister","id":"method-unregister","cls":"Ext.dd.Registry"},{"type":"cls","member":"ScrollManager","cls":"Ext.dd.ScrollManager","xtypes":{}},{"type":"property","member":"animDuration","id":"property-animDuration","cls":"Ext.dd.ScrollManager"},{"type":"property","member":"animate","id":"property-animate","cls":"Ext.dd.ScrollManager"},{"type":"property","member":"ddGroup","id":"property-ddGroup","cls":"Ext.dd.ScrollManager"},{"type":"property","member":"frequency","id":"property-frequency","cls":"Ext.dd.ScrollManager"},{"type":"property","member":"hthresh","id":"property-hthresh","cls":"Ext.dd.ScrollManager"},{"type":"property","member":"increment","id":"property-increment","cls":"Ext.dd.ScrollManager"},{"type":"property","member":"vthresh","id":"property-vthresh","cls":"Ext.dd.ScrollManager"},{"type":"method","member":"refreshCache","id":"method-refreshCache","cls":"Ext.dd.ScrollManager"},{"type":"method","member":"register","id":"method-register","cls":"Ext.dd.ScrollManager"},{"type":"method","member":"unregister","id":"method-unregister","cls":"Ext.dd.ScrollManager"},{"type":"cls","member":"StatusProxy","cls":"Ext.dd.StatusProxy","xtypes":{}},{"type":"cfg","member":"dropAllowed","id":"cfg-dropAllowed","cls":"Ext.dd.StatusProxy"},{"type":"cfg","member":"dropNotAllowed","id":"cfg-dropNotAllowed","cls":"Ext.dd.StatusProxy"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.dd.StatusProxy"},{"type":"method","member":"getEl","id":"method-getEl","cls":"Ext.dd.StatusProxy"},{"type":"method","member":"getGhost","id":"method-getGhost","cls":"Ext.dd.StatusProxy"},{"type":"method","member":"hide","id":"method-hide","cls":"Ext.dd.StatusProxy"},{"type":"method","member":"repair","id":"method-repair","cls":"Ext.dd.StatusProxy"},{"type":"method","member":"reset","id":"method-reset","cls":"Ext.dd.StatusProxy"},{"type":"method","member":"setStatus","id":"method-setStatus","cls":"Ext.dd.StatusProxy"},{"type":"method","member":"show","id":"method-show","cls":"Ext.dd.StatusProxy"},{"type":"method","member":"stop","id":"method-stop","cls":"Ext.dd.StatusProxy"},{"type":"method","member":"sync","id":"method-sync","cls":"Ext.dd.StatusProxy"},{"type":"method","member":"update","id":"method-update","cls":"Ext.dd.StatusProxy"},{"type":"cls","member":"Editor","cls":"Ext.Editor","xtypes":{"widget":["editor"]}},{"type":"cfg","member":"alignment","id":"cfg-alignment","cls":"Ext.Editor"},{"type":"cfg","member":"allowBlur","id":"cfg-allowBlur","cls":"Ext.Editor"},{"type":"cfg","member":"autoSize","id":"cfg-autoSize","cls":"Ext.Editor"},{"type":"cfg","member":"cancelOnEsc","id":"cfg-cancelOnEsc","cls":"Ext.Editor"},{"type":"cfg","member":"completeOnEnter","id":"cfg-completeOnEnter","cls":"Ext.Editor"},{"type":"cfg","member":"constrain","id":"cfg-constrain","cls":"Ext.Editor"},{"type":"cfg","member":"field","id":"cfg-field","cls":"Ext.Editor"},{"type":"cfg","member":"hideEl","id":"cfg-hideEl","cls":"Ext.Editor"},{"type":"cfg","member":"ignoreNoChange","id":"cfg-ignoreNoChange","cls":"Ext.Editor"},{"type":"cfg","member":"offsets","id":"cfg-offsets","cls":"Ext.Editor"},{"type":"cfg","member":"parentEl","id":"cfg-parentEl","cls":"Ext.Editor"},{"type":"cfg","member":"revertInvalid","id":"cfg-revertInvalid","cls":"Ext.Editor"},{"type":"cfg","member":"shadow","id":"cfg-shadow","cls":"Ext.Editor"},{"type":"cfg","member":"swallowKeys","id":"cfg-swallowKeys","cls":"Ext.Editor"},{"type":"cfg","member":"updateEl","id":"cfg-updateEl","cls":"Ext.Editor"},{"type":"cfg","member":"value","id":"cfg-value","cls":"Ext.Editor"},{"type":"method","member":"cancelEdit","id":"method-cancelEdit","cls":"Ext.Editor"},{"type":"method","member":"completeEdit","id":"method-completeEdit","cls":"Ext.Editor"},{"type":"method","member":"getValue","id":"method-getValue","cls":"Ext.Editor"},{"type":"method","member":"realign","id":"method-realign","cls":"Ext.Editor"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.Editor"},{"type":"method","member":"startEdit","id":"method-startEdit","cls":"Ext.Editor"},{"type":"event","member":"beforecomplete","id":"event-beforecomplete","cls":"Ext.Editor"},{"type":"event","member":"beforestartedit","id":"event-beforestartedit","cls":"Ext.Editor"},{"type":"event","member":"canceledit","id":"event-canceledit","cls":"Ext.Editor"},{"type":"event","member":"complete","id":"event-complete","cls":"Ext.Editor"},{"type":"event","member":"specialkey","id":"event-specialkey","cls":"Ext.Editor"},{"type":"event","member":"startedit","id":"event-startedit","cls":"Ext.Editor"},{"type":"cls","member":"Component","cls":"Ext.flash.Component","xtypes":{"widget":["flash"]}},{"type":"property","member":"swf","id":"property-swf","cls":"Ext.flash.Component"},{"type":"cfg","member":"backgroundColor","id":"cfg-backgroundColor","cls":"Ext.flash.Component"},{"type":"cfg","member":"expressInstall","id":"cfg-expressInstall","cls":"Ext.flash.Component"},{"type":"cfg","member":"flashAttributes","id":"cfg-flashAttributes","cls":"Ext.flash.Component"},{"type":"cfg","member":"flashParams","id":"cfg-flashParams","cls":"Ext.flash.Component"},{"type":"cfg","member":"flashVars","id":"cfg-flashVars","cls":"Ext.flash.Component"},{"type":"cfg","member":"flashVersion","id":"cfg-flashVersion","cls":"Ext.flash.Component"},{"type":"cfg","member":"swfHeight","id":"cfg-swfHeight","cls":"Ext.flash.Component"},{"type":"cfg","member":"swfWidth","id":"cfg-swfWidth","cls":"Ext.flash.Component"},{"type":"cfg","member":"url","id":"cfg-url","cls":"Ext.flash.Component"},{"type":"cfg","member":"wmode","id":"cfg-wmode","cls":"Ext.flash.Component"},{"type":"method","member":"getSwfId","id":"method-getSwfId","cls":"Ext.flash.Component"},{"type":"event","member":"failure","id":"event-failure","cls":"Ext.flash.Component"},{"type":"event","member":"success","id":"event-success","cls":"Ext.flash.Component"},{"type":"property","member":"EXPRESS_INSTALL_URL","id":"static-property-EXPRESS_INSTALL_URL","cls":"Ext.flash.Component"},{"type":"cls","member":"FocusManager","cls":"Ext.FocusManager","xtypes":{}},{"type":"property","member":"enabled","id":"property-enabled","cls":"Ext.FocusManager"},{"type":"property","member":"focusedCmp","id":"property-focusedCmp","cls":"Ext.FocusManager"},{"type":"property","member":"whitelist","id":"property-whitelist","cls":"Ext.FocusManager"},{"type":"method","member":"addXTypeToWhitelist","id":"method-addXTypeToWhitelist","cls":"Ext.FocusManager"},{"type":"method","member":"disable","id":"method-disable","cls":"Ext.FocusManager"},{"type":"method","member":"enable","id":"method-enable","cls":"Ext.FocusManager"},{"type":"method","member":"removeXTypeFromWhitelist","id":"method-removeXTypeFromWhitelist","cls":"Ext.FocusManager"},{"type":"method","member":"subscribe","id":"method-subscribe","cls":"Ext.FocusManager"},{"type":"method","member":"unsubscribe","id":"method-unsubscribe","cls":"Ext.FocusManager"},{"type":"event","member":"beforecomponentfocus","id":"event-beforecomponentfocus","cls":"Ext.FocusManager"},{"type":"event","member":"componentfocus","id":"event-componentfocus","cls":"Ext.FocusManager"},{"type":"event","member":"disable","id":"event-disable","cls":"Ext.FocusManager"},{"type":"event","member":"enable","id":"event-enable","cls":"Ext.FocusManager"},{"type":"cls","member":"Action","cls":"Ext.form.action.Action","xtypes":{}},{"type":"property","member":"failureType","id":"property-failureType","cls":"Ext.form.action.Action"},{"type":"property","member":"response","id":"property-response","cls":"Ext.form.action.Action"},{"type":"property","member":"result","id":"property-result","cls":"Ext.form.action.Action"},{"type":"property","member":"run","id":"property-run","cls":"Ext.form.action.Action"},{"type":"property","member":"type","id":"property-type","cls":"Ext.form.action.Action"},{"type":"cfg","member":"failure","id":"cfg-failure","cls":"Ext.form.action.Action"},{"type":"cfg","member":"form","id":"cfg-form","cls":"Ext.form.action.Action"},{"type":"cfg","member":"headers","id":"cfg-headers","cls":"Ext.form.action.Action"},{"type":"cfg","member":"method","id":"cfg-method","cls":"Ext.form.action.Action"},{"type":"cfg","member":"params","id":"cfg-params","cls":"Ext.form.action.Action"},{"type":"cfg","member":"reset","id":"cfg-reset","cls":"Ext.form.action.Action"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.form.action.Action"},{"type":"cfg","member":"submitEmptyText","id":"cfg-submitEmptyText","cls":"Ext.form.action.Action"},{"type":"cfg","member":"success","id":"cfg-success","cls":"Ext.form.action.Action"},{"type":"cfg","member":"timeout","id":"cfg-timeout","cls":"Ext.form.action.Action"},{"type":"cfg","member":"url","id":"cfg-url","cls":"Ext.form.action.Action"},{"type":"cfg","member":"waitMsg","id":"cfg-waitMsg","cls":"Ext.form.action.Action"},{"type":"cfg","member":"waitTitle","id":"cfg-waitTitle","cls":"Ext.form.action.Action"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.form.action.Action"},{"type":"property","member":"CLIENT_INVALID","id":"static-property-CLIENT_INVALID","cls":"Ext.form.action.Action"},{"type":"property","member":"CONNECT_FAILURE","id":"static-property-CONNECT_FAILURE","cls":"Ext.form.action.Action"},{"type":"property","member":"LOAD_FAILURE","id":"static-property-LOAD_FAILURE","cls":"Ext.form.action.Action"},{"type":"property","member":"SERVER_INVALID","id":"static-property-SERVER_INVALID","cls":"Ext.form.action.Action"},{"type":"cls","member":"DirectLoad","cls":"Ext.form.action.DirectLoad","xtypes":{"formaction":["directload"]}},{"type":"cls","member":"DirectSubmit","cls":"Ext.form.action.DirectSubmit","xtypes":{"formaction":["directsubmit"]}},{"type":"cls","member":"Load","cls":"Ext.form.action.Load","xtypes":{"formaction":["load"]}},{"type":"cls","member":"StandardSubmit","cls":"Ext.form.action.StandardSubmit","xtypes":{"formaction":["standardsubmit"]}},{"type":"cfg","member":"target","id":"cfg-target","cls":"Ext.form.action.StandardSubmit"},{"type":"cls","member":"Submit","cls":"Ext.form.action.Submit","xtypes":{"formaction":["submit"]}},{"type":"cfg","member":"clientValidation","id":"cfg-clientValidation","cls":"Ext.form.action.Submit"},{"type":"cls","member":"Basic","cls":"Ext.form.Basic","xtypes":{}},{"type":"property","member":"owner","id":"property-owner","cls":"Ext.form.Basic"},{"type":"cfg","member":"api","id":"cfg-api","cls":"Ext.form.Basic"},{"type":"cfg","member":"baseParams","id":"cfg-baseParams","cls":"Ext.form.Basic"},{"type":"cfg","member":"errorReader","id":"cfg-errorReader","cls":"Ext.form.Basic"},{"type":"cfg","member":"method","id":"cfg-method","cls":"Ext.form.Basic"},{"type":"cfg","member":"paramOrder","id":"cfg-paramOrder","cls":"Ext.form.Basic"},{"type":"cfg","member":"paramsAsHash","id":"cfg-paramsAsHash","cls":"Ext.form.Basic"},{"type":"cfg","member":"reader","id":"cfg-reader","cls":"Ext.form.Basic"},{"type":"cfg","member":"standardSubmit","id":"cfg-standardSubmit","cls":"Ext.form.Basic"},{"type":"cfg","member":"timeout","id":"cfg-timeout","cls":"Ext.form.Basic"},{"type":"cfg","member":"trackResetOnLoad","id":"cfg-trackResetOnLoad","cls":"Ext.form.Basic"},{"type":"cfg","member":"url","id":"cfg-url","cls":"Ext.form.Basic"},{"type":"cfg","member":"waitMsgTarget","id":"cfg-waitMsgTarget","cls":"Ext.form.Basic"},{"type":"cfg","member":"waitTitle","id":"cfg-waitTitle","cls":"Ext.form.Basic"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.form.Basic"},{"type":"method","member":"applyIfToFields","id":"method-applyIfToFields","cls":"Ext.form.Basic"},{"type":"method","member":"applyToFields","id":"method-applyToFields","cls":"Ext.form.Basic"},{"type":"method","member":"checkDirty","id":"method-checkDirty","cls":"Ext.form.Basic"},{"type":"method","member":"checkValidity","id":"method-checkValidity","cls":"Ext.form.Basic"},{"type":"method","member":"clearInvalid","id":"method-clearInvalid","cls":"Ext.form.Basic"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.form.Basic"},{"type":"method","member":"doAction","id":"method-doAction","cls":"Ext.form.Basic"},{"type":"method","member":"findField","id":"method-findField","cls":"Ext.form.Basic"},{"type":"method","member":"getFieldValues","id":"method-getFieldValues","cls":"Ext.form.Basic"},{"type":"method","member":"getFields","id":"method-getFields","cls":"Ext.form.Basic"},{"type":"method","member":"getRecord","id":"method-getRecord","cls":"Ext.form.Basic"},{"type":"method","member":"getValues","id":"method-getValues","cls":"Ext.form.Basic"},{"type":"method","member":"hasInvalidField","id":"method-hasInvalidField","cls":"Ext.form.Basic"},{"type":"method","member":"hasUpload","id":"method-hasUpload","cls":"Ext.form.Basic"},{"type":"method","member":"isDirty","id":"method-isDirty","cls":"Ext.form.Basic"},{"type":"method","member":"isValid","id":"method-isValid","cls":"Ext.form.Basic"},{"type":"method","member":"load","id":"method-load","cls":"Ext.form.Basic"},{"type":"method","member":"loadRecord","id":"method-loadRecord","cls":"Ext.form.Basic"},{"type":"method","member":"markInvalid","id":"method-markInvalid","cls":"Ext.form.Basic"},{"type":"method","member":"reset","id":"method-reset","cls":"Ext.form.Basic"},{"type":"method","member":"setValues","id":"method-setValues","cls":"Ext.form.Basic"},{"type":"method","member":"submit","id":"method-submit","cls":"Ext.form.Basic"},{"type":"method","member":"updateRecord","id":"method-updateRecord","cls":"Ext.form.Basic"},{"type":"event","member":"actioncomplete","id":"event-actioncomplete","cls":"Ext.form.Basic"},{"type":"event","member":"actionfailed","id":"event-actionfailed","cls":"Ext.form.Basic"},{"type":"event","member":"beforeaction","id":"event-beforeaction","cls":"Ext.form.Basic"},{"type":"event","member":"dirtychange","id":"event-dirtychange","cls":"Ext.form.Basic"},{"type":"event","member":"validitychange","id":"event-validitychange","cls":"Ext.form.Basic"},{"type":"cls","member":"CheckboxGroup","cls":"Ext.form.CheckboxGroup","xtypes":{"widget":["checkboxgroup"]}},{"type":"cfg","member":"allowBlank","id":"cfg-allowBlank","cls":"Ext.form.CheckboxGroup"},{"type":"cfg","member":"blankText","id":"cfg-blankText","cls":"Ext.form.CheckboxGroup"},{"type":"cfg","member":"columns","id":"cfg-columns","cls":"Ext.form.CheckboxGroup"},{"type":"cfg","member":"fieldBodyCls","id":"cfg-fieldBodyCls","cls":"Ext.form.CheckboxGroup"},{"type":"cfg","member":"items","id":"cfg-items","cls":"Ext.form.CheckboxGroup"},{"type":"cfg","member":"vertical","id":"cfg-vertical","cls":"Ext.form.CheckboxGroup"},{"type":"method","member":"getChecked","id":"method-getChecked","cls":"Ext.form.CheckboxGroup"},{"type":"method","member":"getErrors","id":"method-getErrors","cls":"Ext.form.CheckboxGroup"},{"type":"method","member":"getValue","id":"method-getValue","cls":"Ext.form.CheckboxGroup"},{"type":"method","member":"initValue","id":"method-initValue","cls":"Ext.form.CheckboxGroup"},{"type":"method","member":"onFieldAdded","id":"method-onFieldAdded","cls":"Ext.form.CheckboxGroup"},{"type":"method","member":"reset","id":"method-reset","cls":"Ext.form.CheckboxGroup"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.form.CheckboxGroup"},{"type":"cls","member":"CheckboxManager","cls":"Ext.form.CheckboxManager","xtypes":{}},{"type":"cls","member":"Base","cls":"Ext.form.field.Base","xtypes":{"widget":["field"]}},{"type":"property","member":"inputEl","id":"property-inputEl","cls":"Ext.form.field.Base"},{"type":"cfg","member":"checkChangeBuffer","id":"cfg-checkChangeBuffer","cls":"Ext.form.field.Base"},{"type":"cfg","member":"checkChangeEvents","id":"cfg-checkChangeEvents","cls":"Ext.form.field.Base"},{"type":"cfg","member":"dirtyCls","id":"cfg-dirtyCls","cls":"Ext.form.field.Base"},{"type":"cfg","member":"fieldCls","id":"cfg-fieldCls","cls":"Ext.form.field.Base"},{"type":"cfg","member":"fieldStyle","id":"cfg-fieldStyle","cls":"Ext.form.field.Base"},{"type":"cfg","member":"fieldSubTpl","id":"cfg-fieldSubTpl","cls":"Ext.form.field.Base"},{"type":"cfg","member":"focusCls","id":"cfg-focusCls","cls":"Ext.form.field.Base"},{"type":"cfg","member":"inputId","id":"cfg-inputId","cls":"Ext.form.field.Base"},{"type":"cfg","member":"inputType","id":"cfg-inputType","cls":"Ext.form.field.Base"},{"type":"cfg","member":"invalidText","id":"cfg-invalidText","cls":"Ext.form.field.Base"},{"type":"cfg","member":"name","id":"cfg-name","cls":"Ext.form.field.Base"},{"type":"cfg","member":"readOnly","id":"cfg-readOnly","cls":"Ext.form.field.Base"},{"type":"cfg","member":"readOnlyCls","id":"cfg-readOnlyCls","cls":"Ext.form.field.Base"},{"type":"cfg","member":"tabIndex","id":"cfg-tabIndex","cls":"Ext.form.field.Base"},{"type":"cfg","member":"validateOnBlur","id":"cfg-validateOnBlur","cls":"Ext.form.field.Base"},{"type":"method","member":"clearInvalid","id":"method-clearInvalid","cls":"Ext.form.field.Base"},{"type":"method","member":"getInputId","id":"method-getInputId","cls":"Ext.form.field.Base"},{"type":"method","member":"getRawValue","id":"method-getRawValue","cls":"Ext.form.field.Base"},{"type":"method","member":"getSubTplData","id":"method-getSubTplData","cls":"Ext.form.field.Base"},{"type":"method","member":"getSubTplMarkup","id":"method-getSubTplMarkup","cls":"Ext.form.field.Base"},{"type":"method","member":"getSubmitValue","id":"method-getSubmitValue","cls":"Ext.form.field.Base"},{"type":"method","member":"getValue","id":"method-getValue","cls":"Ext.form.field.Base"},{"type":"method","member":"isValid","id":"method-isValid","cls":"Ext.form.field.Base"},{"type":"method","member":"markInvalid","id":"method-markInvalid","cls":"Ext.form.field.Base"},{"type":"method","member":"processRawValue","id":"method-processRawValue","cls":"Ext.form.field.Base"},{"type":"method","member":"rawToValue","id":"method-rawToValue","cls":"Ext.form.field.Base"},{"type":"method","member":"setFieldStyle","id":"method-setFieldStyle","cls":"Ext.form.field.Base"},{"type":"method","member":"setRawValue","id":"method-setRawValue","cls":"Ext.form.field.Base"},{"type":"method","member":"setReadOnly","id":"method-setReadOnly","cls":"Ext.form.field.Base"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.form.field.Base"},{"type":"method","member":"validateValue","id":"method-validateValue","cls":"Ext.form.field.Base"},{"type":"method","member":"valueToRaw","id":"method-valueToRaw","cls":"Ext.form.field.Base"},{"type":"event","member":"blur","id":"event-blur","cls":"Ext.form.field.Base"},{"type":"event","member":"focus","id":"event-focus","cls":"Ext.form.field.Base"},{"type":"event","member":"specialkey","id":"event-specialkey","cls":"Ext.form.field.Base"},{"type":"cls","member":"Checkbox","cls":"Ext.form.field.Checkbox","xtypes":{"widget":["checkboxfield","checkbox"]}},{"type":"property","member":"boxLabelEl","id":"property-boxLabelEl","cls":"Ext.form.field.Checkbox"},{"type":"property","member":"originalValue","id":"property-originalValue","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"boxLabel","id":"cfg-boxLabel","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"boxLabelAlign","id":"cfg-boxLabelAlign","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"boxLabelCls","id":"cfg-boxLabelCls","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"checked","id":"cfg-checked","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"checkedCls","id":"cfg-checkedCls","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"fieldBodyCls","id":"cfg-fieldBodyCls","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"fieldCls","id":"cfg-fieldCls","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"focusCls","id":"cfg-focusCls","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"handler","id":"cfg-handler","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"inputValue","id":"cfg-inputValue","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.form.field.Checkbox"},{"type":"cfg","member":"uncheckedValue","id":"cfg-uncheckedValue","cls":"Ext.form.field.Checkbox"},{"type":"method","member":"getRawValue","id":"method-getRawValue","cls":"Ext.form.field.Checkbox"},{"type":"method","member":"getSubmitValue","id":"method-getSubmitValue","cls":"Ext.form.field.Checkbox"},{"type":"method","member":"getValue","id":"method-getValue","cls":"Ext.form.field.Checkbox"},{"type":"method","member":"setRawValue","id":"method-setRawValue","cls":"Ext.form.field.Checkbox"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.form.field.Checkbox"},{"type":"cls","member":"ComboBox","cls":"Ext.form.field.ComboBox","xtypes":{"widget":["combobox","combo"]}},{"type":"property","member":"fieldSubTpl","id":"property-fieldSubTpl","cls":"Ext.form.field.ComboBox"},{"type":"property","member":"lastQuery","id":"property-lastQuery","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"allQuery","id":"cfg-allQuery","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"autoSelect","id":"cfg-autoSelect","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"defaultListConfig","id":"cfg-defaultListConfig","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"delimiter","id":"cfg-delimiter","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"displayField","id":"cfg-displayField","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"forceSelection","id":"cfg-forceSelection","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"listConfig","id":"cfg-listConfig","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"minChars","id":"cfg-minChars","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"multiSelect","id":"cfg-multiSelect","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"pageSize","id":"cfg-pageSize","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"queryDelay","id":"cfg-queryDelay","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"queryMode","id":"cfg-queryMode","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"queryParam","id":"cfg-queryParam","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"selectOnTab","id":"cfg-selectOnTab","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"store","id":"cfg-store","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"transform","id":"cfg-transform","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"triggerAction","id":"cfg-triggerAction","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"triggerCls","id":"cfg-triggerCls","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"typeAhead","id":"cfg-typeAhead","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"typeAheadDelay","id":"cfg-typeAheadDelay","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"valueField","id":"cfg-valueField","cls":"Ext.form.field.ComboBox"},{"type":"cfg","member":"valueNotFoundText","id":"cfg-valueNotFoundText","cls":"Ext.form.field.ComboBox"},{"type":"method","member":"clearValue","id":"method-clearValue","cls":"Ext.form.field.ComboBox"},{"type":"method","member":"doQuery","id":"method-doQuery","cls":"Ext.form.field.ComboBox"},{"type":"method","member":"findRecord","id":"method-findRecord","cls":"Ext.form.field.ComboBox"},{"type":"method","member":"findRecordByDisplay","id":"method-findRecordByDisplay","cls":"Ext.form.field.ComboBox"},{"type":"method","member":"findRecordByValue","id":"method-findRecordByValue","cls":"Ext.form.field.ComboBox"},{"type":"method","member":"getStore","id":"method-getStore","cls":"Ext.form.field.ComboBox"},{"type":"method","member":"select","id":"method-select","cls":"Ext.form.field.ComboBox"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.form.field.ComboBox"},{"type":"event","member":"beforedeselect","id":"event-beforedeselect","cls":"Ext.form.field.ComboBox"},{"type":"event","member":"beforequery","id":"event-beforequery","cls":"Ext.form.field.ComboBox"},{"type":"event","member":"beforeselect","id":"event-beforeselect","cls":"Ext.form.field.ComboBox"},{"type":"event","member":"select","id":"event-select","cls":"Ext.form.field.ComboBox"},{"type":"cls","member":"Date","cls":"Ext.form.field.Date","xtypes":{"widget":["datefield"]}},{"type":"cfg","member":"altFormats","id":"cfg-altFormats","cls":"Ext.form.field.Date"},{"type":"cfg","member":"disabledDates","id":"cfg-disabledDates","cls":"Ext.form.field.Date"},{"type":"cfg","member":"disabledDatesText","id":"cfg-disabledDatesText","cls":"Ext.form.field.Date"},{"type":"cfg","member":"disabledDays","id":"cfg-disabledDays","cls":"Ext.form.field.Date"},{"type":"cfg","member":"disabledDaysText","id":"cfg-disabledDaysText","cls":"Ext.form.field.Date"},{"type":"cfg","member":"format","id":"cfg-format","cls":"Ext.form.field.Date"},{"type":"cfg","member":"invalidText","id":"cfg-invalidText","cls":"Ext.form.field.Date"},{"type":"cfg","member":"maxText","id":"cfg-maxText","cls":"Ext.form.field.Date"},{"type":"cfg","member":"maxValue","id":"cfg-maxValue","cls":"Ext.form.field.Date"},{"type":"cfg","member":"minText","id":"cfg-minText","cls":"Ext.form.field.Date"},{"type":"cfg","member":"minValue","id":"cfg-minValue","cls":"Ext.form.field.Date"},{"type":"cfg","member":"showToday","id":"cfg-showToday","cls":"Ext.form.field.Date"},{"type":"cfg","member":"startDay","id":"cfg-startDay","cls":"Ext.form.field.Date"},{"type":"cfg","member":"submitFormat","id":"cfg-submitFormat","cls":"Ext.form.field.Date"},{"type":"cfg","member":"triggerCls","id":"cfg-triggerCls","cls":"Ext.form.field.Date"},{"type":"method","member":"getErrors","id":"method-getErrors","cls":"Ext.form.field.Date"},{"type":"method","member":"safeParse","id":"method-safeParse","cls":"Ext.form.field.Date"},{"type":"method","member":"setDisabledDates","id":"method-setDisabledDates","cls":"Ext.form.field.Date"},{"type":"method","member":"setDisabledDays","id":"method-setDisabledDays","cls":"Ext.form.field.Date"},{"type":"method","member":"setMaxValue","id":"method-setMaxValue","cls":"Ext.form.field.Date"},{"type":"method","member":"setMinValue","id":"method-setMinValue","cls":"Ext.form.field.Date"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.form.field.Date"},{"type":"cls","member":"Display","cls":"Ext.form.field.Display","xtypes":{"widget":["displayfield"]}},{"type":"cfg","member":"fieldCls","id":"cfg-fieldCls","cls":"Ext.form.field.Display"},{"type":"cfg","member":"htmlEncode","id":"cfg-htmlEncode","cls":"Ext.form.field.Display"},{"type":"cls","member":"Field","cls":"Ext.form.field.Field","xtypes":{}},{"type":"property","member":"isFormField","id":"property-isFormField","cls":"Ext.form.field.Field"},{"type":"property","member":"originalValue","id":"property-originalValue","cls":"Ext.form.field.Field"},{"type":"cfg","member":"disabled","id":"cfg-disabled","cls":"Ext.form.field.Field"},{"type":"cfg","member":"name","id":"cfg-name","cls":"Ext.form.field.Field"},{"type":"cfg","member":"submitValue","id":"cfg-submitValue","cls":"Ext.form.field.Field"},{"type":"cfg","member":"validateOnChange","id":"cfg-validateOnChange","cls":"Ext.form.field.Field"},{"type":"cfg","member":"value","id":"cfg-value","cls":"Ext.form.field.Field"},{"type":"method","member":"batchChanges","id":"method-batchChanges","cls":"Ext.form.field.Field"},{"type":"method","member":"checkChange","id":"method-checkChange","cls":"Ext.form.field.Field"},{"type":"method","member":"checkDirty","id":"method-checkDirty","cls":"Ext.form.field.Field"},{"type":"method","member":"clearInvalid","id":"method-clearInvalid","cls":"Ext.form.field.Field"},{"type":"method","member":"extractFileInput","id":"method-extractFileInput","cls":"Ext.form.field.Field"},{"type":"method","member":"getErrors","id":"method-getErrors","cls":"Ext.form.field.Field"},{"type":"method","member":"getModelData","id":"method-getModelData","cls":"Ext.form.field.Field"},{"type":"method","member":"getName","id":"method-getName","cls":"Ext.form.field.Field"},{"type":"method","member":"getSubmitData","id":"method-getSubmitData","cls":"Ext.form.field.Field"},{"type":"method","member":"getValue","id":"method-getValue","cls":"Ext.form.field.Field"},{"type":"method","member":"initField","id":"method-initField","cls":"Ext.form.field.Field"},{"type":"method","member":"initValue","id":"method-initValue","cls":"Ext.form.field.Field"},{"type":"method","member":"isDirty","id":"method-isDirty","cls":"Ext.form.field.Field"},{"type":"method","member":"isEqual","id":"method-isEqual","cls":"Ext.form.field.Field"},{"type":"method","member":"isFileUpload","id":"method-isFileUpload","cls":"Ext.form.field.Field"},{"type":"method","member":"isValid","id":"method-isValid","cls":"Ext.form.field.Field"},{"type":"method","member":"markInvalid","id":"method-markInvalid","cls":"Ext.form.field.Field"},{"type":"method","member":"reset","id":"method-reset","cls":"Ext.form.field.Field"},{"type":"method","member":"resetOriginalValue","id":"method-resetOriginalValue","cls":"Ext.form.field.Field"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.form.field.Field"},{"type":"method","member":"validate","id":"method-validate","cls":"Ext.form.field.Field"},{"type":"event","member":"change","id":"event-change","cls":"Ext.form.field.Field"},{"type":"event","member":"dirtychange","id":"event-dirtychange","cls":"Ext.form.field.Field"},{"type":"event","member":"validitychange","id":"event-validitychange","cls":"Ext.form.field.Field"},{"type":"cls","member":"File","cls":"Ext.form.field.File","xtypes":{"widget":["filefield","fileuploadfield"]}},{"type":"property","member":"button","id":"property-button","cls":"Ext.form.field.File"},{"type":"property","member":"fileInputEl","id":"property-fileInputEl","cls":"Ext.form.field.File"},{"type":"cfg","member":"buttonConfig","id":"cfg-buttonConfig","cls":"Ext.form.field.File"},{"type":"cfg","member":"buttonMargin","id":"cfg-buttonMargin","cls":"Ext.form.field.File"},{"type":"cfg","member":"buttonOnly","id":"cfg-buttonOnly","cls":"Ext.form.field.File"},{"type":"cfg","member":"buttonText","id":"cfg-buttonText","cls":"Ext.form.field.File"},{"type":"cfg","member":"fieldBodyCls","id":"cfg-fieldBodyCls","cls":"Ext.form.field.File"},{"type":"cfg","member":"readOnly","id":"cfg-readOnly","cls":"Ext.form.field.File"},{"type":"event","member":"change","id":"event-change","cls":"Ext.form.field.File"},{"type":"cls","member":"Hidden","cls":"Ext.form.field.Hidden","xtypes":{"widget":["hiddenfield","hidden"]}},{"type":"cls","member":"HtmlEditor","cls":"Ext.form.field.HtmlEditor","xtypes":{"widget":["htmleditor"]}},{"type":"property","member":"buttonTips","id":"property-buttonTips","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"createLinkText","id":"cfg-createLinkText","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"defaultLinkValue","id":"cfg-defaultLinkValue","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"defaultValue","id":"cfg-defaultValue","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"enableAlignments","id":"cfg-enableAlignments","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"enableColors","id":"cfg-enableColors","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"enableFont","id":"cfg-enableFont","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"enableFontSize","id":"cfg-enableFontSize","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"enableFormat","id":"cfg-enableFormat","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"enableLinks","id":"cfg-enableLinks","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"enableLists","id":"cfg-enableLists","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"enableSourceEdit","id":"cfg-enableSourceEdit","cls":"Ext.form.field.HtmlEditor"},{"type":"cfg","member":"fontFamilies","id":"cfg-fontFamilies","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"cleanHtml","id":"method-cleanHtml","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"createToolbar","id":"method-createToolbar","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"execCmd","id":"method-execCmd","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"getDocMarkup","id":"method-getDocMarkup","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"getToolbar","id":"method-getToolbar","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"insertAtCursor","id":"method-insertAtCursor","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"pushValue","id":"method-pushValue","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"relayCmd","id":"method-relayCmd","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"setReadOnly","id":"method-setReadOnly","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"syncValue","id":"method-syncValue","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"toggleSourceEdit","id":"method-toggleSourceEdit","cls":"Ext.form.field.HtmlEditor"},{"type":"method","member":"updateToolbar","id":"method-updateToolbar","cls":"Ext.form.field.HtmlEditor"},{"type":"event","member":"activate","id":"event-activate","cls":"Ext.form.field.HtmlEditor"},{"type":"event","member":"beforepush","id":"event-beforepush","cls":"Ext.form.field.HtmlEditor"},{"type":"event","member":"beforesync","id":"event-beforesync","cls":"Ext.form.field.HtmlEditor"},{"type":"event","member":"editmodechange","id":"event-editmodechange","cls":"Ext.form.field.HtmlEditor"},{"type":"event","member":"initialize","id":"event-initialize","cls":"Ext.form.field.HtmlEditor"},{"type":"event","member":"push","id":"event-push","cls":"Ext.form.field.HtmlEditor"},{"type":"event","member":"sync","id":"event-sync","cls":"Ext.form.field.HtmlEditor"},{"type":"cls","member":"Number","cls":"Ext.form.field.Number","xtypes":{"widget":["numberfield"]}},{"type":"cfg","member":"allowDecimals","id":"cfg-allowDecimals","cls":"Ext.form.field.Number"},{"type":"cfg","member":"autoStripChars","id":"cfg-autoStripChars","cls":"Ext.form.field.Number"},{"type":"cfg","member":"baseChars","id":"cfg-baseChars","cls":"Ext.form.field.Number"},{"type":"cfg","member":"decimalPrecision","id":"cfg-decimalPrecision","cls":"Ext.form.field.Number"},{"type":"cfg","member":"decimalSeparator","id":"cfg-decimalSeparator","cls":"Ext.form.field.Number"},{"type":"cfg","member":"maxText","id":"cfg-maxText","cls":"Ext.form.field.Number"},{"type":"cfg","member":"maxValue","id":"cfg-maxValue","cls":"Ext.form.field.Number"},{"type":"cfg","member":"minText","id":"cfg-minText","cls":"Ext.form.field.Number"},{"type":"cfg","member":"minValue","id":"cfg-minValue","cls":"Ext.form.field.Number"},{"type":"cfg","member":"nanText","id":"cfg-nanText","cls":"Ext.form.field.Number"},{"type":"cfg","member":"negativeText","id":"cfg-negativeText","cls":"Ext.form.field.Number"},{"type":"cfg","member":"step","id":"cfg-step","cls":"Ext.form.field.Number"},{"type":"method","member":"getErrors","id":"method-getErrors","cls":"Ext.form.field.Number"},{"type":"method","member":"setMaxValue","id":"method-setMaxValue","cls":"Ext.form.field.Number"},{"type":"method","member":"setMinValue","id":"method-setMinValue","cls":"Ext.form.field.Number"},{"type":"cls","member":"Picker","cls":"Ext.form.field.Picker","xtypes":{"widget":["pickerfield"]}},{"type":"property","member":"isExpanded","id":"property-isExpanded","cls":"Ext.form.field.Picker"},{"type":"cfg","member":"editable","id":"cfg-editable","cls":"Ext.form.field.Picker"},{"type":"cfg","member":"matchFieldWidth","id":"cfg-matchFieldWidth","cls":"Ext.form.field.Picker"},{"type":"cfg","member":"openCls","id":"cfg-openCls","cls":"Ext.form.field.Picker"},{"type":"cfg","member":"pickerAlign","id":"cfg-pickerAlign","cls":"Ext.form.field.Picker"},{"type":"cfg","member":"pickerOffset","id":"cfg-pickerOffset","cls":"Ext.form.field.Picker"},{"type":"method","member":"alignPicker","id":"method-alignPicker","cls":"Ext.form.field.Picker"},{"type":"method","member":"collapse","id":"method-collapse","cls":"Ext.form.field.Picker"},{"type":"method","member":"createPicker","id":"method-createPicker","cls":"Ext.form.field.Picker"},{"type":"method","member":"expand","id":"method-expand","cls":"Ext.form.field.Picker"},{"type":"method","member":"getPicker","id":"method-getPicker","cls":"Ext.form.field.Picker"},{"type":"method","member":"onTriggerClick","id":"method-onTriggerClick","cls":"Ext.form.field.Picker"},{"type":"event","member":"collapse","id":"event-collapse","cls":"Ext.form.field.Picker"},{"type":"event","member":"expand","id":"event-expand","cls":"Ext.form.field.Picker"},{"type":"event","member":"select","id":"event-select","cls":"Ext.form.field.Picker"},{"type":"cls","member":"Radio","cls":"Ext.form.field.Radio","xtypes":{"widget":["radiofield","radio"]}},{"type":"method","member":"getGroupValue","id":"method-getGroupValue","cls":"Ext.form.field.Radio"},{"type":"method","member":"getSubmitValue","id":"method-getSubmitValue","cls":"Ext.form.field.Radio"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.form.field.Radio"},{"type":"cls","member":"Spinner","cls":"Ext.form.field.Spinner","xtypes":{"widget":["spinnerfield"]}},{"type":"property","member":"spinDownEl","id":"property-spinDownEl","cls":"Ext.form.field.Spinner"},{"type":"property","member":"spinUpEl","id":"property-spinUpEl","cls":"Ext.form.field.Spinner"},{"type":"cfg","member":"keyNavEnabled","id":"cfg-keyNavEnabled","cls":"Ext.form.field.Spinner"},{"type":"cfg","member":"mouseWheelEnabled","id":"cfg-mouseWheelEnabled","cls":"Ext.form.field.Spinner"},{"type":"cfg","member":"repeatTriggerClick","id":"cfg-repeatTriggerClick","cls":"Ext.form.field.Spinner"},{"type":"cfg","member":"spinDownEnabled","id":"cfg-spinDownEnabled","cls":"Ext.form.field.Spinner"},{"type":"cfg","member":"spinUpEnabled","id":"cfg-spinUpEnabled","cls":"Ext.form.field.Spinner"},{"type":"method","member":"onSpinDown","id":"method-onSpinDown","cls":"Ext.form.field.Spinner"},{"type":"method","member":"onSpinUp","id":"method-onSpinUp","cls":"Ext.form.field.Spinner"},{"type":"method","member":"setSpinDownEnabled","id":"method-setSpinDownEnabled","cls":"Ext.form.field.Spinner"},{"type":"method","member":"setSpinUpEnabled","id":"method-setSpinUpEnabled","cls":"Ext.form.field.Spinner"},{"type":"method","member":"spinDown","id":"method-spinDown","cls":"Ext.form.field.Spinner"},{"type":"method","member":"spinUp","id":"method-spinUp","cls":"Ext.form.field.Spinner"},{"type":"event","member":"spin","id":"event-spin","cls":"Ext.form.field.Spinner"},{"type":"event","member":"spindown","id":"event-spindown","cls":"Ext.form.field.Spinner"},{"type":"event","member":"spinup","id":"event-spinup","cls":"Ext.form.field.Spinner"},{"type":"cls","member":"Text","cls":"Ext.form.field.Text","xtypes":{"widget":["textfield"]}},{"type":"cfg","member":"allowBlank","id":"cfg-allowBlank","cls":"Ext.form.field.Text"},{"type":"cfg","member":"blankText","id":"cfg-blankText","cls":"Ext.form.field.Text"},{"type":"cfg","member":"disableKeyFilter","id":"cfg-disableKeyFilter","cls":"Ext.form.field.Text"},{"type":"cfg","member":"emptyCls","id":"cfg-emptyCls","cls":"Ext.form.field.Text"},{"type":"cfg","member":"emptyText","id":"cfg-emptyText","cls":"Ext.form.field.Text"},{"type":"cfg","member":"enableKeyEvents","id":"cfg-enableKeyEvents","cls":"Ext.form.field.Text"},{"type":"cfg","member":"enforceMaxLength","id":"cfg-enforceMaxLength","cls":"Ext.form.field.Text"},{"type":"cfg","member":"grow","id":"cfg-grow","cls":"Ext.form.field.Text"},{"type":"cfg","member":"growAppend","id":"cfg-growAppend","cls":"Ext.form.field.Text"},{"type":"cfg","member":"growMax","id":"cfg-growMax","cls":"Ext.form.field.Text"},{"type":"cfg","member":"growMin","id":"cfg-growMin","cls":"Ext.form.field.Text"},{"type":"cfg","member":"maskRe","id":"cfg-maskRe","cls":"Ext.form.field.Text"},{"type":"cfg","member":"maxLength","id":"cfg-maxLength","cls":"Ext.form.field.Text"},{"type":"cfg","member":"maxLengthText","id":"cfg-maxLengthText","cls":"Ext.form.field.Text"},{"type":"cfg","member":"minLength","id":"cfg-minLength","cls":"Ext.form.field.Text"},{"type":"cfg","member":"minLengthText","id":"cfg-minLengthText","cls":"Ext.form.field.Text"},{"type":"cfg","member":"regex","id":"cfg-regex","cls":"Ext.form.field.Text"},{"type":"cfg","member":"regexText","id":"cfg-regexText","cls":"Ext.form.field.Text"},{"type":"cfg","member":"selectOnFocus","id":"cfg-selectOnFocus","cls":"Ext.form.field.Text"},{"type":"cfg","member":"size","id":"cfg-size","cls":"Ext.form.field.Text"},{"type":"cfg","member":"stripCharsRe","id":"cfg-stripCharsRe","cls":"Ext.form.field.Text"},{"type":"cfg","member":"validator","id":"cfg-validator","cls":"Ext.form.field.Text"},{"type":"cfg","member":"vtype","id":"cfg-vtype","cls":"Ext.form.field.Text"},{"type":"cfg","member":"vtypeText","id":"cfg-vtypeText","cls":"Ext.form.field.Text"},{"type":"method","member":"autoSize","id":"method-autoSize","cls":"Ext.form.field.Text"},{"type":"method","member":"getBodyNaturalWidth","id":"method-getBodyNaturalWidth","cls":"Ext.form.field.Text"},{"type":"method","member":"getErrors","id":"method-getErrors","cls":"Ext.form.field.Text"},{"type":"method","member":"getRawValue","id":"method-getRawValue","cls":"Ext.form.field.Text"},{"type":"method","member":"processRawValue","id":"method-processRawValue","cls":"Ext.form.field.Text"},{"type":"method","member":"reset","id":"method-reset","cls":"Ext.form.field.Text"},{"type":"method","member":"selectText","id":"method-selectText","cls":"Ext.form.field.Text"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.form.field.Text"},{"type":"event","member":"autosize","id":"event-autosize","cls":"Ext.form.field.Text"},{"type":"event","member":"keydown","id":"event-keydown","cls":"Ext.form.field.Text"},{"type":"event","member":"keypress","id":"event-keypress","cls":"Ext.form.field.Text"},{"type":"event","member":"keyup","id":"event-keyup","cls":"Ext.form.field.Text"},{"type":"cls","member":"TextArea","cls":"Ext.form.field.TextArea","xtypes":{"widget":["textareafield","textarea"]}},{"type":"cfg","member":"cols","id":"cfg-cols","cls":"Ext.form.field.TextArea"},{"type":"cfg","member":"enterIsSpecial","id":"cfg-enterIsSpecial","cls":"Ext.form.field.TextArea"},{"type":"cfg","member":"growAppend","id":"cfg-growAppend","cls":"Ext.form.field.TextArea"},{"type":"cfg","member":"growMax","id":"cfg-growMax","cls":"Ext.form.field.TextArea"},{"type":"cfg","member":"growMin","id":"cfg-growMin","cls":"Ext.form.field.TextArea"},{"type":"cfg","member":"preventScrollbars","id":"cfg-preventScrollbars","cls":"Ext.form.field.TextArea"},{"type":"method","member":"autoSize","id":"method-autoSize","cls":"Ext.form.field.TextArea"},{"type":"method","member":"getBodyNaturalWidth","id":"method-getBodyNaturalWidth","cls":"Ext.form.field.TextArea"},{"type":"cls","member":"Time","cls":"Ext.form.field.Time","xtypes":{"widget":["timefield"]}},{"type":"cfg","member":"altFormats","id":"cfg-altFormats","cls":"Ext.form.field.Time"},{"type":"cfg","member":"format","id":"cfg-format","cls":"Ext.form.field.Time"},{"type":"cfg","member":"increment","id":"cfg-increment","cls":"Ext.form.field.Time"},{"type":"cfg","member":"invalidText","id":"cfg-invalidText","cls":"Ext.form.field.Time"},{"type":"cfg","member":"maxText","id":"cfg-maxText","cls":"Ext.form.field.Time"},{"type":"cfg","member":"maxValue","id":"cfg-maxValue","cls":"Ext.form.field.Time"},{"type":"cfg","member":"minText","id":"cfg-minText","cls":"Ext.form.field.Time"},{"type":"cfg","member":"minValue","id":"cfg-minValue","cls":"Ext.form.field.Time"},{"type":"cfg","member":"pickerMaxHeight","id":"cfg-pickerMaxHeight","cls":"Ext.form.field.Time"},{"type":"cfg","member":"selectOnTab","id":"cfg-selectOnTab","cls":"Ext.form.field.Time"},{"type":"cfg","member":"submitFormat","id":"cfg-submitFormat","cls":"Ext.form.field.Time"},{"type":"cfg","member":"triggerCls","id":"cfg-triggerCls","cls":"Ext.form.field.Time"},{"type":"method","member":"getErrors","id":"method-getErrors","cls":"Ext.form.field.Time"},{"type":"method","member":"setMaxValue","id":"method-setMaxValue","cls":"Ext.form.field.Time"},{"type":"method","member":"setMinValue","id":"method-setMinValue","cls":"Ext.form.field.Time"},{"type":"cls","member":"Trigger","cls":"Ext.form.field.Trigger","xtypes":{"widget":["triggerfield","trigger"]}},{"type":"property","member":"triggerEl","id":"property-triggerEl","cls":"Ext.form.field.Trigger"},{"type":"property","member":"triggerWrap","id":"property-triggerWrap","cls":"Ext.form.field.Trigger"},{"type":"cfg","member":"editable","id":"cfg-editable","cls":"Ext.form.field.Trigger"},{"type":"cfg","member":"hideTrigger","id":"cfg-hideTrigger","cls":"Ext.form.field.Trigger"},{"type":"cfg","member":"readOnly","id":"cfg-readOnly","cls":"Ext.form.field.Trigger"},{"type":"cfg","member":"repeatTriggerClick","id":"cfg-repeatTriggerClick","cls":"Ext.form.field.Trigger"},{"type":"cfg","member":"selectOnFocus","id":"cfg-selectOnFocus","cls":"Ext.form.field.Trigger"},{"type":"cfg","member":"triggerBaseCls","id":"cfg-triggerBaseCls","cls":"Ext.form.field.Trigger"},{"type":"cfg","member":"triggerCls","id":"cfg-triggerCls","cls":"Ext.form.field.Trigger"},{"type":"cfg","member":"triggerWrapCls","id":"cfg-triggerWrapCls","cls":"Ext.form.field.Trigger"},{"type":"method","member":"getTriggerWidth","id":"method-getTriggerWidth","cls":"Ext.form.field.Trigger"},{"type":"method","member":"onTriggerClick","id":"method-onTriggerClick","cls":"Ext.form.field.Trigger"},{"type":"method","member":"setEditable","id":"method-setEditable","cls":"Ext.form.field.Trigger"},{"type":"method","member":"setReadOnly","id":"method-setReadOnly","cls":"Ext.form.field.Trigger"},{"type":"cls","member":"VTypes","cls":"Ext.form.field.VTypes","xtypes":{}},{"type":"property","member":"alphaMask","id":"property-alphaMask","cls":"Ext.form.field.VTypes"},{"type":"property","member":"alphaText","id":"property-alphaText","cls":"Ext.form.field.VTypes"},{"type":"property","member":"alphanumMask","id":"property-alphanumMask","cls":"Ext.form.field.VTypes"},{"type":"property","member":"alphanumText","id":"property-alphanumText","cls":"Ext.form.field.VTypes"},{"type":"property","member":"emailMask","id":"property-emailMask","cls":"Ext.form.field.VTypes"},{"type":"property","member":"emailText","id":"property-emailText","cls":"Ext.form.field.VTypes"},{"type":"property","member":"urlText","id":"property-urlText","cls":"Ext.form.field.VTypes"},{"type":"method","member":"alpha","id":"method-alpha","cls":"Ext.form.field.VTypes"},{"type":"method","member":"alphanum","id":"method-alphanum","cls":"Ext.form.field.VTypes"},{"type":"method","member":"email","id":"method-email","cls":"Ext.form.field.VTypes"},{"type":"method","member":"url","id":"method-url","cls":"Ext.form.field.VTypes"},{"type":"cls","member":"FieldAncestor","cls":"Ext.form.FieldAncestor","xtypes":{}},{"type":"property","member":"onFieldErrorChange","id":"property-onFieldErrorChange","cls":"Ext.form.FieldAncestor"},{"type":"property","member":"onFieldValidityChange","id":"property-onFieldValidityChange","cls":"Ext.form.FieldAncestor"},{"type":"cfg","member":"fieldDefaults","id":"cfg-fieldDefaults","cls":"Ext.form.FieldAncestor"},{"type":"method","member":"initFieldAncestor","id":"method-initFieldAncestor","cls":"Ext.form.FieldAncestor"},{"type":"method","member":"onFieldAdded","id":"method-onFieldAdded","cls":"Ext.form.FieldAncestor"},{"type":"method","member":"onFieldRemoved","id":"method-onFieldRemoved","cls":"Ext.form.FieldAncestor"},{"type":"method","member":"onLabelableAdded","id":"method-onLabelableAdded","cls":"Ext.form.FieldAncestor"},{"type":"method","member":"onLabelableRemoved","id":"method-onLabelableRemoved","cls":"Ext.form.FieldAncestor"},{"type":"event","member":"fielderrorchange","id":"event-fielderrorchange","cls":"Ext.form.FieldAncestor"},{"type":"event","member":"fieldvaliditychange","id":"event-fieldvaliditychange","cls":"Ext.form.FieldAncestor"},{"type":"cls","member":"FieldContainer","cls":"Ext.form.FieldContainer","xtypes":{"widget":["fieldcontainer"]}},{"type":"cfg","member":"combineErrors","id":"cfg-combineErrors","cls":"Ext.form.FieldContainer"},{"type":"cfg","member":"combineLabels","id":"cfg-combineLabels","cls":"Ext.form.FieldContainer"},{"type":"cfg","member":"labelConnector","id":"cfg-labelConnector","cls":"Ext.form.FieldContainer"},{"type":"method","member":"getCombinedErrors","id":"method-getCombinedErrors","cls":"Ext.form.FieldContainer"},{"type":"method","member":"getFieldLabel","id":"method-getFieldLabel","cls":"Ext.form.FieldContainer"},{"type":"method","member":"onLabelableAdded","id":"method-onLabelableAdded","cls":"Ext.form.FieldContainer"},{"type":"method","member":"onLabelableRemoved","id":"method-onLabelableRemoved","cls":"Ext.form.FieldContainer"},{"type":"cls","member":"FieldSet","cls":"Ext.form.FieldSet","xtypes":{"widget":["fieldset"]}},{"type":"property","member":"checkboxCmp","id":"property-checkboxCmp","cls":"Ext.form.FieldSet"},{"type":"property","member":"legend","id":"property-legend","cls":"Ext.form.FieldSet"},{"type":"property","member":"toggleCmp","id":"property-toggleCmp","cls":"Ext.form.FieldSet"},{"type":"cfg","member":"baseCls","id":"cfg-baseCls","cls":"Ext.form.FieldSet"},{"type":"cfg","member":"checkboxName","id":"cfg-checkboxName","cls":"Ext.form.FieldSet"},{"type":"cfg","member":"checkboxToggle","id":"cfg-checkboxToggle","cls":"Ext.form.FieldSet"},{"type":"cfg","member":"collapsed","id":"cfg-collapsed","cls":"Ext.form.FieldSet"},{"type":"cfg","member":"collapsible","id":"cfg-collapsible","cls":"Ext.form.FieldSet"},{"type":"cfg","member":"layout","id":"cfg-layout","cls":"Ext.form.FieldSet"},{"type":"cfg","member":"title","id":"cfg-title","cls":"Ext.form.FieldSet"},{"type":"method","member":"collapse","id":"method-collapse","cls":"Ext.form.FieldSet"},{"type":"method","member":"createCheckboxCmp","id":"method-createCheckboxCmp","cls":"Ext.form.FieldSet"},{"type":"method","member":"createTitleCmp","id":"method-createTitleCmp","cls":"Ext.form.FieldSet"},{"type":"method","member":"createToggleCmp","id":"method-createToggleCmp","cls":"Ext.form.FieldSet"},{"type":"method","member":"expand","id":"method-expand","cls":"Ext.form.FieldSet"},{"type":"method","member":"setTitle","id":"method-setTitle","cls":"Ext.form.FieldSet"},{"type":"method","member":"toggle","id":"method-toggle","cls":"Ext.form.FieldSet"},{"type":"cls","member":"Label","cls":"Ext.form.Label","xtypes":{"widget":["label"]}},{"type":"cfg","member":"forId","id":"cfg-forId","cls":"Ext.form.Label"},{"type":"cfg","member":"html","id":"cfg-html","cls":"Ext.form.Label"},{"type":"cfg","member":"text","id":"cfg-text","cls":"Ext.form.Label"},{"type":"method","member":"setText","id":"method-setText","cls":"Ext.form.Label"},{"type":"cls","member":"Labelable","cls":"Ext.form.Labelable","xtypes":{}},{"type":"property","member":"bodyEl","id":"property-bodyEl","cls":"Ext.form.Labelable"},{"type":"property","member":"errorEl","id":"property-errorEl","cls":"Ext.form.Labelable"},{"type":"property","member":"isFieldLabelable","id":"property-isFieldLabelable","cls":"Ext.form.Labelable"},{"type":"property","member":"labelEl","id":"property-labelEl","cls":"Ext.form.Labelable"},{"type":"cfg","member":"activeError","id":"cfg-activeError","cls":"Ext.form.Labelable"},{"type":"cfg","member":"activeErrorsTpl","id":"cfg-activeErrorsTpl","cls":"Ext.form.Labelable"},{"type":"cfg","member":"autoFitErrors","id":"cfg-autoFitErrors","cls":"Ext.form.Labelable"},{"type":"cfg","member":"baseBodyCls","id":"cfg-baseBodyCls","cls":"Ext.form.Labelable"},{"type":"cfg","member":"clearCls","id":"cfg-clearCls","cls":"Ext.form.Labelable"},{"type":"cfg","member":"errorMsgCls","id":"cfg-errorMsgCls","cls":"Ext.form.Labelable"},{"type":"cfg","member":"fieldBodyCls","id":"cfg-fieldBodyCls","cls":"Ext.form.Labelable"},{"type":"cfg","member":"fieldLabel","id":"cfg-fieldLabel","cls":"Ext.form.Labelable"},{"type":"cfg","member":"formItemCls","id":"cfg-formItemCls","cls":"Ext.form.Labelable"},{"type":"cfg","member":"hideEmptyLabel","id":"cfg-hideEmptyLabel","cls":"Ext.form.Labelable"},{"type":"cfg","member":"hideLabel","id":"cfg-hideLabel","cls":"Ext.form.Labelable"},{"type":"cfg","member":"invalidCls","id":"cfg-invalidCls","cls":"Ext.form.Labelable"},{"type":"cfg","member":"labelAlign","id":"cfg-labelAlign","cls":"Ext.form.Labelable"},{"type":"cfg","member":"labelCls","id":"cfg-labelCls","cls":"Ext.form.Labelable"},{"type":"cfg","member":"labelClsExtra","id":"cfg-labelClsExtra","cls":"Ext.form.Labelable"},{"type":"cfg","member":"labelPad","id":"cfg-labelPad","cls":"Ext.form.Labelable"},{"type":"cfg","member":"labelSeparator","id":"cfg-labelSeparator","cls":"Ext.form.Labelable"},{"type":"cfg","member":"labelStyle","id":"cfg-labelStyle","cls":"Ext.form.Labelable"},{"type":"cfg","member":"labelWidth","id":"cfg-labelWidth","cls":"Ext.form.Labelable"},{"type":"cfg","member":"labelableRenderTpl","id":"cfg-labelableRenderTpl","cls":"Ext.form.Labelable"},{"type":"cfg","member":"msgTarget","id":"cfg-msgTarget","cls":"Ext.form.Labelable"},{"type":"cfg","member":"preventMark","id":"cfg-preventMark","cls":"Ext.form.Labelable"},{"type":"method","member":"getActiveError","id":"method-getActiveError","cls":"Ext.form.Labelable"},{"type":"method","member":"getActiveErrors","id":"method-getActiveErrors","cls":"Ext.form.Labelable"},{"type":"method","member":"getBodyNaturalWidth","id":"method-getBodyNaturalWidth","cls":"Ext.form.Labelable"},{"type":"method","member":"getFieldLabel","id":"method-getFieldLabel","cls":"Ext.form.Labelable"},{"type":"method","member":"getInputId","id":"method-getInputId","cls":"Ext.form.Labelable"},{"type":"method","member":"getLabelableRenderData","id":"method-getLabelableRenderData","cls":"Ext.form.Labelable"},{"type":"method","member":"getSubTplMarkup","id":"method-getSubTplMarkup","cls":"Ext.form.Labelable"},{"type":"method","member":"hasActiveError","id":"method-hasActiveError","cls":"Ext.form.Labelable"},{"type":"method","member":"initLabelable","id":"method-initLabelable","cls":"Ext.form.Labelable"},{"type":"method","member":"setActiveError","id":"method-setActiveError","cls":"Ext.form.Labelable"},{"type":"method","member":"setActiveErrors","id":"method-setActiveErrors","cls":"Ext.form.Labelable"},{"type":"method","member":"setFieldDefaults","id":"method-setFieldDefaults","cls":"Ext.form.Labelable"},{"type":"method","member":"unsetActiveError","id":"method-unsetActiveError","cls":"Ext.form.Labelable"},{"type":"event","member":"errorchange","id":"event-errorchange","cls":"Ext.form.Labelable"},{"type":"cls","member":"Panel","cls":"Ext.form.Panel","xtypes":{"widget":["form"]}},{"type":"cfg","member":"layout","id":"cfg-layout","cls":"Ext.form.Panel"},{"type":"cfg","member":"pollForChanges","id":"cfg-pollForChanges","cls":"Ext.form.Panel"},{"type":"cfg","member":"pollInterval","id":"cfg-pollInterval","cls":"Ext.form.Panel"},{"type":"method","member":"checkChange","id":"method-checkChange","cls":"Ext.form.Panel"},{"type":"method","member":"getForm","id":"method-getForm","cls":"Ext.form.Panel"},{"type":"method","member":"getRecord","id":"method-getRecord","cls":"Ext.form.Panel"},{"type":"method","member":"getValues","id":"method-getValues","cls":"Ext.form.Panel"},{"type":"method","member":"load","id":"method-load","cls":"Ext.form.Panel"},{"type":"method","member":"loadRecord","id":"method-loadRecord","cls":"Ext.form.Panel"},{"type":"method","member":"startPolling","id":"method-startPolling","cls":"Ext.form.Panel"},{"type":"method","member":"stopPolling","id":"method-stopPolling","cls":"Ext.form.Panel"},{"type":"method","member":"submit","id":"method-submit","cls":"Ext.form.Panel"},{"type":"cls","member":"RadioGroup","cls":"Ext.form.RadioGroup","xtypes":{"widget":["radiogroup"]}},{"type":"cfg","member":"allowBlank","id":"cfg-allowBlank","cls":"Ext.form.RadioGroup"},{"type":"cfg","member":"blankText","id":"cfg-blankText","cls":"Ext.form.RadioGroup"},{"type":"cfg","member":"items","id":"cfg-items","cls":"Ext.form.RadioGroup"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.form.RadioGroup"},{"type":"cls","member":"RadioManager","cls":"Ext.form.RadioManager","xtypes":{}},{"type":"cls","member":"CellEditor","cls":"Ext.grid.CellEditor","xtypes":{}},{"type":"cls","member":"Action","cls":"Ext.grid.column.Action","xtypes":{"widget":["actioncolumn"]}},{"type":"property","member":"items","id":"property-items","cls":"Ext.grid.column.Action"},{"type":"cfg","member":"altText","id":"cfg-altText","cls":"Ext.grid.column.Action"},{"type":"cfg","member":"getClass","id":"cfg-getClass","cls":"Ext.grid.column.Action"},{"type":"cfg","member":"handler","id":"cfg-handler","cls":"Ext.grid.column.Action"},{"type":"cfg","member":"icon","id":"cfg-icon","cls":"Ext.grid.column.Action"},{"type":"cfg","member":"iconCls","id":"cfg-iconCls","cls":"Ext.grid.column.Action"},{"type":"cfg","member":"items","id":"cfg-items","cls":"Ext.grid.column.Action"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.grid.column.Action"},{"type":"cfg","member":"stopSelection","id":"cfg-stopSelection","cls":"Ext.grid.column.Action"},{"type":"cfg","member":"tooltip","id":"cfg-tooltip","cls":"Ext.grid.column.Action"},{"type":"method","member":"disableAction","id":"method-disableAction","cls":"Ext.grid.column.Action"},{"type":"method","member":"enableAction","id":"method-enableAction","cls":"Ext.grid.column.Action"},{"type":"cls","member":"Boolean","cls":"Ext.grid.column.Boolean","xtypes":{"widget":["booleancolumn"]}},{"type":"cfg","member":"falseText","id":"cfg-falseText","cls":"Ext.grid.column.Boolean"},{"type":"cfg","member":"trueText","id":"cfg-trueText","cls":"Ext.grid.column.Boolean"},{"type":"cfg","member":"undefinedText","id":"cfg-undefinedText","cls":"Ext.grid.column.Boolean"},{"type":"cls","member":"Column","cls":"Ext.grid.column.Column","xtypes":{"widget":["gridcolumn"]}},{"type":"property","member":"textEl","id":"property-textEl","cls":"Ext.grid.column.Column"},{"type":"property","member":"triggerEl","id":"property-triggerEl","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"align","id":"cfg-align","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"columns","id":"cfg-columns","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"dataIndex","id":"cfg-dataIndex","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"draggable","id":"cfg-draggable","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"editor","id":"cfg-editor","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"field","id":"cfg-field","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"fixed","id":"cfg-fixed","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"groupable","id":"cfg-groupable","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"hideable","id":"cfg-hideable","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"menuDisabled","id":"cfg-menuDisabled","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"renderer","id":"cfg-renderer","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"resizable","id":"cfg-resizable","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"sortable","id":"cfg-sortable","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"tdCls","id":"cfg-tdCls","cls":"Ext.grid.column.Column"},{"type":"cfg","member":"text","id":"cfg-text","cls":"Ext.grid.column.Column"},{"type":"method","member":"getEditor","id":"method-getEditor","cls":"Ext.grid.column.Column"},{"type":"method","member":"getIndex","id":"method-getIndex","cls":"Ext.grid.column.Column"},{"type":"method","member":"getSortParam","id":"method-getSortParam","cls":"Ext.grid.column.Column"},{"type":"method","member":"setEditor","id":"method-setEditor","cls":"Ext.grid.column.Column"},{"type":"method","member":"setText","id":"method-setText","cls":"Ext.grid.column.Column"},{"type":"method","member":"setWidth","id":"method-setWidth","cls":"Ext.grid.column.Column"},{"type":"cls","member":"Date","cls":"Ext.grid.column.Date","xtypes":{"widget":["datecolumn"]}},{"type":"cfg","member":"format","id":"cfg-format","cls":"Ext.grid.column.Date"},{"type":"cls","member":"Number","cls":"Ext.grid.column.Number","xtypes":{"widget":["numbercolumn"]}},{"type":"cfg","member":"format","id":"cfg-format","cls":"Ext.grid.column.Number"},{"type":"cls","member":"Template","cls":"Ext.grid.column.Template","xtypes":{"widget":["templatecolumn"]}},{"type":"cfg","member":"tpl","id":"cfg-tpl","cls":"Ext.grid.column.Template"},{"type":"cls","member":"ColumnLayout","cls":"Ext.grid.ColumnLayout","xtypes":{"layout":["gridcolumn"]}},{"type":"cls","member":"AbstractSummary","cls":"Ext.grid.feature.AbstractSummary","xtypes":{"feature":["abstractsummary"]}},{"type":"cfg","member":"showSummaryRow","id":"cfg-showSummaryRow","cls":"Ext.grid.feature.AbstractSummary"},{"type":"method","member":"getColumnValue","id":"method-getColumnValue","cls":"Ext.grid.feature.AbstractSummary"},{"type":"method","member":"toggleSummaryRow","id":"method-toggleSummaryRow","cls":"Ext.grid.feature.AbstractSummary"},{"type":"cls","member":"Chunking","cls":"Ext.grid.feature.Chunking","xtypes":{"feature":["chunking"]}},{"type":"cls","member":"Feature","cls":"Ext.grid.feature.Feature","xtypes":{"feature":["feature"]}},{"type":"property","member":"collectData","id":"property-collectData","cls":"Ext.grid.feature.Feature"},{"type":"property","member":"eventPrefix","id":"property-eventPrefix","cls":"Ext.grid.feature.Feature"},{"type":"property","member":"eventSelector","id":"property-eventSelector","cls":"Ext.grid.feature.Feature"},{"type":"property","member":"grid","id":"property-grid","cls":"Ext.grid.feature.Feature"},{"type":"property","member":"hasFeatureEvent","id":"property-hasFeatureEvent","cls":"Ext.grid.feature.Feature"},{"type":"property","member":"view","id":"property-view","cls":"Ext.grid.feature.Feature"},{"type":"method","member":"attachEvents","id":"method-attachEvents","cls":"Ext.grid.feature.Feature"},{"type":"method","member":"disable","id":"method-disable","cls":"Ext.grid.feature.Feature"},{"type":"method","member":"enable","id":"method-enable","cls":"Ext.grid.feature.Feature"},{"type":"method","member":"getAdditionalData","id":"method-getAdditionalData","cls":"Ext.grid.feature.Feature"},{"type":"method","member":"getFireEventArgs","id":"method-getFireEventArgs","cls":"Ext.grid.feature.Feature"},{"type":"method","member":"getMetaRowTplFragments","id":"method-getMetaRowTplFragments","cls":"Ext.grid.feature.Feature"},{"type":"method","member":"mutateMetaRowTpl","id":"method-mutateMetaRowTpl","cls":"Ext.grid.feature.Feature"},{"type":"cls","member":"Grouping","cls":"Ext.grid.feature.Grouping","xtypes":{"feature":["grouping"]}},{"type":"cfg","member":"depthToIndent","id":"cfg-depthToIndent","cls":"Ext.grid.feature.Grouping"},{"type":"cfg","member":"enableGroupingMenu","id":"cfg-enableGroupingMenu","cls":"Ext.grid.feature.Grouping"},{"type":"cfg","member":"enableNoGroups","id":"cfg-enableNoGroups","cls":"Ext.grid.feature.Grouping"},{"type":"cfg","member":"groupByText","id":"cfg-groupByText","cls":"Ext.grid.feature.Grouping"},{"type":"cfg","member":"groupHeaderTpl","id":"cfg-groupHeaderTpl","cls":"Ext.grid.feature.Grouping"},{"type":"cfg","member":"hideGroupedHeader","id":"cfg-hideGroupedHeader","cls":"Ext.grid.feature.Grouping"},{"type":"cfg","member":"showGroupsText","id":"cfg-showGroupsText","cls":"Ext.grid.feature.Grouping"},{"type":"cfg","member":"startCollapsed","id":"cfg-startCollapsed","cls":"Ext.grid.feature.Grouping"},{"type":"event","member":"groupclick","id":"event-groupclick","cls":"Ext.grid.feature.Grouping"},{"type":"event","member":"groupcollapse","id":"event-groupcollapse","cls":"Ext.grid.feature.Grouping"},{"type":"event","member":"groupcontextmenu","id":"event-groupcontextmenu","cls":"Ext.grid.feature.Grouping"},{"type":"event","member":"groupdblclick","id":"event-groupdblclick","cls":"Ext.grid.feature.Grouping"},{"type":"event","member":"groupexpand","id":"event-groupexpand","cls":"Ext.grid.feature.Grouping"},{"type":"cls","member":"GroupingSummary","cls":"Ext.grid.feature.GroupingSummary","xtypes":{"feature":["groupingsummary"]}},{"type":"cfg","member":"remoteRoot","id":"cfg-remoteRoot","cls":"Ext.grid.feature.GroupingSummary"},{"type":"cls","member":"RowBody","cls":"Ext.grid.feature.RowBody","xtypes":{"feature":["rowbody"]}},{"type":"method","member":"getAdditionalData","id":"method-getAdditionalData","cls":"Ext.grid.feature.RowBody"},{"type":"cls","member":"RowWrap","cls":"Ext.grid.feature.RowWrap","xtypes":{"feature":["rowwrap"]}},{"type":"cls","member":"Summary","cls":"Ext.grid.feature.Summary","xtypes":{"feature":["summary"]}},{"type":"cls","member":"Container","cls":"Ext.grid.header.Container","xtypes":{"widget":["headercontainer"]}},{"type":"property","member":"isGroupHeader","id":"property-isGroupHeader","cls":"Ext.grid.header.Container"},{"type":"cfg","member":"defaultWidth","id":"cfg-defaultWidth","cls":"Ext.grid.header.Container"},{"type":"cfg","member":"sortable","id":"cfg-sortable","cls":"Ext.grid.header.Container"},{"type":"cfg","member":"weight","id":"cfg-weight","cls":"Ext.grid.header.Container"},{"type":"method","member":"getColumnCount","id":"method-getColumnCount","cls":"Ext.grid.header.Container"},{"type":"method","member":"getColumnMenu","id":"method-getColumnMenu","cls":"Ext.grid.header.Container"},{"type":"method","member":"getFullWidth","id":"method-getFullWidth","cls":"Ext.grid.header.Container"},{"type":"method","member":"getGridColumns","id":"method-getGridColumns","cls":"Ext.grid.header.Container"},{"type":"method","member":"getHeaderAtIndex","id":"method-getHeaderAtIndex","cls":"Ext.grid.header.Container"},{"type":"method","member":"getHeaderIndex","id":"method-getHeaderIndex","cls":"Ext.grid.header.Container"},{"type":"method","member":"getMenuItems","id":"method-getMenuItems","cls":"Ext.grid.header.Container"},{"type":"method","member":"getVisibleGridColumns","id":"method-getVisibleGridColumns","cls":"Ext.grid.header.Container"},{"type":"method","member":"prepareData","id":"method-prepareData","cls":"Ext.grid.header.Container"},{"type":"event","member":"columnhide","id":"event-columnhide","cls":"Ext.grid.header.Container"},{"type":"event","member":"columnmove","id":"event-columnmove","cls":"Ext.grid.header.Container"},{"type":"event","member":"columnresize","id":"event-columnresize","cls":"Ext.grid.header.Container"},{"type":"event","member":"columnshow","id":"event-columnshow","cls":"Ext.grid.header.Container"},{"type":"event","member":"headerclick","id":"event-headerclick","cls":"Ext.grid.header.Container"},{"type":"event","member":"headertriggerclick","id":"event-headertriggerclick","cls":"Ext.grid.header.Container"},{"type":"event","member":"menucreate","id":"event-menucreate","cls":"Ext.grid.header.Container"},{"type":"event","member":"sortchange","id":"event-sortchange","cls":"Ext.grid.header.Container"},{"type":"cls","member":"DragZone","cls":"Ext.grid.header.DragZone","xtypes":{}},{"type":"cls","member":"DropZone","cls":"Ext.grid.header.DropZone","xtypes":{}},{"type":"cls","member":"Lockable","cls":"Ext.grid.Lockable","xtypes":{}},{"type":"cfg","member":"lockedViewConfig","id":"cfg-lockedViewConfig","cls":"Ext.grid.Lockable"},{"type":"cfg","member":"normalViewConfig","id":"cfg-normalViewConfig","cls":"Ext.grid.Lockable"},{"type":"cfg","member":"subGridXType","id":"cfg-subGridXType","cls":"Ext.grid.Lockable"},{"type":"cfg","member":"syncRowHeight","id":"cfg-syncRowHeight","cls":"Ext.grid.Lockable"},{"type":"event","member":"lockcolumn","id":"event-lockcolumn","cls":"Ext.grid.Lockable"},{"type":"event","member":"unlockcolumn","id":"event-unlockcolumn","cls":"Ext.grid.Lockable"},{"type":"cls","member":"LockingView","cls":"Ext.grid.LockingView","xtypes":{}},{"type":"cls","member":"PagingScroller","cls":"Ext.grid.PagingScroller","xtypes":{"widget":["paginggridscroller"]}},{"type":"cfg","member":"percentageFromEdge","id":"cfg-percentageFromEdge","cls":"Ext.grid.PagingScroller"},{"type":"cfg","member":"scrollToLoadBuffer","id":"cfg-scrollToLoadBuffer","cls":"Ext.grid.PagingScroller"},{"type":"cls","member":"Panel","cls":"Ext.grid.Panel","xtypes":{"widget":["gridpanel","grid"]}},{"type":"cfg","member":"columnLines","id":"cfg-columnLines","cls":"Ext.grid.Panel"},{"type":"cls","member":"CellEditing","cls":"Ext.grid.plugin.CellEditing","xtypes":{"plugin":["cellediting"]}},{"type":"method","member":"cancelEdit","id":"method-cancelEdit","cls":"Ext.grid.plugin.CellEditing"},{"type":"method","member":"startEdit","id":"method-startEdit","cls":"Ext.grid.plugin.CellEditing"},{"type":"method","member":"startEditByPosition","id":"method-startEditByPosition","cls":"Ext.grid.plugin.CellEditing"},{"type":"event","member":"beforeedit","id":"event-beforeedit","cls":"Ext.grid.plugin.CellEditing"},{"type":"event","member":"edit","id":"event-edit","cls":"Ext.grid.plugin.CellEditing"},{"type":"event","member":"validateedit","id":"event-validateedit","cls":"Ext.grid.plugin.CellEditing"},{"type":"cls","member":"DragDrop","cls":"Ext.grid.plugin.DragDrop","xtypes":{"plugin":["gridviewdragdrop"]}},{"type":"cfg","member":"ddGroup","id":"cfg-ddGroup","cls":"Ext.grid.plugin.DragDrop"},{"type":"cfg","member":"dragGroup","id":"cfg-dragGroup","cls":"Ext.grid.plugin.DragDrop"},{"type":"cfg","member":"dropGroup","id":"cfg-dropGroup","cls":"Ext.grid.plugin.DragDrop"},{"type":"cfg","member":"enableDrag","id":"cfg-enableDrag","cls":"Ext.grid.plugin.DragDrop"},{"type":"cfg","member":"enableDrop","id":"cfg-enableDrop","cls":"Ext.grid.plugin.DragDrop"},{"type":"event","member":"beforedrop","id":"event-beforedrop","cls":"Ext.grid.plugin.DragDrop"},{"type":"event","member":"drop","id":"event-drop","cls":"Ext.grid.plugin.DragDrop"},{"type":"cls","member":"Editing","cls":"Ext.grid.plugin.Editing","xtypes":{"editing":["editing"]}},{"type":"cfg","member":"clicksToEdit","id":"cfg-clicksToEdit","cls":"Ext.grid.plugin.Editing"},{"type":"method","member":"cancelEdit","id":"method-cancelEdit","cls":"Ext.grid.plugin.Editing"},{"type":"method","member":"completeEdit","id":"method-completeEdit","cls":"Ext.grid.plugin.Editing"},{"type":"method","member":"startEdit","id":"method-startEdit","cls":"Ext.grid.plugin.Editing"},{"type":"cls","member":"HeaderReorderer","cls":"Ext.grid.plugin.HeaderReorderer","xtypes":{"plugin":["gridheaderreorderer"]}},{"type":"cls","member":"HeaderResizer","cls":"Ext.grid.plugin.HeaderResizer","xtypes":{"plugin":["gridheaderresizer"]}},{"type":"cfg","member":"dynamic","id":"cfg-dynamic","cls":"Ext.grid.plugin.HeaderResizer"},{"type":"cls","member":"RowEditing","cls":"Ext.grid.plugin.RowEditing","xtypes":{"plugin":["rowediting"]}},{"type":"cfg","member":"autoCancel","id":"cfg-autoCancel","cls":"Ext.grid.plugin.RowEditing"},{"type":"cfg","member":"clicksToMoveEditor","id":"cfg-clicksToMoveEditor","cls":"Ext.grid.plugin.RowEditing"},{"type":"cfg","member":"errorSummary","id":"cfg-errorSummary","cls":"Ext.grid.plugin.RowEditing"},{"type":"method","member":"startEdit","id":"method-startEdit","cls":"Ext.grid.plugin.RowEditing"},{"type":"event","member":"beforeedit","id":"event-beforeedit","cls":"Ext.grid.plugin.RowEditing"},{"type":"event","member":"canceledit","id":"event-canceledit","cls":"Ext.grid.plugin.RowEditing"},{"type":"event","member":"edit","id":"event-edit","cls":"Ext.grid.plugin.RowEditing"},{"type":"event","member":"validateedit","id":"event-validateedit","cls":"Ext.grid.plugin.RowEditing"},{"type":"cls","member":"Grid","cls":"Ext.grid.property.Grid","xtypes":{"widget":["propertygrid"]}},{"type":"cfg","member":"customEditors","id":"cfg-customEditors","cls":"Ext.grid.property.Grid"},{"type":"cfg","member":"customRenderers","id":"cfg-customRenderers","cls":"Ext.grid.property.Grid"},{"type":"cfg","member":"nameColumnWidth","id":"cfg-nameColumnWidth","cls":"Ext.grid.property.Grid"},{"type":"cfg","member":"nameField","id":"cfg-nameField","cls":"Ext.grid.property.Grid"},{"type":"cfg","member":"propertyNames","id":"cfg-propertyNames","cls":"Ext.grid.property.Grid"},{"type":"cfg","member":"source","id":"cfg-source","cls":"Ext.grid.property.Grid"},{"type":"cfg","member":"valueField","id":"cfg-valueField","cls":"Ext.grid.property.Grid"},{"type":"method","member":"getSource","id":"method-getSource","cls":"Ext.grid.property.Grid"},{"type":"method","member":"removeProperty","id":"method-removeProperty","cls":"Ext.grid.property.Grid"},{"type":"method","member":"setProperty","id":"method-setProperty","cls":"Ext.grid.property.Grid"},{"type":"method","member":"setSource","id":"method-setSource","cls":"Ext.grid.property.Grid"},{"type":"event","member":"beforepropertychange","id":"event-beforepropertychange","cls":"Ext.grid.property.Grid"},{"type":"event","member":"propertychange","id":"event-propertychange","cls":"Ext.grid.property.Grid"},{"type":"cls","member":"HeaderContainer","cls":"Ext.grid.property.HeaderContainer","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.grid.property.HeaderContainer"},{"type":"cls","member":"Property","cls":"Ext.grid.property.Property","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.grid.property.Property"},{"type":"cls","member":"Store","cls":"Ext.grid.property.Store","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.grid.property.Store"},{"type":"cls","member":"RowEditor","cls":"Ext.grid.RowEditor","xtypes":{}},{"type":"method","member":"startEdit","id":"method-startEdit","cls":"Ext.grid.RowEditor"},{"type":"cls","member":"RowNumberer","cls":"Ext.grid.RowNumberer","xtypes":{"widget":["rownumberer"]}},{"type":"cfg","member":"text","id":"cfg-text","cls":"Ext.grid.RowNumberer"},{"type":"cfg","member":"width","id":"cfg-width","cls":"Ext.grid.RowNumberer"},{"type":"cls","member":"Scroller","cls":"Ext.grid.Scroller","xtypes":{"widget":["gridscroller"]}},{"type":"method","member":"scrollByDeltaX","id":"method-scrollByDeltaX","cls":"Ext.grid.Scroller"},{"type":"method","member":"scrollByDeltaY","id":"method-scrollByDeltaY","cls":"Ext.grid.Scroller"},{"type":"method","member":"scrollToTop","id":"method-scrollToTop","cls":"Ext.grid.Scroller"},{"type":"method","member":"setScrollLeft","id":"method-setScrollLeft","cls":"Ext.grid.Scroller"},{"type":"method","member":"setScrollTop","id":"method-setScrollTop","cls":"Ext.grid.Scroller"},{"type":"cls","member":"View","cls":"Ext.grid.View","xtypes":{"widget":["gridview"]}},{"type":"cfg","member":"stripeRows","id":"cfg-stripeRows","cls":"Ext.grid.View"},{"type":"cls","member":"Img","cls":"Ext.Img","xtypes":{"widget":["image","imagecomponent"]}},{"type":"cfg","member":"src","id":"cfg-src","cls":"Ext.Img"},{"type":"method","member":"setSrc","id":"method-setSrc","cls":"Ext.Img"},{"type":"cls","member":"Layer","cls":"Ext.Layer","xtypes":{}},{"type":"cfg","member":"cls","id":"cfg-cls","cls":"Ext.Layer"},{"type":"cfg","member":"constrain","id":"cfg-constrain","cls":"Ext.Layer"},{"type":"cfg","member":"dh","id":"cfg-dh","cls":"Ext.Layer"},{"type":"cfg","member":"hideMode","id":"cfg-hideMode","cls":"Ext.Layer"},{"type":"cfg","member":"shadow","id":"cfg-shadow","cls":"Ext.Layer"},{"type":"cfg","member":"shadowOffset","id":"cfg-shadowOffset","cls":"Ext.Layer"},{"type":"cfg","member":"shim","id":"cfg-shim","cls":"Ext.Layer"},{"type":"cfg","member":"useDisplay","id":"cfg-useDisplay","cls":"Ext.Layer"},{"type":"cfg","member":"visibilityCls","id":"cfg-visibilityCls","cls":"Ext.Layer"},{"type":"cfg","member":"zindex","id":"cfg-zindex","cls":"Ext.Layer"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.Layer"},{"type":"method","member":"setZIndex","id":"method-setZIndex","cls":"Ext.Layer"},{"type":"cls","member":"Body","cls":"Ext.layout.component.Body","xtypes":{"layout":["body"]}},{"type":"cls","member":"BoundList","cls":"Ext.layout.component.BoundList","xtypes":{"layout":["boundlist"]}},{"type":"cls","member":"Button","cls":"Ext.layout.component.Button","xtypes":{"layout":["button"]}},{"type":"method","member":"onLayout","id":"method-onLayout","cls":"Ext.layout.component.Button"},{"type":"cls","member":"Dock","cls":"Ext.layout.component.Dock","xtypes":{"layout":["dock"]}},{"type":"cls","member":"Editor","cls":"Ext.layout.component.Editor","xtypes":{"layout":["editor"]}},{"type":"cls","member":"Field","cls":"Ext.layout.component.field.Field","xtypes":{"layout":["field"]}},{"type":"property","member":"elementId","id":"property-elementId","cls":"Ext.layout.component.field.Field"},{"type":"property","member":"errorStrategies","id":"property-errorStrategies","cls":"Ext.layout.component.field.Field"},{"type":"property","member":"labelStrategies","id":"property-labelStrategies","cls":"Ext.layout.component.field.Field"},{"type":"property","member":"left","id":"property-left","cls":"Ext.layout.component.field.Field"},{"type":"property","member":"qtip","id":"property-qtip","cls":"Ext.layout.component.field.Field"},{"type":"property","member":"right","id":"property-right","cls":"Ext.layout.component.field.Field"},{"type":"property","member":"side","id":"property-side","cls":"Ext.layout.component.field.Field"},{"type":"property","member":"sizeBodyContents","id":"property-sizeBodyContents","cls":"Ext.layout.component.field.Field"},{"type":"property","member":"title","id":"property-title","cls":"Ext.layout.component.field.Field"},{"type":"property","member":"top","id":"property-top","cls":"Ext.layout.component.field.Field"},{"type":"property","member":"under","id":"property-under","cls":"Ext.layout.component.field.Field"},{"type":"method","member":"destroyTip","id":"method-destroyTip","cls":"Ext.layout.component.field.Field"},{"type":"method","member":"getErrorStrategy","id":"method-getErrorStrategy","cls":"Ext.layout.component.field.Field"},{"type":"method","member":"getLabelStrategy","id":"method-getLabelStrategy","cls":"Ext.layout.component.field.Field"},{"type":"method","member":"initTip","id":"method-initTip","cls":"Ext.layout.component.field.Field"},{"type":"method","member":"sizeBody","id":"method-sizeBody","cls":"Ext.layout.component.field.Field"},{"type":"cls","member":"File","cls":"Ext.layout.component.field.File","xtypes":{"layout":["filefield"]}},{"type":"cls","member":"HtmlEditor","cls":"Ext.layout.component.field.HtmlEditor","xtypes":{"layout":["htmleditor"]}},{"type":"cls","member":"Slider","cls":"Ext.layout.component.field.Slider","xtypes":{"layout":["sliderfield"]}},{"type":"cls","member":"Text","cls":"Ext.layout.component.field.Text","xtypes":{"layout":["textfield"]}},{"type":"method","member":"adjustForGrow","id":"method-adjustForGrow","cls":"Ext.layout.component.field.Text"},{"type":"method","member":"beforeLayout","id":"method-beforeLayout","cls":"Ext.layout.component.field.Text"},{"type":"method","member":"sizeBodyContents","id":"method-sizeBodyContents","cls":"Ext.layout.component.field.Text"},{"type":"cls","member":"TextArea","cls":"Ext.layout.component.field.TextArea","xtypes":{"layout":["textareafield"]}},{"type":"method","member":"adjustForGrow","id":"method-adjustForGrow","cls":"Ext.layout.component.field.TextArea"},{"type":"cls","member":"Trigger","cls":"Ext.layout.component.field.Trigger","xtypes":{"layout":["triggerfield"]}},{"type":"cls","member":"FieldSet","cls":"Ext.layout.component.FieldSet","xtypes":{"layout":["fieldset"]}},{"type":"cls","member":"ProgressBar","cls":"Ext.layout.component.ProgressBar","xtypes":{"layout":["progressbar"]}},{"type":"cls","member":"Tab","cls":"Ext.layout.component.Tab","xtypes":{"layout":["tab"]}},{"type":"cls","member":"Tip","cls":"Ext.layout.component.Tip","xtypes":{"layout":["tip"]}},{"type":"cls","member":"Absolute","cls":"Ext.layout.container.Absolute","xtypes":{"layout":["absolute"]}},{"type":"cls","member":"Accordion","cls":"Ext.layout.container.Accordion","xtypes":{"layout":["accordion"]}},{"type":"cfg","member":"activeOnTop","id":"cfg-activeOnTop","cls":"Ext.layout.container.Accordion"},{"type":"cfg","member":"animate","id":"cfg-animate","cls":"Ext.layout.container.Accordion"},{"type":"cfg","member":"autoWidth","id":"cfg-autoWidth","cls":"Ext.layout.container.Accordion"},{"type":"cfg","member":"collapseFirst","id":"cfg-collapseFirst","cls":"Ext.layout.container.Accordion"},{"type":"cfg","member":"fill","id":"cfg-fill","cls":"Ext.layout.container.Accordion"},{"type":"cfg","member":"hideCollapseTool","id":"cfg-hideCollapseTool","cls":"Ext.layout.container.Accordion"},{"type":"cfg","member":"multi","id":"cfg-multi","cls":"Ext.layout.container.Accordion"},{"type":"cfg","member":"titleCollapse","id":"cfg-titleCollapse","cls":"Ext.layout.container.Accordion"},{"type":"cls","member":"Anchor","cls":"Ext.layout.container.Anchor","xtypes":{"layout":["anchor"]}},{"type":"cfg","member":"anchor","id":"cfg-anchor","cls":"Ext.layout.container.Anchor"},{"type":"cfg","member":"defaultAnchor","id":"cfg-defaultAnchor","cls":"Ext.layout.container.Anchor"},{"type":"cls","member":"Border","cls":"Ext.layout.container.Border","xtypes":{"layout":["border"]}},{"type":"method","member":"getPlaceholder","id":"method-getPlaceholder","cls":"Ext.layout.container.Border"},{"type":"cls","member":"Box","cls":"Ext.layout.container.Box","xtypes":{"layout":["box"]}},{"type":"cfg","member":"animate","id":"cfg-animate","cls":"Ext.layout.container.Box"},{"type":"cfg","member":"clearInnerCtOnLayout","id":"cfg-clearInnerCtOnLayout","cls":"Ext.layout.container.Box"},{"type":"cfg","member":"defaultMargins","id":"cfg-defaultMargins","cls":"Ext.layout.container.Box"},{"type":"cfg","member":"flex","id":"cfg-flex","cls":"Ext.layout.container.Box"},{"type":"cfg","member":"pack","id":"cfg-pack","cls":"Ext.layout.container.Box"},{"type":"cfg","member":"padding","id":"cfg-padding","cls":"Ext.layout.container.Box"},{"type":"cfg","member":"shrinkToFit","id":"cfg-shrinkToFit","cls":"Ext.layout.container.Box"},{"type":"method","member":"updateChildBoxes","id":"method-updateChildBoxes","cls":"Ext.layout.container.Box"},{"type":"cls","member":"Menu","cls":"Ext.layout.container.boxOverflow.Menu","xtypes":{}},{"type":"property","member":"menuItems","id":"property-menuItems","cls":"Ext.layout.container.boxOverflow.Menu"},{"type":"property","member":"noItemsMenuText","id":"property-noItemsMenuText","cls":"Ext.layout.container.boxOverflow.Menu"},{"type":"cfg","member":"afterCtCls","id":"cfg-afterCtCls","cls":"Ext.layout.container.boxOverflow.Menu"},{"type":"cls","member":"None","cls":"Ext.layout.container.boxOverflow.None","xtypes":{}},{"type":"cls","member":"Scroller","cls":"Ext.layout.container.boxOverflow.Scroller","xtypes":{}},{"type":"property","member":"afterScroller","id":"property-afterScroller","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"property","member":"beforeScroller","id":"property-beforeScroller","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"cfg","member":"afterCtCls","id":"cfg-afterCtCls","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"cfg","member":"afterScrollerCls","id":"cfg-afterScrollerCls","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"cfg","member":"animateScroll","id":"cfg-animateScroll","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"cfg","member":"beforeCtCls","id":"cfg-beforeCtCls","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"cfg","member":"beforeScrollerCls","id":"cfg-beforeScrollerCls","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"cfg","member":"scrollDuration","id":"cfg-scrollDuration","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"cfg","member":"scrollIncrement","id":"cfg-scrollIncrement","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"cfg","member":"scrollRepeatInterval","id":"cfg-scrollRepeatInterval","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"cfg","member":"scrollerCls","id":"cfg-scrollerCls","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"cfg","member":"wheelIncrement","id":"cfg-wheelIncrement","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"method","member":"getScrollPosition","id":"method-getScrollPosition","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"method","member":"scrollToItem","id":"method-scrollToItem","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"event","member":"scroll","id":"event-scroll","cls":"Ext.layout.container.boxOverflow.Scroller"},{"type":"cls","member":"Card","cls":"Ext.layout.container.Card","xtypes":{"layout":["card"]}},{"type":"method","member":"setActiveItem","id":"method-setActiveItem","cls":"Ext.layout.container.Card"},{"type":"cls","member":"CheckboxGroup","cls":"Ext.layout.container.CheckboxGroup","xtypes":{"layout":["checkboxgroup"]}},{"type":"cls","member":"Column","cls":"Ext.layout.container.Column","xtypes":{"layout":["column"]}},{"type":"cls","member":"Container","cls":"Ext.layout.container.Container","xtypes":{}},{"type":"method","member":"getRenderedItems","id":"method-getRenderedItems","cls":"Ext.layout.container.Container"},{"type":"method","member":"getVisibleItems","id":"method-getVisibleItems","cls":"Ext.layout.container.Container"},{"type":"cls","member":"Fit","cls":"Ext.layout.container.Fit","xtypes":{"layout":["fit"]}},{"type":"cfg","member":"defaultMargins","id":"cfg-defaultMargins","cls":"Ext.layout.container.Fit"},{"type":"cls","member":"HBox","cls":"Ext.layout.container.HBox","xtypes":{"layout":["hbox"]}},{"type":"cfg","member":"align","id":"cfg-align","cls":"Ext.layout.container.HBox"},{"type":"cls","member":"Table","cls":"Ext.layout.container.Table","xtypes":{"layout":["table"]}},{"type":"cfg","member":"columns","id":"cfg-columns","cls":"Ext.layout.container.Table"},{"type":"cfg","member":"tableAttrs","id":"cfg-tableAttrs","cls":"Ext.layout.container.Table"},{"type":"cfg","member":"tdAttrs","id":"cfg-tdAttrs","cls":"Ext.layout.container.Table"},{"type":"cfg","member":"trAttrs","id":"cfg-trAttrs","cls":"Ext.layout.container.Table"},{"type":"cls","member":"VBox","cls":"Ext.layout.container.VBox","xtypes":{"layout":["vbox"]}},{"type":"cfg","member":"align","id":"cfg-align","cls":"Ext.layout.container.VBox"},{"type":"cls","member":"LoadMask","cls":"Ext.LoadMask","xtypes":{"widget":["loadmask"]}},{"type":"property","member":"disabled","id":"property-disabled","cls":"Ext.LoadMask"},{"type":"cfg","member":"msg","id":"cfg-msg","cls":"Ext.LoadMask"},{"type":"cfg","member":"msgCls","id":"cfg-msgCls","cls":"Ext.LoadMask"},{"type":"cfg","member":"store","id":"cfg-store","cls":"Ext.LoadMask"},{"type":"cfg","member":"useMsg","id":"cfg-useMsg","cls":"Ext.LoadMask"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.LoadMask"},{"type":"method","member":"bindStore","id":"method-bindStore","cls":"Ext.LoadMask"},{"type":"cls","member":"CheckItem","cls":"Ext.menu.CheckItem","xtypes":{"widget":["menucheckitem"]}},{"type":"cfg","member":"checkedCls","id":"cfg-checkedCls","cls":"Ext.menu.CheckItem"},{"type":"cfg","member":"groupCls","id":"cfg-groupCls","cls":"Ext.menu.CheckItem"},{"type":"cfg","member":"hideOnClick","id":"cfg-hideOnClick","cls":"Ext.menu.CheckItem"},{"type":"cfg","member":"uncheckedCls","id":"cfg-uncheckedCls","cls":"Ext.menu.CheckItem"},{"type":"method","member":"disableCheckChange","id":"method-disableCheckChange","cls":"Ext.menu.CheckItem"},{"type":"method","member":"enableCheckChange","id":"method-enableCheckChange","cls":"Ext.menu.CheckItem"},{"type":"method","member":"setChecked","id":"method-setChecked","cls":"Ext.menu.CheckItem"},{"type":"event","member":"beforecheckchange","id":"event-beforecheckchange","cls":"Ext.menu.CheckItem"},{"type":"event","member":"checkchange","id":"event-checkchange","cls":"Ext.menu.CheckItem"},{"type":"cls","member":"ColorPicker","cls":"Ext.menu.ColorPicker","xtypes":{"widget":["colormenu"]}},{"type":"property","member":"picker","id":"property-picker","cls":"Ext.menu.ColorPicker"},{"type":"cfg","member":"hideOnClick","id":"cfg-hideOnClick","cls":"Ext.menu.ColorPicker"},{"type":"cfg","member":"pickerId","id":"cfg-pickerId","cls":"Ext.menu.ColorPicker"},{"type":"event","member":"select","id":"event-select","cls":"Ext.menu.ColorPicker"},{"type":"cls","member":"DatePicker","cls":"Ext.menu.DatePicker","xtypes":{"widget":["datemenu"]}},{"type":"property","member":"picker","id":"property-picker","cls":"Ext.menu.DatePicker"},{"type":"cfg","member":"hideOnClick","id":"cfg-hideOnClick","cls":"Ext.menu.DatePicker"},{"type":"cfg","member":"pickerId","id":"cfg-pickerId","cls":"Ext.menu.DatePicker"},{"type":"event","member":"select","id":"event-select","cls":"Ext.menu.DatePicker"},{"type":"cls","member":"Item","cls":"Ext.menu.Item","xtypes":{"widget":["menuitem"]}},{"type":"property","member":"activated","id":"property-activated","cls":"Ext.menu.Item"},{"type":"property","member":"menu","id":"property-menu","cls":"Ext.menu.Item"},{"type":"property","member":"parentMenu","id":"property-parentMenu","cls":"Ext.menu.Item"},{"type":"cfg","member":"activeCls","id":"cfg-activeCls","cls":"Ext.menu.Item"},{"type":"cfg","member":"canActivate","id":"cfg-canActivate","cls":"Ext.menu.Item"},{"type":"cfg","member":"clickHideDelay","id":"cfg-clickHideDelay","cls":"Ext.menu.Item"},{"type":"cfg","member":"destroyMenu","id":"cfg-destroyMenu","cls":"Ext.menu.Item"},{"type":"cfg","member":"disabledCls","id":"cfg-disabledCls","cls":"Ext.menu.Item"},{"type":"cfg","member":"hideOnClick","id":"cfg-hideOnClick","cls":"Ext.menu.Item"},{"type":"cfg","member":"href","id":"cfg-href","cls":"Ext.menu.Item"},{"type":"cfg","member":"hrefTarget","id":"cfg-hrefTarget","cls":"Ext.menu.Item"},{"type":"cfg","member":"icon","id":"cfg-icon","cls":"Ext.menu.Item"},{"type":"cfg","member":"iconCls","id":"cfg-iconCls","cls":"Ext.menu.Item"},{"type":"cfg","member":"menuAlign","id":"cfg-menuAlign","cls":"Ext.menu.Item"},{"type":"cfg","member":"menuExpandDelay","id":"cfg-menuExpandDelay","cls":"Ext.menu.Item"},{"type":"cfg","member":"menuHideDelay","id":"cfg-menuHideDelay","cls":"Ext.menu.Item"},{"type":"cfg","member":"plain","id":"cfg-plain","cls":"Ext.menu.Item"},{"type":"cfg","member":"text","id":"cfg-text","cls":"Ext.menu.Item"},{"type":"method","member":"setHandler","id":"method-setHandler","cls":"Ext.menu.Item"},{"type":"method","member":"setIconCls","id":"method-setIconCls","cls":"Ext.menu.Item"},{"type":"method","member":"setText","id":"method-setText","cls":"Ext.menu.Item"},{"type":"event","member":"activate","id":"event-activate","cls":"Ext.menu.Item"},{"type":"event","member":"click","id":"event-click","cls":"Ext.menu.Item"},{"type":"event","member":"deactivate","id":"event-deactivate","cls":"Ext.menu.Item"},{"type":"cls","member":"KeyNav","cls":"Ext.menu.KeyNav","xtypes":{}},{"type":"cls","member":"Manager","cls":"Ext.menu.Manager","xtypes":{}},{"type":"method","member":"get","id":"method-get","cls":"Ext.menu.Manager"},{"type":"method","member":"hideAll","id":"method-hideAll","cls":"Ext.menu.Manager"},{"type":"cls","member":"Menu","cls":"Ext.menu.Menu","xtypes":{"widget":["menu"]}},{"type":"property","member":"parentMenu","id":"property-parentMenu","cls":"Ext.menu.Menu"},{"type":"cfg","member":"allowOtherMenus","id":"cfg-allowOtherMenus","cls":"Ext.menu.Menu"},{"type":"cfg","member":"defaultAlign","id":"cfg-defaultAlign","cls":"Ext.menu.Menu"},{"type":"cfg","member":"floating","id":"cfg-floating","cls":"Ext.menu.Menu"},{"type":"cfg","member":"hidden","id":"cfg-hidden","cls":"Ext.menu.Menu"},{"type":"cfg","member":"ignoreParentClicks","id":"cfg-ignoreParentClicks","cls":"Ext.menu.Menu"},{"type":"cfg","member":"minWidth","id":"cfg-minWidth","cls":"Ext.menu.Menu"},{"type":"cfg","member":"plain","id":"cfg-plain","cls":"Ext.menu.Menu"},{"type":"cfg","member":"showSeparator","id":"cfg-showSeparator","cls":"Ext.menu.Menu"},{"type":"method","member":"canActivateItem","id":"method-canActivateItem","cls":"Ext.menu.Menu"},{"type":"method","member":"deactivateActiveItem","id":"method-deactivateActiveItem","cls":"Ext.menu.Menu"},{"type":"method","member":"showBy","id":"method-showBy","cls":"Ext.menu.Menu"},{"type":"event","member":"click","id":"event-click","cls":"Ext.menu.Menu"},{"type":"event","member":"mouseenter","id":"event-mouseenter","cls":"Ext.menu.Menu"},{"type":"event","member":"mouseleave","id":"event-mouseleave","cls":"Ext.menu.Menu"},{"type":"event","member":"mouseover","id":"event-mouseover","cls":"Ext.menu.Menu"},{"type":"cls","member":"Separator","cls":"Ext.menu.Separator","xtypes":{"widget":["menuseparator"]}},{"type":"cfg","member":"separatorCls","id":"cfg-separatorCls","cls":"Ext.menu.Separator"},{"type":"cls","member":"Header","cls":"Ext.panel.Header","xtypes":{"widget":["header"]}},{"type":"cfg","member":"iconCls","id":"cfg-iconCls","cls":"Ext.panel.Header"},{"type":"cfg","member":"title","id":"cfg-title","cls":"Ext.panel.Header"},{"type":"method","member":"addTool","id":"method-addTool","cls":"Ext.panel.Header"},{"type":"method","member":"setIconCls","id":"method-setIconCls","cls":"Ext.panel.Header"},{"type":"method","member":"setTitle","id":"method-setTitle","cls":"Ext.panel.Header"},{"type":"cls","member":"Panel","cls":"Ext.panel.Panel","xtypes":{"widget":["panel"]}},{"type":"property","member":"dd","id":"property-dd","cls":"Ext.panel.Panel"},{"type":"cfg","member":"animCollapse","id":"cfg-animCollapse","cls":"Ext.panel.Panel"},{"type":"cfg","member":"bbar","id":"cfg-bbar","cls":"Ext.panel.Panel"},{"type":"cfg","member":"buttonAlign","id":"cfg-buttonAlign","cls":"Ext.panel.Panel"},{"type":"cfg","member":"buttons","id":"cfg-buttons","cls":"Ext.panel.Panel"},{"type":"cfg","member":"closable","id":"cfg-closable","cls":"Ext.panel.Panel"},{"type":"cfg","member":"closeAction","id":"cfg-closeAction","cls":"Ext.panel.Panel"},{"type":"cfg","member":"collapseDirection","id":"cfg-collapseDirection","cls":"Ext.panel.Panel"},{"type":"cfg","member":"collapseFirst","id":"cfg-collapseFirst","cls":"Ext.panel.Panel"},{"type":"cfg","member":"collapseMode","id":"cfg-collapseMode","cls":"Ext.panel.Panel"},{"type":"cfg","member":"collapsed","id":"cfg-collapsed","cls":"Ext.panel.Panel"},{"type":"cfg","member":"collapsedCls","id":"cfg-collapsedCls","cls":"Ext.panel.Panel"},{"type":"cfg","member":"collapsible","id":"cfg-collapsible","cls":"Ext.panel.Panel"},{"type":"cfg","member":"dockedItems","id":"cfg-dockedItems","cls":"Ext.panel.Panel"},{"type":"cfg","member":"fbar","id":"cfg-fbar","cls":"Ext.panel.Panel"},{"type":"cfg","member":"floatable","id":"cfg-floatable","cls":"Ext.panel.Panel"},{"type":"cfg","member":"frame","id":"cfg-frame","cls":"Ext.panel.Panel"},{"type":"cfg","member":"frameHeader","id":"cfg-frameHeader","cls":"Ext.panel.Panel"},{"type":"cfg","member":"headerPosition","id":"cfg-headerPosition","cls":"Ext.panel.Panel"},{"type":"cfg","member":"hideCollapseTool","id":"cfg-hideCollapseTool","cls":"Ext.panel.Panel"},{"type":"cfg","member":"iconCls","id":"cfg-iconCls","cls":"Ext.panel.Panel"},{"type":"cfg","member":"lbar","id":"cfg-lbar","cls":"Ext.panel.Panel"},{"type":"cfg","member":"minButtonWidth","id":"cfg-minButtonWidth","cls":"Ext.panel.Panel"},{"type":"cfg","member":"overlapHeader","id":"cfg-overlapHeader","cls":"Ext.panel.Panel"},{"type":"cfg","member":"placeholder","id":"cfg-placeholder","cls":"Ext.panel.Panel"},{"type":"cfg","member":"preventHeader","id":"cfg-preventHeader","cls":"Ext.panel.Panel"},{"type":"cfg","member":"rbar","id":"cfg-rbar","cls":"Ext.panel.Panel"},{"type":"cfg","member":"tbar","id":"cfg-tbar","cls":"Ext.panel.Panel"},{"type":"cfg","member":"title","id":"cfg-title","cls":"Ext.panel.Panel"},{"type":"cfg","member":"titleCollapse","id":"cfg-titleCollapse","cls":"Ext.panel.Panel"},{"type":"cfg","member":"tools","id":"cfg-tools","cls":"Ext.panel.Panel"},{"type":"method","member":"close","id":"method-close","cls":"Ext.panel.Panel"},{"type":"method","member":"collapse","id":"method-collapse","cls":"Ext.panel.Panel"},{"type":"method","member":"expand","id":"method-expand","cls":"Ext.panel.Panel"},{"type":"method","member":"setIconCls","id":"method-setIconCls","cls":"Ext.panel.Panel"},{"type":"method","member":"setTitle","id":"method-setTitle","cls":"Ext.panel.Panel"},{"type":"method","member":"toggleCollapse","id":"method-toggleCollapse","cls":"Ext.panel.Panel"},{"type":"event","member":"beforeclose","id":"event-beforeclose","cls":"Ext.panel.Panel"},{"type":"event","member":"beforecollapse","id":"event-beforecollapse","cls":"Ext.panel.Panel"},{"type":"event","member":"beforeexpand","id":"event-beforeexpand","cls":"Ext.panel.Panel"},{"type":"event","member":"collapse","id":"event-collapse","cls":"Ext.panel.Panel"},{"type":"event","member":"expand","id":"event-expand","cls":"Ext.panel.Panel"},{"type":"event","member":"iconchange","id":"event-iconchange","cls":"Ext.panel.Panel"},{"type":"event","member":"titlechange","id":"event-titlechange","cls":"Ext.panel.Panel"},{"type":"cls","member":"Proxy","cls":"Ext.panel.Proxy","xtypes":{}},{"type":"property","member":"panel","id":"property-panel","cls":"Ext.panel.Proxy"},{"type":"cfg","member":"insertProxy","id":"cfg-insertProxy","cls":"Ext.panel.Proxy"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.panel.Proxy"},{"type":"method","member":"getEl","id":"method-getEl","cls":"Ext.panel.Proxy"},{"type":"method","member":"getGhost","id":"method-getGhost","cls":"Ext.panel.Proxy"},{"type":"method","member":"getProxy","id":"method-getProxy","cls":"Ext.panel.Proxy"},{"type":"method","member":"hide","id":"method-hide","cls":"Ext.panel.Proxy"},{"type":"method","member":"moveProxy","id":"method-moveProxy","cls":"Ext.panel.Proxy"},{"type":"method","member":"show","id":"method-show","cls":"Ext.panel.Proxy"},{"type":"cls","member":"Table","cls":"Ext.panel.Table","xtypes":{"widget":["tablepanel"]}},{"type":"property","member":"hasView","id":"property-hasView","cls":"Ext.panel.Table"},{"type":"cfg","member":"columns","id":"cfg-columns","cls":"Ext.panel.Table"},{"type":"cfg","member":"deferRowRender","id":"cfg-deferRowRender","cls":"Ext.panel.Table"},{"type":"cfg","member":"enableColumnHide","id":"cfg-enableColumnHide","cls":"Ext.panel.Table"},{"type":"cfg","member":"enableColumnMove","id":"cfg-enableColumnMove","cls":"Ext.panel.Table"},{"type":"cfg","member":"enableColumnResize","id":"cfg-enableColumnResize","cls":"Ext.panel.Table"},{"type":"cfg","member":"enableLocking","id":"cfg-enableLocking","cls":"Ext.panel.Table"},{"type":"cfg","member":"features","id":"cfg-features","cls":"Ext.panel.Table"},{"type":"cfg","member":"forceFit","id":"cfg-forceFit","cls":"Ext.panel.Table"},{"type":"cfg","member":"hideHeaders","id":"cfg-hideHeaders","cls":"Ext.panel.Table"},{"type":"cfg","member":"multiSelect","id":"cfg-multiSelect","cls":"Ext.panel.Table"},{"type":"cfg","member":"scroll","id":"cfg-scroll","cls":"Ext.panel.Table"},{"type":"cfg","member":"scrollDelta","id":"cfg-scrollDelta","cls":"Ext.panel.Table"},{"type":"cfg","member":"selModel","id":"cfg-selModel","cls":"Ext.panel.Table"},{"type":"cfg","member":"selType","id":"cfg-selType","cls":"Ext.panel.Table"},{"type":"cfg","member":"simpleSelect","id":"cfg-simpleSelect","cls":"Ext.panel.Table"},{"type":"cfg","member":"sortableColumns","id":"cfg-sortableColumns","cls":"Ext.panel.Table"},{"type":"cfg","member":"store","id":"cfg-store","cls":"Ext.panel.Table"},{"type":"cfg","member":"view","id":"cfg-view","cls":"Ext.panel.Table"},{"type":"cfg","member":"viewConfig","id":"cfg-viewConfig","cls":"Ext.panel.Table"},{"type":"cfg","member":"viewType","id":"cfg-viewType","cls":"Ext.panel.Table"},{"type":"method","member":"determineScrollbars","id":"method-determineScrollbars","cls":"Ext.panel.Table"},{"type":"method","member":"getSelectionModel","id":"method-getSelectionModel","cls":"Ext.panel.Table"},{"type":"method","member":"getStore","id":"method-getStore","cls":"Ext.panel.Table"},{"type":"method","member":"getView","id":"method-getView","cls":"Ext.panel.Table"},{"type":"method","member":"hideHorizontalScroller","id":"method-hideHorizontalScroller","cls":"Ext.panel.Table"},{"type":"method","member":"hideVerticalScroller","id":"method-hideVerticalScroller","cls":"Ext.panel.Table"},{"type":"method","member":"initHorizontalScroller","id":"method-initHorizontalScroller","cls":"Ext.panel.Table"},{"type":"method","member":"initVerticalScroller","id":"method-initVerticalScroller","cls":"Ext.panel.Table"},{"type":"method","member":"invalidateScroller","id":"method-invalidateScroller","cls":"Ext.panel.Table"},{"type":"method","member":"reconfigure","id":"method-reconfigure","cls":"Ext.panel.Table"},{"type":"method","member":"scrollByDeltaX","id":"method-scrollByDeltaX","cls":"Ext.panel.Table"},{"type":"method","member":"scrollByDeltaY","id":"method-scrollByDeltaY","cls":"Ext.panel.Table"},{"type":"method","member":"setScrollTop","id":"method-setScrollTop","cls":"Ext.panel.Table"},{"type":"method","member":"showHorizontalScroller","id":"method-showHorizontalScroller","cls":"Ext.panel.Table"},{"type":"method","member":"showVerticalScroller","id":"method-showVerticalScroller","cls":"Ext.panel.Table"},{"type":"event","member":"beforecontainerclick","id":"event-beforecontainerclick","cls":"Ext.panel.Table"},{"type":"event","member":"beforecontainercontextmenu","id":"event-beforecontainercontextmenu","cls":"Ext.panel.Table"},{"type":"event","member":"beforecontainerdblclick","id":"event-beforecontainerdblclick","cls":"Ext.panel.Table"},{"type":"event","member":"beforecontainermousedown","id":"event-beforecontainermousedown","cls":"Ext.panel.Table"},{"type":"event","member":"beforecontainermouseout","id":"event-beforecontainermouseout","cls":"Ext.panel.Table"},{"type":"event","member":"beforecontainermouseover","id":"event-beforecontainermouseover","cls":"Ext.panel.Table"},{"type":"event","member":"beforecontainermouseup","id":"event-beforecontainermouseup","cls":"Ext.panel.Table"},{"type":"event","member":"beforedeselect","id":"event-beforedeselect","cls":"Ext.panel.Table"},{"type":"event","member":"beforeitemclick","id":"event-beforeitemclick","cls":"Ext.panel.Table"},{"type":"event","member":"beforeitemcontextmenu","id":"event-beforeitemcontextmenu","cls":"Ext.panel.Table"},{"type":"event","member":"beforeitemdblclick","id":"event-beforeitemdblclick","cls":"Ext.panel.Table"},{"type":"event","member":"beforeitemmousedown","id":"event-beforeitemmousedown","cls":"Ext.panel.Table"},{"type":"event","member":"beforeitemmouseenter","id":"event-beforeitemmouseenter","cls":"Ext.panel.Table"},{"type":"event","member":"beforeitemmouseleave","id":"event-beforeitemmouseleave","cls":"Ext.panel.Table"},{"type":"event","member":"beforeitemmouseup","id":"event-beforeitemmouseup","cls":"Ext.panel.Table"},{"type":"event","member":"beforeselect","id":"event-beforeselect","cls":"Ext.panel.Table"},{"type":"event","member":"columnhide","id":"event-columnhide","cls":"Ext.panel.Table"},{"type":"event","member":"columnmove","id":"event-columnmove","cls":"Ext.panel.Table"},{"type":"event","member":"columnresize","id":"event-columnresize","cls":"Ext.panel.Table"},{"type":"event","member":"columnshow","id":"event-columnshow","cls":"Ext.panel.Table"},{"type":"event","member":"containerclick","id":"event-containerclick","cls":"Ext.panel.Table"},{"type":"event","member":"containercontextmenu","id":"event-containercontextmenu","cls":"Ext.panel.Table"},{"type":"event","member":"containerdblclick","id":"event-containerdblclick","cls":"Ext.panel.Table"},{"type":"event","member":"containermouseout","id":"event-containermouseout","cls":"Ext.panel.Table"},{"type":"event","member":"containermouseover","id":"event-containermouseover","cls":"Ext.panel.Table"},{"type":"event","member":"containermouseup","id":"event-containermouseup","cls":"Ext.panel.Table"},{"type":"event","member":"deselect","id":"event-deselect","cls":"Ext.panel.Table"},{"type":"event","member":"itemclick","id":"event-itemclick","cls":"Ext.panel.Table"},{"type":"event","member":"itemcontextmenu","id":"event-itemcontextmenu","cls":"Ext.panel.Table"},{"type":"event","member":"itemdblclick","id":"event-itemdblclick","cls":"Ext.panel.Table"},{"type":"event","member":"itemmousedown","id":"event-itemmousedown","cls":"Ext.panel.Table"},{"type":"event","member":"itemmouseenter","id":"event-itemmouseenter","cls":"Ext.panel.Table"},{"type":"event","member":"itemmouseleave","id":"event-itemmouseleave","cls":"Ext.panel.Table"},{"type":"event","member":"itemmouseup","id":"event-itemmouseup","cls":"Ext.panel.Table"},{"type":"event","member":"reconfigure","id":"event-reconfigure","cls":"Ext.panel.Table"},{"type":"event","member":"scrollerhide","id":"event-scrollerhide","cls":"Ext.panel.Table"},{"type":"event","member":"scrollershow","id":"event-scrollershow","cls":"Ext.panel.Table"},{"type":"event","member":"select","id":"event-select","cls":"Ext.panel.Table"},{"type":"event","member":"selectionchange","id":"event-selectionchange","cls":"Ext.panel.Table"},{"type":"event","member":"sortchange","id":"event-sortchange","cls":"Ext.panel.Table"},{"type":"event","member":"viewready","id":"event-viewready","cls":"Ext.panel.Table"},{"type":"cls","member":"Tool","cls":"Ext.panel.Tool","xtypes":{"widget":["tool"]}},{"type":"cfg","member":"handler","id":"cfg-handler","cls":"Ext.panel.Tool"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.panel.Tool"},{"type":"cfg","member":"stopEvent","id":"cfg-stopEvent","cls":"Ext.panel.Tool"},{"type":"cfg","member":"tooltip","id":"cfg-tooltip","cls":"Ext.panel.Tool"},{"type":"cfg","member":"tooltipType","id":"cfg-tooltipType","cls":"Ext.panel.Tool"},{"type":"cfg","member":"type","id":"cfg-type","cls":"Ext.panel.Tool"},{"type":"method","member":"setType","id":"method-setType","cls":"Ext.panel.Tool"},{"type":"event","member":"click","id":"event-click","cls":"Ext.panel.Tool"},{"type":"cls","member":"Color","cls":"Ext.picker.Color","xtypes":{"widget":["colorpicker"]}},{"type":"property","member":"colors","id":"property-colors","cls":"Ext.picker.Color"},{"type":"cfg","member":"allowReselect","id":"cfg-allowReselect","cls":"Ext.picker.Color"},{"type":"cfg","member":"clickEvent","id":"cfg-clickEvent","cls":"Ext.picker.Color"},{"type":"cfg","member":"componentCls","id":"cfg-componentCls","cls":"Ext.picker.Color"},{"type":"cfg","member":"handler","id":"cfg-handler","cls":"Ext.picker.Color"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.picker.Color"},{"type":"cfg","member":"selectedCls","id":"cfg-selectedCls","cls":"Ext.picker.Color"},{"type":"cfg","member":"value","id":"cfg-value","cls":"Ext.picker.Color"},{"type":"method","member":"getValue","id":"method-getValue","cls":"Ext.picker.Color"},{"type":"method","member":"select","id":"method-select","cls":"Ext.picker.Color"},{"type":"event","member":"select","id":"event-select","cls":"Ext.picker.Color"},{"type":"cls","member":"Date","cls":"Ext.picker.Date","xtypes":{"widget":["datepicker"]}},{"type":"cfg","member":"baseCls","id":"cfg-baseCls","cls":"Ext.picker.Date"},{"type":"cfg","member":"dayNames","id":"cfg-dayNames","cls":"Ext.picker.Date"},{"type":"cfg","member":"disableAnim","id":"cfg-disableAnim","cls":"Ext.picker.Date"},{"type":"cfg","member":"disabledCellCls","id":"cfg-disabledCellCls","cls":"Ext.picker.Date"},{"type":"cfg","member":"disabledDates","id":"cfg-disabledDates","cls":"Ext.picker.Date"},{"type":"cfg","member":"disabledDatesRE","id":"cfg-disabledDatesRE","cls":"Ext.picker.Date"},{"type":"cfg","member":"disabledDatesText","id":"cfg-disabledDatesText","cls":"Ext.picker.Date"},{"type":"cfg","member":"disabledDays","id":"cfg-disabledDays","cls":"Ext.picker.Date"},{"type":"cfg","member":"disabledDaysText","id":"cfg-disabledDaysText","cls":"Ext.picker.Date"},{"type":"cfg","member":"focusOnShow","id":"cfg-focusOnShow","cls":"Ext.picker.Date"},{"type":"cfg","member":"format","id":"cfg-format","cls":"Ext.picker.Date"},{"type":"cfg","member":"handler","id":"cfg-handler","cls":"Ext.picker.Date"},{"type":"cfg","member":"keyNavConfig","id":"cfg-keyNavConfig","cls":"Ext.picker.Date"},{"type":"cfg","member":"longDayFormat","id":"cfg-longDayFormat","cls":"Ext.picker.Date"},{"type":"cfg","member":"maxDate","id":"cfg-maxDate","cls":"Ext.picker.Date"},{"type":"cfg","member":"maxText","id":"cfg-maxText","cls":"Ext.picker.Date"},{"type":"cfg","member":"minDate","id":"cfg-minDate","cls":"Ext.picker.Date"},{"type":"cfg","member":"minText","id":"cfg-minText","cls":"Ext.picker.Date"},{"type":"cfg","member":"monthNames","id":"cfg-monthNames","cls":"Ext.picker.Date"},{"type":"cfg","member":"monthYearText","id":"cfg-monthYearText","cls":"Ext.picker.Date"},{"type":"cfg","member":"nextText","id":"cfg-nextText","cls":"Ext.picker.Date"},{"type":"cfg","member":"prevText","id":"cfg-prevText","cls":"Ext.picker.Date"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.picker.Date"},{"type":"cfg","member":"selectedCls","id":"cfg-selectedCls","cls":"Ext.picker.Date"},{"type":"cfg","member":"showToday","id":"cfg-showToday","cls":"Ext.picker.Date"},{"type":"cfg","member":"startDay","id":"cfg-startDay","cls":"Ext.picker.Date"},{"type":"cfg","member":"todayText","id":"cfg-todayText","cls":"Ext.picker.Date"},{"type":"cfg","member":"todayTip","id":"cfg-todayTip","cls":"Ext.picker.Date"},{"type":"method","member":"getValue","id":"method-getValue","cls":"Ext.picker.Date"},{"type":"method","member":"hideMonthPicker","id":"method-hideMonthPicker","cls":"Ext.picker.Date"},{"type":"method","member":"selectToday","id":"method-selectToday","cls":"Ext.picker.Date"},{"type":"method","member":"setDisabledDates","id":"method-setDisabledDates","cls":"Ext.picker.Date"},{"type":"method","member":"setDisabledDays","id":"method-setDisabledDays","cls":"Ext.picker.Date"},{"type":"method","member":"setMaxDate","id":"method-setMaxDate","cls":"Ext.picker.Date"},{"type":"method","member":"setMinDate","id":"method-setMinDate","cls":"Ext.picker.Date"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.picker.Date"},{"type":"method","member":"showMonthPicker","id":"method-showMonthPicker","cls":"Ext.picker.Date"},{"type":"method","member":"showNextMonth","id":"method-showNextMonth","cls":"Ext.picker.Date"},{"type":"method","member":"showNextYear","id":"method-showNextYear","cls":"Ext.picker.Date"},{"type":"method","member":"showPrevMonth","id":"method-showPrevMonth","cls":"Ext.picker.Date"},{"type":"method","member":"showPrevYear","id":"method-showPrevYear","cls":"Ext.picker.Date"},{"type":"event","member":"select","id":"event-select","cls":"Ext.picker.Date"},{"type":"cls","member":"Month","cls":"Ext.picker.Month","xtypes":{"widget":["monthpicker"]}},{"type":"cfg","member":"baseCls","id":"cfg-baseCls","cls":"Ext.picker.Month"},{"type":"cfg","member":"cancelText","id":"cfg-cancelText","cls":"Ext.picker.Month"},{"type":"cfg","member":"okText","id":"cfg-okText","cls":"Ext.picker.Month"},{"type":"cfg","member":"selectedCls","id":"cfg-selectedCls","cls":"Ext.picker.Month"},{"type":"cfg","member":"showButtons","id":"cfg-showButtons","cls":"Ext.picker.Month"},{"type":"cfg","member":"value","id":"cfg-value","cls":"Ext.picker.Month"},{"type":"method","member":"adjustYear","id":"method-adjustYear","cls":"Ext.picker.Month"},{"type":"method","member":"getValue","id":"method-getValue","cls":"Ext.picker.Month"},{"type":"method","member":"hasSelection","id":"method-hasSelection","cls":"Ext.picker.Month"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.picker.Month"},{"type":"event","member":"cancelclick","id":"event-cancelclick","cls":"Ext.picker.Month"},{"type":"event","member":"monthclick","id":"event-monthclick","cls":"Ext.picker.Month"},{"type":"event","member":"monthdblclick","id":"event-monthdblclick","cls":"Ext.picker.Month"},{"type":"event","member":"okclick","id":"event-okclick","cls":"Ext.picker.Month"},{"type":"event","member":"select","id":"event-select","cls":"Ext.picker.Month"},{"type":"event","member":"yearclick","id":"event-yearclick","cls":"Ext.picker.Month"},{"type":"event","member":"yeardblclick","id":"event-yeardblclick","cls":"Ext.picker.Month"},{"type":"cls","member":"Time","cls":"Ext.picker.Time","xtypes":{"widget":["timepicker"]}},{"type":"cfg","member":"format","id":"cfg-format","cls":"Ext.picker.Time"},{"type":"cfg","member":"increment","id":"cfg-increment","cls":"Ext.picker.Time"},{"type":"cfg","member":"maxValue","id":"cfg-maxValue","cls":"Ext.picker.Time"},{"type":"cfg","member":"minValue","id":"cfg-minValue","cls":"Ext.picker.Time"},{"type":"method","member":"setMaxValue","id":"method-setMaxValue","cls":"Ext.picker.Time"},{"type":"method","member":"setMinValue","id":"method-setMinValue","cls":"Ext.picker.Time"},{"type":"method","member":"updateList","id":"method-updateList","cls":"Ext.picker.Time"},{"type":"cls","member":"ProgressBar","cls":"Ext.ProgressBar","xtypes":{"widget":["progressbar"]}},{"type":"cfg","member":"animate","id":"cfg-animate","cls":"Ext.ProgressBar"},{"type":"cfg","member":"baseCls","id":"cfg-baseCls","cls":"Ext.ProgressBar"},{"type":"cfg","member":"id","id":"cfg-id","cls":"Ext.ProgressBar"},{"type":"cfg","member":"text","id":"cfg-text","cls":"Ext.ProgressBar"},{"type":"cfg","member":"textEl","id":"cfg-textEl","cls":"Ext.ProgressBar"},{"type":"cfg","member":"value","id":"cfg-value","cls":"Ext.ProgressBar"},{"type":"method","member":"isWaiting","id":"method-isWaiting","cls":"Ext.ProgressBar"},{"type":"method","member":"reset","id":"method-reset","cls":"Ext.ProgressBar"},{"type":"method","member":"updateProgress","id":"method-updateProgress","cls":"Ext.ProgressBar"},{"type":"method","member":"updateText","id":"method-updateText","cls":"Ext.ProgressBar"},{"type":"method","member":"wait","id":"method-wait","cls":"Ext.ProgressBar"},{"type":"event","member":"update","id":"event-update","cls":"Ext.ProgressBar"},{"type":"cls","member":"Handle","cls":"Ext.resizer.Handle","xtypes":{}},{"type":"cls","member":"Resizer","cls":"Ext.resizer.Resizer","xtypes":{}},{"type":"property","member":"el","id":"property-el","cls":"Ext.resizer.Resizer"},{"type":"property","member":"originalTarget","id":"property-originalTarget","cls":"Ext.resizer.Resizer"},{"type":"property","member":"resizeTracker","id":"property-resizeTracker","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"constrainTo","id":"cfg-constrainTo","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"dynamic","id":"cfg-dynamic","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"handles","id":"cfg-handles","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"height","id":"cfg-height","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"heightIncrement","id":"cfg-heightIncrement","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"maxHeight","id":"cfg-maxHeight","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"maxWidth","id":"cfg-maxWidth","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"minHeight","id":"cfg-minHeight","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"minWidth","id":"cfg-minWidth","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"pinned","id":"cfg-pinned","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"preserveRatio","id":"cfg-preserveRatio","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"target","id":"cfg-target","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"transparent","id":"cfg-transparent","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"width","id":"cfg-width","cls":"Ext.resizer.Resizer"},{"type":"cfg","member":"widthIncrement","id":"cfg-widthIncrement","cls":"Ext.resizer.Resizer"},{"type":"method","member":"getEl","id":"method-getEl","cls":"Ext.resizer.Resizer"},{"type":"method","member":"getTarget","id":"method-getTarget","cls":"Ext.resizer.Resizer"},{"type":"method","member":"resizeTo","id":"method-resizeTo","cls":"Ext.resizer.Resizer"},{"type":"event","member":"beforeresize","id":"event-beforeresize","cls":"Ext.resizer.Resizer"},{"type":"event","member":"resize","id":"event-resize","cls":"Ext.resizer.Resizer"},{"type":"event","member":"resizedrag","id":"event-resizedrag","cls":"Ext.resizer.Resizer"},{"type":"cls","member":"ResizeTracker","cls":"Ext.resizer.ResizeTracker","xtypes":{}},{"type":"method","member":"createProxy","id":"method-createProxy","cls":"Ext.resizer.ResizeTracker"},{"type":"cls","member":"Splitter","cls":"Ext.resizer.Splitter","xtypes":{"widget":["splitter"]}},{"type":"property","member":"orientation","id":"property-orientation","cls":"Ext.resizer.Splitter"},{"type":"cfg","member":"collapseOnDblClick","id":"cfg-collapseOnDblClick","cls":"Ext.resizer.Splitter"},{"type":"cfg","member":"collapseTarget","id":"cfg-collapseTarget","cls":"Ext.resizer.Splitter"},{"type":"cfg","member":"collapsedCls","id":"cfg-collapsedCls","cls":"Ext.resizer.Splitter"},{"type":"cfg","member":"collapsible","id":"cfg-collapsible","cls":"Ext.resizer.Splitter"},{"type":"cfg","member":"defaultSplitMax","id":"cfg-defaultSplitMax","cls":"Ext.resizer.Splitter"},{"type":"cfg","member":"defaultSplitMin","id":"cfg-defaultSplitMin","cls":"Ext.resizer.Splitter"},{"type":"cfg","member":"performCollapse","id":"cfg-performCollapse","cls":"Ext.resizer.Splitter"},{"type":"cls","member":"SplitterTracker","cls":"Ext.resizer.SplitterTracker","xtypes":{}},{"type":"cls","member":"CellModel","cls":"Ext.selection.CellModel","xtypes":{"selection":["cellmodel"]}},{"type":"cfg","member":"enableKeyNav","id":"cfg-enableKeyNav","cls":"Ext.selection.CellModel"},{"type":"cfg","member":"preventWrap","id":"cfg-preventWrap","cls":"Ext.selection.CellModel"},{"type":"method","member":"getCurrentPosition","id":"method-getCurrentPosition","cls":"Ext.selection.CellModel"},{"type":"method","member":"setCurrentPosition","id":"method-setCurrentPosition","cls":"Ext.selection.CellModel"},{"type":"event","member":"deselect","id":"event-deselect","cls":"Ext.selection.CellModel"},{"type":"event","member":"select","id":"event-select","cls":"Ext.selection.CellModel"},{"type":"cls","member":"CheckboxModel","cls":"Ext.selection.CheckboxModel","xtypes":{"selection":["checkboxmodel"]}},{"type":"cfg","member":"checkOnly","id":"cfg-checkOnly","cls":"Ext.selection.CheckboxModel"},{"type":"cfg","member":"injectCheckbox","id":"cfg-injectCheckbox","cls":"Ext.selection.CheckboxModel"},{"type":"cfg","member":"mode","id":"cfg-mode","cls":"Ext.selection.CheckboxModel"},{"type":"method","member":"getHeaderConfig","id":"method-getHeaderConfig","cls":"Ext.selection.CheckboxModel"},{"type":"method","member":"onHeaderClick","id":"method-onHeaderClick","cls":"Ext.selection.CheckboxModel"},{"type":"method","member":"renderer","id":"method-renderer","cls":"Ext.selection.CheckboxModel"},{"type":"cls","member":"RowModel","cls":"Ext.selection.RowModel","xtypes":{"selection":["rowmodel"]}},{"type":"cfg","member":"enableKeyNav","id":"cfg-enableKeyNav","cls":"Ext.selection.RowModel"},{"type":"cfg","member":"ignoreRightMouseSelection","id":"cfg-ignoreRightMouseSelection","cls":"Ext.selection.RowModel"},{"type":"event","member":"beforedeselect","id":"event-beforedeselect","cls":"Ext.selection.RowModel"},{"type":"event","member":"beforeselect","id":"event-beforeselect","cls":"Ext.selection.RowModel"},{"type":"event","member":"deselect","id":"event-deselect","cls":"Ext.selection.RowModel"},{"type":"event","member":"select","id":"event-select","cls":"Ext.selection.RowModel"},{"type":"cls","member":"TreeModel","cls":"Ext.selection.TreeModel","xtypes":{"selection":["treemodel"]}},{"type":"cls","member":"Shadow","cls":"Ext.Shadow","xtypes":{}},{"type":"cfg","member":"mode","id":"cfg-mode","cls":"Ext.Shadow"},{"type":"cfg","member":"offset","id":"cfg-offset","cls":"Ext.Shadow"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.Shadow"},{"type":"method","member":"hide","id":"method-hide","cls":"Ext.Shadow"},{"type":"method","member":"isVisible","id":"method-isVisible","cls":"Ext.Shadow"},{"type":"method","member":"realign","id":"method-realign","cls":"Ext.Shadow"},{"type":"method","member":"setOpacity","id":"method-setOpacity","cls":"Ext.Shadow"},{"type":"method","member":"setZIndex","id":"method-setZIndex","cls":"Ext.Shadow"},{"type":"method","member":"show","id":"method-show","cls":"Ext.Shadow"},{"type":"cls","member":"ShadowPool","cls":"Ext.ShadowPool","xtypes":{}},{"type":"cls","member":"Multi","cls":"Ext.slider.Multi","xtypes":{"widget":["multislider"]}},{"type":"property","member":"dragging","id":"property-dragging","cls":"Ext.slider.Multi"},{"type":"property","member":"thumbs","id":"property-thumbs","cls":"Ext.slider.Multi"},{"type":"cfg","member":"animate","id":"cfg-animate","cls":"Ext.slider.Multi"},{"type":"cfg","member":"clickToChange","id":"cfg-clickToChange","cls":"Ext.slider.Multi"},{"type":"cfg","member":"constrainThumbs","id":"cfg-constrainThumbs","cls":"Ext.slider.Multi"},{"type":"cfg","member":"decimalPrecision","id":"cfg-decimalPrecision","cls":"Ext.slider.Multi"},{"type":"cfg","member":"increment","id":"cfg-increment","cls":"Ext.slider.Multi"},{"type":"cfg","member":"keyIncrement","id":"cfg-keyIncrement","cls":"Ext.slider.Multi"},{"type":"cfg","member":"maxValue","id":"cfg-maxValue","cls":"Ext.slider.Multi"},{"type":"cfg","member":"minValue","id":"cfg-minValue","cls":"Ext.slider.Multi"},{"type":"cfg","member":"tipText","id":"cfg-tipText","cls":"Ext.slider.Multi"},{"type":"cfg","member":"useTips","id":"cfg-useTips","cls":"Ext.slider.Multi"},{"type":"cfg","member":"value","id":"cfg-value","cls":"Ext.slider.Multi"},{"type":"cfg","member":"values","id":"cfg-values","cls":"Ext.slider.Multi"},{"type":"cfg","member":"vertical","id":"cfg-vertical","cls":"Ext.slider.Multi"},{"type":"method","member":"addThumb","id":"method-addThumb","cls":"Ext.slider.Multi"},{"type":"method","member":"getValue","id":"method-getValue","cls":"Ext.slider.Multi"},{"type":"method","member":"getValues","id":"method-getValues","cls":"Ext.slider.Multi"},{"type":"method","member":"setMaxValue","id":"method-setMaxValue","cls":"Ext.slider.Multi"},{"type":"method","member":"setMinValue","id":"method-setMinValue","cls":"Ext.slider.Multi"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.slider.Multi"},{"type":"method","member":"syncThumbs","id":"method-syncThumbs","cls":"Ext.slider.Multi"},{"type":"event","member":"beforechange","id":"event-beforechange","cls":"Ext.slider.Multi"},{"type":"event","member":"change","id":"event-change","cls":"Ext.slider.Multi"},{"type":"event","member":"changecomplete","id":"event-changecomplete","cls":"Ext.slider.Multi"},{"type":"event","member":"drag","id":"event-drag","cls":"Ext.slider.Multi"},{"type":"event","member":"dragend","id":"event-dragend","cls":"Ext.slider.Multi"},{"type":"event","member":"dragstart","id":"event-dragstart","cls":"Ext.slider.Multi"},{"type":"cls","member":"Single","cls":"Ext.slider.Single","xtypes":{"widget":["slider","sliderfield"]}},{"type":"method","member":"getValue","id":"method-getValue","cls":"Ext.slider.Single"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.slider.Single"},{"type":"cls","member":"Thumb","cls":"Ext.slider.Thumb","xtypes":{}},{"type":"property","member":"slider","id":"property-slider","cls":"Ext.slider.Thumb"},{"type":"cfg","member":"constrain","id":"cfg-constrain","cls":"Ext.slider.Thumb"},{"type":"cfg","member":"slider","id":"cfg-slider","cls":"Ext.slider.Thumb"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.slider.Thumb"},{"type":"method","member":"disable","id":"method-disable","cls":"Ext.slider.Thumb"},{"type":"method","member":"enable","id":"method-enable","cls":"Ext.slider.Thumb"},{"type":"method","member":"initEvents","id":"method-initEvents","cls":"Ext.slider.Thumb"},{"type":"method","member":"render","id":"method-render","cls":"Ext.slider.Thumb"},{"type":"cls","member":"Tip","cls":"Ext.slider.Tip","xtypes":{"widget":["slidertip"]}},{"type":"method","member":"getText","id":"method-getText","cls":"Ext.slider.Tip"},{"type":"cls","member":"Bar","cls":"Ext.tab.Bar","xtypes":{"widget":["tabbar"]}},{"type":"cfg","member":"maxTabWidth","id":"cfg-maxTabWidth","cls":"Ext.tab.Bar"},{"type":"cfg","member":"minTabWidth","id":"cfg-minTabWidth","cls":"Ext.tab.Bar"},{"type":"cfg","member":"plain","id":"cfg-plain","cls":"Ext.tab.Bar"},{"type":"event","member":"change","id":"event-change","cls":"Ext.tab.Bar"},{"type":"cls","member":"Panel","cls":"Ext.tab.Panel","xtypes":{"widget":["tabpanel"]}},{"type":"property","member":"tabBar","id":"property-tabBar","cls":"Ext.tab.Panel"},{"type":"cfg","member":"activeItem","id":"cfg-activeItem","cls":"Ext.tab.Panel"},{"type":"cfg","member":"activeTab","id":"cfg-activeTab","cls":"Ext.tab.Panel"},{"type":"cfg","member":"deferredRender","id":"cfg-deferredRender","cls":"Ext.tab.Panel"},{"type":"cfg","member":"itemCls","id":"cfg-itemCls","cls":"Ext.tab.Panel"},{"type":"cfg","member":"layout","id":"cfg-layout","cls":"Ext.tab.Panel"},{"type":"cfg","member":"maxTabWidth","id":"cfg-maxTabWidth","cls":"Ext.tab.Panel"},{"type":"cfg","member":"minTabWidth","id":"cfg-minTabWidth","cls":"Ext.tab.Panel"},{"type":"cfg","member":"plain","id":"cfg-plain","cls":"Ext.tab.Panel"},{"type":"cfg","member":"removePanelHeader","id":"cfg-removePanelHeader","cls":"Ext.tab.Panel"},{"type":"cfg","member":"tabBar","id":"cfg-tabBar","cls":"Ext.tab.Panel"},{"type":"cfg","member":"tabPosition","id":"cfg-tabPosition","cls":"Ext.tab.Panel"},{"type":"method","member":"getActiveTab","id":"method-getActiveTab","cls":"Ext.tab.Panel"},{"type":"method","member":"getTabBar","id":"method-getTabBar","cls":"Ext.tab.Panel"},{"type":"method","member":"setActiveTab","id":"method-setActiveTab","cls":"Ext.tab.Panel"},{"type":"event","member":"beforetabchange","id":"event-beforetabchange","cls":"Ext.tab.Panel"},{"type":"event","member":"tabchange","id":"event-tabchange","cls":"Ext.tab.Panel"},{"type":"cls","member":"Tab","cls":"Ext.tab.Tab","xtypes":{"widget":["tab"]}},{"type":"property","member":"active","id":"property-active","cls":"Ext.tab.Tab"},{"type":"property","member":"closable","id":"property-closable","cls":"Ext.tab.Tab"},{"type":"cfg","member":"activeCls","id":"cfg-activeCls","cls":"Ext.tab.Tab"},{"type":"cfg","member":"closable","id":"cfg-closable","cls":"Ext.tab.Tab"},{"type":"cfg","member":"closableCls","id":"cfg-closableCls","cls":"Ext.tab.Tab"},{"type":"cfg","member":"closeText","id":"cfg-closeText","cls":"Ext.tab.Tab"},{"type":"cfg","member":"disabledCls","id":"cfg-disabledCls","cls":"Ext.tab.Tab"},{"type":"method","member":"setCard","id":"method-setCard","cls":"Ext.tab.Tab"},{"type":"method","member":"setClosable","id":"method-setClosable","cls":"Ext.tab.Tab"},{"type":"event","member":"activate","id":"event-activate","cls":"Ext.tab.Tab"},{"type":"event","member":"beforeclose","id":"event-beforeclose","cls":"Ext.tab.Tab"},{"type":"event","member":"close","id":"event-close","cls":"Ext.tab.Tab"},{"type":"event","member":"deactivate","id":"event-deactivate","cls":"Ext.tab.Tab"},{"type":"cls","member":"QuickTip","cls":"Ext.tip.QuickTip","xtypes":{"widget":["quicktip"]}},{"type":"cfg","member":"interceptTitles","id":"cfg-interceptTitles","cls":"Ext.tip.QuickTip"},{"type":"cfg","member":"target","id":"cfg-target","cls":"Ext.tip.QuickTip"},{"type":"method","member":"cancelShow","id":"method-cancelShow","cls":"Ext.tip.QuickTip"},{"type":"method","member":"register","id":"method-register","cls":"Ext.tip.QuickTip"},{"type":"method","member":"unregister","id":"method-unregister","cls":"Ext.tip.QuickTip"},{"type":"cls","member":"QuickTipManager","cls":"Ext.tip.QuickTipManager","xtypes":{}},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.tip.QuickTipManager"},{"type":"method","member":"disable","id":"method-disable","cls":"Ext.tip.QuickTipManager"},{"type":"method","member":"enable","id":"method-enable","cls":"Ext.tip.QuickTipManager"},{"type":"method","member":"getQuickTip","id":"method-getQuickTip","cls":"Ext.tip.QuickTipManager"},{"type":"method","member":"init","id":"method-init","cls":"Ext.tip.QuickTipManager"},{"type":"method","member":"isEnabled","id":"method-isEnabled","cls":"Ext.tip.QuickTipManager"},{"type":"method","member":"register","id":"method-register","cls":"Ext.tip.QuickTipManager"},{"type":"method","member":"tips","id":"method-tips","cls":"Ext.tip.QuickTipManager"},{"type":"method","member":"unregister","id":"method-unregister","cls":"Ext.tip.QuickTipManager"},{"type":"cls","member":"Tip","cls":"Ext.tip.Tip","xtypes":{"widget":["tip"]}},{"type":"cfg","member":"closable","id":"cfg-closable","cls":"Ext.tip.Tip"},{"type":"cfg","member":"closeAction","id":"cfg-closeAction","cls":"Ext.tip.Tip"},{"type":"cfg","member":"constrainPosition","id":"cfg-constrainPosition","cls":"Ext.tip.Tip"},{"type":"cfg","member":"defaultAlign","id":"cfg-defaultAlign","cls":"Ext.tip.Tip"},{"type":"cfg","member":"maxWidth","id":"cfg-maxWidth","cls":"Ext.tip.Tip"},{"type":"cfg","member":"minWidth","id":"cfg-minWidth","cls":"Ext.tip.Tip"},{"type":"cfg","member":"shadow","id":"cfg-shadow","cls":"Ext.tip.Tip"},{"type":"cfg","member":"width","id":"cfg-width","cls":"Ext.tip.Tip"},{"type":"method","member":"showAt","id":"method-showAt","cls":"Ext.tip.Tip"},{"type":"method","member":"showBy","id":"method-showBy","cls":"Ext.tip.Tip"},{"type":"cls","member":"ToolTip","cls":"Ext.tip.ToolTip","xtypes":{"widget":["tooltip"]}},{"type":"property","member":"triggerElement","id":"property-triggerElement","cls":"Ext.tip.ToolTip"},{"type":"cfg","member":"anchor","id":"cfg-anchor","cls":"Ext.tip.ToolTip"},{"type":"cfg","member":"anchorOffset","id":"cfg-anchorOffset","cls":"Ext.tip.ToolTip"},{"type":"cfg","member":"anchorToTarget","id":"cfg-anchorToTarget","cls":"Ext.tip.ToolTip"},{"type":"cfg","member":"autoHide","id":"cfg-autoHide","cls":"Ext.tip.ToolTip"},{"type":"cfg","member":"delegate","id":"cfg-delegate","cls":"Ext.tip.ToolTip"},{"type":"cfg","member":"dismissDelay","id":"cfg-dismissDelay","cls":"Ext.tip.ToolTip"},{"type":"cfg","member":"hideDelay","id":"cfg-hideDelay","cls":"Ext.tip.ToolTip"},{"type":"cfg","member":"mouseOffset","id":"cfg-mouseOffset","cls":"Ext.tip.ToolTip"},{"type":"cfg","member":"showDelay","id":"cfg-showDelay","cls":"Ext.tip.ToolTip"},{"type":"cfg","member":"target","id":"cfg-target","cls":"Ext.tip.ToolTip"},{"type":"cfg","member":"trackMouse","id":"cfg-trackMouse","cls":"Ext.tip.ToolTip"},{"type":"method","member":"hide","id":"method-hide","cls":"Ext.tip.ToolTip"},{"type":"method","member":"setTarget","id":"method-setTarget","cls":"Ext.tip.ToolTip"},{"type":"method","member":"show","id":"method-show","cls":"Ext.tip.ToolTip"},{"type":"cls","member":"Fill","cls":"Ext.toolbar.Fill","xtypes":{"widget":["tbfill"]}},{"type":"cls","member":"Item","cls":"Ext.toolbar.Item","xtypes":{"widget":["tbitem"]}},{"type":"cfg","member":"overflowText","id":"cfg-overflowText","cls":"Ext.toolbar.Item"},{"type":"cls","member":"Paging","cls":"Ext.toolbar.Paging","xtypes":{"widget":["pagingtoolbar"]}},{"type":"cfg","member":"afterPageText","id":"cfg-afterPageText","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"beforePageText","id":"cfg-beforePageText","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"displayInfo","id":"cfg-displayInfo","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"displayMsg","id":"cfg-displayMsg","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"emptyMsg","id":"cfg-emptyMsg","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"firstText","id":"cfg-firstText","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"inputItemWidth","id":"cfg-inputItemWidth","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"lastText","id":"cfg-lastText","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"nextText","id":"cfg-nextText","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"prependButtons","id":"cfg-prependButtons","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"prevText","id":"cfg-prevText","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"refreshText","id":"cfg-refreshText","cls":"Ext.toolbar.Paging"},{"type":"cfg","member":"store","id":"cfg-store","cls":"Ext.toolbar.Paging"},{"type":"method","member":"bind","id":"method-bind","cls":"Ext.toolbar.Paging"},{"type":"method","member":"bindStore","id":"method-bindStore","cls":"Ext.toolbar.Paging"},{"type":"method","member":"doRefresh","id":"method-doRefresh","cls":"Ext.toolbar.Paging"},{"type":"method","member":"moveFirst","id":"method-moveFirst","cls":"Ext.toolbar.Paging"},{"type":"method","member":"moveLast","id":"method-moveLast","cls":"Ext.toolbar.Paging"},{"type":"method","member":"moveNext","id":"method-moveNext","cls":"Ext.toolbar.Paging"},{"type":"method","member":"movePrevious","id":"method-movePrevious","cls":"Ext.toolbar.Paging"},{"type":"method","member":"unbind","id":"method-unbind","cls":"Ext.toolbar.Paging"},{"type":"event","member":"beforechange","id":"event-beforechange","cls":"Ext.toolbar.Paging"},{"type":"event","member":"change","id":"event-change","cls":"Ext.toolbar.Paging"},{"type":"cls","member":"Separator","cls":"Ext.toolbar.Separator","xtypes":{"widget":["tbseparator"]}},{"type":"cls","member":"Spacer","cls":"Ext.toolbar.Spacer","xtypes":{"widget":["tbspacer"]}},{"type":"cls","member":"TextItem","cls":"Ext.toolbar.TextItem","xtypes":{"widget":["tbtext"]}},{"type":"cfg","member":"text","id":"cfg-text","cls":"Ext.toolbar.TextItem"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.toolbar.TextItem"},{"type":"method","member":"setText","id":"method-setText","cls":"Ext.toolbar.TextItem"},{"type":"cls","member":"Toolbar","cls":"Ext.toolbar.Toolbar","xtypes":{"widget":["toolbar"]}},{"type":"cfg","member":"enableOverflow","id":"cfg-enableOverflow","cls":"Ext.toolbar.Toolbar"},{"type":"cfg","member":"layout","id":"cfg-layout","cls":"Ext.toolbar.Toolbar"},{"type":"cfg","member":"menuTriggerCls","id":"cfg-menuTriggerCls","cls":"Ext.toolbar.Toolbar"},{"type":"cfg","member":"vertical","id":"cfg-vertical","cls":"Ext.toolbar.Toolbar"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.toolbar.Toolbar"},{"type":"method","member":"add","id":"method-add","cls":"Ext.toolbar.Toolbar"},{"type":"event","member":"overflowchange","id":"event-overflowchange","cls":"Ext.toolbar.Toolbar"},{"type":"cls","member":"Column","cls":"Ext.tree.Column","xtypes":{"widget":["treecolumn"]}},{"type":"cls","member":"Panel","cls":"Ext.tree.Panel","xtypes":{"widget":["treepanel"]}},{"type":"cfg","member":"animate","id":"cfg-animate","cls":"Ext.tree.Panel"},{"type":"cfg","member":"displayField","id":"cfg-displayField","cls":"Ext.tree.Panel"},{"type":"cfg","member":"folderSort","id":"cfg-folderSort","cls":"Ext.tree.Panel"},{"type":"cfg","member":"hideHeaders","id":"cfg-hideHeaders","cls":"Ext.tree.Panel"},{"type":"cfg","member":"lines","id":"cfg-lines","cls":"Ext.tree.Panel"},{"type":"cfg","member":"root","id":"cfg-root","cls":"Ext.tree.Panel"},{"type":"cfg","member":"rootVisible","id":"cfg-rootVisible","cls":"Ext.tree.Panel"},{"type":"cfg","member":"singleExpand","id":"cfg-singleExpand","cls":"Ext.tree.Panel"},{"type":"cfg","member":"useArrows","id":"cfg-useArrows","cls":"Ext.tree.Panel"},{"type":"method","member":"collapseAll","id":"method-collapseAll","cls":"Ext.tree.Panel"},{"type":"method","member":"expandAll","id":"method-expandAll","cls":"Ext.tree.Panel"},{"type":"method","member":"expandPath","id":"method-expandPath","cls":"Ext.tree.Panel"},{"type":"method","member":"getChecked","id":"method-getChecked","cls":"Ext.tree.Panel"},{"type":"method","member":"getRootNode","id":"method-getRootNode","cls":"Ext.tree.Panel"},{"type":"method","member":"selectPath","id":"method-selectPath","cls":"Ext.tree.Panel"},{"type":"method","member":"setRootNode","id":"method-setRootNode","cls":"Ext.tree.Panel"},{"type":"event","member":"beforeitemappend","id":"event-beforeitemappend","cls":"Ext.tree.Panel"},{"type":"event","member":"beforeitemcollapse","id":"event-beforeitemcollapse","cls":"Ext.tree.Panel"},{"type":"event","member":"beforeitemexpand","id":"event-beforeitemexpand","cls":"Ext.tree.Panel"},{"type":"event","member":"beforeiteminsert","id":"event-beforeiteminsert","cls":"Ext.tree.Panel"},{"type":"event","member":"beforeitemmove","id":"event-beforeitemmove","cls":"Ext.tree.Panel"},{"type":"event","member":"beforeitemremove","id":"event-beforeitemremove","cls":"Ext.tree.Panel"},{"type":"event","member":"beforeload","id":"event-beforeload","cls":"Ext.tree.Panel"},{"type":"event","member":"checkchange","id":"event-checkchange","cls":"Ext.tree.Panel"},{"type":"event","member":"itemappend","id":"event-itemappend","cls":"Ext.tree.Panel"},{"type":"event","member":"itemcollapse","id":"event-itemcollapse","cls":"Ext.tree.Panel"},{"type":"event","member":"itemexpand","id":"event-itemexpand","cls":"Ext.tree.Panel"},{"type":"event","member":"iteminsert","id":"event-iteminsert","cls":"Ext.tree.Panel"},{"type":"event","member":"itemmove","id":"event-itemmove","cls":"Ext.tree.Panel"},{"type":"event","member":"itemremove","id":"event-itemremove","cls":"Ext.tree.Panel"},{"type":"event","member":"load","id":"event-load","cls":"Ext.tree.Panel"},{"type":"cls","member":"TreeViewDragDrop","cls":"Ext.tree.plugin.TreeViewDragDrop","xtypes":{"plugin":["treeviewdragdrop"]}},{"type":"cfg","member":"allowContainerDrop","id":"cfg-allowContainerDrop","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cfg","member":"allowParentInsert","id":"cfg-allowParentInsert","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cfg","member":"appendOnly","id":"cfg-appendOnly","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cfg","member":"ddGroup","id":"cfg-ddGroup","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cfg","member":"dragGroup","id":"cfg-dragGroup","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cfg","member":"dropGroup","id":"cfg-dropGroup","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cfg","member":"enableDrag","id":"cfg-enableDrag","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cfg","member":"enableDrop","id":"cfg-enableDrop","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cfg","member":"expandDelay","id":"cfg-expandDelay","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cfg","member":"nodeHighlightColor","id":"cfg-nodeHighlightColor","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cfg","member":"nodeHighlightOnDrop","id":"cfg-nodeHighlightOnDrop","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cfg","member":"nodeHighlightOnRepair","id":"cfg-nodeHighlightOnRepair","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"event","member":"beforedrop","id":"event-beforedrop","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"event","member":"drop","id":"event-drop","cls":"Ext.tree.plugin.TreeViewDragDrop"},{"type":"cls","member":"View","cls":"Ext.tree.View","xtypes":{"widget":["treeview"]}},{"type":"cfg","member":"animate","id":"cfg-animate","cls":"Ext.tree.View"},{"type":"cfg","member":"rootVisible","id":"cfg-rootVisible","cls":"Ext.tree.View"},{"type":"method","member":"collapse","id":"method-collapse","cls":"Ext.tree.View"},{"type":"method","member":"expand","id":"method-expand","cls":"Ext.tree.View"},{"type":"method","member":"getTreeStore","id":"method-getTreeStore","cls":"Ext.tree.View"},{"type":"method","member":"toggle","id":"method-toggle","cls":"Ext.tree.View"},{"type":"cls","member":"ViewDropZone","cls":"Ext.tree.ViewDropZone","xtypes":{}},{"type":"cfg","member":"allowContainerDrop","id":"cfg-allowContainerDrop","cls":"Ext.tree.ViewDropZone"},{"type":"cfg","member":"allowParentInsert","id":"cfg-allowParentInsert","cls":"Ext.tree.ViewDropZone"},{"type":"cfg","member":"appendOnly","id":"cfg-appendOnly","cls":"Ext.tree.ViewDropZone"},{"type":"cfg","member":"expandDelay","id":"cfg-expandDelay","cls":"Ext.tree.ViewDropZone"},{"type":"cls","member":"Animate","cls":"Ext.util.Animate","xtypes":{}},{"type":"method","member":"animate","id":"method-animate","cls":"Ext.util.Animate"},{"type":"method","member":"getActiveAnimation","id":"method-getActiveAnimation","cls":"Ext.util.Animate"},{"type":"method","member":"hasActiveFx","id":"method-hasActiveFx","cls":"Ext.util.Animate"},{"type":"method","member":"sequenceFx","id":"method-sequenceFx","cls":"Ext.util.Animate"},{"type":"method","member":"stopAnimation","id":"method-stopAnimation","cls":"Ext.util.Animate"},{"type":"method","member":"stopFx","id":"method-stopFx","cls":"Ext.util.Animate"},{"type":"method","member":"syncFx","id":"method-syncFx","cls":"Ext.util.Animate"},{"type":"cls","member":"ClickRepeater","cls":"Ext.util.ClickRepeater","xtypes":{}},{"type":"cfg","member":"accelerate","id":"cfg-accelerate","cls":"Ext.util.ClickRepeater"},{"type":"cfg","member":"delay","id":"cfg-delay","cls":"Ext.util.ClickRepeater"},{"type":"cfg","member":"el","id":"cfg-el","cls":"Ext.util.ClickRepeater"},{"type":"cfg","member":"interval","id":"cfg-interval","cls":"Ext.util.ClickRepeater"},{"type":"cfg","member":"pressedCls","id":"cfg-pressedCls","cls":"Ext.util.ClickRepeater"},{"type":"cfg","member":"preventDefault","id":"cfg-preventDefault","cls":"Ext.util.ClickRepeater"},{"type":"cfg","member":"stopDefault","id":"cfg-stopDefault","cls":"Ext.util.ClickRepeater"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.ClickRepeater"},{"type":"method","member":"disable","id":"method-disable","cls":"Ext.util.ClickRepeater"},{"type":"method","member":"enable","id":"method-enable","cls":"Ext.util.ClickRepeater"},{"type":"method","member":"setDisabled","id":"method-setDisabled","cls":"Ext.util.ClickRepeater"},{"type":"event","member":"click","id":"event-click","cls":"Ext.util.ClickRepeater"},{"type":"event","member":"mousedown","id":"event-mousedown","cls":"Ext.util.ClickRepeater"},{"type":"event","member":"mouseup","id":"event-mouseup","cls":"Ext.util.ClickRepeater"},{"type":"cls","member":"ComponentDragger","cls":"Ext.util.ComponentDragger","xtypes":{}},{"type":"cfg","member":"constrain","id":"cfg-constrain","cls":"Ext.util.ComponentDragger"},{"type":"cfg","member":"constrainDelegate","id":"cfg-constrainDelegate","cls":"Ext.util.ComponentDragger"},{"type":"cfg","member":"delegate","id":"cfg-delegate","cls":"Ext.util.ComponentDragger"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.ComponentDragger"},{"type":"cls","member":"Cookies","cls":"Ext.util.Cookies","xtypes":{}},{"type":"method","member":"clear","id":"method-clear","cls":"Ext.util.Cookies"},{"type":"method","member":"get","id":"method-get","cls":"Ext.util.Cookies"},{"type":"method","member":"set","id":"method-set","cls":"Ext.util.Cookies"},{"type":"cls","member":"CSS","cls":"Ext.util.CSS","xtypes":{}},{"type":"method","member":"createStyleSheet","id":"method-createStyleSheet","cls":"Ext.util.CSS"},{"type":"method","member":"getRule","id":"method-getRule","cls":"Ext.util.CSS"},{"type":"method","member":"getRules","id":"method-getRules","cls":"Ext.util.CSS"},{"type":"method","member":"refreshCache","id":"method-refreshCache","cls":"Ext.util.CSS"},{"type":"method","member":"removeStyleSheet","id":"method-removeStyleSheet","cls":"Ext.util.CSS"},{"type":"method","member":"swapStyleSheet","id":"method-swapStyleSheet","cls":"Ext.util.CSS"},{"type":"method","member":"updateRule","id":"method-updateRule","cls":"Ext.util.CSS"},{"type":"cls","member":"Floating","cls":"Ext.util.Floating","xtypes":{}},{"type":"cfg","member":"focusOnToFront","id":"cfg-focusOnToFront","cls":"Ext.util.Floating"},{"type":"cfg","member":"shadow","id":"cfg-shadow","cls":"Ext.util.Floating"},{"type":"method","member":"alignTo","id":"method-alignTo","cls":"Ext.util.Floating"},{"type":"method","member":"center","id":"method-center","cls":"Ext.util.Floating"},{"type":"method","member":"doConstrain","id":"method-doConstrain","cls":"Ext.util.Floating"},{"type":"method","member":"setActive","id":"method-setActive","cls":"Ext.util.Floating"},{"type":"method","member":"toBack","id":"method-toBack","cls":"Ext.util.Floating"},{"type":"method","member":"toFront","id":"method-toFront","cls":"Ext.util.Floating"},{"type":"cls","member":"History","cls":"Ext.util.History","xtypes":{}},{"type":"property","member":"fieldId","id":"property-fieldId","cls":"Ext.util.History"},{"type":"property","member":"iframeId","id":"property-iframeId","cls":"Ext.util.History"},{"type":"method","member":"add","id":"method-add","cls":"Ext.util.History"},{"type":"method","member":"back","id":"method-back","cls":"Ext.util.History"},{"type":"method","member":"forward","id":"method-forward","cls":"Ext.util.History"},{"type":"method","member":"getToken","id":"method-getToken","cls":"Ext.util.History"},{"type":"method","member":"init","id":"method-init","cls":"Ext.util.History"},{"type":"event","member":"change","id":"event-change","cls":"Ext.util.History"},{"type":"event","member":"ready","id":"event-ready","cls":"Ext.util.History"},{"type":"cls","member":"KeyMap","cls":"Ext.util.KeyMap","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.KeyMap"},{"type":"method","member":"addBinding","id":"method-addBinding","cls":"Ext.util.KeyMap"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.util.KeyMap"},{"type":"method","member":"disable","id":"method-disable","cls":"Ext.util.KeyMap"},{"type":"method","member":"enable","id":"method-enable","cls":"Ext.util.KeyMap"},{"type":"method","member":"isEnabled","id":"method-isEnabled","cls":"Ext.util.KeyMap"},{"type":"method","member":"on","id":"method-on","cls":"Ext.util.KeyMap"},{"type":"method","member":"setDisabled","id":"method-setDisabled","cls":"Ext.util.KeyMap"},{"type":"cls","member":"KeyNav","cls":"Ext.util.KeyNav","xtypes":{}},{"type":"cfg","member":"defaultEventAction","id":"cfg-defaultEventAction","cls":"Ext.util.KeyNav"},{"type":"cfg","member":"disabled","id":"cfg-disabled","cls":"Ext.util.KeyNav"},{"type":"cfg","member":"forceKeyDown","id":"cfg-forceKeyDown","cls":"Ext.util.KeyNav"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.KeyNav"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.util.KeyNav"},{"type":"method","member":"disable","id":"method-disable","cls":"Ext.util.KeyNav"},{"type":"method","member":"enable","id":"method-enable","cls":"Ext.util.KeyNav"},{"type":"method","member":"getKeyEvent","id":"method-getKeyEvent","cls":"Ext.util.KeyNav"},{"type":"method","member":"setDisabled","id":"method-setDisabled","cls":"Ext.util.KeyNav"},{"type":"cls","member":"TextMetrics","cls":"Ext.util.TextMetrics","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.TextMetrics"},{"type":"method","member":"bind","id":"method-bind","cls":"Ext.util.TextMetrics"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.util.TextMetrics"},{"type":"method","member":"getHeight","id":"method-getHeight","cls":"Ext.util.TextMetrics"},{"type":"method","member":"getSize","id":"method-getSize","cls":"Ext.util.TextMetrics"},{"type":"method","member":"getWidth","id":"method-getWidth","cls":"Ext.util.TextMetrics"},{"type":"method","member":"measure","id":"method-measure","cls":"Ext.util.TextMetrics"},{"type":"method","member":"setFixedWidth","id":"method-setFixedWidth","cls":"Ext.util.TextMetrics"},{"type":"cls","member":"BoundList","cls":"Ext.view.BoundList","xtypes":{"widget":["boundlist"]}},{"type":"property","member":"pagingToolbar","id":"property-pagingToolbar","cls":"Ext.view.BoundList"},{"type":"cfg","member":"pageSize","id":"cfg-pageSize","cls":"Ext.view.BoundList"},{"type":"cls","member":"BoundListKeyNav","cls":"Ext.view.BoundListKeyNav","xtypes":{}},{"type":"cfg","member":"boundList","id":"cfg-boundList","cls":"Ext.view.BoundListKeyNav"},{"type":"method","member":"highlightAt","id":"method-highlightAt","cls":"Ext.view.BoundListKeyNav"},{"type":"method","member":"selectHighlighted","id":"method-selectHighlighted","cls":"Ext.view.BoundListKeyNav"},{"type":"cls","member":"DragZone","cls":"Ext.view.DragZone","xtypes":{}},{"type":"cls","member":"DropZone","cls":"Ext.view.DropZone","xtypes":{}},{"type":"cls","member":"Table","cls":"Ext.view.Table","xtypes":{"widget":["tableview"]}},{"type":"method","member":"addRowCls","id":"method-addRowCls","cls":"Ext.view.Table"},{"type":"method","member":"focusRow","id":"method-focusRow","cls":"Ext.view.Table"},{"type":"method","member":"getFeature","id":"method-getFeature","cls":"Ext.view.Table"},{"type":"method","member":"getRowClass","id":"method-getRowClass","cls":"Ext.view.Table"},{"type":"method","member":"getTableChunker","id":"method-getTableChunker","cls":"Ext.view.Table"},{"type":"method","member":"refresh","id":"method-refresh","cls":"Ext.view.Table"},{"type":"method","member":"removeRowCls","id":"method-removeRowCls","cls":"Ext.view.Table"},{"type":"method","member":"saveScrollState","id":"method-saveScrollState","cls":"Ext.view.Table"},{"type":"cls","member":"TableChunker","cls":"Ext.view.TableChunker","xtypes":{}},{"type":"cls","member":"View","cls":"Ext.view.View","xtypes":{"widget":["dataview"]}},{"type":"method","member":"clearHighlight","id":"method-clearHighlight","cls":"Ext.view.View"},{"type":"method","member":"highlightItem","id":"method-highlightItem","cls":"Ext.view.View"},{"type":"event","member":"beforecontainerclick","id":"event-beforecontainerclick","cls":"Ext.view.View"},{"type":"event","member":"beforecontainercontextmenu","id":"event-beforecontainercontextmenu","cls":"Ext.view.View"},{"type":"event","member":"beforecontainerdblclick","id":"event-beforecontainerdblclick","cls":"Ext.view.View"},{"type":"event","member":"beforecontainerkeydown","id":"event-beforecontainerkeydown","cls":"Ext.view.View"},{"type":"event","member":"beforecontainermousedown","id":"event-beforecontainermousedown","cls":"Ext.view.View"},{"type":"event","member":"beforecontainermouseout","id":"event-beforecontainermouseout","cls":"Ext.view.View"},{"type":"event","member":"beforecontainermouseover","id":"event-beforecontainermouseover","cls":"Ext.view.View"},{"type":"event","member":"beforecontainermouseup","id":"event-beforecontainermouseup","cls":"Ext.view.View"},{"type":"event","member":"beforeitemclick","id":"event-beforeitemclick","cls":"Ext.view.View"},{"type":"event","member":"beforeitemcontextmenu","id":"event-beforeitemcontextmenu","cls":"Ext.view.View"},{"type":"event","member":"beforeitemdblclick","id":"event-beforeitemdblclick","cls":"Ext.view.View"},{"type":"event","member":"beforeitemkeydown","id":"event-beforeitemkeydown","cls":"Ext.view.View"},{"type":"event","member":"beforeitemmousedown","id":"event-beforeitemmousedown","cls":"Ext.view.View"},{"type":"event","member":"beforeitemmouseenter","id":"event-beforeitemmouseenter","cls":"Ext.view.View"},{"type":"event","member":"beforeitemmouseleave","id":"event-beforeitemmouseleave","cls":"Ext.view.View"},{"type":"event","member":"beforeitemmouseup","id":"event-beforeitemmouseup","cls":"Ext.view.View"},{"type":"event","member":"beforeselect","id":"event-beforeselect","cls":"Ext.view.View"},{"type":"event","member":"containerclick","id":"event-containerclick","cls":"Ext.view.View"},{"type":"event","member":"containercontextmenu","id":"event-containercontextmenu","cls":"Ext.view.View"},{"type":"event","member":"containerdblclick","id":"event-containerdblclick","cls":"Ext.view.View"},{"type":"event","member":"containerkeydown","id":"event-containerkeydown","cls":"Ext.view.View"},{"type":"event","member":"containermouseout","id":"event-containermouseout","cls":"Ext.view.View"},{"type":"event","member":"containermouseover","id":"event-containermouseover","cls":"Ext.view.View"},{"type":"event","member":"containermouseup","id":"event-containermouseup","cls":"Ext.view.View"},{"type":"event","member":"itemclick","id":"event-itemclick","cls":"Ext.view.View"},{"type":"event","member":"itemcontextmenu","id":"event-itemcontextmenu","cls":"Ext.view.View"},{"type":"event","member":"itemdblclick","id":"event-itemdblclick","cls":"Ext.view.View"},{"type":"event","member":"itemkeydown","id":"event-itemkeydown","cls":"Ext.view.View"},{"type":"event","member":"itemmousedown","id":"event-itemmousedown","cls":"Ext.view.View"},{"type":"event","member":"itemmouseenter","id":"event-itemmouseenter","cls":"Ext.view.View"},{"type":"event","member":"itemmouseleave","id":"event-itemmouseleave","cls":"Ext.view.View"},{"type":"event","member":"itemmouseup","id":"event-itemmouseup","cls":"Ext.view.View"},{"type":"event","member":"selectionchange","id":"event-selectionchange","cls":"Ext.view.View"},{"type":"cls","member":"MessageBox","cls":"Ext.window.MessageBox","xtypes":{"widget":["messagebox"]}},{"type":"property","member":"CANCEL","id":"property-CANCEL","cls":"Ext.window.MessageBox"},{"type":"property","member":"ERROR","id":"property-ERROR","cls":"Ext.window.MessageBox"},{"type":"property","member":"INFO","id":"property-INFO","cls":"Ext.window.MessageBox"},{"type":"property","member":"NO","id":"property-NO","cls":"Ext.window.MessageBox"},{"type":"property","member":"OK","id":"property-OK","cls":"Ext.window.MessageBox"},{"type":"property","member":"OKCANCEL","id":"property-OKCANCEL","cls":"Ext.window.MessageBox"},{"type":"property","member":"QUESTION","id":"property-QUESTION","cls":"Ext.window.MessageBox"},{"type":"property","member":"WARNING","id":"property-WARNING","cls":"Ext.window.MessageBox"},{"type":"property","member":"YES","id":"property-YES","cls":"Ext.window.MessageBox"},{"type":"property","member":"YESNO","id":"property-YESNO","cls":"Ext.window.MessageBox"},{"type":"property","member":"YESNOCANCEL","id":"property-YESNOCANCEL","cls":"Ext.window.MessageBox"},{"type":"property","member":"buttonText","id":"property-buttonText","cls":"Ext.window.MessageBox"},{"type":"property","member":"defaultTextHeight","id":"property-defaultTextHeight","cls":"Ext.window.MessageBox"},{"type":"property","member":"minProgressWidth","id":"property-minProgressWidth","cls":"Ext.window.MessageBox"},{"type":"property","member":"minPromptWidth","id":"property-minPromptWidth","cls":"Ext.window.MessageBox"},{"type":"method","member":"alert","id":"method-alert","cls":"Ext.window.MessageBox"},{"type":"method","member":"confirm","id":"method-confirm","cls":"Ext.window.MessageBox"},{"type":"method","member":"progress","id":"method-progress","cls":"Ext.window.MessageBox"},{"type":"method","member":"prompt","id":"method-prompt","cls":"Ext.window.MessageBox"},{"type":"method","member":"setIcon","id":"method-setIcon","cls":"Ext.window.MessageBox"},{"type":"method","member":"show","id":"method-show","cls":"Ext.window.MessageBox"},{"type":"method","member":"updateProgress","id":"method-updateProgress","cls":"Ext.window.MessageBox"},{"type":"method","member":"wait","id":"method-wait","cls":"Ext.window.MessageBox"},{"type":"cls","member":"MessageBox","cls":"Ext.MessageBox","xtypes":{}},{"type":"cls","member":"Window","cls":"Ext.window.Window","xtypes":{"widget":["window"]}},{"type":"property","member":"dd","id":"property-dd","cls":"Ext.window.Window"},{"type":"cfg","member":"animateTarget","id":"cfg-animateTarget","cls":"Ext.window.Window"},{"type":"cfg","member":"baseCls","id":"cfg-baseCls","cls":"Ext.window.Window"},{"type":"cfg","member":"closable","id":"cfg-closable","cls":"Ext.window.Window"},{"type":"cfg","member":"collapsed","id":"cfg-collapsed","cls":"Ext.window.Window"},{"type":"cfg","member":"constrain","id":"cfg-constrain","cls":"Ext.window.Window"},{"type":"cfg","member":"constrainHeader","id":"cfg-constrainHeader","cls":"Ext.window.Window"},{"type":"cfg","member":"defaultFocus","id":"cfg-defaultFocus","cls":"Ext.window.Window"},{"type":"cfg","member":"draggable","id":"cfg-draggable","cls":"Ext.window.Window"},{"type":"cfg","member":"expandOnShow","id":"cfg-expandOnShow","cls":"Ext.window.Window"},{"type":"cfg","member":"hidden","id":"cfg-hidden","cls":"Ext.window.Window"},{"type":"cfg","member":"maximizable","id":"cfg-maximizable","cls":"Ext.window.Window"},{"type":"cfg","member":"maximized","id":"cfg-maximized","cls":"Ext.window.Window"},{"type":"cfg","member":"minimizable","id":"cfg-minimizable","cls":"Ext.window.Window"},{"type":"cfg","member":"modal","id":"cfg-modal","cls":"Ext.window.Window"},{"type":"cfg","member":"onEsc","id":"cfg-onEsc","cls":"Ext.window.Window"},{"type":"cfg","member":"plain","id":"cfg-plain","cls":"Ext.window.Window"},{"type":"cfg","member":"resizable","id":"cfg-resizable","cls":"Ext.window.Window"},{"type":"cfg","member":"x","id":"cfg-x","cls":"Ext.window.Window"},{"type":"cfg","member":"y","id":"cfg-y","cls":"Ext.window.Window"},{"type":"method","member":"getFocusEl","id":"method-getFocusEl","cls":"Ext.window.Window"},{"type":"method","member":"maximize","id":"method-maximize","cls":"Ext.window.Window"},{"type":"method","member":"minimize","id":"method-minimize","cls":"Ext.window.Window"},{"type":"method","member":"restore","id":"method-restore","cls":"Ext.window.Window"},{"type":"method","member":"toggleMaximize","id":"method-toggleMaximize","cls":"Ext.window.Window"},{"type":"event","member":"activate","id":"event-activate","cls":"Ext.window.Window"},{"type":"event","member":"deactivate","id":"event-deactivate","cls":"Ext.window.Window"},{"type":"event","member":"maximize","id":"event-maximize","cls":"Ext.window.Window"},{"type":"event","member":"minimize","id":"event-minimize","cls":"Ext.window.Window"},{"type":"event","member":"resize","id":"event-resize","cls":"Ext.window.Window"},{"type":"event","member":"restore","id":"event-restore","cls":"Ext.window.Window"},{"type":"cls","member":"ZIndexManager","cls":"Ext.ZIndexManager","xtypes":{}},{"type":"method","member":"bringToFront","id":"method-bringToFront","cls":"Ext.ZIndexManager"},{"type":"method","member":"each","id":"method-each","cls":"Ext.ZIndexManager"},{"type":"method","member":"eachBottomUp","id":"method-eachBottomUp","cls":"Ext.ZIndexManager"},{"type":"method","member":"eachTopDown","id":"method-eachTopDown","cls":"Ext.ZIndexManager"},{"type":"method","member":"get","id":"method-get","cls":"Ext.ZIndexManager"},{"type":"method","member":"getActive","id":"method-getActive","cls":"Ext.ZIndexManager"},{"type":"method","member":"getBy","id":"method-getBy","cls":"Ext.ZIndexManager"},{"type":"method","member":"hideAll","id":"method-hideAll","cls":"Ext.ZIndexManager"},{"type":"method","member":"register","id":"method-register","cls":"Ext.ZIndexManager"},{"type":"method","member":"sendToBack","id":"method-sendToBack","cls":"Ext.ZIndexManager"},{"type":"method","member":"unregister","id":"method-unregister","cls":"Ext.ZIndexManager"},{"type":"cls","member":"WindowManager","cls":"Ext.WindowManager","xtypes":{}},{"type":"cls","member":"AbstractComponent","cls":"Ext.AbstractComponent","xtypes":{}},{"type":"property","member":"draggable","id":"property-draggable","cls":"Ext.AbstractComponent"},{"type":"property","member":"frameSize","id":"property-frameSize","cls":"Ext.AbstractComponent"},{"type":"property","member":"maskOnDisable","id":"property-maskOnDisable","cls":"Ext.AbstractComponent"},{"type":"property","member":"ownerCt","id":"property-ownerCt","cls":"Ext.AbstractComponent"},{"type":"property","member":"rendered","id":"property-rendered","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"autoEl","id":"cfg-autoEl","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"autoRender","id":"cfg-autoRender","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"autoShow","id":"cfg-autoShow","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"baseCls","id":"cfg-baseCls","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"border","id":"cfg-border","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"childEls","id":"cfg-childEls","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"cls","id":"cfg-cls","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"componentCls","id":"cfg-componentCls","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"componentLayout","id":"cfg-componentLayout","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"contentEl","id":"cfg-contentEl","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"data","id":"cfg-data","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"disabled","id":"cfg-disabled","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"disabledCls","id":"cfg-disabledCls","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"draggable","id":"cfg-draggable","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"floating","id":"cfg-floating","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"frame","id":"cfg-frame","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"height","id":"cfg-height","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"hidden","id":"cfg-hidden","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"hideMode","id":"cfg-hideMode","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"html","id":"cfg-html","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"id","id":"cfg-id","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"itemId","id":"cfg-itemId","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"loader","id":"cfg-loader","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"margin","id":"cfg-margin","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"maxHeight","id":"cfg-maxHeight","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"maxWidth","id":"cfg-maxWidth","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"minHeight","id":"cfg-minHeight","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"minWidth","id":"cfg-minWidth","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"overCls","id":"cfg-overCls","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"padding","id":"cfg-padding","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"plugins","id":"cfg-plugins","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"renderData","id":"cfg-renderData","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"renderSelectors","id":"cfg-renderSelectors","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"renderTo","id":"cfg-renderTo","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"renderTpl","id":"cfg-renderTpl","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"style","id":"cfg-style","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"styleHtmlCls","id":"cfg-styleHtmlCls","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"styleHtmlContent","id":"cfg-styleHtmlContent","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"tpl","id":"cfg-tpl","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"tplWriteMode","id":"cfg-tplWriteMode","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"ui","id":"cfg-ui","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"width","id":"cfg-width","cls":"Ext.AbstractComponent"},{"type":"cfg","member":"xtype","id":"cfg-xtype","cls":"Ext.AbstractComponent"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.AbstractComponent"},{"type":"method","member":"addChildEls","id":"method-addChildEls","cls":"Ext.AbstractComponent"},{"type":"method","member":"addClass","id":"method-addClass","cls":"Ext.AbstractComponent"},{"type":"method","member":"addCls","id":"method-addCls","cls":"Ext.AbstractComponent"},{"type":"method","member":"addClsWithUI","id":"method-addClsWithUI","cls":"Ext.AbstractComponent"},{"type":"method","member":"addUIClsToElement","id":"method-addUIClsToElement","cls":"Ext.AbstractComponent"},{"type":"method","member":"afterComponentLayout","id":"method-afterComponentLayout","cls":"Ext.AbstractComponent"},{"type":"method","member":"beforeComponentLayout","id":"method-beforeComponentLayout","cls":"Ext.AbstractComponent"},{"type":"method","member":"constructPlugins","id":"method-constructPlugins","cls":"Ext.AbstractComponent"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.AbstractComponent"},{"type":"method","member":"disable","id":"method-disable","cls":"Ext.AbstractComponent"},{"type":"method","member":"doAutoRender","id":"method-doAutoRender","cls":"Ext.AbstractComponent"},{"type":"method","member":"doComponentLayout","id":"method-doComponentLayout","cls":"Ext.AbstractComponent"},{"type":"method","member":"enable","id":"method-enable","cls":"Ext.AbstractComponent"},{"type":"method","member":"findLayoutController","id":"method-findLayoutController","cls":"Ext.AbstractComponent"},{"type":"method","member":"forceComponentLayout","id":"method-forceComponentLayout","cls":"Ext.AbstractComponent"},{"type":"method","member":"getBubbleTarget","id":"method-getBubbleTarget","cls":"Ext.AbstractComponent"},{"type":"method","member":"getEl","id":"method-getEl","cls":"Ext.AbstractComponent"},{"type":"method","member":"getHeight","id":"method-getHeight","cls":"Ext.AbstractComponent"},{"type":"method","member":"getId","id":"method-getId","cls":"Ext.AbstractComponent"},{"type":"method","member":"getInsertPosition","id":"method-getInsertPosition","cls":"Ext.AbstractComponent"},{"type":"method","member":"getLoader","id":"method-getLoader","cls":"Ext.AbstractComponent"},{"type":"method","member":"getPlugin","id":"method-getPlugin","cls":"Ext.AbstractComponent"},{"type":"method","member":"getSize","id":"method-getSize","cls":"Ext.AbstractComponent"},{"type":"method","member":"getState","id":"method-getState","cls":"Ext.AbstractComponent"},{"type":"method","member":"getWidth","id":"method-getWidth","cls":"Ext.AbstractComponent"},{"type":"method","member":"getXTypes","id":"method-getXTypes","cls":"Ext.AbstractComponent"},{"type":"method","member":"hasUICls","id":"method-hasUICls","cls":"Ext.AbstractComponent"},{"type":"method","member":"is","id":"method-is","cls":"Ext.AbstractComponent"},{"type":"method","member":"isDescendantOf","id":"method-isDescendantOf","cls":"Ext.AbstractComponent"},{"type":"method","member":"isDisabled","id":"method-isDisabled","cls":"Ext.AbstractComponent"},{"type":"method","member":"isDraggable","id":"method-isDraggable","cls":"Ext.AbstractComponent"},{"type":"method","member":"isDroppable","id":"method-isDroppable","cls":"Ext.AbstractComponent"},{"type":"method","member":"isFloating","id":"method-isFloating","cls":"Ext.AbstractComponent"},{"type":"method","member":"isHidden","id":"method-isHidden","cls":"Ext.AbstractComponent"},{"type":"method","member":"isVisible","id":"method-isVisible","cls":"Ext.AbstractComponent"},{"type":"method","member":"isXType","id":"method-isXType","cls":"Ext.AbstractComponent"},{"type":"method","member":"nextNode","id":"method-nextNode","cls":"Ext.AbstractComponent"},{"type":"method","member":"nextSibling","id":"method-nextSibling","cls":"Ext.AbstractComponent"},{"type":"method","member":"previousNode","id":"method-previousNode","cls":"Ext.AbstractComponent"},{"type":"method","member":"previousSibling","id":"method-previousSibling","cls":"Ext.AbstractComponent"},{"type":"method","member":"removeChildEls","id":"method-removeChildEls","cls":"Ext.AbstractComponent"},{"type":"method","member":"removeCls","id":"method-removeCls","cls":"Ext.AbstractComponent"},{"type":"method","member":"removeClsWithUI","id":"method-removeClsWithUI","cls":"Ext.AbstractComponent"},{"type":"method","member":"removeUIClsFromElement","id":"method-removeUIClsFromElement","cls":"Ext.AbstractComponent"},{"type":"method","member":"setDisabled","id":"method-setDisabled","cls":"Ext.AbstractComponent"},{"type":"method","member":"setDocked","id":"method-setDocked","cls":"Ext.AbstractComponent"},{"type":"method","member":"setHeight","id":"method-setHeight","cls":"Ext.AbstractComponent"},{"type":"method","member":"setLoading","id":"method-setLoading","cls":"Ext.AbstractComponent"},{"type":"method","member":"setPosition","id":"method-setPosition","cls":"Ext.AbstractComponent"},{"type":"method","member":"setSize","id":"method-setSize","cls":"Ext.AbstractComponent"},{"type":"method","member":"setUI","id":"method-setUI","cls":"Ext.AbstractComponent"},{"type":"method","member":"setVisible","id":"method-setVisible","cls":"Ext.AbstractComponent"},{"type":"method","member":"setWidth","id":"method-setWidth","cls":"Ext.AbstractComponent"},{"type":"method","member":"up","id":"method-up","cls":"Ext.AbstractComponent"},{"type":"method","member":"update","id":"method-update","cls":"Ext.AbstractComponent"},{"type":"event","member":"activate","id":"event-activate","cls":"Ext.AbstractComponent"},{"type":"event","member":"added","id":"event-added","cls":"Ext.AbstractComponent"},{"type":"event","member":"afterrender","id":"event-afterrender","cls":"Ext.AbstractComponent"},{"type":"event","member":"beforeactivate","id":"event-beforeactivate","cls":"Ext.AbstractComponent"},{"type":"event","member":"beforedeactivate","id":"event-beforedeactivate","cls":"Ext.AbstractComponent"},{"type":"event","member":"beforedestroy","id":"event-beforedestroy","cls":"Ext.AbstractComponent"},{"type":"event","member":"beforehide","id":"event-beforehide","cls":"Ext.AbstractComponent"},{"type":"event","member":"beforerender","id":"event-beforerender","cls":"Ext.AbstractComponent"},{"type":"event","member":"beforeshow","id":"event-beforeshow","cls":"Ext.AbstractComponent"},{"type":"event","member":"deactivate","id":"event-deactivate","cls":"Ext.AbstractComponent"},{"type":"event","member":"destroy","id":"event-destroy","cls":"Ext.AbstractComponent"},{"type":"event","member":"disable","id":"event-disable","cls":"Ext.AbstractComponent"},{"type":"event","member":"enable","id":"event-enable","cls":"Ext.AbstractComponent"},{"type":"event","member":"hide","id":"event-hide","cls":"Ext.AbstractComponent"},{"type":"event","member":"move","id":"event-move","cls":"Ext.AbstractComponent"},{"type":"event","member":"removed","id":"event-removed","cls":"Ext.AbstractComponent"},{"type":"event","member":"render","id":"event-render","cls":"Ext.AbstractComponent"},{"type":"event","member":"resize","id":"event-resize","cls":"Ext.AbstractComponent"},{"type":"event","member":"show","id":"event-show","cls":"Ext.AbstractComponent"},{"type":"cls","member":"AbstractManager","cls":"Ext.AbstractManager","xtypes":{}},{"type":"property","member":"all","id":"property-all","cls":"Ext.AbstractManager"},{"type":"method","member":"create","id":"method-create","cls":"Ext.AbstractManager"},{"type":"method","member":"each","id":"method-each","cls":"Ext.AbstractManager"},{"type":"method","member":"get","id":"method-get","cls":"Ext.AbstractManager"},{"type":"method","member":"getCount","id":"method-getCount","cls":"Ext.AbstractManager"},{"type":"method","member":"isRegistered","id":"method-isRegistered","cls":"Ext.AbstractManager"},{"type":"method","member":"onAvailable","id":"method-onAvailable","cls":"Ext.AbstractManager"},{"type":"method","member":"register","id":"method-register","cls":"Ext.AbstractManager"},{"type":"method","member":"registerType","id":"method-registerType","cls":"Ext.AbstractManager"},{"type":"method","member":"unregister","id":"method-unregister","cls":"Ext.AbstractManager"},{"type":"cls","member":"AbstractPlugin","cls":"Ext.AbstractPlugin","xtypes":{}},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.AbstractPlugin"},{"type":"method","member":"disable","id":"method-disable","cls":"Ext.AbstractPlugin"},{"type":"method","member":"enable","id":"method-enable","cls":"Ext.AbstractPlugin"},{"type":"method","member":"init","id":"method-init","cls":"Ext.AbstractPlugin"},{"type":"cls","member":"Ajax","cls":"Ext.Ajax","xtypes":{}},{"type":"property","member":"autoAbort","id":"property-autoAbort","cls":"Ext.Ajax"},{"type":"property","member":"defaultHeaders","id":"property-defaultHeaders","cls":"Ext.Ajax"},{"type":"property","member":"disableCaching","id":"property-disableCaching","cls":"Ext.Ajax"},{"type":"property","member":"extraParams","id":"property-extraParams","cls":"Ext.Ajax"},{"type":"property","member":"method","id":"property-method","cls":"Ext.Ajax"},{"type":"property","member":"timeout","id":"property-timeout","cls":"Ext.Ajax"},{"type":"property","member":"url","id":"property-url","cls":"Ext.Ajax"},{"type":"cls","member":"Application","cls":"Ext.app.Application","xtypes":{}},{"type":"property","member":"launch","id":"property-launch","cls":"Ext.app.Application"},{"type":"cfg","member":"appFolder","id":"cfg-appFolder","cls":"Ext.app.Application"},{"type":"cfg","member":"autoCreateViewport","id":"cfg-autoCreateViewport","cls":"Ext.app.Application"},{"type":"cfg","member":"defaultUrl","id":"cfg-defaultUrl","cls":"Ext.app.Application"},{"type":"cfg","member":"enableQuickTips","id":"cfg-enableQuickTips","cls":"Ext.app.Application"},{"type":"cfg","member":"name","id":"cfg-name","cls":"Ext.app.Application"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.app.Application"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.app.Application"},{"type":"cls","member":"Controller","cls":"Ext.app.Controller","xtypes":{}},{"type":"cfg","member":"id","id":"cfg-id","cls":"Ext.app.Controller"},{"type":"cfg","member":"models","id":"cfg-models","cls":"Ext.app.Controller"},{"type":"cfg","member":"stores","id":"cfg-stores","cls":"Ext.app.Controller"},{"type":"cfg","member":"views","id":"cfg-views","cls":"Ext.app.Controller"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.app.Controller"},{"type":"method","member":"control","id":"method-control","cls":"Ext.app.Controller"},{"type":"method","member":"getController","id":"method-getController","cls":"Ext.app.Controller"},{"type":"method","member":"getModel","id":"method-getModel","cls":"Ext.app.Controller"},{"type":"method","member":"getStore","id":"method-getStore","cls":"Ext.app.Controller"},{"type":"method","member":"getView","id":"method-getView","cls":"Ext.app.Controller"},{"type":"method","member":"init","id":"method-init","cls":"Ext.app.Controller"},{"type":"method","member":"onLaunch","id":"method-onLaunch","cls":"Ext.app.Controller"},{"type":"cls","member":"EventBus","cls":"Ext.app.EventBus","xtypes":{}},{"type":"cls","member":"Abstract","cls":"Ext.chart.axis.Abstract","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.chart.axis.Abstract"},{"type":"cls","member":"Axis","cls":"Ext.chart.axis.Axis","xtypes":{}},{"type":"cfg","member":"dashSize","id":"cfg-dashSize","cls":"Ext.chart.axis.Axis"},{"type":"cfg","member":"grid","id":"cfg-grid","cls":"Ext.chart.axis.Axis"},{"type":"cfg","member":"length","id":"cfg-length","cls":"Ext.chart.axis.Axis"},{"type":"cfg","member":"majorTickSteps","id":"cfg-majorTickSteps","cls":"Ext.chart.axis.Axis"},{"type":"cfg","member":"minorTickSteps","id":"cfg-minorTickSteps","cls":"Ext.chart.axis.Axis"},{"type":"cfg","member":"position","id":"cfg-position","cls":"Ext.chart.axis.Axis"},{"type":"cfg","member":"title","id":"cfg-title","cls":"Ext.chart.axis.Axis"},{"type":"cfg","member":"width","id":"cfg-width","cls":"Ext.chart.axis.Axis"},{"type":"method","member":"drawAxis","id":"method-drawAxis","cls":"Ext.chart.axis.Axis"},{"type":"method","member":"drawGrid","id":"method-drawGrid","cls":"Ext.chart.axis.Axis"},{"type":"method","member":"drawLabel","id":"method-drawLabel","cls":"Ext.chart.axis.Axis"},{"type":"method","member":"setTitle","id":"method-setTitle","cls":"Ext.chart.axis.Axis"},{"type":"cls","member":"Category","cls":"Ext.chart.axis.Category","xtypes":{"axis":["category"]}},{"type":"property","member":"calculateCategoryCount","id":"property-calculateCategoryCount","cls":"Ext.chart.axis.Category"},{"type":"property","member":"categoryNames","id":"property-categoryNames","cls":"Ext.chart.axis.Category"},{"type":"cls","member":"Gauge","cls":"Ext.chart.axis.Gauge","xtypes":{}},{"type":"cfg","member":"margin","id":"cfg-margin","cls":"Ext.chart.axis.Gauge"},{"type":"cfg","member":"maximum","id":"cfg-maximum","cls":"Ext.chart.axis.Gauge"},{"type":"cfg","member":"minimum","id":"cfg-minimum","cls":"Ext.chart.axis.Gauge"},{"type":"cfg","member":"steps","id":"cfg-steps","cls":"Ext.chart.axis.Gauge"},{"type":"cfg","member":"title","id":"cfg-title","cls":"Ext.chart.axis.Gauge"},{"type":"method","member":"setTitle","id":"method-setTitle","cls":"Ext.chart.axis.Gauge"},{"type":"cls","member":"Numeric","cls":"Ext.chart.axis.Numeric","xtypes":{"axis":["numeric"]}},{"type":"property","member":"adjustMaximumByMajorUnit","id":"property-adjustMaximumByMajorUnit","cls":"Ext.chart.axis.Numeric"},{"type":"property","member":"adjustMinimumByMajorUnit","id":"property-adjustMinimumByMajorUnit","cls":"Ext.chart.axis.Numeric"},{"type":"property","member":"decimals","id":"property-decimals","cls":"Ext.chart.axis.Numeric"},{"type":"property","member":"maximum","id":"property-maximum","cls":"Ext.chart.axis.Numeric"},{"type":"property","member":"minimum","id":"property-minimum","cls":"Ext.chart.axis.Numeric"},{"type":"property","member":"position","id":"property-position","cls":"Ext.chart.axis.Numeric"},{"type":"cls","member":"Radial","cls":"Ext.chart.axis.Radial","xtypes":{"axis":["radial"]}},{"type":"cls","member":"Time","cls":"Ext.chart.axis.Time","xtypes":{"axis":["time"]}},{"type":"cfg","member":"constrain","id":"cfg-constrain","cls":"Ext.chart.axis.Time"},{"type":"cfg","member":"dateFormat","id":"cfg-dateFormat","cls":"Ext.chart.axis.Time"},{"type":"cfg","member":"fromDate","id":"cfg-fromDate","cls":"Ext.chart.axis.Time"},{"type":"cfg","member":"step","id":"cfg-step","cls":"Ext.chart.axis.Time"},{"type":"cfg","member":"toDate","id":"cfg-toDate","cls":"Ext.chart.axis.Time"},{"type":"cls","member":"Callout","cls":"Ext.chart.Callout","xtypes":{}},{"type":"cls","member":"Chart","cls":"Ext.chart.Chart","xtypes":{"widget":["chart"]}},{"type":"cfg","member":"animate","id":"cfg-animate","cls":"Ext.chart.Chart"},{"type":"cfg","member":"axes","id":"cfg-axes","cls":"Ext.chart.Chart"},{"type":"cfg","member":"background","id":"cfg-background","cls":"Ext.chart.Chart"},{"type":"cfg","member":"enginePriority","id":"cfg-enginePriority","cls":"Ext.chart.Chart"},{"type":"cfg","member":"gradients","id":"cfg-gradients","cls":"Ext.chart.Chart"},{"type":"cfg","member":"insetPadding","id":"cfg-insetPadding","cls":"Ext.chart.Chart"},{"type":"cfg","member":"legend","id":"cfg-legend","cls":"Ext.chart.Chart"},{"type":"cfg","member":"series","id":"cfg-series","cls":"Ext.chart.Chart"},{"type":"cfg","member":"store","id":"cfg-store","cls":"Ext.chart.Chart"},{"type":"cfg","member":"theme","id":"cfg-theme","cls":"Ext.chart.Chart"},{"type":"method","member":"bindStore","id":"method-bindStore","cls":"Ext.chart.Chart"},{"type":"method","member":"redraw","id":"method-redraw","cls":"Ext.chart.Chart"},{"type":"event","member":"beforerefresh","id":"event-beforerefresh","cls":"Ext.chart.Chart"},{"type":"event","member":"refresh","id":"event-refresh","cls":"Ext.chart.Chart"},{"type":"cls","member":"Highlight","cls":"Ext.chart.Highlight","xtypes":{}},{"type":"property","member":"highlight","id":"property-highlight","cls":"Ext.chart.Highlight"},{"type":"method","member":"highlightItem","id":"method-highlightItem","cls":"Ext.chart.Highlight"},{"type":"method","member":"unHighlightItem","id":"method-unHighlightItem","cls":"Ext.chart.Highlight"},{"type":"cls","member":"Label","cls":"Ext.chart.Label","xtypes":{}},{"type":"cfg","member":"label","id":"cfg-label","cls":"Ext.chart.Label"},{"type":"cls","member":"Legend","cls":"Ext.chart.Legend","xtypes":{}},{"type":"property","member":"isVertical","id":"property-isVertical","cls":"Ext.chart.Legend"},{"type":"cfg","member":"boxFill","id":"cfg-boxFill","cls":"Ext.chart.Legend"},{"type":"cfg","member":"boxStroke","id":"cfg-boxStroke","cls":"Ext.chart.Legend"},{"type":"cfg","member":"boxStrokeWidth","id":"cfg-boxStrokeWidth","cls":"Ext.chart.Legend"},{"type":"cfg","member":"boxZIndex","id":"cfg-boxZIndex","cls":"Ext.chart.Legend"},{"type":"cfg","member":"itemSpacing","id":"cfg-itemSpacing","cls":"Ext.chart.Legend"},{"type":"cfg","member":"labelFont","id":"cfg-labelFont","cls":"Ext.chart.Legend"},{"type":"cfg","member":"padding","id":"cfg-padding","cls":"Ext.chart.Legend"},{"type":"cfg","member":"position","id":"cfg-position","cls":"Ext.chart.Legend"},{"type":"cfg","member":"visible","id":"cfg-visible","cls":"Ext.chart.Legend"},{"type":"cfg","member":"x","id":"cfg-x","cls":"Ext.chart.Legend"},{"type":"cfg","member":"y","id":"cfg-y","cls":"Ext.chart.Legend"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.chart.Legend"},{"type":"cls","member":"LegendItem","cls":"Ext.chart.LegendItem","xtypes":{}},{"type":"method","member":"createLegend","id":"method-createLegend","cls":"Ext.chart.LegendItem"},{"type":"method","member":"updatePosition","id":"method-updatePosition","cls":"Ext.chart.LegendItem"},{"type":"cls","member":"Mask","cls":"Ext.chart.Mask","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.chart.Mask"},{"type":"cls","member":"Navigation","cls":"Ext.chart.Navigation","xtypes":{}},{"type":"method","member":"restoreZoom","id":"method-restoreZoom","cls":"Ext.chart.Navigation"},{"type":"method","member":"setZoom","id":"method-setZoom","cls":"Ext.chart.Navigation"},{"type":"cls","member":"Area","cls":"Ext.chart.series.Area","xtypes":{"widget":["area","area"]}},{"type":"cfg","member":"style","id":"cfg-style","cls":"Ext.chart.series.Area"},{"type":"method","member":"drawSeries","id":"method-drawSeries","cls":"Ext.chart.series.Area"},{"type":"method","member":"getLegendColor","id":"method-getLegendColor","cls":"Ext.chart.series.Area"},{"type":"method","member":"highlightItem","id":"method-highlightItem","cls":"Ext.chart.series.Area"},{"type":"method","member":"highlightSeries","id":"method-highlightSeries","cls":"Ext.chart.series.Area"},{"type":"method","member":"unHighlightItem","id":"method-unHighlightItem","cls":"Ext.chart.series.Area"},{"type":"method","member":"unHighlightSeries","id":"method-unHighlightSeries","cls":"Ext.chart.series.Area"},{"type":"cls","member":"Bar","cls":"Ext.chart.series.Bar","xtypes":{"series":["bar"]}},{"type":"cfg","member":"column","id":"cfg-column","cls":"Ext.chart.series.Bar"},{"type":"cfg","member":"groupGutter","id":"cfg-groupGutter","cls":"Ext.chart.series.Bar"},{"type":"cfg","member":"gutter","id":"cfg-gutter","cls":"Ext.chart.series.Bar"},{"type":"cfg","member":"style","id":"cfg-style","cls":"Ext.chart.series.Bar"},{"type":"cfg","member":"xPadding","id":"cfg-xPadding","cls":"Ext.chart.series.Bar"},{"type":"cfg","member":"yPadding","id":"cfg-yPadding","cls":"Ext.chart.series.Bar"},{"type":"method","member":"drawSeries","id":"method-drawSeries","cls":"Ext.chart.series.Bar"},{"type":"method","member":"getLegendColor","id":"method-getLegendColor","cls":"Ext.chart.series.Bar"},{"type":"cls","member":"Cartesian","cls":"Ext.chart.series.Cartesian","xtypes":{}},{"type":"property","member":"xField","id":"property-xField","cls":"Ext.chart.series.Cartesian"},{"type":"property","member":"yField","id":"property-yField","cls":"Ext.chart.series.Cartesian"},{"type":"cfg","member":"axis","id":"cfg-axis","cls":"Ext.chart.series.Cartesian"},{"type":"method","member":"eachYValue","id":"method-eachYValue","cls":"Ext.chart.series.Cartesian"},{"type":"method","member":"getMinMaxXValues","id":"method-getMinMaxXValues","cls":"Ext.chart.series.Cartesian"},{"type":"method","member":"getMinMaxYValues","id":"method-getMinMaxYValues","cls":"Ext.chart.series.Cartesian"},{"type":"method","member":"getYValueAccessors","id":"method-getYValueAccessors","cls":"Ext.chart.series.Cartesian"},{"type":"method","member":"getYValueCount","id":"method-getYValueCount","cls":"Ext.chart.series.Cartesian"},{"type":"cls","member":"Column","cls":"Ext.chart.series.Column","xtypes":{"series":["column"]}},{"type":"cfg","member":"xPadding","id":"cfg-xPadding","cls":"Ext.chart.series.Column"},{"type":"cfg","member":"yPadding","id":"cfg-yPadding","cls":"Ext.chart.series.Column"},{"type":"cls","member":"Gauge","cls":"Ext.chart.series.Gauge","xtypes":{"widget":["gauge"]}},{"type":"cfg","member":"angleField","id":"cfg-angleField","cls":"Ext.chart.series.Gauge"},{"type":"cfg","member":"donut","id":"cfg-donut","cls":"Ext.chart.series.Gauge"},{"type":"cfg","member":"highlightDuration","id":"cfg-highlightDuration","cls":"Ext.chart.series.Gauge"},{"type":"cfg","member":"needle","id":"cfg-needle","cls":"Ext.chart.series.Gauge"},{"type":"cfg","member":"showInLegend","id":"cfg-showInLegend","cls":"Ext.chart.series.Gauge"},{"type":"cfg","member":"style","id":"cfg-style","cls":"Ext.chart.series.Gauge"},{"type":"method","member":"drawSeries","id":"method-drawSeries","cls":"Ext.chart.series.Gauge"},{"type":"method","member":"getLegendColor","id":"method-getLegendColor","cls":"Ext.chart.series.Gauge"},{"type":"method","member":"setValue","id":"method-setValue","cls":"Ext.chart.series.Gauge"},{"type":"cls","member":"Line","cls":"Ext.chart.series.Line","xtypes":{"series":["line"]}},{"type":"cfg","member":"axis","id":"cfg-axis","cls":"Ext.chart.series.Line"},{"type":"cfg","member":"fill","id":"cfg-fill","cls":"Ext.chart.series.Line"},{"type":"cfg","member":"markerConfig","id":"cfg-markerConfig","cls":"Ext.chart.series.Line"},{"type":"cfg","member":"selectionTolerance","id":"cfg-selectionTolerance","cls":"Ext.chart.series.Line"},{"type":"cfg","member":"showMarkers","id":"cfg-showMarkers","cls":"Ext.chart.series.Line"},{"type":"cfg","member":"smooth","id":"cfg-smooth","cls":"Ext.chart.series.Line"},{"type":"cfg","member":"style","id":"cfg-style","cls":"Ext.chart.series.Line"},{"type":"method","member":"drawSeries","id":"method-drawSeries","cls":"Ext.chart.series.Line"},{"type":"cls","member":"Pie","cls":"Ext.chart.series.Pie","xtypes":{"widget":["pie"]}},{"type":"cfg","member":"angleField","id":"cfg-angleField","cls":"Ext.chart.series.Pie"},{"type":"cfg","member":"colorSet","id":"cfg-colorSet","cls":"Ext.chart.series.Pie"},{"type":"cfg","member":"donut","id":"cfg-donut","cls":"Ext.chart.series.Pie"},{"type":"cfg","member":"highlightDuration","id":"cfg-highlightDuration","cls":"Ext.chart.series.Pie"},{"type":"cfg","member":"lengthField","id":"cfg-lengthField","cls":"Ext.chart.series.Pie"},{"type":"cfg","member":"showInLegend","id":"cfg-showInLegend","cls":"Ext.chart.series.Pie"},{"type":"cfg","member":"style","id":"cfg-style","cls":"Ext.chart.series.Pie"},{"type":"method","member":"drawSeries","id":"method-drawSeries","cls":"Ext.chart.series.Pie"},{"type":"method","member":"getLegendColor","id":"method-getLegendColor","cls":"Ext.chart.series.Pie"},{"type":"method","member":"highlightItem","id":"method-highlightItem","cls":"Ext.chart.series.Pie"},{"type":"method","member":"unHighlightItem","id":"method-unHighlightItem","cls":"Ext.chart.series.Pie"},{"type":"cls","member":"Radar","cls":"Ext.chart.series.Radar","xtypes":{"widget":["radar"]}},{"type":"cfg","member":"style","id":"cfg-style","cls":"Ext.chart.series.Radar"},{"type":"method","member":"drawSeries","id":"method-drawSeries","cls":"Ext.chart.series.Radar"},{"type":"cls","member":"Scatter","cls":"Ext.chart.series.Scatter","xtypes":{"widget":["scatter"]}},{"type":"cfg","member":"axis","id":"cfg-axis","cls":"Ext.chart.series.Scatter"},{"type":"cfg","member":"markerConfig","id":"cfg-markerConfig","cls":"Ext.chart.series.Scatter"},{"type":"cfg","member":"style","id":"cfg-style","cls":"Ext.chart.series.Scatter"},{"type":"method","member":"drawSeries","id":"method-drawSeries","cls":"Ext.chart.series.Scatter"},{"type":"cls","member":"Series","cls":"Ext.chart.series.Series","xtypes":{}},{"type":"cfg","member":"highlight","id":"cfg-highlight","cls":"Ext.chart.series.Series"},{"type":"cfg","member":"listeners","id":"cfg-listeners","cls":"Ext.chart.series.Series"},{"type":"cfg","member":"renderer","id":"cfg-renderer","cls":"Ext.chart.series.Series"},{"type":"cfg","member":"shadowAttributes","id":"cfg-shadowAttributes","cls":"Ext.chart.series.Series"},{"type":"cfg","member":"showInLegend","id":"cfg-showInLegend","cls":"Ext.chart.series.Series"},{"type":"cfg","member":"tips","id":"cfg-tips","cls":"Ext.chart.series.Series"},{"type":"cfg","member":"title","id":"cfg-title","cls":"Ext.chart.series.Series"},{"type":"cfg","member":"type","id":"cfg-type","cls":"Ext.chart.series.Series"},{"type":"method","member":"eachRecord","id":"method-eachRecord","cls":"Ext.chart.series.Series"},{"type":"method","member":"getItemForPoint","id":"method-getItemForPoint","cls":"Ext.chart.series.Series"},{"type":"method","member":"getLegendColor","id":"method-getLegendColor","cls":"Ext.chart.series.Series"},{"type":"method","member":"getRecordCount","id":"method-getRecordCount","cls":"Ext.chart.series.Series"},{"type":"method","member":"hideAll","id":"method-hideAll","cls":"Ext.chart.series.Series"},{"type":"method","member":"isExcluded","id":"method-isExcluded","cls":"Ext.chart.series.Series"},{"type":"method","member":"setTitle","id":"method-setTitle","cls":"Ext.chart.series.Series"},{"type":"method","member":"showAll","id":"method-showAll","cls":"Ext.chart.series.Series"},{"type":"event","member":"titlechange","id":"event-titlechange","cls":"Ext.chart.series.Series"},{"type":"cls","member":"Shape","cls":"Ext.chart.Shape","xtypes":{}},{"type":"cls","member":"Base","cls":"Ext.chart.theme.Base","xtypes":{}},{"type":"cls","member":"Theme","cls":"Ext.chart.theme.Theme","xtypes":{}},{"type":"cls","member":"Tip","cls":"Ext.chart.Tip","xtypes":{}},{"type":"cls","member":"TipSurface","cls":"Ext.chart.TipSurface","xtypes":{}},{"type":"cls","member":"ComponentLoader","cls":"Ext.ComponentLoader","xtypes":{}},{"type":"cfg","member":"loadMask","id":"cfg-loadMask","cls":"Ext.ComponentLoader"},{"type":"cfg","member":"renderer","id":"cfg-renderer","cls":"Ext.ComponentLoader"},{"type":"cfg","member":"scripts","id":"cfg-scripts","cls":"Ext.ComponentLoader"},{"type":"cfg","member":"target","id":"cfg-target","cls":"Ext.ComponentLoader"},{"type":"method","member":"setOptions","id":"method-setOptions","cls":"Ext.ComponentLoader"},{"type":"method","member":"setTarget","id":"method-setTarget","cls":"Ext.ComponentLoader"},{"type":"cls","member":"ComponentManager","cls":"Ext.ComponentManager","xtypes":{}},{"type":"method","member":"create","id":"method-create","cls":"Ext.ComponentManager"},{"type":"cls","member":"ComponentQuery","cls":"Ext.ComponentQuery","xtypes":{}},{"type":"method","member":"is","id":"method-is","cls":"Ext.ComponentQuery"},{"type":"method","member":"query","id":"method-query","cls":"Ext.ComponentQuery"},{"type":"cls","member":"AbstractContainer","cls":"Ext.container.AbstractContainer","xtypes":{}},{"type":"property","member":"items","id":"property-items","cls":"Ext.container.AbstractContainer"},{"type":"cfg","member":"activeItem","id":"cfg-activeItem","cls":"Ext.container.AbstractContainer"},{"type":"cfg","member":"autoDestroy","id":"cfg-autoDestroy","cls":"Ext.container.AbstractContainer"},{"type":"cfg","member":"bubbleEvents","id":"cfg-bubbleEvents","cls":"Ext.container.AbstractContainer"},{"type":"cfg","member":"defaultType","id":"cfg-defaultType","cls":"Ext.container.AbstractContainer"},{"type":"cfg","member":"defaults","id":"cfg-defaults","cls":"Ext.container.AbstractContainer"},{"type":"cfg","member":"items","id":"cfg-items","cls":"Ext.container.AbstractContainer"},{"type":"cfg","member":"layout","id":"cfg-layout","cls":"Ext.container.AbstractContainer"},{"type":"cfg","member":"suspendLayout","id":"cfg-suspendLayout","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"add","id":"method-add","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"beforeLayout","id":"method-beforeLayout","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"cascade","id":"method-cascade","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"child","id":"method-child","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"doLayout","id":"method-doLayout","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"down","id":"method-down","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"getComponent","id":"method-getComponent","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"getLayout","id":"method-getLayout","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"insert","id":"method-insert","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"move","id":"method-move","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"query","id":"method-query","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"remove","id":"method-remove","cls":"Ext.container.AbstractContainer"},{"type":"method","member":"removeAll","id":"method-removeAll","cls":"Ext.container.AbstractContainer"},{"type":"event","member":"add","id":"event-add","cls":"Ext.container.AbstractContainer"},{"type":"event","member":"afterlayout","id":"event-afterlayout","cls":"Ext.container.AbstractContainer"},{"type":"event","member":"beforeadd","id":"event-beforeadd","cls":"Ext.container.AbstractContainer"},{"type":"event","member":"beforeremove","id":"event-beforeremove","cls":"Ext.container.AbstractContainer"},{"type":"event","member":"remove","id":"event-remove","cls":"Ext.container.AbstractContainer"},{"type":"cls","member":"AbstractStore","cls":"Ext.data.AbstractStore","xtypes":{}},{"type":"property","member":"batchUpdateMode","id":"property-batchUpdateMode","cls":"Ext.data.AbstractStore"},{"type":"property","member":"defaultProxyType","id":"property-defaultProxyType","cls":"Ext.data.AbstractStore"},{"type":"property","member":"filterOnLoad","id":"property-filterOnLoad","cls":"Ext.data.AbstractStore"},{"type":"property","member":"filters","id":"property-filters","cls":"Ext.data.AbstractStore"},{"type":"property","member":"isDestroyed","id":"property-isDestroyed","cls":"Ext.data.AbstractStore"},{"type":"property","member":"sortOnLoad","id":"property-sortOnLoad","cls":"Ext.data.AbstractStore"},{"type":"cfg","member":"autoLoad","id":"cfg-autoLoad","cls":"Ext.data.AbstractStore"},{"type":"cfg","member":"autoSync","id":"cfg-autoSync","cls":"Ext.data.AbstractStore"},{"type":"cfg","member":"fields","id":"cfg-fields","cls":"Ext.data.AbstractStore"},{"type":"cfg","member":"model","id":"cfg-model","cls":"Ext.data.AbstractStore"},{"type":"cfg","member":"proxy","id":"cfg-proxy","cls":"Ext.data.AbstractStore"},{"type":"cfg","member":"storeId","id":"cfg-storeId","cls":"Ext.data.AbstractStore"},{"type":"method","member":"getNewRecords","id":"method-getNewRecords","cls":"Ext.data.AbstractStore"},{"type":"method","member":"getProxy","id":"method-getProxy","cls":"Ext.data.AbstractStore"},{"type":"method","member":"getRemovedRecords","id":"method-getRemovedRecords","cls":"Ext.data.AbstractStore"},{"type":"method","member":"getUpdatedRecords","id":"method-getUpdatedRecords","cls":"Ext.data.AbstractStore"},{"type":"method","member":"isLoading","id":"method-isLoading","cls":"Ext.data.AbstractStore"},{"type":"method","member":"load","id":"method-load","cls":"Ext.data.AbstractStore"},{"type":"method","member":"removeAll","id":"method-removeAll","cls":"Ext.data.AbstractStore"},{"type":"method","member":"setProxy","id":"method-setProxy","cls":"Ext.data.AbstractStore"},{"type":"method","member":"sync","id":"method-sync","cls":"Ext.data.AbstractStore"},{"type":"event","member":"add","id":"event-add","cls":"Ext.data.AbstractStore"},{"type":"event","member":"beforeload","id":"event-beforeload","cls":"Ext.data.AbstractStore"},{"type":"event","member":"beforesync","id":"event-beforesync","cls":"Ext.data.AbstractStore"},{"type":"event","member":"clear","id":"event-clear","cls":"Ext.data.AbstractStore"},{"type":"event","member":"datachanged","id":"event-datachanged","cls":"Ext.data.AbstractStore"},{"type":"event","member":"load","id":"event-load","cls":"Ext.data.AbstractStore"},{"type":"event","member":"remove","id":"event-remove","cls":"Ext.data.AbstractStore"},{"type":"event","member":"update","id":"event-update","cls":"Ext.data.AbstractStore"},{"type":"event","member":"write","id":"event-write","cls":"Ext.data.AbstractStore"},{"type":"cls","member":"ArrayStore","cls":"Ext.data.ArrayStore","xtypes":{"store":["array"]}},{"type":"cls","member":"Association","cls":"Ext.data.Association","xtypes":{}},{"type":"property","member":"associatedName","id":"property-associatedName","cls":"Ext.data.Association"},{"type":"property","member":"ownerName","id":"property-ownerName","cls":"Ext.data.Association"},{"type":"cfg","member":"associatedModel","id":"cfg-associatedModel","cls":"Ext.data.Association"},{"type":"cfg","member":"associationKey","id":"cfg-associationKey","cls":"Ext.data.Association"},{"type":"cfg","member":"ownerModel","id":"cfg-ownerModel","cls":"Ext.data.Association"},{"type":"cfg","member":"primaryKey","id":"cfg-primaryKey","cls":"Ext.data.Association"},{"type":"cfg","member":"reader","id":"cfg-reader","cls":"Ext.data.Association"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.Association"},{"type":"method","member":"getReader","id":"method-getReader","cls":"Ext.data.Association"},{"type":"cls","member":"Batch","cls":"Ext.data.Batch","xtypes":{}},{"type":"property","member":"autoStart","id":"property-autoStart","cls":"Ext.data.Batch"},{"type":"property","member":"current","id":"property-current","cls":"Ext.data.Batch"},{"type":"property","member":"hasException","id":"property-hasException","cls":"Ext.data.Batch"},{"type":"property","member":"isComplete","id":"property-isComplete","cls":"Ext.data.Batch"},{"type":"property","member":"isRunning","id":"property-isRunning","cls":"Ext.data.Batch"},{"type":"property","member":"operations","id":"property-operations","cls":"Ext.data.Batch"},{"type":"property","member":"pauseOnException","id":"property-pauseOnException","cls":"Ext.data.Batch"},{"type":"property","member":"total","id":"property-total","cls":"Ext.data.Batch"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.Batch"},{"type":"method","member":"add","id":"method-add","cls":"Ext.data.Batch"},{"type":"method","member":"pause","id":"method-pause","cls":"Ext.data.Batch"},{"type":"method","member":"runOperation","id":"method-runOperation","cls":"Ext.data.Batch"},{"type":"method","member":"start","id":"method-start","cls":"Ext.data.Batch"},{"type":"event","member":"complete","id":"event-complete","cls":"Ext.data.Batch"},{"type":"event","member":"exception","id":"event-exception","cls":"Ext.data.Batch"},{"type":"event","member":"operationcomplete","id":"event-operationcomplete","cls":"Ext.data.Batch"},{"type":"cls","member":"BelongsToAssociation","cls":"Ext.data.BelongsToAssociation","xtypes":{"association":["belongsto"]}},{"type":"cfg","member":"foreignKey","id":"cfg-foreignKey","cls":"Ext.data.BelongsToAssociation"},{"type":"cfg","member":"getterName","id":"cfg-getterName","cls":"Ext.data.BelongsToAssociation"},{"type":"cfg","member":"setterName","id":"cfg-setterName","cls":"Ext.data.BelongsToAssociation"},{"type":"cfg","member":"type","id":"cfg-type","cls":"Ext.data.BelongsToAssociation"},{"type":"cls","member":"BufferStore","cls":"Ext.data.BufferStore","xtypes":{"store":["buffer"]}},{"type":"cls","member":"Connection","cls":"Ext.data.Connection","xtypes":{}},{"type":"cfg","member":"cors","id":"cfg-cors","cls":"Ext.data.Connection"},{"type":"cfg","member":"disableCaching","id":"cfg-disableCaching","cls":"Ext.data.Connection"},{"type":"cfg","member":"disableCachingParam","id":"cfg-disableCachingParam","cls":"Ext.data.Connection"},{"type":"cfg","member":"extraParams","id":"cfg-extraParams","cls":"Ext.data.Connection"},{"type":"cfg","member":"timeout","id":"cfg-timeout","cls":"Ext.data.Connection"},{"type":"cfg","member":"withCredentials","id":"cfg-withCredentials","cls":"Ext.data.Connection"},{"type":"method","member":"abort","id":"method-abort","cls":"Ext.data.Connection"},{"type":"method","member":"abortAll","id":"method-abortAll","cls":"Ext.data.Connection"},{"type":"method","member":"isLoading","id":"method-isLoading","cls":"Ext.data.Connection"},{"type":"method","member":"parseStatus","id":"method-parseStatus","cls":"Ext.data.Connection"},{"type":"method","member":"request","id":"method-request","cls":"Ext.data.Connection"},{"type":"method","member":"setOptions","id":"method-setOptions","cls":"Ext.data.Connection"},{"type":"method","member":"upload","id":"method-upload","cls":"Ext.data.Connection"},{"type":"event","member":"beforerequest","id":"event-beforerequest","cls":"Ext.data.Connection"},{"type":"event","member":"requestcomplete","id":"event-requestcomplete","cls":"Ext.data.Connection"},{"type":"event","member":"requestexception","id":"event-requestexception","cls":"Ext.data.Connection"},{"type":"cls","member":"DirectStore","cls":"Ext.data.DirectStore","xtypes":{"store":["direct"]}},{"type":"cls","member":"Errors","cls":"Ext.data.Errors","xtypes":{}},{"type":"method","member":"getByField","id":"method-getByField","cls":"Ext.data.Errors"},{"type":"method","member":"isValid","id":"method-isValid","cls":"Ext.data.Errors"},{"type":"cls","member":"Field","cls":"Ext.data.Field","xtypes":{"data":["field"]}},{"type":"cfg","member":"convert","id":"cfg-convert","cls":"Ext.data.Field"},{"type":"cfg","member":"dateFormat","id":"cfg-dateFormat","cls":"Ext.data.Field"},{"type":"cfg","member":"defaultValue","id":"cfg-defaultValue","cls":"Ext.data.Field"},{"type":"cfg","member":"mapping","id":"cfg-mapping","cls":"Ext.data.Field"},{"type":"cfg","member":"name","id":"cfg-name","cls":"Ext.data.Field"},{"type":"cfg","member":"persist","id":"cfg-persist","cls":"Ext.data.Field"},{"type":"cfg","member":"sortDir","id":"cfg-sortDir","cls":"Ext.data.Field"},{"type":"cfg","member":"sortType","id":"cfg-sortType","cls":"Ext.data.Field"},{"type":"cfg","member":"type","id":"cfg-type","cls":"Ext.data.Field"},{"type":"cfg","member":"useNull","id":"cfg-useNull","cls":"Ext.data.Field"},{"type":"cls","member":"HasManyAssociation","cls":"Ext.data.HasManyAssociation","xtypes":{"association":["hasmany"]}},{"type":"cfg","member":"autoLoad","id":"cfg-autoLoad","cls":"Ext.data.HasManyAssociation"},{"type":"cfg","member":"filterProperty","id":"cfg-filterProperty","cls":"Ext.data.HasManyAssociation"},{"type":"cfg","member":"foreignKey","id":"cfg-foreignKey","cls":"Ext.data.HasManyAssociation"},{"type":"cfg","member":"name","id":"cfg-name","cls":"Ext.data.HasManyAssociation"},{"type":"cfg","member":"storeConfig","id":"cfg-storeConfig","cls":"Ext.data.HasManyAssociation"},{"type":"cfg","member":"type","id":"cfg-type","cls":"Ext.data.HasManyAssociation"},{"type":"cls","member":"IdGenerator","cls":"Ext.data.IdGenerator","xtypes":{}},{"type":"cfg","member":"id","id":"cfg-id","cls":"Ext.data.IdGenerator"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.IdGenerator"},{"type":"method","member":"generate","id":"method-generate","cls":"Ext.data.IdGenerator"},{"type":"method","member":"get","id":"static-method-get","cls":"Ext.data.IdGenerator"},{"type":"cls","member":"JsonP","cls":"Ext.data.JsonP","xtypes":{}},{"type":"property","member":"callbackKey","id":"property-callbackKey","cls":"Ext.data.JsonP"},{"type":"property","member":"disableCaching","id":"property-disableCaching","cls":"Ext.data.JsonP"},{"type":"property","member":"disableCachingParam","id":"property-disableCachingParam","cls":"Ext.data.JsonP"},{"type":"property","member":"timeout","id":"property-timeout","cls":"Ext.data.JsonP"},{"type":"method","member":"abort","id":"method-abort","cls":"Ext.data.JsonP"},{"type":"method","member":"request","id":"method-request","cls":"Ext.data.JsonP"},{"type":"cls","member":"JsonPStore","cls":"Ext.data.JsonPStore","xtypes":{"widget":["jsonpstore"]}},{"type":"cls","member":"JsonStore","cls":"Ext.data.JsonStore","xtypes":{"widget":["jsonstore"]}},{"type":"cls","member":"Model","cls":"Ext.data.Model","xtypes":{}},{"type":"property","member":"associations","id":"property-associations","cls":"Ext.data.Model"},{"type":"property","member":"dirty","id":"property-dirty","cls":"Ext.data.Model"},{"type":"property","member":"editing","id":"property-editing","cls":"Ext.data.Model"},{"type":"property","member":"fields","id":"property-fields","cls":"Ext.data.Model"},{"type":"property","member":"modified","id":"property-modified","cls":"Ext.data.Model"},{"type":"property","member":"phantom","id":"property-phantom","cls":"Ext.data.Model"},{"type":"property","member":"raw","id":"property-raw","cls":"Ext.data.Model"},{"type":"property","member":"store","id":"property-store","cls":"Ext.data.Model"},{"type":"cfg","member":"associations","id":"cfg-associations","cls":"Ext.data.Model"},{"type":"cfg","member":"belongsTo","id":"cfg-belongsTo","cls":"Ext.data.Model"},{"type":"cfg","member":"defaultProxyType","id":"cfg-defaultProxyType","cls":"Ext.data.Model"},{"type":"cfg","member":"fields","id":"cfg-fields","cls":"Ext.data.Model"},{"type":"cfg","member":"hasMany","id":"cfg-hasMany","cls":"Ext.data.Model"},{"type":"cfg","member":"idProperty","id":"cfg-idProperty","cls":"Ext.data.Model"},{"type":"cfg","member":"idgen","id":"cfg-idgen","cls":"Ext.data.Model"},{"type":"cfg","member":"persistenceProperty","id":"cfg-persistenceProperty","cls":"Ext.data.Model"},{"type":"cfg","member":"proxy","id":"cfg-proxy","cls":"Ext.data.Model"},{"type":"cfg","member":"validations","id":"cfg-validations","cls":"Ext.data.Model"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.Model"},{"type":"method","member":"beginEdit","id":"method-beginEdit","cls":"Ext.data.Model"},{"type":"method","member":"cancelEdit","id":"method-cancelEdit","cls":"Ext.data.Model"},{"type":"method","member":"commit","id":"method-commit","cls":"Ext.data.Model"},{"type":"method","member":"copy","id":"method-copy","cls":"Ext.data.Model"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.data.Model"},{"type":"method","member":"endEdit","id":"method-endEdit","cls":"Ext.data.Model"},{"type":"method","member":"get","id":"method-get","cls":"Ext.data.Model"},{"type":"method","member":"getAssociatedData","id":"method-getAssociatedData","cls":"Ext.data.Model"},{"type":"method","member":"getChanges","id":"method-getChanges","cls":"Ext.data.Model"},{"type":"method","member":"getId","id":"method-getId","cls":"Ext.data.Model"},{"type":"method","member":"getProxy","id":"method-getProxy","cls":"Ext.data.Model"},{"type":"method","member":"isModified","id":"method-isModified","cls":"Ext.data.Model"},{"type":"method","member":"isValid","id":"method-isValid","cls":"Ext.data.Model"},{"type":"method","member":"join","id":"method-join","cls":"Ext.data.Model"},{"type":"method","member":"reject","id":"method-reject","cls":"Ext.data.Model"},{"type":"method","member":"save","id":"method-save","cls":"Ext.data.Model"},{"type":"method","member":"set","id":"method-set","cls":"Ext.data.Model"},{"type":"method","member":"setDirty","id":"method-setDirty","cls":"Ext.data.Model"},{"type":"method","member":"setId","id":"method-setId","cls":"Ext.data.Model"},{"type":"method","member":"setProxy","id":"method-setProxy","cls":"Ext.data.Model"},{"type":"method","member":"unjoin","id":"method-unjoin","cls":"Ext.data.Model"},{"type":"method","member":"validate","id":"method-validate","cls":"Ext.data.Model"},{"type":"method","member":"getProxy","id":"static-method-getProxy","cls":"Ext.data.Model"},{"type":"method","member":"id","id":"static-method-id","cls":"Ext.data.Model"},{"type":"method","member":"load","id":"static-method-load","cls":"Ext.data.Model"},{"type":"method","member":"setProxy","id":"static-method-setProxy","cls":"Ext.data.Model"},{"type":"cls","member":"NodeInterface","cls":"Ext.data.NodeInterface","xtypes":{}},{"type":"property","member":"childNodes","id":"property-childNodes","cls":"Ext.data.NodeInterface"},{"type":"property","member":"firstChild","id":"property-firstChild","cls":"Ext.data.NodeInterface"},{"type":"property","member":"lastChild","id":"property-lastChild","cls":"Ext.data.NodeInterface"},{"type":"property","member":"nextSibling","id":"property-nextSibling","cls":"Ext.data.NodeInterface"},{"type":"property","member":"parentNode","id":"property-parentNode","cls":"Ext.data.NodeInterface"},{"type":"property","member":"previousSibling","id":"property-previousSibling","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"allowDrag","id":"cfg-allowDrag","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"allowDrop","id":"cfg-allowDrop","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"checked","id":"cfg-checked","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"children","id":"cfg-children","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"cls","id":"cfg-cls","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"depth","id":"cfg-depth","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"expandable","id":"cfg-expandable","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"expanded","id":"cfg-expanded","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"href","id":"cfg-href","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"hrefTarget","id":"cfg-hrefTarget","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"icon","id":"cfg-icon","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"iconCls","id":"cfg-iconCls","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"index","id":"cfg-index","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"isFirst","id":"cfg-isFirst","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"isLast","id":"cfg-isLast","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"leaf","id":"cfg-leaf","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"loaded","id":"cfg-loaded","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"loading","id":"cfg-loading","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"parentId","id":"cfg-parentId","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"qtip","id":"cfg-qtip","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"qtitle","id":"cfg-qtitle","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"root","id":"cfg-root","cls":"Ext.data.NodeInterface"},{"type":"cfg","member":"text","id":"cfg-text","cls":"Ext.data.NodeInterface"},{"type":"method","member":"appendChild","id":"method-appendChild","cls":"Ext.data.NodeInterface"},{"type":"method","member":"bubble","id":"method-bubble","cls":"Ext.data.NodeInterface"},{"type":"method","member":"cascadeBy","id":"method-cascadeBy","cls":"Ext.data.NodeInterface"},{"type":"method","member":"collapse","id":"method-collapse","cls":"Ext.data.NodeInterface"},{"type":"method","member":"collapseChildren","id":"method-collapseChildren","cls":"Ext.data.NodeInterface"},{"type":"method","member":"contains","id":"method-contains","cls":"Ext.data.NodeInterface"},{"type":"method","member":"copy","id":"method-copy","cls":"Ext.data.NodeInterface"},{"type":"method","member":"createNode","id":"method-createNode","cls":"Ext.data.NodeInterface"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.data.NodeInterface"},{"type":"method","member":"eachChild","id":"method-eachChild","cls":"Ext.data.NodeInterface"},{"type":"method","member":"expand","id":"method-expand","cls":"Ext.data.NodeInterface"},{"type":"method","member":"expandChildren","id":"method-expandChildren","cls":"Ext.data.NodeInterface"},{"type":"method","member":"findChild","id":"method-findChild","cls":"Ext.data.NodeInterface"},{"type":"method","member":"findChildBy","id":"method-findChildBy","cls":"Ext.data.NodeInterface"},{"type":"method","member":"getChildAt","id":"method-getChildAt","cls":"Ext.data.NodeInterface"},{"type":"method","member":"getDepth","id":"method-getDepth","cls":"Ext.data.NodeInterface"},{"type":"method","member":"getPath","id":"method-getPath","cls":"Ext.data.NodeInterface"},{"type":"method","member":"hasChildNodes","id":"method-hasChildNodes","cls":"Ext.data.NodeInterface"},{"type":"method","member":"indexOf","id":"method-indexOf","cls":"Ext.data.NodeInterface"},{"type":"method","member":"insertBefore","id":"method-insertBefore","cls":"Ext.data.NodeInterface"},{"type":"method","member":"insertChild","id":"method-insertChild","cls":"Ext.data.NodeInterface"},{"type":"method","member":"isAncestor","id":"method-isAncestor","cls":"Ext.data.NodeInterface"},{"type":"method","member":"isExpandable","id":"method-isExpandable","cls":"Ext.data.NodeInterface"},{"type":"method","member":"isExpanded","id":"method-isExpanded","cls":"Ext.data.NodeInterface"},{"type":"method","member":"isFirst","id":"method-isFirst","cls":"Ext.data.NodeInterface"},{"type":"method","member":"isLast","id":"method-isLast","cls":"Ext.data.NodeInterface"},{"type":"method","member":"isLeaf","id":"method-isLeaf","cls":"Ext.data.NodeInterface"},{"type":"method","member":"isLoaded","id":"method-isLoaded","cls":"Ext.data.NodeInterface"},{"type":"method","member":"isLoading","id":"method-isLoading","cls":"Ext.data.NodeInterface"},{"type":"method","member":"isRoot","id":"method-isRoot","cls":"Ext.data.NodeInterface"},{"type":"method","member":"isVisible","id":"method-isVisible","cls":"Ext.data.NodeInterface"},{"type":"method","member":"remove","id":"method-remove","cls":"Ext.data.NodeInterface"},{"type":"method","member":"removeAll","id":"method-removeAll","cls":"Ext.data.NodeInterface"},{"type":"method","member":"removeChild","id":"method-removeChild","cls":"Ext.data.NodeInterface"},{"type":"method","member":"replaceChild","id":"method-replaceChild","cls":"Ext.data.NodeInterface"},{"type":"method","member":"sort","id":"method-sort","cls":"Ext.data.NodeInterface"},{"type":"method","member":"updateInfo","id":"method-updateInfo","cls":"Ext.data.NodeInterface"},{"type":"event","member":"append","id":"event-append","cls":"Ext.data.NodeInterface"},{"type":"event","member":"beforeappend","id":"event-beforeappend","cls":"Ext.data.NodeInterface"},{"type":"event","member":"beforecollapse","id":"event-beforecollapse","cls":"Ext.data.NodeInterface"},{"type":"event","member":"beforeexpand","id":"event-beforeexpand","cls":"Ext.data.NodeInterface"},{"type":"event","member":"beforeinsert","id":"event-beforeinsert","cls":"Ext.data.NodeInterface"},{"type":"event","member":"beforemove","id":"event-beforemove","cls":"Ext.data.NodeInterface"},{"type":"event","member":"beforeremove","id":"event-beforeremove","cls":"Ext.data.NodeInterface"},{"type":"event","member":"collapse","id":"event-collapse","cls":"Ext.data.NodeInterface"},{"type":"event","member":"expand","id":"event-expand","cls":"Ext.data.NodeInterface"},{"type":"event","member":"insert","id":"event-insert","cls":"Ext.data.NodeInterface"},{"type":"event","member":"move","id":"event-move","cls":"Ext.data.NodeInterface"},{"type":"event","member":"remove","id":"event-remove","cls":"Ext.data.NodeInterface"},{"type":"event","member":"sort","id":"event-sort","cls":"Ext.data.NodeInterface"},{"type":"method","member":"decorate","id":"static-method-decorate","cls":"Ext.data.NodeInterface"},{"type":"cls","member":"NodeStore","cls":"Ext.data.NodeStore","xtypes":{"store":["node"]}},{"type":"cfg","member":"node","id":"cfg-node","cls":"Ext.data.NodeStore"},{"type":"cfg","member":"recursive","id":"cfg-recursive","cls":"Ext.data.NodeStore"},{"type":"cfg","member":"rootVisible","id":"cfg-rootVisible","cls":"Ext.data.NodeStore"},{"type":"cls","member":"Operation","cls":"Ext.data.Operation","xtypes":{}},{"type":"property","member":"actionCommitRecordsRe","id":"property-actionCommitRecordsRe","cls":"Ext.data.Operation"},{"type":"property","member":"actionSkipSyncRe","id":"property-actionSkipSyncRe","cls":"Ext.data.Operation"},{"type":"cfg","member":"action","id":"cfg-action","cls":"Ext.data.Operation"},{"type":"cfg","member":"batch","id":"cfg-batch","cls":"Ext.data.Operation"},{"type":"cfg","member":"callback","id":"cfg-callback","cls":"Ext.data.Operation"},{"type":"cfg","member":"filters","id":"cfg-filters","cls":"Ext.data.Operation"},{"type":"cfg","member":"group","id":"cfg-group","cls":"Ext.data.Operation"},{"type":"cfg","member":"limit","id":"cfg-limit","cls":"Ext.data.Operation"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.data.Operation"},{"type":"cfg","member":"sorters","id":"cfg-sorters","cls":"Ext.data.Operation"},{"type":"cfg","member":"start","id":"cfg-start","cls":"Ext.data.Operation"},{"type":"cfg","member":"synchronous","id":"cfg-synchronous","cls":"Ext.data.Operation"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.Operation"},{"type":"method","member":"allowWrite","id":"method-allowWrite","cls":"Ext.data.Operation"},{"type":"method","member":"commitRecords","id":"method-commitRecords","cls":"Ext.data.Operation"},{"type":"method","member":"getError","id":"method-getError","cls":"Ext.data.Operation"},{"type":"method","member":"getRecords","id":"method-getRecords","cls":"Ext.data.Operation"},{"type":"method","member":"getResultSet","id":"method-getResultSet","cls":"Ext.data.Operation"},{"type":"method","member":"hasException","id":"method-hasException","cls":"Ext.data.Operation"},{"type":"method","member":"isComplete","id":"method-isComplete","cls":"Ext.data.Operation"},{"type":"method","member":"isRunning","id":"method-isRunning","cls":"Ext.data.Operation"},{"type":"method","member":"isStarted","id":"method-isStarted","cls":"Ext.data.Operation"},{"type":"method","member":"setCompleted","id":"method-setCompleted","cls":"Ext.data.Operation"},{"type":"method","member":"setException","id":"method-setException","cls":"Ext.data.Operation"},{"type":"method","member":"setStarted","id":"method-setStarted","cls":"Ext.data.Operation"},{"type":"method","member":"setSuccessful","id":"method-setSuccessful","cls":"Ext.data.Operation"},{"type":"method","member":"wasSuccessful","id":"method-wasSuccessful","cls":"Ext.data.Operation"},{"type":"cls","member":"Ajax","cls":"Ext.data.proxy.Ajax","xtypes":{"proxy":["ajax"]}},{"type":"property","member":"actionMethods","id":"property-actionMethods","cls":"Ext.data.proxy.Ajax"},{"type":"cfg","member":"headers","id":"cfg-headers","cls":"Ext.data.proxy.Ajax"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.proxy.Ajax"},{"type":"method","member":"getMethod","id":"method-getMethod","cls":"Ext.data.proxy.Ajax"},{"type":"cls","member":"Client","cls":"Ext.data.proxy.Client","xtypes":{}},{"type":"method","member":"clear","id":"method-clear","cls":"Ext.data.proxy.Client"},{"type":"cls","member":"Direct","cls":"Ext.data.proxy.Direct","xtypes":{"proxy":["direct"]}},{"type":"cfg","member":"api","id":"cfg-api","cls":"Ext.data.proxy.Direct"},{"type":"cfg","member":"directFn","id":"cfg-directFn","cls":"Ext.data.proxy.Direct"},{"type":"cfg","member":"extraParams","id":"cfg-extraParams","cls":"Ext.data.proxy.Direct"},{"type":"cfg","member":"paramOrder","id":"cfg-paramOrder","cls":"Ext.data.proxy.Direct"},{"type":"cfg","member":"paramsAsHash","id":"cfg-paramsAsHash","cls":"Ext.data.proxy.Direct"},{"type":"cls","member":"JsonP","cls":"Ext.data.proxy.JsonP","xtypes":{"proxy":["jsonp","scripttag"]}},{"type":"cfg","member":"autoAppendParams","id":"cfg-autoAppendParams","cls":"Ext.data.proxy.JsonP"},{"type":"cfg","member":"callbackKey","id":"cfg-callbackKey","cls":"Ext.data.proxy.JsonP"},{"type":"cfg","member":"recordParam","id":"cfg-recordParam","cls":"Ext.data.proxy.JsonP"},{"type":"method","member":"abort","id":"method-abort","cls":"Ext.data.proxy.JsonP"},{"type":"method","member":"buildUrl","id":"method-buildUrl","cls":"Ext.data.proxy.JsonP"},{"type":"method","member":"encodeRecords","id":"method-encodeRecords","cls":"Ext.data.proxy.JsonP"},{"type":"event","member":"exception","id":"event-exception","cls":"Ext.data.proxy.JsonP"},{"type":"cls","member":"LocalStorage","cls":"Ext.data.proxy.LocalStorage","xtypes":{"proxy":["localstorage"]}},{"type":"cls","member":"Memory","cls":"Ext.data.proxy.Memory","xtypes":{"proxy":["memory"]}},{"type":"cfg","member":"data","id":"cfg-data","cls":"Ext.data.proxy.Memory"},{"type":"method","member":"read","id":"method-read","cls":"Ext.data.proxy.Memory"},{"type":"cls","member":"Proxy","cls":"Ext.data.proxy.Proxy","xtypes":{"proxy":["proxy"]}},{"type":"cfg","member":"batchActions","id":"cfg-batchActions","cls":"Ext.data.proxy.Proxy"},{"type":"cfg","member":"batchOrder","id":"cfg-batchOrder","cls":"Ext.data.proxy.Proxy"},{"type":"cfg","member":"model","id":"cfg-model","cls":"Ext.data.proxy.Proxy"},{"type":"cfg","member":"reader","id":"cfg-reader","cls":"Ext.data.proxy.Proxy"},{"type":"cfg","member":"writer","id":"cfg-writer","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"batch","id":"method-batch","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"create","id":"method-create","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"getModel","id":"method-getModel","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"getReader","id":"method-getReader","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"getWriter","id":"method-getWriter","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"read","id":"method-read","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"setModel","id":"method-setModel","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"setReader","id":"method-setReader","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"setWriter","id":"method-setWriter","cls":"Ext.data.proxy.Proxy"},{"type":"method","member":"update","id":"method-update","cls":"Ext.data.proxy.Proxy"},{"type":"cls","member":"Rest","cls":"Ext.data.proxy.Rest","xtypes":{"proxy":["rest"]}},{"type":"property","member":"actionMethods","id":"property-actionMethods","cls":"Ext.data.proxy.Rest"},{"type":"cfg","member":"appendId","id":"cfg-appendId","cls":"Ext.data.proxy.Rest"},{"type":"cfg","member":"batchActions","id":"cfg-batchActions","cls":"Ext.data.proxy.Rest"},{"type":"cfg","member":"format","id":"cfg-format","cls":"Ext.data.proxy.Rest"},{"type":"method","member":"buildUrl","id":"method-buildUrl","cls":"Ext.data.proxy.Rest"},{"type":"cls","member":"Server","cls":"Ext.data.proxy.Server","xtypes":{"proxy":["server"]}},{"type":"cfg","member":"api","id":"cfg-api","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"cacheString","id":"cfg-cacheString","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"directionParam","id":"cfg-directionParam","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"extraParams","id":"cfg-extraParams","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"filterParam","id":"cfg-filterParam","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"groupParam","id":"cfg-groupParam","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"limitParam","id":"cfg-limitParam","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"noCache","id":"cfg-noCache","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"pageParam","id":"cfg-pageParam","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"simpleSortMode","id":"cfg-simpleSortMode","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"sortParam","id":"cfg-sortParam","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"startParam","id":"cfg-startParam","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"timeout","id":"cfg-timeout","cls":"Ext.data.proxy.Server"},{"type":"cfg","member":"url","id":"cfg-url","cls":"Ext.data.proxy.Server"},{"type":"method","member":"afterRequest","id":"method-afterRequest","cls":"Ext.data.proxy.Server"},{"type":"method","member":"buildRequest","id":"method-buildRequest","cls":"Ext.data.proxy.Server"},{"type":"method","member":"buildUrl","id":"method-buildUrl","cls":"Ext.data.proxy.Server"},{"type":"method","member":"doRequest","id":"method-doRequest","cls":"Ext.data.proxy.Server"},{"type":"method","member":"encodeFilters","id":"method-encodeFilters","cls":"Ext.data.proxy.Server"},{"type":"method","member":"encodeSorters","id":"method-encodeSorters","cls":"Ext.data.proxy.Server"},{"type":"event","member":"exception","id":"event-exception","cls":"Ext.data.proxy.Server"},{"type":"cls","member":"SessionStorage","cls":"Ext.data.proxy.SessionStorage","xtypes":{"proxy":["sessionstorage"]}},{"type":"cls","member":"WebStorage","cls":"Ext.data.proxy.WebStorage","xtypes":{}},{"type":"property","member":"cache","id":"property-cache","cls":"Ext.data.proxy.WebStorage"},{"type":"cfg","member":"id","id":"cfg-id","cls":"Ext.data.proxy.WebStorage"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.proxy.WebStorage"},{"type":"method","member":"clear","id":"method-clear","cls":"Ext.data.proxy.WebStorage"},{"type":"method","member":"setRecord","id":"method-setRecord","cls":"Ext.data.proxy.WebStorage"},{"type":"cls","member":"Array","cls":"Ext.data.reader.Array","xtypes":{"reader":["array"]}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.reader.Array"},{"type":"cls","member":"Json","cls":"Ext.data.reader.Json","xtypes":{"reader":["json"]}},{"type":"property","member":"jsonData","id":"property-jsonData","cls":"Ext.data.reader.Json"},{"type":"cfg","member":"record","id":"cfg-record","cls":"Ext.data.reader.Json"},{"type":"cfg","member":"useSimpleAccessors","id":"cfg-useSimpleAccessors","cls":"Ext.data.reader.Json"},{"type":"method","member":"readRecords","id":"method-readRecords","cls":"Ext.data.reader.Json"},{"type":"cls","member":"Reader","cls":"Ext.data.reader.Reader","xtypes":{}},{"type":"property","member":"rawData","id":"property-rawData","cls":"Ext.data.reader.Reader"},{"type":"cfg","member":"idProperty","id":"cfg-idProperty","cls":"Ext.data.reader.Reader"},{"type":"cfg","member":"implicitIncludes","id":"cfg-implicitIncludes","cls":"Ext.data.reader.Reader"},{"type":"cfg","member":"messageProperty","id":"cfg-messageProperty","cls":"Ext.data.reader.Reader"},{"type":"cfg","member":"root","id":"cfg-root","cls":"Ext.data.reader.Reader"},{"type":"cfg","member":"successProperty","id":"cfg-successProperty","cls":"Ext.data.reader.Reader"},{"type":"cfg","member":"totalProperty","id":"cfg-totalProperty","cls":"Ext.data.reader.Reader"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.reader.Reader"},{"type":"method","member":"getResponseData","id":"method-getResponseData","cls":"Ext.data.reader.Reader"},{"type":"method","member":"read","id":"method-read","cls":"Ext.data.reader.Reader"},{"type":"method","member":"readRecords","id":"method-readRecords","cls":"Ext.data.reader.Reader"},{"type":"cls","member":"Xml","cls":"Ext.data.reader.Xml","xtypes":{"reader":["xml"]}},{"type":"property","member":"xmlData","id":"property-xmlData","cls":"Ext.data.reader.Xml"},{"type":"cfg","member":"record","id":"cfg-record","cls":"Ext.data.reader.Xml"},{"type":"method","member":"getData","id":"method-getData","cls":"Ext.data.reader.Xml"},{"type":"method","member":"readRecords","id":"method-readRecords","cls":"Ext.data.reader.Xml"},{"type":"cls","member":"Request","cls":"Ext.data.Request","xtypes":{}},{"type":"cfg","member":"action","id":"cfg-action","cls":"Ext.data.Request"},{"type":"cfg","member":"method","id":"cfg-method","cls":"Ext.data.Request"},{"type":"cfg","member":"params","id":"cfg-params","cls":"Ext.data.Request"},{"type":"cfg","member":"url","id":"cfg-url","cls":"Ext.data.Request"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.Request"},{"type":"cls","member":"ResultSet","cls":"Ext.data.ResultSet","xtypes":{}},{"type":"property","member":"totalRecords","id":"property-totalRecords","cls":"Ext.data.ResultSet"},{"type":"cfg","member":"count","id":"cfg-count","cls":"Ext.data.ResultSet"},{"type":"cfg","member":"loaded","id":"cfg-loaded","cls":"Ext.data.ResultSet"},{"type":"cfg","member":"records","id":"cfg-records","cls":"Ext.data.ResultSet"},{"type":"cfg","member":"success","id":"cfg-success","cls":"Ext.data.ResultSet"},{"type":"cfg","member":"total","id":"cfg-total","cls":"Ext.data.ResultSet"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.ResultSet"},{"type":"cls","member":"SequentialIdGenerator","cls":"Ext.data.SequentialIdGenerator","xtypes":{"idgen":["sequential"]}},{"type":"cfg","member":"prefix","id":"cfg-prefix","cls":"Ext.data.SequentialIdGenerator"},{"type":"cfg","member":"seed","id":"cfg-seed","cls":"Ext.data.SequentialIdGenerator"},{"type":"method","member":"generate","id":"method-generate","cls":"Ext.data.SequentialIdGenerator"},{"type":"cls","member":"SortTypes","cls":"Ext.data.SortTypes","xtypes":{}},{"type":"property","member":"stripTagsRE","id":"property-stripTagsRE","cls":"Ext.data.SortTypes"},{"type":"method","member":"asDate","id":"method-asDate","cls":"Ext.data.SortTypes"},{"type":"method","member":"asFloat","id":"method-asFloat","cls":"Ext.data.SortTypes"},{"type":"method","member":"asInt","id":"method-asInt","cls":"Ext.data.SortTypes"},{"type":"method","member":"asText","id":"method-asText","cls":"Ext.data.SortTypes"},{"type":"method","member":"asUCString","id":"method-asUCString","cls":"Ext.data.SortTypes"},{"type":"method","member":"asUCText","id":"method-asUCText","cls":"Ext.data.SortTypes"},{"type":"method","member":"none","id":"method-none","cls":"Ext.data.SortTypes"},{"type":"cls","member":"Store","cls":"Ext.data.Store","xtypes":{"store":["store"]}},{"type":"property","member":"currentPage","id":"property-currentPage","cls":"Ext.data.Store"},{"type":"property","member":"data","id":"property-data","cls":"Ext.data.Store"},{"type":"property","member":"groupDir","id":"property-groupDir","cls":"Ext.data.Store"},{"type":"property","member":"groupField","id":"property-groupField","cls":"Ext.data.Store"},{"type":"property","member":"groupers","id":"property-groupers","cls":"Ext.data.Store"},{"type":"property","member":"snapshot","id":"property-snapshot","cls":"Ext.data.Store"},{"type":"cfg","member":"buffered","id":"cfg-buffered","cls":"Ext.data.Store"},{"type":"cfg","member":"clearOnPageLoad","id":"cfg-clearOnPageLoad","cls":"Ext.data.Store"},{"type":"cfg","member":"data","id":"cfg-data","cls":"Ext.data.Store"},{"type":"cfg","member":"pageSize","id":"cfg-pageSize","cls":"Ext.data.Store"},{"type":"cfg","member":"proxy","id":"cfg-proxy","cls":"Ext.data.Store"},{"type":"cfg","member":"purgePageCount","id":"cfg-purgePageCount","cls":"Ext.data.Store"},{"type":"cfg","member":"remoteFilter","id":"cfg-remoteFilter","cls":"Ext.data.Store"},{"type":"cfg","member":"remoteGroup","id":"cfg-remoteGroup","cls":"Ext.data.Store"},{"type":"cfg","member":"remoteSort","id":"cfg-remoteSort","cls":"Ext.data.Store"},{"type":"cfg","member":"sortOnFilter","id":"cfg-sortOnFilter","cls":"Ext.data.Store"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.Store"},{"type":"method","member":"add","id":"method-add","cls":"Ext.data.Store"},{"type":"method","member":"aggregate","id":"method-aggregate","cls":"Ext.data.Store"},{"type":"method","member":"average","id":"method-average","cls":"Ext.data.Store"},{"type":"method","member":"clearFilter","id":"method-clearFilter","cls":"Ext.data.Store"},{"type":"method","member":"clearGrouping","id":"method-clearGrouping","cls":"Ext.data.Store"},{"type":"method","member":"collect","id":"method-collect","cls":"Ext.data.Store"},{"type":"method","member":"count","id":"method-count","cls":"Ext.data.Store"},{"type":"method","member":"each","id":"method-each","cls":"Ext.data.Store"},{"type":"method","member":"filter","id":"method-filter","cls":"Ext.data.Store"},{"type":"method","member":"filterBy","id":"method-filterBy","cls":"Ext.data.Store"},{"type":"method","member":"find","id":"method-find","cls":"Ext.data.Store"},{"type":"method","member":"findBy","id":"method-findBy","cls":"Ext.data.Store"},{"type":"method","member":"findExact","id":"method-findExact","cls":"Ext.data.Store"},{"type":"method","member":"findRecord","id":"method-findRecord","cls":"Ext.data.Store"},{"type":"method","member":"first","id":"method-first","cls":"Ext.data.Store"},{"type":"method","member":"getAt","id":"method-getAt","cls":"Ext.data.Store"},{"type":"method","member":"getById","id":"method-getById","cls":"Ext.data.Store"},{"type":"method","member":"getCount","id":"method-getCount","cls":"Ext.data.Store"},{"type":"method","member":"getGroupString","id":"method-getGroupString","cls":"Ext.data.Store"},{"type":"method","member":"getGroups","id":"method-getGroups","cls":"Ext.data.Store"},{"type":"method","member":"getPageFromRecordIndex","id":"method-getPageFromRecordIndex","cls":"Ext.data.Store"},{"type":"method","member":"getRange","id":"method-getRange","cls":"Ext.data.Store"},{"type":"method","member":"getTotalCount","id":"method-getTotalCount","cls":"Ext.data.Store"},{"type":"method","member":"group","id":"method-group","cls":"Ext.data.Store"},{"type":"method","member":"guaranteeRange","id":"method-guaranteeRange","cls":"Ext.data.Store"},{"type":"method","member":"hasPendingRequests","id":"method-hasPendingRequests","cls":"Ext.data.Store"},{"type":"method","member":"indexOf","id":"method-indexOf","cls":"Ext.data.Store"},{"type":"method","member":"indexOfId","id":"method-indexOfId","cls":"Ext.data.Store"},{"type":"method","member":"indexOfTotal","id":"method-indexOfTotal","cls":"Ext.data.Store"},{"type":"method","member":"insert","id":"method-insert","cls":"Ext.data.Store"},{"type":"method","member":"isFiltered","id":"method-isFiltered","cls":"Ext.data.Store"},{"type":"method","member":"isGrouped","id":"method-isGrouped","cls":"Ext.data.Store"},{"type":"method","member":"last","id":"method-last","cls":"Ext.data.Store"},{"type":"method","member":"load","id":"method-load","cls":"Ext.data.Store"},{"type":"method","member":"loadData","id":"method-loadData","cls":"Ext.data.Store"},{"type":"method","member":"loadPage","id":"method-loadPage","cls":"Ext.data.Store"},{"type":"method","member":"loadRawData","id":"method-loadRawData","cls":"Ext.data.Store"},{"type":"method","member":"loadRecords","id":"method-loadRecords","cls":"Ext.data.Store"},{"type":"method","member":"max","id":"method-max","cls":"Ext.data.Store"},{"type":"method","member":"min","id":"method-min","cls":"Ext.data.Store"},{"type":"method","member":"nextPage","id":"method-nextPage","cls":"Ext.data.Store"},{"type":"method","member":"prefetch","id":"method-prefetch","cls":"Ext.data.Store"},{"type":"method","member":"prefetchPage","id":"method-prefetchPage","cls":"Ext.data.Store"},{"type":"method","member":"previousPage","id":"method-previousPage","cls":"Ext.data.Store"},{"type":"method","member":"purgeRecords","id":"method-purgeRecords","cls":"Ext.data.Store"},{"type":"method","member":"queryBy","id":"method-queryBy","cls":"Ext.data.Store"},{"type":"method","member":"remove","id":"method-remove","cls":"Ext.data.Store"},{"type":"method","member":"removeAll","id":"method-removeAll","cls":"Ext.data.Store"},{"type":"method","member":"removeAt","id":"method-removeAt","cls":"Ext.data.Store"},{"type":"method","member":"sum","id":"method-sum","cls":"Ext.data.Store"},{"type":"event","member":"beforeprefetch","id":"event-beforeprefetch","cls":"Ext.data.Store"},{"type":"event","member":"groupchange","id":"event-groupchange","cls":"Ext.data.Store"},{"type":"event","member":"load","id":"event-load","cls":"Ext.data.Store"},{"type":"cls","member":"StoreManager","cls":"Ext.data.StoreManager","xtypes":{}},{"type":"method","member":"lookup","id":"method-lookup","cls":"Ext.data.StoreManager"},{"type":"method","member":"register","id":"method-register","cls":"Ext.data.StoreManager"},{"type":"method","member":"unregister","id":"method-unregister","cls":"Ext.data.StoreManager"},{"type":"cls","member":"Tree","cls":"Ext.data.Tree","xtypes":{"data":["tree"]}},{"type":"property","member":"root","id":"property-root","cls":"Ext.data.Tree"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.Tree"},{"type":"method","member":"getNodeById","id":"method-getNodeById","cls":"Ext.data.Tree"},{"type":"method","member":"getRootNode","id":"method-getRootNode","cls":"Ext.data.Tree"},{"type":"method","member":"setRootNode","id":"method-setRootNode","cls":"Ext.data.Tree"},{"type":"event","member":"append","id":"event-append","cls":"Ext.data.Tree"},{"type":"event","member":"beforeappend","id":"event-beforeappend","cls":"Ext.data.Tree"},{"type":"event","member":"beforecollapse","id":"event-beforecollapse","cls":"Ext.data.Tree"},{"type":"event","member":"beforeexpand","id":"event-beforeexpand","cls":"Ext.data.Tree"},{"type":"event","member":"beforeinsert","id":"event-beforeinsert","cls":"Ext.data.Tree"},{"type":"event","member":"beforemove","id":"event-beforemove","cls":"Ext.data.Tree"},{"type":"event","member":"beforeremove","id":"event-beforeremove","cls":"Ext.data.Tree"},{"type":"event","member":"collapse","id":"event-collapse","cls":"Ext.data.Tree"},{"type":"event","member":"expand","id":"event-expand","cls":"Ext.data.Tree"},{"type":"event","member":"insert","id":"event-insert","cls":"Ext.data.Tree"},{"type":"event","member":"move","id":"event-move","cls":"Ext.data.Tree"},{"type":"event","member":"remove","id":"event-remove","cls":"Ext.data.Tree"},{"type":"event","member":"rootchange","id":"event-rootchange","cls":"Ext.data.Tree"},{"type":"cls","member":"TreeStore","cls":"Ext.data.TreeStore","xtypes":{"store":["tree"]}},{"type":"property","member":"fields","id":"property-fields","cls":"Ext.data.TreeStore"},{"type":"cfg","member":"clearOnLoad","id":"cfg-clearOnLoad","cls":"Ext.data.TreeStore"},{"type":"cfg","member":"defaultRootId","id":"cfg-defaultRootId","cls":"Ext.data.TreeStore"},{"type":"cfg","member":"defaultRootProperty","id":"cfg-defaultRootProperty","cls":"Ext.data.TreeStore"},{"type":"cfg","member":"folderSort","id":"cfg-folderSort","cls":"Ext.data.TreeStore"},{"type":"cfg","member":"nodeParam","id":"cfg-nodeParam","cls":"Ext.data.TreeStore"},{"type":"cfg","member":"root","id":"cfg-root","cls":"Ext.data.TreeStore"},{"type":"method","member":"getNodeById","id":"method-getNodeById","cls":"Ext.data.TreeStore"},{"type":"method","member":"getRootNode","id":"method-getRootNode","cls":"Ext.data.TreeStore"},{"type":"method","member":"load","id":"method-load","cls":"Ext.data.TreeStore"},{"type":"method","member":"setRootNode","id":"method-setRootNode","cls":"Ext.data.TreeStore"},{"type":"event","member":"append","id":"event-append","cls":"Ext.data.TreeStore"},{"type":"event","member":"beforeappend","id":"event-beforeappend","cls":"Ext.data.TreeStore"},{"type":"event","member":"beforecollapse","id":"event-beforecollapse","cls":"Ext.data.TreeStore"},{"type":"event","member":"beforeexpand","id":"event-beforeexpand","cls":"Ext.data.TreeStore"},{"type":"event","member":"beforeinsert","id":"event-beforeinsert","cls":"Ext.data.TreeStore"},{"type":"event","member":"beforemove","id":"event-beforemove","cls":"Ext.data.TreeStore"},{"type":"event","member":"beforeremove","id":"event-beforeremove","cls":"Ext.data.TreeStore"},{"type":"event","member":"collapse","id":"event-collapse","cls":"Ext.data.TreeStore"},{"type":"event","member":"expand","id":"event-expand","cls":"Ext.data.TreeStore"},{"type":"event","member":"insert","id":"event-insert","cls":"Ext.data.TreeStore"},{"type":"event","member":"load","id":"event-load","cls":"Ext.data.TreeStore"},{"type":"event","member":"move","id":"event-move","cls":"Ext.data.TreeStore"},{"type":"event","member":"remove","id":"event-remove","cls":"Ext.data.TreeStore"},{"type":"event","member":"rootchange","id":"event-rootchange","cls":"Ext.data.TreeStore"},{"type":"event","member":"sort","id":"event-sort","cls":"Ext.data.TreeStore"},{"type":"cls","member":"Types","cls":"Ext.data.Types","xtypes":{}},{"type":"property","member":"AUTO","id":"property-AUTO","cls":"Ext.data.Types"},{"type":"property","member":"BOOL","id":"property-BOOL","cls":"Ext.data.Types"},{"type":"property","member":"BOOLEAN","id":"property-BOOLEAN","cls":"Ext.data.Types"},{"type":"property","member":"DATE","id":"property-DATE","cls":"Ext.data.Types"},{"type":"property","member":"FLOAT","id":"property-FLOAT","cls":"Ext.data.Types"},{"type":"property","member":"INT","id":"property-INT","cls":"Ext.data.Types"},{"type":"property","member":"INTEGER","id":"property-INTEGER","cls":"Ext.data.Types"},{"type":"property","member":"NUMBER","id":"property-NUMBER","cls":"Ext.data.Types"},{"type":"property","member":"STRING","id":"property-STRING","cls":"Ext.data.Types"},{"type":"property","member":"stripRe","id":"property-stripRe","cls":"Ext.data.Types"},{"type":"cls","member":"UuidGenerator","cls":"Ext.data.UuidGenerator","xtypes":{}},{"type":"property","member":"salt","id":"property-salt","cls":"Ext.data.UuidGenerator"},{"type":"property","member":"timestamp","id":"property-timestamp","cls":"Ext.data.UuidGenerator"},{"type":"cfg","member":"version","id":"cfg-version","cls":"Ext.data.UuidGenerator"},{"type":"method","member":"reconfigure","id":"method-reconfigure","cls":"Ext.data.UuidGenerator"},{"type":"cls","member":"validations","cls":"Ext.data.validations","xtypes":{}},{"type":"property","member":"emailMessage","id":"property-emailMessage","cls":"Ext.data.validations"},{"type":"property","member":"emailRe","id":"property-emailRe","cls":"Ext.data.validations"},{"type":"property","member":"exclusionMessage","id":"property-exclusionMessage","cls":"Ext.data.validations"},{"type":"property","member":"formatMessage","id":"property-formatMessage","cls":"Ext.data.validations"},{"type":"property","member":"inclusionMessage","id":"property-inclusionMessage","cls":"Ext.data.validations"},{"type":"property","member":"lengthMessage","id":"property-lengthMessage","cls":"Ext.data.validations"},{"type":"property","member":"presenceMessage","id":"property-presenceMessage","cls":"Ext.data.validations"},{"type":"method","member":"email","id":"method-email","cls":"Ext.data.validations"},{"type":"method","member":"exclusion","id":"method-exclusion","cls":"Ext.data.validations"},{"type":"method","member":"format","id":"method-format","cls":"Ext.data.validations"},{"type":"method","member":"inclusion","id":"method-inclusion","cls":"Ext.data.validations"},{"type":"method","member":"length","id":"method-length","cls":"Ext.data.validations"},{"type":"method","member":"presence","id":"method-presence","cls":"Ext.data.validations"},{"type":"cls","member":"Json","cls":"Ext.data.writer.Json","xtypes":{"writer":["json"]}},{"type":"cfg","member":"allowSingle","id":"cfg-allowSingle","cls":"Ext.data.writer.Json"},{"type":"cfg","member":"encode","id":"cfg-encode","cls":"Ext.data.writer.Json"},{"type":"cfg","member":"root","id":"cfg-root","cls":"Ext.data.writer.Json"},{"type":"cls","member":"Writer","cls":"Ext.data.writer.Writer","xtypes":{"writer":["base"]}},{"type":"cfg","member":"nameProperty","id":"cfg-nameProperty","cls":"Ext.data.writer.Writer"},{"type":"cfg","member":"writeAllFields","id":"cfg-writeAllFields","cls":"Ext.data.writer.Writer"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.data.writer.Writer"},{"type":"method","member":"getRecordData","id":"method-getRecordData","cls":"Ext.data.writer.Writer"},{"type":"method","member":"write","id":"method-write","cls":"Ext.data.writer.Writer"},{"type":"cls","member":"Xml","cls":"Ext.data.writer.Xml","xtypes":{"writer":["xml"]}},{"type":"cfg","member":"defaultDocumentRoot","id":"cfg-defaultDocumentRoot","cls":"Ext.data.writer.Xml"},{"type":"cfg","member":"documentRoot","id":"cfg-documentRoot","cls":"Ext.data.writer.Xml"},{"type":"cfg","member":"header","id":"cfg-header","cls":"Ext.data.writer.Xml"},{"type":"cfg","member":"record","id":"cfg-record","cls":"Ext.data.writer.Xml"},{"type":"cls","member":"XmlStore","cls":"Ext.data.XmlStore","xtypes":{"widget":["xmlstore"]}},{"type":"cls","member":"Event","cls":"Ext.direct.Event","xtypes":{"direct":["event"]}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.direct.Event"},{"type":"method","member":"getData","id":"method-getData","cls":"Ext.direct.Event"},{"type":"cls","member":"ExceptionEvent","cls":"Ext.direct.ExceptionEvent","xtypes":{"direct":["exception"]}},{"type":"cls","member":"JsonProvider","cls":"Ext.direct.JsonProvider","xtypes":{"direct":["jsonprovider"]}},{"type":"method","member":"createEvent","id":"method-createEvent","cls":"Ext.direct.JsonProvider"},{"type":"cls","member":"Manager","cls":"Ext.direct.Manager","xtypes":{}},{"type":"method","member":"addProvider","id":"method-addProvider","cls":"Ext.direct.Manager"},{"type":"method","member":"getProvider","id":"method-getProvider","cls":"Ext.direct.Manager"},{"type":"method","member":"removeProvider","id":"method-removeProvider","cls":"Ext.direct.Manager"},{"type":"event","member":"event","id":"event-event","cls":"Ext.direct.Manager"},{"type":"event","member":"exception","id":"event-exception","cls":"Ext.direct.Manager"},{"type":"cls","member":"PollingProvider","cls":"Ext.direct.PollingProvider","xtypes":{"direct":["pollingprovider"]}},{"type":"cfg","member":"baseParams","id":"cfg-baseParams","cls":"Ext.direct.PollingProvider"},{"type":"cfg","member":"interval","id":"cfg-interval","cls":"Ext.direct.PollingProvider"},{"type":"cfg","member":"url","id":"cfg-url","cls":"Ext.direct.PollingProvider"},{"type":"method","member":"connect","id":"method-connect","cls":"Ext.direct.PollingProvider"},{"type":"method","member":"disconnect","id":"method-disconnect","cls":"Ext.direct.PollingProvider"},{"type":"event","member":"beforepoll","id":"event-beforepoll","cls":"Ext.direct.PollingProvider"},{"type":"event","member":"poll","id":"event-poll","cls":"Ext.direct.PollingProvider"},{"type":"cls","member":"Provider","cls":"Ext.direct.Provider","xtypes":{"direct":["provider"]}},{"type":"cfg","member":"id","id":"cfg-id","cls":"Ext.direct.Provider"},{"type":"method","member":"connect","id":"method-connect","cls":"Ext.direct.Provider"},{"type":"method","member":"disconnect","id":"method-disconnect","cls":"Ext.direct.Provider"},{"type":"method","member":"isConnected","id":"method-isConnected","cls":"Ext.direct.Provider"},{"type":"event","member":"connect","id":"event-connect","cls":"Ext.direct.Provider"},{"type":"event","member":"data","id":"event-data","cls":"Ext.direct.Provider"},{"type":"event","member":"disconnect","id":"event-disconnect","cls":"Ext.direct.Provider"},{"type":"event","member":"exception","id":"event-exception","cls":"Ext.direct.Provider"},{"type":"cls","member":"RemotingEvent","cls":"Ext.direct.RemotingEvent","xtypes":{"direct":["rpc"]}},{"type":"method","member":"getTransaction","id":"method-getTransaction","cls":"Ext.direct.RemotingEvent"},{"type":"cls","member":"RemotingMethod","cls":"Ext.direct.RemotingMethod","xtypes":{}},{"type":"method","member":"getCallData","id":"method-getCallData","cls":"Ext.direct.RemotingMethod"},{"type":"cls","member":"RemotingProvider","cls":"Ext.direct.RemotingProvider","xtypes":{"direct":["remotingprovider"]}},{"type":"cfg","member":"actions","id":"cfg-actions","cls":"Ext.direct.RemotingProvider"},{"type":"cfg","member":"enableBuffer","id":"cfg-enableBuffer","cls":"Ext.direct.RemotingProvider"},{"type":"cfg","member":"enableUrlEncode","id":"cfg-enableUrlEncode","cls":"Ext.direct.RemotingProvider"},{"type":"cfg","member":"maxRetries","id":"cfg-maxRetries","cls":"Ext.direct.RemotingProvider"},{"type":"cfg","member":"namespace","id":"cfg-namespace","cls":"Ext.direct.RemotingProvider"},{"type":"cfg","member":"timeout","id":"cfg-timeout","cls":"Ext.direct.RemotingProvider"},{"type":"cfg","member":"url","id":"cfg-url","cls":"Ext.direct.RemotingProvider"},{"type":"event","member":"beforecall","id":"event-beforecall","cls":"Ext.direct.RemotingProvider"},{"type":"event","member":"call","id":"event-call","cls":"Ext.direct.RemotingProvider"},{"type":"cls","member":"Transaction","cls":"Ext.direct.Transaction","xtypes":{"direct":["transaction"]}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.direct.Transaction"},{"type":"cls","member":"Color","cls":"Ext.draw.Color","xtypes":{}},{"type":"cfg","member":"lightnessFactor","id":"cfg-lightnessFactor","cls":"Ext.draw.Color"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.draw.Color"},{"type":"method","member":"getBlue","id":"method-getBlue","cls":"Ext.draw.Color"},{"type":"method","member":"getDarker","id":"method-getDarker","cls":"Ext.draw.Color"},{"type":"method","member":"getGrayscale","id":"method-getGrayscale","cls":"Ext.draw.Color"},{"type":"method","member":"getGreen","id":"method-getGreen","cls":"Ext.draw.Color"},{"type":"method","member":"getHSL","id":"method-getHSL","cls":"Ext.draw.Color"},{"type":"method","member":"getLighter","id":"method-getLighter","cls":"Ext.draw.Color"},{"type":"method","member":"getRGB","id":"method-getRGB","cls":"Ext.draw.Color"},{"type":"method","member":"getRed","id":"method-getRed","cls":"Ext.draw.Color"},{"type":"method","member":"toString","id":"method-toString","cls":"Ext.draw.Color"},{"type":"method","member":"fromHSL","id":"static-method-fromHSL","cls":"Ext.draw.Color"},{"type":"method","member":"fromString","id":"static-method-fromString","cls":"Ext.draw.Color"},{"type":"method","member":"toHex","id":"static-method-toHex","cls":"Ext.draw.Color"},{"type":"cls","member":"Component","cls":"Ext.draw.Component","xtypes":{"widget":["draw"]}},{"type":"cfg","member":"autoSize","id":"cfg-autoSize","cls":"Ext.draw.Component"},{"type":"cfg","member":"enginePriority","id":"cfg-enginePriority","cls":"Ext.draw.Component"},{"type":"cfg","member":"gradients","id":"cfg-gradients","cls":"Ext.draw.Component"},{"type":"cfg","member":"viewBox","id":"cfg-viewBox","cls":"Ext.draw.Component"},{"type":"method","member":"createSurface","id":"method-createSurface","cls":"Ext.draw.Component"},{"type":"cls","member":"CompositeSprite","cls":"Ext.draw.CompositeSprite","xtypes":{}},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.draw.CompositeSprite"},{"type":"method","member":"getBBox","id":"method-getBBox","cls":"Ext.draw.CompositeSprite"},{"type":"method","member":"hide","id":"method-hide","cls":"Ext.draw.CompositeSprite"},{"type":"method","member":"setAttributes","id":"method-setAttributes","cls":"Ext.draw.CompositeSprite"},{"type":"method","member":"show","id":"method-show","cls":"Ext.draw.CompositeSprite"},{"type":"cls","member":"Draw","cls":"Ext.draw.Draw","xtypes":{}},{"type":"method","member":"snapEnds","id":"method-snapEnds","cls":"Ext.draw.Draw"},{"type":"method","member":"snapEndsByDate","id":"method-snapEndsByDate","cls":"Ext.draw.Draw"},{"type":"method","member":"snapEndsByDateAndStep","id":"method-snapEndsByDateAndStep","cls":"Ext.draw.Draw"},{"type":"cls","member":"Svg","cls":"Ext.draw.engine.Svg","xtypes":{}},{"type":"method","member":"applyZIndex","id":"method-applyZIndex","cls":"Ext.draw.engine.Svg"},{"type":"method","member":"getRegion","id":"method-getRegion","cls":"Ext.draw.engine.Svg"},{"type":"method","member":"hasCls","id":"method-hasCls","cls":"Ext.draw.engine.Svg"},{"type":"cls","member":"Vml","cls":"Ext.draw.engine.Vml","xtypes":{}},{"type":"method","member":"addGradient","id":"method-addGradient","cls":"Ext.draw.engine.Vml"},{"type":"cls","member":"Sprite","cls":"Ext.draw.Sprite","xtypes":{}},{"type":"property","member":"dd","id":"property-dd","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"draggable","id":"cfg-draggable","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"fill","id":"cfg-fill","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"font","id":"cfg-font","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"group","id":"cfg-group","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"height","id":"cfg-height","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"opacity","id":"cfg-opacity","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"path","id":"cfg-path","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"radius","id":"cfg-radius","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"size","id":"cfg-size","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"stroke","id":"cfg-stroke","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"text","id":"cfg-text","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"type","id":"cfg-type","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"width","id":"cfg-width","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"x","id":"cfg-x","cls":"Ext.draw.Sprite"},{"type":"cfg","member":"y","id":"cfg-y","cls":"Ext.draw.Sprite"},{"type":"method","member":"addCls","id":"method-addCls","cls":"Ext.draw.Sprite"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.draw.Sprite"},{"type":"method","member":"getBBox","id":"method-getBBox","cls":"Ext.draw.Sprite"},{"type":"method","member":"hide","id":"method-hide","cls":"Ext.draw.Sprite"},{"type":"method","member":"redraw","id":"method-redraw","cls":"Ext.draw.Sprite"},{"type":"method","member":"remove","id":"method-remove","cls":"Ext.draw.Sprite"},{"type":"method","member":"removeCls","id":"method-removeCls","cls":"Ext.draw.Sprite"},{"type":"method","member":"setAttributes","id":"method-setAttributes","cls":"Ext.draw.Sprite"},{"type":"method","member":"setStyle","id":"method-setStyle","cls":"Ext.draw.Sprite"},{"type":"method","member":"show","id":"method-show","cls":"Ext.draw.Sprite"},{"type":"cls","member":"Surface","cls":"Ext.draw.Surface","xtypes":{}},{"type":"cfg","member":"height","id":"cfg-height","cls":"Ext.draw.Surface"},{"type":"cfg","member":"width","id":"cfg-width","cls":"Ext.draw.Surface"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.draw.Surface"},{"type":"method","member":"add","id":"method-add","cls":"Ext.draw.Surface"},{"type":"method","member":"addCls","id":"method-addCls","cls":"Ext.draw.Surface"},{"type":"method","member":"addGradient","id":"method-addGradient","cls":"Ext.draw.Surface"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.draw.Surface"},{"type":"method","member":"getGroup","id":"method-getGroup","cls":"Ext.draw.Surface"},{"type":"method","member":"getId","id":"method-getId","cls":"Ext.draw.Surface"},{"type":"method","member":"remove","id":"method-remove","cls":"Ext.draw.Surface"},{"type":"method","member":"removeAll","id":"method-removeAll","cls":"Ext.draw.Surface"},{"type":"method","member":"removeCls","id":"method-removeCls","cls":"Ext.draw.Surface"},{"type":"method","member":"setSize","id":"method-setSize","cls":"Ext.draw.Surface"},{"type":"method","member":"setStyle","id":"method-setStyle","cls":"Ext.draw.Surface"},{"type":"method","member":"setText","id":"method-setText","cls":"Ext.draw.Surface"},{"type":"method","member":"create","id":"static-method-create","cls":"Ext.draw.Surface"},{"type":"cls","member":"ElementLoader","cls":"Ext.ElementLoader","xtypes":{}},{"type":"cfg","member":"ajaxOptions","id":"cfg-ajaxOptions","cls":"Ext.ElementLoader"},{"type":"cfg","member":"autoLoad","id":"cfg-autoLoad","cls":"Ext.ElementLoader"},{"type":"cfg","member":"baseParams","id":"cfg-baseParams","cls":"Ext.ElementLoader"},{"type":"cfg","member":"callback","id":"cfg-callback","cls":"Ext.ElementLoader"},{"type":"cfg","member":"failure","id":"cfg-failure","cls":"Ext.ElementLoader"},{"type":"cfg","member":"loadMask","id":"cfg-loadMask","cls":"Ext.ElementLoader"},{"type":"cfg","member":"params","id":"cfg-params","cls":"Ext.ElementLoader"},{"type":"cfg","member":"renderer","id":"cfg-renderer","cls":"Ext.ElementLoader"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.ElementLoader"},{"type":"cfg","member":"scripts","id":"cfg-scripts","cls":"Ext.ElementLoader"},{"type":"cfg","member":"success","id":"cfg-success","cls":"Ext.ElementLoader"},{"type":"cfg","member":"target","id":"cfg-target","cls":"Ext.ElementLoader"},{"type":"cfg","member":"url","id":"cfg-url","cls":"Ext.ElementLoader"},{"type":"method","member":"abort","id":"method-abort","cls":"Ext.ElementLoader"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.ElementLoader"},{"type":"method","member":"getTarget","id":"method-getTarget","cls":"Ext.ElementLoader"},{"type":"method","member":"isAutoRefreshing","id":"method-isAutoRefreshing","cls":"Ext.ElementLoader"},{"type":"method","member":"load","id":"method-load","cls":"Ext.ElementLoader"},{"type":"method","member":"setTarget","id":"method-setTarget","cls":"Ext.ElementLoader"},{"type":"method","member":"startAutoRefresh","id":"method-startAutoRefresh","cls":"Ext.ElementLoader"},{"type":"method","member":"stopAutoRefresh","id":"method-stopAutoRefresh","cls":"Ext.ElementLoader"},{"type":"event","member":"beforeload","id":"event-beforeload","cls":"Ext.ElementLoader"},{"type":"event","member":"exception","id":"event-exception","cls":"Ext.ElementLoader"},{"type":"event","member":"load","id":"event-load","cls":"Ext.ElementLoader"},{"type":"cls","member":"Anim","cls":"Ext.fx.Anim","xtypes":{}},{"type":"property","member":"currentIteration","id":"property-currentIteration","cls":"Ext.fx.Anim"},{"type":"property","member":"paused","id":"property-paused","cls":"Ext.fx.Anim"},{"type":"property","member":"running","id":"property-running","cls":"Ext.fx.Anim"},{"type":"property","member":"startTime","id":"property-startTime","cls":"Ext.fx.Anim"},{"type":"cfg","member":"alternate","id":"cfg-alternate","cls":"Ext.fx.Anim"},{"type":"cfg","member":"callback","id":"cfg-callback","cls":"Ext.fx.Anim"},{"type":"cfg","member":"delay","id":"cfg-delay","cls":"Ext.fx.Anim"},{"type":"cfg","member":"duration","id":"cfg-duration","cls":"Ext.fx.Anim"},{"type":"cfg","member":"dynamic","id":"cfg-dynamic","cls":"Ext.fx.Anim"},{"type":"cfg","member":"easing","id":"cfg-easing","cls":"Ext.fx.Anim"},{"type":"cfg","member":"from","id":"cfg-from","cls":"Ext.fx.Anim"},{"type":"cfg","member":"iterations","id":"cfg-iterations","cls":"Ext.fx.Anim"},{"type":"cfg","member":"keyframes","id":"cfg-keyframes","cls":"Ext.fx.Anim"},{"type":"cfg","member":"reverse","id":"cfg-reverse","cls":"Ext.fx.Anim"},{"type":"cfg","member":"scope","id":"cfg-scope","cls":"Ext.fx.Anim"},{"type":"cfg","member":"target","id":"cfg-target","cls":"Ext.fx.Anim"},{"type":"cfg","member":"to","id":"cfg-to","cls":"Ext.fx.Anim"},{"type":"method","member":"end","id":"method-end","cls":"Ext.fx.Anim"},{"type":"event","member":"afteranimate","id":"event-afteranimate","cls":"Ext.fx.Anim"},{"type":"event","member":"beforeanimate","id":"event-beforeanimate","cls":"Ext.fx.Anim"},{"type":"event","member":"lastframe","id":"event-lastframe","cls":"Ext.fx.Anim"},{"type":"cls","member":"Animator","cls":"Ext.fx.Animator","xtypes":{}},{"type":"property","member":"currentIteration","id":"property-currentIteration","cls":"Ext.fx.Animator"},{"type":"property","member":"keyframeStep","id":"property-keyframeStep","cls":"Ext.fx.Animator"},{"type":"property","member":"paused","id":"property-paused","cls":"Ext.fx.Animator"},{"type":"property","member":"running","id":"property-running","cls":"Ext.fx.Animator"},{"type":"cfg","member":"delay","id":"cfg-delay","cls":"Ext.fx.Animator"},{"type":"cfg","member":"duration","id":"cfg-duration","cls":"Ext.fx.Animator"},{"type":"cfg","member":"dynamic","id":"cfg-dynamic","cls":"Ext.fx.Animator"},{"type":"cfg","member":"easing","id":"cfg-easing","cls":"Ext.fx.Animator"},{"type":"cfg","member":"iterations","id":"cfg-iterations","cls":"Ext.fx.Animator"},{"type":"cfg","member":"keyframes","id":"cfg-keyframes","cls":"Ext.fx.Animator"},{"type":"cfg","member":"target","id":"cfg-target","cls":"Ext.fx.Animator"},{"type":"method","member":"end","id":"method-end","cls":"Ext.fx.Animator"},{"type":"event","member":"afteranimate","id":"event-afteranimate","cls":"Ext.fx.Animator"},{"type":"event","member":"beforeanimate","id":"event-beforeanimate","cls":"Ext.fx.Animator"},{"type":"event","member":"keyframe","id":"event-keyframe","cls":"Ext.fx.Animator"},{"type":"cls","member":"CubicBezier","cls":"Ext.fx.CubicBezier","xtypes":{}},{"type":"cls","member":"Easing","cls":"Ext.fx.Easing","xtypes":{}},{"type":"cls","member":"Manager","cls":"Ext.fx.Manager","xtypes":{}},{"type":"cfg","member":"forceJS","id":"cfg-forceJS","cls":"Ext.fx.Manager"},{"type":"cfg","member":"interval","id":"cfg-interval","cls":"Ext.fx.Manager"},{"type":"method","member":"addAnim","id":"method-addAnim","cls":"Ext.fx.Manager"},{"type":"method","member":"collectTargetData","id":"method-collectTargetData","cls":"Ext.fx.Manager"},{"type":"method","member":"removeAnim","id":"method-removeAnim","cls":"Ext.fx.Manager"},{"type":"cls","member":"PropertyHandler","cls":"Ext.fx.PropertyHandler","xtypes":{}},{"type":"cls","member":"Queue","cls":"Ext.fx.Queue","xtypes":{}},{"type":"cls","member":"Component","cls":"Ext.fx.target.Component","xtypes":{}},{"type":"cls","member":"CompositeElement","cls":"Ext.fx.target.CompositeElement","xtypes":{}},{"type":"cls","member":"CompositeElementCSS","cls":"Ext.fx.target.CompositeElementCSS","xtypes":{}},{"type":"cls","member":"CompositeSprite","cls":"Ext.fx.target.CompositeSprite","xtypes":{}},{"type":"cls","member":"Element","cls":"Ext.fx.target.Element","xtypes":{}},{"type":"cls","member":"ElementCSS","cls":"Ext.fx.target.ElementCSS","xtypes":{}},{"type":"cls","member":"Sprite","cls":"Ext.fx.target.Sprite","xtypes":{}},{"type":"cls","member":"Target","cls":"Ext.fx.target.Target","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.fx.target.Target"},{"type":"cls","member":"AbstractDock","cls":"Ext.layout.component.AbstractDock","xtypes":{}},{"type":"method","member":"adjustAutoBox","id":"method-adjustAutoBox","cls":"Ext.layout.component.AbstractDock"},{"type":"method","member":"adjustSizedBox","id":"method-adjustSizedBox","cls":"Ext.layout.component.AbstractDock"},{"type":"method","member":"calculateDockBoxes","id":"method-calculateDockBoxes","cls":"Ext.layout.component.AbstractDock"},{"type":"method","member":"configureItem","id":"method-configureItem","cls":"Ext.layout.component.AbstractDock"},{"type":"method","member":"dockItems","id":"method-dockItems","cls":"Ext.layout.component.AbstractDock"},{"type":"method","member":"getLayoutItems","id":"method-getLayoutItems","cls":"Ext.layout.component.AbstractDock"},{"type":"method","member":"initBox","id":"method-initBox","cls":"Ext.layout.component.AbstractDock"},{"type":"method","member":"onLayout","id":"method-onLayout","cls":"Ext.layout.component.AbstractDock"},{"type":"method","member":"renderItems","id":"method-renderItems","cls":"Ext.layout.component.AbstractDock"},{"type":"method","member":"setBodyBox","id":"method-setBodyBox","cls":"Ext.layout.component.AbstractDock"},{"type":"cls","member":"Auto","cls":"Ext.layout.component.Auto","xtypes":{"layout":["autocomponent"]}},{"type":"cls","member":"Component","cls":"Ext.layout.component.Component","xtypes":{}},{"type":"method","member":"getRenderTarget","id":"method-getRenderTarget","cls":"Ext.layout.component.Component"},{"type":"method","member":"getTarget","id":"method-getTarget","cls":"Ext.layout.component.Component"},{"type":"method","member":"needsLayout","id":"method-needsLayout","cls":"Ext.layout.component.Component"},{"type":"method","member":"setElementSize","id":"method-setElementSize","cls":"Ext.layout.component.Component"},{"type":"method","member":"setTargetSize","id":"method-setTargetSize","cls":"Ext.layout.component.Component"},{"type":"cls","member":"Draw","cls":"Ext.layout.component.Draw","xtypes":{"layout":["draw"]}},{"type":"cls","member":"AbstractCard","cls":"Ext.layout.container.AbstractCard","xtypes":{}},{"type":"cfg","member":"deferredRender","id":"cfg-deferredRender","cls":"Ext.layout.container.AbstractCard"},{"type":"method","member":"getActiveItem","id":"method-getActiveItem","cls":"Ext.layout.container.AbstractCard"},{"type":"method","member":"getNext","id":"method-getNext","cls":"Ext.layout.container.AbstractCard"},{"type":"method","member":"getPrev","id":"method-getPrev","cls":"Ext.layout.container.AbstractCard"},{"type":"method","member":"next","id":"method-next","cls":"Ext.layout.container.AbstractCard"},{"type":"method","member":"prev","id":"method-prev","cls":"Ext.layout.container.AbstractCard"},{"type":"cls","member":"AbstractContainer","cls":"Ext.layout.container.AbstractContainer","xtypes":{}},{"type":"cfg","member":"bindToOwnerCtComponent","id":"cfg-bindToOwnerCtComponent","cls":"Ext.layout.container.AbstractContainer"},{"type":"cfg","member":"bindToOwnerCtContainer","id":"cfg-bindToOwnerCtContainer","cls":"Ext.layout.container.AbstractContainer"},{"type":"cfg","member":"itemCls","id":"cfg-itemCls","cls":"Ext.layout.container.AbstractContainer"},{"type":"method","member":"beforeLayout","id":"method-beforeLayout","cls":"Ext.layout.container.AbstractContainer"},{"type":"method","member":"getLayoutItems","id":"method-getLayoutItems","cls":"Ext.layout.container.AbstractContainer"},{"type":"method","member":"getRenderTarget","id":"method-getRenderTarget","cls":"Ext.layout.container.AbstractContainer"},{"type":"method","member":"getTarget","id":"method-getTarget","cls":"Ext.layout.container.AbstractContainer"},{"type":"cls","member":"AbstractFit","cls":"Ext.layout.container.AbstractFit","xtypes":{}},{"type":"cls","member":"Auto","cls":"Ext.layout.container.Auto","xtypes":{"layout":["auto","autocontainer"]}},{"type":"cls","member":"Layout","cls":"Ext.layout.Layout","xtypes":{}},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.layout.Layout"},{"type":"cls","member":"ModelManager","cls":"Ext.ModelManager","xtypes":{}},{"type":"property","member":"associationStack","id":"property-associationStack","cls":"Ext.ModelManager"},{"type":"method","member":"create","id":"method-create","cls":"Ext.ModelManager"},{"type":"method","member":"getModel","id":"method-getModel","cls":"Ext.ModelManager"},{"type":"cls","member":"AbstractPanel","cls":"Ext.panel.AbstractPanel","xtypes":{}},{"type":"cfg","member":"baseCls","id":"cfg-baseCls","cls":"Ext.panel.AbstractPanel"},{"type":"cfg","member":"bodyBorder","id":"cfg-bodyBorder","cls":"Ext.panel.AbstractPanel"},{"type":"cfg","member":"bodyCls","id":"cfg-bodyCls","cls":"Ext.panel.AbstractPanel"},{"type":"cfg","member":"bodyPadding","id":"cfg-bodyPadding","cls":"Ext.panel.AbstractPanel"},{"type":"cfg","member":"bodyStyle","id":"cfg-bodyStyle","cls":"Ext.panel.AbstractPanel"},{"type":"cfg","member":"defaultDockWeights","id":"cfg-defaultDockWeights","cls":"Ext.panel.AbstractPanel"},{"type":"cfg","member":"dockedItems","id":"cfg-dockedItems","cls":"Ext.panel.AbstractPanel"},{"type":"method","member":"addDocked","id":"method-addDocked","cls":"Ext.panel.AbstractPanel"},{"type":"method","member":"getComponent","id":"method-getComponent","cls":"Ext.panel.AbstractPanel"},{"type":"method","member":"getDockedComponent","id":"method-getDockedComponent","cls":"Ext.panel.AbstractPanel"},{"type":"method","member":"getDockedItems","id":"method-getDockedItems","cls":"Ext.panel.AbstractPanel"},{"type":"method","member":"insertDocked","id":"method-insertDocked","cls":"Ext.panel.AbstractPanel"},{"type":"method","member":"removeDocked","id":"method-removeDocked","cls":"Ext.panel.AbstractPanel"},{"type":"event","member":"bodyresize","id":"event-bodyresize","cls":"Ext.panel.AbstractPanel"},{"type":"cls","member":"PluginManager","cls":"Ext.PluginManager","xtypes":{}},{"type":"method","member":"create","id":"method-create","cls":"Ext.PluginManager"},{"type":"method","member":"findByType","id":"method-findByType","cls":"Ext.PluginManager"},{"type":"cls","member":"DataViewModel","cls":"Ext.selection.DataViewModel","xtypes":{}},{"type":"cfg","member":"enableKeyNav","id":"cfg-enableKeyNav","cls":"Ext.selection.DataViewModel"},{"type":"event","member":"beforedeselect","id":"event-beforedeselect","cls":"Ext.selection.DataViewModel"},{"type":"event","member":"beforeselect","id":"event-beforeselect","cls":"Ext.selection.DataViewModel"},{"type":"event","member":"deselect","id":"event-deselect","cls":"Ext.selection.DataViewModel"},{"type":"event","member":"select","id":"event-select","cls":"Ext.selection.DataViewModel"},{"type":"cls","member":"Model","cls":"Ext.selection.Model","xtypes":{}},{"type":"property","member":"selected","id":"property-selected","cls":"Ext.selection.Model"},{"type":"cfg","member":"allowDeselect","id":"cfg-allowDeselect","cls":"Ext.selection.Model"},{"type":"cfg","member":"mode","id":"cfg-mode","cls":"Ext.selection.Model"},{"type":"method","member":"deselect","id":"method-deselect","cls":"Ext.selection.Model"},{"type":"method","member":"deselectAll","id":"method-deselectAll","cls":"Ext.selection.Model"},{"type":"method","member":"getCount","id":"method-getCount","cls":"Ext.selection.Model"},{"type":"method","member":"getLastSelected","id":"method-getLastSelected","cls":"Ext.selection.Model"},{"type":"method","member":"getSelection","id":"method-getSelection","cls":"Ext.selection.Model"},{"type":"method","member":"getSelectionMode","id":"method-getSelectionMode","cls":"Ext.selection.Model"},{"type":"method","member":"hasSelection","id":"method-hasSelection","cls":"Ext.selection.Model"},{"type":"method","member":"isFocused","id":"method-isFocused","cls":"Ext.selection.Model"},{"type":"method","member":"isLocked","id":"method-isLocked","cls":"Ext.selection.Model"},{"type":"method","member":"isSelected","id":"method-isSelected","cls":"Ext.selection.Model"},{"type":"method","member":"select","id":"method-select","cls":"Ext.selection.Model"},{"type":"method","member":"selectAll","id":"method-selectAll","cls":"Ext.selection.Model"},{"type":"method","member":"selectRange","id":"method-selectRange","cls":"Ext.selection.Model"},{"type":"method","member":"setLastFocused","id":"method-setLastFocused","cls":"Ext.selection.Model"},{"type":"method","member":"setLocked","id":"method-setLocked","cls":"Ext.selection.Model"},{"type":"method","member":"setSelectionMode","id":"method-setSelectionMode","cls":"Ext.selection.Model"},{"type":"event","member":"selectionchange","id":"event-selectionchange","cls":"Ext.selection.Model"},{"type":"cls","member":"CookieProvider","cls":"Ext.state.CookieProvider","xtypes":{}},{"type":"cfg","member":"domain","id":"cfg-domain","cls":"Ext.state.CookieProvider"},{"type":"cfg","member":"expires","id":"cfg-expires","cls":"Ext.state.CookieProvider"},{"type":"cfg","member":"path","id":"cfg-path","cls":"Ext.state.CookieProvider"},{"type":"cfg","member":"secure","id":"cfg-secure","cls":"Ext.state.CookieProvider"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.state.CookieProvider"},{"type":"cls","member":"LocalStorageProvider","cls":"Ext.state.LocalStorageProvider","xtypes":{"state":["localstorage"]}},{"type":"cls","member":"Manager","cls":"Ext.state.Manager","xtypes":{}},{"type":"method","member":"clear","id":"method-clear","cls":"Ext.state.Manager"},{"type":"method","member":"get","id":"method-get","cls":"Ext.state.Manager"},{"type":"method","member":"getProvider","id":"method-getProvider","cls":"Ext.state.Manager"},{"type":"method","member":"set","id":"method-set","cls":"Ext.state.Manager"},{"type":"method","member":"setProvider","id":"method-setProvider","cls":"Ext.state.Manager"},{"type":"cls","member":"Provider","cls":"Ext.state.Provider","xtypes":{}},{"type":"cfg","member":"prefix","id":"cfg-prefix","cls":"Ext.state.Provider"},{"type":"method","member":"clear","id":"method-clear","cls":"Ext.state.Provider"},{"type":"method","member":"decodeValue","id":"method-decodeValue","cls":"Ext.state.Provider"},{"type":"method","member":"encodeValue","id":"method-encodeValue","cls":"Ext.state.Provider"},{"type":"method","member":"get","id":"method-get","cls":"Ext.state.Provider"},{"type":"method","member":"set","id":"method-set","cls":"Ext.state.Provider"},{"type":"event","member":"statechange","id":"event-statechange","cls":"Ext.state.Provider"},{"type":"cls","member":"Stateful","cls":"Ext.state.Stateful","xtypes":{}},{"type":"cfg","member":"saveDelay","id":"cfg-saveDelay","cls":"Ext.state.Stateful"},{"type":"cfg","member":"stateEvents","id":"cfg-stateEvents","cls":"Ext.state.Stateful"},{"type":"cfg","member":"stateId","id":"cfg-stateId","cls":"Ext.state.Stateful"},{"type":"cfg","member":"stateful","id":"cfg-stateful","cls":"Ext.state.Stateful"},{"type":"method","member":"addStateEvents","id":"method-addStateEvents","cls":"Ext.state.Stateful"},{"type":"method","member":"applyState","id":"method-applyState","cls":"Ext.state.Stateful"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.state.Stateful"},{"type":"method","member":"getState","id":"method-getState","cls":"Ext.state.Stateful"},{"type":"method","member":"getStateId","id":"method-getStateId","cls":"Ext.state.Stateful"},{"type":"method","member":"savePropToState","id":"method-savePropToState","cls":"Ext.state.Stateful"},{"type":"event","member":"beforestaterestore","id":"event-beforestaterestore","cls":"Ext.state.Stateful"},{"type":"event","member":"beforestatesave","id":"event-beforestatesave","cls":"Ext.state.Stateful"},{"type":"event","member":"staterestore","id":"event-staterestore","cls":"Ext.state.Stateful"},{"type":"event","member":"statesave","id":"event-statesave","cls":"Ext.state.Stateful"},{"type":"cls","member":"Template","cls":"Ext.Template","xtypes":{}},{"type":"cfg","member":"compiled","id":"cfg-compiled","cls":"Ext.Template"},{"type":"cfg","member":"disableFormats","id":"cfg-disableFormats","cls":"Ext.Template"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.Template"},{"type":"method","member":"append","id":"method-append","cls":"Ext.Template"},{"type":"method","member":"apply","id":"method-apply","cls":"Ext.Template"},{"type":"method","member":"applyTemplate","id":"method-applyTemplate","cls":"Ext.Template"},{"type":"method","member":"compile","id":"method-compile","cls":"Ext.Template"},{"type":"method","member":"insertAfter","id":"method-insertAfter","cls":"Ext.Template"},{"type":"method","member":"insertBefore","id":"method-insertBefore","cls":"Ext.Template"},{"type":"method","member":"insertFirst","id":"method-insertFirst","cls":"Ext.Template"},{"type":"method","member":"overwrite","id":"method-overwrite","cls":"Ext.Template"},{"type":"method","member":"set","id":"method-set","cls":"Ext.Template"},{"type":"method","member":"from","id":"static-method-from","cls":"Ext.Template"},{"type":"cls","member":"AbstractMixedCollection","cls":"Ext.util.AbstractMixedCollection","xtypes":{}},{"type":"cfg","member":"allowFunctions","id":"cfg-allowFunctions","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"add","id":"method-add","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"addAll","id":"method-addAll","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"clear","id":"method-clear","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"clone","id":"method-clone","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"collect","id":"method-collect","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"contains","id":"method-contains","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"containsKey","id":"method-containsKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"each","id":"method-each","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"eachKey","id":"method-eachKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"filter","id":"method-filter","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"filterBy","id":"method-filterBy","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"findBy","id":"method-findBy","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"findIndex","id":"method-findIndex","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"findIndexBy","id":"method-findIndexBy","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"first","id":"method-first","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"get","id":"method-get","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"getAt","id":"method-getAt","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"getByKey","id":"method-getByKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"getCount","id":"method-getCount","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"getKey","id":"method-getKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"getRange","id":"method-getRange","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"indexOf","id":"method-indexOf","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"indexOfKey","id":"method-indexOfKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"insert","id":"method-insert","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"last","id":"method-last","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"remove","id":"method-remove","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"removeAll","id":"method-removeAll","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"removeAt","id":"method-removeAt","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"removeAtKey","id":"method-removeAtKey","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"replace","id":"method-replace","cls":"Ext.util.AbstractMixedCollection"},{"type":"method","member":"sum","id":"method-sum","cls":"Ext.util.AbstractMixedCollection"},{"type":"event","member":"add","id":"event-add","cls":"Ext.util.AbstractMixedCollection"},{"type":"event","member":"clear","id":"event-clear","cls":"Ext.util.AbstractMixedCollection"},{"type":"event","member":"remove","id":"event-remove","cls":"Ext.util.AbstractMixedCollection"},{"type":"event","member":"replace","id":"event-replace","cls":"Ext.util.AbstractMixedCollection"},{"type":"cls","member":"Filter","cls":"Ext.util.Filter","xtypes":{}},{"type":"cfg","member":"anyMatch","id":"cfg-anyMatch","cls":"Ext.util.Filter"},{"type":"cfg","member":"caseSensitive","id":"cfg-caseSensitive","cls":"Ext.util.Filter"},{"type":"cfg","member":"exactMatch","id":"cfg-exactMatch","cls":"Ext.util.Filter"},{"type":"cfg","member":"filterFn","id":"cfg-filterFn","cls":"Ext.util.Filter"},{"type":"cfg","member":"property","id":"cfg-property","cls":"Ext.util.Filter"},{"type":"cfg","member":"root","id":"cfg-root","cls":"Ext.util.Filter"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.Filter"},{"type":"cls","member":"Grouper","cls":"Ext.util.Grouper","xtypes":{}},{"type":"method","member":"getGroupString","id":"method-getGroupString","cls":"Ext.util.Grouper"},{"type":"cls","member":"HashMap","cls":"Ext.util.HashMap","xtypes":{}},{"type":"cfg","member":"keyFn","id":"cfg-keyFn","cls":"Ext.util.HashMap"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.HashMap"},{"type":"method","member":"add","id":"method-add","cls":"Ext.util.HashMap"},{"type":"method","member":"clear","id":"method-clear","cls":"Ext.util.HashMap"},{"type":"method","member":"clone","id":"method-clone","cls":"Ext.util.HashMap"},{"type":"method","member":"contains","id":"method-contains","cls":"Ext.util.HashMap"},{"type":"method","member":"containsKey","id":"method-containsKey","cls":"Ext.util.HashMap"},{"type":"method","member":"each","id":"method-each","cls":"Ext.util.HashMap"},{"type":"method","member":"get","id":"method-get","cls":"Ext.util.HashMap"},{"type":"method","member":"getCount","id":"method-getCount","cls":"Ext.util.HashMap"},{"type":"method","member":"getKey","id":"method-getKey","cls":"Ext.util.HashMap"},{"type":"method","member":"getKeys","id":"method-getKeys","cls":"Ext.util.HashMap"},{"type":"method","member":"getValues","id":"method-getValues","cls":"Ext.util.HashMap"},{"type":"method","member":"remove","id":"method-remove","cls":"Ext.util.HashMap"},{"type":"method","member":"removeAtKey","id":"method-removeAtKey","cls":"Ext.util.HashMap"},{"type":"method","member":"replace","id":"method-replace","cls":"Ext.util.HashMap"},{"type":"event","member":"add","id":"event-add","cls":"Ext.util.HashMap"},{"type":"event","member":"clear","id":"event-clear","cls":"Ext.util.HashMap"},{"type":"event","member":"remove","id":"event-remove","cls":"Ext.util.HashMap"},{"type":"event","member":"replace","id":"event-replace","cls":"Ext.util.HashMap"},{"type":"cls","member":"Inflector","cls":"Ext.util.Inflector","xtypes":{}},{"type":"method","member":"classify","id":"method-classify","cls":"Ext.util.Inflector"},{"type":"method","member":"clearPlurals","id":"method-clearPlurals","cls":"Ext.util.Inflector"},{"type":"method","member":"clearSingulars","id":"method-clearSingulars","cls":"Ext.util.Inflector"},{"type":"method","member":"isTransnumeral","id":"method-isTransnumeral","cls":"Ext.util.Inflector"},{"type":"method","member":"ordinalize","id":"method-ordinalize","cls":"Ext.util.Inflector"},{"type":"method","member":"plural","id":"method-plural","cls":"Ext.util.Inflector"},{"type":"method","member":"pluralize","id":"method-pluralize","cls":"Ext.util.Inflector"},{"type":"method","member":"singular","id":"method-singular","cls":"Ext.util.Inflector"},{"type":"method","member":"singularize","id":"method-singularize","cls":"Ext.util.Inflector"},{"type":"cls","member":"Memento","cls":"Ext.util.Memento","xtypes":{}},{"type":"property","member":"target","id":"property-target","cls":"Ext.util.Memento"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.Memento"},{"type":"method","member":"capture","id":"method-capture","cls":"Ext.util.Memento"},{"type":"method","member":"remove","id":"method-remove","cls":"Ext.util.Memento"},{"type":"method","member":"restore","id":"method-restore","cls":"Ext.util.Memento"},{"type":"method","member":"restoreAll","id":"method-restoreAll","cls":"Ext.util.Memento"},{"type":"cls","member":"MixedCollection","cls":"Ext.util.MixedCollection","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.MixedCollection"},{"type":"method","member":"reorder","id":"method-reorder","cls":"Ext.util.MixedCollection"},{"type":"method","member":"sortBy","id":"method-sortBy","cls":"Ext.util.MixedCollection"},{"type":"method","member":"sortByKey","id":"method-sortByKey","cls":"Ext.util.MixedCollection"},{"type":"cls","member":"Observable","cls":"Ext.util.Observable","xtypes":{}},{"type":"cfg","member":"listeners","id":"cfg-listeners","cls":"Ext.util.Observable"},{"type":"method","member":"addEvents","id":"method-addEvents","cls":"Ext.util.Observable"},{"type":"method","member":"addListener","id":"method-addListener","cls":"Ext.util.Observable"},{"type":"method","member":"addManagedListener","id":"method-addManagedListener","cls":"Ext.util.Observable"},{"type":"method","member":"clearListeners","id":"method-clearListeners","cls":"Ext.util.Observable"},{"type":"method","member":"clearManagedListeners","id":"method-clearManagedListeners","cls":"Ext.util.Observable"},{"type":"method","member":"enableBubble","id":"method-enableBubble","cls":"Ext.util.Observable"},{"type":"method","member":"fireEvent","id":"method-fireEvent","cls":"Ext.util.Observable"},{"type":"method","member":"hasListener","id":"method-hasListener","cls":"Ext.util.Observable"},{"type":"method","member":"mon","id":"method-mon","cls":"Ext.util.Observable"},{"type":"method","member":"mun","id":"method-mun","cls":"Ext.util.Observable"},{"type":"method","member":"on","id":"method-on","cls":"Ext.util.Observable"},{"type":"method","member":"relayEvents","id":"method-relayEvents","cls":"Ext.util.Observable"},{"type":"method","member":"removeListener","id":"method-removeListener","cls":"Ext.util.Observable"},{"type":"method","member":"removeManagedListener","id":"method-removeManagedListener","cls":"Ext.util.Observable"},{"type":"method","member":"resumeEvents","id":"method-resumeEvents","cls":"Ext.util.Observable"},{"type":"method","member":"suspendEvents","id":"method-suspendEvents","cls":"Ext.util.Observable"},{"type":"method","member":"un","id":"method-un","cls":"Ext.util.Observable"},{"type":"method","member":"capture","id":"static-method-capture","cls":"Ext.util.Observable"},{"type":"method","member":"observe","id":"static-method-observe","cls":"Ext.util.Observable"},{"type":"method","member":"releaseCapture","id":"static-method-releaseCapture","cls":"Ext.util.Observable"},{"type":"cls","member":"Offset","cls":"Ext.util.Offset","xtypes":{}},{"type":"cls","member":"Point","cls":"Ext.util.Point","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.Point"},{"type":"method","member":"equals","id":"method-equals","cls":"Ext.util.Point"},{"type":"method","member":"isWithin","id":"method-isWithin","cls":"Ext.util.Point"},{"type":"method","member":"roundedEquals","id":"method-roundedEquals","cls":"Ext.util.Point"},{"type":"method","member":"toString","id":"method-toString","cls":"Ext.util.Point"},{"type":"method","member":"translate","id":"method-translate","cls":"Ext.util.Point"},{"type":"method","member":"fromEvent","id":"static-method-fromEvent","cls":"Ext.util.Point"},{"type":"cls","member":"Region","cls":"Ext.util.Region","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.Region"},{"type":"method","member":"adjust","id":"method-adjust","cls":"Ext.util.Region"},{"type":"method","member":"constrainTo","id":"method-constrainTo","cls":"Ext.util.Region"},{"type":"method","member":"contains","id":"method-contains","cls":"Ext.util.Region"},{"type":"method","member":"copy","id":"method-copy","cls":"Ext.util.Region"},{"type":"method","member":"copyFrom","id":"method-copyFrom","cls":"Ext.util.Region"},{"type":"method","member":"equals","id":"method-equals","cls":"Ext.util.Region"},{"type":"method","member":"getOutOfBoundOffset","id":"method-getOutOfBoundOffset","cls":"Ext.util.Region"},{"type":"method","member":"getOutOfBoundOffsetX","id":"method-getOutOfBoundOffsetX","cls":"Ext.util.Region"},{"type":"method","member":"getOutOfBoundOffsetY","id":"method-getOutOfBoundOffsetY","cls":"Ext.util.Region"},{"type":"method","member":"intersect","id":"method-intersect","cls":"Ext.util.Region"},{"type":"method","member":"isOutOfBound","id":"method-isOutOfBound","cls":"Ext.util.Region"},{"type":"method","member":"isOutOfBoundX","id":"method-isOutOfBoundX","cls":"Ext.util.Region"},{"type":"method","member":"isOutOfBoundY","id":"method-isOutOfBoundY","cls":"Ext.util.Region"},{"type":"method","member":"round","id":"method-round","cls":"Ext.util.Region"},{"type":"method","member":"translateBy","id":"method-translateBy","cls":"Ext.util.Region"},{"type":"method","member":"union","id":"method-union","cls":"Ext.util.Region"},{"type":"method","member":"from","id":"static-method-from","cls":"Ext.util.Region"},{"type":"method","member":"getRegion","id":"static-method-getRegion","cls":"Ext.util.Region"},{"type":"cls","member":"Sortable","cls":"Ext.util.Sortable","xtypes":{}},{"type":"property","member":"defaultSortDirection","id":"property-defaultSortDirection","cls":"Ext.util.Sortable"},{"type":"property","member":"isSortable","id":"property-isSortable","cls":"Ext.util.Sortable"},{"type":"property","member":"sortRoot","id":"property-sortRoot","cls":"Ext.util.Sortable"},{"type":"property","member":"sorters","id":"property-sorters","cls":"Ext.util.Sortable"},{"type":"method","member":"initSortable","id":"method-initSortable","cls":"Ext.util.Sortable"},{"type":"method","member":"sort","id":"method-sort","cls":"Ext.util.Sortable"},{"type":"cls","member":"Sorter","cls":"Ext.util.Sorter","xtypes":{}},{"type":"cfg","member":"direction","id":"cfg-direction","cls":"Ext.util.Sorter"},{"type":"cfg","member":"property","id":"cfg-property","cls":"Ext.util.Sorter"},{"type":"cfg","member":"root","id":"cfg-root","cls":"Ext.util.Sorter"},{"type":"cfg","member":"sorterFn","id":"cfg-sorterFn","cls":"Ext.util.Sorter"},{"type":"cfg","member":"transform","id":"cfg-transform","cls":"Ext.util.Sorter"},{"type":"method","member":"setDirection","id":"method-setDirection","cls":"Ext.util.Sorter"},{"type":"method","member":"toggle","id":"method-toggle","cls":"Ext.util.Sorter"},{"type":"method","member":"updateSortFunction","id":"method-updateSortFunction","cls":"Ext.util.Sorter"},{"type":"cls","member":"AbstractView","cls":"Ext.view.AbstractView","xtypes":{}},{"type":"cfg","member":"blockRefresh","id":"cfg-blockRefresh","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"deferEmptyText","id":"cfg-deferEmptyText","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"deferInitialRefresh","id":"cfg-deferInitialRefresh","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"disableSelection","id":"cfg-disableSelection","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"emptyText","id":"cfg-emptyText","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"itemCls","id":"cfg-itemCls","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"itemSelector","id":"cfg-itemSelector","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"itemTpl","id":"cfg-itemTpl","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"loadMask","id":"cfg-loadMask","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"loadingCls","id":"cfg-loadingCls","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"loadingHeight","id":"cfg-loadingHeight","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"loadingText","id":"cfg-loadingText","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"multiSelect","id":"cfg-multiSelect","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"overItemCls","id":"cfg-overItemCls","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"selectedItemCls","id":"cfg-selectedItemCls","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"simpleSelect","id":"cfg-simpleSelect","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"singleSelect","id":"cfg-singleSelect","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"store","id":"cfg-store","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"tpl","id":"cfg-tpl","cls":"Ext.view.AbstractView"},{"type":"cfg","member":"trackOver","id":"cfg-trackOver","cls":"Ext.view.AbstractView"},{"type":"method","member":"bindStore","id":"method-bindStore","cls":"Ext.view.AbstractView"},{"type":"method","member":"collectData","id":"method-collectData","cls":"Ext.view.AbstractView"},{"type":"method","member":"deselect","id":"method-deselect","cls":"Ext.view.AbstractView"},{"type":"method","member":"findItemByChild","id":"method-findItemByChild","cls":"Ext.view.AbstractView"},{"type":"method","member":"findTargetByEvent","id":"method-findTargetByEvent","cls":"Ext.view.AbstractView"},{"type":"method","member":"getNode","id":"method-getNode","cls":"Ext.view.AbstractView"},{"type":"method","member":"getNodes","id":"method-getNodes","cls":"Ext.view.AbstractView"},{"type":"method","member":"getRecord","id":"method-getRecord","cls":"Ext.view.AbstractView"},{"type":"method","member":"getRecords","id":"method-getRecords","cls":"Ext.view.AbstractView"},{"type":"method","member":"getSelectedNodes","id":"method-getSelectedNodes","cls":"Ext.view.AbstractView"},{"type":"method","member":"getSelectedRecords","id":"method-getSelectedRecords","cls":"Ext.view.AbstractView"},{"type":"method","member":"getSelectionCount","id":"method-getSelectionCount","cls":"Ext.view.AbstractView"},{"type":"method","member":"getSelectionModel","id":"method-getSelectionModel","cls":"Ext.view.AbstractView"},{"type":"method","member":"getStore","id":"method-getStore","cls":"Ext.view.AbstractView"},{"type":"method","member":"indexOf","id":"method-indexOf","cls":"Ext.view.AbstractView"},{"type":"method","member":"isSelected","id":"method-isSelected","cls":"Ext.view.AbstractView"},{"type":"method","member":"prepareData","id":"method-prepareData","cls":"Ext.view.AbstractView"},{"type":"method","member":"refresh","id":"method-refresh","cls":"Ext.view.AbstractView"},{"type":"method","member":"refreshNode","id":"method-refreshNode","cls":"Ext.view.AbstractView"},{"type":"method","member":"select","id":"method-select","cls":"Ext.view.AbstractView"},{"type":"event","member":"beforerefresh","id":"event-beforerefresh","cls":"Ext.view.AbstractView"},{"type":"event","member":"itemadd","id":"event-itemadd","cls":"Ext.view.AbstractView"},{"type":"event","member":"itemremove","id":"event-itemremove","cls":"Ext.view.AbstractView"},{"type":"event","member":"itemupdate","id":"event-itemupdate","cls":"Ext.view.AbstractView"},{"type":"event","member":"refresh","id":"event-refresh","cls":"Ext.view.AbstractView"},{"type":"event","member":"viewready","id":"event-viewready","cls":"Ext.view.AbstractView"},{"type":"cls","member":"XTemplate","cls":"Ext.XTemplate","xtypes":{}},{"type":"cfg","member":"codeRe","id":"cfg-codeRe","cls":"Ext.XTemplate"},{"type":"cfg","member":"compiled","id":"cfg-compiled","cls":"Ext.XTemplate"},{"type":"method","member":"compile","id":"method-compile","cls":"Ext.XTemplate"},{"type":"cls","member":"Base","cls":"Ext.Base","xtypes":{}},{"type":"property","member":"self","id":"property-self","cls":"Ext.Base"},{"type":"method","member":"callOverridden","id":"method-callOverridden","cls":"Ext.Base"},{"type":"method","member":"callParent","id":"method-callParent","cls":"Ext.Base"},{"type":"method","member":"initConfig","id":"method-initConfig","cls":"Ext.Base"},{"type":"method","member":"statics","id":"method-statics","cls":"Ext.Base"},{"type":"method","member":"addStatics","id":"static-method-addStatics","cls":"Ext.Base"},{"type":"method","member":"borrow","id":"static-method-borrow","cls":"Ext.Base"},{"type":"method","member":"create","id":"static-method-create","cls":"Ext.Base"},{"type":"method","member":"createAlias","id":"static-method-createAlias","cls":"Ext.Base"},{"type":"method","member":"getName","id":"static-method-getName","cls":"Ext.Base"},{"type":"method","member":"implement","id":"static-method-implement","cls":"Ext.Base"},{"type":"method","member":"override","id":"static-method-override","cls":"Ext.Base"},{"type":"cls","member":"Class","cls":"Ext.Class","xtypes":{}},{"type":"cfg","member":"alias","id":"cfg-alias","cls":"Ext.Class"},{"type":"cfg","member":"alternateClassName","id":"cfg-alternateClassName","cls":"Ext.Class"},{"type":"cfg","member":"config","id":"cfg-config","cls":"Ext.Class"},{"type":"cfg","member":"extend","id":"cfg-extend","cls":"Ext.Class"},{"type":"cfg","member":"inheritableStatics","id":"cfg-inheritableStatics","cls":"Ext.Class"},{"type":"cfg","member":"mixins","id":"cfg-mixins","cls":"Ext.Class"},{"type":"cfg","member":"override","id":"cfg-override","cls":"Ext.Class"},{"type":"cfg","member":"requires","id":"cfg-requires","cls":"Ext.Class"},{"type":"cfg","member":"singleton","id":"cfg-singleton","cls":"Ext.Class"},{"type":"cfg","member":"statics","id":"cfg-statics","cls":"Ext.Class"},{"type":"cfg","member":"uses","id":"cfg-uses","cls":"Ext.Class"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.Class"},{"type":"method","member":"getDefaultPreprocessors","id":"static-method-getDefaultPreprocessors","cls":"Ext.Class"},{"type":"method","member":"getPreprocessor","id":"static-method-getPreprocessor","cls":"Ext.Class"},{"type":"method","member":"registerPreprocessor","id":"static-method-registerPreprocessor","cls":"Ext.Class"},{"type":"method","member":"setDefaultPreprocessorPosition","id":"static-method-setDefaultPreprocessorPosition","cls":"Ext.Class"},{"type":"method","member":"setDefaultPreprocessors","id":"static-method-setDefaultPreprocessors","cls":"Ext.Class"},{"type":"cls","member":"ClassManager","cls":"Ext.ClassManager","xtypes":{}},{"type":"method","member":"create","id":"method-create","cls":"Ext.ClassManager"},{"type":"method","member":"get","id":"method-get","cls":"Ext.ClassManager"},{"type":"method","member":"getAliasesByName","id":"method-getAliasesByName","cls":"Ext.ClassManager"},{"type":"method","member":"getByAlias","id":"method-getByAlias","cls":"Ext.ClassManager"},{"type":"method","member":"getClass","id":"method-getClass","cls":"Ext.ClassManager"},{"type":"method","member":"getDisplayName","id":"method-getDisplayName","cls":"Ext.ClassManager"},{"type":"method","member":"getName","id":"method-getName","cls":"Ext.ClassManager"},{"type":"method","member":"getNameByAlias","id":"method-getNameByAlias","cls":"Ext.ClassManager"},{"type":"method","member":"getNameByAlternate","id":"method-getNameByAlternate","cls":"Ext.ClassManager"},{"type":"method","member":"getNamesByExpression","id":"method-getNamesByExpression","cls":"Ext.ClassManager"},{"type":"method","member":"instantiate","id":"method-instantiate","cls":"Ext.ClassManager"},{"type":"method","member":"instantiateByAlias","id":"method-instantiateByAlias","cls":"Ext.ClassManager"},{"type":"method","member":"isCreated","id":"method-isCreated","cls":"Ext.ClassManager"},{"type":"method","member":"registerPostprocessor","id":"method-registerPostprocessor","cls":"Ext.ClassManager"},{"type":"method","member":"set","id":"method-set","cls":"Ext.ClassManager"},{"type":"method","member":"setAlias","id":"method-setAlias","cls":"Ext.ClassManager"},{"type":"method","member":"setDefaultPostprocessorPosition","id":"method-setDefaultPostprocessorPosition","cls":"Ext.ClassManager"},{"type":"method","member":"setDefaultPostprocessors","id":"method-setDefaultPostprocessors","cls":"Ext.ClassManager"},{"type":"method","member":"setNamespace","id":"method-setNamespace","cls":"Ext.ClassManager"},{"type":"cls","member":"Loader","cls":"Ext.Loader","xtypes":{}},{"type":"property","member":"history","id":"property-history","cls":"Ext.Loader"},{"type":"cfg","member":"disableCaching","id":"cfg-disableCaching","cls":"Ext.Loader"},{"type":"cfg","member":"disableCachingParam","id":"cfg-disableCachingParam","cls":"Ext.Loader"},{"type":"cfg","member":"enabled","id":"cfg-enabled","cls":"Ext.Loader"},{"type":"cfg","member":"paths","id":"cfg-paths","cls":"Ext.Loader"},{"type":"method","member":"exclude","id":"method-exclude","cls":"Ext.Loader"},{"type":"method","member":"getConfig","id":"method-getConfig","cls":"Ext.Loader"},{"type":"method","member":"getPath","id":"method-getPath","cls":"Ext.Loader"},{"type":"method","member":"onReady","id":"method-onReady","cls":"Ext.Loader"},{"type":"method","member":"require","id":"method-require","cls":"Ext.Loader"},{"type":"method","member":"setConfig","id":"method-setConfig","cls":"Ext.Loader"},{"type":"method","member":"setPath","id":"method-setPath","cls":"Ext.Loader"},{"type":"method","member":"syncRequire","id":"method-syncRequire","cls":"Ext.Loader"},{"type":"cls","member":"CompositeElement","cls":"Ext.CompositeElement","xtypes":{}},{"type":"cls","member":"CompositeElementLite","cls":"Ext.CompositeElementLite","xtypes":{}},{"type":"property","member":"elements","id":"property-elements","cls":"Ext.CompositeElementLite"},{"type":"method","member":"add","id":"method-add","cls":"Ext.CompositeElementLite"},{"type":"method","member":"clear","id":"method-clear","cls":"Ext.CompositeElementLite"},{"type":"method","member":"contains","id":"method-contains","cls":"Ext.CompositeElementLite"},{"type":"method","member":"each","id":"method-each","cls":"Ext.CompositeElementLite"},{"type":"method","member":"fill","id":"method-fill","cls":"Ext.CompositeElementLite"},{"type":"method","member":"filter","id":"method-filter","cls":"Ext.CompositeElementLite"},{"type":"method","member":"first","id":"method-first","cls":"Ext.CompositeElementLite"},{"type":"method","member":"getCount","id":"method-getCount","cls":"Ext.CompositeElementLite"},{"type":"method","member":"indexOf","id":"method-indexOf","cls":"Ext.CompositeElementLite"},{"type":"method","member":"item","id":"method-item","cls":"Ext.CompositeElementLite"},{"type":"method","member":"last","id":"method-last","cls":"Ext.CompositeElementLite"},{"type":"method","member":"removeElement","id":"method-removeElement","cls":"Ext.CompositeElementLite"},{"type":"method","member":"replaceElement","id":"method-replaceElement","cls":"Ext.CompositeElementLite"},{"type":"cls","member":"DomHelper","cls":"Ext.DomHelper","xtypes":{}},{"type":"property","member":"useDom","id":"property-useDom","cls":"Ext.DomHelper"},{"type":"method","member":"append","id":"method-append","cls":"Ext.DomHelper"},{"type":"method","member":"applyStyles","id":"method-applyStyles","cls":"Ext.DomHelper"},{"type":"method","member":"createDom","id":"method-createDom","cls":"Ext.DomHelper"},{"type":"method","member":"createTemplate","id":"method-createTemplate","cls":"Ext.DomHelper"},{"type":"method","member":"insertAfter","id":"method-insertAfter","cls":"Ext.DomHelper"},{"type":"method","member":"insertBefore","id":"method-insertBefore","cls":"Ext.DomHelper"},{"type":"method","member":"insertFirst","id":"method-insertFirst","cls":"Ext.DomHelper"},{"type":"method","member":"insertHtml","id":"method-insertHtml","cls":"Ext.DomHelper"},{"type":"method","member":"markup","id":"method-markup","cls":"Ext.DomHelper"},{"type":"method","member":"overwrite","id":"method-overwrite","cls":"Ext.DomHelper"},{"type":"cls","member":"DomQuery","cls":"Ext.DomQuery","xtypes":{}},{"type":"property","member":"matchers","id":"property-matchers","cls":"Ext.DomQuery"},{"type":"property","member":"operators","id":"property-operators","cls":"Ext.DomQuery"},{"type":"property","member":"pseudos","id":"property-pseudos","cls":"Ext.DomQuery"},{"type":"method","member":"compile","id":"method-compile","cls":"Ext.DomQuery"},{"type":"method","member":"filter","id":"method-filter","cls":"Ext.DomQuery"},{"type":"method","member":"is","id":"method-is","cls":"Ext.DomQuery"},{"type":"method","member":"jsSelect","id":"method-jsSelect","cls":"Ext.DomQuery"},{"type":"method","member":"select","id":"method-select","cls":"Ext.DomQuery"},{"type":"method","member":"selectNode","id":"method-selectNode","cls":"Ext.DomQuery"},{"type":"method","member":"selectNumber","id":"method-selectNumber","cls":"Ext.DomQuery"},{"type":"method","member":"selectValue","id":"method-selectValue","cls":"Ext.DomQuery"},{"type":"cls","member":"Element","cls":"Ext.Element","xtypes":{}},{"type":"property","member":"autoBoxAdjust","id":"property-autoBoxAdjust","cls":"Ext.Element"},{"type":"property","member":"defaultUnit","id":"property-defaultUnit","cls":"Ext.Element"},{"type":"property","member":"dom","id":"property-dom","cls":"Ext.Element"},{"type":"property","member":"id","id":"property-id","cls":"Ext.Element"},{"type":"property","member":"originalDisplay","id":"property-originalDisplay","cls":"Ext.Element"},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.Element"},{"type":"method","member":"addCls","id":"method-addCls","cls":"Ext.Element"},{"type":"method","member":"addClsOnClick","id":"method-addClsOnClick","cls":"Ext.Element"},{"type":"method","member":"addClsOnFocus","id":"method-addClsOnFocus","cls":"Ext.Element"},{"type":"method","member":"addClsOnOver","id":"method-addClsOnOver","cls":"Ext.Element"},{"type":"method","member":"addKeyListener","id":"method-addKeyListener","cls":"Ext.Element"},{"type":"method","member":"addKeyMap","id":"method-addKeyMap","cls":"Ext.Element"},{"type":"method","member":"addListener","id":"method-addListener","cls":"Ext.Element"},{"type":"method","member":"adjustWidth","id":"method-adjustWidth","cls":"Ext.Element"},{"type":"method","member":"alignTo","id":"method-alignTo","cls":"Ext.Element"},{"type":"method","member":"anchorTo","id":"method-anchorTo","cls":"Ext.Element"},{"type":"method","member":"appendChild","id":"method-appendChild","cls":"Ext.Element"},{"type":"method","member":"appendTo","id":"method-appendTo","cls":"Ext.Element"},{"type":"method","member":"applyStyles","id":"method-applyStyles","cls":"Ext.Element"},{"type":"method","member":"blur","id":"method-blur","cls":"Ext.Element"},{"type":"method","member":"boxWrap","id":"method-boxWrap","cls":"Ext.Element"},{"type":"method","member":"center","id":"method-center","cls":"Ext.Element"},{"type":"method","member":"child","id":"method-child","cls":"Ext.Element"},{"type":"method","member":"clean","id":"method-clean","cls":"Ext.Element"},{"type":"method","member":"clearListeners","id":"method-clearListeners","cls":"Ext.Element"},{"type":"method","member":"clearOpacity","id":"method-clearOpacity","cls":"Ext.Element"},{"type":"method","member":"clearPositioning","id":"method-clearPositioning","cls":"Ext.Element"},{"type":"method","member":"clip","id":"method-clip","cls":"Ext.Element"},{"type":"method","member":"contains","id":"method-contains","cls":"Ext.Element"},{"type":"method","member":"createChild","id":"method-createChild","cls":"Ext.Element"},{"type":"method","member":"createProxy","id":"method-createProxy","cls":"Ext.Element"},{"type":"method","member":"createShim","id":"method-createShim","cls":"Ext.Element"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext.Element"},{"type":"method","member":"down","id":"method-down","cls":"Ext.Element"},{"type":"method","member":"enableDisplayMode","id":"method-enableDisplayMode","cls":"Ext.Element"},{"type":"method","member":"fadeIn","id":"method-fadeIn","cls":"Ext.Element"},{"type":"method","member":"fadeOut","id":"method-fadeOut","cls":"Ext.Element"},{"type":"method","member":"findParent","id":"method-findParent","cls":"Ext.Element"},{"type":"method","member":"findParentNode","id":"method-findParentNode","cls":"Ext.Element"},{"type":"method","member":"first","id":"method-first","cls":"Ext.Element"},{"type":"method","member":"focus","id":"method-focus","cls":"Ext.Element"},{"type":"method","member":"focusable","id":"method-focusable","cls":"Ext.Element"},{"type":"method","member":"frame","id":"method-frame","cls":"Ext.Element"},{"type":"method","member":"getActiveElement","id":"method-getActiveElement","cls":"Ext.Element"},{"type":"method","member":"getAlignToXY","id":"method-getAlignToXY","cls":"Ext.Element"},{"type":"method","member":"getAnchorXY","id":"method-getAnchorXY","cls":"Ext.Element"},{"type":"method","member":"getAttribute","id":"method-getAttribute","cls":"Ext.Element"},{"type":"method","member":"getAttributeNS","id":"method-getAttributeNS","cls":"Ext.Element"},{"type":"method","member":"getBorderWidth","id":"method-getBorderWidth","cls":"Ext.Element"},{"type":"method","member":"getBottom","id":"method-getBottom","cls":"Ext.Element"},{"type":"method","member":"getBox","id":"method-getBox","cls":"Ext.Element"},{"type":"method","member":"getById","id":"method-getById","cls":"Ext.Element"},{"type":"method","member":"getCenterXY","id":"method-getCenterXY","cls":"Ext.Element"},{"type":"method","member":"getColor","id":"method-getColor","cls":"Ext.Element"},{"type":"method","member":"getComputedHeight","id":"method-getComputedHeight","cls":"Ext.Element"},{"type":"method","member":"getComputedWidth","id":"method-getComputedWidth","cls":"Ext.Element"},{"type":"method","member":"getConstrainVector","id":"method-getConstrainVector","cls":"Ext.Element"},{"type":"method","member":"getFrameWidth","id":"method-getFrameWidth","cls":"Ext.Element"},{"type":"method","member":"getHeight","id":"method-getHeight","cls":"Ext.Element"},{"type":"method","member":"getLeft","id":"method-getLeft","cls":"Ext.Element"},{"type":"method","member":"getLoader","id":"method-getLoader","cls":"Ext.Element"},{"type":"method","member":"getMargin","id":"method-getMargin","cls":"Ext.Element"},{"type":"method","member":"getOffsetsTo","id":"method-getOffsetsTo","cls":"Ext.Element"},{"type":"method","member":"getPadding","id":"method-getPadding","cls":"Ext.Element"},{"type":"method","member":"getPageBox","id":"method-getPageBox","cls":"Ext.Element"},{"type":"method","member":"getPositioning","id":"method-getPositioning","cls":"Ext.Element"},{"type":"method","member":"getRegion","id":"method-getRegion","cls":"Ext.Element"},{"type":"method","member":"getRight","id":"method-getRight","cls":"Ext.Element"},{"type":"method","member":"getScopeParent","id":"method-getScopeParent","cls":"Ext.Element"},{"type":"method","member":"getScroll","id":"method-getScroll","cls":"Ext.Element"},{"type":"method","member":"getSize","id":"method-getSize","cls":"Ext.Element"},{"type":"method","member":"getStyle","id":"method-getStyle","cls":"Ext.Element"},{"type":"method","member":"getStyleSize","id":"method-getStyleSize","cls":"Ext.Element"},{"type":"method","member":"getStyles","id":"method-getStyles","cls":"Ext.Element"},{"type":"method","member":"getTextWidth","id":"method-getTextWidth","cls":"Ext.Element"},{"type":"method","member":"getTop","id":"method-getTop","cls":"Ext.Element"},{"type":"method","member":"getValue","id":"method-getValue","cls":"Ext.Element"},{"type":"method","member":"getViewRegion","id":"method-getViewRegion","cls":"Ext.Element"},{"type":"method","member":"getViewSize","id":"method-getViewSize","cls":"Ext.Element"},{"type":"method","member":"getWidth","id":"method-getWidth","cls":"Ext.Element"},{"type":"method","member":"getX","id":"method-getX","cls":"Ext.Element"},{"type":"method","member":"getXY","id":"method-getXY","cls":"Ext.Element"},{"type":"method","member":"getY","id":"method-getY","cls":"Ext.Element"},{"type":"method","member":"ghost","id":"method-ghost","cls":"Ext.Element"},{"type":"method","member":"hasCls","id":"method-hasCls","cls":"Ext.Element"},{"type":"method","member":"hide","id":"method-hide","cls":"Ext.Element"},{"type":"method","member":"highlight","id":"method-highlight","cls":"Ext.Element"},{"type":"method","member":"hover","id":"method-hover","cls":"Ext.Element"},{"type":"method","member":"initDD","id":"method-initDD","cls":"Ext.Element"},{"type":"method","member":"initDDProxy","id":"method-initDDProxy","cls":"Ext.Element"},{"type":"method","member":"initDDTarget","id":"method-initDDTarget","cls":"Ext.Element"},{"type":"method","member":"insertAfter","id":"method-insertAfter","cls":"Ext.Element"},{"type":"method","member":"insertBefore","id":"method-insertBefore","cls":"Ext.Element"},{"type":"method","member":"insertFirst","id":"method-insertFirst","cls":"Ext.Element"},{"type":"method","member":"insertHtml","id":"method-insertHtml","cls":"Ext.Element"},{"type":"method","member":"insertSibling","id":"method-insertSibling","cls":"Ext.Element"},{"type":"method","member":"is","id":"method-is","cls":"Ext.Element"},{"type":"method","member":"isBorderBox","id":"method-isBorderBox","cls":"Ext.Element"},{"type":"method","member":"isDisplayed","id":"method-isDisplayed","cls":"Ext.Element"},{"type":"method","member":"isMasked","id":"method-isMasked","cls":"Ext.Element"},{"type":"method","member":"isScrollable","id":"method-isScrollable","cls":"Ext.Element"},{"type":"method","member":"isVisible","id":"method-isVisible","cls":"Ext.Element"},{"type":"method","member":"last","id":"method-last","cls":"Ext.Element"},{"type":"method","member":"load","id":"method-load","cls":"Ext.Element"},{"type":"method","member":"mask","id":"method-mask","cls":"Ext.Element"},{"type":"method","member":"monitorMouseLeave","id":"method-monitorMouseLeave","cls":"Ext.Element"},{"type":"method","member":"move","id":"method-move","cls":"Ext.Element"},{"type":"method","member":"moveTo","id":"method-moveTo","cls":"Ext.Element"},{"type":"method","member":"next","id":"method-next","cls":"Ext.Element"},{"type":"method","member":"on","id":"method-on","cls":"Ext.Element"},{"type":"method","member":"parent","id":"method-parent","cls":"Ext.Element"},{"type":"method","member":"pause","id":"method-pause","cls":"Ext.Element"},{"type":"method","member":"position","id":"method-position","cls":"Ext.Element"},{"type":"method","member":"prev","id":"method-prev","cls":"Ext.Element"},{"type":"method","member":"puff","id":"method-puff","cls":"Ext.Element"},{"type":"method","member":"purgeAllListeners","id":"method-purgeAllListeners","cls":"Ext.Element"},{"type":"method","member":"query","id":"method-query","cls":"Ext.Element"},{"type":"method","member":"radioCls","id":"method-radioCls","cls":"Ext.Element"},{"type":"method","member":"relayEvent","id":"method-relayEvent","cls":"Ext.Element"},{"type":"method","member":"remove","id":"method-remove","cls":"Ext.Element"},{"type":"method","member":"removeAllListeners","id":"method-removeAllListeners","cls":"Ext.Element"},{"type":"method","member":"removeAnchor","id":"method-removeAnchor","cls":"Ext.Element"},{"type":"method","member":"removeCls","id":"method-removeCls","cls":"Ext.Element"},{"type":"method","member":"removeListener","id":"method-removeListener","cls":"Ext.Element"},{"type":"method","member":"repaint","id":"method-repaint","cls":"Ext.Element"},{"type":"method","member":"replace","id":"method-replace","cls":"Ext.Element"},{"type":"method","member":"replaceCls","id":"method-replaceCls","cls":"Ext.Element"},{"type":"method","member":"replaceWith","id":"method-replaceWith","cls":"Ext.Element"},{"type":"method","member":"scale","id":"method-scale","cls":"Ext.Element"},{"type":"method","member":"scroll","id":"method-scroll","cls":"Ext.Element"},{"type":"method","member":"scrollIntoView","id":"method-scrollIntoView","cls":"Ext.Element"},{"type":"method","member":"scrollTo","id":"method-scrollTo","cls":"Ext.Element"},{"type":"method","member":"select","id":"method-select","cls":"Ext.Element"},{"type":"method","member":"selectable","id":"method-selectable","cls":"Ext.Element"},{"type":"method","member":"serializeForm","id":"method-serializeForm","cls":"Ext.Element"},{"type":"method","member":"set","id":"method-set","cls":"Ext.Element"},{"type":"method","member":"setBottom","id":"method-setBottom","cls":"Ext.Element"},{"type":"method","member":"setBounds","id":"method-setBounds","cls":"Ext.Element"},{"type":"method","member":"setBox","id":"method-setBox","cls":"Ext.Element"},{"type":"method","member":"setDisplayed","id":"method-setDisplayed","cls":"Ext.Element"},{"type":"method","member":"setHeight","id":"method-setHeight","cls":"Ext.Element"},{"type":"method","member":"setLeft","id":"method-setLeft","cls":"Ext.Element"},{"type":"method","member":"setLeftTop","id":"method-setLeftTop","cls":"Ext.Element"},{"type":"method","member":"setLocation","id":"method-setLocation","cls":"Ext.Element"},{"type":"method","member":"setOpacity","id":"method-setOpacity","cls":"Ext.Element"},{"type":"method","member":"setPositioning","id":"method-setPositioning","cls":"Ext.Element"},{"type":"method","member":"setRegion","id":"method-setRegion","cls":"Ext.Element"},{"type":"method","member":"setRight","id":"method-setRight","cls":"Ext.Element"},{"type":"method","member":"setSize","id":"method-setSize","cls":"Ext.Element"},{"type":"method","member":"setStyle","id":"method-setStyle","cls":"Ext.Element"},{"type":"method","member":"setTop","id":"method-setTop","cls":"Ext.Element"},{"type":"method","member":"setVisibilityMode","id":"method-setVisibilityMode","cls":"Ext.Element"},{"type":"method","member":"setVisible","id":"method-setVisible","cls":"Ext.Element"},{"type":"method","member":"setWidth","id":"method-setWidth","cls":"Ext.Element"},{"type":"method","member":"setX","id":"method-setX","cls":"Ext.Element"},{"type":"method","member":"setXY","id":"method-setXY","cls":"Ext.Element"},{"type":"method","member":"setY","id":"method-setY","cls":"Ext.Element"},{"type":"method","member":"shift","id":"method-shift","cls":"Ext.Element"},{"type":"method","member":"show","id":"method-show","cls":"Ext.Element"},{"type":"method","member":"slideIn","id":"method-slideIn","cls":"Ext.Element"},{"type":"method","member":"slideOut","id":"method-slideOut","cls":"Ext.Element"},{"type":"method","member":"swallowEvent","id":"method-swallowEvent","cls":"Ext.Element"},{"type":"method","member":"switchOff","id":"method-switchOff","cls":"Ext.Element"},{"type":"method","member":"toggle","id":"method-toggle","cls":"Ext.Element"},{"type":"method","member":"toggleCls","id":"method-toggleCls","cls":"Ext.Element"},{"type":"method","member":"translatePoints","id":"method-translatePoints","cls":"Ext.Element"},{"type":"method","member":"un","id":"method-un","cls":"Ext.Element"},{"type":"method","member":"unclip","id":"method-unclip","cls":"Ext.Element"},{"type":"method","member":"unmask","id":"method-unmask","cls":"Ext.Element"},{"type":"method","member":"unselectable","id":"method-unselectable","cls":"Ext.Element"},{"type":"method","member":"up","id":"method-up","cls":"Ext.Element"},{"type":"method","member":"update","id":"method-update","cls":"Ext.Element"},{"type":"method","member":"wrap","id":"method-wrap","cls":"Ext.Element"},{"type":"event","member":"DOMActivate","id":"event-DOMActivate","cls":"Ext.Element"},{"type":"event","member":"DOMAttrModified","id":"event-DOMAttrModified","cls":"Ext.Element"},{"type":"event","member":"DOMCharacterDataModified","id":"event-DOMCharacterDataModified","cls":"Ext.Element"},{"type":"event","member":"DOMFocusIn","id":"event-DOMFocusIn","cls":"Ext.Element"},{"type":"event","member":"DOMFocusOut","id":"event-DOMFocusOut","cls":"Ext.Element"},{"type":"event","member":"DOMNodeInserted","id":"event-DOMNodeInserted","cls":"Ext.Element"},{"type":"event","member":"DOMNodeInsertedIntoDocument","id":"event-DOMNodeInsertedIntoDocument","cls":"Ext.Element"},{"type":"event","member":"DOMNodeRemoved","id":"event-DOMNodeRemoved","cls":"Ext.Element"},{"type":"event","member":"DOMNodeRemovedFromDocument","id":"event-DOMNodeRemovedFromDocument","cls":"Ext.Element"},{"type":"event","member":"DOMSubtreeModified","id":"event-DOMSubtreeModified","cls":"Ext.Element"},{"type":"event","member":"abort","id":"event-abort","cls":"Ext.Element"},{"type":"event","member":"blur","id":"event-blur","cls":"Ext.Element"},{"type":"event","member":"change","id":"event-change","cls":"Ext.Element"},{"type":"event","member":"click","id":"event-click","cls":"Ext.Element"},{"type":"event","member":"contextmenu","id":"event-contextmenu","cls":"Ext.Element"},{"type":"event","member":"dblclick","id":"event-dblclick","cls":"Ext.Element"},{"type":"event","member":"error","id":"event-error","cls":"Ext.Element"},{"type":"event","member":"focus","id":"event-focus","cls":"Ext.Element"},{"type":"event","member":"keydown","id":"event-keydown","cls":"Ext.Element"},{"type":"event","member":"keypress","id":"event-keypress","cls":"Ext.Element"},{"type":"event","member":"keyup","id":"event-keyup","cls":"Ext.Element"},{"type":"event","member":"load","id":"event-load","cls":"Ext.Element"},{"type":"event","member":"mousedown","id":"event-mousedown","cls":"Ext.Element"},{"type":"event","member":"mouseenter","id":"event-mouseenter","cls":"Ext.Element"},{"type":"event","member":"mouseleave","id":"event-mouseleave","cls":"Ext.Element"},{"type":"event","member":"mousemove","id":"event-mousemove","cls":"Ext.Element"},{"type":"event","member":"mouseout","id":"event-mouseout","cls":"Ext.Element"},{"type":"event","member":"mouseover","id":"event-mouseover","cls":"Ext.Element"},{"type":"event","member":"mouseup","id":"event-mouseup","cls":"Ext.Element"},{"type":"event","member":"reset","id":"event-reset","cls":"Ext.Element"},{"type":"event","member":"resize","id":"event-resize","cls":"Ext.Element"},{"type":"event","member":"scroll","id":"event-scroll","cls":"Ext.Element"},{"type":"event","member":"select","id":"event-select","cls":"Ext.Element"},{"type":"event","member":"submit","id":"event-submit","cls":"Ext.Element"},{"type":"event","member":"unload","id":"event-unload","cls":"Ext.Element"},{"type":"property","member":"DISPLAY","id":"static-property-DISPLAY","cls":"Ext.Element"},{"type":"property","member":"OFFSETS","id":"static-property-OFFSETS","cls":"Ext.Element"},{"type":"property","member":"VISIBILITY","id":"static-property-VISIBILITY","cls":"Ext.Element"},{"type":"property","member":"visibilityCls","id":"static-property-visibilityCls","cls":"Ext.Element"},{"type":"method","member":"fly","id":"static-method-fly","cls":"Ext.Element"},{"type":"method","member":"fromPoint","id":"static-method-fromPoint","cls":"Ext.Element"},{"type":"method","member":"get","id":"static-method-get","cls":"Ext.Element"},{"type":"method","member":"getDocumentHeight","id":"static-method-getDocumentHeight","cls":"Ext.Element"},{"type":"method","member":"getDocumentWidth","id":"static-method-getDocumentWidth","cls":"Ext.Element"},{"type":"method","member":"getOrientation","id":"static-method-getOrientation","cls":"Ext.Element"},{"type":"method","member":"getViewSize","id":"static-method-getViewSize","cls":"Ext.Element"},{"type":"method","member":"getViewportHeight","id":"static-method-getViewportHeight","cls":"Ext.Element"},{"type":"method","member":"getViewportWidth","id":"static-method-getViewportWidth","cls":"Ext.Element"},{"type":"method","member":"normalize","id":"static-method-normalize","cls":"Ext.Element"},{"type":"method","member":"parseBox","id":"static-method-parseBox","cls":"Ext.Element"},{"type":"method","member":"parseStyles","id":"static-method-parseStyles","cls":"Ext.Element"},{"type":"method","member":"unitizeBox","id":"static-method-unitizeBox","cls":"Ext.Element"},{"type":"cls","member":"Browser","cls":"Ext.env.Browser","xtypes":{}},{"type":"property","member":"engineName","id":"property-engineName","cls":"Ext.env.Browser"},{"type":"property","member":"engineVersion","id":"property-engineVersion","cls":"Ext.env.Browser"},{"type":"property","member":"isSecure","id":"property-isSecure","cls":"Ext.env.Browser"},{"type":"property","member":"isStrict","id":"property-isStrict","cls":"Ext.env.Browser"},{"type":"property","member":"name","id":"property-name","cls":"Ext.env.Browser"},{"type":"property","member":"version","id":"property-version","cls":"Ext.env.Browser"},{"type":"method","member":"is","id":"method-is","cls":"Ext.env.Browser"},{"type":"cls","member":"FeatureDetector","cls":"Ext.env.FeatureDetector","xtypes":{}},{"type":"property","member":"Audio","id":"property-Audio","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"CSS3DTransforms","id":"property-CSS3DTransforms","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"CSSAnimations","id":"property-CSSAnimations","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"CSSTransforms","id":"property-CSSTransforms","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"CSSTransitions","id":"property-CSSTransitions","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"Canvas","id":"property-Canvas","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"Geolocation","id":"property-Geolocation","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"History","id":"property-History","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"Orientation","id":"property-Orientation","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"SVG","id":"property-SVG","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"SqlDatabase","id":"property-SqlDatabase","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"Touch","id":"property-Touch","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"VML","id":"property-VML","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"Video","id":"property-Video","cls":"Ext.env.FeatureDetector"},{"type":"property","member":"Websockets","id":"property-Websockets","cls":"Ext.env.FeatureDetector"},{"type":"cls","member":"OS","cls":"Ext.env.OS","xtypes":{}},{"type":"property","member":"name","id":"property-name","cls":"Ext.env.OS"},{"type":"property","member":"version","id":"property-version","cls":"Ext.env.OS"},{"type":"method","member":"is","id":"method-is","cls":"Ext.env.OS"},{"type":"cls","member":"EventManager","cls":"Ext.EventManager","xtypes":{}},{"type":"method","member":"addListener","id":"method-addListener","cls":"Ext.EventManager"},{"type":"method","member":"getId","id":"method-getId","cls":"Ext.EventManager"},{"type":"method","member":"getKeyEvent","id":"method-getKeyEvent","cls":"Ext.EventManager"},{"type":"method","member":"getPageX","id":"method-getPageX","cls":"Ext.EventManager"},{"type":"method","member":"getPageXY","id":"method-getPageXY","cls":"Ext.EventManager"},{"type":"method","member":"getPageY","id":"method-getPageY","cls":"Ext.EventManager"},{"type":"method","member":"getRelatedTarget","id":"method-getRelatedTarget","cls":"Ext.EventManager"},{"type":"method","member":"getTarget","id":"method-getTarget","cls":"Ext.EventManager"},{"type":"method","member":"on","id":"method-on","cls":"Ext.EventManager"},{"type":"method","member":"onDocumentReady","id":"method-onDocumentReady","cls":"Ext.EventManager"},{"type":"method","member":"onWindowResize","id":"method-onWindowResize","cls":"Ext.EventManager"},{"type":"method","member":"preventDefault","id":"method-preventDefault","cls":"Ext.EventManager"},{"type":"method","member":"purgeElement","id":"method-purgeElement","cls":"Ext.EventManager"},{"type":"method","member":"removeAll","id":"method-removeAll","cls":"Ext.EventManager"},{"type":"method","member":"removeListener","id":"method-removeListener","cls":"Ext.EventManager"},{"type":"method","member":"removeResizeListener","id":"method-removeResizeListener","cls":"Ext.EventManager"},{"type":"method","member":"removeUnloadListener","id":"method-removeUnloadListener","cls":"Ext.EventManager"},{"type":"method","member":"stopEvent","id":"method-stopEvent","cls":"Ext.EventManager"},{"type":"method","member":"stopPropagation","id":"method-stopPropagation","cls":"Ext.EventManager"},{"type":"method","member":"un","id":"method-un","cls":"Ext.EventManager"},{"type":"cls","member":"EventObject","cls":"Ext.EventObject","xtypes":{}},{"type":"property","member":"A","id":"property-A","cls":"Ext.EventObject"},{"type":"property","member":"ALT","id":"property-ALT","cls":"Ext.EventObject"},{"type":"property","member":"B","id":"property-B","cls":"Ext.EventObject"},{"type":"property","member":"BACKSPACE","id":"property-BACKSPACE","cls":"Ext.EventObject"},{"type":"property","member":"C","id":"property-C","cls":"Ext.EventObject"},{"type":"property","member":"CAPS_LOCK","id":"property-CAPS_LOCK","cls":"Ext.EventObject"},{"type":"property","member":"CONTEXT_MENU","id":"property-CONTEXT_MENU","cls":"Ext.EventObject"},{"type":"property","member":"CTRL","id":"property-CTRL","cls":"Ext.EventObject"},{"type":"property","member":"D","id":"property-D","cls":"Ext.EventObject"},{"type":"property","member":"DELETE","id":"property-DELETE","cls":"Ext.EventObject"},{"type":"property","member":"DOWN","id":"property-DOWN","cls":"Ext.EventObject"},{"type":"property","member":"E","id":"property-E","cls":"Ext.EventObject"},{"type":"property","member":"EIGHT","id":"property-EIGHT","cls":"Ext.EventObject"},{"type":"property","member":"END","id":"property-END","cls":"Ext.EventObject"},{"type":"property","member":"ENTER","id":"property-ENTER","cls":"Ext.EventObject"},{"type":"property","member":"ESC","id":"property-ESC","cls":"Ext.EventObject"},{"type":"property","member":"F","id":"property-F","cls":"Ext.EventObject"},{"type":"property","member":"F1","id":"property-F1","cls":"Ext.EventObject"},{"type":"property","member":"F10","id":"property-F10","cls":"Ext.EventObject"},{"type":"property","member":"F11","id":"property-F11","cls":"Ext.EventObject"},{"type":"property","member":"F12","id":"property-F12","cls":"Ext.EventObject"},{"type":"property","member":"F2","id":"property-F2","cls":"Ext.EventObject"},{"type":"property","member":"F3","id":"property-F3","cls":"Ext.EventObject"},{"type":"property","member":"F4","id":"property-F4","cls":"Ext.EventObject"},{"type":"property","member":"F5","id":"property-F5","cls":"Ext.EventObject"},{"type":"property","member":"F6","id":"property-F6","cls":"Ext.EventObject"},{"type":"property","member":"F7","id":"property-F7","cls":"Ext.EventObject"},{"type":"property","member":"F8","id":"property-F8","cls":"Ext.EventObject"},{"type":"property","member":"F9","id":"property-F9","cls":"Ext.EventObject"},{"type":"property","member":"FIVE","id":"property-FIVE","cls":"Ext.EventObject"},{"type":"property","member":"FOUR","id":"property-FOUR","cls":"Ext.EventObject"},{"type":"property","member":"G","id":"property-G","cls":"Ext.EventObject"},{"type":"property","member":"H","id":"property-H","cls":"Ext.EventObject"},{"type":"property","member":"HOME","id":"property-HOME","cls":"Ext.EventObject"},{"type":"property","member":"I","id":"property-I","cls":"Ext.EventObject"},{"type":"property","member":"INSERT","id":"property-INSERT","cls":"Ext.EventObject"},{"type":"property","member":"J","id":"property-J","cls":"Ext.EventObject"},{"type":"property","member":"K","id":"property-K","cls":"Ext.EventObject"},{"type":"property","member":"L","id":"property-L","cls":"Ext.EventObject"},{"type":"property","member":"LEFT","id":"property-LEFT","cls":"Ext.EventObject"},{"type":"property","member":"M","id":"property-M","cls":"Ext.EventObject"},{"type":"property","member":"N","id":"property-N","cls":"Ext.EventObject"},{"type":"property","member":"NINE","id":"property-NINE","cls":"Ext.EventObject"},{"type":"property","member":"NUM_CENTER","id":"property-NUM_CENTER","cls":"Ext.EventObject"},{"type":"property","member":"NUM_DIVISION","id":"property-NUM_DIVISION","cls":"Ext.EventObject"},{"type":"property","member":"NUM_EIGHT","id":"property-NUM_EIGHT","cls":"Ext.EventObject"},{"type":"property","member":"NUM_FIVE","id":"property-NUM_FIVE","cls":"Ext.EventObject"},{"type":"property","member":"NUM_FOUR","id":"property-NUM_FOUR","cls":"Ext.EventObject"},{"type":"property","member":"NUM_MINUS","id":"property-NUM_MINUS","cls":"Ext.EventObject"},{"type":"property","member":"NUM_MULTIPLY","id":"property-NUM_MULTIPLY","cls":"Ext.EventObject"},{"type":"property","member":"NUM_NINE","id":"property-NUM_NINE","cls":"Ext.EventObject"},{"type":"property","member":"NUM_ONE","id":"property-NUM_ONE","cls":"Ext.EventObject"},{"type":"property","member":"NUM_PERIOD","id":"property-NUM_PERIOD","cls":"Ext.EventObject"},{"type":"property","member":"NUM_PLUS","id":"property-NUM_PLUS","cls":"Ext.EventObject"},{"type":"property","member":"NUM_SEVEN","id":"property-NUM_SEVEN","cls":"Ext.EventObject"},{"type":"property","member":"NUM_SIX","id":"property-NUM_SIX","cls":"Ext.EventObject"},{"type":"property","member":"NUM_THREE","id":"property-NUM_THREE","cls":"Ext.EventObject"},{"type":"property","member":"NUM_TWO","id":"property-NUM_TWO","cls":"Ext.EventObject"},{"type":"property","member":"NUM_ZERO","id":"property-NUM_ZERO","cls":"Ext.EventObject"},{"type":"property","member":"O","id":"property-O","cls":"Ext.EventObject"},{"type":"property","member":"ONE","id":"property-ONE","cls":"Ext.EventObject"},{"type":"property","member":"P","id":"property-P","cls":"Ext.EventObject"},{"type":"property","member":"PAGE_DOWN","id":"property-PAGE_DOWN","cls":"Ext.EventObject"},{"type":"property","member":"PAGE_UP","id":"property-PAGE_UP","cls":"Ext.EventObject"},{"type":"property","member":"PAUSE","id":"property-PAUSE","cls":"Ext.EventObject"},{"type":"property","member":"PRINT_SCREEN","id":"property-PRINT_SCREEN","cls":"Ext.EventObject"},{"type":"property","member":"Q","id":"property-Q","cls":"Ext.EventObject"},{"type":"property","member":"R","id":"property-R","cls":"Ext.EventObject"},{"type":"property","member":"RETURN","id":"property-RETURN","cls":"Ext.EventObject"},{"type":"property","member":"RIGHT","id":"property-RIGHT","cls":"Ext.EventObject"},{"type":"property","member":"S","id":"property-S","cls":"Ext.EventObject"},{"type":"property","member":"SEVEN","id":"property-SEVEN","cls":"Ext.EventObject"},{"type":"property","member":"SHIFT","id":"property-SHIFT","cls":"Ext.EventObject"},{"type":"property","member":"SIX","id":"property-SIX","cls":"Ext.EventObject"},{"type":"property","member":"SPACE","id":"property-SPACE","cls":"Ext.EventObject"},{"type":"property","member":"T","id":"property-T","cls":"Ext.EventObject"},{"type":"property","member":"TAB","id":"property-TAB","cls":"Ext.EventObject"},{"type":"property","member":"THREE","id":"property-THREE","cls":"Ext.EventObject"},{"type":"property","member":"TWO","id":"property-TWO","cls":"Ext.EventObject"},{"type":"property","member":"U","id":"property-U","cls":"Ext.EventObject"},{"type":"property","member":"UP","id":"property-UP","cls":"Ext.EventObject"},{"type":"property","member":"V","id":"property-V","cls":"Ext.EventObject"},{"type":"property","member":"W","id":"property-W","cls":"Ext.EventObject"},{"type":"property","member":"WHEEL_SCALE","id":"property-WHEEL_SCALE","cls":"Ext.EventObject"},{"type":"property","member":"X","id":"property-X","cls":"Ext.EventObject"},{"type":"property","member":"Y","id":"property-Y","cls":"Ext.EventObject"},{"type":"property","member":"Z","id":"property-Z","cls":"Ext.EventObject"},{"type":"property","member":"ZERO","id":"property-ZERO","cls":"Ext.EventObject"},{"type":"method","member":"correctWheelDelta","id":"method-correctWheelDelta","cls":"Ext.EventObject"},{"type":"method","member":"getCharCode","id":"method-getCharCode","cls":"Ext.EventObject"},{"type":"method","member":"getKey","id":"method-getKey","cls":"Ext.EventObject"},{"type":"method","member":"getPageX","id":"method-getPageX","cls":"Ext.EventObject"},{"type":"method","member":"getPageY","id":"method-getPageY","cls":"Ext.EventObject"},{"type":"method","member":"getPoint","id":"method-getPoint","cls":"Ext.EventObject"},{"type":"method","member":"getRelatedTarget","id":"method-getRelatedTarget","cls":"Ext.EventObject"},{"type":"method","member":"getTarget","id":"method-getTarget","cls":"Ext.EventObject"},{"type":"method","member":"getWheelDelta","id":"method-getWheelDelta","cls":"Ext.EventObject"},{"type":"method","member":"getWheelDeltas","id":"method-getWheelDeltas","cls":"Ext.EventObject"},{"type":"method","member":"getX","id":"method-getX","cls":"Ext.EventObject"},{"type":"method","member":"getXY","id":"method-getXY","cls":"Ext.EventObject"},{"type":"method","member":"getY","id":"method-getY","cls":"Ext.EventObject"},{"type":"method","member":"hasModifier","id":"method-hasModifier","cls":"Ext.EventObject"},{"type":"method","member":"injectEvent","id":"method-injectEvent","cls":"Ext.EventObject"},{"type":"method","member":"isNavKeyPress","id":"method-isNavKeyPress","cls":"Ext.EventObject"},{"type":"method","member":"isSpecialKey","id":"method-isSpecialKey","cls":"Ext.EventObject"},{"type":"method","member":"preventDefault","id":"method-preventDefault","cls":"Ext.EventObject"},{"type":"method","member":"stopEvent","id":"method-stopEvent","cls":"Ext.EventObject"},{"type":"method","member":"stopPropagation","id":"method-stopPropagation","cls":"Ext.EventObject"},{"type":"method","member":"within","id":"method-within","cls":"Ext.EventObject"},{"type":"cls","member":"Ext","cls":"Ext","xtypes":{}},{"type":"property","member":"BLANK_IMAGE_URL","id":"property-BLANK_IMAGE_URL","cls":"Ext"},{"type":"property","member":"SSL_SECURE_URL","id":"property-SSL_SECURE_URL","cls":"Ext"},{"type":"property","member":"USE_NATIVE_JSON","id":"property-USE_NATIVE_JSON","cls":"Ext"},{"type":"property","member":"browser","id":"property-browser","cls":"Ext"},{"type":"property","member":"chromeVersion","id":"property-chromeVersion","cls":"Ext"},{"type":"property","member":"enableFx","id":"property-enableFx","cls":"Ext"},{"type":"property","member":"enableGarbageCollector","id":"property-enableGarbageCollector","cls":"Ext"},{"type":"property","member":"enableListenerCollection","id":"property-enableListenerCollection","cls":"Ext"},{"type":"property","member":"enableNestedListenerRemoval","id":"property-enableNestedListenerRemoval","cls":"Ext"},{"type":"property","member":"enumerables","id":"property-enumerables","cls":"Ext"},{"type":"property","member":"features","id":"property-features","cls":"Ext"},{"type":"property","member":"firefoxVersion","id":"property-firefoxVersion","cls":"Ext"},{"type":"property","member":"ieVersion","id":"property-ieVersion","cls":"Ext"},{"type":"property","member":"isChrome","id":"property-isChrome","cls":"Ext"},{"type":"property","member":"isFF3_0","id":"property-isFF3_0","cls":"Ext"},{"type":"property","member":"isFF3_5","id":"property-isFF3_5","cls":"Ext"},{"type":"property","member":"isFF3_6","id":"property-isFF3_6","cls":"Ext"},{"type":"property","member":"isFF4","id":"property-isFF4","cls":"Ext"},{"type":"property","member":"isFF5","id":"property-isFF5","cls":"Ext"},{"type":"property","member":"isGecko","id":"property-isGecko","cls":"Ext"},{"type":"property","member":"isGecko3","id":"property-isGecko3","cls":"Ext"},{"type":"property","member":"isGecko4","id":"property-isGecko4","cls":"Ext"},{"type":"property","member":"isGecko5","id":"property-isGecko5","cls":"Ext"},{"type":"property","member":"isIE","id":"property-isIE","cls":"Ext"},{"type":"property","member":"isIE6","id":"property-isIE6","cls":"Ext"},{"type":"property","member":"isIE7","id":"property-isIE7","cls":"Ext"},{"type":"property","member":"isIE8","id":"property-isIE8","cls":"Ext"},{"type":"property","member":"isIE9","id":"property-isIE9","cls":"Ext"},{"type":"property","member":"isLinux","id":"property-isLinux","cls":"Ext"},{"type":"property","member":"isMac","id":"property-isMac","cls":"Ext"},{"type":"property","member":"isOpera","id":"property-isOpera","cls":"Ext"},{"type":"property","member":"isOpera10_5","id":"property-isOpera10_5","cls":"Ext"},{"type":"property","member":"isReady","id":"property-isReady","cls":"Ext"},{"type":"property","member":"isSafari","id":"property-isSafari","cls":"Ext"},{"type":"property","member":"isSafari2","id":"property-isSafari2","cls":"Ext"},{"type":"property","member":"isSafari3","id":"property-isSafari3","cls":"Ext"},{"type":"property","member":"isSafari4","id":"property-isSafari4","cls":"Ext"},{"type":"property","member":"isSafari5","id":"property-isSafari5","cls":"Ext"},{"type":"property","member":"isSecure","id":"property-isSecure","cls":"Ext"},{"type":"property","member":"isWebKit","id":"property-isWebKit","cls":"Ext"},{"type":"property","member":"isWindows","id":"property-isWindows","cls":"Ext"},{"type":"property","member":"log","id":"property-log","cls":"Ext"},{"type":"property","member":"operaVersion","id":"property-operaVersion","cls":"Ext"},{"type":"property","member":"os","id":"property-os","cls":"Ext"},{"type":"property","member":"safariVersion","id":"property-safariVersion","cls":"Ext"},{"type":"property","member":"scopeResetCSS","id":"property-scopeResetCSS","cls":"Ext"},{"type":"property","member":"useShims","id":"property-useShims","cls":"Ext"},{"type":"property","member":"webKitVersion","id":"property-webKitVersion","cls":"Ext"},{"type":"method","member":"addBehaviors","id":"method-addBehaviors","cls":"Ext"},{"type":"method","member":"application","id":"method-application","cls":"Ext"},{"type":"method","member":"apply","id":"method-apply","cls":"Ext"},{"type":"method","member":"applyIf","id":"method-applyIf","cls":"Ext"},{"type":"method","member":"bind","id":"method-bind","cls":"Ext"},{"type":"method","member":"callback","id":"method-callback","cls":"Ext"},{"type":"method","member":"clean","id":"method-clean","cls":"Ext"},{"type":"method","member":"clone","id":"method-clone","cls":"Ext"},{"type":"method","member":"copyTo","id":"method-copyTo","cls":"Ext"},{"type":"method","member":"create","id":"method-create","cls":"Ext"},{"type":"method","member":"createByAlias","id":"method-createByAlias","cls":"Ext"},{"type":"method","member":"createWidget","id":"method-createWidget","cls":"Ext"},{"type":"method","member":"decode","id":"method-decode","cls":"Ext"},{"type":"method","member":"defer","id":"method-defer","cls":"Ext"},{"type":"method","member":"define","id":"method-define","cls":"Ext"},{"type":"method","member":"destroy","id":"method-destroy","cls":"Ext"},{"type":"method","member":"destroyMembers","id":"method-destroyMembers","cls":"Ext"},{"type":"method","member":"each","id":"method-each","cls":"Ext"},{"type":"method","member":"emptyFn","id":"method-emptyFn","cls":"Ext"},{"type":"method","member":"encode","id":"method-encode","cls":"Ext"},{"type":"method","member":"escapeRe","id":"method-escapeRe","cls":"Ext"},{"type":"method","member":"exclude","id":"method-exclude","cls":"Ext"},{"type":"method","member":"extend","id":"method-extend","cls":"Ext"},{"type":"method","member":"flatten","id":"method-flatten","cls":"Ext"},{"type":"method","member":"fly","id":"method-fly","cls":"Ext"},{"type":"method","member":"get","id":"method-get","cls":"Ext"},{"type":"method","member":"getBody","id":"method-getBody","cls":"Ext"},{"type":"method","member":"getClass","id":"method-getClass","cls":"Ext"},{"type":"method","member":"getClassName","id":"method-getClassName","cls":"Ext"},{"type":"method","member":"getCmp","id":"method-getCmp","cls":"Ext"},{"type":"method","member":"getDoc","id":"method-getDoc","cls":"Ext"},{"type":"method","member":"getDom","id":"method-getDom","cls":"Ext"},{"type":"method","member":"getHead","id":"method-getHead","cls":"Ext"},{"type":"method","member":"getOrientation","id":"method-getOrientation","cls":"Ext"},{"type":"method","member":"getScrollBarWidth","id":"method-getScrollBarWidth","cls":"Ext"},{"type":"method","member":"getScrollbarSize","id":"method-getScrollbarSize","cls":"Ext"},{"type":"method","member":"getStore","id":"method-getStore","cls":"Ext"},{"type":"method","member":"htmlDecode","id":"method-htmlDecode","cls":"Ext"},{"type":"method","member":"htmlEncode","id":"method-htmlEncode","cls":"Ext"},{"type":"method","member":"id","id":"method-id","cls":"Ext"},{"type":"method","member":"invoke","id":"method-invoke","cls":"Ext"},{"type":"method","member":"isArray","id":"method-isArray","cls":"Ext"},{"type":"method","member":"isBoolean","id":"method-isBoolean","cls":"Ext"},{"type":"method","member":"isDate","id":"method-isDate","cls":"Ext"},{"type":"method","member":"isDefined","id":"method-isDefined","cls":"Ext"},{"type":"method","member":"isElement","id":"method-isElement","cls":"Ext"},{"type":"method","member":"isEmpty","id":"method-isEmpty","cls":"Ext"},{"type":"method","member":"isFunction","id":"method-isFunction","cls":"Ext"},{"type":"method","member":"isIterable","id":"method-isIterable","cls":"Ext"},{"type":"method","member":"isNumber","id":"method-isNumber","cls":"Ext"},{"type":"method","member":"isNumeric","id":"method-isNumeric","cls":"Ext"},{"type":"method","member":"isObject","id":"method-isObject","cls":"Ext"},{"type":"method","member":"isPrimitive","id":"method-isPrimitive","cls":"Ext"},{"type":"method","member":"isString","id":"method-isString","cls":"Ext"},{"type":"method","member":"isTextNode","id":"method-isTextNode","cls":"Ext"},{"type":"method","member":"iterate","id":"method-iterate","cls":"Ext"},{"type":"method","member":"max","id":"method-max","cls":"Ext"},{"type":"method","member":"mean","id":"method-mean","cls":"Ext"},{"type":"method","member":"merge","id":"method-merge","cls":"Ext"},{"type":"method","member":"min","id":"method-min","cls":"Ext"},{"type":"method","member":"namespace","id":"method-namespace","cls":"Ext"},{"type":"method","member":"ns","id":"method-ns","cls":"Ext"},{"type":"method","member":"num","id":"method-num","cls":"Ext"},{"type":"method","member":"onDocumentReady","id":"method-onDocumentReady","cls":"Ext"},{"type":"method","member":"onReady","id":"method-onReady","cls":"Ext"},{"type":"method","member":"override","id":"method-override","cls":"Ext"},{"type":"method","member":"partition","id":"method-partition","cls":"Ext"},{"type":"method","member":"pass","id":"method-pass","cls":"Ext"},{"type":"method","member":"pluck","id":"method-pluck","cls":"Ext"},{"type":"method","member":"preg","id":"method-preg","cls":"Ext"},{"type":"method","member":"query","id":"method-query","cls":"Ext"},{"type":"method","member":"regModel","id":"method-regModel","cls":"Ext"},{"type":"method","member":"regStore","id":"method-regStore","cls":"Ext"},{"type":"method","member":"removeNode","id":"method-removeNode","cls":"Ext"},{"type":"method","member":"require","id":"method-require","cls":"Ext"},{"type":"method","member":"select","id":"method-select","cls":"Ext"},{"type":"method","member":"sum","id":"method-sum","cls":"Ext"},{"type":"method","member":"syncRequire","id":"method-syncRequire","cls":"Ext"},{"type":"method","member":"toArray","id":"method-toArray","cls":"Ext"},{"type":"method","member":"toSentence","id":"method-toSentence","cls":"Ext"},{"type":"method","member":"type","id":"method-type","cls":"Ext"},{"type":"method","member":"typeOf","id":"method-typeOf","cls":"Ext"},{"type":"method","member":"unique","id":"method-unique","cls":"Ext"},{"type":"method","member":"urlAppend","id":"method-urlAppend","cls":"Ext"},{"type":"method","member":"urlDecode","id":"method-urlDecode","cls":"Ext"},{"type":"method","member":"urlEncode","id":"method-urlEncode","cls":"Ext"},{"type":"method","member":"value","id":"method-value","cls":"Ext"},{"type":"method","member":"valueFrom","id":"method-valueFrom","cls":"Ext"},{"type":"method","member":"widget","id":"method-widget","cls":"Ext"},{"type":"method","member":"zip","id":"method-zip","cls":"Ext"},{"type":"cls","member":"Array","cls":"Ext.Array","xtypes":{}},{"type":"property","member":"slice","id":"property-slice","cls":"Ext.Array"},{"type":"method","member":"clean","id":"method-clean","cls":"Ext.Array"},{"type":"method","member":"clone","id":"method-clone","cls":"Ext.Array"},{"type":"method","member":"contains","id":"method-contains","cls":"Ext.Array"},{"type":"method","member":"difference","id":"method-difference","cls":"Ext.Array"},{"type":"method","member":"each","id":"method-each","cls":"Ext.Array"},{"type":"method","member":"erase","id":"method-erase","cls":"Ext.Array"},{"type":"method","member":"every","id":"method-every","cls":"Ext.Array"},{"type":"method","member":"filter","id":"method-filter","cls":"Ext.Array"},{"type":"method","member":"flatten","id":"method-flatten","cls":"Ext.Array"},{"type":"method","member":"forEach","id":"method-forEach","cls":"Ext.Array"},{"type":"method","member":"from","id":"method-from","cls":"Ext.Array"},{"type":"method","member":"include","id":"method-include","cls":"Ext.Array"},{"type":"method","member":"indexOf","id":"method-indexOf","cls":"Ext.Array"},{"type":"method","member":"insert","id":"method-insert","cls":"Ext.Array"},{"type":"method","member":"intersect","id":"method-intersect","cls":"Ext.Array"},{"type":"method","member":"map","id":"method-map","cls":"Ext.Array"},{"type":"method","member":"max","id":"method-max","cls":"Ext.Array"},{"type":"method","member":"mean","id":"method-mean","cls":"Ext.Array"},{"type":"method","member":"merge","id":"method-merge","cls":"Ext.Array"},{"type":"method","member":"min","id":"method-min","cls":"Ext.Array"},{"type":"method","member":"pluck","id":"method-pluck","cls":"Ext.Array"},{"type":"method","member":"remove","id":"method-remove","cls":"Ext.Array"},{"type":"method","member":"replace","id":"method-replace","cls":"Ext.Array"},{"type":"method","member":"some","id":"method-some","cls":"Ext.Array"},{"type":"method","member":"sort","id":"method-sort","cls":"Ext.Array"},{"type":"method","member":"splice","id":"method-splice","cls":"Ext.Array"},{"type":"method","member":"sum","id":"method-sum","cls":"Ext.Array"},{"type":"method","member":"toArray","id":"method-toArray","cls":"Ext.Array"},{"type":"method","member":"union","id":"method-union","cls":"Ext.Array"},{"type":"method","member":"unique","id":"method-unique","cls":"Ext.Array"},{"type":"cls","member":"Date","cls":"Ext.Date","xtypes":{}},{"type":"property","member":"DAY","id":"property-DAY","cls":"Ext.Date"},{"type":"property","member":"HOUR","id":"property-HOUR","cls":"Ext.Date"},{"type":"property","member":"MILLI","id":"property-MILLI","cls":"Ext.Date"},{"type":"property","member":"MINUTE","id":"property-MINUTE","cls":"Ext.Date"},{"type":"property","member":"MONTH","id":"property-MONTH","cls":"Ext.Date"},{"type":"property","member":"SECOND","id":"property-SECOND","cls":"Ext.Date"},{"type":"property","member":"YEAR","id":"property-YEAR","cls":"Ext.Date"},{"type":"property","member":"dayNames","id":"property-dayNames","cls":"Ext.Date"},{"type":"property","member":"defaultFormat","id":"property-defaultFormat","cls":"Ext.Date"},{"type":"property","member":"defaults","id":"property-defaults","cls":"Ext.Date"},{"type":"property","member":"formatCodes","id":"property-formatCodes","cls":"Ext.Date"},{"type":"property","member":"formatFunctions","id":"property-formatFunctions","cls":"Ext.Date"},{"type":"property","member":"monthNames","id":"property-monthNames","cls":"Ext.Date"},{"type":"property","member":"monthNumbers","id":"property-monthNumbers","cls":"Ext.Date"},{"type":"property","member":"parseFunctions","id":"property-parseFunctions","cls":"Ext.Date"},{"type":"property","member":"useStrict","id":"property-useStrict","cls":"Ext.Date"},{"type":"method","member":"add","id":"method-add","cls":"Ext.Date"},{"type":"method","member":"between","id":"method-between","cls":"Ext.Date"},{"type":"method","member":"clearTime","id":"method-clearTime","cls":"Ext.Date"},{"type":"method","member":"clone","id":"method-clone","cls":"Ext.Date"},{"type":"method","member":"format","id":"method-format","cls":"Ext.Date"},{"type":"method","member":"formatContainsDateInfo","id":"method-formatContainsDateInfo","cls":"Ext.Date"},{"type":"method","member":"formatContainsHourInfo","id":"method-formatContainsHourInfo","cls":"Ext.Date"},{"type":"method","member":"getDayOfYear","id":"method-getDayOfYear","cls":"Ext.Date"},{"type":"method","member":"getDaysInMonth","id":"method-getDaysInMonth","cls":"Ext.Date"},{"type":"method","member":"getElapsed","id":"method-getElapsed","cls":"Ext.Date"},{"type":"method","member":"getFirstDateOfMonth","id":"method-getFirstDateOfMonth","cls":"Ext.Date"},{"type":"method","member":"getFirstDayOfMonth","id":"method-getFirstDayOfMonth","cls":"Ext.Date"},{"type":"method","member":"getGMTOffset","id":"method-getGMTOffset","cls":"Ext.Date"},{"type":"method","member":"getLastDateOfMonth","id":"method-getLastDateOfMonth","cls":"Ext.Date"},{"type":"method","member":"getLastDayOfMonth","id":"method-getLastDayOfMonth","cls":"Ext.Date"},{"type":"method","member":"getMonthNumber","id":"method-getMonthNumber","cls":"Ext.Date"},{"type":"method","member":"getShortDayName","id":"method-getShortDayName","cls":"Ext.Date"},{"type":"method","member":"getShortMonthName","id":"method-getShortMonthName","cls":"Ext.Date"},{"type":"method","member":"getSuffix","id":"method-getSuffix","cls":"Ext.Date"},{"type":"method","member":"getTimezone","id":"method-getTimezone","cls":"Ext.Date"},{"type":"method","member":"getWeekOfYear","id":"method-getWeekOfYear","cls":"Ext.Date"},{"type":"method","member":"isDST","id":"method-isDST","cls":"Ext.Date"},{"type":"method","member":"isLeapYear","id":"method-isLeapYear","cls":"Ext.Date"},{"type":"method","member":"isValid","id":"method-isValid","cls":"Ext.Date"},{"type":"method","member":"now","id":"method-now","cls":"Ext.Date"},{"type":"method","member":"parse","id":"method-parse","cls":"Ext.Date"},{"type":"cls","member":"Error","cls":"Ext.Error","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.Error"},{"type":"method","member":"toString","id":"method-toString","cls":"Ext.Error"},{"type":"property","member":"ignore","id":"static-property-ignore","cls":"Ext.Error"},{"type":"property","member":"notify","id":"static-property-notify","cls":"Ext.Error"},{"type":"method","member":"handle","id":"static-method-handle","cls":"Ext.Error"},{"type":"method","member":"raise","id":"static-method-raise","cls":"Ext.Error"},{"type":"cls","member":"Function","cls":"Ext.Function","xtypes":{}},{"type":"method","member":"alias","id":"method-alias","cls":"Ext.Function"},{"type":"method","member":"bind","id":"method-bind","cls":"Ext.Function"},{"type":"method","member":"createBuffered","id":"method-createBuffered","cls":"Ext.Function"},{"type":"method","member":"createDelayed","id":"method-createDelayed","cls":"Ext.Function"},{"type":"method","member":"createInterceptor","id":"method-createInterceptor","cls":"Ext.Function"},{"type":"method","member":"createSequence","id":"method-createSequence","cls":"Ext.Function"},{"type":"method","member":"createThrottled","id":"method-createThrottled","cls":"Ext.Function"},{"type":"method","member":"defer","id":"method-defer","cls":"Ext.Function"},{"type":"method","member":"flexSetter","id":"method-flexSetter","cls":"Ext.Function"},{"type":"method","member":"interceptAfter","id":"method-interceptAfter","cls":"Ext.Function"},{"type":"method","member":"interceptBefore","id":"method-interceptBefore","cls":"Ext.Function"},{"type":"method","member":"pass","id":"method-pass","cls":"Ext.Function"},{"type":"cls","member":"Number","cls":"Ext.Number","xtypes":{}},{"type":"method","member":"constrain","id":"method-constrain","cls":"Ext.Number"},{"type":"method","member":"from","id":"method-from","cls":"Ext.Number"},{"type":"method","member":"snap","id":"method-snap","cls":"Ext.Number"},{"type":"method","member":"toFixed","id":"method-toFixed","cls":"Ext.Number"},{"type":"cls","member":"Object","cls":"Ext.Object","xtypes":{}},{"type":"method","member":"each","id":"method-each","cls":"Ext.Object"},{"type":"method","member":"fromQueryString","id":"method-fromQueryString","cls":"Ext.Object"},{"type":"method","member":"getKey","id":"method-getKey","cls":"Ext.Object"},{"type":"method","member":"getKeys","id":"method-getKeys","cls":"Ext.Object"},{"type":"method","member":"getSize","id":"method-getSize","cls":"Ext.Object"},{"type":"method","member":"getValues","id":"method-getValues","cls":"Ext.Object"},{"type":"method","member":"merge","id":"method-merge","cls":"Ext.Object"},{"type":"method","member":"toQueryObjects","id":"method-toQueryObjects","cls":"Ext.Object"},{"type":"method","member":"toQueryString","id":"method-toQueryString","cls":"Ext.Object"},{"type":"cls","member":"String","cls":"Ext.String","xtypes":{}},{"type":"method","member":"capitalize","id":"method-capitalize","cls":"Ext.String"},{"type":"method","member":"ellipsis","id":"method-ellipsis","cls":"Ext.String"},{"type":"method","member":"escape","id":"method-escape","cls":"Ext.String"},{"type":"method","member":"escapeRegex","id":"method-escapeRegex","cls":"Ext.String"},{"type":"method","member":"format","id":"method-format","cls":"Ext.String"},{"type":"method","member":"htmlDecode","id":"method-htmlDecode","cls":"Ext.String"},{"type":"method","member":"htmlEncode","id":"method-htmlEncode","cls":"Ext.String"},{"type":"method","member":"leftPad","id":"method-leftPad","cls":"Ext.String"},{"type":"method","member":"repeat","id":"method-repeat","cls":"Ext.String"},{"type":"method","member":"toggle","id":"method-toggle","cls":"Ext.String"},{"type":"method","member":"trim","id":"method-trim","cls":"Ext.String"},{"type":"method","member":"urlAppend","id":"method-urlAppend","cls":"Ext.String"},{"type":"cls","member":"JSON","cls":"Ext.JSON","xtypes":{}},{"type":"method","member":"decode","id":"method-decode","cls":"Ext.JSON"},{"type":"method","member":"encode","id":"method-encode","cls":"Ext.JSON"},{"type":"method","member":"encodeDate","id":"method-encodeDate","cls":"Ext.JSON"},{"type":"cls","member":"is","cls":"Ext.is","xtypes":{}},{"type":"property","member":"Android","id":"property-Android","cls":"Ext.is"},{"type":"property","member":"Blackberry","id":"property-Blackberry","cls":"Ext.is"},{"type":"property","member":"Desktop","id":"property-Desktop","cls":"Ext.is"},{"type":"property","member":"Linux","id":"property-Linux","cls":"Ext.is"},{"type":"property","member":"Mac","id":"property-Mac","cls":"Ext.is"},{"type":"property","member":"Phone","id":"property-Phone","cls":"Ext.is"},{"type":"property","member":"Standalone","id":"property-Standalone","cls":"Ext.is"},{"type":"property","member":"Tablet","id":"property-Tablet","cls":"Ext.is"},{"type":"property","member":"Windows","id":"property-Windows","cls":"Ext.is"},{"type":"property","member":"iOS","id":"property-iOS","cls":"Ext.is"},{"type":"property","member":"iPad","id":"property-iPad","cls":"Ext.is"},{"type":"property","member":"iPhone","id":"property-iPhone","cls":"Ext.is"},{"type":"property","member":"iPod","id":"property-iPod","cls":"Ext.is"},{"type":"cls","member":"supports","cls":"Ext.supports","xtypes":{}},{"type":"property","member":"ArraySort","id":"property-ArraySort","cls":"Ext.supports"},{"type":"property","member":"AudioTag","id":"property-AudioTag","cls":"Ext.supports"},{"type":"property","member":"BoundingClientRect","id":"property-BoundingClientRect","cls":"Ext.supports"},{"type":"property","member":"CSS3BorderRadius","id":"property-CSS3BorderRadius","cls":"Ext.supports"},{"type":"property","member":"CSS3BoxShadow","id":"property-CSS3BoxShadow","cls":"Ext.supports"},{"type":"property","member":"CSS3DTransform","id":"property-CSS3DTransform","cls":"Ext.supports"},{"type":"property","member":"CSS3LinearGradient","id":"property-CSS3LinearGradient","cls":"Ext.supports"},{"type":"property","member":"Canvas","id":"property-Canvas","cls":"Ext.supports"},{"type":"property","member":"ClassList","id":"property-ClassList","cls":"Ext.supports"},{"type":"property","member":"ComputedStyle","id":"property-ComputedStyle","cls":"Ext.supports"},{"type":"property","member":"CreateContextualFragment","id":"property-CreateContextualFragment","cls":"Ext.supports"},{"type":"property","member":"DeviceMotion","id":"property-DeviceMotion","cls":"Ext.supports"},{"type":"property","member":"Direct2DBug","id":"property-Direct2DBug","cls":"Ext.supports"},{"type":"property","member":"DisplayChangeInputSelectionBug","id":"property-DisplayChangeInputSelectionBug","cls":"Ext.supports"},{"type":"property","member":"DisplayChangeTextAreaSelectionBug","id":"property-DisplayChangeTextAreaSelectionBug","cls":"Ext.supports"},{"type":"property","member":"Float","id":"property-Float","cls":"Ext.supports"},{"type":"property","member":"GeoLocation","id":"property-GeoLocation","cls":"Ext.supports"},{"type":"property","member":"History","id":"property-History","cls":"Ext.supports"},{"type":"property","member":"MouseEnterLeave","id":"property-MouseEnterLeave","cls":"Ext.supports"},{"type":"property","member":"MouseWheel","id":"property-MouseWheel","cls":"Ext.supports"},{"type":"property","member":"Opacity","id":"property-Opacity","cls":"Ext.supports"},{"type":"property","member":"OrientationChange","id":"property-OrientationChange","cls":"Ext.supports"},{"type":"property","member":"Placeholder","id":"property-Placeholder","cls":"Ext.supports"},{"type":"property","member":"Range","id":"property-Range","cls":"Ext.supports"},{"type":"property","member":"RightMargin","id":"property-RightMargin","cls":"Ext.supports"},{"type":"property","member":"SVG","id":"property-SVG","cls":"Ext.supports"},{"type":"property","member":"Touch","id":"property-Touch","cls":"Ext.supports"},{"type":"property","member":"Transitions","id":"property-Transitions","cls":"Ext.supports"},{"type":"property","member":"TransparentColor","id":"property-TransparentColor","cls":"Ext.supports"},{"type":"property","member":"VML","id":"property-VML","cls":"Ext.supports"},{"type":"property","member":"WindowOnError","id":"property-WindowOnError","cls":"Ext.supports"},{"type":"cls","member":"DelayedTask","cls":"Ext.util.DelayedTask","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.DelayedTask"},{"type":"method","member":"cancel","id":"method-cancel","cls":"Ext.util.DelayedTask"},{"type":"method","member":"delay","id":"method-delay","cls":"Ext.util.DelayedTask"},{"type":"cls","member":"Format","cls":"Ext.util.Format","xtypes":{}},{"type":"property","member":"currencyAtEnd","id":"property-currencyAtEnd","cls":"Ext.util.Format"},{"type":"property","member":"currencyPrecision","id":"property-currencyPrecision","cls":"Ext.util.Format"},{"type":"property","member":"currencySign","id":"property-currencySign","cls":"Ext.util.Format"},{"type":"property","member":"decimalSeparator","id":"property-decimalSeparator","cls":"Ext.util.Format"},{"type":"property","member":"thousandSeparator","id":"property-thousandSeparator","cls":"Ext.util.Format"},{"type":"method","member":"capitalize","id":"method-capitalize","cls":"Ext.util.Format"},{"type":"method","member":"currency","id":"method-currency","cls":"Ext.util.Format"},{"type":"method","member":"date","id":"method-date","cls":"Ext.util.Format"},{"type":"method","member":"dateRenderer","id":"method-dateRenderer","cls":"Ext.util.Format"},{"type":"method","member":"defaultValue","id":"method-defaultValue","cls":"Ext.util.Format"},{"type":"method","member":"ellipsis","id":"method-ellipsis","cls":"Ext.util.Format"},{"type":"method","member":"escapeRegex","id":"method-escapeRegex","cls":"Ext.util.Format"},{"type":"method","member":"fileSize","id":"method-fileSize","cls":"Ext.util.Format"},{"type":"method","member":"format","id":"method-format","cls":"Ext.util.Format"},{"type":"method","member":"htmlDecode","id":"method-htmlDecode","cls":"Ext.util.Format"},{"type":"method","member":"htmlEncode","id":"method-htmlEncode","cls":"Ext.util.Format"},{"type":"method","member":"leftPad","id":"method-leftPad","cls":"Ext.util.Format"},{"type":"method","member":"lowercase","id":"method-lowercase","cls":"Ext.util.Format"},{"type":"method","member":"math","id":"method-math","cls":"Ext.util.Format"},{"type":"method","member":"nl2br","id":"method-nl2br","cls":"Ext.util.Format"},{"type":"method","member":"number","id":"method-number","cls":"Ext.util.Format"},{"type":"method","member":"numberRenderer","id":"method-numberRenderer","cls":"Ext.util.Format"},{"type":"method","member":"parseBox","id":"method-parseBox","cls":"Ext.util.Format"},{"type":"method","member":"plural","id":"method-plural","cls":"Ext.util.Format"},{"type":"method","member":"round","id":"method-round","cls":"Ext.util.Format"},{"type":"method","member":"stripScripts","id":"method-stripScripts","cls":"Ext.util.Format"},{"type":"method","member":"stripTags","id":"method-stripTags","cls":"Ext.util.Format"},{"type":"method","member":"substr","id":"method-substr","cls":"Ext.util.Format"},{"type":"method","member":"trim","id":"method-trim","cls":"Ext.util.Format"},{"type":"method","member":"undef","id":"method-undef","cls":"Ext.util.Format"},{"type":"method","member":"uppercase","id":"method-uppercase","cls":"Ext.util.Format"},{"type":"method","member":"usMoney","id":"method-usMoney","cls":"Ext.util.Format"},{"type":"cls","member":"TaskRunner","cls":"Ext.util.TaskRunner","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.util.TaskRunner"},{"type":"method","member":"start","id":"method-start","cls":"Ext.util.TaskRunner"},{"type":"method","member":"stop","id":"method-stop","cls":"Ext.util.TaskRunner"},{"type":"method","member":"stopAll","id":"method-stopAll","cls":"Ext.util.TaskRunner"},{"type":"cls","member":"TaskManager","cls":"Ext.TaskManager","xtypes":{}},{"type":"cls","member":"Version","cls":"Ext.Version","xtypes":{}},{"type":"method","member":"constructor","id":"method-constructor","cls":"Ext.Version"},{"type":"method","member":"deprecate","id":"method-deprecate","cls":"Ext.Version"},{"type":"method","member":"equals","id":"method-equals","cls":"Ext.Version"},{"type":"method","member":"getBuild","id":"method-getBuild","cls":"Ext.Version"},{"type":"method","member":"getMajor","id":"method-getMajor","cls":"Ext.Version"},{"type":"method","member":"getMinor","id":"method-getMinor","cls":"Ext.Version"},{"type":"method","member":"getPatch","id":"method-getPatch","cls":"Ext.Version"},{"type":"method","member":"getRelease","id":"method-getRelease","cls":"Ext.Version"},{"type":"method","member":"getShortVersion","id":"method-getShortVersion","cls":"Ext.Version"},{"type":"method","member":"getVersion","id":"method-getVersion","cls":"Ext.Version"},{"type":"method","member":"isGreaterThan","id":"method-isGreaterThan","cls":"Ext.Version"},{"type":"method","member":"isLessThan","id":"method-isLessThan","cls":"Ext.Version"},{"type":"method","member":"match","id":"method-match","cls":"Ext.Version"},{"type":"method","member":"setVersion","id":"method-setVersion","cls":"Ext.Version"},{"type":"method","member":"toArray","id":"method-toArray","cls":"Ext.Version"},{"type":"method","member":"compare","id":"static-method-compare","cls":"Ext.Version"},{"type":"method","member":"getComponentValue","id":"static-method-getComponentValue","cls":"Ext.Version"}],"examples":[{"items":[{"url":"feed-viewer/feed-viewer.html","text":"Feed Viewer","icon":"feeds.gif","desc":"RSS feed reader example application that features a swappable reader panel layout.","status":"updated"},{"url":"desktop/desktop.html","text":"Web Desktop","icon":"desktop.gif","desc":"Demonstrates how one could build a desktop in the browser using Ext components including a module plugin system.","status":"updated"},{"url":"portal/portal.html","text":"Portal Demo","icon":"portal.gif","desc":"A page layout using several custom extensions to provide a web portal interface.","status":"updated"},{"url":"sandbox/sandbox.html","text":"Ext JS 3 & 4 on one page","icon":"sandbox.gif","desc":"This example demonstrates Ext JS 4's sandboxing behavior which allows you to run Ext JS 3 & 4 on the same page.","status":"new"},{"url":"organizer/organizer.html","text":"Image Viewer","icon":"organizer.gif","desc":"DataView and TreePanel example that demonstrates dragging data items from a DataView into a TreePanel."},{"url":"themes/index.html","text":"Theme Viewer","icon":"themes.gif","desc":"View and test every Ext component against bundled Ext themes."}],"title":"Combination Examples"},{"items":[{"url":"key-feed-viewer/feed-viewer.html","text":"Keyboard Feed Viewer","icon":"keyboard.gif","desc":"Shows Ext JS 4's comprehensive keyboard support for users who have difficulty using a pointing device","status":"new"},{"url":"form/form-grid-access.html","text":"Binding a Grid to a Form","icon":"form-grid-binding-access.gif","desc":"A grid embedded within a FormPanel that uses the Accessibility theme."}],"title":"Accessibility"},{"items":[{"url":"grid/array-grid.html","text":"Basic Array Grid","icon":"grid-array.gif","desc":"A basic read-only grid loaded from local array data that demonstrates the use of custom column renderer functions.","status":"updated"},{"url":"grid/xml-grid.html","text":"XML Grid","icon":"grid-xml.gif","desc":"A simple read-only grid loaded from XML data."},{"url":"grid/paging.html","text":"Paging","icon":"grid-paging.gif","desc":"A grid with paging, cross-domain data loading and custom- rendered expandable row bodies."},{"url":"grid/sliding-pager.html","text":"Sliding Pager","icon":"slider-pager.gif","desc":"A demonstration on the integration of the Slider with the Paging Toolbar using a custom plugin."},{"url":"grid/groupgrid.html","text":"Grouping","icon":"grid-grouping.gif","desc":"A basic grouping grid showing collapsible data groups that can be customized via the 'Group By' header menu option."},{"url":"grid/grid-plugins.html","text":"Grid Plugins","icon":"grid-plugins.gif","desc":"Multiple grids customized via plugins: expander rows, checkbox selection and row numbering."},{"url":"grid-filtering/grid-filter-local.html","text":"Grid Filtering","icon":"grid-filter.gif","desc":"Grid feature providing custom data filtering menus that support various data types.","status":"updated"},{"url":"grid/binding.html","text":"Grid Data Binding (basic)","icon":"grid-data-binding.gif","desc":"Data binding a grid to a detail preview panel via the grid\"s RowSelectionModel."},{"url":"grid/binding-with-classes.html","text":"Grid Data Binding (advanced)","icon":"grid-data-binding.gif","desc":"Refactoring the basic data binding example to use a class-based application design model."},{"url":"grid/multiple-sorting.html","text":"Multiple Sorting","icon":"grid-multiple-sorting.gif","desc":"An example that shows multi-level sorting in a Grid Panel."},{"url":"grid/cell-editing.html","text":"Grid Cell Editing","icon":"grid-cell-editing.gif","desc":"An example that shows cell editing in a Grid Panel.","status":"updated"},{"url":"grid/group-header-grid.html","text":"Grouped Header Grid","icon":"grid-grouped-headers.gif","desc":"A basic grouping grid showing collapsible data groups that can be customized via the 'Group By' header menu option.","status":"updated"},{"url":"grid/group-summary-grid.html","text":"Grid Grouping with Summary","icon":"grid-summary.gif","desc":"Advanced grouping grid that allows cell editing and includes custom dynamic summary calculations.","status":"updated"},{"url":"grid/infinite-scroll.html","text":"Infinite Grid","icon":"grid-infinite-scroll.gif","desc":"Sample grid which scrolls through thousands of rows dynamically loaded from a server","status":"new"},{"url":"grid/live-search-grid.html","text":"Grid with Live Search Capability","icon":"grid-live-search.gif","desc":"Grid with Live Search Capability.","status":"new"},{"url":"grid/locking-grid.html","text":"Grid with Locking Capability","icon":"grid-locking.gif","desc":"An example extension that introduces the ability to add locking columns to the GridPanel.","status":"updated"},{"url":"grid/remote-group-summary-grid.html","text":"Grouping with Remote Summary","icon":"grid-group-summaries.gif","desc":"Advanced grouping grid that allows cell editing and includes remotely loaded dynamic summary calculations."},{"url":"grid/row-editing.html","text":"Grid Row Editing","icon":"grid-row-editor.gif","desc":"An editable grid which allows the user to make modifications to an entire record at once.","status":"updated"},{"url":"restful/restful.html","text":"RESTful Store with GridPanel and RowEditor","icon":"grid-row-editor.gif","desc":"A RESTful Store with JsonWriter which automatically generates CRUD requests to the server."},{"url":"writer/writer.html","text":"Editable Grid with Writable Store","icon":"writer-thumb.gif","desc":"This Store uses Data's writer to automatically generate CRUD requests to the server through a standard HttpProxy."},{"url":"grid/buffer-grid.html","text":"Buffered Scrolling","icon":"buffer-grid.gif","desc":"The new grid uses a virtualized scrolling system to handle potentially infinite data sets without any impact on client side performance.","status":"updated"},{"url":"grid/list-view.html","text":"List View","icon":"list-view.gif","desc":"Ext 4 replaces Ext.ListView with the default Ext.grid.Panel.","status":"updated"},{"url":"grid/progress-bar-pager.html","text":"Progress Bar Pager","icon":"progress-bar-pager.gif","desc":"Progress Bar Pager Extension."},{"url":"grid/property.html","text":"Property Grid","icon":"grid-property.gif","desc":"Create a property grid from an object."},{"url":"grid/transform-dom.html","text":"Grid From Markup","icon":"grid-transform.gif","desc":"Create a grid with from an existing, unformatted HTML table."}],"title":"Grids"},{"items":[{"url":"charts/Area.html","text":"Area Charts","icon":"chart-area.gif","desc":"Display 7 sets of random data in an area series. Reload data will randomly generate a new set of data in the store.","status":"new"},{"url":"charts/Area - BrowserStats.html","text":"Custom Area Charts","icon":"area-browsers.gif","desc":"Display browser usage trends in an area series. This chart uses custom gradients for the colors and the legend is interactive.","status":"new"},{"url":"charts/Bar.html","text":"Bar Charts","icon":"chart-bar.gif","desc":"Display a sets of random data in a bar series. Reload data will randomly generate a new set of data in the store.","status":"new"},{"url":"charts/BarRenderer.html","text":"Custom Bar Charts","icon":"chart-bar-renderer.gif","desc":"Displaying a horizontal bar series with a bar renderer that modifies the color of each bar.","status":"new"},{"url":"charts/FormDashboard.html","text":"Complex Dashboard","icon":"form-dashboard.gif","desc":"Showing companies information in a complex dashboard. Edit the information for each record in the form to see live updates in the charts and grid.","status":"new"},{"url":"charts/TipsChart.html","text":"Rich Tips","icon":"rich-tips.gif","desc":"Showing a line series with rich tips. Tips show dynamic information in Grid and Pie chart components.","status":"new"},{"url":"charts/Charts.html","text":"Themed Line Charts","icon":"chart-themed.gif","desc":"Using 3.x theme. Displaying multiple charts and mixed charts with mouse over and click interaction.","status":"new"},{"url":"charts/Column.html","text":"Column Charts","icon":"chart-column.gif","desc":"Display a set of random data in a column series. Reload data will randomly generate a new set of data in the store.","status":"new"},{"url":"charts/Line.html","text":"Line Charts","icon":"chart-line.gif","desc":"Display 2 sets of random data in a line series. Reload data will randomly generate a new set of data in the store.","status":"new"},{"url":"charts/Column2.html","text":"Column Custom Background","icon":"column2.gif","desc":"A Column chart with customized theme and animation transitions","status":"new"},{"url":"charts/Mixed.html","text":"Mixed Series Chart","icon":"chart-mixed.gif","desc":"Display 3 sets of random data using a line, bar, and scatter series. Reload data will randomly generate a new set of data in the store.","status":"new"},{"url":"charts/Pie.html","text":"Pie Charts","icon":"chart-pie.gif","desc":"Display 5 sets of random data using a pie chart. Reload data will randomly generate a new set of data in the store.","status":"new"},{"url":"charts/PieRenderer.html","text":"Custom Pie Charts","icon":"chart-pie-renderer.gif","desc":"Display 5 sets of random data using a pie chart. A renderer has been set up on to dynamically change the length and color of each slice based on the data.","status":"new"},{"url":"charts/Radar.html","text":"Radar Charts","icon":"chart-radar.gif","desc":"Display 3 sets of random data in a radar series. Note this example uses a radial axis.","status":"new"},{"url":"charts/RadarFill.html","text":"Filled Radar Charts","icon":"chart-radar-fill.gif","desc":"Display 3 sets of random data in a filled radar series. Click or hover on the legend items to highlight and remove them from the chart.","status":"new"},{"url":"charts/Scatter - Renderer.html","text":"Scatter Charts","icon":"chart-scatter.gif","desc":"Display 2 sets of random data in a scatter series. A renderer has been set up on to dynamically change the size and color of the items based upon it's data.","status":"new"},{"url":"charts/StackedBar.html","text":"Stacked Bar Charts","icon":"chart-bar-stacked.gif","desc":"Showing movie taking by genre as a stacked bar chart sample. Filter the stacks by clicking on the legend items.","status":"new"},{"url":"charts/LiveUpdates.html","text":"Live Updated Chart","icon":"live-updated.gif","desc":"Showing a line series with data updating at a regular interval.","status":"new"},{"url":"charts/LiveAnimated.html","text":"Live Animated Chart","icon":"live-animated.gif","desc":"Showing a line series with smooth transitions on data updating at regular intervals.","status":"new"},{"url":"charts/Gauge.html","text":"Gauge Chart","icon":"gauge.gif","desc":"Display three custom gauge charts bound to different data stores with different configuration options and easings.","status":"new"},{"url":"charts/GroupedBar.html","text":"Grouped Bar","icon":"grouped-bar.gif","desc":"Display 3 sets of random data in a grouped bar series.","status":"new"},{"url":"charts/ReloadChart.html","text":"Reload Chart","icon":"reload-chart.gif","desc":"Display a Column Chart Sample that animates when refreshing the data set","status":"new"}],"title":"Charts"},{"items":[{"url":"tabs/tabs.html","text":"Basic Tabs","icon":"tabs.gif","desc":"Basic tab functionality including autoHeight, tabs from markup, Ajax loading and tab events."},{"url":"tabs/tabs-adv.html","text":"Advanced Tabs","icon":"tabs-adv.gif","desc":"Advanced tab features including tab scrolling, adding tabs programmatically and a context menu plugin."},{"url":"tabs/tab-scroller-menu.html","text":"Tab overflow menu","icon":"tabs-adv.gif","desc":"Demonstrates the TabPanel overflow menu extension, which makes management of large numbers of tabs easier","status":"updated"}],"title":"Tabs"},{"items":[{"url":"window/window.html","text":"Window Variations","icon":"window-layout.gif","desc":"A collection of Windows in different configurations, showing headers attached to any side of the window.","status":"new"},{"url":"window/layout.html","text":"Layout Window","icon":"window.gif","desc":"A window containing a basic BorderLayout with nested TabPanel."},{"url":"message-box/msg-box.html","text":"MessageBox","icon":"msg-box.gif","desc":"Different styles include confirm, alert, prompt, progress and wait and also support custom icons."}],"title":"Windows"},{"items":[{"url":"tree/reorder.html","text":"Drag and Drop Reordering","icon":"tree-reorder.gif","desc":"A TreePanel loaded asynchronously via a JSON TreeLoader that shows drag and drop with container scroll."},{"url":"tree/two-trees.html","text":"Multiple trees","icon":"tree-two.gif","desc":"Drag and drop between two different sorted TreePanels."},{"url":"tree/treegrid.html","text":"TreeGrid","icon":"tree-columns.gif","desc":"The TreeGrid component","status":"updated"},{"url":"tree/check-tree.html","text":"Check Tree","icon":"tree-check.gif","desc":"An example showing simple checkbox selection in a tree."},{"url":"tree/xml-tree.html","text":"XML Tree","icon":"tree-xml-loader.gif","desc":"A custom TreeLoader implementation that demonstrates loading a tree from an XML document."}],"title":"Trees"},{"items":[{"url":"layout-browser/layout-browser.html","text":"Layout Browser","icon":"layout-browser.gif","desc":"Comprehensive showcase of the standard layout managers as well as several custom and combination layouts and combination examples."},{"url":"layout/border.html","text":"Border Layout","icon":"border-layout.gif","desc":"A complex BorderLayout implementation that shows nesting multiple components and sub-layouts.","status":"updated"},{"url":"layout/accordion.html","text":"Accordion Layout","icon":"layout-accordion.gif","desc":"A basic accordion layout within a border layout."},{"url":"form/anchoring.html","text":"Anchor Layout (Form)","icon":"layout-form.gif","desc":"A simple example of form fields utilizing an anchor layout in a window for flexible form resizing."},{"url":"layout/anchor.html","text":"Anchor Layout (Panel)","icon":"layout-anchor.gif","desc":"An example of Panels anchored in the browser window."},{"url":"layout/column.html","text":"Column Layout","icon":"layout-column.gif","desc":"An example of Panels managed by a column layout."},{"url":"layout/table.html","text":"Table Layout","icon":"layout-table.gif","desc":"An example of Panels managed by a table layout."},{"url":"layout/hbox.html","text":"HBox Layout","icon":"layout-column.gif","desc":"Interactive layout illustrating the capabilities of the HBox Layout."},{"url":"layout/vbox.html","text":"VBox Layout","icon":"layout-vbox.gif","desc":"Interactive layout illustrating the capabilities of the VBox Layout."},{"url":"layout/complex.html","text":"Complex Layout","icon":"complex-layout.gif","desc":"A complex layout example.","status":"updated"}],"title":"Layout Managers"},{"items":[{"url":"draw/Sencha.html","text":"Resizable Sencha Logo","icon":"draw-sencha.gif","desc":"Resolution independent Sencha logo in a resizable component.","status":"new"},{"url":"draw/Logos.html","text":"Browser Logos","icon":"draw-logos.gif","desc":"Resolution independent logos of all the popular browsers.","status":"new"},{"url":"draw/Tiger.html","text":"Tiger","icon":"draw-tiger.gif","desc":"The classic SVG Tiger in a floatable, draggable component. Scalable to any size, fully resolution independent.","status":"new"},{"url":"draw/Rotate Text.html","text":"Rotate Text","icon":"draw-rotate-text.gif","desc":"Create text in a Draw Component which can be rotated easily in any browser.","status":"new"}],"title":"Drawing"},{"items":[{"url":"dd/dnd_grid_to_grid.html","text":"Grid to Grid DnD","icon":"dd-gridtogrid.gif","desc":"Shows how rows can be easily dragged and dropped between two or more grids"},{"url":"dd/dnd_grid_to_formpanel.html","text":"Grid to Form DnD","icon":"dd-gridtoformpanel.gif","desc":"Enables a user to drag a record from a grid and drop it into a form, where it can be edited"},{"url":"dd/field-to-grid-dd.html","text":"Field to Grid DnD","icon":"dd-fieldtogrid.gif","desc":"Demonstrates dragging a value from a field onto a grid cell"},{"url":"dd/dragdropzones.html","text":"Custom Drag and Drop","icon":"dd-zones.gif","desc":"A completely custom Drag and Drop example showing DnD between a DataView and a grid"}],"title":"Drag and Drop"},{"items":[{"url":"menu/menus.html","text":"Basic Toolbar","icon":"toolbar.gif","desc":"Toolbar and menus that contain various components like date pickers, color pickers, sub-menus and more.","status":"updated"},{"url":"toolbar/toolbars.html","text":"Toolbar Button Groups","icon":"toolbar-button-groups.gif","desc":"Group buttons together in the toolbar."},{"url":"toolbar/vertical-toolbars.html","text":"Vertical Toolbars","icon":"toolbar.gif","desc":"Vertical Toolbars on the left and right. Combined vertical and horizontal toolbars.","status":"new"},{"url":"menu/action-grid.html","text":"Ext Grid Actions","icon":"actions-grid.gif","desc":"Bind the same behavior to multiple buttons, toolbar and menu items using the Ext.Action class.","status":"updated"},{"url":"toolbar/reorderable.html","text":"Reorderable Toolbar","icon":"toolbar-reorderable.png","desc":"Items within a toolbar can be reordered using this plugin."},{"url":"toolbar/overflow.html","text":"Overflow Toolbar","icon":"toolbar-reorderable.png","desc":"Items within a toolbar will be placed into an overflow menu if the toolbar is too narrow."},{"url":"statusbar/statusbar-demo.html","text":"Status Bar","icon":"statusbar-demo.gif","desc":"A simple StatusBar that can be dropped into the bottom of any panel to display status text and icons."},{"url":"statusbar/statusbar-advanced.html","text":"Status Bar (Advanced)","icon":"statusbar-adv.gif","desc":"Customizing the StatusBar via a plugin to provide automatic form validation monitoring and error linking."},{"url":"menu/actions.html","text":"Ext Toolbar Actions","icon":"actions.gif","desc":"Bind the same behavior to multiple buttons, toolbar and menu items using the Ext.Action class."}],"title":"Toolbars and Menus"},{"items":[{"url":"form/combos.html","text":"Basic ComboBox","icon":"combo.gif","desc":"Basic combos, combos rendered from markup and customized list layout to provide item tooltips."},{"url":"form/forum-search.html","text":"ComboBox Templates","icon":"combo-custom.gif","desc":"Customized combo with template-based list rendering, remote loading and paging."}],"title":"ComboBox"},{"items":[{"url":"view/data-view.html","text":"DataView","icon":"data-view.gif","desc":"This example shows how to use an Ext.view.View","status":"updated"},{"url":"view/animated-dataview.html","text":"Animated DataView","icon":"animated-dataview.png","desc":"Transition animation plugin applied to a standard DataView"},{"url":"view/multisort/multisort.html","text":"Multi-sort DataView","icon":"multisort-dataview.png","desc":"Example demonstrating the ability to sort a DataView by multiple sorters."},{"url":"view/chooser/chooser.html","text":"Advanced DataView","icon":"advanced-dataview.png","desc":"DataView which allows you to filter and sort images."}],"title":"DataView"},{"items":[{"url":"form/dynamic.html","text":"Dynamic Forms","icon":"form-dynamic.gif","desc":"Various example forms showing collapsible fieldsets, column layout, nested TabPanels and more."},{"url":"form/xml-form.html","text":"Ajax with XML Forms","icon":"form-xml.gif","desc":"Ajax-loaded form fields from remote XML data and remote field validation on submit."},{"url":"form/contact-form.html","text":"Contact Us Form","icon":"form-contact.gif","desc":"An example of a common popup Contact Us form.","status":"new"},{"url":"form/forum-search.html","text":"Custom Search Fields","icon":"form-custom.gif","desc":"A TriggerField search extension combined with an XTemplate for custom results rendering."},{"url":"form/form-grid.html","text":"Binding a Grid to a Form","icon":"form-grid-binding.gif","desc":"A grid embedded within a FormPanel that automatically loads records into the form on row selection.","status":"updated"},{"url":"form/field-types.html","text":"Field Types","icon":"form-field-types.gif","desc":"This example shows off all of the field types available in Ext JS in lots of different configurations.","status":"updated"},{"url":"form/adv-vtypes.html","text":"Advanced Validation","icon":"form-adv-vtypes.gif","desc":"Relational form field validation using custom vtypes."},{"url":"form/check-radio.html","text":"Checkbox/Radio Groups","icon":"form-check-radio.gif","desc":"Examples showing different checkbox and radio group configurations."},{"url":"form/file-upload.html","text":"File Upload Field","icon":"form-file-upload.gif","desc":"A demo of how to give standard file upload fields a bit of Ext style using a custom class.","status":"updated"},{"url":"form/number.html","text":"Number Field","icon":"form-spinner.gif","desc":"An example of the Number field, with and without a spinner.","status":"updated"},{"url":"multiselect/multiselect-demo.html","text":"MultiSelect and ItemSelector","icon":"form-multiselect.gif","desc":"Example controls for selecting a list of items in forms.","status":"updated"},{"url":"form/registration.html","text":"Registration Form","icon":"form-registration.gif","desc":"An account registration form, with custom global error message display.","status":"new"},{"url":"form/checkout.html","text":"Shopping Cart Checkout","icon":"form-checkout.gif","desc":"An example of a common shopping cart checkout form.","status":"new"},{"url":"slider/slider-field.html","text":"Slider Field","icon":"form-slider.png","desc":"Example usage of an Ext.Slider to select a number value in a form."},{"url":"form/vbox-form.html","text":"Forms with vBox layout","icon":"form-vbox.gif","desc":"Example usage of the vBox layout with forms. An added bonus is the FieldReplicator plugin.","status":"new"},{"url":"form/hbox-form.html","text":"Forms with hBox layout","icon":"form-hbox.gif","desc":"Example usage of the hBox layout with a form. Includes automatically adjusting validation messages.","status":"new"},{"url":"form/fieldcontainer.html","text":"Field Containers","icon":"form-fieldcontainer.png","desc":"Example usage of the FieldContainer to place several fields on a single form row.","status":"new"},{"url":"form/absform.html","text":"Form with absolute layout","icon":"form-absolute.gif","desc":"A simple example of form fields utilizing an absolute layout in a window for flexible form resizing.","status":"new"},{"url":"form/custom-form.html","text":"Custom form Field","icon":"form-custom.gif","desc":"A simple example that demonstrate how to create a custom form field.","status":"new"}],"title":"Forms"},{"items":[{"url":"direct/direct.html","text":"Direct","icon":"direct.gif","desc":"An example demonstrating Remoting and Polling the server"},{"url":"direct/direct-form.html","text":"Direct Form","icon":"direct.gif","desc":"Ext.Direct Remoting with a Form"},{"url":"direct/direct-grid.html","text":"Direct Grid","icon":"direct.gif","desc":"Ext.Direct Remoting with a Grid"},{"url":"direct/direct-tree.html","text":"Direct TreeLoader","icon":"direct.gif","desc":"Ext.Direct Remoting with a Tree","status":"new"},{"url":"direct/named-arguments.html","text":"Direct Named Arguments","icon":"direct.gif","desc":"Ext.Direct Named Arguments","status":"new"}],"title":"Direct"},{"items":[{"url":"app/feed-viewer/feed-viewer.html","text":"Feed Viewer","icon":"feeds.gif","desc":"An MVC application version of the Feed Viewer example. This shows best practice for a small app","status":"new"},{"url":"app/nested-loading/nested-loading.html","text":"Nested Loading","icon":"nested-loading.gif","desc":"An MVC example that shows simple navigation and nested loading with the data package","status":"new"}],"title":"MVC"},{"items":[{"url":"history/history.html","text":"History","icon":"history.gif","desc":"A History manager that allows the user to navigate an Ext UI via browser back/forward."},{"url":"window/gmap.html","text":"Google Maps","icon":"gmap-panel.gif","desc":"A Google Maps wrapper class that enables easy display of dynamic maps in Ext panels and windows."},{"url":"simple-widgets/editor.html","text":"Editor","icon":"editor.gif","desc":"An example demonstrating the ease of use of the Ext.editor class to modify DOM elements"},{"url":"slider/slider.html","text":"Slider","icon":"slider.gif","desc":"A slider component that supports vertical mode, snapping, tooltips, customized styles and multiple thumbs.","status":"updated"},{"url":"qtips/qtips.html","text":"QuickTips","icon":"qtips.gif","desc":"Various tooltip and quick tip configuration options including Ajax loading and mouse tracking.","status":"updated"},{"url":"simple-widgets/progress-bar.html","text":"Progress Bar","icon":"progress.gif","desc":"A basic progress bar component shown in various configurations and with custom styles."},{"url":"panel/panel.html","text":"Panels","icon":"panel.gif","desc":"A basic collapsible panel example.","status":"updated"},{"url":"resizer/basic.html","text":"Resizable","icon":"resizable.gif","desc":"Examples of making any element resizable with various configuration options."},{"url":"button/button.html","text":"Buttons","icon":"buttons.gif","desc":"Shows buttons in many of their possible configurations"},{"url":"core/spotlight.html","text":"Spotlight","icon":"spotlight.gif","desc":"A utility for masking everything except a single element on the page to visually highlight it."},{"url":"keynav/keynav.html","text":"Keyboard Navigation","icon":"keyboard.gif","desc":"Shows a custom keyboard navigation using the KeyNav class","status":"new"},{"url":"locale/dutch-form.html","text":"Localization (static)","icon":"locale-dutch.gif","desc":"Demonstrates fully localizing a form by including a custom locale script."},{"url":"locale/multi-lang.html","text":"Localization (dynamic)","icon":"locale-switch.gif","desc":"Dynamically render various Ext components in different locales by selecting from a locale list."},{"url":"state/state.html","text":"Browser State Management","icon":"state-saving.gif","desc":"An example of storing your application's state.","status":"new"},{"url":"platform/templates.html","text":"Basic Templating","icon":"templates.gif","desc":"A basic templating example."},{"url":"panel/bubble-panel/bubble-panel.html","text":"Bubble Panel","icon":"panel-bubble.gif","desc":"This is a custom panel UI to achieve a different look and feel while not changing the default appearance of an Ext.Panel.","status":"updated"}],"title":"Miscellaneous"}],"videos":[{"items":[{"title":"Introducing Ext JS 4","thumb":"http://b.vimeocdn.com/ts/110/118/110118333_200.jpg","id":"17666102","description":"Ext JS 4 is a major advance in JavaScript frameworks providing significantly expanded and refactored functionality in practically every area of the product. It's faster, easier and more stable.\n\nPresented by Ed Spencer.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"What's New in Ext JS 4 (Webinar)","thumb":"http://b.vimeocdn.com/ts/166/239/166239450_200.jpg","id":"25264626","description":"Ext JS 4 raises the bar for cross-browser web apps. New features include plug-in-free charting, fully customizable theming, upgraded components — all packaged in a modern app framework that delivers high-quality, predictable results faster and easier than ever.\n\nJoin us for this one-hour webinar where we'll discuss the new features and benefits of using Ext JS 4. We'll also provide tips and resources for migrating from Ext JS 3 to Ext JS 4.\n\nHosting this webinar from Sencha will be Aditya Bansod, Sr. Director of Product Management, Ed Spencer, Sr. Software Architect, and Brian Moeskau, Sr. Software Architect."},{"title":"Ext JS 3 to 4 Migration, Part 1","thumb":"http://b.vimeocdn.com/ts/149/792/149792412_200.jpg","id":"23027769","description":"In this video tutorial series Brian Moeskau teaches you how to use the Ext compatibility layer to migrate existing Ext 3 applications to Ext 4. The tutorial covers setup, debugging, dealing with common problems, and techniques for properly updating your application code.\n\nPart 1 focuses on the initial setup of the compatibility layer and getting a demo Ext 3 application running under Ext 4 in compatibility mode.\n\nPart 2 builds on the first video, migrating the demo application off of the compatibility layer and getting it fully converted to Ext 4, including using the new class system and dynamic loading.\n\nSee Part 2: http://vimeo.com/23046756\n\nSee the accompanying blog post for more details and to download the Ext JS 3 to 4 Migration Pack: http://www.sencha.com/blog/ext-js-3-to-4-migration"},{"title":"Ext JS 3 to 4 Migration, Part 2","thumb":"http://b.vimeocdn.com/ts/149/936/149936004_200.jpg","id":"23046756","description":"In this video tutorial series Brian Moeskau teaches you how to use the Ext compatibility layer to migrate existing Ext 3 applications to Ext 4. The tutorial covers setup, debugging, dealing with common problems, and techniques for properly updating your application code.\n\nPart 1 focuses on the initial setup of the compatibility layer and getting a demo Ext 3 application running under Ext 4 in compatibility mode.\n\nSee Part 1: http://vimeo.com/23027769\n\nPart 2 builds on the first video, migrating the demo application off of the compatibility layer and getting it fully converted to Ext 4, including using the new class system and dynamic loading.\n\nSee the accompanying blog post for more details and to download the Ext 3 to 4 Migration Pack: http://www.sencha.com/blog/ext-js-3-to-4-migration"}],"title":"Overview"},{"items":[{"title":"The Ext JS 4 Layout System","thumb":"http://b.vimeocdn.com/ts/112/023/112023545_200.jpg","id":"17917111","description":"Ext JS 4 has a fully refactored layout engine with higher efficiency and performance. During this session, you'll learn all the in-depth details with a hands-on coding review of the updated ContainerLayouts and newly introduced ComponentLayouts. \n\nPresented by Jamie Avins.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Charting & Data Visualization in Ext JS 4","thumb":"http://b.vimeocdn.com/ts/110/173/110173068_200.jpg","id":"17673342","description":"The exciting future of full JavaScript-powered charts and data visualizations coming in Ext JS 4.0! No Flash required! \n\nPresented by Jamie Avins.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Ext JS 4 Architecture","thumb":"http://b.vimeocdn.com/ts/110/628/110628273_200.jpg","id":"17733892","description":"Ext JS 4 has a thoroughly revamped architecture that enables faster performance and more developer flexibility. In this session, we will take a tour through the revamped architecture of Ext JS 4.x, taking a high-level look at the updated data package, component hierarchy and core APIs. Afterwards, developers will have an understanding of why Ext JS 4 works the way it does and how best to leverage its underlying APIs.\n\nPresented by Ed Spencer.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"JavaScript: Advanced Scoping & Other Puzzles","thumb":"http://b.vimeocdn.com/ts/115/026/115026061_200.jpg","id":"18312985","description":"In this session, we'll review the fundamentals of JavaScript variable scope and common \"execution context\" (scope) challenges associated with early/late binding of event handlers, specifically within complex Ext JS layouts. We'll also bring several patterns (namespaced references, Function closures, inline references, ref/refOwner, and the \"Poor-man's message bus\") to bear on the bowl of soup we call \"scope.\"\n\nPresented by Doug Hendricks.\n\nCheck out http://sencha.com/​conference for more session videos."},{"title":"Behavior Driven Testing with Jasmine","thumb":"http://b.vimeocdn.com/ts/113/422/113422915_200.jpg","id":"18100173","description":"An intro to Jasmine: BDD for JavaScript. We'll talk about why you want to use a test framework for JavaScript testing, why use Jasmine, and review its features, syntax and infrastructure, including how best to incorporate into a Sencha application. \n\nPresented by Davis Frank.\n\nCheck out http://sencha.com/​conference for more session videos."},{"title":"Debugging Your Ext JS Code","thumb":"http://b.vimeocdn.com/ts/113/275/113275508_200.jpg","id":"18080793","description":"To err is human, to code flawlessly is divine. During this session, you'll learn how to debug your JavaScript, Data, and Ext JS based applications using commonly available tools and advanced insight into the Ext JS component framework and life-cycle.\n\nPresented by Aaron Conran & Jarred Nicholls.\n\nCheck out http://sencha.com/​conference for more session videos."}],"title":"Concepts"},{"items":[{"title":"Advanced Server Integration with Data and Direct","thumb":"http://b.vimeocdn.com/ts/111/724/111724762_200.jpg","id":"17876920","description":"Many Ext JS developers have yet to take advantage of Ext Direct to directly call server methods from the browser. During this session, you'll learn how to leverage Ext.Direct's existing functionality to make accessing your server data easier while eliminating common boiler-plate code. This session will spend more time on introductory material. The session repeat on Tuesday will spend more time on advanced material including developing routers, using ColdFusion as an example. \n\nPresented by Aaron Conran.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Advanced Templates for Ext JS","thumb":"http://b.vimeocdn.com/ts/111/935/111935062_200.jpg","id":"17905336","description":"In this session you'll learn how to go beyond basic templating and harness the power of XTemplate to create complex, data-bound HTML. We'll show you how to use XTemplate in ways you didn't think were possible. Among other topics, we'll look at Javascript member functions, recursive templates, subtemplates, and layouts for lists. \n\nPresented by James Brantly.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Creating Ext JS Extensions and Components","thumb":"http://b.vimeocdn.com/ts/112/046/112046224_200.jpg","id":"17920271","description":"One of the great benefits of developing in Ext JS is its clean extensibility. This lets you create reusable components easily that other developers can simply drop into their own applications with minimal effort. In this session, you'll learn how to create a re-usable component for Ext JS, and I'll describe my own experience creating Ext Scheduler - the scheduling component for Ext JS. \n\nPresented by Mats Bryntse.\n\nCheck out http://sencha.com/conference for more session videos."}],"title":"Components"},{"items":[{"title":"Theming Ext JS 4","thumb":"http://b.vimeocdn.com/ts/121/202/121202378_200.jpg","id":"19159630","description":"Ext JS 4 has a new CSS architecture which uses SASS & Compass. This will enable developers to easily create new themes. During this session you will learn how the Ext JS 4 theme was constructed, how to quickly customize the look and feel of your application and how to optimize your stylesheets for faster downloads."},{"title":"Theming with Sass and Compass","thumb":"http://b.vimeocdn.com/ts/175/125/175125406_200.jpg","id":"26506883","description":"A deep dive into how to use SASS and Compass with Sencha frameworks"},{"title":"SASS - The Next Wave in Styling and Theming","thumb":"http://b.vimeocdn.com/ts/113/301/113301648_200.jpg","id":"18084338","description":"CSS and CSS3 are an amazing toolbox for styling your applications, but they're a challenge to wrangle due to their wordy and encyclopedic nature. SASS is an overlay language for CSS that allows powerful and thorough control of CSS properties with a minimum of typing. In this session, we'll give you a thorough grounder in SASS.\n\nPresented by Chris Eppstein.\n\nCheck out http://sencha.com/​conference for more session videos."}],"title":"Theming"},{"items":[{"title":"Creating Optimal Desktop User Experiences","thumb":"http://b.vimeocdn.com/ts/118/390/118390396_200.jpg","id":"18777458","description":"Great User Experiences savs money in training and support and makes money in strong word-of-mouth marketing as well as customer referrals. However, the techniques and process to make great UX happen are often counter-intuitive and tricky. This session will demystify UX greatness and show you how you can create the optimal desktop user experience. This session will be content-rich with many topics covered."},{"title":"Designing for Accessibility with ARIA","thumb":"http://b.vimeocdn.com/ts/111/451/111451316_200.jpg","id":"17840717","description":"ARIA is an accessibility standard that provides capabilities such as screen-reader access to application functionality. During this session, we'll take a tour of the latest accessibility enhancements to Ext JS and Ext GWT including improved keyboard navigation, ARIA and focus management. We'll also discuss how government standards like Section 508 may apply to your organization. \n\nPresented by Aaron Conran.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"All About HTML5 Offline Storage","thumb":"http://b.vimeocdn.com/ts/111/478/111478226_200.jpg","id":"17844271","description":"HTML5 gives us a number of different techniques for storing information on the client machine: AppCache for storing local copies of assets, localStorage for quick and simple key/value data, WebSQL and IndexDB for full SQL-like queries, and the FileSystem APIs for reading/writing files to a persistent sandbox. We'll spend time discussing all of these solutions and when you would want to use each. \n\nPresented by Eric Bidelman.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Architecting for the Enterprise","thumb":"http://b.vimeocdn.com/ts/114/998/114998224_200.jpg","id":"18309352","description":"Adopting early planning and architectural design strategies is essential to create scalable Enterprise apps that are ready to meet the demands of dynamic workforces, and can scale to meet future business needs. You'll learn how to leverage class-based UI development within evolving Agile/Waterfall development methodologies and how Ext.Direct, Connect, and Ext.data packages can assist with integration. We'll also review best practices for strong, unit-tested foundation classes that will support your 'next' enterprise solution.\n\nPresented by Doug Hendricks.\n\nCheck out http://sencha.com/​conference for more session videos."},{"title":"HTML5: State of the Union","thumb":"http://b.vimeocdn.com/ts/111/160/111160207_200.jpg","id":"17802908","description":"HTML5 has emerged as this year's web technology buzzword, but it's quickly become overloaded and overused. In this session, we'll walk through the various parts of \"HTML5\" separating out the core spec from its satellite specs, as well as the CSS3 family. We'll also take a look at the state of implementations on mobile and desktop browsers.\n\nPresented by Michael Mullany.\n\nCheck out http://sencha.com/conference for more session videos."},{"title":"Sencha Customer Testimonials","thumb":"http://b.vimeocdn.com/ts/105/981/105981266_200.jpg","id":"17131795","description":"Hear how AdMob, Widgetbox, Marketo, and Momentum Design Lab use Sencha frameworks to develop amazing web applications."},{"title":"JavaScript Engines: Under the Hood","thumb":"http://b.vimeocdn.com/ts/118/429/118429198_200.jpg","id":"18783283","description":"A browser's JavaScript engine can seem like a magical black box. During this session, we'll show you how they work from 10,000 feet and give you the tricks to compile all the popular engines out there including JavaScriptCore, V8, and SpiderMonkey). We'll inspect the internals of the engine, and debug+profile your favorite code snippets. Armed with just a little extra knowledge about this black box, you will be ready to take a new look at JavaScript apps."},{"title":"The \"In Action\" Pattern for RIA Development","thumb":"http://b.vimeocdn.com/ts/116/691/116691974_200.jpg","id":"18537381","description":"With RIAs growing in complexity, JavaScript developers today have to make tough choices on how to organize their code and do so in a manner that both allows for growth and ease of management. Often the wrong choices are made, impacting the maintenance cycles of the applications. In this session, we'll discuss exactly how to organize your code from ground up by exploring popular patterns used by today's industry leaders.\n\nPresented by Jay Garcia.\n\nCheck out http://sencha.com/​conference for more session videos."}],"title":"Miscellaneous"}],"classes":[{"extends":null,"icon":"icon-class","private":false,"name":"Array"},{"extends":null,"icon":"icon-class","private":false,"name":"Boolean"},{"extends":null,"icon":"icon-class","private":false,"name":"Date"},{"extends":null,"icon":"icon-class","private":false,"name":"Function"},{"extends":null,"icon":"icon-class","private":false,"name":"Number"},{"extends":null,"icon":"icon-class","private":false,"name":"Object"},{"extends":null,"icon":"icon-class","private":false,"name":"RegExp"},{"extends":null,"icon":"icon-class","private":false,"name":"String"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.Action"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.button.Button"},{"extends":null,"icon":"icon-class","private":true,"name":"Ext.ButtonToggleManager"},{"extends":"Ext.button.Split","icon":"icon-component","private":false,"name":"Ext.button.Cycle"},{"extends":"Ext.button.Button","icon":"icon-component","private":false,"name":"Ext.button.Split"},{"extends":"Ext.AbstractComponent","icon":"icon-component","private":false,"name":"Ext.Component"},{"extends":"Ext.panel.Panel","icon":"icon-component","private":false,"name":"Ext.container.ButtonGroup"},{"extends":"Ext.container.AbstractContainer","icon":"icon-component","private":false,"name":"Ext.container.Container"},{"extends":"Ext.container.Container","icon":"icon-component","private":false,"name":"Ext.container.Viewport"},{"extends":"Ext.dd.DragDrop","icon":"icon-class","private":false,"name":"Ext.dd.DD"},{"extends":"Ext.dd.DD","icon":"icon-class","private":false,"name":"Ext.dd.DDProxy"},{"extends":"Ext.dd.DragDrop","icon":"icon-class","private":false,"name":"Ext.dd.DDTarget"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.dd.DragDrop"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.dd.DragDropManager"},{"extends":null,"icon":"icon-class","private":true,"name":"Ext.dd.DragDropManager.ElementWrapper"},{"extends":"Ext.dd.DDProxy","icon":"icon-class","private":false,"name":"Ext.dd.DragSource"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.dd.DragTracker"},{"extends":"Ext.dd.DragSource","icon":"icon-class","private":false,"name":"Ext.dd.DragZone"},{"extends":"Ext.dd.DDTarget","icon":"icon-class","private":false,"name":"Ext.dd.DropTarget"},{"extends":"Ext.dd.DropTarget","icon":"icon-class","private":false,"name":"Ext.dd.DropZone"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.dd.Registry"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.dd.ScrollManager"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.dd.StatusProxy"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.Editor"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.flash.Component"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.FocusManager"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.form.action.Action"},{"extends":"Ext.form.action.Load","icon":"icon-class","private":false,"name":"Ext.form.action.DirectLoad"},{"extends":"Ext.form.action.Submit","icon":"icon-class","private":false,"name":"Ext.form.action.DirectSubmit"},{"extends":"Ext.form.action.Action","icon":"icon-class","private":false,"name":"Ext.form.action.Load"},{"extends":"Ext.form.action.Submit","icon":"icon-class","private":false,"name":"Ext.form.action.StandardSubmit"},{"extends":"Ext.form.action.Action","icon":"icon-class","private":false,"name":"Ext.form.action.Submit"},{"extends":"Ext.util.Observable","icon":"icon-class","private":false,"name":"Ext.form.Basic"},{"extends":"Ext.form.FieldContainer","icon":"icon-component","private":false,"name":"Ext.form.CheckboxGroup"},{"extends":"Ext.util.MixedCollection","icon":"icon-singleton","private":true,"name":"Ext.form.CheckboxManager"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.form.field.Base"},{"extends":"Ext.form.field.Base","icon":"icon-component","private":false,"name":"Ext.form.field.Checkbox"},{"extends":"Ext.form.field.Picker","icon":"icon-component","private":false,"name":"Ext.form.field.ComboBox"},{"extends":"Ext.form.field.Picker","icon":"icon-component","private":false,"name":"Ext.form.field.Date"},{"extends":"Ext.form.field.Base","icon":"icon-component","private":false,"name":"Ext.form.field.Display"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.form.field.Field"},{"extends":"Ext.form.field.Text","icon":"icon-component","private":false,"name":"Ext.form.field.File"},{"extends":"Ext.form.field.Base","icon":"icon-component","private":false,"name":"Ext.form.field.Hidden"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.form.field.HtmlEditor"},{"extends":"Ext.form.field.Spinner","icon":"icon-component","private":false,"name":"Ext.form.field.Number"},{"extends":"Ext.form.field.Trigger","icon":"icon-component","private":false,"name":"Ext.form.field.Picker"},{"extends":"Ext.form.field.Checkbox","icon":"icon-component","private":false,"name":"Ext.form.field.Radio"},{"extends":"Ext.form.field.Trigger","icon":"icon-component","private":false,"name":"Ext.form.field.Spinner"},{"extends":"Ext.form.field.Base","icon":"icon-component","private":false,"name":"Ext.form.field.Text"},{"extends":"Ext.form.field.Text","icon":"icon-component","private":false,"name":"Ext.form.field.TextArea"},{"extends":"Ext.form.field.Picker","icon":"icon-component","private":false,"name":"Ext.form.field.Time"},{"extends":"Ext.form.field.Text","icon":"icon-component","private":false,"name":"Ext.form.field.Trigger"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.form.field.VTypes"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.form.FieldAncestor"},{"extends":"Ext.container.Container","icon":"icon-component","private":false,"name":"Ext.form.FieldContainer"},{"extends":"Ext.container.Container","icon":"icon-component","private":false,"name":"Ext.form.FieldSet"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.form.Label"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.form.Labelable"},{"extends":"Ext.panel.Panel","icon":"icon-component","private":false,"name":"Ext.form.Panel"},{"extends":"Ext.form.CheckboxGroup","icon":"icon-component","private":false,"name":"Ext.form.RadioGroup"},{"extends":"Ext.util.MixedCollection","icon":"icon-singleton","private":true,"name":"Ext.form.RadioManager"},{"extends":"Ext.Editor","icon":"icon-component","private":true,"name":"Ext.grid.CellEditor"},{"extends":"Ext.grid.column.Column","icon":"icon-component","private":false,"name":"Ext.grid.column.Action"},{"extends":"Ext.grid.column.Column","icon":"icon-component","private":false,"name":"Ext.grid.column.Boolean"},{"extends":"Ext.grid.header.Container","icon":"icon-component","private":false,"name":"Ext.grid.column.Column"},{"extends":"Ext.grid.column.Column","icon":"icon-component","private":false,"name":"Ext.grid.column.Date"},{"extends":"Ext.grid.column.Column","icon":"icon-component","private":false,"name":"Ext.grid.column.Number"},{"extends":"Ext.grid.column.Column","icon":"icon-component","private":false,"name":"Ext.grid.column.Template"},{"extends":"Ext.layout.container.HBox","icon":"icon-class","private":true,"name":"Ext.grid.ColumnLayout"},{"extends":"Ext.grid.feature.Feature","icon":"icon-class","private":false,"name":"Ext.grid.feature.AbstractSummary"},{"extends":"Ext.grid.feature.Feature","icon":"icon-class","private":false,"name":"Ext.grid.feature.Chunking"},{"extends":"Ext.util.Observable","icon":"icon-class","private":false,"name":"Ext.grid.feature.Feature"},{"extends":"Ext.grid.feature.Feature","icon":"icon-class","private":false,"name":"Ext.grid.feature.Grouping"},{"extends":"Ext.grid.feature.Grouping","icon":"icon-class","private":false,"name":"Ext.grid.feature.GroupingSummary"},{"extends":"Ext.grid.feature.Feature","icon":"icon-class","private":false,"name":"Ext.grid.feature.RowBody"},{"extends":"Ext.grid.feature.Feature","icon":"icon-class","private":true,"name":"Ext.grid.feature.RowWrap"},{"extends":"Ext.grid.feature.AbstractSummary","icon":"icon-class","private":false,"name":"Ext.grid.feature.Summary"},{"extends":"Ext.container.Container","icon":"icon-component","private":false,"name":"Ext.grid.header.Container"},{"extends":"Ext.dd.DragZone","icon":"icon-class","private":true,"name":"Ext.grid.header.DragZone"},{"extends":"Ext.dd.DropZone","icon":"icon-class","private":true,"name":"Ext.grid.header.DropZone"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.grid.Lockable"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.grid.LockingView"},{"extends":"Ext.grid.Scroller","icon":"icon-component","private":false,"name":"Ext.grid.PagingScroller"},{"extends":"Ext.panel.Table","icon":"icon-component","private":false,"name":"Ext.grid.Panel"},{"extends":"Ext.grid.plugin.Editing","icon":"icon-class","private":false,"name":"Ext.grid.plugin.CellEditing"},{"extends":"Ext.AbstractPlugin","icon":"icon-class","private":false,"name":"Ext.grid.plugin.DragDrop"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.grid.plugin.Editing"},{"extends":"Ext.util.Observable","icon":"icon-class","private":true,"name":"Ext.grid.plugin.HeaderReorderer"},{"extends":"Ext.util.Observable","icon":"icon-class","private":false,"name":"Ext.grid.plugin.HeaderResizer"},{"extends":"Ext.grid.plugin.Editing","icon":"icon-class","private":false,"name":"Ext.grid.plugin.RowEditing"},{"extends":"Ext.grid.Panel","icon":"icon-component","private":false,"name":"Ext.grid.property.Grid"},{"extends":"Ext.grid.header.Container","icon":"icon-component","private":false,"name":"Ext.grid.property.HeaderContainer"},{"extends":"Ext.data.Model","icon":"icon-class","private":false,"name":"Ext.grid.property.Property"},{"extends":"Ext.data.Store","icon":"icon-class","private":false,"name":"Ext.grid.property.Store"},{"extends":"Ext.form.Panel","icon":"icon-component","private":true,"name":"Ext.grid.RowEditor"},{"extends":"Ext.grid.column.Column","icon":"icon-component","private":false,"name":"Ext.grid.RowNumberer"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.grid.Scroller"},{"extends":"Ext.view.Table","icon":"icon-component","private":false,"name":"Ext.grid.View"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.Img"},{"extends":"Ext.Element","icon":"icon-class","private":false,"name":"Ext.Layer"},{"extends":"Ext.layout.component.Component","icon":"icon-class","private":true,"name":"Ext.layout.component.Body"},{"extends":"Ext.layout.component.Component","icon":"icon-class","private":true,"name":"Ext.layout.component.BoundList"},{"extends":"Ext.layout.component.Component","icon":"icon-class","private":true,"name":"Ext.layout.component.Button"},{"extends":"Ext.layout.component.AbstractDock","icon":"icon-class","private":true,"name":"Ext.layout.component.Dock"},{"extends":"Ext.layout.component.Component","icon":"icon-class","private":true,"name":"Ext.layout.component.Editor"},{"extends":"Ext.layout.component.Component","icon":"icon-class","private":true,"name":"Ext.layout.component.field.Field"},{"extends":"Ext.layout.component.field.Field","icon":"icon-class","private":true,"name":"Ext.layout.component.field.File"},{"extends":"Ext.layout.component.field.Field","icon":"icon-class","private":true,"name":"Ext.layout.component.field.HtmlEditor"},{"extends":"Ext.layout.component.field.Field","icon":"icon-class","private":true,"name":"Ext.layout.component.field.Slider"},{"extends":"Ext.layout.component.field.Field","icon":"icon-class","private":true,"name":"Ext.layout.component.field.Text"},{"extends":"Ext.layout.component.field.Field","icon":"icon-class","private":true,"name":"Ext.layout.component.field.TextArea"},{"extends":"Ext.layout.component.field.Field","icon":"icon-class","private":true,"name":"Ext.layout.component.field.Trigger"},{"extends":"Ext.layout.component.Body","icon":"icon-class","private":true,"name":"Ext.layout.component.FieldSet"},{"extends":"Ext.layout.component.Component","icon":"icon-class","private":true,"name":"Ext.layout.component.ProgressBar"},{"extends":"Ext.layout.component.Button","icon":"icon-class","private":true,"name":"Ext.layout.component.Tab"},{"extends":"Ext.layout.component.Dock","icon":"icon-class","private":true,"name":"Ext.layout.component.Tip"},{"extends":"Ext.layout.container.Anchor","icon":"icon-class","private":false,"name":"Ext.layout.container.Absolute"},{"extends":"Ext.layout.container.VBox","icon":"icon-class","private":false,"name":"Ext.layout.container.Accordion"},{"extends":"Ext.layout.container.Container","icon":"icon-class","private":false,"name":"Ext.layout.container.Anchor"},{"extends":"Ext.layout.container.Container","icon":"icon-class","private":false,"name":"Ext.layout.container.Border"},{"extends":"Ext.layout.container.Container","icon":"icon-class","private":false,"name":"Ext.layout.container.Box"},{"extends":"Ext.layout.container.boxOverflow.None","icon":"icon-class","private":true,"name":"Ext.layout.container.boxOverflow.Menu"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.layout.container.boxOverflow.None"},{"extends":"Ext.layout.container.boxOverflow.None","icon":"icon-class","private":true,"name":"Ext.layout.container.boxOverflow.Scroller"},{"extends":"Ext.layout.container.AbstractCard","icon":"icon-class","private":false,"name":"Ext.layout.container.Card"},{"extends":"Ext.layout.container.Container","icon":"icon-class","private":false,"name":"Ext.layout.container.CheckboxGroup"},{"extends":"Ext.layout.container.Auto","icon":"icon-class","private":false,"name":"Ext.layout.container.Column"},{"extends":"Ext.layout.container.AbstractContainer","icon":"icon-class","private":false,"name":"Ext.layout.container.Container"},{"extends":"Ext.layout.container.AbstractFit","icon":"icon-class","private":false,"name":"Ext.layout.container.Fit"},{"extends":"Ext.layout.container.Box","icon":"icon-class","private":false,"name":"Ext.layout.container.HBox"},{"extends":"Ext.layout.container.Auto","icon":"icon-class","private":false,"name":"Ext.layout.container.Table"},{"extends":"Ext.layout.container.Box","icon":"icon-class","private":false,"name":"Ext.layout.container.VBox"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.LoadMask"},{"extends":"Ext.menu.Item","icon":"icon-component","private":false,"name":"Ext.menu.CheckItem"},{"extends":"Ext.menu.Menu","icon":"icon-component","private":false,"name":"Ext.menu.ColorPicker"},{"extends":"Ext.menu.Menu","icon":"icon-component","private":false,"name":"Ext.menu.DatePicker"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.menu.Item"},{"extends":"Ext.util.KeyNav","icon":"icon-class","private":true,"name":"Ext.menu.KeyNav"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.menu.Manager"},{"extends":"Ext.panel.Panel","icon":"icon-component","private":false,"name":"Ext.menu.Menu"},{"extends":"Ext.menu.Item","icon":"icon-component","private":false,"name":"Ext.menu.Separator"},{"extends":"Ext.container.Container","icon":"icon-component","private":false,"name":"Ext.panel.Header"},{"extends":"Ext.panel.AbstractPanel","icon":"icon-component","private":false,"name":"Ext.panel.Panel"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.panel.Proxy"},{"extends":"Ext.panel.Panel","icon":"icon-component","private":false,"name":"Ext.panel.Table"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.panel.Tool"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.picker.Color"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.picker.Date"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.picker.Month"},{"extends":"Ext.view.BoundList","icon":"icon-component","private":false,"name":"Ext.picker.Time"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.ProgressBar"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.resizer.Handle"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.resizer.Resizer"},{"extends":"Ext.dd.DragTracker","icon":"icon-class","private":true,"name":"Ext.resizer.ResizeTracker"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.resizer.Splitter"},{"extends":"Ext.dd.DragTracker","icon":"icon-class","private":true,"name":"Ext.resizer.SplitterTracker"},{"extends":"Ext.selection.Model","icon":"icon-class","private":false,"name":"Ext.selection.CellModel"},{"extends":"Ext.selection.RowModel","icon":"icon-class","private":false,"name":"Ext.selection.CheckboxModel"},{"extends":"Ext.selection.Model","icon":"icon-class","private":false,"name":"Ext.selection.RowModel"},{"extends":"Ext.selection.RowModel","icon":"icon-class","private":true,"name":"Ext.selection.TreeModel"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.Shadow"},{"extends":"Ext.Base","icon":"icon-singleton","private":true,"name":"Ext.ShadowPool"},{"extends":"Ext.form.field.Base","icon":"icon-component","private":false,"name":"Ext.slider.Multi"},{"extends":"Ext.slider.Multi","icon":"icon-component","private":false,"name":"Ext.slider.Single"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.slider.Thumb"},{"extends":"Ext.tip.Tip","icon":"icon-component","private":false,"name":"Ext.slider.Tip"},{"extends":"Ext.panel.Header","icon":"icon-component","private":false,"name":"Ext.tab.Bar"},{"extends":"Ext.panel.Panel","icon":"icon-component","private":false,"name":"Ext.tab.Panel"},{"extends":"Ext.button.Button","icon":"icon-component","private":false,"name":"Ext.tab.Tab"},{"extends":"Ext.tip.ToolTip","icon":"icon-component","private":false,"name":"Ext.tip.QuickTip"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.tip.QuickTipManager"},{"extends":"Ext.panel.Panel","icon":"icon-component","private":false,"name":"Ext.tip.Tip"},{"extends":"Ext.tip.Tip","icon":"icon-component","private":false,"name":"Ext.tip.ToolTip"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.toolbar.Fill"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.toolbar.Item"},{"extends":"Ext.toolbar.Toolbar","icon":"icon-component","private":false,"name":"Ext.toolbar.Paging"},{"extends":"Ext.toolbar.Item","icon":"icon-component","private":false,"name":"Ext.toolbar.Separator"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.toolbar.Spacer"},{"extends":"Ext.toolbar.Item","icon":"icon-component","private":false,"name":"Ext.toolbar.TextItem"},{"extends":"Ext.container.Container","icon":"icon-component","private":false,"name":"Ext.toolbar.Toolbar"},{"extends":"Ext.grid.column.Column","icon":"icon-component","private":true,"name":"Ext.tree.Column"},{"extends":"Ext.panel.Table","icon":"icon-component","private":false,"name":"Ext.tree.Panel"},{"extends":"Ext.AbstractPlugin","icon":"icon-class","private":false,"name":"Ext.tree.plugin.TreeViewDragDrop"},{"extends":"Ext.view.Table","icon":"icon-component","private":false,"name":"Ext.tree.View"},{"extends":"Ext.view.DropZone","icon":"icon-class","private":true,"name":"Ext.tree.ViewDropZone"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.Animate"},{"extends":"Ext.util.Observable","icon":"icon-class","private":false,"name":"Ext.util.ClickRepeater"},{"extends":"Ext.dd.DragTracker","icon":"icon-class","private":false,"name":"Ext.util.ComponentDragger"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.util.Cookies"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.util.CSS"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.Floating"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.util.History"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.KeyMap"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.KeyNav"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.TextMetrics"},{"extends":"Ext.view.View","icon":"icon-component","private":false,"name":"Ext.view.BoundList"},{"extends":"Ext.util.KeyNav","icon":"icon-class","private":false,"name":"Ext.view.BoundListKeyNav"},{"extends":"Ext.dd.DragZone","icon":"icon-class","private":true,"name":"Ext.view.DragZone"},{"extends":"Ext.dd.DropZone","icon":"icon-class","private":true,"name":"Ext.view.DropZone"},{"extends":"Ext.view.View","icon":"icon-component","private":false,"name":"Ext.view.Table"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.view.TableChunker"},{"extends":"Ext.view.AbstractView","icon":"icon-component","private":false,"name":"Ext.view.View"},{"extends":"Ext.window.Window","icon":"icon-component","private":false,"name":"Ext.window.MessageBox"},{"extends":"Ext.window.MessageBox","icon":"icon-singleton","private":false,"name":"Ext.MessageBox"},{"extends":"Ext.panel.Panel","icon":"icon-component","private":false,"name":"Ext.window.Window"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.ZIndexManager"},{"extends":"Ext.ZIndexManager","icon":"icon-singleton","private":false,"name":"Ext.WindowManager"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.AbstractComponent"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.AbstractManager"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.AbstractPlugin"},{"extends":"Ext.data.Connection","icon":"icon-singleton","private":false,"name":"Ext.Ajax"},{"extends":"Ext.app.Controller","icon":"icon-class","private":false,"name":"Ext.app.Application"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.app.Controller"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.app.EventBus"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.chart.axis.Abstract"},{"extends":"Ext.chart.axis.Abstract","icon":"icon-class","private":false,"name":"Ext.chart.axis.Axis"},{"extends":"Ext.chart.axis.Axis","icon":"icon-class","private":false,"name":"Ext.chart.axis.Category"},{"extends":"Ext.chart.axis.Abstract","icon":"icon-class","private":false,"name":"Ext.chart.axis.Gauge"},{"extends":"Ext.chart.axis.Axis","icon":"icon-class","private":false,"name":"Ext.chart.axis.Numeric"},{"extends":"Ext.chart.axis.Abstract","icon":"icon-class","private":true,"name":"Ext.chart.axis.Radial"},{"extends":"Ext.chart.axis.Numeric","icon":"icon-class","private":false,"name":"Ext.chart.axis.Time"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.chart.Callout"},{"extends":"Ext.draw.Component","icon":"icon-component","private":false,"name":"Ext.chart.Chart"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.chart.Highlight"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.chart.Label"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.chart.Legend"},{"extends":"Ext.draw.CompositeSprite","icon":"icon-class","private":false,"name":"Ext.chart.LegendItem"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.chart.Mask"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.chart.Navigation"},{"extends":"Ext.chart.series.Cartesian","icon":"icon-class","private":false,"name":"Ext.chart.series.Area"},{"extends":"Ext.chart.series.Cartesian","icon":"icon-class","private":false,"name":"Ext.chart.series.Bar"},{"extends":"Ext.chart.series.Series","icon":"icon-class","private":false,"name":"Ext.chart.series.Cartesian"},{"extends":"Ext.chart.series.Bar","icon":"icon-class","private":false,"name":"Ext.chart.series.Column"},{"extends":"Ext.chart.series.Series","icon":"icon-class","private":false,"name":"Ext.chart.series.Gauge"},{"extends":"Ext.chart.series.Cartesian","icon":"icon-class","private":false,"name":"Ext.chart.series.Line"},{"extends":"Ext.chart.series.Series","icon":"icon-class","private":false,"name":"Ext.chart.series.Pie"},{"extends":"Ext.chart.series.Series","icon":"icon-class","private":false,"name":"Ext.chart.series.Radar"},{"extends":"Ext.chart.series.Cartesian","icon":"icon-class","private":false,"name":"Ext.chart.series.Scatter"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.chart.series.Series"},{"extends":"Ext.Base","icon":"icon-singleton","private":true,"name":"Ext.chart.Shape"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.chart.theme.Base"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.chart.theme.Theme"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.chart.Tip"},{"extends":"Ext.draw.Component","icon":"icon-component","private":true,"name":"Ext.chart.TipSurface"},{"extends":"Ext.ElementLoader","icon":"icon-class","private":false,"name":"Ext.ComponentLoader"},{"extends":"Ext.AbstractManager","icon":"icon-singleton","private":false,"name":"Ext.ComponentManager"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.ComponentQuery"},{"extends":"Ext.Component","icon":"icon-component","private":true,"name":"Ext.container.AbstractContainer"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.AbstractStore"},{"extends":"Ext.data.Store","icon":"icon-class","private":false,"name":"Ext.data.ArrayStore"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.Association"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.Batch"},{"extends":"Ext.data.Association","icon":"icon-class","private":false,"name":"Ext.data.BelongsToAssociation"},{"extends":"Ext.data.Store","icon":"icon-class","private":true,"name":"Ext.data.BufferStore"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.Connection"},{"extends":"Ext.data.Store","icon":"icon-class","private":false,"name":"Ext.data.DirectStore"},{"extends":"Ext.util.MixedCollection","icon":"icon-class","private":false,"name":"Ext.data.Errors"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.Field"},{"extends":"Ext.data.Association","icon":"icon-class","private":false,"name":"Ext.data.HasManyAssociation"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.IdGenerator"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.data.JsonP"},{"extends":"Ext.data.Store","icon":"icon-class","private":true,"name":"Ext.data.JsonPStore"},{"extends":"Ext.data.Store","icon":"icon-class","private":true,"name":"Ext.data.JsonStore"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.Model"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.NodeInterface"},{"extends":"Ext.data.AbstractStore","icon":"icon-class","private":true,"name":"Ext.data.NodeStore"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.Operation"},{"extends":"Ext.data.proxy.Server","icon":"icon-class","private":false,"name":"Ext.data.proxy.Ajax"},{"extends":"Ext.data.proxy.Proxy","icon":"icon-class","private":true,"name":"Ext.data.proxy.Client"},{"extends":"Ext.data.proxy.Server","icon":"icon-class","private":false,"name":"Ext.data.proxy.Direct"},{"extends":"Ext.data.proxy.Server","icon":"icon-class","private":false,"name":"Ext.data.proxy.JsonP"},{"extends":"Ext.data.proxy.WebStorage","icon":"icon-class","private":false,"name":"Ext.data.proxy.LocalStorage"},{"extends":"Ext.data.proxy.Client","icon":"icon-class","private":false,"name":"Ext.data.proxy.Memory"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.proxy.Proxy"},{"extends":"Ext.data.proxy.Ajax","icon":"icon-class","private":false,"name":"Ext.data.proxy.Rest"},{"extends":"Ext.data.proxy.Proxy","icon":"icon-class","private":true,"name":"Ext.data.proxy.Server"},{"extends":"Ext.data.proxy.WebStorage","icon":"icon-class","private":false,"name":"Ext.data.proxy.SessionStorage"},{"extends":"Ext.data.proxy.Client","icon":"icon-class","private":true,"name":"Ext.data.proxy.WebStorage"},{"extends":"Ext.data.reader.Json","icon":"icon-class","private":false,"name":"Ext.data.reader.Array"},{"extends":"Ext.data.reader.Reader","icon":"icon-class","private":false,"name":"Ext.data.reader.Json"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.reader.Reader"},{"extends":"Ext.data.reader.Reader","icon":"icon-class","private":false,"name":"Ext.data.reader.Xml"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.Request"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.ResultSet"},{"extends":"Ext.data.IdGenerator","icon":"icon-class","private":false,"name":"Ext.data.SequentialIdGenerator"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.data.SortTypes"},{"extends":"Ext.data.AbstractStore","icon":"icon-class","private":false,"name":"Ext.data.Store"},{"extends":"Ext.util.MixedCollection","icon":"icon-singleton","private":false,"name":"Ext.data.StoreManager"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.Tree"},{"extends":"Ext.data.AbstractStore","icon":"icon-class","private":false,"name":"Ext.data.TreeStore"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.data.Types"},{"extends":"Ext.data.IdGenerator","icon":"icon-class","private":false,"name":"Ext.data.UuidGenerator"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.data.validations"},{"extends":"Ext.data.writer.Writer","icon":"icon-class","private":false,"name":"Ext.data.writer.Json"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.data.writer.Writer"},{"extends":"Ext.data.writer.Writer","icon":"icon-class","private":false,"name":"Ext.data.writer.Xml"},{"extends":"Ext.data.Store","icon":"icon-class","private":true,"name":"Ext.data.XmlStore"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.direct.Event"},{"extends":"Ext.direct.RemotingEvent","icon":"icon-class","private":false,"name":"Ext.direct.ExceptionEvent"},{"extends":"Ext.direct.Provider","icon":"icon-class","private":false,"name":"Ext.direct.JsonProvider"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.direct.Manager"},{"extends":"Ext.direct.JsonProvider","icon":"icon-class","private":false,"name":"Ext.direct.PollingProvider"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.direct.Provider"},{"extends":"Ext.direct.Event","icon":"icon-class","private":false,"name":"Ext.direct.RemotingEvent"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.direct.RemotingMethod"},{"extends":"Ext.direct.JsonProvider","icon":"icon-class","private":false,"name":"Ext.direct.RemotingProvider"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.direct.Transaction"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.draw.Color"},{"extends":"Ext.Component","icon":"icon-component","private":false,"name":"Ext.draw.Component"},{"extends":"Ext.util.MixedCollection","icon":"icon-class","private":false,"name":"Ext.draw.CompositeSprite"},{"extends":"Ext.Base","icon":"icon-singleton","private":true,"name":"Ext.draw.Draw"},{"extends":"Ext.draw.Surface","icon":"icon-class","private":false,"name":"Ext.draw.engine.Svg"},{"extends":"Ext.draw.Surface","icon":"icon-class","private":false,"name":"Ext.draw.engine.Vml"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.draw.Sprite"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.draw.Surface"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.ElementLoader"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.fx.Anim"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.fx.Animator"},{"extends":"Ext.Base","icon":"icon-singleton","private":true,"name":"Ext.fx.CubicBezier"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.fx.Easing"},{"extends":"Ext.Base","icon":"icon-singleton","private":true,"name":"Ext.fx.Manager"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.fx.PropertyHandler"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.fx.Queue"},{"extends":"Ext.fx.target.Target","icon":"icon-class","private":false,"name":"Ext.fx.target.Component"},{"extends":"Ext.fx.target.Element","icon":"icon-class","private":false,"name":"Ext.fx.target.CompositeElement"},{"extends":"Ext.fx.target.CompositeElement","icon":"icon-class","private":false,"name":"Ext.fx.target.CompositeElementCSS"},{"extends":"Ext.fx.target.Sprite","icon":"icon-class","private":false,"name":"Ext.fx.target.CompositeSprite"},{"extends":"Ext.fx.target.Target","icon":"icon-class","private":false,"name":"Ext.fx.target.Element"},{"extends":"Ext.fx.target.Element","icon":"icon-class","private":false,"name":"Ext.fx.target.ElementCSS"},{"extends":"Ext.fx.target.Target","icon":"icon-class","private":false,"name":"Ext.fx.target.Sprite"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.fx.target.Target"},{"extends":"Ext.layout.component.Component","icon":"icon-class","private":true,"name":"Ext.layout.component.AbstractDock"},{"extends":"Ext.layout.component.Component","icon":"icon-class","private":true,"name":"Ext.layout.component.Auto"},{"extends":"Ext.layout.Layout","icon":"icon-class","private":true,"name":"Ext.layout.component.Component"},{"extends":"Ext.layout.component.Component","icon":"icon-class","private":true,"name":"Ext.layout.component.Draw"},{"extends":"Ext.layout.container.Fit","icon":"icon-class","private":true,"name":"Ext.layout.container.AbstractCard"},{"extends":"Ext.layout.Layout","icon":"icon-class","private":true,"name":"Ext.layout.container.AbstractContainer"},{"extends":"Ext.layout.container.Container","icon":"icon-class","private":true,"name":"Ext.layout.container.AbstractFit"},{"extends":"Ext.layout.container.Container","icon":"icon-class","private":false,"name":"Ext.layout.container.Auto"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.layout.Layout"},{"extends":"Ext.AbstractManager","icon":"icon-singleton","private":false,"name":"Ext.ModelManager"},{"extends":"Ext.container.Container","icon":"icon-component","private":true,"name":"Ext.panel.AbstractPanel"},{"extends":"Ext.AbstractManager","icon":"icon-singleton","private":false,"name":"Ext.PluginManager"},{"extends":"Ext.selection.Model","icon":"icon-class","private":true,"name":"Ext.selection.DataViewModel"},{"extends":"Ext.util.Observable","icon":"icon-class","private":false,"name":"Ext.selection.Model"},{"extends":"Ext.state.Provider","icon":"icon-class","private":false,"name":"Ext.state.CookieProvider"},{"extends":"Ext.state.Provider","icon":"icon-class","private":false,"name":"Ext.state.LocalStorageProvider"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.state.Manager"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.state.Provider"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.state.Stateful"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.Template"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.util.AbstractMixedCollection"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.Filter"},{"extends":"Ext.util.Sorter","icon":"icon-class","private":false,"name":"Ext.util.Grouper"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.HashMap"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.util.Inflector"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.Memento"},{"extends":"Ext.util.AbstractMixedCollection","icon":"icon-class","private":false,"name":"Ext.util.MixedCollection"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.Observable"},{"extends":"Ext.Base","icon":"icon-class","private":true,"name":"Ext.util.Offset"},{"extends":"Ext.util.Region","icon":"icon-class","private":false,"name":"Ext.util.Point"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.Region"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.Sortable"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.util.Sorter"},{"extends":"Ext.Component","icon":"icon-component","private":true,"name":"Ext.view.AbstractView"},{"extends":"Ext.Template","icon":"icon-class","private":false,"name":"Ext.XTemplate"},{"extends":null,"icon":"icon-class","private":false,"name":"Ext.Base"},{"extends":null,"icon":"icon-class","private":false,"name":"Ext.Class"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.ClassManager"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.Loader"},{"extends":"Ext.CompositeElementLite","icon":"icon-class","private":false,"name":"Ext.CompositeElement"},{"extends":null,"icon":"icon-class","private":false,"name":"Ext.CompositeElementLite"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.DomHelper"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.DomQuery"},{"extends":null,"icon":"icon-class","private":false,"name":"Ext.Element"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.env.Browser"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.env.FeatureDetector"},{"extends":"Ext.Base","icon":"icon-class","private":false,"name":"Ext.env.OS"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.EventManager"},{"extends":"Ext.Base","icon":"icon-singleton","private":false,"name":"Ext.EventObject"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.Array"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.Date"},{"extends":"Error","icon":"icon-class","private":false,"name":"Ext.Error"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.Function"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.Number"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.Object"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.String"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.JSON"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.is"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.supports"},{"extends":null,"icon":"icon-class","private":false,"name":"Ext.util.DelayedTask"},{"extends":null,"icon":"icon-singleton","private":false,"name":"Ext.util.Format"},{"extends":null,"icon":"icon-class","private":false,"name":"Ext.util.TaskRunner"},{"extends":"Ext.util.TaskRunner","icon":"icon-singleton","private":false,"name":"Ext.TaskManager"},{"extends":null,"icon":"icon-class","private":false,"name":"Ext.Version"}]};
