Ext.data.JsonP.grid({
  "guide": "<h1>Grid</h1>\n\n<hr />\n\n<p>The grid is one of the centerpieces of <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS. It’s an incredibly versatile component that provides a great way to view lots of data at once, formatted exactly how you need it. With Ext JS 4 we have overhauled the grid, making it faster, lighter and easier to customize.</p>\n\n<h2>Grid Components</h2>\n\n<p>Original article: <a href=\"http://www.sencha.com/blog/ext-js-4-grid-components/\">Grid Components</a></p>\n\n<h3>Intelligent Rendering</h3>\n\n<p>The <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 3 grid works fantastically well, but it takes the \"least common denominator\" approach to its rich feature support by always generating the full markup needed by every grid feature (which is overly-heavy in most cases). In Ext JS 4, the default grid has very lightweight markup, and additional feature-specific markup is only rendered as developers enable different features. This is a huge boost both for page rendering speed and overall grid performance.</p>\n\n<h3>Standardized Layout</h3>\n\n<p>Along with a smarter rendering pipeline, many parts of the new grid have been made into proper Components and integrated into the standard layout management system rather than relying on custom internal markup and CSS. This enables us to unify the grid's rendering process with the rest of the framework, while still retaining a pixel-perfect UI experience.</p>\n\n<h3>DataView</h3>\n\n<p>The new GridView in <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 4 extends the standard DataView class. This not only minimizes duplicated code internally, it also makes the new grid even easier to customize. Because it extends DataView, the new grid is also able to leverage the same selection models as any view, including non-contiguous selection via keyboard navigation.</p>\n\n<h3>Feature Support</h3>\n\n<p>In <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 3, it was easy to add new functionality to grids, but there was no single strategy for doing it. Many added features were provided as plugins, but some were provided via subclassing. This made it very difficult (if not impossible) to combine certain features easily.</p>\n\n<p>Ext JS 4 includes a new grid base class called Ext.grid.Feature which provides the basis for creating extremely flexible optional grid features. The underlying grid templates can be modified by any Feature classes in order to decorate or mutate the markup that the grid's view generates. Features provide a powerful alternative to subclassing the old GridView because it makes it easy to mix and match compatible features. Some examples of Features in the new grid are RowWrap, RowBody and Grouping.</p>\n\n<h3>Virtual Scrolling</h3>\n\n<p>The <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> 4 grid now natively supports buffering its data during rendering, providing a virtual, load-on-demand view of its data. Grids will now easily support hundreds or even thousands of records without paging, which will be a massive improvement over the <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 3 grid's data handling capacity.</p>\n\n<h3>Editing Improvements</h3>\n\n<p>In <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 3, developers had to use the specialized EditorGrid class to provide an editable grid, which limited its flexibility. In Ext JS 4, there is now an Editing plugin that can be applied to any grid instance, making it completely reusable across all grids. In addition, the popular RowEditor extension from <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 3 has been promoted to a first-class and fully-supported framework component in <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 4.</p>\n\n<h3>An Example</h3>\n\n<p><img src=\"guides/grid/image04.png\" alt=\"Example grid\" /></p>\n\n<p>Here's the setup of a basic grid with grouping in <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 4. It's impossible to cover all of the new functionality in only one example, but this should give you a good taste of the new grid in action. As you can see, the configuration is very similar to that in <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 3, but the grouping functionality is now a simple feature config, rather than an entire custom GroupingView instance as required in <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 3. This is but one example of the new flexibility in <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 4. Also, grouping is now supported directly in the standard Store, so a separate GroupingStore is not needed either.</p>\n\n<pre><code>Ext.onReady(function() {\n    Ext.define('Teams', {\n        extend: 'Ext.data.Model',\n        fields: ['name', 'sport']\n    });\n\n    var teamStore = new Ext.data.Store({\n        model: 'Teams',\n        sorters: ['sport','name'],\n        groupField: 'sport',\n        data: [\n            { name: 'Aaron', sport: 'Table Tennis' },\n            { name: 'Aaron', sport: 'Football' },\n            { name: 'Abe', sport: 'Basketball' },\n            { name: 'Tommy', sport: 'Football' },\n            { name: 'Tommy', sport: 'Basketball' },\n            { name: 'Jamie', sport: 'Table Tennis' },\n            { name: 'Brian', sport: 'Basketball' },\n            { name: 'Brian', sport: 'Table Tennis' }\n        ]\n    });\n\n    var grid = new Ext.grid.Panel({\n        renderTo: Ext.getBody(),\n        store: teamStore,\n        width: 400,\n        height: 300,\n        title: 'Sports Teams',\n        features: [{\n            ftype: 'grouping'\n        }],\n        columns: [{\n            text: 'Name',\n            flex: 1,\n            dataIndex: 'name'\n        },{\n            text: 'Sport',\n            dataIndex: 'sport'\n        }]\n    });\n});\n</code></pre>\n"
});