Ext.data.JsonP.components({
  "guide": "<h1>Components</h1>\n\n<hr />\n\n<p>All components in <a href=\"#/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a> JS 4 are rendered with a base div element which provides a unique id, and baseline component classes (cls, cmpCls, baseCls, and ui). If additional elements are needed to create a component, they are now handled with an XTemplate (renderTpl). Data for the XTemplate is read from a renderData object and Ext.Element references can be placed on the component instance via renderSelectors. The renderSelector is scoped from the base div element and uses standard css selectors. These Ext.Element references are part of the component lifecycle and removed automatically when the component is destroyed. The following example will help illustrate the creation of a custom component:</p>\n\n<p>Simple custom icon component example:</p>\n\n<pre><code>IconComponent = Ext.extend(Ext.Component, {\n   iconCls: 'myIcon',\n   renderTpl: '&lt;img alt=\"\" src=\"{blank}\" class=\"{iconCls}\"/&gt;',\n   onRender: function() {\n       Ext.applyIf(this.renderData, {\n           blank: Ext.BLANK_IMAGE_URL,\n           iconCls: this.iconCls\n       });\n       Ext.applyIf(this.renderSelectors, {\n           iconEl: '.' + this.iconCls\n       });\n       IconComponent.superclass.onRender.call(this);\n   },\n   changeIconCls: function(newIconCls) {\n       if (this.rendered) {\n           this.iconEl.replaceClass(this.iconCls, newIconCls);\n       }\n       this.iconCls = newIconCls;\n   }\n});\n</code></pre>\n\n<p>The renderTpl defines an XTemplate with \"blank\" and \"iconCls\" variables which are read from renderData at render time. In addition, an \"iconEl\" reference to the Ext.Element is applied to the instance at render time. The changeIconCls method can now use the iconEl as soon as the component has been rendered.</p>\n\n<iframe src=\"http://player.vimeo.com/video/17905336?byline=0&amp;portrait=0\" width=\"500\" height=\"281\" frameborder=\"0\"></iframe>\n\n\n\n\n<iframe src=\"http://player.vimeo.com/video/17920271?byline=0&amp;portrait=0\" width=\"500\" height=\"281\" frameborder=\"0\"></iframe>\n\n\n\n\n<iframe src=\"http://player.vimeo.com/video/18777458?byline=0&amp;portrait=0\" width=\"500\" height=\"281\" frameborder=\"0\"></iframe>\n\n"
});