<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]><xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : lp_hu_HU_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass LP in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/lp_hu_HU_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='personal.firstName' and @before='personal.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
<head>
  <title>LP - HTML</title>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
  <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
</head>
<body>
  <table class="LP" cellSpacing="0" cellPadding="10" width="740" border="0">
	  <tbody>
	  <tr align="middle">
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_europass_lp.gif" width="95"/></td>
	    <td style="text-align: center" width="60%">
		  <span class="LabelBold">Europass Nyelvi útlevél</span>
		  <br/>
		  <span class="Label">Az Európa Tanács által kidolgozott Európai Nyelvtanulási napló része</span>
		</td>
	    <td width="20%"><img height="53" src="http://europass.cedefop.europa.eu/instruments/images/logos/otherlogo_lp.gif" width="95"/></td>
	  </tr>
	  </tbody>
  </table>
  <div class="VerLine_LP">
    <table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="173"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="516"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
	  <td class="LabelBold">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
	        Vezetéknév(nevek)&#160;
	      </xsl:when>
	      <xsl:otherwise>
		    &#160;Vezetéknév(nevek)
	      </xsl:otherwise>
	    </xsl:choose>
	  </td>
      <td class="Normal">
	    <xsl:choose>
	      <xsl:when test="$firstNameBefore=0">
            <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		  </xsl:when>
	      <xsl:otherwise>
		    <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		  </xsl:otherwise>
	    </xsl:choose>
      </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <xsl:if test="//field[@name='personal.birthDate' and @keep='true']">
    <tr>
      <td class="Label">Születési dátum</td>
      <td class="Normal">
      <xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
      </td><td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
	</xsl:if>
    <tr>
      <td class="Label">Anyanyelv(ek)</td>
      <td class="Normal"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td colSpan="3"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="Label">Egyéb/beszélt nyelv(ek)</td>
	  <td class="Normal">
	    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
          <xsl:if test="position() != 1">,&#160;</xsl:if>
		  <xsl:value-of select="label" />
	    </xsl:for-each>
	   </td>
      <td>&#160;</td>
	 </tr>
	 </tbody>
     </table>
  </div>
  
  <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
    <xsl:variable name="indexedLang">
	  <xsl:value-of select="concat('foreignLanguageList[', position()-1, ']')" />
    </xsl:variable>
	
    <br/>
	<div class="VerLine_LP">
    
	<table class="LP" cellSpacing="0" cellPadding="0" width="710" border="0">
    <tbody>
    <tr>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="19"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="109"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="8"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="17"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="108"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="86"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="23"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="25"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="31"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="79"/></td>
      <td><img height="1" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="21"/></td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalHighlight" colSpan="13"><xsl:value-of select="label" /> </td>
      <td>&#160;</td>
	</tr>
    
	<xsl:if test="//field[@name=concat($indexedLang,'.ass') and @keep='true']">
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Önértékelés </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeadingBold" colSpan="4">Szövegértés</td>
      <td class="GridHeadingBold" colSpan="6">Beszéd</td>
      <td class="GridHeadingBold" colSpan="3">Írás</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="2">Hallás utáni értés</td>
      <td class="GridHeading" colspan="2">Olvasás</td>
      <td class="GridHeading" colspan="3">Társalgás</td>
      <td class="GridHeading" colspan="3">Folyamatos beszéd</td>
      <td colSpan="3">&#160;</td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="NormalCenter"><xsl:value-of select="level/listening" /> </td>
      <td class="NormalCenter">
	    <xsl:if test="level/listening='a1'">alapszintű nyelvhasználó</xsl:if>
        <xsl:if test="level/listening='b1'">önálló nyelvhasználó</xsl:if>
  	    <xsl:if test="level/listening='c1'">mesterfokú nyelvhasználó</xsl:if>
	    
		<xsl:if test="level/listening='a2'">alapszintű nyelvhasználó</xsl:if>
	    <xsl:if test="level/listening='b2'">önálló nyelvhasználó</xsl:if>
		<xsl:if test="level/listening='c2'">mesterfokú nyelvhasználó</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/reading" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/reading='a1'">alapszintű nyelvhasználó</xsl:if>
		<xsl:if test="level/reading='b1'">önálló nyelvhasználó</xsl:if>
		<xsl:if test="level/reading='c1'">mesterfokú nyelvhasználó</xsl:if>
		
		<xsl:if test="level/reading='a2'">alapszintű nyelvhasználó</xsl:if>
		<xsl:if test="level/reading='b2'">önálló nyelvhasználó</xsl:if>
		<xsl:if test="level/reading='c2'">mesterfokú nyelvhasználó</xsl:if>
	  </td>
      <td class="NormalCenter" colSpan="2"><xsl:value-of select="level/spokeninteraction" /> </td>
      <td class="NormalCenter">
		<xsl:if test="level/spokeninteraction='a1'">alapszintű nyelvhasználó</xsl:if>
	    <xsl:if test="level/spokeninteraction='b1'">önálló nyelvhasználó</xsl:if>
		<xsl:if test="level/spokeninteraction='c1'">mesterfokú nyelvhasználó</xsl:if>
		
		<xsl:if test="level/spokeninteraction='a2'">alapszintű nyelvhasználó</xsl:if>
	    <xsl:if test="level/spokeninteraction='b2'">önálló nyelvhasználó</xsl:if>
		<xsl:if test="level/spokeninteraction='c2'">mesterfokú nyelvhasználó</xsl:if>
	  </td>
      <td class="NormalCenter"><xsl:value-of select="level/spokenproduction" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/spokenproduction='a1'">alapszintű nyelvhasználó</xsl:if>
	    <xsl:if test="level/spokenproduction='b1'">önálló nyelvhasználó</xsl:if>
		<xsl:if test="level/spokenproduction='c1'">mesterfokú nyelvhasználó</xsl:if>
		
		<xsl:if test="level/spokenproduction='a2'">alapszintű nyelvhasználó</xsl:if>
	    <xsl:if test="level/spokenproduction='b2'">önálló nyelvhasználó</xsl:if>
		<xsl:if test="level/spokenproduction='c2'">mesterfokú nyelvhasználó</xsl:if>
	  </td>
	  <td class="NormalCenter"><xsl:value-of select="level/writing" /> </td>
      <td class="NormalCenter" colSpan="2">
		<xsl:if test="level/writing='a1'">alapszintű nyelvhasználó</xsl:if>
	    <xsl:if test="level/writing='b1'">önálló nyelvhasználó</xsl:if>
		<xsl:if test="level/writing='c1'">mesterfokú nyelvhasználó</xsl:if>
		
		<xsl:if test="level/writing='a2'">alapszintű nyelvhasználó</xsl:if>
	    <xsl:if test="level/writing='b2'">önálló nyelvhasználó</xsl:if>
		<xsl:if test="level/writing='c2'">mesterfokú nyelvhasználó</xsl:if>
	  </td>
      <td>&#160;</td>
	</tr>
    </xsl:if>
	<tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Okelvel(ek) / bizonyítvány(ok) </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="5">Megnevezés</td>
	  <td class="GridHeading" colspan="4">Kibocsátó szerv</td>
	  <td class="GridHeading" colspan="3">Év</td>
	  <td class="GridHeading">Európai szint</td>
      <td>&#160;</td>
	</tr>
    
	<xsl:for-each select="diplomalist/diploma">
	  <xsl:variable name="indexedDiploma">
	    <xsl:value-of select="concat('.diplomaList[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:variable name="indexedBoth">
	    <xsl:value-of select="concat('', $indexedLang, $indexedDiploma)" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
        <tr>
          <td>&#160;</td>
          <td class="Normal" colSpan="5"><xsl:value-of select="title" /></td>
          <td class="Normal" colSpan="4"><xsl:value-of select="awardingBody" /></td>
          <td class="NormalCenter" colSpan="3">
            <xsl:value-of select="translate(date/day,'-','')" />
            <xsl:if test="string-length(date/day) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/month,'-','')" />
            <xsl:if test="string-length(date/month) != 0">/</xsl:if>
            <xsl:value-of select="translate(date/year,'-','')" />
          </td>
          <td class="NormalCenter"><xsl:value-of select="level" /> </td>
          <td>&#160;</td>
	    </tr>
        <tr>
          <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	    </tr>
	  </xsl:if>
    </xsl:for-each>
  
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
    <tr>
      <td class="GridHeadingBold" colSpan="14">Nyelvi tapasztalat(ok) </td>
      <td>&#160;</td>
	</tr>
    <tr>
      <td>&#160;</td>
      <td class="GridHeading" colspan="9">Leírás</td>
	  <td class="GridHeading" colspan="3">-tól</td>
	  <td class="GridHeading">-ig</td>
      <td>&#160;</td>
	</tr>
	
    <xsl:for-each select="experiencelist/experience">
	<xsl:variable name="indexedExperience">
	  <xsl:value-of select="concat('.experienceList[', position()-1, ']')" />
	</xsl:variable>
	<xsl:variable name="indexedBoth">
	  <xsl:value-of select="concat('', $indexedLang, $indexedExperience)" />
	</xsl:variable>
    <xsl:if test="//field[@name=$indexedBoth and @keep='true']">
      <tr>
        <td>&#160;</td>
        <td class="Normal" colSpan="9"><xsl:value-of select="description" /></td>
        <td class="NormalCenter" colSpan="3">
          <xsl:value-of select="translate(period/from/day,'-','')" />
		    	<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/month,'-','')" />
          <xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/from/year,'-','')" />
	    </td>
        <td class="NormalCenter">
          <xsl:value-of select="translate(period/to/day,'-','')" />
          <xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/month,'-','')" />
          <xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
          <xsl:value-of select="translate(period/to/year,'-','')" />
	    </td>
        <td>&#160;</td>
	  </tr>
      <tr>
        <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
      </tr>
	</xsl:if>
	</xsl:for-each>
    <tr>
      <td colSpan="15"><img height="5" src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="5"/></td>
	</tr>
  
  </tbody>
  </table>
  
  </div>
  </xsl:for-each>
    
  <div class="Asterix">
    (*)A csillaggal megjelölt rovatok kitöltése választható
	(**)Önértékelési táblázatot lásd túloldalt
	(***)Közös Európai Referenciakeret (CEF) szint, ha meghatározásra került az eredeti bizonyítávnyban vagy oklevélben.<br/>
  </div>
  <br/>
  <div class="Footnote">
	<b>Magyarázó jegyzet</b><br/>
	Az Europass nyelvi útlevél az Európa Tanács által fejlesztett Európai Nyelvtanulási napló részére. A formanyomtatványban a Közös Európai Referenciakeret 6 európai szintje szolgál a gyakorlati nyelvtudás bemutatására.<br/>
	További információk az Europass nyelvi útlevélről: http://europass.cedefop.europa.eu - További információk az Európai Nyelvtanuálsi naplóról: www.coe.int/portfolio<br/>
	A formanyomtatvány az Europass nyelvi útlevélhez térítésmentesen letötlhető a fenti honlapokról.<br/>
	© Európa Tanács és Európai Közösségek, 2004   20060628<br/>
  </div>
  <br/>
  
  <xsl:if test="//field[@name='grid' and @keep='true']">
  <table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">A közös európai léptékre épülő értékelési táblázat</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Megértem a személyemre, a családomra, a közvetlen környezetemre vonatkozó, gyakran használt, egyszerű szavakat és szókapcsolatokat, ha lassan és tagoltan beszélnek hozzám.</td>
		<td>Megértem a nagyon egyszerű mondatokat, például hirdetésekben,  plakátokon vagy katalógusokban az ismert nevek vagy szavak segítségével.</td>
		<td>Képes vagyok egyszerű kapcsolatteremtésre, ha a másik személy kész mondanivalóját kissé lassabban vagy más kifejezésekkel megismételni illetve segíti  a mondanivalóm megformálását. Fel tudok tenni és meg tudok válaszolni olyan kérdéseket, amelyek a mindennapi szükségletek konkrét kifejezésére szolgálnak.</td>
		<td>Egyszerű kifejezésekkel és mondatokkal be tudom mutatni a lakóhelyemet és az ismerőseimet.</td>
		<td>Tudok képeslapra rövid és egyszerű (például nyaralási)  üdvözletet írni. Ki tudom tölteni egyszerű nyomtatványon a személyi adataimra vonatkozó részeket, például a szállodai bejelentőlapon a nevemet, az állampolgárságomat és a  címemet.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Megértem a személyemhez közvetlenül kapcsolódó, gyakran használt szavakat és kifejezéseket (pl. személyes adataim, családom, vásárlások, szűk környezet, tanulás, munka). Megértem az egyszerű és világos hirdetések és üzenetek lényegét.</td>
		<td>El tudok olvasni rövid, nagyon egyszerű szövegeket. Megtalálom a várható, konkrét információt a mindennapi, egyszerű szövegekben (pl. rövid hirdetés, prospektus, menü, menetrend), és megértem a rövid, egyszerű magánleveleket.</td>
		<td>Az egyszerű, rutinszerű helyzetekben egyszerű és közvetlen módon cserélek információt mindennapi tevékenységekről vagy témákról. A nagyon rövid információcserére még akkor is képes vagyok, ha egyébként nem értek meg eleget ahhoz, hogy a társalgásban folyamatosan részt vegyek.</td>
		<td>Egyszerű eszközökkel és mondatokkal tudok beszélni a családomról és más személyekről, életkörülményeimről, tanulmányaimról, jelenlegi vagy előző szakmai tevékenységemről.</td>
		<td>Tudok rövid, egyszerű jegyzetet, üzenetet, vagy magánjellegű, például köszönőlevelet írni.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>Megértem a világos, mindennapi beszéd lényegét, ha olyan témákról esik szó, mint a munka, a tanulás, a szabadidő, stb. Ki tudom szűrni a lényeget azokból a rádió- és tévéadásokból, amelyek aktuális eseményekről, szakmai vagy érdeklődési körömnek megfelelő témákról szólnak, ha eléggé lassan és tagoltan beszélnek.</td>
		<td>Megértem a főként köznyelven, vagy a munkámhoz közvetlenül kapcsolódó szaknyelven megírt szövegeket. Magánlevélben megértem az események, érzelmek vagy kívánságok leírását.</td>
		<td>Elboldogulok a legtöbb olyan nyelvi helyzetben, amely utazás során adódik. Felkészülés nélkül részt tudok venni az ismert, az érdeklődési körömnek megfelelő, vagy a mindennapi témákról (pl. család, szabadidő, tanulás, munka, utazás, aktuális események) folyó társalgásban.</td>
		<td>Egyszerű kifejezésekkel tudok beszélni élményekről, eseményekről, álmaimról, reményeimről és céljaimról. Röviden is meg tudom magyarázni, indokolni véleményemet és terveimet.</td>
		<td>Egyszerű, folyamatos szövegeket tudok alkotni olyan témákban, amelyeket ismerek, vagy érdeklődési körömbe tartoznak. Élményeimről és benyomásaimról magánleveleket tudok írni.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>Megértem a hosszabb beszédeket és előadásokat, illetve még a bonyolultabb érveléseket is követni tudom, amennyiben a téma számomra elég ismert. Többnyire megértem a híreket és az aktuális eseményekről szóló műsorokat a tévében. Általában értem a filmeket, ha a szereplők köznyelven beszélnek.</td>
		<td>El tudom olvasni azokat a cikkeket és beszámolókat, amelyek jelenkori problémákkal foglalkoznak, és szerzőjük véleményét, nézetét fejtik ki. Megértem a kortárs irodalmi prózát.</td>
		<td>Az anyanyelvi beszélővel természetes, könnyed és közvetlen kapcsolatteremtésre vagyok képes. Aktívan részt tudok venni az ismert témákról folyó társalgásban, úgy, hogy közben érvelve kifejtem a véleményemet.</td>
		<td>Világosan és kellő részletességgel fejezem ki magam számos, érdeklődési körömbe tartozó témában. Ki tudom fejteni a véleményemet valamely aktuális témáról úgy, hogy részletezem a különböző lehetőségek előnyeit és hátrányait.</td>
		<td>Világos és részletes szövegeket tudok alkotni az érdeklődési körömbe tartozó számos témáról. Tudok olyan dolgozatot vagy beszámolót írni, amely tájékoztat, érveket és ellenérveket sorakoztat fel valamiről. Levélben rá tudok világítani arra, hogy milyen jelentőséget tulajdonítok az eseményeknek, élményeknek.</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Még a nem világosan szerkesztett és rejtett jelentéstartalmú, hosszú szöveget is megértem. Szinte erőfeszítés nélkül értem meg a tévéműsorokat és a filmeket.</td>
		<td>Megértem a hosszú, összetett, tényszerű és irodalmi szövegeket; érzékelem bennük a különböző stílusjegyeket. A szakmai cikkeket és a hosszú műszaki leírásokat akkor is megértem, ha nem kapcsolódnak szakterületemhez.</td>
		<td>Folyamatosan és gördülékenyen fejezem ki magam, ritkán keresek szavakat és kifejezéseket. A nyelvet könnyeden és hatékonyan használom a különböző társadalmi és szakmai kapcsolatokban. Gondolataimat, véleményemet pontosan ki tudom fejteni; hozzászólásaimat a beszélőtársakéhoz tudom kapcsolni.</td>
		<td>Világosan és részletesen tudok leírni bonyolult dolgokat úgy, hogy más kapcsolódó témaköröket is bevonok, egyes elemeket részletezek, és mondanivalómat megfelelően fejezem be.</td>
		<td>Képes vagyok arra, hogy álláspontomat világos, jól szerkesztett szövegben fogalmazzam meg. Levélben, dolgozatban, beszámolóban úgy tudok összetett témákról írni, hogy a fontosnak tartott dolgokat kiemelem. Stílusomat az olvasóhoz tudom igazítani.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Minden nehézség nélkül megértem az élőben hallott, médián keresztül sugárzott, vagy gyors tempójú beszédet, ha van időm megszokni az akcentust.</td>
		<td>Könnyedén elolvasok bármilyen tartalmú vagy formájú elvont, bonyolult szöveget, például kézikönyvet, szakcikket, irodalmi művet.</td>
		<td>Könnyedén részt tudok venni bármilyen társalgásban, vitában; nagy biztonsággal alkalmazom a sajátos kifejezéseket és a különböző nyelvi fordulatokat. Gördülékenyen, szabatosan, az árnyalatok finom kifejezésére is ügyelve beszélek. Ha elakadok, úgy kezdem újra és fogalmazom át a mondandómat, hogy az szinte fel sem tűnik.</td>
		<td>Világosan és folyamatosan, stílusomat a helyzethez igazítva írok le vagy fejtek ki bármit, előadásomat logikusan szerkesztem meg; segítem a hallgatót abban, hogy a lényeges pontokat kiragadja és megjegyezze.</td>
		<td>Tudok világos, gördülékeny, a körülményekhez stílusában illeszkedő szöveget írni. Meg tudok fogalmazni olyan bonyolult levelet, beszámolót és cikket, amelynek jó tagolása segíti az olvasót abban, hogy a lényeges pontokat kiragadja és megjegyezze. Össze tudok foglalni szakmai és irodalmi műveket, tudok róluk kritikai elemzést írni.</td>
	</tr>
  </table>
  </xsl:if>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif"/> <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logos/logo_for_htmlpreview.gif"/>
  <img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg"/> 
</body>
</html>
  </xsl:template>
</xsl:stylesheet>
