<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
  <!ENTITY copy   "&#169;">
]>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:europass="http://europass.cedefop.europa.eu/Europass/V2.0">
<xsl:template match="/">
<xsl:comment>
  # 
	© European Communities, 2002-2008 http://europass.cedefop.europa.eu
  # http://europass.cedefop.europa.eu/europass/home/botnav/LegalNotice.csp
  # Name      : cv_mt_MT_V2.0.xsl
  # Version   : V2.0
  # Purpose   : Provides a way to show the Europass CV in HTML format.
  # Author(s) : Europass team
  # URL       : http://europass.cedefop.europa.eu/TechnicalResources/XML/xsl/europass-xsl-V2.0/cv_mt_MT_V2.0.xsl
</xsl:comment>
<xsl:variable name="firstNameBefore">
<xsl:choose>
  <xsl:when test="//field[@name='step1.firstName' and @before='step1.lastName']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="step3Before">
<xsl:choose>
  <xsl:when test="//field[@name='step3List' and @before='step4List']">1</xsl:when>
  <xsl:otherwise>0</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<html>
  <head>
    <title>CV - HTML</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <link href="http://europass.cedefop.europa.eu/instruments/css/html.css" type="text/css" rel="stylesheet"/>
  </head>
<body>
<table width="700" border="0" cellspacing="0" cellpadding="0" class="CV">
  <tr>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="190"/></td>
    <td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="7"/></td>
	<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="8"/></td>
    <td colspan="11"><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" height="1" width="495"/></td>
  </tr>
  <tr>
    <td class="Logo" rowspan="2">&#160;</td>
	<td style="height:42px;">&#160;</td>
    <td colspan="12" rowspan="2">&#160;</td>
  </tr>
  <tr>
    <td class="Corner">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Title">
	  Europass<br/>
      Curriculum Vitae <br />
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Heading1">Informazzjoni personali</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <tr>
    <td class="Label">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
	      Kunjom(ijiet)&#160;Isem (Ismijiet)
	    </xsl:when>
	    <xsl:otherwise>
		  Isem (Ismijiet)&#160;Kunjom(ijiet)
	    </xsl:otherwise>
	  </xsl:choose>
	</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11">
	  <xsl:choose>
	    <xsl:when test="$firstNameBefore=0">
          <xsl:value-of select="europass:learnerinfo/identification/lastname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/firstname" />
		</xsl:when>
	    <xsl:otherwise>
		  <xsl:value-of select="europass:learnerinfo/identification/firstname" />&#160;<xsl:value-of select="europass:learnerinfo/identification/lastname" />
		</xsl:otherwise>
	  </xsl:choose>
	</td>
  </tr>
  <xsl:if test="//field[@name='step1.addressInfo' and @keep='true']">
  <tr>
    <td class="Label">Indirizz(i)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/contactinfo/address/addressLine">
        <xsl:value-of select="current()" /><br/>
      </xsl:for-each>
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/postalCode) != 0">
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/postalCode" />, </xsl:if>
      <xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/municipality" />
      <xsl:if test="string-length(europass:learnerinfo/identification/contactinfo/address/country/label) != 0"> (<xsl:value-of select="europass:learnerinfo/identification/contactinfo/address/country/label" />)</xsl:if>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.mobile' and @keep='true']">
  <tr>
    <td class="Label">Numru(i) tat-telefon(s)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="5">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/telephone" />
	</td>
    <td class="Label" width="15%" colSpan="2">Mowbajl</td>
    <td class="Normal" colSpan="4">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/mobile" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.fax' and @keep='true']">
  <tr>
    <td class="Label">Numru(i) tal-faks</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/fax" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.email' and @keep='true']">
  <tr>
    <td class="Label">E-mail (s)</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td class="Normal" colspan="11">
	  <xsl:value-of select="europass:learnerinfo/identification/contactinfo/email" />
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.nationality' and @keep='true']">
  <tr>
    <td class="Label">Nazzjonalita' / jiet</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
      <xsl:for-each select="europass:learnerinfo/identification/demographics/nationality/label">
    		<xsl:if test="position() != 1">,&#160;</xsl:if>
        <xsl:value-of select="current()"/>
    	</xsl:for-each>
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.birthDate' and @keep='true']">
  <tr>
    <td class="Label">Data tat-twelid</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
    	<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 9, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 6, 2)" />/<xsl:value-of select="substring(europass:learnerinfo/identification/demographics/birthdate, 1, 4)" />
    </td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.gender' and @keep='true']">
  <tr>
    <td class="Label">Sess</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='M'"><xsl:text>Maskil</xsl:text></xsl:if>
	  <xsl:if test="europass:learnerinfo/identification/demographics/gender='F'"><xsl:text>Femminil</xsl:text></xsl:if>
	</td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step1.application' and @keep='true']">
  <tr>
    <td class="Heading1">Impjieg mixtieq/Qasam ta' xogħol</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
	  <PRE><xsl:value-of select="europass:learnerinfo/application/label" /></PRE>
	</td>
  </tr>
  </xsl:if>
  
  
  <xsl:choose>
    <xsl:when test="$step3Before=1">
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Esperjenza ta' xogħol</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Dati</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Impjieg jew pożizzjoni li kellek/għandek</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Attivitajiet u responsabbilitajiet prinċipali</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Isem u indirizz ta' min iħaddem</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
          <PRE><xsl:value-of select="employer/name" /></PRE>
          <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
            <xsl:for-each select="employer/address/addressLine">
              <xsl:value-of select="current()" /><br/>
            </xsl:for-each>
            <xsl:if test="string-length(employer/address/postalCode) != 0"><xsl:value-of select="employer/address/postalCode" />, </xsl:if>
            <xsl:value-of select="employer/address/municipality" />
            <xsl:if test=" string-length(employer/address/country/label) != 0"> (<xsl:value-of select="employer/address/country/label" />)</xsl:if>
          </xsl:if>
		    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Tip ta' negozju jew ta' settur</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Edukazzjoni u taħriġ</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Dati</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Titlu tal-kwalifika miksuba</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Suġġetti prinċipali/ ħiliet ta' xogħol miksuba</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Isem u tip tal-organizzazzjoni liipprovdiet l-edukazzjoni/t-taħriġ</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
        <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
        <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
          <xsl:for-each select="organisation/address/addressLine">
            <xsl:value-of select="current()" /><br/>
          </xsl:for-each>
          <xsl:if test="string-length(organisation/address/postalCode) != 0"><xsl:value-of select="organisation/address/postalCode" />, </xsl:if>
          <xsl:value-of select="organisation/address/municipality" />
          <xsl:if test="string-length(organisation/address/country/label) != 0"> (<xsl:value-of select="organisation/address/country/label" />)</xsl:if>
        </xsl:if>
      </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Klassifikazzjoni tal-livell nazzjonali / internazzjonali</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:if test="//field[@name='step4List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Edukazzjoni u taħriġ</td>
	    <td class="VerticalLine">&#160;</td>
		<td>&#160;</td>
	    <td class="Normal" colspan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/educationlist/education">
	  <tr>
	    <td class="Label">Dati</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
			<xsl:value-of select="translate(period/from/day,'-','')" />
	    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/month,'-','')" />
			<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/from/year,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
			-
			</xsl:if>
			<xsl:value-of select="translate(period/to/day,'-','')" />
			<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/month,'-','')" />
			<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
			<xsl:value-of select="translate(period/to/year,'-','')" />
		</td>
	  </tr>
	  <xsl:variable name="indexedStep4">
	    <xsl:value-of select="concat('step4List[', position()-1, ']')" />
	  </xsl:variable>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.title') and @keep='true']">
	  <tr>
	    <td class="Label">Titlu tal-kwalifika miksuba</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="title" /></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.skills') and @keep='true']">
	  <tr>
	    <td class="Label">Suġġetti prinċipali/ ħiliet ta' xogħol miksuba</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="skills" /></PRE></td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.name') and @keep='true']">
	  <tr>
	    <td class="Label">Isem u tip tal-organizzazzjoni liipprovdiet l-edukazzjoni/t-taħriġ</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">
                <PRE><xsl:value-of select="organisation/name" /><xsl:if test="string-length(organisation/type) != 0">(<xsl:value-of select="organisation/type" />)</xsl:if></PRE>
            </td>
	  </tr>
	  </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.educationalOrg.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Indirizz(i)</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="organisation/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="organisation/address/postalCode" /><br/>
                      <xsl:value-of select="organisation/address/municipality" /><br/>
                      <xsl:value-of select="organisation/address/country/label" /><br/>
                    </td>
		  </tr>
          </xsl:if>
	  <xsl:if test="//field[@name=concat($indexedStep4,'.level.label') and @keep='true']">
	  <tr>
	    <td class="Label">Klassifikazzjoni tal-livell nazzjonali / internazzjonali</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11"><xsl:value-of select="level/label" /></td>
	  </tr>
	  </xsl:if>
	  <tr>
	    <td class="Label">&#160;</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>          
	  </xsl:for-each>
	  </xsl:if>
	  <xsl:if test="//field[@name='step3List' and @keep='true']">
	  <tr>
	    <td class="Heading1">Esperjenza ta' xogħol</td>
	    <td class="VerticalLine">&#160;</td>
	    <td>&#160;</td>
	    <td class="Normal" colSpan="11">&#160;</td>
	  </tr>
	  <xsl:for-each select="europass:learnerinfo/workexperiencelist/workexperience">
		  <tr>
		    <td class="Label">Dati</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
		    		<xsl:value-of select="translate(period/from/day,'-','')" />
		    		<xsl:if test="string-length(period/from/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/month,'-','')" />
				<xsl:if test="string-length(period/from/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/from/year,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0 or string-length(period/to/month) != 0 or string-length(period/to/year) != 0">
				-
				</xsl:if>
				<xsl:value-of select="translate(period/to/day,'-','')" />
				<xsl:if test="string-length(period/to/day) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/month,'-','')" />
				<xsl:if test="string-length(period/to/month) != 0">/</xsl:if>
				<xsl:value-of select="translate(period/to/year,'-','')" />
			</td>
		  </tr>
		  <xsl:variable name="indexedStep3">
			<xsl:value-of select="concat('step3List[', position()-1, ']')" />
		  </xsl:variable>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.position') and @keep='true']">
		  <tr>
		    <td class="Label">Impjieg jew pożizzjoni li kellek/għandek</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="position/label" /></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.activities') and @keep='true']">
		  <tr>
		    <td class="Label">Attivitajiet u responsabbilitajiet prinċipali</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="activities" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.name') and @keep='true']">
		  <tr>
		    <td class="Label">Isem u indirizz ta' min iħaddem</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="employer/name" /></PRE></td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.addressInfo') and @keep='true']">
		  <tr>
		    <td class="Label">Indirizz(i)</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">
                      <xsl:for-each select="employer/address/addressLine">
                        <xsl:value-of select="current()" /><br/>
                      </xsl:for-each>
                      <xsl:value-of select="employer/address/postalCode" /><br/>
                      <xsl:value-of select="employer/address/municipality" /><br/>
                      <xsl:value-of select="employer/address/country/label" /><br/>
                    </td>
		  </tr>
		  </xsl:if>
		  <xsl:if test="//field[@name=concat($indexedStep3,'.company.sector.label') and @keep='true']">
		  <tr>
		    <td class="Label">Tip ta' negozju jew ta' settur</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11"><xsl:value-of select="employer/sector/label" /></td>
		  </tr>
		  </xsl:if>
		  <tr>
		    <td class="Label">&#160;</td>
		    <td class="VerticalLine">&#160;</td>
		    <td>&#160;</td>
		    <td class="Normal" colSpan="11">&#160;</td>
		  </tr>
	  </xsl:for-each>
	  </xsl:if>
	</xsl:otherwise>
  </xsl:choose>
  
  <tr>
    <td class="Heading1">Ħiliet u kompetenzi personali</td>
    <td class="VerticalLine">&#160;</td>
	<td>&#160;</td>
    <td colspan="11" class="Normal">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step5.motherLanguages' and @keep='true']">
  <tr>
    <td class="Label">Ilsien / Isla nattiv(i)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2" colSpan="11"><xsl:value-of select="europass:learnerinfo/languagelist/language[@xsi:type='europass:mother']/label" /></td>
  </tr>
  </xsl:if>
  <xsl:if test="//field[@name='step5.foreignLanguageList' and @keep='true']">
  <tr>
    <td class="Label">Lingwa(i) oħra</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td></tr>
  <tr>
    <td class="Label">Awtoassessjar</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Heading2Center" colSpan="4">Fehim</td>
    <td class="Heading2Center" colSpan="4">Taħdit</td>
    <td class="Heading2Center" colSpan="2">Kitba</td>
    <td width="1%">&#160;</td>
  </tr>
  <tr>
    <td class="Label">Livell Ewropew(***)</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="NormalSmall" colSpan="2">Smigħ</td>
    <td class="NormalSmall" colSpan="2">Qari</td>
    <td class="NormalSmall" colSpan="2">Taħdit interattiv</td>
    <td class="NormalSmall" colSpan="2">Taħdit produttiv</td>
    <td class="NormalSmall" colSpan="2">&#160;</td>
    <td width="1%">&#160;</td>
  </tr>
    <xsl:for-each select="europass:learnerinfo/languagelist/language[@xsi:type='europass:foreign']">
	  <xsl:variable name="indexedLang">
        <xsl:value-of select="concat('step5.foreignLanguageList[', position()-1, ']')" />
      </xsl:variable>
      <xsl:if test="//field[@name=$indexedLang and @keep='true']">
      <tr>
	    <td class="Heading1Box"><xsl:value-of select="label" /></td>
	    <td class="VerticalLineBox">&#160;</td>
	    <td>&#160;</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/listening" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/listening='a1'">Użu bażiku</xsl:if>
		    <xsl:if test="level/listening='b1'">Użu indipendenti</xsl:if>
			<xsl:if test="level/listening='c1'">Użu profiċjenti</xsl:if>
			
			<xsl:if test="level/listening='a2'">Użu bażiku</xsl:if>
		    <xsl:if test="level/listening='b2'">Użu indipendenti</xsl:if>
			<xsl:if test="level/listening='c2'">Użu profiċjenti</xsl:if>
	    </td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/reading" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/reading='a1'">Użu bażiku</xsl:if>
			<xsl:if test="level/reading='b1'">Użu indipendenti</xsl:if>
			<xsl:if test="level/reading='c1'">Użu profiċjenti</xsl:if>
		
			<xsl:if test="level/reading='a2'">Użu bażiku</xsl:if>
			<xsl:if test="level/reading='b2'">Użu indipendenti</xsl:if>
			<xsl:if test="level/reading='c2'">Użu profiċjenti</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/spokeninteraction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokeninteraction='a1'">Użu bażiku</xsl:if>
			<xsl:if test="level/spokeninteraction='b1'">Użu indipendenti</xsl:if>
			<xsl:if test="level/spokeninteraction='c1'">Użu profiċjenti</xsl:if>
		
			<xsl:if test="level/spokeninteraction='a2'">Użu bażiku</xsl:if>
			<xsl:if test="level/spokeninteraction='b2'">Użu indipendenti</xsl:if>
			<xsl:if test="level/spokeninteraction='c2'">Użu profiċjenti</xsl:if>
		</td>
		<td class="NormalSmall" width="5%"><xsl:value-of select="level/spokenproduction" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/spokenproduction='a1'">Użu bażiku</xsl:if>
			<xsl:if test="level/spokenproduction='b1'">Użu indipendenti</xsl:if>
			<xsl:if test="level/spokenproduction='c1'">Użu profiċjenti</xsl:if>
		
			<xsl:if test="level/spokenproduction='a2'">Użu bażiku</xsl:if>
			<xsl:if test="level/spokenproduction='b2'">Użu indipendenti</xsl:if>
			<xsl:if test="level/spokenproduction='c2'">Użu profiċjenti</xsl:if>
		</td>
	    <td class="NormalSmall" width="5%"><xsl:value-of select="level/writing" /></td>
	    <td class="NormalSmall">
			<xsl:if test="level/writing='a1'">Użu bażiku</xsl:if>
			<xsl:if test="level/writing='b1'">Użu indipendenti</xsl:if>
			<xsl:if test="level/writing='c1'">Użu profiċjenti</xsl:if>
		
			<xsl:if test="level/writing='a2'">Użu bażiku</xsl:if>
			<xsl:if test="level/writing='b2'">Użu indipendenti</xsl:if>
			<xsl:if test="level/writing='c2'">Użu profiċjenti</xsl:if>
		</td>
	    <td width="1%">&#160;</td>
	  </tr>
	  </xsl:if>
    </xsl:for-each>
  </xsl:if>
  <tr>
    <td class="Label">&#160;</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">&#160;</td>
  </tr>
  <xsl:if test="//field[@name='step6.socialSkills' and @keep='true']">
  <tr>
    <td class="Label">Ħiliet soċjali u kompetenzi</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='social']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.organisationalSkills' and @keep='true']">
  <tr>
    <td class="Label">Ħiliet u kompetenzi organizzattivi</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='organisational']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.technicalSkills' and @keep='true']">
  <tr>
    <td class="Label">Ħiliet u kompetenzi tekniċi</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='technical']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.computerSkills' and @keep='true']">
  <tr>
    <td class="Label">Ħiliet u kompetenzi fl-użu tal-kompjuter</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='computer']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.artisticSkills' and @keep='true']">
  <tr>
    <td class="Label">Ħiliet u kompetenzi artistiċi</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='artistic']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.otherSkills' and @keep='true']">
  <tr>
    <td class="Label">Ħiliet u kompetenzi oħra</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/skilllist/skill[@type='other']" /></PRE></td>
  </tr>	
  </xsl:if>	  
  <xsl:if test="//field[@name='step6.drivingLicences' and @keep='true']">
  <tr>
    <td class="Label">Liċenzja tas-sewqan</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11">
        <xsl:for-each select="europass:learnerinfo/skilllist/structured-skill[@xsi:type='europass:driving']/drivinglicence">
            <xsl:if test="position() != 1">,&#160;</xsl:if>
            <xsl:value-of select="current()" />
        </xsl:for-each>
    </td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.additionalInfo' and @keep='true']">
  <tr>
    <td class="Heading1">Informazzjoni oħra</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='additional']" /></PRE></td>
  </tr>
  </xsl:if>	  
  <xsl:if test="//field[@name='step7.annexes' and @keep='true']">
  <tr>
    <td class="Heading1">Annessi</td>
    <td class="VerticalLine">&#160;</td>
    <td>&#160;</td>
    <td class="Normal" colSpan="11"><PRE><xsl:value-of select="europass:learnerinfo/misclist/misc[@type='annexes']" /></PRE></td>
  </tr>
  </xsl:if>
</table>
<br/>
<xsl:if test="//field[@name='grid' and @keep='true']">
<table width="710" border="0" cellspacing="0" cellpadding="0" class="Grid">
	<tr class="spacer">
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="20" height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
		<td><img src="http://europass.cedefop.europa.eu/instruments/images/logospace.gif" width="138"  height="1" /></td>
	</tr>
	<tr>
		<th colspan="6" class="title">Livell Ewropew – tabella ta’ l-awto-assessjar</th>
	</tr>
	<tr class="level">
		<th>A1</th>
		<td>Kapaċi nifhem kliem familjari u xi frażijiet bażiċi fuqi nnifsi,fuq il-familja tiegħi u fuq l-ambjent ta’ madwari meta n-nies jitkellmu bil-mod u ċar.</td>
		<td>Kapaċi nifhem ismijiet u kliem familjari u sentenzi sempliċi ħafna bħal f’avviżi, f’kartelluni jew f’katalgi.</td>
		<td>Kapaċi nikkomunika b’mod sempliċi sakemm il-persuna l-oħra hija lesta li tirrepeti jew tbiddel il-kliem u titkellem b’mod inqas mgħaġġel u tgħinni ngħid dak li nkun qiegħed nipprova ngħid. Kapaċi nistaqsi u nwieġeb mistoqsijiet sempliċi fir-rigward ta’ bżonnijiet immedjati jew suġġetti familjari ħafna.</td>
		<td>Kapaċi nuża frażijiet u sentenzi sempliċi biex niddeskrivi fejn noqgħod u n-nies li naf.</td>
		<td>Kapaċi nikteb kartolina fil-qosor u b’mod sempliċi biex nibgħat tislijiet meta nkun bi btala. Nista’ nimla formoli b’dettalji personali bħal ismi, in-nazzjonalità u l-indirizz fuq formola ta’ reġistrazzjoni f’lukanda.</td>
	</tr>
	<tr class="level">
		<th>A2</th>
		<td>Kapaċi nifhem frażijiet u li jintużaw ta’ spiss u li huma relatati ma esperjenzi personali li jolqtu fil qrib il-familja (eż informazzjoni bażika ħafna dwari, ix-xiri, l-ambjent ta’ madwari u l-impjiegi). Kapaċi nifhem il-punt prinċipali f’messaġġi u avviżi qosra, ċari u sempliċi.</td>
		<td>Kapaċi naqra testi qosra ħafna u sempliċi. Kapaċi nsib informazzjoni speċifika u li tista’ tobsorha f’publikazzjonijiet sempliċi u ta’ kuljum bħal f’reklami, prospetti, menus, u timetables u nista’ nifhem ittri qosra, sempliċi u personali.</td>
		<td>Kapaċi nikkomunika b’xogħlijiet sempliċi u ta’ rutina li jesiġu bdil ta’ nformazzjoni sempliċi u diretta dwar suġġetti u attivitajiet familjari. Kapaċi nagħmel diskors qasir ħafna u soċjali iżda normalment ma nifhimx biżżejjed biex inżomm konverżazzjoni.</td>
		<td>Kapaċi nuża serje ta’ frażijiet u sentenzi biex niddeskrivi b’mod sempliċi, il-familja u nies oħra, il-kundizzjonijiet ta’ għijxien, l-edukazzjoni tiegħi u l-impjieg preżenti u l-aktar reċenti.</td>
		<td>Kapaċi nikteb noti u messaġġi qosra u sempliċi. Kapaċi nikteb ittra sempliċi u personali biex nirringrazzja lil xi ħadd għal xi ħaġa.</td>
	</tr>
	<tr class="level">
		<th>B1</th>
		<td>Kapaċi nifhem il-punti ewlenin ta’ taħdit ċar dwar temi familjari li niltaqgħu magħhom regolarment fix-xogħol, fl-iskola, waqt il-ħin liberu eċċ. Kapaċi nifhem il-punt ewlieni ta’ programmi ta’ ġrajjiet kurrenti fuq ir-radju u t-televiżjoni jew temi ta’ interess personali u professjonali meta d-diskors isir bil-mod u ċar.</td>
		<td>Kapaċi nifhem testi li jikkonsistu prinċipalment f’lingwaġġ użat ta’ spiss u ta’ kuljum jew li għandu x’jaqsam ma’ xogħol. Kapaċi nifhem id-deskrizzjoni ta’ avvenimenti, ħsus u xewqat f’ittri personali.</td>
		<td>Kapaċi niffaċċja ħafna sitwazzjonijiet li jistgħu jinqalgħu waqt vjaġġ f’post fejn il-lingwa tal-post hi mitkellma u nidħol mhux ippreparat f’konverżazzjoni fuq temi familjari ta’ interess personali jew pertinenti fil-ħajja ta’ kuljum. (eż. familja, passatempi, xogħol, vjaġġar u ġrajjiet kurrenti).</td>
		<td>Kapaċi ngħaqqad frażijiet b’mod sempliċi biex niddeskrivi esperjenzi u avvenimenti, il-ħolm tiegħi, ix-xewqat u l-ambizzjonijiet tiegħi. Kapaċi nagħti raġunijiet u spjegazzjonijiet fil-qosor u nispjega opinjonijiet u pjanijiet. Naf ngħid storja jew nitkellem dwar in-nisġa ta’ ktieb jew ta’ film u niddeskrivi r-reazzjonijiet tiegħi.</td>
		<td>Kapaċi nikteb test sempliċi u stilistikament konness dwar interessi familjari u personali. Kapaċi nikteb ittri personali li jiddeskrivu esperjenzi u impressjonijiet.</td>
	</tr>
	<tr class="level">
		<th>B2</th>
		<td>Kapaċi nifhem taħdidiet u ‘lectures’ twal u nifhem ukoll argumenti kumplessi sakemm it-tema tkun waħda familjari. Kapaċi nifhem il-biċċa l-kbira ta’ l-aħbarijiet u programmi ta’ ġrajjiet kurrenti fuq it-televiżjoni. Kapaċi nifhem il-biċċa l-kbira ta’ films bil-lingwa ‘standard’.</td>
		<td>Kapaċi naqra artikli u rapporti li għandhom x’jaqsmu ma’ problemi attwali li fihom il-kittieba jaddottaw attitudnijiet jew opinjonijiet partikulari. Kapaċi nifhem proża letterarja kontemporanja.</td>
		<td>Kapaċi nikkomunika b&apos;mod spontanju li tgħinni nikkomunika man-nies tal-lokal. Kapaċi nieħu parti attiva f’diskussjoni f’kuntest familjari u nsostni u nispjega l-opinjoni tieghi.</td>
		<td>Kapaċi niddeskrivi b’mod ċar u dettaljat firxa wiesgħa ta’ suġġetti relatati ma oqsma li jinteressawni. Kapaċi nispjega l-opinjoni tiegħi dwar il-vantaġġi u l-iżvantaġġi ta’ argumenti varji.</td>
		<td>Kapaċi nikteb b’mod dettaljat u ċar fuq suġġetti relatati ma’ l-interessi tiegħi. Kapaċi nikteb esej jew rapport fejn nagħti informazzjoni u raġunijiet biex insaħħaħ jew nikkontradixxi opinjoni partikulari. Kapaċi nikteb ittri u nagħmel enfasi fuq l-importanza personali ta’ avvenimenti u esperjenzi.</td>
	</tr>
	<tr class="level">
		<th>C1</th>
		<td>Kapaċi nifhem taħditiet twal anke meta l-istruttura tas-sentenza ma tkunx ċara u meta  r-relazzjonijiet ikunu biss implikati u ma jkunux spjegati b’mod ċar. Kapaċi nifhem programmi tat-televiżjoni u films mingħajr sforz żejjed.</td>
		<td>Kapaċi nifhem testi twal, kumplessi, fattwali u letterarji u napprezza d-diversità fl-istil. Kapaċi nifhem artikli speċjalizzati u struzzjonijiet tekniċi twal anke meta dawn m’għandhomx x’jaqsmu mal-linja tiegħi.</td>
		<td>Kapaċi nesprimi ruħi b’mod mexxej u spontanju mingħajr ħafna tlaqliq biex insib il-kelma. Kapaċi nuża l-lingwa b’mod flessibli u effettiv għal skopijiet soċjali u professjonali. Kapaċi nifformula ideat u opinjonijiet bi preċiżjoni u norbot b’sengħa l-kontribut tiegħi ma’ dawk ta’ kelliema oħra.</td>
		<td>Kapaċi nagħti deskrizzjonijiet ċari u dettaljati ta’ suġġetti kumplessi u ninkorpora temi sekondarji niżviluppa partikolari u nagħlaq b’mod adattat.</td>
		<td>Kapaċi nesprimi ruħi b’testi ċari u strutturati u li jesprimu opinjonijiet fit-tul. Kapaċi nikteb dwar suġġetti kumplessi f’ittra, esej jew f’rapport u nagħmel enfasi dwar x’inqis li jkunu l-punti ewlenin. Kapaċi nagħżel stil tajjeb għall-qarrej konċernat.</td>
	</tr>
	<tr class="level">
		<th>C2</th>
		<td>Ma nsib l-ebda diffikultà biex nifhem kull lingwa mitkellma sew jekk tkun diretta jew imxandra, anke jekk mitkellma bħala lingwa nattiva b’mod mgħaġġel sakemm ikolli ftit taż-żmien biex nidra l-aċċent.</td>
		<td>Kapaċi naqra faċilment kull forma tal-lingwa mitkellma nkluż testi astratti u kumplessi fl-istruttura u fil-lingwa bħal f’&apos;manwali, artikli speċjalizzati u xogħlijiet letterarji.</td>
		<td>Kapaċi nipparteċipa bla edba sforz żejjed f’kull konverżazzjoni jew diskussjoni u jkolli ħakma tajba ta’ l-espressjonijiet idjomatiċi u tal-lingwa mitkellma. Kapaċi nesprimi ruħi b’mod mexxej u nagħti tifsiriet preċiżi ħafna billi nirristruturha b’mod li ħadd ma jinduna. Jekk insib xi problema naf insib tarfha.</td>
		<td>Kapaċi noffri deskrizzjoni jew argument b’mod ċar u mexxej fl-istil xieraq għall-kuntest u bi struttura effettiva u loġika li tgħin lis-semmiegħ biex jagħraf u jiftakar il-punti l-aktar importanti.</td>
		<td>Kapaċi nikteb test ċar u mexxej bi stil adattat. Kapaċi nikteb ittri kumplessi, rapporti jew artikli li jippreżentaw każ, bi struttura effettiva u loġika li tgħin lill-qarrej jinnota u jiftakar l-punti mportanti. Kapaċi nikteb taqsiriet u xogħlijiet professjonali jew letterarji.</td>
	</tr>
</table>
</xsl:if>		
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/cv_verline.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/logo_for_htmlpreview.gif" /> 
		<img style="display: none" src="http://europass.cedefop.europa.eu/instruments/images/bg_win4.jpg" /> 
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
