<?php
/**
 *
 */
session_cache_limiter('none');          //Initialize session
session_start();
$path = "../libraries/";
require_once $path."configuration.php";

header("Cache-Control: no-cache, must-revalidate"); // HTTP/1.1
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past

if (!eF_checkUser($_SESSION['s_login'], $_SESSION['s_password'])) {                                       //Any logged-in user may view an announcement
    eF_printMessage("You must login to access this page");
    exit;
}

try {    
    if (isset($_GET['test_id'])) {
        $test = new EfrontTest($_GET['test_id']);
        $test -> setDone($_GET['user']);
    } else if (isset($_GET['content_id'])) {
        $test = new EfrontTest($_GET['content_id'], true);
        $test -> setDone($_GET['user']);
    } else if (isset($_GET['done_test_id'])) {
        $result = eF_getTableData("done_tests", "tests_ID, users_LOGIN", "id=".$_GET['done_test_id']);
        $test = new EfrontTest($result[0]['tests_ID']); 
        $test -> setDone($result[0]['users_LOGIN']);    
    } else {
        throw new Exception(_INVALIDID);
    }

    //Check if current user is eligible to see this test
    if ($_SESSION['s_type'] != 'administrator') {
        //$currentUser = EfrontUserFactory :: factory($_SESSION['s_login'], false); 
        $result      = eF_getTableData("content", "lessons_ID", "id=".$test -> test['content_ID']);
        $testLesson  = new EfrontLesson($result[0]['lessons_ID']);    
        $lessonUsers = $testLesson -> getUsers();
        if (!in_array($_SESSION['s_login'], array_keys($lessonUsers))) {
            throw new Exception(_YOUARENOTAUTHORISEDTOSEETHISTEST);
        } else if ($lessonUsers[$_SESSION['s_login']]['role'] == 'student' && $_SESSION['s_login'] != $test -> doneInfo['users_LOGIN']) {
            throw new Exception(_YOUARENOTAUTHORISEDTOSEETHISTEST);
        }
    }
    
    if (isset($_GET['reset'])) {            //reset test        
        if (!isset($lessonUsers[$_SESSION['s_login']]['role']) || $lessonUsers[$_SESSION['s_login']]['role'] != 'student') {
            $test -> reset($test -> doneInfo['users_LOGIN']);
        } else {
            if (!$test -> test['redoable'] || $test -> test['redoable'] < $test -> doneInfo['times']) {
                $test -> reset($test -> doneInfo['users_LOGIN']);
            } else {
                throw new Exception(_YOUCANNOTREDOTHISTEST);
            }
        }
    } else {
        $form = new HTML_QuickForm("questionForm", "post", "", "", null, true);		//Create the test form
        $html = $test -> toHTMLQuickForm($form, false, true);
        $smarty -> assign("T_SOLVED_TEST", $html);
        
        $test -> doneInfo['duration'] = eF_convertIntervalToTime($test -> doneInfo['duration']);
        $smarty -> assign("T_TEST", $test);
    }
} catch (Exception $e) {
    $smarty -> assign("T_EXCEPTION_TRACE", $e -> getTraceAsString());
    $message      = _SOMEPROBLEMOCCURED.': '.$e -> getMessage().' ('.$e -> getCode().') &nbsp;<a href = "javascript:void(0)" onclick = "eF_js_showDivPopup(\''._ERRORDETAILS.'\', 2, \'error_details\')">'._MOREINFO.'</a>';
    $message_type = 'failure';
}
$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);
$smarty -> display('view_test.tpl');
    

?>