<?php
/**
 * Platform index page
 *
 * This is the index page, allowing for logging in, registering new users, 
 * contacting and resetting password 
 *
 * @package eFront
 * @version 3.1.1
 */

$debug_TimeStart = microtime(true);

$path = "../libraries/";

if (!is_file($path."configuration.php")) {                        //If the configuration file does not exist, this is a fresh installation, so redirect to installation page 
    is_file("install/install.php") ? header("location:install/install.php") : print('Failed locating configuration file <br/> Failed locating installation directory <br/> Please execute installation script manually <br/>');
    exit;
} else {
    /** Configuration file */
    require_once $path."configuration.php";
}

if (is_dir("install") && isset($_GET['delete_install'])) {
    try {
        $dir = new EfrontDirectory('install');
        $dir -> delete();
    } catch (Exception $e) {
        echo "The installation directory could not be deleted. Please delete it manually or your system security is at risk.";
    }
}

$debug_InitTime = microtime(true) - $debug_TimeStart;

$message = '';$message_type = '';                                                                        //Initialize error messages


if ($configuration['cms_page'] != "" && !isset($_GET['index_efront']) && sizeof($_GET) == 0){            //if there is cms page and no get parameter defined
    header("location:".G_RELATIVEADMINLINK.$configuration['cms_page'].".php");
}

if (isset($_GET['logout']) && !isset($_POST['submit_login'])) {                                                       //If user wants to log out
    session_start();
    if ($_SESSION['s_login']) {
        try {
            $user = EfrontUserFactory :: factory($_SESSION['s_login']);
            $user -> logout();
        } catch (EfrontUserException $e) {
            $message = $e -> getMessage();
        }
    }

    if (isset($_GET['reason']) && $_GET['reason']=='timeout') {
        $message      = _YOUHAVELOGGEDOUTBECAUSEYOURSESSIONHASTIMEDOUT;
        $message_type = 'failure';
    }
}

$language    = $configuration['default_language'];
$bypass_language_str = '';
if (isset($_GET['bypass_language']) && in_array($_GET['bypass_language'], array_keys(EfrontSystem :: getLanguages()))) {                        //Check if another language is specified in the address bar
    $bypass_language_str = '&bypass_language='.$_GET['bypass_language'];
    $language            = $_GET['bypass_language'];
} 
$_SESSION['s_language'] = $language;

/* ---------------------------------------------------------Activation by email part--------------------------------------------------------- */
if (isset($_GET['account']) && isset($_GET['key']) && eF_checkParameter($_GET['account'], 'login') && eF_checkParameter($_GET['key'], 'timestamp')) {
    $result = eF_getTableData("users", "timestamp, active", "login='".$_GET['account']."'");
    if ($configuration['activation'] == 0 && $configuration['mail_activation'] == 1) { 
        if ($result[0]['active'] == 0 && $result[0]['timestamp'] == $_GET['key']) {
            try {
	            $user = EfrontUserFactory :: factory($_GET['account']);//new EfrontUser($_GET['login']);
	            $user -> activate();
	            $message      = _ACCOUNTSUCCESSFULLYACTIVATED;
	            $message_type = 'success';
	            header('location:'.$_SERVER['PHP_SELF'].'?message='.urlencode($message).'&message_type=success'.$bypass_language_str);
            } catch (EfrontException $e) {
	            $message      = _PROBLEMACTIVATINGACCOUNT.': '.$e -> getMessage().' ('.$e -> getCode().')';
	            $message_type = 'failure';                
            }
        }
    } else {
        $message      = _YOUCANNOTACCESSTHISPAGE;
        header('location:'.$_SERVER['PHP_SELF'].'message='.urlencode($message).'&message_type=failure'.$bypass_language_str);
    }

}


/* ---------------------------------------------------------Reset Password part--------------------------------------------------------- */
if (isset($_GET['ctg']) && $_GET['ctg'] == 'reset_pwd') {                                                         //The user asked to display the contact form
    $smarty -> assign('T_CTG', 'reset_pwd');

    $form = new HTML_QuickForm("reset_password_form", "post", $_SERVER['PHP_SELF']."?ctg=reset_pwd".$bypass_language_str, "", null, true);
    $form -> removeAttribute('name');
    $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');           //Register this rule for checking user input with our function, eF_checkParameter

    $form -> addElement('text', 'login_or_pwd', _PLEASEGIVEYOURLOGINOREMAIL, 'class = "inputText"');
    $form -> addRule('login_or_pwd', _THEFIELD.' '._ISMANDATORY, 'required', null, 'client');
    $form -> addRule('login_or_pwd', _INVALIDFIELDDATA, 'checkParameter', 'text');
    $form -> addElement('submit', 'submit_reset_password', _SUBMIT, 'class="flatButton"');

    if ($form -> isSubmitted() && $form -> validate()) {
        $input = $form -> exportValue("login_or_pwd");
        try {
            if (eF_checkParameter($input, 'email')) {                                               //The user entered an email address
                $result = eF_getTableData("users", "login", "email='".$input."'");                  //Get the user stored login
                $user = EfrontUserFactory :: factory($result[0]['login']); 
            } elseif (eF_checkParameter($input, 'login')) {                                         //The user entered his login name
                $user = EfrontUserFactory :: factory($input);        
            } 
            if ($user -> isLdapUser) {
                header('location:'.$_SERVER['PHP_SELF'].'?message='.urlencode(_LDAPUSERMUSTCONTACTADMIN.$GLOBALS['configuration']['system_email']).'&message_type=failure'.$bypass_language_str);
            } else {
                eF_emailPasswordConfirmation($user -> user['email'], $user -> user['login'], $user -> user['name']);
                header('location:'.$_SERVER['PHP_SELF'].'?message='.urlencode(_ANEMAILHASBEENSENT).'&message_type=success'.$bypass_language_str);
            }            
        } catch (Exception $e) {
            $message      = _NONEXISTINGMAIL;
            $message_type = 'failure';
        }        
    } elseif (isset($_GET['id']) && isset($_GET['login'])) {                             //Second stage, user received the email and clicked on the link
        $login = $_GET['login'];
        if (!eF_checkParameter($login, 'login')) {                                      //Possible hacking attempt: malformed user
            $message      = _INVALIDUSER;
            $message_type = 'failure';
        } else {
            $user = eF_getTableData("users", "email, name", "login='".$login."'");
            if (strcmp($_GET['id'], md5($login.G_MD5KEY)) == 0 && sizeof($user) > 0) {
                $password           = mb_substr(md5($login.time()), 0, 8);
                $password_encrypted = md5($password.G_MD5KEY);

                eF_updateTableData("users", array('password' => $password_encrypted), "login='$login'");

                if (eF_emailNewPassword($user[0]['email'], $user[0]['name'], $password)) {
                    $message      = _EMAILWITHPASSWORDSENT;
                    header('location:'.$_SERVER['PHP_SELF'].'?message='.urlencode($message).'&message_type=success'.$bypass_language_str);
                } else {
                    $message      = _THEMAILCOULDNOTBESENDTRYLATER;
                    $message_type = 'failure';
                }

            } else {
                $message      = _INVALIDUSER;
                $message_type = 'failure';
            }
        }
    }

    $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

    $renderer -> setRequiredTemplate(
       '{$html}{if $required}
            &nbsp;<span class = "formRequired">*</span>
        {/if}');

    $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
    $form -> setRequiredNote(_REQUIREDNOTE);
    $form -> accept($renderer);

    $smarty -> assign('T_RESET_PASSWORD_FORM', $renderer -> toArray());

}
/* -------------------------------------------------------End of Reset Password part--------------------------------------------------------- */


/* -----------------------------------------------------Sign up part--------------------------------------------------------- */
if (isset($_GET['ctg']) && ($_GET['ctg'] == "signup") && $configuration['signup']) {
	$users = eF_getTableDataFlat("users", "*");
	$versionDetails = eF_checkVersionKey($configuration['version_key']);

	if (sizeof($users['login']) > $versionDetails['users']) {
        $message      = _USERSEXCEEDED;
        $message_type = 'failure';
        header("location:".$_SERVER['PHP_SELF']."?message=".urlencode($message)."&message_type=$message_type");		
	}

    $smarty -> assign("T_CTG", "signup");

    $form = new HTML_QuickForm("signup_register_personal_form", "post", $_SERVER['PHP_SELF']."?ctg=signup".(isset($_GET['ldap']) ? '&ldap=1' : ''), "", null, true);
    $form -> removeAttribute('name');
    $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');           //Register this rule for checking user input with our function, eF_checkParameter
    $form -> registerRule('checkNotExist', 'callback', 'eF_checkNotExist');             //This rule is using our function, eF_checkNotExist, to ensure that no duplicate values are inserted in unique fields, such as login and email
    
    foreach (EfrontSystem :: getLanguages() as $key => $value) {
        if ($value['active']) {
            $languages[$key] = $value['translation'];
        }
    }
    $form -> addElement('select', 'languages_NAME', _LANGUAGE, $languages, 'class = "inputSelect" onchange = "location = \'index.php?ctg=signup&bypass_language=\'+this.options[this.selectedIndex].value"');     //A select drop down for languages
    if ($_GET['bypass_language']) {
        $form -> setDefaults(array('languages_NAME' => $_GET['bypass_language']));                                       //The default language is also the selected one
    } else {
        $form -> setDefaults(array('languages_NAME' => $GLOBALS['configuration']['default_language']));                                       //The default language is also the selected one
    }
    if ($GLOBALS['configuration']['onelanguage']) {
        $form -> freeze(array('languages_NAME'));
    }
    
    $form -> addElement('text', 'login', _LOGIN, 'class = "inputText"');
    $form -> addRule('login', _THEFIELD.' '._LOGIN.' '._ISMANDATORY, 'required', null, 'client');
    $form -> addRule('login', _THEFIELD.' '._LOGIN.' '._HASINVALIDCHARACTERS.'. '._ONLYALLOWEDCHARACTERSLOGIN, 'checkParameter', 'login');
    $form -> addRule('login', _THELOGIN.' &quot;'.($form -> exportValue('login')).'&quot; '._ALREADYEXISTS, 'checkNotExist', 'login');

    $form -> addElement(isset($_GET['ldap']) ? 'text' : 'password', 'password', _PASSWORD, 'class = "inputText "');
    $form -> addElement(isset($_GET['ldap']) ? 'text' : 'password', 'passrepeat', _REPEATPASSWORD, 'class = "inputText "');
    $form -> addRule('password', _THEFIELD.' '._PASSWORD.' '._ISMANDATORY, 'required', null, 'client');
    $form -> addRule('passrepeat', _THEFIELD.' '._REPEATPASSWORD.' '._ISMANDATORY, 'required', null, 'client');
    $form -> addRule(array('password', 'passrepeat'), _PASSWORDSDONOTMATCH, 'compare', null, 'client');

    $form -> addElement('text', 'firstName', _FIRSTNAME, 'class = "inputText "');
    $form -> addRule('firstName', _THEFIELD.' '._FIRSTNAME.' '._ISMANDATORY, 'required', null, 'client');
    $form -> addRule('firstName', _THEFIELD.' '._FIRSTNAME.' '._HASINVALIDCHARACTERS.'. '._ONLYALLOWEDCHARACTERSTEXT, 'checkParameter', 'text');

    $form -> addElement('text', 'lastName', _LASTNAME, 'class = "inputText "');
    $form -> addRule('lastName', _THEFIELD.' '._LASTNAME.' '._ISMANDATORY, 'required', null, 'client');
    $form -> addRule('lastName', _THEFIELD.' '._LASTNAME.' '._HASINVALIDCHARACTERS.'. '._ONLYALLOWEDCHARACTERSTEXT, 'checkParameter', 'text');

    $form -> addElement('text', 'email', _EMAILADDRESS, 'class = "inputText "');
    $form -> addRule('email', _THEFIELD.' '._EMAILADDRESS.' '._ISMANDATORY, 'required', null, 'client');
    $form -> addRule('email', _THEFIELD.' '._EMAILADDRESS.' '._HASINVALIDCHARACTERS.'. '._ONLYALLOWEDCHARACTERSTEXT, 'email', null, 'client');
    $form -> addRule('email', _THEEMAIL.' &quot;'.($form -> exportValue('email')).'&quot; '._ALREADYEXISTS, 'checkNotExist', 'email');

    $user_profile = eF_getTableData("user_profile", "*", "active=1");    //Get admin-defined form fields for user registration

    foreach ($user_profile as $field) {                             //Add custom fields, defined in user_profile database table
        $userProfileFields[] = $field['name'];
        if ($field['type'] == 'select') {
            $options = unserialize($field['options']);
            $form -> addElement('select', $field['name'], $field['description'], array_combine($options, $options), 'class = " inputSelect"');
        } else {
            $form -> addElement('text', $field['name'], $field['description'], 'class = " inputText"');
        }
        if ($field['mandatory']) {
            $form -> addRule($field['name'], _THEFIELD.' '.$field['description'].' '._ISMANDATORY, 'required', null, 'client');
        }
        if ($field['default_value']) {
            $form -> setDefaults(array($field['name'] => $field['default_value']));
        }
    }

    $smarty -> assign("T_USER_PROFILE_FIELDS", $userProfileFields);

    $element =& $form -> addElement('textarea', 'comments', _COMMENTS, '"class = inputTextarea" style = "width:95%"');
    $element -> setCols(40);
    $element -> setRows(2);
    $form -> addElement('submit', 'submit_register', _REGISTER, 'class=flatButton');

/*    
    $form -> addElement('textarea', 'terms', _TERMS, array("class" => "inputTextarea", "eadonly" => "readonly", "style" => "width:95%"));  //Terms of usage is a readonly textarea
    $form -> setDefaults(array('terms' => _DEFAULTTERMSOFUSAGE));                                           //Display terms of usage
    $form -> addElement('checkbox', 'accept_terms', _ACCEPTTERMS);
    $form -> addRule('accept_terms', _YOUMUSTAGREEWITHTERMSOFUSAGETOCONTINUE, 'required', null, 'client');

    $directions = eF_getTableData("directions", "*", "active=1");                                           //Get directions
    foreach ($directions as $direction) {                                                                   //Recursively add checkboxes corresponding to lessons
        $lessons = eF_getTableData("lessons", "*", "languages_NAME = '$language' and directions_ID=".$direction['id']);
        if (sizeof($lessons) > 0) {
            foreach ($lessons as $lesson) {
                $form -> addElement('checkbox', 'lessons['.$direction['name'].']['.$lesson['id'].']', $lesson['name'], '', 'class = "inputCheckbox"');
                $lessons_info[$lesson['id']] = array('name' => $lesson['name'], 'price' => $lesson['price'], 'info' => $lesson['info']);        //Will be used to display information about the lesson, next to its name
            }
        }
    }
    $smarty -> assign("T_LESSONS_INFO", $lessons_info);
*/     

    if (isset($_GET['ldap'])) {
        $result = eF_getLdapValues($GLOBALS['configuration']['ldap_uid'].'='.$_GET['login'], array($GLOBALS['configuration']['ldap_preferredlanguage'],
                                                                                                   $GLOBALS['configuration']['ldap_mail'],
                                                                                                   $GLOBALS['configuration']['ldap_cn'],
                                                                                                   $GLOBALS['configuration']['ldap_uid']));
        $name_parts = explode(" ", $result[0]['cn'][0]);
        $first_name = array_shift($name_parts);
        sizeof($name_parts) == 0 ? $last_name = $first_name : $last_name = implode(" ", $name_parts);
        $form -> setDefaults(array("login"      => $_GET['login'],
                                   "password"   => _LDAPACCOUNTPASSWORD,
                                   "passrepeat" => _LDAPACCOUNTPASSWORD,
                                   "email"      => $result[0]['mail'][0],
                                   "firstName"  => $first_name,
                                   "lastName"   => $last_name));
        $form -> freeze(array('login', 'password', 'passrepeat'));
    } elseif ($configuration['only_ldap']) {
        $message      = _ONLYLDAPREGISTRATIONPERMITTED;
        $message_type = 'failure';
        header("location:".$_SERVER['PHP_SELF']."?message=".urlencode($message)."&message_type=$message_type");
    }

    if ($form -> isSubmitted()) {
        if ($form -> validate()) {
            if (isset($_SESSION['s_login'])) {                                          //A logged-in user wants to signup: Log him out first
				$user = EfrontUserFactory :: factory($_SESSION['s_login']);
				$user -> logout();
            }

            $values = $form -> exportValues();                                          //Get the form values

            $user_data = array("login"          => $values['login'],
                               "password"       => isset($_GET['ldap']) ? 'ldap' : $values['password'],
                               "name"           => $values['firstName'],
                               "surname"        => $values['lastName'],
                               "email"          => $values['email'],
                               "comments"       => $values['comments'],
                               "languages_NAME" => $values['languages_NAME']);
            foreach ($user_profile as $field) {                                         //Get the custom fields values
                $user_data[$field['name']] = $values[$field['name']];
            }
            if (eF_registerUser($user_data, $configuration['activation'], isset($_GET['ldap']) ? true : false)) {        //First try to register user
                /*
                 foreach ($values['lessons'] as $direction => $lessons) {        //Insert all the lessons
                 foreach($lessons as $lesson_id => $lesson) {
                 $lesson_registrations = array("users_LOGIN"    => $values['login'],
                 "lessons_ID"     => $lesson_id,
                 "from_timestamp" => time());
                 $lessons_info[$lesson_id]['price'] == 0 ? $lesson_registrations['active'] = 1 : $lesson_registrations['active'] = 0;  //If the lesson is free, then automatically activate the enrollment; otherwise, user will wait for the administrator to confirm the enrollment

                 eF_insertTableData("users_to_lessons", $lesson_registrations);
                 $lessons_selection = $lessons_info[$lesson_id];                         //Geather the lessons selected for registration, so the list can be emailed to the user and the administrator
                 }
                 }
                 */
                eF_mailRegister($values['email'],   $user_data, $lessons_selection, $configuration['activation']);
                eF_mailRegister(eF_getAdminEmail(), $user_data, $lessons_selection, $configuration['activation']);
                
                if ($configuration['activation'] == 0) {
	                if ($configuration['mail_activation'] == 1){
	                    $tmp            = eF_getTableData("users","timestamp","login='".$user_data['login']."'");
	                    $timestamp      = $tmp[0]["timestamp"];
	                    $subject_nonutf = _ACCOUNTACTIVATIONMAILSUBJECT;
	                    $subject        = mb_convert_encoding($subject_nonutf,'UTF-8');
	                    $body           = _DEARUSER." ".$user_data['login'].",\r\n\r\n"._ACCOUNTACTIVATIONMAILBODY."\r\n<a href=\"".G_SERVERNAME."index.php?account=".$user_data['login']."&key=".$timestamp."\">".G_SERVERNAME."index.php?account=".$user_data['login']."&key=".$timestamp."</a>\r\n";
	                    eF_mail($configuration['system_email'],$user_data['email'],$subject,$body,false,true);
	
	                    $message = _YOUWILLRECEIVEMAILFORACCOUNTACTIVATION;
	                    header('location:'.$_SERVER['PHP_SELF'].'?message='.$message.'&message_type=success'.$bypass_language_str);
	                } else{
	                    $message = _ADMINISTRATORWILLACTIVATEYOURACCOUNT;
	                    header('location:'.$_SERVER['PHP_SELF'].'?message='.$message.'&message_type=success'.$bypass_language_str);
	                }
                } else {
                    $message = _SUCCESSREGISTER;
                    header('location:'.$_SERVER['PHP_SELF'].'?message='.$message.'&message_type=success'.$bypass_language_str);
                }

            } else {
                $message      = _REGISTRATIONFAILEDCONTACTADMIN;
                $message_type = 'failure';
            }
        }
    }

    $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

    $renderer -> setRequiredTemplate(
       '{$html}{if $required}
            &nbsp;<span class = "formRequired">*</span>
        {/if}'
        );

        $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
        $form -> setRequiredNote(_REQUIREDNOTE);
        $form -> accept($renderer);

        $smarty -> assign('T_PERSONAL_INFO_FORM', $renderer -> toArray());
}
/* --------------------------------------------------- End of Sign up part--------------------------------------------------- */

/* -------------------------------------------------------Contact part--------------------------------------------------------- */
if (isset($_GET['ctg']) && $_GET['ctg'] == 'contact') {                                                         //The user asked to display the contact form
    $smarty->assign('T_CTG', 'contact');

    $form = new HTML_QuickForm("contact_form", "post", $_SERVER['PHP_SELF']."?ctg=contact", "", null, true);
    $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');           //Register this rule for checking user input with our function, eF_checkParameter

    $form -> addElement('text', 'email', _YOUREMAIL, 'class = "inputText"');
    $form -> addRule('email', _THEFIELD.' "'._EMAIL.'" '._ISMANDATORY, 'required');
    $form -> addRule('email', _INVALIDFIELDDATA, 'checkParameter', 'email');

    $form -> addElement('text', 'message_subject', _MESSAGESUBJECT, 'class = "inputText"');
    $form -> addRule('message_subject', _INVALIDFIELDDATA, 'checkParameter', 'text');

    $form -> addElement('textarea', 'message_body', _TEXT, "class = inputTextarea_Contact");
    //$form -> setDefaults(array('message_body' => _DEFAULTCONTACTMESSAGE));                                           //Display default contact message
    $form -> addElement('submit', 'submit_contact', _SUBMIT, 'class=flatButton');

    if ($form -> isSubmitted()) {
        if ($form -> validate()) {
            $to      = $form -> exportValue("email");
            $subject = $form -> exportValue("message_subject");
            $body    = $form -> exportValue("message_body");
            if (eF_mail(eF_getAdminEmail(), $to, $subject." ["._FROM.": ".$sender."]", $body,false,true)) {
                $message      = _SENDSUCCESS;
                $message_type = 'success';
                header('location:'.$_SERVER['PHP_SELF'].'?message='.$message.'&message_type='.$message_type);
            } else {
                $message      = _SENDFAILURE;
                $message_type = 'failure';
            }
        }
    }

    $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

    $renderer -> setRequiredTemplate(
       '{$html}{if $required}
            &nbsp;<span class = "formRequired">*</span>
        {/if}');

    $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
    $form -> setRequiredNote(_REQUIREDNOTE);
    $form -> accept($renderer);

    $smarty -> assign('T_CONTACT_FORM', $renderer -> toArray());
}


/* -------------------------------------------------------End of Contact part--------------------------------------------------------- */

/* -------------------------------------------------------Login part-------------------------------------------------------------------*/

if (!isset($_GET['ctg']) || (isset($_GET['ctg']) && ($_GET['ctg'] == 'reset_pwd' || $_GET['ctg'] == 'signup' || $_GET['ctg'] == 'contact' || $_GET['ctg'] == 'news'))) {
    if (isset($_COOKIE['cookie_login']) && isset($_COOKIE['cookie_password'])) {
	    try {
	        $user = EfrontUserFactory :: factory($_COOKIE['cookie_login']);//new EfrontUser($_COOKIE['cookie_login']);
	        $user -> login($_COOKIE['cookie_password'], true);
	        header("location:".$user -> user['user_type']."page.php");
	        exit;
	    } catch (EfrontUserException $e) {}
	}    
	if (!isset($_GET['ctg'])) {
		$smarty -> assign('T_CTG', 'login');
	}

    $forml = new HTML_QuickForm("login_form", "post", $_SERVER['PHP_SELF']."?index_efront", "", null, true);
    $forml -> removeAttribute('name');
    $forml -> registerRule('checkParameter', 'callback', 'eF_checkParameter');           //Register this rule for checking user input with our function, eF_checkParameter

    $forml -> addElement('text', 'login', _LOGIN, 'class = "inputText"');
    $forml -> addRule('login', _THEFIELD.' "'._LOGIN.'" '._ISMANDATORY, 'required', null, 'client');
    $forml -> addRule('login', _YOUCANNOTLOGINAS, 'checkParameter', 'login');

    $forml -> addElement('password', 'password', _PASSWORD, 'class = "inputText"');
    $forml -> addRule('password', _THEFIELD.' "'._PASSWORD.'" '._ISMANDATORY, 'required', null, 'client');
    
    $forml -> addElement('checkbox', 'remember', _REMEMBERME, "", 'class = "inputCheckbox"');
    $forml -> addElement('submit', 'submit_login', _ENTER, 'class=flatButton');

    $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

    $forml -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
    $forml -> setRequiredNote(_REQUIREDNOTE);
    $forml -> accept($renderer);

    $smarty -> assign('T_LOGIN_FORM', $renderer -> toArray());

    if ($forml -> isSubmitted() && $forml -> validate()) {
        try {
            $user = EfrontUserFactory :: factory($forml -> exportValue('login'));
            $user -> login($forml -> exportValue('password'));
	        if ($forml -> exportValue('remember')) {                                                             //The user asked to remeber login (it is implemented with cookies)
	            $expire = time() + 30 * 86400;                                                                  //1 month
	            setcookie("cookie_login",    $_SESSION['s_login'],    $expire);
	            setcookie("cookie_password", $_SESSION['s_password'], $expire);
	        } else {
	            setcookie("cookie_login",    '', time() - 3600);
	            setcookie("cookie_password", '', time() - 3600);
	        }
	        header("location:".$user -> user['user_type']."page.php");
	        exit;       
        } catch (EfrontUserException $e) {
            if ($GLOBALS['configuration']['activate_ldap']) {
                if (!extension_loaded('ldap')) {
                    $message      = $e -> getMessage().'<br/>'._LDAPEXTENSIONNOTLOADED;
                    $message_type = 'failure';
                } else {
                    $result = eF_checkUserLdap($forml -> exportValue('login'), $forml -> exportValue('password'));
                    if ($result) {                                                //The user exists in the LDAP server 
                        header("location:index.php?ctg=signup&ldap=1&login=".$forml -> exportValue('login'));
                    } else if ($result === 0) {                                    //false means that this user does not exist, and 0 means that the user exists but the password is invalid
                        $message = _INVALIDPASSWORD;
                        $message_type = 'failure';
                    } else {
                        $message      = $e -> getMessage();
                        $message_type = 'failure';
                    }
                }
            } else {
                $message      = $e -> getMessage();
                $message_type = 'failure';
            }
        }
    }

}

/* -----------------End of Login part-----------------------------*/

$_SESSION['s_type'] = "index";

$smarty -> assign('T_MESSAGE', $message);
$smarty -> assign('T_MESSAGE_TYPE', $message_type);

try {
    $logoFile = new EfrontFile($configuration['logo']);
    $smarty -> assign("T_LOGO", 'logo/'.$logoFile['physical_name']);
} catch (EfrontFileException $e) {
    $smarty -> assign("T_LOGO", "logo.png");
}

$smarty -> assign('T_LDAPSUPPORT', $configuration['activate_ldap']);
$smarty -> assign('T_ONLY_LDAP', $configuration['only_ldap']);
$smarty -> assign('T_EXTERNALLYSIGNUP', $configuration['signup']);
$smarty -> assign("T_BYPASSLANG", $bypass_language_str);

if (strlen($configuration['css']) > 0 && is_file(G_CUSTOMCSSPATH.$configuration['css'])) {                //Load custom css, if one exists
    $smarty -> assign("T_CUSTOM_CSS", $configuration['css']);
}

$debug_timeBeforeSmarty = microtime(true) - $debug_TimeStart;

if ($configuration['lessons_directory'] == '2') {				//if admin selects to show directory on login page
	$smarty -> assign('T_SHOW_DIRECTORY', '1');
} else {
	$smarty -> assign('T_SHOW_DIRECTORY', '0');
}

if ($configuration['interface_view'] == '2' && !isset($_SESSION['s_login'])) {
	include_once "directory.php";
	$smarty -> display('directory.tpl');
} else {
	$smarty -> display('index.tpl');
}
$debug_timeAfterSmarty = microtime(true) - $debug_TimeStart;

$debug_TotalTime = microtime(true) - $debug_TimeStart;

if (G_DEBUG) {
    echo "
    <div onclick = 'this.style.display=\"none\"' style = 'position:absolute;top:0px;right:0px;background-color:lightblue;border:1px solid black' >
    <table> 
        <tr><th colspan = '100%'>Benchmarking info (click to remove)</th></tr>
        <tr><td>Initialization time: </td><td>".round($debug_InitTime, 5)." sec</td></tr>
        <tr><td>Time up to smarty: </td><td>".round($debug_timeBeforeSmarty, 5)." sec</td></tr>
        <tr><td>Database time: </td><td>".round($databaseTime, 5)." sec</td></tr>
        <tr><td>Smarty overhead: </td><td>".round($debug_timeAfterSmarty - $debug_timeBeforeSmarty, 5)." sec</td></tr>
        <tr><td colspan = \"2\" class = \"horizontalSeparator\"></td></tr>
        <tr><td>Total execution time: </td><td>".round($debug_TotalTime, 5)." sec</td></tr>
        <tr><td>Execution time for this script is: </td><td>".round($debug_TotalTime - $debug_InitTime - ($debug_timeAfterSmarty - $debug_timeBeforeSmarty), 5)." sec</td></tr>
    </table>
    </div>";
}

?>
