<?php
/**
* Smarty plugin: smarty_function_eF_template_printInnerTable function. Prints inner table
*
* $params is an array with fields: title, data, image, navigation (optional), is_last (optional)
* $params['data'] is plain html
*/
function smarty_function_eF_template_printInnerTable($params, &$smarty) {
    if (!$params['data'] && isset($params['alt'])) {
        $params['data'] = $params['alt'];
    }

    $str = '
        <table class = "innerTable">
            <tr class="handle">
                <th class = "innerTableHeader">
                    <img class = "iconTableImage" src="';
                    if (!isset($params['absoluteImagePath'])) {
                        $str .= 'images/';
                    } else {
                        $str .= '';//'file:///';
                    }
                    $str .= $params['image'].'" title="'.$params['title'].'" alt="'.$params['title'].'"/>&nbsp;';
            if (isset($params['link']) && sizeof($params['link']) > 0){
                if ($params['titleStyle']) {
                    $str.= '<a href="'.$params['link'].'"><span style="'.$params['titleStyle'].'" >'.$params['title'].'</span></a></th>';
                } else {
                    $str.= '<a href="'.$params['link'].'">'.$params['title'].'</a></th>';
                }
            }
            else{
                if ($params['titleStyle']) {
                    $str .= '<span style="'.$params['titleStyle'].'" >'.$params['title'].'</span></a></th>';
                } else {
                    $str.= $params['title'].'</a></th>';
                }
            }
            $str .= '<td class = "innerTableTd" align="right">';
            if (isset($params['options'])) {
                foreach($params['options'] as $key => $value) {
                    if(isset($value['class']) && $value['class'] != '') {
                        $classstr = '"optionsIcons '.$value['class'].'"';
                    } else {
                        $classstr = "optionsIcons";
                    }
                    isset($value['target']) ? $target = 'target = "'.$value['target'].'"' : $target = '';
                    $str .= '<a href="'.$value['href'].'" ';
                    if ($value['id']) {
                        $str .= ' id = "'.$value['id'].'" ';
                    }
                    $str .= 'onclick="'.$value['onClick'].'" '.$target.'><img border="0" class="'.$classstr.'" src="images/'.$value['image'].'" title="'.$value['text'].'" alt="'.$value['text'].'"></a>';
                }
            }

            if (strpos($params['data'], "empty_category") == false) {
                $str .= '<img src = "images/others/blank.gif" class = "minus" onclick="toggleVisibility(document.getElementById(\''.$params['title'].'_tableId\'),this)"/>';
            }
            $str .= '</td></tr>
            <tr><td colspan = "3" class = "horizontalSeparator"></td></tr>';

            $optionsStr = '';
            if (isset($params['main_options'])) {
                foreach ($params['main_options'] as $key => $value) {
                    $key > 0 ? $style = 'border-left:1px solid black;' : $style = '';
                    $value['selected'] ? $style .= 'background-color:#D3D3D3;font-weight:bold;' : null;
                    $optionsStr.= '
                        <td style = "white-space:nowrap;'.$style.'">&nbsp;
                            <a href = "'.$value['link'].'"><img src = "images/'.($value['image'] ? $value['image'] : '16x16/arrow_right_blue.png').'" style = "vertical-align:middle" border = "0"/></a>
                            <a href = "'.$value['link'].'" style = "vertical-align:middle" class = "'.$value['class'].'">'.$value['title'].'</a>&nbsp;
                        </td>';
                }
                $str .= '
                        <tr><td colspan = "3" class = "horizontalSeparator">
                                <table>
                                    <tr>'.$optionsStr.'</tr>
                                </table>
                            </td></tr>';

            }

            if($params['data'] != ""){
                $str .= '
            <tr><td colspan = "3" id = "'.$params['title'].'_tableId">'.$params['data'].'</td></tr>';
            } else {
                $str .= '
            <tr><td colspan = "3" class = "emptyCategory">'._NOCONTENTFOUND.'</td></tr>';
            }
      /*$str .= (isset($params['navigation']) ? '
            <tr><td colspan = "3">'.$params['navigation'].'</td></tr>' : '').''.(!isset($params['is_last']) ? '
            <tr><td colspan = "3">&nbsp;</td></tr>'                    : '').'
        </table>';*/  //backup for a while
     $str .= (isset($params['navigation']) ? '
            <tr><td colspan = "3">'.$params['navigation'].'</td></tr>' : '').''.(!isset($params['is_last']) ? '
            '                    : '').'
        </table>';

    return $str;
}

?>