<?php
/**
* Smarty plugin: smarty_function_eF_template_printIconTable function. Prints a table with icons and descriptions
*
* $params is an array with fields: title, columns, links, image
* $params['links'] is an array with fields: text, image
*/
function smarty_function_eF_template_printIconTable($params, &$smarty) {

    $str = '
        <table class = "iconTable">
            <tr class = "handle"> 
                <th class = "iconTableHeader" colspan = "'.$params['columns'].'" >
            		<img class = "iconTableImage" src = "images/'.$params['image'].'" title = "'.$params['title'].'" alt = "'.$params['title'].'"/>&nbsp;'.$params['title'].'
            	</th></tr>
        	<tr><td colspan = "'.$params['columns'].'" class = "horizontalSeparator"></td></tr>';
    
    $optionsStr = '';
    if (isset($params['options'])) {
        foreach ($params['options'] as $key => $value) {
            $key > 0 ? $style = 'border-left:1px solid black;' : $style = '';
            $value['selected'] ? $style .= 'background-color:#D3D3D3;font-weight:bold;' : null;
            $optionsStr.= '
                    	<td style = "white-space:nowrap;'.$style.'">&nbsp;
                        	<a href = "'.$value['link'].'"><img src = "images/'.($value['image'] ? $value['image'] : '16x16/arrow_right_blue.png').'" style = "vertical-align:middle" border = "0"/></a>
                        	<a href = "'.$value['link'].'" style = "vertical-align:middle" class = "'.$value['class'].'">'.$value['title'].'</a>&nbsp;
                        </td>';
        }
	    $str .= '
	    		<tr><td colspan = "'.$params['columns'].'" class = "horizontalSeparator" >
	    				<table>
	    					<tr><td style = "white-space:nowrap;">'.$optionsStr.'</td></tr>
	    				</table>
	    			</td></tr>';
    }
    $str .= '
        	<tr>';
    $counter = 1;
    foreach($params['links'] as $key => $value) {
        $str .= '
	        	<td class = "'.(isset($value['class']) && $value['class']=='inactiveLink' ? 'emptyIconTableTD' : 'iconTableTD').'" style = "width:'.(100 / $params['columns']).'%">
			        <a href = "'.$value['href'].'" class = "'.$value['class'].'" title = "'.$value['title'].'" onclick = "'.$value['onClick'].'" '.(isset($value['target']) ? 'target = "'.$value['target'].'"' : '').' style = "'.$value['style'].'">
				        <img border = "0" src = "images/'.$value['image'].'" alt = "'.$value['title'].'" title = "'.$value['title'].'"/><br clear = "all"/>'.$value['text'].'
				    </a></td>';
        if ($counter++ % $params['columns'] == 0) {
            $str .= '
	        </tr><tr>';
        }
    }

    for ($i = $counter; $counter < $i && $i % $params['columns'] != 1; $i++) {
        $str .= '
    	    	<td class = "emptyIconTableTD">&nbsp;</td>';
    }
    $str .= '
        	</tr>
        </table>'; 
    
    return $str; 
}

?>