<?php
/**
* System announcements popup
* 
* This page is used as a popup to show, update, insert or delete a system announcement.
* @package efront
* @version 1.0
*/

//   .
session_cache_limiter('none');
session_start();

$path = "../libraries/";

/**   .*/
include_once $path."configuration.php";


//error_reporting(E_ALL);
//pr($_GET);pr($_POST);

if (isset($_GET['op']) && eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']) != "administrator") {         //Only a professor may perform operations (insert, change, delete)
    eF_printMessage("You must be an administrator in order to perform this action");
    exit;
} elseif (!eF_checkUser($_SESSION['s_login'], $_SESSION['s_password'])) {                                       //Any logged-in user may view an announcement
    eF_printMessage("You must login to access this page");
    exit;
}
    
if (isset($_GET['id'])) {
    $id = eF_checkParameter($_GET['id'], 'uint');
    if ($id === false || !isset($_GET['id'])) {
        eF_printMessage(_INVALIDID);
        exit;
    }
}

if (isset($_GET['op']) && $_GET['op'] == "delete") {
    eF_deleteTableData("system_announcements", "id=".$id);
    $message      = _SUCCESFULLYDELETEDANNOUNCEMENTWINDOWCLOSE5SECONDS;
    $message_type = 'success';
} elseif(isset($_GET['op']) && ($_GET['op'] == 'insert' || $_GET['op'] == 'change')) {
    $load_editor = true;
    
    if (isset($_GET['op']) && $_GET['op'] == 'change' && isset($id)) {
        $form = new HTML_QuickForm("change_system_annoucement_form", "post", $_SERVER['PHP_SELF']."?op=change&id=$id", "", null, true);
    } else {
        $form = new HTML_QuickForm("add_system_annoucement_form", "post", $_SERVER['PHP_SELF']."?op=insert", "", null, true);
    }
    $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');           //Register this rule for checking user input with our function, eF_checkParameter

    $form -> addElement('text', 'title', _ANNOUNCEMENTTITLE, 'class = "inputText"');    
    $form -> addRule('title', _THEFIELD.' '._ISMANDATORY, 'required', null, 'client');
    $form -> addRule('title', _INVALIDFIELDDATA, 'checkParameter', 'text');

    $form -> addElement('textarea', 'data', _ANNOUNCEMENTBODY, 'class = "simpleEditor inputTextArea"');
    $form -> addElement('submit', 'submit_news', _ANNOUNCEMENTADD, 'class = "flatButton"');

    if (isset($_GET['op']) && $_GET['op'] == 'change' && isset($id)) {
        $news_content = eF_getTableData("system_announcements", "*", "id=".$id);
        $form -> setDefaults(array('title' => $news_content[0]['title'], 'data' => $news_content[0]['data']));
    }

    if ($form -> isSubmitted()) {
        if ($form -> validate()) {
            if (isset($_GET['op']) && $_GET['op'] == 'change' && isset($id)) {
                $news_content = array("title" => $form -> exportValue('title'),
                                      "data"  => $form -> exportValue('data'));

                if (eF_updateTableData("system_announcements", $news_content, "id=".$id)) {
                    $message      = _SUCCESFULLYUPDATEDANNOUNCEMENTWINDOWCLOSE5SECONDS;
                    $message_type = 'success';
                } else {
                    $message      = _SOMEPROBLEMEMERGED;
                    $message_type = 'failure';
                }
            } elseif (isset($_GET['op']) && $_GET['op'] == 'insert') {
                $news_content = array("title"       => $form -> exportValue('title'),
                                      "data"        => $form -> exportValue('data'),
                                      "timestamp"   => time(),
                                      "users_LOGIN" => $_SESSION['s_login']);

                if (eF_insertTableData("system_announcements", $news_content)) {
                    $message      = _SUCCESFULLYADDEDANNOUNCEMENTWINDOWCLOSE5SECONDS;
                    $message_type = 'success';
                } else {
                    $message      = _SOMEPROBLEMEMERGED;
                    $message_type = 'failure';
                }
            }
        }
    }

    $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

    $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
    $form -> setRequiredNote(_REQUIREDNOTE);
    $form -> accept($renderer);

    $smarty -> assign('T_NEWS_FORM', $renderer -> toArray());    
} else {
    $announcement = eF_getTableData("system_announcements", "*", "id=".$id);
    if (sizeof($announcement) > 0) {
        $smarty -> assign("T_ANNOUNCEMENT", $announcement[0]);
    } else {
        $message      = 'This system announcement does not exist';
        $message_type = 'failure';
    }
}

$smarty -> assign("T_LESSON_NAME", eF_getLessonName());

$smarty -> assign("T_HEADER_CSS", eF_getCustomCss());
$smarty -> assign("T_HEADER_EDITOR", $load_editor);
$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);

$smarty -> display("system_announcements.tpl");

?>