<?php
/**
* Sidebar frame
*
* This page is used as the leftmost frame, which is the menu bar
* @package efront
* @version 1.0
*/

//---------------------------------------------Initialization-------------------------------------------------
session_cache_limiter('none');
session_start();

$path = "../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";

//eF_clearSessions();

if (isset($_SESSION['s_login'])) {
    $user_type_ret = eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']);
}

/******************** DISCOVER YOUR ROLE IN THE HIERARCHY ********/
if(MODULE_HCD_INTERFACE && $_SESSION['s_type'] != "administrator") {
    $supervisor_at_branches = eF_getTableDataFlat("module_hcd_employee_works_at_branch", "branch_ID","users_login = '" .$_SESSION['s_login']. "' AND supervisor='1'");
// pr($supervisor_at_branches);
    if (!empty($supervisor_at_branches)) {
         $_SESSION['employee_type'] = _SUPERVISOR;
         $_SESSION['supervises_branches'] = implode(",",$supervisor_at_branches['branch_ID']);
    } else {
        $_SESSION['employee_type'] = _EMPLOYEE;
    }
}

if (!isset($_SESSION['s_login']) || ($user_type_ret != "student" && $user_type_ret != "professor" && $user_type_ret != "administrator") ) {  //Must be a user of any type to access this page
    header("location:index.php");
    exit;
}

$css = $configuration['css'];
if (strlen($css) > 0 && is_file(G_CUSTOMCSSPATH.$css)){
    $smarty->assign("T_CUSTOM_CSS",$css);
}

eF_setRoleParameters();
/**Search module is used to display the search field and perform the searches*/
include "module_search.php";
//---------------------------------------------End of Initialization-------------------------------------------------

if (isset($_GET['ctg']) && $_GET['ctg'] == 'users' && $user_type_ret == 'administrator') {//manos lines.. avatar problem in admin
    $ctg = 'users';
} else if ($user_type_ret == 'administrator' && !isset($_GET['ctg'])) {
    $ctg = 'control_panel';
} else if (isset($_GET['ctg'])){
    $ctg = $_GET['ctg'];
}

/*
isset($_GET['ctg']) ? $ctg = $_GET['ctg'] : $ctg = 'lessons';          //Initialize category variable
if ($_SESSION['s_type'] != 'administrator') {
    if (isset($_GET['lessons_ID']) && $_GET['lessons_ID'] != $_SESSION['s_lessons_ID'] && eF_checkParameter($_GET['lessons_ID'], 'id')) {               //The user asked for another lesson

        $lessons_list = eF_getTableData("users_to_lessons,lessons", "lessons.id", "users_to_lessons.users_LOGIN='".$_SESSION['s_login']."' AND users_to_lessons.active=1 AND lessons.id=users_to_lessons.lessons_ID AND lessons.languages_NAME='".$_SESSION['s_language']."' AND lessons.active=1");         //Get the lessons where this user is enrolled

        $_SESSION['s_lessons_ID'] = $_GET['lessons_ID'];                //Set the current lesson to the new one
    //echo "ssssssss";
        //eF_local_setLessonParameters();
    } elseif (!isset($_SESSION['s_lessons_ID']) || $_SESSION['s_lessons_ID'] == '') {                            //The user just entered the system or sees the lessons list
        $lessons_list = eF_getTableData("users_to_lessons,lessons", "lessons.id", "users_to_lessons.users_LOGIN='".$_SESSION['s_login']."' AND users_to_lessons.active=1 AND lessons.id=users_to_lessons.lessons_ID AND lessons.languages_NAME='".$_SESSION['s_language']."' AND lessons.active=1");         //Get the lessons where this user is enrolled

        if (sizeof($lessons_list) == 0) {                               //This user hasn't enrolled to any lessons
            $ctg = "personal";                                          //Redirect user to the settings page, where he may enroll in new lessons
        } elseif (sizeof($lessons_list) == 1) {                         //The user has enrolled to a single lesson
            //$_SESSION['s_lessons_ID'] = $lessons_list[0]['id'];         //Set the current lesson to this one, bypassing the lessons list
            //eF_local_setLessonParameters();
        } else {                                                        //The user just asked to see the lessons list
            //$_SESSION['s_lessons_ID'] = false;
            $_GET['op'] = 'lessons_list';                               //Set the op parameter to lessons_list, so that the lessons list is printed below
        }
    }
}
*/
//eF_printHeader();
/**This part is used at the page header*/
$css = eF_getTableData("configuration", "value", "name='css'");
if ($css && eF_checkParameter($css[0]['value'], 'filename') && is_file(G_ROOTPATH.'www/css/custom_css/'.$css[0]['value'])) {
    $smarty -> assign("T_HEADER_CSS", $css[0]['value']);
} else {
    $smarty -> assign("T_HEADER_CSS", "normal.css");
}

$lesson_name = eF_getLessonName();


if ((isset($_SESSION['s_lesson_options']['online']) && $_SESSION['s_lesson_options']['online'] == 1) || $_SESSION['s_type']=='administrator' ){
	$user = EfrontUserFactory :: factory($_SESSION['s_login']);
	$onlineusers = $user -> getUsersOnline(false);
    $smarty -> assign("T_ONLINE_USERS_LIST", $onlineusers);
}

//$smarty -> assign("T_CURRENT_CTG", $ctg);
//$smarty -> assign("T_HEADER_EDITOR", $load_editor);
//$logo_type = eF_getTableData("configuration","value","name='logo_type'");
//$smarty -> assign('T_LOGO_TYPE', $logo_type[0]['value']);

if (isset($_GET['hcd']) && MODULE_HCD_INTERFACE) {
    // MODULE HCD LEFT SIDE MENU
    $smarty -> assign("T_ROLE", $_SESSION['employee_type']);

    $smarty -> assign("T_MENUCTG", $ctg);

    include ("../libraries/module_hcd_tools.php");
    $menu = ef_getHcdMenu();
} else {
    // Normal case
    $smarty -> assign("T_ROLE", eF_getUserRole());
    $smarty -> assign("T_LESSON_NAME", $lesson_name);
    $smarty -> assign("T_MENUCTG", $ctg);
    $menu = ef_getMenu();
}

$smarty -> assign("T_MENU",$menu);

//$smarty -> assign("T_MESSAGE", $message);
//$smarty -> assign("T_MESSAGE_TYPE", $message_type);

//$smarty -> assign("T_SHOWFOOTER", eF_getShowFooter());
//$smarty -> assign("T_ADMINEMAIL", eF_getAdminEmail());

$smarty -> assign("T_UNREAD_MESSAGES", eF_getUnreadMessagesNumber());


$smarty -> load_filter('output', 'eF_template_formatTimestamp');
$smarty -> load_filter('output', 'eF_template_formatLogins');

$smarty -> display('sidebar_frame.tpl');


/*
function eF_local_setLessonParameters() {

    $result = eF_getTableData("lessons", "options", "id=".$_SESSION['s_lessons_ID']);                                      // Get the lesson options (eg if the chat and forum are activated)
    //print_r(unserialize($result[0]['options']));
    if ($result[0]['options'] != "") {
     //echo "skataaaaaaaaaaaaaaaaaa1111111111";                                                                                     //If there are no specific options for this lesson, get default options
 //print_r(unserialize($result[0]['options']));
        $_SESSION['s_lesson_options'] = unserialize($result[0]['options']);
    } else {
     //echo "skataaaaaaaaaaaaaaaaaa";
        $_SESSION['s_lesson_options'] = $GLOBALS['DEF_OPTIONS'];
    }

    $result = eF_getTableData("users", "colors", "login='".$_SESSION['s_login']."'");                                      // Get user colors

    if ($result[0]['colors'] == "") {                                                                                      //If there are no user colors, get the lesson colors (if neither exist, default colors will be used)
        $result = eF_getTableData("lessons", "colors", "id=".$_SESSION['s_lessons_ID']);
        if ($result[0]['colors'] != "") {
            $_SESSION['s_color'] = unserialize($result[0]['colors']);
            foreach ($system_default_colors AS $key => $value) {                                                            //For each of the system colors, if a user has defined one of his own, then assign this one
                if ($_SESSION['s_color'][$key] == "") {
                    $_SESSION['s_color'][$key] = $value;
                }
            }
        }
    }
}
*/


?>
