<?php
/**
* Sends a file along with a test question
* 
* This page is displayed when a student wants to attach a file to a test question.
*
* @package efront
* @version 1.0
*/

//General initialization and parameters
session_cache_limiter('none');
session_start();

$path = "../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";

//eF_printHeader(); 
//error_reporting(E_ALL);
//echo "<pre>";print_r($_POST);print_r($_GET);

if (eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']) != "student") {                           //Only a student may access this page
    header("location:index.php");
    exit;
}
(isset($_GET['tests_ID'])) ? $tests_ID = $_GET['tests_ID']: $tests_ID = $_POST['tests_ID']; 
(isset($_GET['q_ID'])) ? $q_ID = $_GET['q_ID']: $q_ID = $_POST['q_ID']; 

    
if (isset($tests_ID)) {
    $dir = G_LESSONSPATH.$_SESSION['s_lessons_ID']."/"."Students"."/".$_SESSION['s_login']."/"."Tests";
} else {
    $dir = G_LESSONSPATH.$_SESSION['s_lessons_ID']."/"."Students"."/".$_SESSION['s_login'];
}

if (!is_dir(G_LESSONSPATH.$_SESSION['s_lessons_ID']."/"."Students")) {
    @mkdir(G_LESSONSPATH.$_SESSION['s_lessons_ID']."/"."Students");
}
if (!is_dir(G_LESSONSPATH.$_SESSION['s_lessons_ID']."/"."Students"."/".$_SESSION['s_login'])) {
    @mkdir(G_LESSONSPATH.$_SESSION['s_lessons_ID']."/"."Students"."/".$_SESSION['s_login']);
}
if (!is_dir(G_LESSONSPATH.$_SESSION['s_lessons_ID']."/"."Students"."/".$_SESSION['s_login']."/"."Tests")) {
    @mkdir(G_LESSONSPATH.$_SESSION['s_lessons_ID']."/"."Students"."/".$_SESSION['s_login']."/"."Tests");
}



if (isset($_POST['submit'])) {
    $file['data'] = $_FILES['fileupload']['tmp_name'];
    $file['name'] = $_FILES['fileupload']['name'];
    $file['size'] = $_FILES['fileupload']['size'];
    
    if ($file['name'] != "") {
        if ($file['size'] == 0 OR !is_uploaded_file($file['data'])) {
            $message .= _SOMEPROBLEMWITHTHEFILE."<BR>";
            $message_type = 'failure';
        } elseif($file['size'] > G_MAXFILESIZE*1024) {
            $message .= _THEFILE." "._MUSTBESMALLERTHAN." ".sprintf("%.0f",G_MAXFILESIZE)." "._KILOBYTES."<BR>";
            $message_type = 'failure';
        } elseif(in_array(eF_getFileExtension($file['name']),$NOT_ALLOWED_EXTENSIONS)) {
            $message = _WRONGFILEEXTENSION;
            $message_type = 'failure';
        } else {
            if (isset($tests_ID)) {
                $to_file = $_POST['to_dir']."/".strtolower($tests_ID."_".$q_ID."_".$file['name']);
            } else {
                $to_file = $_POST['to_dir']."/".strtolower($file['name']);       
            } if(!is_dir($_POST['to_dir'])) {
                $message = _FOLDERNOTCREATEDCONTACTADMIN;
                $message_type = 'failure';
            } else {
                $result = @copy($file['data'],$to_file);
                if (isset($tests_ID)) {
                    $s_file_q[$q_ID] = $tests_ID."_".$q_ID."_".$file['name'];
                    if (!isset($_SESSION['s_file_q'])) {
                        $_SESSION['s_file_q'] = $s_file_q;
                    }
                    
                }
                $message = _THEFILE." "._HASBEENSEND."<br/>"._WINDOWCLOSE5SECONDS;
                $message_type = 'success';
            }
        }
    }
}

$smarty -> assign("T_DIR", $dir);
$smarty -> assign("T_TESTS_ID", $tests_ID);
$smarty -> assign("T_QUESTION_ID", $q_ID);

$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);

$smarty -> display("send_file.tpl");

?>
