<?php

$loadScripts = array_merge($loadScripts, array('scriptaculous/prototype','scriptaculous/scriptaculous','scriptaculous/effects','scriptaculous/controls'));

$smarty -> assign("T_CATEGORY", 'statistics');
$systemUser      = EfrontUserFactory :: factory($_SESSION['s_login']);
$basic_user_type = $systemUser  -> getType();
$smarty -> assign("T_BASIC_TYPE", $basic_user_type);

if (isset($_GET['tab'])){
    $smarty -> assign("T_TAB", $_GET['tab']);
}

$isProfessor = 0;
$isStudent = 0;

//check to see if the user has any lessons as a student and any lessons as professor
if ($basic_user_type != 'administrator'){
    $lessons = $systemUser -> getLessons(false);
    foreach ($lessons as $lesson_id => $type){
        if ($type == 'professor'){
            $isProfessor = 1;
        }
        else if ($type == 'student'){
            $isStudent = 1;
        }
    } 
}
 

$smarty -> assign("T_ISPROFESSOR", $isProfessor);
$smarty -> assign("T_ISSTUDENT", $isStudent);    

if ($basic_user_type != 'administrator' && !$isProfessor){
    $_GET['option'] = 'user';
}

/*no option is set, so just show the available options*/
if (!isset($_GET['option']) && !isset($_GET['oper'])){
    if ($basic_user_type == 'administrator'){
        $options[0]  = array('text' => _USERSTATISTICS,    'image' => "32x32/user1.png",   'href' => "administrator.php?ctg=statistics&option=user");
        $options[1]  = array('text' => _LESSONSTATISTICS,  'image' => "32x32/board.png",   'href' => "administrator.php?ctg=statistics&option=lesson");
        $options[2]  = array('text' => _COURSESTATISTICS,  'image' => "32x32/books.png",   'href' => "administrator.php?ctg=statistics&option=course");
        $options[3]  = array('text' => _TESTSTATISTICS,  'image' => "32x32/edit.png",   'href' => "administrator.php?ctg=statistics&option=test");
        $options[4]  = array('text' => _SYSTEMSTATISTICS,  'image' => "32x32/chart.png",   'href' => "administrator.php?ctg=statistics&option=system");
        /* MODULE HCD INTERFACE: Add Search for employee*/
        if (MODULE_HCD_INTERFACE) {
            $options[5]  = array('text' => _SEARCHFOREMPLOYEE,                 'image' => "32x32/book_red.png",  'href' => $_SESSION['s_type'] . ".php?ctg=module_hcd&op=reports");
        }
        $smarty -> assign("T_STATISTICS_OPTIONS", $options);
    }
    else if ($basic_user_type == 'professor'){
        if ($isProfessor){
            $options[0]  = array('text' => _USERSTATISTICS,    'image' => "32x32/user1.png",   'href' => "professor.php?ctg=statistics&option=user");
            $options[1]  = array('text' => _LESSONSTATISTICS,  'image' => "32x32/board.png",   'href' => "professor.php?ctg=statistics&option=lesson");
            $options[2]  = array('text' => _COURSESTATISTICS,  'image' => "32x32/books.png",   'href' => "professor.php?ctg=statistics&option=course");
            $options[3]  = array('text' => _TESTSTATISTICS,  'image' => "32x32/edit.png",   'href' => "professor.php?ctg=statistics&option=test");  
            $smarty -> assign("T_STATISTICS_OPTIONS", $options);
        }
    }
    else if ($basic_user_type == 'student'){
        if ($isProfessor){
            $options[0]  = array('text' => _USERSTATISTICS,    'image' => "32x32/user1.png",   'href' => "student.php?ctg=statistics&option=user");
            $options[1]  = array('text' => _LESSONSTATISTICS,  'image' => "32x32/board.png",   'href' => "student.php?ctg=statistics&option=lesson");
            $options[2]  = array('text' => _TESTSTATISTICS,  'image' => "32x32/edit.png",   'href' => "student.php?ctg=statistics&option=test");
            $smarty -> assign("T_STATISTICS_OPTIONS", $options);
        }
    }
}
else if ($_GET['option'] == 'lesson'){
    $smarty -> assign("T_OPTION", $_GET['option']);
    if ($basic_user_type == 'administrator'){
        $lessons = EfrontLesson :: getLessons();
    }
    else if ($isProfessor){
        $lessons = $systemUser -> getRoleLessons('professor', true);
    }
    
    $currentLesson = null;
    if (sizeof($lessons) == 1){
        $currentLesson = current($lessons); /*get the current(first) lesson*/
    }
    else if (isset($_GET['sel_lesson'])){
        $currentLesson = new EfrontLesson($_GET['sel_lesson']);
    }
    else if (isset($_SESSION['s_lessons_ID']) && in_array($_SESSION['s_lessons_ID'], array_keys($lessons))){
        $currentLesson = new EfrontLesson($_SESSION['s_lessons_ID']);
    }
    /*if the current lesson is not null, then calculate its statistics*/
    if ($currentLesson != null){
        //get the lesson information
        $lesson_info = $currentLesson -> getStatisticInformation();
        $groups = EfrontGroup :: getGroups();

        $smarty -> assign("T_TLESSON_NAME", $currentLesson -> lesson['name']);
        $smarty -> assign("T_TLESSON_ID", $currentLesson -> lesson['id']);    

        $smarty -> assign("T_GROUPS", $groups);
        if (isset($_GET['group_filter'])){
            $smarty -> assign("T_GROUP_ID", $_GET['group_filter']);
        }        
        $smarty -> assign("T_TLESSON_INFO", $lesson_info);
        
        $user_titles_list = array('login' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&usort_by=login&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'], 'text' => _USERNAME, 'align' => "left"),
                        'name' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&usort_by=name&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _FIRSTNAME, 'align' => "left"),
                        'surname' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&usort_by=surname&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _LASTNAME, 'align' => "left"),
                        'time' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&usort_by=time&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _TIMEINLESSON, 'align' => "center"),
                        'content' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&usort_by=content&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _CONTENT, 'align' => "center"),
                        'tests' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&usort_by=tests&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'], 'text' => _TESTS, 'align' => "center"),
                        'projects' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&usort_by=projects&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'], 'text' => _PROJECTS, 'align' => "center"),
                        'num_comments' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&usort_by=num_comments&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _COMMENTS, 'align' => "center"),
                        'num_posts' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&usort_by=num_posts&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _MESSAGES, 'align' => "center"));          //Make a list with the urls that are used to sort a column
        
        //calculate the status of each student
        $students = $currentLesson -> getUsers('student');
        $logins = array();
        foreach ($students as $user){
            $logins[] = $user['login'];
        }
 
        $status           = EfrontStats :: getStudentsLessonStatus($currentLesson, $logins);
        $userTimes        = EfrontStats :: getUsersTime($currentLesson -> lesson['id'], $logins);
        $doneTests        = EfrontStats :: getStudentsDoneTests($currentLesson -> lesson['id'], $logins);
        $assignedProjects = EfrontStats :: getStudentsAssignedProjects($currentLesson -> lesson['id'], $logins);

        //calculate the appropriate data arrays (in order fort sorting to be easy)
        foreach ($logins as $cur_login){
            $name_array[$cur_login]     = $students[$cur_login]['name'];
            $surname_array[$cur_login]  = $students[$cur_login]['surname'];
            $time_array[$cur_login]     = $userTimes[$cur_login];
            $seconds_array[$cur_login]  = $userTimes[$cur_login]['total_seconds'];
            $content_array[$cur_login]  = $status[$cur_login]['percentage_done'];
            $test_array[$cur_login]     = $status[$cur_login]['avg_score_tests'];
            $project_array[$cur_login]  = $status[$cur_login]['avg_grade_projects'];
            $posts_array[$cur_login]    = $status[$cur_login]['total_posts'];
            $comments_array[$cur_login] = $status[$cur_login]['total_comments'];
        }
        
        //sort the student arrays before assigning them to smarty
        (isset($_GET['uorder']) && $_GET['uorder'] == 'desc') ? $uorder = SORT_DESC : $uorder = SORT_ASC;
        if (isset($_GET['usort_by'])) {
            switch($_GET['usort_by']) {
                case 'login':
                    array_multisort($logins, $uorder, $name_array, $surname_array, $time_array, $content_array, $test_array, $project_array, $posts_array, $comments_array);
                    break;
                case 'name':
                    array_multisort($name_array, $uorder, $logins, $surname_array, $time_array, $content_array, $test_array, $project_array, $posts_array, $comments_array);
                    break;
                case 'surname':
                    array_multisort($surname_array, $uorder, $name_array, $logins, $time_array, $content_array, $test_array, $project_array, $posts_array, $comments_array);
                    break;
                case 'time':
                    array_multisort($seconds_array, $uorder, $surname_array, $name_array, $logins, $time_array, $content_array, $test_array, $project_array, $posts_array, $comments_array);
                    break;
                case 'content':
                    array_multisort($content_array, $uorder, $name_array, $surname_array, $time_array, $logins, $test_array, $project_array, $posts_array, $comments_array);
                    break;
                case 'tests':
                    array_multisort($test_array, $uorder, $name_array, $surname_array, $time_array, $content_array, $logins, $project_array, $posts_array, $comments_array);
                    break;
                case 'projects':
                    array_multisort($project_array, $uorder, $name_array, $surname_array, $time_array, $content_array, $test_array, $logins, $posts_array, $comments_array);
                    break;
                case 'num_posts':
                    array_multisort($posts_array, $uorder, $name_array, $surname_array, $time_array, $content_array, $test_array, $project_array, $logins, $comments_array);
                    break;
                case 'num_comments':
                    array_multisort($comments_array, $uorder, $name_array, $surname_array, $time_array, $content_array, $test_array, $project_array, $posts_array, $logins);
                    break;
                default:break;
            }
        }
        
        foreach ($user_titles_list as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
            if (isset($_GET['usort_by']) && $key == $_GET['usort_by']) {
                if (isset($_GET['uorder']) && $_GET['uorder'] == 'desc') {
                    $order_str                       = '&uorder=asc';
                    $user_titles_list[$key]['arrow'] = '&uarr;';
                } else {
                    $order_str                       = '&uorder=desc';
                    $user_titles_list[$key]['arrow'] = '&darr;';
                }
                $user_titles_list[$key]['link'] .= $order_str.'';
            } else {
                $user_titles_list[$key]['link'] .= '&uorder=desc';
                $user_titles_list[$key]['arrow'] = '';
            }
        }
        
        $smarty -> assign("T_TLESSON_STUDENT_LOGINS",   $logins);
        $smarty -> assign("T_TLESSON_STUDENT_NAMES",    $name_array);
        $smarty -> assign("T_TLESSON_STUDENT_SURNAMES", $surname_array);
        $smarty -> assign("T_TLESSON_STUDENT_TIME",     $time_array);
        $smarty -> assign("T_TLESSON_STUDENT_CONTENT",  $content_array);
        $smarty -> assign("T_TLESSON_STUDENT_TESTS",    $test_array);
        $smarty -> assign("T_TLESSON_STUDENT_PROJECTS", $project_array);
        $smarty -> assign("T_TLESSON_STUDENT_COMMENTS", $comments_array);
        $smarty -> assign("T_TLESSON_STUDENT_POSTS",    $posts_array);
        $smarty -> assign("T_STUDENTS_TITLES_LIST",     $user_titles_list);
        
        
        //calculate the data of each professor
        $professors_titles_list = array(
                        'login' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&psort_by=login&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' =>_USERNAME,'align' => "left"),
                        'name' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&psort_by=name&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _FIRSTNAME,'align' => "left"),
                        'surname' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&psort_by=surname&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _LASTNAME,'align' => "left"),
                        'time' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&psort_by=time&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _TIMEINLESSON,'align' => "center"),
                        'num_comments' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&psort_by=num_comments&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _COMMENTS,'align' => "center"),
                        'num_posts' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&psort_by=num_posts&tab=users&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _MESSAGES,'align' => "center")
                        );

        $professors = $currentLesson -> getUsers('professor');
        $logins = array();
        foreach ($professors as $professor){
            $logins[] = $professor['login'];
        }

        $professorTimes    = EfrontStats :: getUsersTime($currentLesson -> lesson['id'], $logins);
        $professorPosts    = EfrontStats :: getUsersForumPosts($currentLesson -> lesson['id'], $logins);
        $professorComments = EfrontStats :: getUsersComments($currentLesson -> lesson['id'], $logins);

        $name_array = array();
        $surname_array = array();
        $time_array = array();
        $seconds_array = array();
        $posts_array = array();
        $comments_array = array();
        //calculate the appropriate data arrays (in order fort sorting to be easy)
        foreach ($logins as $cur_login){
            $name_array[$cur_login]     = $professors[$cur_login]['name'];
            $surname_array[$cur_login]  = $professors[$cur_login]['surname'];
            $time_array[$cur_login]     = $professorTimes[$cur_login];
            $seconds_array[$cur_login]  = $professorTimes[$cur_login]['total_seconds'];
            $posts_array[$cur_login]    = $professorPosts[$cur_login];
            $comments_array[$cur_login] = $professorComments[$cur_login];
        }
        
        //sort the student arrays before assigning them to smarty
        (isset($_GET['porder']) && $_GET['porder'] == 'desc') ? $porder = SORT_DESC : $porder = SORT_ASC;
        if (isset($_GET['psort_by'])) {
            switch($_GET['psort_by']) {
                case 'login':
                    array_multisort($logins, $porder, $name_array, $surname_array, $time_array,  $posts_array, $comments_array);
                    break;
                case 'name':
                    array_multisort($name_array, $uorder, $logins, $surname_array, $time_array,  $posts_array, $comments_array);
                    break;
                case 'surname':
                    array_multisort($surname_array, $uorder, $name_array, $logins, $time_array,  $posts_array, $comments_array);
                    break;
                case 'time':
                    array_multisort($seconds_array, $uorder, $surname_array, $name_array, $logins, $time_array,  $posts_array, $comments_array);
                    break;
                case 'num_posts':
                    array_multisort($posts_array, $uorder, $name_array, $surname_array, $time_array, $logins, $comments_array);
                    break;
                case 'num_comments':
                    array_multisort($comments_array, $uorder, $name_array, $surname_array, $time_array,  $posts_array, $logins);
                    break;
                default:break;
            }
        }
        
        foreach ($professors_titles_list as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
            if (isset($_GET['psort_by']) && $key == $_GET['psort_by']) {
                if (isset($_GET['porder']) && $_GET['porder'] == 'desc') {
                    $order_str                       = '&porder=asc';
                    $professors_titles_list[$key]['arrow'] = '&uarr;';
                } else {
                    $order_str = '&porder=desc';
                    $professors_titles_list[$key]['arrow'] = '&darr;';
                }
                $professors_titles_list[$key]['link'] .= $order_str.'';
            } else {
                $professors_titles_list[$key]['link'] .= '&porder=desc';
                $professors_titles_list[$key]['arrow'] = '';
            }
        }
                
        $smarty -> assign("T_PROFESSORS_TITLES_LIST",     $professors_titles_list);
        $smarty -> assign("T_TLESSON_PROFESSOR_LOGINS",   $logins);
        $smarty -> assign("T_TLESSON_PROFESSOR_NAMES",    $name_array);
        $smarty -> assign("T_TLESSON_PROFESSOR_SURNAMES", $surname_array);
        $smarty -> assign("T_TLESSON_PROFESSOR_TIME",     $time_array);
        $smarty -> assign("T_TLESSON_PROFESSOR_COMMENTS", $comments_array);
        $smarty -> assign("T_TLESSON_PROFESSOR_POSTS",    $posts_array);
        
        
        /*
         *  Lesson's tests
         */
        $lessonTests = $currentLesson -> getTests(true);
        if (sizeof($lessonTests) > 0){
            $lessonTests_ids = array();
            foreach ($lessonTests as $test){
                $lessonTests_ids[] = $test -> test['id'];
            }
            $tests_info = EfrontStats :: getTestInfo($lessonTests_ids);
            
            $tests_users_titles_list = array(
                        'login'    => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&tsort_by=login&tab=tests&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _USERNAME),
                        'name'     => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&tsort_by=name&&tab=tests&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' =>_NAME),
                        'surname'  => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&tsort_by=surname&&tab=tests&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' =>_SURNAME),
                        'score'     => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&tsort_by=score&tab=tests&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'], 'text' => _SCORE),
                        'timestamp' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&tsort_by=timestamp&tab=tests&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'], 'text' => _DATE)
                    );
            
            $doneTests = array();
            foreach ($tests_info as $test_info){
                $doneTests[$test_info['general']['id']]['users_LOGIN'] = array();
                $doneTests[$test_info['general']['id']]['name'] = array();
                $doneTests[$test_info['general']['id']]['surname'] = array();
                $doneTests[$test_info['general']['id']]['score'] = array();
                $doneTests[$test_info['general']['id']]['timestamp'] = array();
                foreach ($test_info['done'] as $done){
                    $doneTests[$test_info['general']['id']]['users_LOGIN'][] = $done['users_LOGIN'];
                    $doneTests[$test_info['general']['id']]['name'][] = $done['name'];
                    $doneTests[$test_info['general']['id']]['surname'][] = $done['surname'];
                    $doneTests[$test_info['general']['id']]['score'][] = round($done['score'], 2);
                    $doneTests[$test_info['general']['id']]['timestamp'][] = $done['timestamp'];
                }
            }
            
            
            (isset($_GET['torder']) && $_GET['torder'] == 'desc') ? $torder = SORT_DESC : $torder = SORT_ASC;
            
            if (isset($_GET['tsort_by'])) {
                switch($_GET['tsort_by']) {
                    case 'login':
                        foreach ($doneTests as $id => $test){
                            array_multisort($doneTests[$id]['users_LOGIN'], $torder, $doneTests[$id]['name'], $doneTests[$id]['surname'], $doneTests[$id]['score'],  $doneTests[$id]['timestamp']);
                        }
                        break;
                    case 'name':
                        foreach ($doneTests as $id => $test){
                            array_multisort($doneTests[$id]['name'], $torder, $doneTests[$id]['users_LOGIN'], $doneTests[$id]['surname'], $doneTests[$id]['score'],  $doneTests[$id]['timestamp']);
                        }
                        break;
                    case 'surname':
                        foreach ($doneTests as $id => $test){
                            array_multisort($doneTests[$id]['surname'], $torder, $doneTests[$id]['name'], $doneTests[$id]['users_LOGIN'], $doneTests[$id]['score'],  $doneTests[$id]['timestamp']);
                        }
                        break;
                    case 'score':
                        foreach ($doneTests as $id => $test){
                            array_multisort($doneTests[$id]['score'], $torder, $doneTests[$id]['name'], $doneTests[$id]['surname'], $doneTests[$id]['users_LOGIN'], $doneTests[$id]['timestamp']);
                        }
                        break;
                    case 'timestamp':
                        foreach ($doneTests as $id => $test){
                            array_multisort($doneTests[$id]['timestamp'], $torder, $doneTests[$id]['name'], $doneTests[$id]['surname'], $doneTests[$id]['score'], $doneTests[$id]['users_LOGIN']);
                        }
                        break;
                    default:break;
                }
            }
            
            foreach ($tests_users_titles_list as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
                if (isset($_GET['tsort_by']) && $key == $_GET['tsort_by']) {
                    if (isset($_GET['torder']) && $_GET['torder'] == 'desc') {
                        $order_str = '&torder=asc';
                        $tests_users_titles_list[$key]['arrow'] = '&uarr;';
                    } else {
                        $order_str = '&torder=desc';
                        $tests_users_titles_list[$key]['arrow'] = '&darr;';
                    }
                    $tests_users_titles_list[$key]['link'] .= $order_str.'';
                } else {
                    $tests_users_titles_list[$key]['link'] .= '&torder=desc';
                    $tests_users_titles_list[$key]['arrow'] = '';
                }
            }
            
            $smarty -> assign("T_TESTS_USERS_TITLES_LIST",  $tests_users_titles_list);
            $smarty -> assign("T_LESSON_TESTS_INFO",        $tests_info);
            $smarty -> assign("T_LESSON_DONE_TESTS",        $doneTests);
        }
        
        /*
         *      Lesson's questions
         */
        $lessonQuestions = $currentLesson -> getQuestions(false);
        if (sizeof($lessonQuestions) > 0){
            $questions_info = EfrontStats :: getQuestionInfo($lessonQuestions);
            $questions_titles = array();
            $questions_titles['text']['title'] = _QUESTIONTEXT;
            $questions_titles['text']['link'] = $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&qsort_by=text&tab=questions&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'].'';
            $questions_titles['avg_score']['title'] = _AVERAGESCORE;
            $questions_titles['avg_score']['link'] = $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&qsort_by=avg_score&tab=questions&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'].'';
            $questions_titles['times_done']['title'] = _TIMESDONE;
            $questions_titles['times_done']['link'] = $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&qsort_by=times_done&tab=questions&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'].'';
            
            $question_id_array         = array();
            $question_text_array       = array();
            $question_type_array       = array();
            $question_difficulty_array = array();
            $question_times_done_array = array();
            $question_avg_score_array  = array();
            foreach ($questions_info as $question_info){
                $question_id_array[]         = $question_info['general']['id'];
                $question_text_array[]       = $question_info['general']['reduced_text'];
                $question_type_array[]       = $question_info['general']['type'];
                $question_difficulty_array[] = $question_info['general']['difficulty'];
                $question_times_done_array[] = $question_info['done']['times_done'];
                $question_avg_score_array[]  = $question_info['done']['avg_score'];
            }
            
            
            (isset($_GET['qorder']) && $_GET['qorder'] == 'desc') ? $qorder = SORT_DESC : $qorder = SORT_ASC;
            
            if (isset($_GET['qsort_by'])) {
                switch($_GET['qsort_by']) {
                    case 'text':
                        array_multisort($question_text_array, $qorder, $question_id_array, $question_type_array, $question_difficulty_array, 
                                        $question_times_done_array, $question_avg_score_array);
                        break;
                    case 'avg_score':
                        array_multisort($question_avg_score_array, $qorder, $question_id_array, $question_type_array, $question_difficulty_array, 
                                        $question_times_done_array, $question_text_array);
                        break;
                    case 'times_done':
                        array_multisort($question_times_done_array, $qorder, $question_id_array, $question_type_array, $question_difficulty_array, 
                                        $question_avg_score_array, $question_text_array);
                        break;
                    default:break;
                }
            }
            
            foreach ($questions_titles as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
                if (isset($_GET['qsort_by']) && $key == $_GET['qsort_by']) {
                    if (isset($_GET['qorder']) && $_GET['qorder'] == 'desc') {
                        $order_str                       = '&qorder=asc';
                        $questions_titles[$key]['arrow'] = '&uarr;';
                    } else {
                        $order_str = '&qorder=desc';
                        $questions_titles[$key]['arrow'] = '&darr;';
                    }
                    $questions_titles[$key]['link']     .= $order_str.'';
                } else {
                    $questions_titles[$key]['link']     .= '&qorder=desc';
                    $questions_titles[$key]['arrow']     = '';
                }
            }
        
            $smarty -> assign("T_LESSON_QUESTIONS_TITLES", $questions_titles);
            $smarty -> assign("T_LESSON_QUESTIONS_ID", $question_id_array);
            $smarty -> assign("T_LESSON_QUESTIONS_TEXT", $question_text_array);
            $smarty -> assign("T_LESSON_QUESTIONS_TYPE", $question_type_array);
            $smarty -> assign("T_LESSON_QUESTIONS_DIFFICULTY", $question_difficulty_array);
            $smarty -> assign("T_LESSON_QUESTIONS_TIMESDONE", $question_times_done_array);
            $smarty -> assign("T_LESSON_QUESTIONS_AVGSCORE", $question_avg_score_array);
        }
    
        /*
         *      Lesson's projects
         */
        $lessonProjects = $currentLesson -> getProjects(true, false, false);
        if (sizeof($lessonProjects) > 0){
            $projects_ids = array();
            foreach ($lessonProjects as $key => $item){
                 $projects_ids[] = $key;
            }
            
            $projects_info = EfrontStats :: getProjectInfo($projects_ids);
            
            $projects_titles_list = array(
                    'login'    => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&psort_by=login&tab=projects&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' => _USERNAME),
                    'name'     => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&psort_by=name&tab=projects&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' =>_NAME),
                    'surname'  => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&psort_by=surname&tab=projects&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],'text' =>_SURNAME),
                    'grade'     => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&psort_by=grade&tab=projects&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'],     'text' => _SCORE),
                    'timestamp' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=lesson&psort_by=timestamp&tab=projects&group_filter='.$group_id.'&sel_lesson='.$currentLesson -> lesson['id'], 'text' => _DATE));
            
            $doneProjects = array();
            foreach ($projects_info as $project_info){
                $doneProjects[$project_info['general']['id']]['users_LOGIN'] = array();
                $doneProjects[$project_info['general']['id']]['name'] = array();
                $doneProjects[$project_info['general']['id']]['surname'] = array();
                $doneProjects[$project_info['general']['id']]['grade'] = array();
                $doneProjects[$project_info['general']['id']]['timestamp'] = array();
                foreach ($project_info['done'] as $done){
                    $doneProjects[$project_info['general']['id']]['users_LOGIN'][] = $done['users_LOGIN'];
                    $doneProjects[$project_info['general']['id']]['name'][] = $done['name'];
                    $doneProjects[$project_info['general']['id']]['surname'][] = $done['surname'];
                    $doneProjects[$project_info['general']['id']]['grade'][] = round($done['grade'], 2);
                    $doneProjects[$project_info['general']['id']]['upload_timestamp'][] = $done['upload_timestamp'];
                }
            }
            
            (isset($_GET['porder']) && $_GET['porder'] == 'desc') ? $porder = SORT_DESC : $porder = SORT_ASC;
            
            if (isset($_GET['psort_by'])) {
                switch($_GET['psort_by']) {
                    case 'login':
                        foreach ($doneProjects as $id => $project){
                            array_multisort($doneProjects[$id]['users_LOGIN'], $porder, $doneProjects[$id]['name'], $doneProjects[$id]['surname'], $doneProjects[$id]['grade'],  $doneProjects[$id]['timestamp']);
                        }
                        break;
                    case 'name':
                        foreach ($doneProjects as $id => $project){
                            array_multisort($doneProjects[$id]['name'], $porder, $doneProjects[$id]['users_LOGIN'], $doneProjects[$id]['surname'], $doneProjects[$id]['score'],  $doneProjects[$id]['timestamp']);
                        }
                        break;
                    case 'surname':
                        foreach ($doneProjects as $id => $test){
                            array_multisort($doneProjects[$id]['surname'], $torder, $doneProjects[$id]['name'], $doneProjects[$id]['users_LOGIN'], $doneProjects[$id]['grade'],  $doneProjects[$id]['timestamp']);
                        }
                        break;
                    case 'grade':
                        foreach ($doneProjects as $id => $test){
                            array_multisort($doneProjects[$id]['grade'], $torder, $doneProjects[$id]['name'], $doneProjects[$id]['surname'], $doneProjects[$id]['users_LOGIN'], $doneProjects[$id]['timestamp']);
                        }
                        break;
                    case 'timestamp':
                        foreach ($doneProjects as $id => $test){
                            array_multisort($doneProjects[$id]['timestamp'], $torder, $doneProjects[$id]['name'], $doneProjects[$id]['surname'], $doneProjects[$id]['grade'], $doneProjects[$id]['users_LOGIN']);
                        }
                        break;
                    default:break;
                }
            }
            
            foreach ($projects_titles_list as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
                if (isset($_GET['psort_by']) && $key == $_GET['psort_by']) {
                    if (isset($_GET['porder']) && $_GET['porder'] == 'desc') {
                        $order_str = '&porder=asc';
                        $projects_titles_list[$key]['arrow'] = '&uarr;';
                    } else {
                        $order_str = '&porder=desc';
                        $projects_titles_list[$key]['arrow'] = '&darr;';
                    }
                    $projects_titles_list[$key]['link'] .= $order_str.'';
                } else {
                    $projects_titles_list[$key]['link'] .= '&porder=desc';
                    $projects_titles_list[$key]['arrow'] = '';
                }
            }
            
            $smarty -> assign("T_PROJECTS_TITLES_LIST",  $projects_titles_list);
            $smarty -> assign("T_LESSON_PROJECTS_INFO",  $projects_info);
            $smarty -> assign("T_LESSON_DONE_PROJECTS",     $doneProjects);
        }
        
        /*
         *  lesson traffic
         */
         if (isset($_GET['from_year'])){ //the admin has chosen a period
                $from = mktime($_GET['from_hour'],$_GET['from_min'],0,$_GET['from_month'],$_GET['from_day'],$_GET['from_year']);
                $to = mktime($_GET['to_hour'],$_GET['to_min'],0,$_GET['to_month'],$_GET['to_day'],$_GET['to_year']);
                $smarty->assign("T_FROM_TIMESTAMP", $from);
                $smarty->assign("T_TO_TIMESTAMP", $to);
                $l_id = $currentLesson -> lesson['id'];
                $traffic = ef_getLessonTraffic($l_id, $from, $to);
                $smarty -> assign("T_LESSON_TRAFFIC", $traffic);
                if (isset($_GET['showlog']) && $_GET['showlog']=="true"){
                    $interval['from'] = $from;
                    $interval['to'] = $to;
                    $smarty -> assign("T_LESSON_LOG",ef_getLessonLog($l_id, $interval));
                }
        }
        else{   //the admin has not chosen a period...
            $from = mktime(date("H"), date("i"), 0, date("m") ,date("d")-7,   date("Y"));
            $to = mktime(date("H"), date("i"), 0, date("m") ,date("d"),   date("Y"));
            $smarty -> assign('T_FROM_TIMESTAMP', $from);
            $smarty -> assign('T_TO_TIMESTAMP',   $to);
            $l_id = $currentLesson -> lesson['id'];
            $traffic = ef_getLessonTraffic($l_id, $from, $to);
            $smarty -> assign("T_LESSON_TRAFFIC", $traffic);

        }
    }
}
else if ($_GET['option'] == 'user'){
    $smarty -> assign("T_OPTION", $_GET['option']);
    $users = array();
    if ($basic_user_type == 'administrator'){
        $users = EfrontUser :: getUsers(false);
    }
    else if ($isProfessor){
        $users = $systemUser -> getProfessorStudents();
        if (!in_array($_SESSION['s_login'])){
            $users[] = $_SESSION['s_login'];
        }
    }
    else {   //if the system user is a simple student
        $users[] =  $systemUser -> user['login'];
    }
    $currentUser = null;
    
    if (sizeof($users) == 1){
        $currentUser  = EfrontUserFactory :: factory(current($users));
    }
    else if (isset($_GET['sel_user'])){
        $currentUser = EfrontUserFactory :: factory($_GET['sel_user']);
    }
    if ($currentUser != null){
        $smarty -> assign("T_TUSER_LOGIN", $currentUser -> user['login']);   
        $user_info = array();
        $user_info['general'] = $currentUser -> getInformation();
        if ($user_info['avatar'] != ""){
            $smarty -> assign("T_TUSER_AVATAR", $user_info['avatar']);
        }
        $communication_info         = EfrontStats :: getUserCommunicationInfo($currentUser);
        $usage_info                 = EfrontStats :: getUserUsageInfo($currentUser);
        $user_info['communication'] = $communication_info;
        $user_info['usage']         = $usage_info;
        
        
        $userStudentLessons   = $user_info['general']['student_lessons'];
        $userProfessorLessons = $user_info['general']['professor_lessons'];
        
        
        //get information for the lessons the user is a student
        $userTimes          = array();
        $userTotalSeconds   = array();
        $userContentPerc    = array();
        $userProjectsPerc   = array();
        $userTestsPerc      = array();
        $studentLessonNames = array();
        foreach ($userStudentLessons as $lesson){
            $studentLessonNames[$lesson -> lesson['id']] = $lesson -> lesson['name'];
            $status                                      = EfrontStats :: getStudentsLessonStatus($lesson -> lesson['id'], $currentUser -> user['login']);
            $userContentPerc[$lesson -> lesson['id']]    = $status[$currentUser -> user['login']]['percentage_done'];
            $userTestsPerc[$lesson -> lesson['id']]      = $status[$currentUser -> user['login']]['avg_score_tests'];
            $userProjectsPerc[$lesson -> lesson['id']]   = $status[$currentUser -> user['login']]['avg_grade_projects'];
            $time                                        = EfrontStats :: getUsersTime($lesson -> lesson['id'], $currentUser -> user['login']);
            $userTimes[$lesson -> lesson['id']]          = $time[$currentUser -> user['login']];
            $userTotalSeconds[$lesson -> lesson['id']]   = $userTimes[$lesson -> lesson['id']]['total_seconds'];
        }
        
        //get information for the lessons the user is a professor
        $professorTimes       = array();
        $professorTotalSecons = array();
        $professorContent     = array();
        $professorProjects    = array();
        $professorTests       = array();
        $professorLessonNames = array();
        foreach ($userProfessorLessons as $lesson){
            $professorLessonNames[$lesson -> lesson['id']]  = $lesson -> lesson['name'];
            $time                                           = EfrontStats :: getUsersTime($lesson -> lesson['id'], $currentUser -> user['login']);
            $professorTimes[$lesson -> lesson['id']]        = $time[$currentUser -> user['login']];
            $professorTotalSeconds[$lesson -> lesson['id']] = $professorTimes[$lesson -> lesson['id']]['total_seconds'];
            $lesson_info                                    = $lesson -> getStatisticInformation();
            $professorContent[$lesson -> lesson['id']]      = $lesson_info['theory'];
            $professorProjects[$lesson -> lesson['id']]     = sizeof($lesson -> getProjects());
            $professorTests[$lesson -> lesson['id']]        = sizeof($lesson -> getTests());
        }
        
        
        $user_lesson_titles_list = array(
            'lesson'    => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&lsort_by=lesson&tab=lessons&sel_user='.$currentUser -> user['login'],'text' =>_LESSON,'align' => "left"),
            'time'      => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&lsort_by=time&tab=lessons&sel_user='.$currentUser -> user['login'],'text' =>_TIMEINLESSON,'align' => "center"),
            'content'   => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&lsort_by=content&tab=lessons&sel_user='.$currentUser -> user['login'],'text' =>_CONTENT,'align' => "center"),
            'tests'     => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&lsort_by=tests&tab=lessons&sel_user='.$currentUser -> user['login'],'text' =>_TESTS,'align' => "center"),
            'projects'  => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&lsort_by=projects&tab=lessons&sel_user='.$currentUser -> user['login'],'text' =>_PROJECTS,'align' => "center"),
        );
        
        
        (isset($_GET['lorder']) && $_GET['lorder'] == 'desc') ? $lorder = SORT_DESC : $lorder = SORT_ASC;
        
        if (isset($_GET['lsort_by'])) {
            switch($_GET['lsort_by']) {
                case 'lesson':
                    array_multisort($studentLessonNames, $lorder, $userTimes, $userContentPerc, $userTestsPerc, $userProjectsPerc);
                    break;
                case 'time':
                    array_multisort($userTotalSeconds, $lorder, $studentLessonNames, $userTimes, $userContentPerc, $userTestsPerc, $userProjectsPerc);
                    break;
                case 'content':
                    array_multisort($userContentPerc, $lorder, $userTimes, $studentLessonNames, $userTestsPerc, $userProjectsPerc);
                    break;
                case 'tests':
                    array_multisort($userTestsPerc, $lorder, $userTimes, $studentLessonNames, $userContentPerc, $userProjectsPerc);
                    break;
                case 'projects':
                    array_multisort($userProjectsPerc, $lorder, $userTimes, $studentLessonNames, $userTestsPerc, $userContentPerc);
                    break;
                default:break;
            }
        }
        
        foreach ($user_lesson_titles_list as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
            if (isset($_GET['lsort_by']) && $key == $_GET['lsort_by']) {
                if (isset($_GET['lorder']) && $_GET['lorder'] == 'desc') {
                    $order_str = '&lorder=asc';
                    $user_lesson_titles_list[$key]['arrow'] = '&uarr;';
                } else {
                    $order_str = '&lorder=desc';
                    $user_lesson_titles_list[$key]['arrow'] = '&darr;';
                }
                $user_lesson_titles_list[$key]['link'] .= $order_str.'';
            } else {
                $user_lesson_titles_list[$key]['link'] .= '&lorder=desc';
                $user_lesson_titles_list[$key]['arrow'] = '';
            }
        }
        
        $professor_lesson_titles_list = array(
            'lesson'    => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&lpsort_by=lesson&tab=lessons&sel_user='.$currentUser -> user['login'],'text' =>_LESSON,'align' => "left"),
            'time'      => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&lpsort_by=time&tab=lessons&sel_user='.$currentUser -> user['login'],'text' =>_TIMEINLESSON,'align' => "center"),
            'content'   => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&lpsort_by=content&tab=lessons&sel_user='.$currentUser -> user['login'],'text' =>_CONTENT,'align' => "center"),
            'tests'     => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&lpsort_by=tests&tab=lessons&sel_user='.$currentUser -> user['login'],'text' =>_TESTS,'align' => "center"),
            'projects'  => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&lpsort_by=projects&tab=lessons&sel_user='.$currentUser -> user['login'],'text' =>_PROJECTS,'align' => "center"),
        );
        
        
        (isset($_GET['lporder']) && $_GET['lporder'] == 'desc') ? $lporder = SORT_DESC : $lporder = SORT_ASC;
        
        if (isset($_GET['lpsort_by'])) {
            switch($_GET['lpsort_by']) {
                case 'lesson':
                    array_multisort($professorLessonNames, $lporder, $professorTimes, $professorContent, $professorTests, $professorProjects);
                    break;
                case 'time':
                    array_multisort($professorTotalSeconds, $lporder, $professorLessonNames, $professorTimes, $professorContent, $professorTests, $professorProjects);
                    break;
                case 'content':
                    array_multisort($professorContent, $lporder, $professorTimes, $professorLessonNames, $professorTests, $professorProjects);
                    break;
                case 'tests':
                    array_multisort($professorTests, $lporder, $professorTimes, $professorLessonNames, $professorContent, $professorProjects);
                    break;
                case 'projects':
                    array_multisort($professorProjects, $lporder, $professorTimes, $professorLessonNames, $professorTests, $professorContent);
                    break;
                default:break;
            }
        }
        
        foreach ($professor_lesson_titles_list as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
            if (isset($_GET['lpsort_by']) && $key == $_GET['lpsort_by']) {
                if (isset($_GET['lporder']) && $_GET['lporder'] == 'desc') {
                    $order_str = '&lporder=asc';
                    $professor_lesson_titles_list[$key]['arrow'] = '&uarr;';
                } else {
                    $order_str = '&lporder=desc';
                    $professor_lesson_titles_list[$key]['arrow'] = '&darr;';
                }
                $professor_lesson_titles_list[$key]['link'] .= $order_str.'';
            } else {
                $professor_lesson_titles_list[$key]['link'] .= '&lporder=desc';
                $professor_lesson_titles_list[$key]['arrow'] = '';
            }
        }
        
        $user_student_lesson_info               = array();
        $user_student_lesson_info['lessons']    = $studentLessonNames;
        $user_student_lesson_info['time']       = $userTimes;
        $user_student_lesson_info['content']    = $userContentPerc;
        $user_student_lesson_info['tests']      = $userTestsPerc;
        $user_student_lesson_info['projects']   = $userProjectsPerc;
        
        $user_professor_lesson_info             = array();
        $user_professor_lesson_info['lessons']  = $professorLessonNames;
        $user_professor_lesson_info['time']     = $professorTimes;
        $user_professor_lesson_info['content']  = $professorContent;
        $user_professor_lesson_info['tests']    = $professorTests;
        $user_professor_lesson_info['projects'] = $professorProjects;
        
        $smarty -> assign("T_STUDENT_LESSON_TITLES_LIST",   $user_lesson_titles_list);
        $smarty -> assign("T_PROFESSOR_LESSON_TITLES_LIST", $professor_lesson_titles_list);
        $smarty -> assign("T_TUSER_INFO",                   $user_info);
        $smarty -> assign("T_STUDENT_LESSON_INFO",          $user_student_lesson_info);
        $smarty -> assign("T_PROFESSOR_LESSON_INFO",        $user_professor_lesson_info);
        
        
        /*courses*/
        $studentCourses = array();
        $professorCourses = array();
        $courses = $currentUser -> getCourses(false);
        foreach ($courses as $course_id => $type){
            if ($type == 'student'){
                $studentCourses[$course_id] = new EfrontCourse($course_id);
            }
            else if ($type == 'professor'){
                $professorCourses[$course_id] = new EfrontCourse($course_id);
            }
        }
        
        $studentCourseNames      = array();
        $studentCourseLessons    = array();
        $studentCourseCompleted  = array();
        $studentCourseScores     = array();
        foreach ($studentCourses as $course_id  => $course){
            $studentCourseNames[$course_id]     = $course -> course['name'];
            $studentCourseLessons[$course_id]   = sizeof($course -> getLessons(false));
            $status                             = EfrontStats :: getStudentsCourseStatus($course, $currentLesson -> user['login']);
            $studentCourseCompleted[$course_id] = $status[$currentUser -> user['login']]['completed_str'];
            $studentCourseScores[$course_id]    = $status[$currentUser -> user['login']]['score'];
        }
        
        $user_course_titles_list = array(
            'course'    => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&scsort_by=course&tab=courses&sel_user='.$currentUser -> user['login'],'text' =>_COURSE,'align' => "left"),
            'lessons'   => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&scsort_by=lessons&tab=courses&sel_user='.$currentUser -> user['login'],'text' =>_LESSONS,'align' => "center"),
            'score'     => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&scsort_by=score&tab=courses&sel_user='.$currentUser -> user['login'],'text' =>_SCORE,'align' => "center"),
            'completed' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&scsort_by=completed&tab=courses&sel_user='.$currentUser -> user['login'],'text' =>_COMPLETED,'align' => "center")
        );
        
        (isset($_GET['scorder']) && $_GET['scorder'] == 'desc') ? $scorder = SORT_DESC : $scorder = SORT_ASC;
        
        if (isset($_GET['scsort_by'])) {
            switch($_GET['scsort_by']) {
                case 'course':
                    array_multisort($studentCourseNames, $scorder, $studentCourseLessons, $studentCourseScores, $studentCourseCompleted);
                    break;
                case 'lessons':
                    array_multisort($studentCourseLessons, $scorder, $studentCourseNames, $studentCourseScores, $studentCourseCompleted);
                    break;
                case 'score':
                    array_multisort($studentCourseScores, $scorder, $studentCourseLessons, $studentCourseNames, $studentCourseCompleted);
                    break;
                case 'completed':
                    array_multisort($studentCourseCompleted, $scorder, $studentCourseLessons, $studentCourseNames, $studentCourseScores);
                    break;
                default:break;
            }
        }
        
        foreach ($user_course_titles_list as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
            if (isset($_GET['scsort_by']) && $key == $_GET['scsort_by']) {
                if (isset($_GET['scorder']) && $_GET['scorder'] == 'desc') {
                    $order_str = '&scorder=asc';
                    $user_course_titles_list[$key]['arrow'] = '&uarr;';
                } else {
                    $order_str = '&scorder=desc';
                    $user_course_titles_list[$key]['arrow'] = '&darr;';
                }
                $user_course_titles_list[$key]['link'] .= $order_str.'';
            } else {
                $user_course_titles_list[$key]['link'] .= '&scorder=desc';
                $user_course_titles_list[$key]['arrow'] = '';
            }
        }
        
        
        $professorCourseNames      = array();
        $professorCourseLessons    = array();
        $professorCourseStudents   = array();
        $professorCourseProfessors = array();
        foreach ($professorCourses as $course_id => $course){
            $professorCourseNames[$course_id]   = $course -> course['name'];
            $professorCourseLessons[$course_id] = sizeof($course -> getLessons(false));
            $cusers = $course -> getUsers(false);
            $professorCourseStudents[$course_id]   = 0;
            $professorCourseProfessors[$course_id] = 0;
            foreach ($cusers as $login => $cuser){
                if ($cuser['user_type'] == 'student'){
                    $professorCourseStudents[$course_id]++;
                }
                else if ($cuser['user_type'] == 'professor'){
                    $professorCourseProfessors[$course_id]++;
                }
            }
        }
        
        $professor_course_titles_list = array(
            'course'   => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&pcsort_by=course&tab=courses&sel_user='.$currentUser -> user['login'],'text' =>_COURSE,'align' => "left"),
            'lessons'  => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&pcsort_by=lessons&tab=courses&sel_user='.$currentUser -> user['login'],'text' =>_LESSONS,'align' => "center"),
            'students' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&pcsort_by=students&tab=courses&sel_user='.$currentUser -> user['login'],'text' =>_STUDENTS,'align' => "center"),
            'professors' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=user&pcsort_by=professors&tab=courses&sel_user='.$currentUser -> user['login'],'text' =>_PROFESSORS,'align' => "center")
        );
        
        (isset($_GET['pcorder']) && $_GET['pcorder'] == 'desc') ? $pcorder = SORT_DESC : $pcorder = SORT_ASC;
        
        if (isset($_GET['pcsort_by'])) {
            switch($_GET['pcsort_by']) {
                case 'course':
                    array_multisort($professorCourseNames, $pcorder, $professorCourseLessons, $professorCourseStudents, $professorCourseProfessors);
                    break;
                case 'lessons':
                    array_multisort($professorCourseLessons, $pcorder, $professorCourseNames, $professorCourseStudents, $professorCourseProfessors);
                    break;
                case 'students':
                    array_multisort($professorCourseStudents, $pcorder, $professorCourseLessons, $professorCourseNames, $professorCourseProfessors);
                    break;
                case 'professors':
                    array_multisort($professorCourseProfessors, $pcorder, $professorCourseLessons, $professorCourseNames, $professorCourseStudents);
                    break;
                default:break;
            }
        }
        
        foreach ($professor_course_titles_list as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
            if (isset($_GET['pcsort_by']) && $key == $_GET['pcsort_by']) {
                if (isset($_GET['pcorder']) && $_GET['pcorder'] == 'desc') {
                    $order_str = '&pcorder=asc';
                    $professor_course_titles_list[$key]['arrow'] = '&uarr;';
                } else {
                    $order_str = '&pcorder=desc';
                    $professor_course_titles_list[$key]['arrow'] = '&darr;';
                }
                $professor_course_titles_list[$key]['link'] .= $order_str.'';
            } else {
                $professor_course_titles_list[$key]['link'] .= '&pcorder=desc';
                $professor_course_titles_list[$key]['arrow'] = '';
            }
        }
        
        $smarty -> assign("T_STUDENT_COURSE_TITLES",       $user_course_titles_list);
        $smarty -> assign("T_PROFESSOR_COURSE_TITLES",     $professor_course_titles_list);
        $smarty -> assign("T_STUDENT_COURSE_NAMES",        $studentCourseNames);
        $smarty -> assign("T_STUDENT_COURSE_LESSONS",      $studentCourseLessons);
        $smarty -> assign("T_STUDENT_COURSE_SCORES",       $studentCourseScores);
        $smarty -> assign("T_STUDENT_COURSE_COMPLETED",    $studentCourseCompleted);
        $smarty -> assign("T_PROFESSOR_COURSE_NAMES",      $professorCourseNames);
        $smarty -> assign("T_PROFESSOR_COURSE_LESSONS",    $professorCourseLessons);
        $smarty -> assign("T_PROFESSOR_COURSE_STUDENTS",   $professorCourseStudents);
        $smarty -> assign("T_PROFESSOR_COURSE_PROFESSORS", $professorCourseProfessors);
        
        //user traffic
        if (isset($_GET['from_year'])){ //the admin has chosen a user period
            $from = mktime($_GET['from_hour'],$_GET['from_min'],0,$_GET['from_month'],$_GET['from_day'],$_GET['from_year']);
            $to = mktime($_GET['to_hour'],$_GET['to_min'],0,$_GET['to_month'],$_GET['to_day'],$_GET['to_year']);
            $smarty->assign("T_FROM_TIMESTAMP", $from);
            $smarty->assign("T_TO_TIMESTAMP", $to);
            if (isset($_GET['user']))
                $u_id = $_GET['user'];
            else
                $u_id = $user_id[0]['login'];
            $traffic = array();
            $interval = array();
            $interval['from'] = $from;
            $interval['to'] = $to;
            $traffic = ef_getUserStatistics($u_id,$interval);
            $smarty -> assign("T_USER_TRAFFIC",$traffic);
            if (isset($_GET['showlog']) && $_GET['showlog']=="true"){
                    $smarty -> assign("T_USER_LOG",ef_getUserLog($u_id, $interval));
                }
        }
        else{
                $from = mktime(date("H"), date("i"), 0, date("m") ,date("d")-7,   date("Y"));
                    $to = mktime(date("H"), date("i"), 0, date("m") ,date("d"),   date("Y"));
                $smarty -> assign('T_FROM_TIMESTAMP', $from);
                    $smarty -> assign('T_TO_TIMESTAMP',   $to);
                    if (isset($_GET['user']))
                    $u_id = $_GET['user'];
                else
                    $u_id = $user_id[0]['login'];
                $traffic = array();
                $interval = array();
                $interval['from'] = $from;
                $interval['to'] = $to;
                $traffic = ef_getUserStatistics($u_id,$interval);
                $smarty -> assign("T_USER_TRAFFIC",$traffic);

        }
    }
}
else if ($_GET['option'] == 'course'){
    $smarty -> assign("T_OPTION", $_GET['option']);
    if (isset($_GET['sel_course'])){
        $course_id = $_GET['sel_course'];
        $currentCourse = new EfrontCourse($course_id);
        $smarty -> assign("T_COURSE_NAME", $currentCourse -> course['name']);
        $smarty -> assign("T_COURSE_ID", $course_id);
        $basic_info = array();
        $basic_info['id'] = $course_id;
        $basic_info['name'] = $currentCourse -> course['name'];
        $direction_data = ef_getTableData("directions", "name", "id=".$currentCourse -> course['directions_ID']);
        if (sizeof($direction_data) > 0){
            $basic_info['direction'] = $direction_data[0]['name'];
        }
        else{
            $basic_info['direction'] = "---";
        }
        $basic_info['lessons'] = sizeof($currentCourse -> getLessons(false));
        $basic_info['professors'] = 0;
        $basic_info['students'] = 0;
        $courseUsers = $currentCourse -> getUsers(false);
        $student_logins = array();
        $professor_logins = array();
        foreach ($courseUsers as $login => $user){
            if ($user['user_type'] == 'student'){
                $basic_info['students']++;
                $student_logins[] = $login;
            }
            else if ($user['user_type'] == 'professor'){
                $basic_info['professors']++;
                $professor_logins[] = $login;
            }
        }
        $basic_info['language'] = $currentCourse -> course['languages_NAME'];
        $basic_info['price']    = $currentCourse -> course['price'].' '.$GLOBALS['configuration']['currency'];
        
        $smarty -> assign("T_COURSE_INFO", $basic_info);
        $status = EfrontStats :: getStudentsCourseStatus($currentCourse, $student_logins);
        $courseStudentNames     = array();
        $courseStudentSurnames  = array();
        $courseStudentScores    = array();
        $courseStudentCompleted = array();
        $courseStudentLogins    = array();
        foreach ($student_logins as $login){
            $user = EfrontUserFactory :: factory($login);
            $courseStudentNames[$login]       = $user -> user['name'];
            $courseStudentSurnames[$login]    = $user -> user['surname'];
            $courseStudentScores[$login]      = round($status[$login]['score'], 2);
            $courseStudentCompleted[$login]   = $status[$login]['completed_str'];
            $courseStudentLogins[$login]      = $login;
        }
        
        
        $course_student_titles_list = array(
            'login'     => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&usort_by=login&tab=users&sel_course='.$course_id,'text' =>_LOGIN,'align' => "left"),
            'name'      => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&usort_by=name&tab=users&sel_course='.$course_id,'text' =>_NAME,'align' => "left"),
            'surname'   => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&usort_by=surname&tab=users&sel_course='.$course_id,'text' =>_SURNAME,'align' => "left"),
            'score'     => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&usort_by=score&tab=users&sel_course='.$course_id,'text' =>_SCORE,'align' => "center"),
            'completed' => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&usort_by=completed&tab=users&sel_course='.$course_id,'text' =>_COMPLETED,'align' => "center")
        );
        
        (isset($_GET['uorder']) && $_GET['uorder'] == 'desc') ? $uorder = SORT_DESC : $uorder = SORT_ASC;
        
        if (isset($_GET['usort_by'])) {
            switch($_GET['usort_by']) {
                case 'login':
                    array_multisort($courseStudentLogins, $uorder, $courseStudentNames, $courseStudentSurnames, $courseStudentScores, $courseStudentCompleted);
                    break;
                case 'name':
                    array_multisort($courseStudentNames, $uorder, $courseStudentLogins, $courseStudentSurnames, $courseStudentScores, $courseStudentCompleted);
                    break;
                case 'surname':
                    array_multisort($courseStudentSurnames, $uorder, $courseStudentNames, $courseStudentLogins, $courseStudentScores, $courseStudentCompleted);
                    break;
                case 'score':
                    array_multisort($courseStudentScores, $uorder, $courseStudentNames, $courseStudentSurnames, $courseStudentLogins, $courseStudentCompleted);
                    break;
                case 'completed':
                    array_multisort($courseStudentCompleted, $uorder, $courseStudentNames, $courseStudentSurnames, $courseStudentScores, $courseStudentLogins);
                    break;
                default:break;
            }
        }
        
        foreach ($course_student_titles_list as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
            if (isset($_GET['usort_by']) && $key == $_GET['usort_by']) {
                if (isset($_GET['uorder']) && $_GET['uorder'] == 'desc') {
                    $order_str = '&uorder=asc';
                    $course_student_titles_list[$key]['arrow'] = '&uarr;';
                } else {
                    $order_str = '&uorder=desc';
                    $course_student_titles_list[$key]['arrow'] = '&darr;';
                }
                $course_student_titles_list[$key]['link'] .= $order_str.'';
            } else {
                $course_student_titles_list[$key]['link'] .= '&uorder=desc';
                $course_student_titles_list[$key]['arrow'] = '';
            }
        }
        
        $courseProfessorNames     = array();
        $courseProfessorSurnames  = array();
        $courseProfessorLogins    = array();
        foreach ($professor_logins as $login){
            $user = EfrontUserFactory :: factory($login);
            $courseProfessorNames[$login]       = $user -> user['name'];
            $courseProfessorSurnames[$login]    = $user -> user['surname'];
            $courseProfessorLogins[$login]      = $login;
        }
        
        
        $course_professor_titles_list = array(
            'login'     => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&psort_by=login&tab=users&sel_course='.$course_id,'text' =>_LOGIN,'align' => "left"),
            'name'      => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&psort_by=name&tab=users&sel_course='.$course_id,'text' =>_NAME,'align' => "left"),
            'surname'   => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&psort_by=surname&tab=users&sel_course='.$course_id,'text' =>_SURNAME,'align' => "left")
        );
        
        (isset($_GET['porder']) && $_GET['porder'] == 'desc') ? $porder = SORT_DESC : $porder = SORT_ASC;
        
        if (isset($_GET['psort_by'])) {
            switch($_GET['psort_by']) {
                case 'login':
                    array_multisort($courseProfessorLogins, $porder, $courseProfessorNames, $courseProfessorSurnames);
                    break;
                case 'name':
                    array_multisort($courseProfessorNames, $porder, $courseProfessorLogins, $courseProfessorSurnames);
                    break;
                case 'surname':
                    array_multisort($courseProfessorSurnames, $porder, $courseProfessorNames, $courseProfessorLogins);
                    break;
                default:break;
            }
        }
        
        foreach ($course_professor_titles_list as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
            if (isset($_GET['psort_by']) && $key == $_GET['psort_by']) {
                if (isset($_GET['porder']) && $_GET['porder'] == 'desc') {
                    $order_str = '&porder=asc';
                    $course_professor_titles_list[$key]['arrow'] = '&uarr;';
                } else {
                    $order_str = '&porder=desc';
                    $course_professor_titles_list[$key]['arrow'] = '&darr;';
                }
                $course_professor_titles_list[$key]['link'] .= $order_str.'';
            } else {
                $course_professor_titles_list[$key]['link'] .= '&porder=desc';
                $course_professor_titles_list[$key]['arrow'] = '';
            }
        }
        
        
        $smarty -> assign("T_COURSE_STUDENT_TITLES",     $course_student_titles_list);
        $smarty -> assign("T_COURSE_PROFESSOR_TITLES",   $course_professor_titles_list);
        $smarty -> assign("T_COURSE_STUDENT_LOGINS",     $courseStudentLogins);
        $smarty -> assign("T_COURSE_STUDENT_NAMES",      $courseStudentNames);
        $smarty -> assign("T_COURSE_STUDENT_SURNAMES",   $courseStudentSurnames);
        $smarty -> assign("T_COURSE_STUDENT_SCORES",     $courseStudentScores);
        $smarty -> assign("T_COURSE_STUDENT_COMPLETED",  $courseStudentCompleted);
        $smarty -> assign("T_COURSE_PROFESSOR_LOGINS",   $courseProfessorLogins);
        $smarty -> assign("T_COURSE_PROFESSOR_NAMES",    $courseProfessorNames);
        $smarty -> assign("T_COURSE_PROFESSOR_SURNAMES", $courseProfessorSurnames);
        
        
        $courseLessons = $currentCourse -> getLessons(true);
        $lessonNames = array();
        $lessonContent = array();
        $lessonTests = array();
        $lessonProjects = array();
        foreach ($courseLessons as $id => $lesson){
            $info = $lesson -> getStatisticInformation();
            $lessonNames[$id]      = $lesson -> lesson['name'];
            $lessonContent[$id]    = $info['content'];
            $lessonTests[$id]      = $info['tests'];
            $lessonProjects[$id]   = $info['projects'];
        }
        
        $course_lesson_titles_list = array(
            'lesson'    => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&lsort_by=lesson&tab=lessons&sel_course='.$course_id,'text' =>_LESSON,'align' => "left"),
            'content'   => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&lsort_by=content&tab=lessons&sel_course='.$course_id,'text' =>_CONTENT,'align' => "center"),
            'tests'      => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&lsort_by=tests&tab=lessons&sel_course='.$course_id,'text' =>_TESTS,'align' => "center"),
            'projects'   => array('link' => $_SERVER['PHP_SELF'].'?ctg=statistics&option=course&lsort_by=projects&tab=lessons&sel_course='.$course_id,'text' =>_PROJECTS,'align' => "center"),
        );
        
        (isset($_GET['lorder']) && $_GET['lorder'] == 'desc') ? $lorder = SORT_DESC : $lorder = SORT_ASC;
        
        if (isset($_GET['lsort_by'])) {
            switch($_GET['lsort_by']) {
                case 'lesson':
                    array_multisort($lessonNames, $lorder, $lessonContent, $lessonTests, $lessonProjects);
                    break;
                case 'content':
                    array_multisort($lessonContent, $lorder, $lessonTests, $lessonProjects, $lessonNames);
                    break;
                case 'tests':
                    array_multisort($lessonTests, $lorder, $lessonTests, $lessonProjects, $lessonNames);
                    break;
                case 'projects':
                    array_multisort($lessonProjects, $lorder, $lessonTests, $lessonTests, $lessonNames);
                    break;
                default:break;
            }
        }
        
        foreach ($course_lesson_titles_list as $key => $value) {                                                                                  //Depending on what is selected, change the url to show data in ascending or descending order
            if (isset($_GET['lsort_by']) && $key == $_GET['lsort_by']) {
                if (isset($_GET['lorder']) && $_GET['lorder'] == 'desc') {
                    $order_str = '&lorder=asc';
                    $course_lesson_titles_list[$key]['arrow'] = '&uarr;';
                } else {
                    $order_str = '&lorder=desc';
                    $course_lesson_titles_list[$key]['arrow'] = '&darr;';
                }
                $course_lesson_titles_list[$key]['link'] .= $order_str.'';
            } else {
                $course_lesson_titles_list[$key]['link'] .= '&lorder=desc';
                $course_lesson_titles_list[$key]['arrow'] = '';
            }
        }
        
        $smarty -> assign("T_COURSE_LESSON_TITLES",   $course_lesson_titles_list);
        $smarty -> assign("T_COURSE_LESSON_NAMES",    $lessonNames);
        $smarty -> assign("T_COURSE_LESSON_CONTENT",  $lessonContent);
        $smarty -> assign("T_COURSE_LESSON_TESTS",    $lessonTests);
        $smarty -> assign("T_COURSE_LESSON_PROJECTS", $lessonProjects);
        
    }
}
else if ($_GET['option'] == 'test'){
    $smarty -> assign("T_OPTION", $_GET['option']);
    if (isset($_GET['sel_test'])){
        $test_id = $_GET['sel_test'];
        $smarty -> assign("T_TEST_ID", $test_id);
        $test_info = ef_getTestInfo($test_id);
        $smarty -> assign("T_TEST_NAME", $test_info['common_info']['name']);
        $smarty -> assign("T_TEST_COMMON_INFO", $test_info['common_info']);
        $smarty -> assign("T_TEST_QUESTIONS", $test_info['questions']);
    }
}
else if ($_GET['option'] == 'system'){
    /*If the user is not the administrator, then */
    if ($basic_user_type != 'administrator'){
        exit;
    }
    $smarty -> assign("T_OPTION", $_GET['option']);
    $user_types = eF_getUserTypesInfo($lesson_id[0]['id']);
    $smarty->assign("T_USERTYPES_INFO",$user_types);
    if (isset($_GET['from_year'])){ //the admin has chosen a user period
        $from = mktime($_GET['from_hour'],$_GET['from_min'],0,$_GET['from_month'],$_GET['from_day'],$_GET['from_year']);
        $to = mktime($_GET['to_hour'],$_GET['to_min'],0,$_GET['to_month'],$_GET['to_day'],$_GET['to_year']);
        $smarty->assign("T_FROM_TIMESTAMP", $from);
        $smarty->assign("T_TO_TIMESTAMP", $to);
        $interval = array();
        $interval['from'] = $from;
        $interval['to'] = $to;
        $activeusers = ef_getActiveUsers($interval);
        $n = min(sizeof($activeusers['login']),20);
        for ($i=0;$i<$n;$i++){
            $active20users['login'][]=$activeusers['login'][$i];
            $active20users['access'][]=$activeusers['access'][$i];
            $active20users['time'][]=$activeusers['time'][$i];
            $active20users['secs'][] = $activeusers['secs'][$i];
        }
        $activelessons = ef_getActiveLessons($interval);
        $n = min(sizeof($activelessons['id']),20);
        for ($i=0;$i<$n;$i++){
            $active20lessons['id'][]=$activelessons['id'][$i];
            $active20lessons['name'][]=$activelessons['name'][$i];
            $active20lessons['access'][]=$activelessons['access'][$i];
            $active20lessons['time'][] = $activelessons['time'][$i];
        }
        $system_statistics = ef_getSystemStatistics($interval);
        $smarty -> assign("T_ACTIVE_USERS",$activeusers);
        $smarty -> assign("T_20ACTIVE_USERS",$active20users);
        $smarty -> assign("T_20USERS_LOGIN_IMPLODE",implode(",",$active20users['login']));
        $smarty -> assign("T_20USERS_SECONDS_IMPLODE",implode(",",$active20users['secs']));
        $smarty -> assign("T_20ACTIVE_LESSONS",$activelessons);
        $smarty -> assign("T_LESSONS_NAME_IMPLODE",implode(",",$activelessons['name']));
        $smarty -> assign("T_LESSONS_ACCESS_IMPLODE",implode(",",$activelessons['access']));
        $smarty -> assign("T_SYSTEM_STATISTICS", $system_statistics);
        if (isset($_GET['showlog']) && $_GET['showlog']=="true"){
               $smarty -> assign("T_SYSTEM_LOG",ef_getSystemLog($interval));
            }
            if (isset($_GET['showusers']) && $_GET['showusers']=="true"){
               $smarty -> assign("T_SYSTEM_ALLUSERS",$activeusers);
            }
            if (isset($_GET['showlessons']) && $_GET['showlessons']=="true"){
               $smarty -> assign("T_SYSTEM_ALLLESSONS",$activelessons);
            }

    }
    else{
        $from = mktime(date("H"), date("i"), 0, date("m") ,date("d")-7,   date("Y"));
        $to = mktime(date("H"), date("i"), 0, date("m") ,date("d"),   date("Y"));
        $smarty -> assign('T_FROM_TIMESTAMP', $from);
        $smarty -> assign('T_TO_TIMESTAMP',   $to);
        $interval = array();
        $interval['from'] = $from;
        $interval['to'] = $to;
        $activeusers = ef_getActiveUsers($interval);
        $n = min(sizeof($activeusers['login']),20);
        $active20users = array();
        for ($i=0;$i<$n;$i++){
            $active20users['login'][]=$activeusers['login'][$i];
            $active20users['access'][]=$activeusers['access'][$i];
            $active20users['time'][]=$activeusers['time'][$i];
            $active20users['secs'][] = $activeusers['secs'][$i];
        }
        $activelessons = ef_getActiveLessons($interval);
        $n = min(sizeof($activelessons['id']),20);
        for ($i=0;$i<$n;$i++){
            $active20lessons['id'][]=$activelessons['id'][$i];
            $active20lessons['name'][]=$activelessons['name'][$i];
            $active20lessons['access'][]=$activelessons['access'][$i];
            $active20lessons['time'][] = $activelessons['time'][$i];
        }
        $system_statistics = ef_getSystemStatistics($interval);
        $smarty -> assign("T_ACTIVE_USERS",$activeusers);
        $smarty -> assign("T_20USERS_LOGIN_IMPLODE",implode(",",$active20users['login']));
        $smarty -> assign("T_20USERS_SECONDS_IMPLODE",implode(",",$active20users['secs']));
        $smarty -> assign("T_20ACTIVE_USERS",$active20users);
        $smarty -> assign("T_20ACTIVE_LESSONS",$active20lessons);
        $smarty -> assign("T_LESSONS_NAME_IMPLODE",implode(",",$activelessons['name']));
        $smarty -> assign("T_LESSONS_ACCESS_IMPLODE",implode(",",$activelessons['access']));
        $smarty -> assign("T_SYSTEM_STATISTICS", $system_statistics);
    }
}
else if ($_GET['oper'] == 'export_user'){
    require_once 'Spreadsheet/Excel/Writer.php';
    if (isset($_GET['user']) && $_GET['user'] != ''){
        $login = $_GET['user'];
    }else{
        $login = $_SESSION['s_login'];
    }

    $user = EfrontUserFactory :: factory($login);
    
    $eF_WorkBook = new Spreadsheet_Excel_Writer();
    $eF_WorkBook -> setVersion(8);
    $eF_WorkBook ->send('export_'.$login.'.xls');
    $eF_formatExcelHeaders = & $eF_WorkBook -> addFormat();
    $eF_formatExcelHeaders ->setSize(14);
    $eF_formatExcelHeaders ->setBold();
    $eF_formatExcelHeaders ->setHAlign('left');

    $eF_formatContent = & $eF_WorkBook -> addFormat();
    $eF_formatContent ->setHAlign('left');
    $eF_formatContent ->setVAlign('top');
    $eF_formatContent ->setTextWrap();
    
    $hf = array('border' => 0,
                'bold'=>'1',
                'size' => '11',
                'color' => 'black',
                'fgcolor' => 22,
                'align' => 'center');
    $headerFormat =& $eF_WorkBook->addFormat($hf);  
   
    $headerBigFormat = & $eF_WorkBook -> addFormat();
    $headerBigFormat ->setHAlign('center');
    $headerBigFormat -> setFgColor(22);
    $headerBigFormat ->setSize(16); 
    $headerBigFormat ->setBold();
   
    $titleCenterFormat = & $eF_WorkBook -> addFormat();
    $titleCenterFormat ->setHAlign('center');
    $titleCenterFormat ->setSize(11); 
    $titleCenterFormat ->setBold();
   
    $titleLeftFormat = & $eF_WorkBook -> addFormat();
    $titleLeftFormat ->setHAlign('left');
    $titleLeftFormat ->setSize(11); 
    $titleLeftFormat ->setBold();
   
    $fieldLeftFormat = & $eF_WorkBook -> addFormat();
    $fieldLeftFormat ->setHAlign('left');
    $fieldLeftFormat ->setSize(10); 
    
    $fieldRightFormat = & $eF_WorkBook -> addFormat();
    $fieldRightFormat ->setHAlign('right');
    $fieldRightFormat ->setSize(10); 
    
    $fieldCenterFormat = & $eF_WorkBook -> addFormat();
    $fieldCenterFormat ->setHAlign('center');
    $fieldCenterFormat ->setSize(10); 
    
    
    
    //first tab
    $eF_workSheetUserGeneral = & $eF_WorkBook->addWorksheet("(".$user->login.") General Statistics");
    $eF_workSheetUserGeneral -> setInputEncoding('utf-8');

    $eF_workSheetUserGeneral->setColumn(0, 0, 5);
    
    $basic_info = $user -> getInformation();
    $lessons = $basic_info['student_lessons'];
    $status = array();
    $userTimes = array();
    $doneTests = array();
    $assignedProjects = array();
    foreach ($lessons as $lesson){
        $status[$lesson -> lesson['id']]           
                        = EfrontStats :: getStudentsLessonStatus($lesson -> lesson['id'], $user -> user['login']);
        $userTimes[$lesson -> lesson['id']]        
                        = EfrontStats :: getUsersTime($lesson -> lesson['id'], $user -> user['login']);
        $doneTests[$lesson -> lesson['id']]        
                        = EfrontStats :: getStudentsDoneTests($lesson -> lesson['id'], $user -> user['login']);
        $assignedProjects[$lesson -> lesson['id']] 
                        = EfrontStats :: getStudentsAssignedProjects($lesson -> lesson['id'], $user -> user['login']);
    }

    //basic info    
    $eF_workSheetUserGeneral->write(1, 1, '', $headerFormat);
    $eF_workSheetUserGeneral->write(1, 2, '', $headerFormat);
    $eF_workSheetUserGeneral->write(1, 1, _BASICINFO, $headerFormat);
    $eF_workSheetUserGeneral->mergeCells(1,1,1,2);
    $eF_workSheetUserGeneral->setColumn(1, 2, 45);      
    
    $eF_workSheetUserGeneral->write(2, 1, _LOGIN, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(2, 2, $basic_info['login'], $fieldRightFormat);
    $eF_workSheetUserGeneral->write(3, 1, _USERNAME, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(3, 2, $basic_info['fullname'], $fieldRightFormat);
    $eF_workSheetUserGeneral->write(4, 1, _USERTYPE, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(4, 2, $basic_info['user_type'], $fieldRightFormat);
    $eF_workSheetUserGeneral->write(5, 1, _LESSONS, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(5, 2, sizeof($basic_info['lessons']), $fieldRightFormat);
    $eF_workSheetUserGeneral->write(6, 1, _TOTALLOGINTIME, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(6, 2, $basic_info['total_login_time']['hours']."h ".
        $basic_info['total_login_time']['minutes']."' ".$basic_info['total_login_time']['seconds']."'' ", $fieldRightFormat);
    $eF_workSheetUserGeneral->write(7, 1, _LANGUAGE, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(7, 2, $basic_info['language'], $fieldRightFormat);
    $eF_workSheetUserGeneral->write(8, 1, _ACTIVE, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(8, 2, $basic_info['active_str'], $fieldRightFormat);
    $eF_workSheetUserGeneral->write(9, 1, _JOINED, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(9, 2, $basic_info['joined_str'], $fieldRightFormat);
    
    //communication info
    $communication_info = EfrontStats::getUserCommunicationInfo($user);
    
    $eF_workSheetUserGeneral->write(10, 1, '', $headerFormat);
    $eF_workSheetUserGeneral->write(10, 2, '', $headerFormat);
    $eF_workSheetUserGeneral->write(10, 1, _USERCOMMUNICATIONINFO, $headerFormat);
    $eF_workSheetUserGeneral->mergeCells(10,1,10,2);
    $eF_workSheetUserGeneral->setColumn(10, 2, 45);     
    $eF_workSheetUserGeneral->write(11, 1, _FORUMPOSTS, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(11, 2, sizeof($communication_info['forum_messages']), $fieldRightFormat);
    $eF_workSheetUserGeneral->write(12, 1, _FORUMLASTMESSAGE, $fieldLeftFormat);
    if (sizeof($communication_info['forum_messages'])){
        $last = current($communication_info['forum_messages']);
        $last_message = strftime('%d-%m-%Y, %H:%M:%S', $last['timestamp']);
    }
    else{
        $last_message = "---";
    }
    $eF_workSheetUserGeneral->write(12, 2, $last_message, $fieldRightFormat);
    $eF_workSheetUserGeneral->write(13, 1, _PERSONALMESSAGES, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(13, 2, sizeof($communication_info['personal_messages']), $fieldRightFormat);
    $eF_workSheetUserGeneral->write(14, 1, _MESSAGESFOLDERS, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(14, 2, sizeof($communication_info['personal_folders']), $fieldRightFormat);
    $eF_workSheetUserGeneral->write(15, 1, _FILES, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(15, 2, sizeof($communication_info['files']), $fieldRightFormat);
    $eF_workSheetUserGeneral->write(16, 1, _FOLDERS, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(16, 2, sizeof($communication_info['folders']), $fieldRightFormat);
    $eF_workSheetUserGeneral->write(17, 1, _TOTALSIZE, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(17, 2, sizeof($communication_info['total_size'])."KB", $fieldRightFormat);
    $eF_workSheetUserGeneral->write(18, 1, _CHATMESSAGES, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(18, 2, sizeof($communication_info['chat_messages']), $fieldRightFormat);
    $eF_workSheetUserGeneral->write(19, 1, _CHATLASTMESSAGE, $fieldLeftFormat);
    if (sizeof($communication_info['chat_messages'])){
        $last = current($communication_info['chat_messages']);
        $last_message = strftime('%d-%m-%Y, %H:%M:%S', $last['timestamp']);
    }
    else{
        $last_message = "---";
    }
    $eF_workSheetUserGeneral->write(19, 2, $last_message, $fieldRightFormat);
    $eF_workSheetUserGeneral->write(20, 1, _COMMENTS, $fieldLeftFormat);
    $eF_workSheetUserGeneral->write(20, 2, sizeof($communication_info['comments']), $fieldRightFormat);
    
    
    //usage info
    $usage_info = EfrontStats::getUserUsageInfo($user);
    $eF_workSheetUserGeneral->write(21, 1, '', $headerFormat);
    $eF_workSheetUserGeneral->write(21, 2, '', $headerFormat);
    $eF_workSheetUserGeneral->write(21, 1, _USERUSAGEINFO, $headerFormat);
    $eF_workSheetUserGeneral->mergeCells(21, 1, 21, 2);
    $eF_workSheetUserGeneral->setColumn(21, 2, 45);    
    if (sizeof($usage_info['logins'])){
        $last = current($usage_info['logins']);
        $last_login = strftime('%d-%m-%Y, %H:%M:%S', $last['timestamp']);
    }
    else{
        $last_login = "---";
    }
    $eF_workSheetUserGeneral -> write(23, 1, _LASTLOGIN, $fieldLeftFormat);
    $eF_workSheetUserGeneral -> write(23, 2, $last_login, $fieldRightFormat);
    $eF_workSheetUserGeneral -> write(24, 1, _TOTALLOGINS, $fieldLeftFormat);
    $eF_workSheetUserGeneral -> write(24, 2, sizeof($usage_info['logins']), $fieldRightFormat);
    $eF_workSheetUserGeneral -> write(25, 1, _MONTHLOGINS, $fieldLeftFormat);
    $eF_workSheetUserGeneral -> write(25, 2, sizeof($usage_info['month_logins']), $fieldRightFormat);
    $eF_workSheetUserGeneral -> write(26, 1, _WEEKLOGINS, $fieldLeftFormat);
    $eF_workSheetUserGeneral -> write(26, 2, sizeof($usage_info['week_logins']), $fieldRightFormat);
    $eF_workSheetUserGeneral -> write(27, 1, _MEANDURATION, $fieldLeftFormat);
    $eF_workSheetUserGeneral -> write(27, 2, $usage_info['mean_duration']."'", $fieldRightFormat);
    $eF_workSheetUserGeneral -> write(28, 1, _MONTHMEANDURATION, $fieldLeftFormat);
    $eF_workSheetUserGeneral -> write(28, 2, $usage_info['month_mean_duration']."'", $fieldRightFormat);
    $eF_workSheetUserGeneral -> write(29, 1, _WEEKMEANDURATION, $fieldLeftFormat);
    $eF_workSheetUserGeneral -> write(29, 2, $usage_info['week_mean_duration']."'", $fieldRightFormat);
    
    
    //lesson users info
    $eF_workSheetUserGeneral -> write(1, 4, '', $headerFormat);
    $eF_workSheetUserGeneral -> write(1, 5, '', $headerFormat);
    $eF_workSheetUserGeneral -> write(1, 6, '', $headerFormat);
    $eF_workSheetUserGeneral -> write(1, 7, '', $headerFormat);
    $eF_workSheetUserGeneral -> write(1, 8, '', $headerFormat);
    $eF_workSheetUserGeneral -> write(1, 9, '', $headerFormat);
    $eF_workSheetUserGeneral -> write(1, 10, '', $headerFormat);
    $eF_workSheetUserGeneral -> write(1, 4, _LESSONSINFO, $headerFormat);
    $eF_workSheetUserGeneral -> mergeCells(1,4,1,10);
    $eF_workSheetUserGeneral -> setColumn(4, 10, 15);    
    
    $eF_workSheetUserGeneral -> write(2, 4, _LESSON, $titleLeftFormat);
    $eF_workSheetUserGeneral -> write(2, 5, _TIME, $titleCenterFormat);
    $eF_workSheetUserGeneral -> write(2, 6, _CONTENT, $titleCenterFormat);
    $eF_workSheetUserGeneral -> write(2, 7, _TESTS, $titleCenterFormat);
    $eF_workSheetUserGeneral -> write(2, 8, _PROJECTS, $titleCenterFormat);
    $eF_workSheetUserGeneral -> write(2, 9, _COMPLETED, $titleCenterFormat);
    $eF_workSheetUserGeneral -> write(2, 10, _GRADE, $titleCenterFormat);
    
    $row = 3;
    foreach ($lessons as $lesson){
        $eF_workSheetUserGeneral -> write($row, 4, $lesson -> lesson['name'], $fieldLeftFormat);
        $eF_workSheetUserGeneral -> write($row, 5, 
                    $userTimes[$lesson -> lesson['id']][$user -> user['login']]['hours']."h ".$userTimes[$lesson -> lesson['id']][$user -> user['login']]['minutes']."' ".$userTimes[$lesson -> lesson['id']][$user -> user['login']]['seconds']."'' ", $fieldCenterFormat);
        $eF_workSheetUserGeneral -> write($row, 6, $status[$lesson -> lesson['id']][$user -> user['login']]['percentage_done']."%", $fieldCenterFormat);
        $eF_workSheetUserGeneral -> write($row, 7, $status[$lesson -> lesson['id']][$user -> user['login']]['percentage_tests']."%", $fieldCenterFormat);
        $eF_workSheetUserGeneral -> write($row, 8, $status[$lesson -> lesson['id']][$user -> user['login']]['percentage_projects']."%", $fieldCenterFormat);
        if ($status[$lesson -> lesson['id']][$user -> user['login']]['lesson_passed']){
            $msg = _YES;
        }
        else{
            $msg = _NO;
        }
        $eF_workSheetUserGeneral -> write($row, 9, $msg, $fieldCenterFormat);
        $eF_workSheetUserGeneral -> write($row, 10, $status[$lesson -> lesson['id']][$user -> user['login']]['score'], $fieldCenterFormat);
        $row++;
    }
    
    $row++;
    
    
    //course users info
    $courses = $user -> getCourses(true);
    $eF_workSheetUserGeneral -> write($row, 4, '', $headerFormat);
    $eF_workSheetUserGeneral -> write($row, 5, '', $headerFormat);
    $eF_workSheetUserGeneral -> write($row, 6, '', $headerFormat);
    $eF_workSheetUserGeneral -> write($row, 7, '', $headerFormat);
    $eF_workSheetUserGeneral -> write($row, 8, '', $headerFormat);
    $eF_workSheetUserGeneral -> write($row, 9, '', $headerFormat);
    $eF_workSheetUserGeneral -> write($row, 10, '', $headerFormat);
    $eF_workSheetUserGeneral -> write($row, 4, _COURSESINFO, $headerFormat);
    $eF_workSheetUserGeneral -> mergeCells($row, 4, $row, 10);
    $eF_workSheetUserGeneral -> setColumn($row, 10, 15);    
    
    $row++;
    $eF_workSheetUserGeneral -> write($row, 4, _COURSE, $titleLeftFormat);
    $eF_workSheetUserGeneral -> write($row, 5, _LESSONS, $titleCenterFormat);
    $eF_workSheetUserGeneral -> write($row, 6, _SCORE, $titleCenterFormat);
    $eF_workSheetUserGeneral -> write($row, 7, _COMPLETED, $titleCenterFormat);
    foreach ($courses as $course){
        $row++;
        $status = EfrontStats :: getStudentsCourseStatus($course, $user -> user['login']);
        $eF_workSheetUserGeneral -> write($row, 4, $course -> course['name'], $fieldLeftFormat);
        $eF_workSheetUserGeneral -> write($row, 5, sizeof($course -> getLessons()), $fieldCenterFormat);
        $eF_workSheetUserGeneral -> write($row, 6, $status[$user -> user['login']]['score']."%", $fieldCenterFormat);
        $eF_workSheetUserGeneral -> write($row, 7, $status[$user -> user['login']]['completed_str'], $fieldCenterFormat);
    }

    
    
    //add a separate sheet for each distinct lesson of that user
    $i = 0;
    $lessons = $user -> getLessons(true);
    $eF_workSheetLessonStudent = array();
    foreach ($lessons as $lesson){
        $eF_workSheetLessonStudent[$i] = & $eF_WorkBook->addWorksheet("Lesson " . $lesson -> lesson['id']);
        $eF_workSheetLessonStudent[$i] -> setInputEncoding('utf-8');
        for ($j = 0; $j < 9; $j++){
            $eF_workSheetLessonStudent[$i] -> write(0, $j, '', $headerBigFormat);
            $eF_workSheetLessonStudent[$i] -> write(0, 0, $lesson -> lesson['name'], $headerBigFormat);
            $eF_workSheetLessonStudent[$i]->mergeCells(0, 0, 0, 9);
        }
        for ($j = 0; $j < 9; $j++){
            $eF_workSheetLessonStudent[$i] -> write(1, $j, '', $fieldCenterFormat);
            $eF_workSheetLessonStudent[$i] -> write(1, 0, $user -> user['login']."-".$user -> user['name']." ".$user -> user['surname'], $fieldCenterFormat);
            $eF_workSheetLessonStudent[$i]->mergeCells(1, 0, 1, 9);
        }
        $eF_workSheetLessonStudent[$i]->setColumn(0, 0, 20);  
        $eF_workSheetLessonStudent[$i]->setColumn(1, 1, 10);
        $eF_workSheetLessonStudent[$i]->setColumn(2, 2, 5);
        
        $eF_workSheetLessonStudent[$i] -> write(3, 0, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(3, 1, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(3, 0, _TIMEINLESSON, $headerFormat);
        $eF_workSheetLessonStudent[$i]->mergeCells(3, 0, 3, 1);
        
        $eF_workSheetLessonStudent[$i] -> write(4, 0, '', $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(4, 1, '', $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(4, 0, 
                    $userTimes[$lesson -> lesson['id']][$user -> user['login']]['hours']."h ".$userTimes[$lesson -> lesson['id']][$user -> user['login']]['minutes']."' ".$userTimes[$lesson -> lesson['id']][$user -> user['login']]['seconds']."''", 
                    $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells(4, 0, 4, 1);
        
        $eF_workSheetLessonStudent[$i] -> write(5, 0, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(5, 1, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(5, 0, _STATUS, $headerFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells(5, 0, 5, 1);
        if ($status[$lesson -> lesson['id']][$user -> user['login']]['score']){
            $msg = _YES;
        }
        else{
            $msg = _NO;
        }
        $eF_workSheetLessonStudent[$i] -> write(6, 0, _COMPLETED, $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(6, 1, $msg, $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(7, 0, _GRADE, $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(7, 1, $status[$lesson -> lesson['id']][$user -> user['login']]['score'], $fieldCenterFormat);
        
        $eF_workSheetLessonStudent[$i] -> write(8, 0, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(8, 1, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(8, 0, _CONTENT, $headerFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells(8, 0, 8, 1);
        
        $eF_workSheetLessonStudent[$i] -> write(9, 0, '', $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(9, 1, '', $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(9, 0, $status[$lesson -> lesson['id']][$user -> user['login']]['percentage_done']."%", $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells(9, 0, 9, 1);
        
        $eF_workSheetLessonStudent[$i] -> write(10, 0, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(10, 1, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(10, 0, _TESTS, $headerFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells(10, 0, 10, 1);
        $row = 11;
        foreach ($doneTests[$lesson -> lesson['id']][$user -> user['login']] as $test){
            $eF_workSheetLessonStudent[$i] -> write($row, 0, $test['name'], $fieldCenterFormat);
            $eF_workSheetLessonStudent[$i] -> write($row, 1, ($test['score']*100)."%", $fieldCenterFormat);
            $row++;
        }
        
        $eF_workSheetLessonStudent[$i] -> write($row, 0, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write($row, 1, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write($row, 0, _PROJECTS, $headerFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells($row, 0, $row, 1);
        $row++;
        foreach ($assignedProjects[$lesson -> lesson['id']][$user -> user['login']] as $project){
            $eF_workSheetLessonStudent[$i] -> write($row, 0, $project['title'], $fieldCenterFormat);
            $eF_workSheetLessonStudent[$i] -> write($row, 1, $project['grade']."%", $fieldCenterFormat);
            $row++;
        }
    }
    
    $eF_WorkBook -> close();
    exit(0);
}
else if ($_GET['oper'] == 'export_lesson'){
    require_once 'Spreadsheet/Excel/Writer.php';
            
    if( isset($_GET['sel_lesson']) && $_GET['sel_lesson'] != ''){
        $lesson_id = $_GET['sel_lesson'];
    }else{
        $lesson_id = $_SESSION['s_lessons_ID'];
    }
    $lesson = new EfrontLesson($lesson_id);
    $eF_WorkBook = new Spreadsheet_Excel_Writer();
    $eF_WorkBook -> setVersion(8);
    $eF_WorkBook ->send('export_'.$lesson -> lesson['name'].'.xls');
    $eF_formatExcelHeaders = & $eF_WorkBook -> addFormat();
    $eF_formatExcelHeaders ->setSize(14);
    $eF_formatExcelHeaders ->setBold();
    $eF_formatExcelHeaders ->setHAlign('left');

    $eF_formatContent = & $eF_WorkBook -> addFormat();
    $eF_formatContent ->setHAlign('left');
    $eF_formatContent ->setVAlign('top');
    $eF_formatContent ->setTextWrap();
    
    $hf = array('border' => 0,
                'bold'=>'1',
                'size' => '11',
                'color' => 'black',
                'fgcolor' => 22,
                'align' => 'center');
    $headerFormat =& $eF_WorkBook->addFormat($hf);  
   
    $headerBigFormat = & $eF_WorkBook -> addFormat();
    $headerBigFormat ->setHAlign('center');
    $headerBigFormat -> setFgColor(22);
    $headerBigFormat ->setSize(16); 
    $headerBigFormat ->setBold();
   
    $titleCenterFormat = & $eF_WorkBook -> addFormat();
    $titleCenterFormat ->setHAlign('center');
    $titleCenterFormat ->setSize(11); 
    $titleCenterFormat ->setBold();
   
    $titleLeftFormat = & $eF_WorkBook -> addFormat();
    $titleLeftFormat ->setHAlign('left');
    $titleLeftFormat ->setSize(11); 
    $titleLeftFormat ->setBold();
   
    $fieldLeftFormat = & $eF_WorkBook -> addFormat();
    $fieldLeftFormat ->setHAlign('left');
    $fieldLeftFormat ->setSize(10); 
    
    $fieldRightFormat = & $eF_WorkBook -> addFormat();
    $fieldRightFormat ->setHAlign('right');
    $fieldRightFormat ->setSize(10); 
    
    $fieldCenterFormat = & $eF_WorkBook -> addFormat();
    $fieldCenterFormat ->setHAlign('center');
    $fieldCenterFormat ->setSize(10); 
    


    if (isset($_GET['group_filter']) && $_GET['group_filter'] > 0){
        $lesson_info = eF_getLessonInfo($lesson_id, $_GET['group_filter']);
    }
    else{
        $lesson_info = eF_getLessonInfo($lesson_id);
    }
    
    foreach ($lesson_info['tests']['done_test'] as $key => $done_test) {
        array_multisort($lesson_info['tests']['done_test'][$key]['users_LOGIN'],SORT_ASC,$lesson_info['tests']['done_test'][$key]['name'] , $lesson_info['tests']['done_test'][$key]['surname'],$lesson_info['tests']['done_test'][$key]['score'], $lesson_info['tests']['done_test'][$key]['timestamp'], $lesson_info['tests']['done_test'][$key]['id'], $lesson_info['tests']['done_test'][$key]['tests_ID'], $lesson_info['tests']['done_test'][$key]['comments'], $lesson_info['tests']['done_test'][$key]['duration']);
    }
    foreach ($lesson_info['projects']['done_project'] as $key => $done_project) {
        array_multisort($lesson_info['projects']['done_project'][$key]['users_LOGIN'], SORT_ASC, $lesson_info['projects']['done_project'][$key]['name'],$lesson_info['projects']['done_project'][$key]['surname'],$lesson_info['projects']['done_project'][$key]['grade'],$lesson_info['projects']['done_project'][$key]['upload_timestamp']);
    }

    
    
    //first tab
    $eF_workSheetLessonGeneral = & $eF_WorkBook->addWorksheet("General Lesson Info");
    $eF_workSheetLessonGeneral -> setInputEncoding('utf-8');

    $eF_workSheetLessonGeneral->setColumn(0, 0, 5);
    
    
    //basic info    
    $eF_workSheetLessonGeneral->write(1, 1, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 2, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 1, _BASICINFO, $headerFormat);
    $eF_workSheetLessonGeneral->mergeCells(1,1,1,2);
    $eF_workSheetLessonGeneral->setColumn(1, 2, 30);              
    
    $eF_workSheetLessonGeneral->write(2, 1, _LESSON, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(2, 2, $lesson->lesson['name'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(3, 1, _CATEGORY, $fieldLeftFormat);
    $res = ef_getTableData("directions", "name", "id=".$lesson->lesson['directions_ID']);
    $direction_name = $res[0]['name'];
    $eF_workSheetLessonGeneral->write(3, 2, $direction_name, $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(4, 1, _STUDENTS, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->writeNumber(4, 2, sizeof($lesson->getUsers('student')), $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(5, 1, _PROFESSORS, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->writeNumber(5, 2, sizeof($lesson->getUsers('professor')), $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(6, 1, _PRICE, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(6, 2, $lesson->lesson['price']." Euro", $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(7, 1, _LANGUAGE, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(7, 2, $lesson->lesson['languages_NAME'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(8, 1, _ACTIVE, $fieldLeftFormat);
    if ($lesson->lesson['active'] == 1){
        $active = _YES;
    }
    else{
        $active = _NO;
    }
    $eF_workSheetLessonGeneral->write(8, 2, $active, $fieldRightFormat);
      
    //participation info
    $eF_workSheetLessonGeneral->write(9, 1, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(9, 2, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(9, 1, _LESSONPARTICIPATIONINFO, $headerFormat);
    $eF_workSheetLessonGeneral->mergeCells(9,1,9,2);
    $eF_workSheetLessonGeneral->setColumn(9, 2, 30);     
          
    $info = $lesson-> getStatisticInformation();
    $eF_workSheetLessonGeneral->write(10, 1, _COMMENTS, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(10, 2, $info['comments'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(11, 1, _MESSAGES, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(11, 2, $info['messages'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(12, 1, _CHATMESSAGES, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(12, 2, $info['chatmessages'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(13, 1, _LASTPOST, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(13, 2, "---", $fieldRightFormat);
    
    //lesson content info
    $eF_workSheetLessonGeneral->write(14, 1, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(14, 2, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(14, 1, _LESSONCONTENTINFO, $headerFormat);
    $eF_workSheetLessonGeneral->mergeCells(14,1,14,2);
    $eF_workSheetLessonGeneral->setColumn(14, 2, 30);     
    
    $eF_workSheetLessonGeneral->write(15, 1, _THEORY, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(15, 2, $info['theory'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(16, 1, _PROJECTS, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(16, 2, $info['projects'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(17, 1, _EXAMPLES, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(17, 2, $info['examples'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(18, 1, _TESTS, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(18, 2, $info['tests'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(19, 1, _FILES, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(19, 2, $info['files'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(20, 1, _DIRECTORIES, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(20, 2, $info['directories'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(21, 1, _FILESIZE, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(21, 2, $info['file_size']." KB", $fieldRightFormat);

    $eF_workSheetLessonGeneral->setColumn(3, 3, 5);

    //lesson users info
    $eF_workSheetLessonGeneral->write(1, 4, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 5, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 6, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 7, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 8, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 9, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 10, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 4, _USERSINFO, $headerFormat);
    $eF_workSheetLessonGeneral->mergeCells(1,4,1,10);
    $eF_workSheetLessonGeneral->setColumn(4, 10, 15);    
    
    $eF_workSheetLessonGeneral->write(2, 4, _LOGIN, $titleLeftFormat);
    $eF_workSheetLessonGeneral->write(2, 5, _TIME, $titleCenterFormat);
    $eF_workSheetLessonGeneral->write(2, 6, _CONTENT, $titleCenterFormat);
    $eF_workSheetLessonGeneral->write(2, 7, _TESTS, $titleCenterFormat);
    $eF_workSheetLessonGeneral->write(2, 8, _PROJECTS, $titleCenterFormat);
    $eF_workSheetLessonGeneral->write(2, 9, _COMPLETED, $titleCenterFormat);
    $eF_workSheetLessonGeneral->write(2, 10, _GRADE, $titleCenterFormat);
    
    $students = $lesson->getUsers('student');
             
    $row = 3;
    $logins = array();
    foreach ($students as $user){
        $logins[] = $user['login'];
    }
    $status = EfrontStats :: getStudentsLessonStatus($lesson->lesson['id'], $logins);
    $userTimes = EfrontStats :: getUsersTime($lesson->lesson['id'], $logins);
    $doneTests = EfrontStats :: getStudentsDoneTests($lesson -> lesson['id'], $logins);
    $assignedProjects = EfrontStats :: getStudentsAssignedProjects($lesson -> lesson['id'], $logins);
    foreach ($students as $user){
        $eF_workSheetLessonGeneral->write($row, 4, $user['login'], $fieldLeftFormat);
        $eF_workSheetLessonGeneral->write($row, 5, 
                    $userTimes[$user['login']]['hours']."h ".$userTimes[$user['login']]['minutes']."' ".$userTimes[$user['login']]['seconds']."'' ", $fieldCenterFormat);
        $eF_workSheetLessonGeneral->write($row, 6, $status[$user['login']]['percentage_done']."%", $fieldCenterFormat);
        $eF_workSheetLessonGeneral->write($row, 7, $status[$user['login']]['percentage_tests']."%", $fieldCenterFormat);
        $eF_workSheetLessonGeneral->write($row, 8, $status[$user['login']]['percentage_projects']."%", $fieldCenterFormat);
        if ($status[$user['login']]['lesson_passed']){
            $msg = _YES;
        }
        else{
            $msg = _NO;
        }
        $eF_workSheetLessonGeneral->write($row, 9, $msg, $fieldCenterFormat);
        $eF_workSheetLessonGeneral->write($row, 10, $status[$user['login']]['score'], $fieldCenterFormat);
        $row++;
    }
    $row+=2;

    //lesson professors info
    $eF_workSheetLessonGeneral->write($row, 4, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 5, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 6, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 7, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 8, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 9, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 10, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 4, _PROFESSORSINFO, $headerFormat);
    $eF_workSheetLessonGeneral->mergeCells($row,4,$row,10);
    $eF_workSheetLessonGeneral->setColumn($row, 10, 15);    
    $row++;
    $professors = $lesson->getUsers('professor');
    foreach ($professors as $professor){
        $eF_workSheetLessonGeneral -> write($row, 4, $professor['login'], $fieldLeftFormat);
        $row++;
    }
    
    
    //add a separate sheet for each distinct student of that lesson
    $i = 0;
    $eF_workSheetLessonStudent = array();
    foreach ($students as $user){
        $eF_workSheetLessonStudent[$i] = & $eF_WorkBook->addWorksheet($user['login']);
        $eF_workSheetLessonStudent[$i] -> setInputEncoding('utf-8');
        for ($j = 0; $j < 9; $j++){
            $eF_workSheetLessonStudent[$i] -> write(0, $j, '', $headerBigFormat);
            $eF_workSheetLessonStudent[$i] -> write(0, 0, $lesson -> lesson['name'], $headerBigFormat);
            $eF_workSheetLessonStudent[$i]->mergeCells(0, 0, 0, 9);
        }
        for ($j = 0; $j < 9; $j++){
            $eF_workSheetLessonStudent[$i] -> write(1, $j, '', $fieldCenterFormat);
            $eF_workSheetLessonStudent[$i] -> write(1, 0, $user['login']."-".$user['name']." ".$user['surname'], $fieldCenterFormat);
            $eF_workSheetLessonStudent[$i]->mergeCells(1, 0, 1, 9);
        }
        $eF_workSheetLessonStudent[$i]->setColumn(0, 0, 20);  
        $eF_workSheetLessonStudent[$i]->setColumn(1, 1, 10);
        $eF_workSheetLessonStudent[$i]->setColumn(2, 2, 5);
        
        $eF_workSheetLessonStudent[$i] -> write(3, 0, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(3, 1, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(3, 0, _TIMEINLESSON, $headerFormat);
        $eF_workSheetLessonStudent[$i]->mergeCells(3, 0, 3, 1);
        
        $eF_workSheetLessonStudent[$i] -> write(4, 0, '', $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(4, 1, '', $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(4, 0, 
                    $userTimes[$user['login']]['hours']."h ".$userTimes[$user['login']]['minutes']."' ".$userTimes[$user['login']]['seconds']."''", 
                    $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells(4, 0, 4, 1);
        
        $eF_workSheetLessonStudent[$i] -> write(5, 0, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(5, 1, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(5, 0, _STATUS, $headerFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells(5, 0, 5, 1);
        if ($status[$user['login']]['score']){
            $msg = _YES;
        }
        else{
            $msg = _NO;
        }
        $eF_workSheetLessonStudent[$i] -> write(6, 0, _COMPLETED, $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(6, 1, $msg, $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(7, 0, _GRADE, $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(7, 1, $status[$user['login']]['score'], $fieldCenterFormat);
        
        $eF_workSheetLessonStudent[$i] -> write(8, 0, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(8, 1, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(8, 0, _CONTENT, $headerFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells(8, 0, 8, 1);
        
        $eF_workSheetLessonStudent[$i] -> write(9, 0, '', $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(9, 1, '', $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> write(9, 0, $status[$user['login']]['percentage_done']."%", $fieldCenterFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells(9, 0, 9, 1);
        
        $eF_workSheetLessonStudent[$i] -> write(10, 0, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(10, 1, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write(10, 0, _TESTS, $headerFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells(10, 0, 10, 1);
        $row = 11;
        foreach ($doneTests[$user['login']] as $test){
            $eF_workSheetLessonStudent[$i] -> write($row, 0, $test['name'], $fieldCenterFormat);
            $eF_workSheetLessonStudent[$i] -> write($row, 1, ($test['score']*100)."%", $fieldCenterFormat);
            $row++;
        }
        
        $eF_workSheetLessonStudent[$i] -> write($row, 0, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write($row, 1, '', $headerFormat);
        $eF_workSheetLessonStudent[$i] -> write($row, 0, _PROJECTS, $headerFormat);
        $eF_workSheetLessonStudent[$i] -> mergeCells($row, 0, $row, 1);
        $row++;
        foreach ($assignedProjects[$user['login']] as $project){
            $eF_workSheetLessonStudent[$i] -> write($row, 0, $project['title'], $fieldCenterFormat);
            $eF_workSheetLessonStudent[$i] -> write($row, 1, $project['grade']."%", $fieldCenterFormat);
            $row++;
        }
    }
    
    $eF_WorkBook -> close();
    exit(0);
}
else if ($_GET['oper'] == 'export_course'){
    require_once 'Spreadsheet/Excel/Writer.php';
            
    if( isset($_GET['sel_course']) && $_GET['sel_course'] != ''){
        $course_id = $_GET['sel_course'];
    }
    $course = new EfrontCourse($course_id);
    $eF_WorkBook = new Spreadsheet_Excel_Writer();
    $eF_WorkBook -> setVersion(8);
    $eF_WorkBook ->send('export_'.$course -> course['name'].'.xls');
    $eF_formatExcelHeaders = & $eF_WorkBook -> addFormat();
    $eF_formatExcelHeaders ->setSize(14);
    $eF_formatExcelHeaders ->setBold();
    $eF_formatExcelHeaders ->setHAlign('left');

    $eF_formatContent = & $eF_WorkBook -> addFormat();
    $eF_formatContent ->setHAlign('left');
    $eF_formatContent ->setVAlign('top');
    $eF_formatContent ->setTextWrap();
    
    $hf = array('border' => 0,
                'bold'=>'1',
                'size' => '11',
                'color' => 'black',
                'fgcolor' => 22,
                'align' => 'center');
    $headerFormat =& $eF_WorkBook->addFormat($hf);  
   
    $headerBigFormat = & $eF_WorkBook -> addFormat();
    $headerBigFormat ->setHAlign('center');
    $headerBigFormat -> setFgColor(22);
    $headerBigFormat ->setSize(16); 
    $headerBigFormat ->setBold();
   
    $titleCenterFormat = & $eF_WorkBook -> addFormat();
    $titleCenterFormat ->setHAlign('center');
    $titleCenterFormat ->setSize(11); 
    $titleCenterFormat ->setBold();
   
    $titleLeftFormat = & $eF_WorkBook -> addFormat();
    $titleLeftFormat ->setHAlign('left');
    $titleLeftFormat ->setSize(11); 
    $titleLeftFormat ->setBold();
   
    $fieldLeftFormat = & $eF_WorkBook -> addFormat();
    $fieldLeftFormat ->setHAlign('left');
    $fieldLeftFormat ->setSize(10); 
    
    $fieldRightFormat = & $eF_WorkBook -> addFormat();
    $fieldRightFormat ->setHAlign('right');
    $fieldRightFormat ->setSize(10); 
    
    $fieldCenterFormat = & $eF_WorkBook -> addFormat();
    $fieldCenterFormat ->setHAlign('center');
    $fieldCenterFormat ->setSize(10); 
    
    
    
    //first tab
    $eF_workSheetLessonGeneral = & $eF_WorkBook->addWorksheet("General Course Info");
    $eF_workSheetLessonGeneral -> setInputEncoding('utf-8');

    $eF_workSheetLessonGeneral->setColumn(0, 0, 5);
    
    $basic_info = array();
    $basic_info['id'] = $course_id;
    $basic_info['name'] = $course -> course['name'];
    $direction_data = ef_getTableData("directions", "name", "id=".$course -> course['directions_ID']);
    if (sizeof($direction_data) > 0){
        $basic_info['direction'] = $direction_data[0]['name'];
    }
    else{
        $basic_info['direction'] = "---";
    }
    $basic_info['lessons'] = sizeof($course -> getLessons(false));
    $basic_info['professors'] = 0;
    $basic_info['students'] = 0;
    $courseUsers = $course -> getUsers(false);
    $student_logins = array();
    $professor_logins = array();
    foreach ($courseUsers as $login => $user){
        if ($user['user_type'] == 'student'){
            $basic_info['students']++;
            $student_logins[] = $login;
        }
        else if ($user['user_type'] == 'professor'){
            $basic_info['professors']++;
            $professor_logins[] = $login;
        }
    }
    $basic_info['language'] = $course -> course['languages_NAME'];
    $basic_info['price']    = $course -> course['price'].' '.$GLOBALS['configuration']['currency'];
    
    //basic info    
    $eF_workSheetLessonGeneral->write(1, 1, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 2, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 1, _BASICINFO, $headerFormat);
    $eF_workSheetLessonGeneral->mergeCells(1,1,1,2);
    $eF_workSheetLessonGeneral->setColumn(1, 2, 30);              
    
    $eF_workSheetLessonGeneral->write(2, 1, _COURSE, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(2, 2, $course -> course['name'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(3, 1, _DIRECTION, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(3, 2, $basic_info['direction'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(4, 1, _LESSONS, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->writeNumber(4, 2, $basic_info['lessons'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(5, 1, _STUDENTS, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->writeNumber(5, 2, $basic_info['students'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(6, 1, _PROFESSORS, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(6, 2, $basic_info['professors'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(7, 1, _PRICE, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(7, 2,  $basic_info['price'], $fieldRightFormat);
    $eF_workSheetLessonGeneral->write(8, 1, _LANGUAGE, $fieldLeftFormat);
    $eF_workSheetLessonGeneral->write(8, 2, $basic_info['language'], $fieldRightFormat);


    //course users info
    $eF_workSheetLessonGeneral->write(1, 4, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 5, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 6, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 7, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 8, '', $headerFormat);
    $eF_workSheetLessonGeneral->write(1, 4, _USERSINFO, $headerFormat);
    $eF_workSheetLessonGeneral->mergeCells(1, 4, 1 ,8);
    $eF_workSheetLessonGeneral->setColumn(4, 8, 15);    
    
    $eF_workSheetLessonGeneral->write(2, 4, _LOGIN, $titleLeftFormat);
    $eF_workSheetLessonGeneral->write(2, 5, _NAME, $titleLeftFormat);
    $eF_workSheetLessonGeneral->write(2, 6, _SURNAME, $titleLeftFormat);
    $eF_workSheetLessonGeneral->write(2, 7, _SCORE, $titleCenterFormat);
    $eF_workSheetLessonGeneral->write(2, 8, _COMPLETED, $titleCenterFormat);
    
    $status = EfrontStats :: getStudentsCourseStatus($course, $student_logins);
    $courseStudentNames     = array();
    $courseStudentSurnames  = array();
    $courseStudentScores    = array();
    $courseStudentCompleted = array();
    $courseStudentLogins    = array();
    foreach ($student_logins as $login){
        $user = EfrontUserFactory :: factory($login);
        $courseStudentNames[$login]       = $user -> user['name'];
        $courseStudentSurnames[$login]    = $user -> user['surname'];
        $courseStudentScores[$login]      = round($status[$login]['score'], 2);
        $courseStudentCompleted[$login]   = $status[$login]['completed_str'];
        $courseStudentLogins[$login]      = $login;
    }
    
    $row = 3;
    foreach ($courseStudentNames as $login => $name){
        $eF_workSheetLessonGeneral->write($row, 4, $login, $fieldLeftFormat);
        $eF_workSheetLessonGeneral->write($row, 5, $name, $fieldLeftFormat);
        $eF_workSheetLessonGeneral->write($row, 6, $courseStudentSurnames[$login], $fieldLeftFormat);
        $eF_workSheetLessonGeneral->write($row, 7, $courseStudentScores[$login]."%", $fieldCenterFormat);
        $eF_workSheetLessonGeneral->write($row, 8, $courseStudentCompleted[$login], $fieldCenterFormat);
        $row++;
    }
    $row += 2;

   
    //lessons
    $courseLessons = $course -> getLessons(true);
    $lessonNames = array();
    $lessonContent = array();
    $lessonTests = array();
    $lessonProjects = array();
    foreach ($courseLessons as $id => $lesson){
        $info = $lesson -> getStatisticInformation();
        $lessonNames[$id]      = $lesson -> lesson['name'];
        $lessonContent[$id]    = $info['content'];
        $lessonTests[$id]      = $info['tests'];
        $lessonProjects[$id]   = $info['projects'];
    }
    $eF_workSheetLessonGeneral->write($row, 4, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 5, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 6, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 7, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 8, '', $headerFormat);
    $eF_workSheetLessonGeneral->write($row, 4, _LESSONS, $headerFormat);
    $eF_workSheetLessonGeneral->mergeCells($row, 4, $row ,8);
    $eF_workSheetLessonGeneral->setColumn($row, 8, 15);    
    $row++;
    $eF_workSheetLessonGeneral->write($row, 4, _LESSON, $titleLeftFormat);
    $eF_workSheetLessonGeneral->write($row, 5, _CONTENT, $titleCenterFormat);
    $eF_workSheetLessonGeneral->write($row, 6, _TESTS, $titleCenterFormat);
    $eF_workSheetLessonGeneral->write($row, 7, _PROJECTS, $titleCenterFormat);
    $row++;
    foreach ($lessonNames as $id => $name){
        $eF_workSheetLessonGeneral->write($row, 4, $name, $fieldLeftFormat);
        $eF_workSheetLessonGeneral->write($row, 5, $lessonContent[$id], $fieldCenterFormat);
        $eF_workSheetLessonGeneral->write($row, 6, $lessonTests[$id], $fieldCenterFormat);
        $eF_workSheetLessonGeneral->write($row, 7, $lessonProjects[$id], $fieldCenterFormat);
        $row++;
    }
    
    $eF_WorkBook -> close();
    exit(0);
}
if(isset($_GET['oper']) AND $_GET['oper'] == 'user_pdf_export'){

            if(isset($_GET['user']) && $_GET['user'] != ''){
                $user = $_GET['user'];
            }else{
                $user = $_SESSION['s_login'];
            }

            $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor(PDF_AUTHOR);
            $pdf->SetTitle($doc_title);
            $pdf->SetSubject($doc_subject);
            $pdf->SetKeywords($doc_keywords);

            //set margins
            $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
            //set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); //set image scale factor

            $pdf->setHeaderFont(Array('FreeSerif', 'I', 11));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setHeaderData('','','', _STATISTICSFORUSER.":".$user);
            $pdf->setLanguageArray($l); //set language items
            //initialize document
            $pdf->AliasNbPages();
            $pdf->AddPage();
            $pdf->SetFont("FreeSerif","B",12);


            $pdf->SetTextColor(0,0,0);

            $user_info = eF_getUserInfo($user);
            $user_type = eF_getTableData("users", "user_type", "login='".$user."'");
            $data_info = $user_info['lessons_info'];
            $pdf->Cell(100, 10, _GENERALUSERINFO, 0, 1, L, 0);


            $pdf->SetFont("FreeSerif","",10);
            $pdf->SetTextColor(0,0,0);
            $pdf->Cell(70, 5, _NAME, 0, 0, L, 0);
            $pdf->SetTextColor(0,0,255);
            $pdf->Cell(170, 5, $user_info['common_info'][_NAME]." ".$user_info['common_info'][_SURNAME], 0, 1, L, 0);
            foreach ($user_info['general_info'] as $key=>$value){
                if ($key == _JOINED){
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->SetTextColor(0,0,0);
                    $pdf->Cell(70, 5, $key, 0, 0, L, 0);
                    $tmp_value = str_replace("#filter:timestamp-"," ",$value);
                    $tmp_endValue = str_replace("#", " ", $tmp_value);
                    $pdf->SetTextColor(0,0,255);
                    $pdf->Cell(70, 5, strftime('%d-%m-%Y, %H:%M:%S', $tmp_endValue), 0, 1, L, 0);
                } else {
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->SetTextColor(0,0,0);
                    $pdf->Cell(70, 5, $key, 0, 0, L, 0);
                    $pdf->SetTextColor(0,0,255);
                    $pdf->Cell(70, 5, $value, 0, 1, L, 0);
                }
            }
            $pdf->SetFont("FreeSerif","B",12);
            $pdf->SetTextColor(0,0,0);
            $pdf->Cell(100, 10, _USERCOMMUNICATIONINFO, 0, 1, L, 0);
            foreach ($user_info['communication'] as $key => $value){
                if ($key == _CHATLASTMESSAGE){
                    continue;
                } else {
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->SetTextColor(0,0,0);
                    $pdf->Cell(70, 5, $key, 0, 0, L, 0);
                    $pdf->SetTextColor(0,0,255);
                    $pdf->Cell(70, 5, $value, 0, 1, L, 0);
                }
            }
            $pdf->SetFont("FreeSerif","B",12);
            $pdf->SetTextColor(0,0,0);
            $pdf->Cell(100, 10, _USERUSAGEINFO, 0, 1, L, 0);
            foreach ($user_info['usage'] as $key=>$value){
                if ($key == _LASTLOGIN){
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->SetTextColor(0,0,0);
                    $pdf->Cell(90, 5, $key, 0, 0, L, 0);
                    $tmp_value = str_replace("#filter:timestamp_time-"," ",$value);
                    $tmp_endValue = str_replace("#", " ", $tmp_value);
                    $pdf->SetTextColor(0,0,255);
                    $pdf->Cell(40, 5, strftime('%d-%m-%Y, %H:%M:%S', $tmp_endValue), 0, 1, L, 0);
                } else {
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->SetTextColor(0,0,0);
                    $pdf->Cell(90, 5, $key, 0, 0, L, 0);
                    $pdf->SetTextColor(0,0,255);
                    $pdf->Cell(40, 5, $value, 0, 1, L, 0);
                }
            }

            /* The second worksheet for the user whith information for his score in each lesson he participates. */
            $pdf->SetTextColor(0,0,0);
            $pdf->AddPage('L');
            /*The following lines of code calculate the average score in tests and percentage of content viewed*/
            $array_scores_mean = array();
            $array_grades_mean = array();
            for ($i=0; $i < sizeof($user_info['lessons_info']['done_projects']); $i ++){
                $tmp_g = 0;
                for($j = 0 ; $j < sizeof($user_info['lessons_info']['done_projects'][$i]['grade']) ; $j ++){
                    $user_info['lessons_info']['done_projects'][$i]['grade'][$j] = sprintf("%01.2f",$user_info['lessons_info']['done_projects'][$i]['grade'][$j]);
                    $tmp_g += floatval($user_info['lessons_info']['done_projects'][$i]['grade'][$j]);
                }
                $tmp_g_i = $tmp_g / sizeof($user_info['lessons_info']['done_projects'][$i]['grade']);
                $array_grades_mean[$i] = array('avg_score' => sprintf("%01.2f",round($tmp_g_i,2)));
            }

            for($i = 0 ; $i < sizeof($user_info['lessons_info']['done_tests']) ; $i ++){
                $tmp = 0.00;
                for($j = 0 ; $j < sizeof($user_info['lessons_info']['done_tests'][$i]['score']) ; $j ++){
                    $tmp += floatval($user_info['lessons_info']['done_tests'][$i]['score'][$j]);
                }
                $tmp_i = $tmp / sizeof($user_info['lessons_info']['done_tests'][$i]['score']);
                $array_scores_mean[$i] = array('avg_score' => sprintf("%01.2f",100*round($tmp_i,2)));
            }
            for($i = 0 ; $i < sizeof($user_info['lessons_info']['done_tests']) ; $i ++){
                for($j = 0 ; $j < sizeof($user_info['lessons_info']['done_tests'][$i]['score']) ; $j ++){
                    $user_info['lessons_info']['done_tests'][$i]['score'][$j] = sprintf("%01.2f",$user_info['lessons_info']['done_tests'][$i]['score'][$j]);
                }
            }
            $scores = array();
            $i = 0;
            foreach($user_info['lessons_info']['content_done'] as $key => $lesson_data){
                $tmp = eF_getStudentProgress($user, $user_info['lessons_info']['id'][$i]);
                $scores[$i]['percentage'] = $tmp[$user_info['lessons_info']['id'][$i]];
                $i ++;
            }
            $pdf->SetFont("FreeSerif","B",12);
            $pdf->Cell(60, 12, _LESSONS, 0, 1, L, 0);
            $pdf->SetFont("FreeSerif","B",10);
            $pdf->Cell(100, 7, _LESSON, 0, 0, L, 0);
            $pdf->Cell(50, 7, _TIMEINLESSON, 0, 0, L, 0);
            $pdf->Cell(40, 7, _CONTENT, 0, 0, C, 0);
            $pdf->Cell(40, 7, _TESTS, 0, 0, C, 0);
            $pdf->Cell(40, 7, _PROJECTS, 0, 1, C, 0);
            for($i =  0 ; $i < sizeof($data_info['id']); $i++){
                $pdf->SetFont("FreeSerif","",10);
                $pdf->SetTextColor(0,0,0);
                $pdf->Cell(100, 5, $user_info['lessons_info']['name'][$i], 0, 0, L, 0);
                $pdf->Cell(50, 5, $user_info['lessons_info']['time'][$i]['hours']."h ".$user_info['lessons_info']['time'][$i]['minutes']."' ".$user_info['lessons_info']['time'][$i]['seconds']."''", 0, 0, L, 0);
                $pdf->Cell(40, 5, $scores[$i]['percentage']."%", 0, 0, C, 0);
                $pdf->Cell(40, 5, $array_scores_mean[$i]['avg_score']."%", 0, 0, C, 0);
                $pdf->Cell(40, 5, $array_grades_mean[$i]['avg_score']."%", 0, 1, C, 0);
            }

            //tests page
            $pdf->SetTextColor(0,0,0);
            $pdf->AddPage('L');
            $pdf->SetFont("FreeSerif","B",12);
            $pdf->Cell(60, 12, _TESTS, 0, 1, L, 0);
            $pdf->SetFont("FreeSerif","B",10);
            $pdf->Cell(100, 7, _LESSON, 0, 0, L, 0);
            $pdf->Cell(100, 7, _TESTNAME, 0, 0, L, 0);
            $pdf->Cell(40, 7, _SCORE, 0, 1, C, 0);

            for($i = 0 ; $i < sizeof($data_info['id']) ; $i ++){
                if(sizeof($data_info['done_tests'][$i]['name']) > 0){
                    for($j = 0 ; $j < sizeof($data_info['done_tests'][$i]['name']) ; $j ++){
                        $pdf->SetFont("FreeSerif","",10);
                        $pdf->SetTextColor(0,0,0);
                        $pdf->Cell(100, 5, $data_info['name'][$i], 0, 0, L, 0);
                        $pdf->Cell(100, 5, $data_info['done_tests'][$i]['name'][$j], 0, 0, L, 0);
                        $pdf->Cell(40, 5, round(100*$data_info['done_tests'][$i]['score'][$j],2)."%", 0, 1, C, 0);
                    }
                }else{
                    continue;
                }
            }

            //projects page
            $pdf->SetTextColor(0,0,0);
            $pdf->AddPage('L');
            $pdf->SetFont("FreeSerif","B",12);
            $pdf->Cell(60, 12, _PROJECTS, 0, 1, L, 0);
            $pdf->SetFont("FreeSerif","B",10);
            $pdf->Cell(100, 7, _LESSON, 0, 0, L, 0);
            $pdf->Cell(100, 7, _TITLE, 0, 0, L, 0);
            $pdf->Cell(40, 7, _GRADE, 0, 1, C, 0);

            for($i = 0 ; $i < sizeof($data_info['id']) ; $i ++){
                if(sizeof($data_info['done_projects'][$i]['title']) > 0){
                    for($j = 0 ; $j < sizeof($data_info['done_projects'][$i]['title']) ; $j ++){
                        $pdf->SetFont("FreeSerif","",10);
                        $pdf->SetTextColor(0,0,0);
                        $pdf->Cell(100, 5, $data_info['name'][$i], 0, 0, L, 0);
                        $pdf->Cell(100, 5, $data_info['done_projects'][$i]['title'][$j], 0, 0, L, 0);
                        $pdf->Cell(40, 5, round($data_info['done_projects'][$i]['grade'][$j],2)."%", 0, 1, C, 0);
                    }
                }else{
                    continue;
                }
            }

            $pdf->Output();
            exit(0);
        }
        if( isset($_GET['oper']) && $_GET['oper'] == 'lesson_pdf_export'){
            if( isset($_GET['sel_lesson']) && $_GET['sel_lesson'] != ''){
                $lesson_id = $_GET['sel_lesson'];
            }else{
                $lesson_id = $_SESSION['s_lessons_ID'];
            }

            if (isset($_GET['group_filter']) && $_GET['group_filter'] > 0){
                $lesson_info = eF_getLessonInfo($lesson_id, $_GET['group_filter']);
            }
            else{
                $lesson_info = eF_getLessonInfo($lesson_id);
            }

            $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true);
            $pdf->SetCreator(PDF_CREATOR);
            $pdf->SetAuthor(PDF_AUTHOR);
            $pdf->SetTitle($doc_title);
            $pdf->SetSubject($doc_subject);
            $pdf->SetKeywords($doc_keywords);

            //set margins
            $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
            //set auto page breaks
            $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
            $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
            $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); //set image scale factor

            $pdf->setHeaderFont(Array('FreeSerif', 'I', 11));
            $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
            $pdf->setHeaderData('','','', _STATISTICSFORLESSON.": ".$lesson_info['common_info'][_NAME]);
            $pdf->setLanguageArray($l); //set language items
            //initialize document
            $pdf->AliasNbPages();
            $pdf->AddPage();
            $pdf->SetFont("FreeSerif","B",12);


            $pdf->SetTextColor(0,0,0);
            $array_generalinfo  = $lesson_info['general_info'];
            $array_commoninfo  = $lesson_info['common_info'];
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont("FreeSerif","B",11);
            $pdf->Cell(70, 10, _GENERALLESSONINFO, 0, 1, L, 0);
            foreach($array_generalinfo as $key => $value){
                $pdf->SetFont("FreeSerif","",10);
                $pdf->SetTextColor(0,0,0);
                $pdf->Cell(40, 5, $key, 0, 0, L, 0);
                $pdf->SetTextColor(0,0,255);
                $pdf->Cell(40, 5, $value, 0, 1, L, 0);
            }
            foreach($array_commoninfo as $key => $value){
                $pdf->SetFont("FreeSerif","",10);
                $pdf->SetTextColor(0,0,0);
                $pdf->Cell(40, 5, $key, 0, 0, L, 0);
                $pdf->SetTextColor(0,0,255);
                $pdf->Cell(40, 5, $value, 0, 1, L, 0);
            }

            $array_participation = $lesson_info['participation'];
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont("FreeSerif","B",11);
            $pdf->Cell(70, 10, _LESSONPARTICIPATIONINFO, 0, 1, L, 0);

            foreach($array_participation as $key=>$value){
                $pdf->SetFont("FreeSerif","",10);
                $pdf->SetTextColor(0,0,0);
                $pdf->Cell(40, 5, $key, 0, 0, L, 0);
                $pdf->SetTextColor(0,0,255);
                $pdf->Cell(40, 5, $value, 0, 1, L, 0);
            }

            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont("FreeSerif","B",11);
            $pdf->Cell(60, 10, _LESSONCONTENTINFO, 0, 1, L, 0);
            $array_contentinfo = $lesson_info['content'];
            foreach($array_contentinfo as $key=>$value){
                $pdf->SetFont("FreeSerif","",10);
                $pdf->SetTextColor(0,0,0);
                $pdf->Cell(40, 5, $key, 0, 0, L, 0);
                $pdf->SetTextColor(0,0,255);
                $pdf->Cell(40, 5, $value, 0, 1, L, 0);
            }
            $array_volumeinfo = $lesson_info['volume'];
            foreach($array_volumeinfo as $key=>$value){
                $pdf->SetFont("FreeSerif","",10);
                $pdf->SetTextColor(0,0,0);
                $pdf->Cell(40, 5, $key, 0, 0, L, 0);
                $pdf->SetTextColor(0,0,255);
                $pdf->Cell(40, 5, $value, 0, 1, L, 0);
            }

            /* This  line of code creates the second page which contains data for users(students + professors).*/
            $pdf->AddPage("L");
            $pdf->SetTextColor(0,0,0);
            if (isset($_GET['group_filter']) && $_GET['group_filter'] > 0){
                $p_activity = eF_getUsersActivityInfo('professor', $lesson_id, $_GET['group_filter']);
                $u_activity = eF_getUsersActivityInfo('student', $lesson_id, $_GET['group_filter']);
            }
            else{
                $p_activity = eF_getUsersActivityInfo('professor', $lesson_id);
                $u_activity = eF_getUsersActivityInfo('student', $lesson_id);
            }
            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont("FreeSerif","B",11);
            $pdf->Cell(60, 10, _STUDENTS, 0, 1, L, 0);

            foreach($u_activity as $key => $value){
                switch($key){
                case 'logins':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(30, 7, _LOGIN, 0, 0, L, 0);
                    break;
                case 'name':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(40, 7, _FIRSTNAME, 0, 0, L, 0);
                    break;
                case 'surname':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(40, 7, _LASTNAME, 0, 0, L, 0);
                    break;
                case 'time':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(35, 7, _TIMEINLESSON, 0, 0, C, 0);
                    break;
                case 'content_done':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(25, 7, _CONTENT, 0, 0, C, 0);
                    break;
                case 'avg_score':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(25, 7, _TESTS, 0, 0, C, 0);
                    break;
                case 'project_score':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(25, 7, _PROJECTS, 0, 0, C, 0);
                    break;
                case 'num_comments':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(25, 7, _COMMENTS, 0, 0, C, 0);
                    break;
                case 'num_posts':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(30, 7, _FORUMPOSTS, 0, 1, C, 0);
                    break;
                default:break;
                }
            }

            for($i = 0 ; $i < sizeof($u_activity['logins']) ; $i ++){
                $pdf->SetTextColor(0,0,255);
                $pdf->Cell(30, 5, $u_activity['logins'][$i], 0, 0, L, 0);
                $pdf->Cell(40, 5, $u_activity['name'][$i], 0, 0, L, 0);
                $pdf->Cell(40, 5, $u_activity['surname'][$i], 0, 0, L, 0);
                $pdf->Cell(35, 5, $u_activity['time'][$i]['hours']."h ".$u_activity['time'][$i]['minutes']."' ".$u_activity['time'][$i]['seconds']."'' ", 0, 0, C, 0);
                $pdf->Cell(25, 5, $u_activity['content_done'][$i][0]['theory_perc'], 0, 0, C, 0);
                $pdf->Cell(25, 5, $u_activity['avg_score'][$i][0], 0, 0, C, 0);
                $pdf->Cell(25, 5, $u_activity['project_score'][$i][0], 0, 0, C, 0);
                $pdf->Cell(25, 5, $u_activity['num_comments'][$i][0], 0, 0, C, 0);
                $pdf->Cell(30, 5, $u_activity['num_posts'][$i][0], 0, 1, C, 0);
            }

            $pdf->SetTextColor(0,0,0);
            $pdf->SetFont("FreeSerif","B",11);
            $pdf->Cell(60, 10, _PROFESSORS, 0, 1, L, 0);

            foreach($p_activity as $key => $value){
                switch($key){
                case 'logins':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(30, 7, _LOGIN, 0, 0, L, 0);
                    break;
                case 'name':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(40, 7, _FIRSTNAME, 0, 0, L, 0);
                    break;
                case 'surname':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(40, 7, _LASTNAME, 0, 0, L, 0);
                    break;
                case 'time':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(35, 7, _TIMEINLESSON, 0, 0, C, 0);
                    break;
                case 'num_comments':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(25, 7, _COMMENTS, 0, 0, C, 0);
                    break;
                case 'num_posts':
                    $pdf->SetTextColor(0,0,0);
                    $pdf->SetFont("FreeSerif","",10);
                    $pdf->Cell(30, 7, _FORUMPOSTS, 0, 1, C, 0);
                    break;
                default:break;
                }
            }

            for($i = 0 ; $i < sizeof($p_activity['logins']) ; $i ++){
                $pdf->SetTextColor(0,0,255);
                $pdf->Cell(30, 5, $p_activity['logins'][$i], 0, 0, L, 0);
                $pdf->Cell(40, 5, $p_activity['name'][$i], 0, 0, L, 0);
                $pdf->Cell(40, 5, $p_activity['surname'][$i], 0, 0, L, 0);
                $pdf->Cell(35, 5, $p_activity['time'][$i]['hours']."h ".$p_activity['time'][$i]['minutes']."' ".$p_activity['time'][$i]['seconds']."'' ", 0, 0, C, 0);
                $pdf->Cell(25, 5, $p_activity['num_comments'][$i][0], 0, 0, C, 0);
                $pdf->Cell(30, 5, $p_activity['num_posts'][$i][0], 0, 1, C, 0);
            }


            /* Creating the page for the tests */
            $pdf->AddPage();
            $pdf->SetTextColor(0,0,0);
            if (isset($_GET['group_filter']) && $_GET['group_filter'] > 0){
                $lesson_info = eF_getLessonInfo($lesson_id, $_GET['group_filter']);
            }
            else{
                $lesson_info = eF_getLessonInfo($lesson_id);
            }
            $tests = $lesson_info['tests']['done_test'];

            if (sizeof($tests) > 0){
                for($i = 0 ; $i < sizeof($tests); $i ++){
                    $pdf->SetTextColor(0, 0, 0);
                    $pdf->SetFont("FreeSerif","B",11);
                    $pdf->Cell(60, 10, $lesson_info['tests']['name'][$i], 0, 1, L, 0);
                    $pdf->SetFont("FreeSerif","",10);
                    if (sizeof($tests[$i]['users_LOGIN']) > 0){
                        $pdf->Cell(30, 5, _LOGIN, 0, 0, L, 0);
                        $pdf->Cell(40, 5, _NAME, 0, 0, L, 0);
                        $pdf->Cell(40, 5, _SURNAME, 0, 0, L, 0);
                        $pdf->Cell(25, 5, _SCORE, 0, 0, C, 0);
                        $pdf->Cell(30, 5, _DATE, 0, 1, L, 0);
                        $pdf->SetFont("FreeSerif","",10);
                        $pdf->SetTextColor(0, 0, 255);
                        for($k = 0 ; $k < sizeof($tests[$i]['users_LOGIN']) ; $k ++){
                            $pdf->Cell(30, 5, $tests[$i]['users_LOGIN'][$k], 0, 0, L, 0);
                            $pdf->Cell(40, 5, $tests[$i]['name'][$k], 0, 0, L, 0);
                            $pdf->Cell(40, 5, $tests[$i]['surname'][$k], 0, 0, L, 0);
                            if ($tests[$i]['score'][$k] == 0)
                                $pdf->Cell(25, 5, "0", 0, 0, C, 0);
                            else
                                $pdf->Cell(25, 5, round((100*floatval($tests[$i]['score'][$k])),2), 0, 0, C, 0);
                            $pdf->Cell(30, 5, date('d/M/Y',$tests[$i]['timestamp'][$k]), 0, 1, L, 0);
                        }
                    }
                    else{
                        $pdf->SetTextColor(0, 0, 0);
                        $pdf->SetFont("FreeSerif","I",11);
                        $pdf->Cell(60, 5, _NOONEHASDONETHISTESTYET, 0, 1, L, 0);
                    }
                }
            }else{
                $pdf->SetTextColor(0, 0, 0);
                $pdf->SetFont("FreeSerif","I",11);
                $pdf->Cell(60, 5, _NOTESTSSETFORTHISUNIT, 0, 1, L, 0);
            }
            $pdf->Output();
        }
        if( isset($_GET['oper']) && $_GET['oper'] == 'test_export'){

            $t_c_id = ef_getTableData("tests", "content_id", "tests.id=".$_GET['sel_test']."");
            $users_done_tests_info = eF_testExport($t_c_id[0]['content_id']);
            $test_info = ef_getTestInfo($_GET['sel_test']);
            require_once 'Spreadsheet/Excel/Writer.php';

            $eF_WorkBook = new Spreadsheet_Excel_Writer();
            $eF_WorkBook ->setVersion(8);
            $eF_WorkBook ->send('test_'.$_GET['sel_test'].'_export.xls');
            $eF_formatExcelHeaders = & $eF_WorkBook -> addFormat();
            $eF_formatExcelHeaders ->setSize(12);
            $eF_formatExcelHeaders ->setBold();
            $eF_formatExcelHeaders ->setAlign('merge');
            $eF_formatExcelHeaders ->setHAlign('left');

            $eF_formatFields = & $eF_WorkBook -> addFormat();
            $eF_formatFields -> setBold();
            $eF_formatFields ->setItalic();
            $eF_formatFields ->setAlign('merge');
            $eF_formatFields ->setHAlign('left');

            $eF_formatColumnHeader = & $eF_WorkBook -> addFormat();
            $eF_formatFields ->setBold();
            $eF_formatFields ->setAlign('merge');
            $eF_formatFields ->setHAlign('left');

            $eF_formatContent = & $eF_WorkBook -> addFormat();
            $eF_formatContent ->setAlign('merge');
            $eF_formatContent ->setHAlign('left');
            $eF_formatContent ->setVAlign('top');

            $keys = array_keys($users_done_tests_info[0]);

            $eF_workSheetOverall = & $eF_WorkBook ->addWorkSheet("1");
            $eF_workSheetOverall -> setInputEncoding('utf-8');

            $eF_workSheetOverall -> write(0,0,$test_info['common_info']['name'],$eF_formatExcelHeaders);
            $write_row = 4;
            $write_column = 0;

            $eF_workSheetOverall -> write($write_row,0,_INFO,$eF_formatExcelHeaders);
            $write_row++;
            $eF_workSheetOverall -> write($write_row,0,_LESSON,$eF_formatField);
            $eF_workSheetOverall -> write($write_row,1,$test_info['common_info']['lesson_name'],$eF_formatField);
            $write_row++;
            $eF_workSheetOverall -> write($write_row,0,_DURATION,$eF_formatField);
            $eF_workSheetOverall -> write($write_row,1,$test_info['common_info']['duration']." ''",$eF_formatField);

            $write_row+=2;
            $eF_workSheetOverall -> write($write_row, 0, _QUESTIONTEXT, $eF_formatExcelHeaders);
            $eF_workSheetOverall -> write($write_row, 1, _CORRECTANSWERS, $eF_formatExcelHeaders);
            $eF_workSheetOverall -> write($write_row, 2, _FALSEANSWERS, $eF_formatExcelHeaders);

            for ($i=0; $i < sizeof($test_info['questions']); $i++)
            {
                $write_column = 0;
                $eF_workSheetOverall -> write($write_row, $write_column, trim(strip_tags($test_info['questions'][$i]['text'])),$eF_formatContent);
                $write_column++;
                if ( $test_info['questions'][$i]['correct'] > 0)
                    $eF_workSheetOverall -> write($write_row, $write_column, $test_info['questions'][$i]['correct'],$eF_formatContent);
                else
                    $eF_workSheetOverall -> write($write_row, $write_column, "0",$eF_formatContent);
                $write_column++;
                if ($test_info['questions'][$i]['false'] > 0)
                    $eF_workSheetOverall -> write($write_row, $write_column, $test_info['questions'][$i]['false'],$eF_formatContent);
                else
                    $eF_workSheetOverall -> write($write_row, $write_column, "0",$eF_formatContent);
                $write_row++;
            }
            $eF_workSheetOverall -> close();
            $eF_workSheetAnswers = & $eF_WorkBook ->addWorkSheet("2");
            $eF_workSheetAnswers -> setInputEncoding('utf-8');

            $eF_workSheetAnswers -> write(0,0,$test_info['common_info']['name'],$eF_formatExcelHeaders);
            $write_row = 4;
            $write_column = 0;
            for($i = 0 ; $i < sizeof($users_done_tests_info); $i++){
                $write_column = 0;
                $avg = 0;
                for($j = 0 ; $j < sizeof($users_done_tests_info[$i]['info']) ; $j ++){
                    if($j == 0){
                        $eF_workSheetAnswers -> write($write_row,$write_column,trim(strip_tags($users_done_tests_info[$i]['login'])),$eF_formatContent);
                        $write_column +=1;
                    }
                    if($i == 0){
                        $write_row -=2;
                        $eF_workSheetAnswers -> write($write_row,$write_column,trim(strip_tags($users_done_tests_info[$i]['info'][$j]['text'])),$eF_formatFields);
                        $write_row +=1;
                        $eF_workSheetAnswers -> write($write_row,$write_column,intVal(strip_tags($users_done_tests_info[$i]['info'][$j]['weight']))*10,$eF_formatFields);
                        $write_row +=1;
                    }
                    if($users_done_tests_info[$i]['info'][$j]['type'] == 'raw_text'){
                        $answer .= (string)trim(strip_tags($users_done_tests_info[$i]['info'][$j]['answer']));
                        $eF_workSheetAnswers -> write($write_row,$write_column,$answer,$eF_formatContent);
                    }else{
                        $answers = unserialize($users_done_tests_info[$i]['info'][$j]['answer']);
                        $answer ='';
                        for($k = 0 ; $k < sizeof($answers) ; $k ++){
                            $answer .= (string)strip_tags((string)$answers[$k]);
                        }
                        $eF_workSheetAnswers -> write($write_row,$write_column,(string)(intVal($answer)+1),$eF_formatContent);
                    }
                    $write_column +=1;
                    $avg += ((intVal($answer)+1)*(10*intVal(strip_tags($users_done_tests_info[$i]['info'][$j]['weight']))));
                }
                $write_column +=1;
                $numoptions = unserialize($users_done_tests_info[$i]['info'][$i]['options']);
                $max = sizeof($numoptions);
                $final_avg = $avg/$max;
                $eF_workSheetAnswers -> write($write_row,$write_column,$final_avg,$eF_formatExcelHeaders);
                $write_row +=1;
        }
        $eF_workSheetAnswers -> close();
        $eF_WorkBook ->close();
        exit(0);
    }
    if( isset($_GET['oper']) && $_GET['oper'] == 'test_pdf_export'){
        $t_c_id = ef_getTableData("tests", "content_id", "tests.id=".$_GET['sel_test']."");
        $users_done = eF_getTableData("done_tests dt", "users_LOGIN","tests_ID=".$_GET['sel_test']."");
        $test_info = ef_getTestInfo($_GET['sel_test']);
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true);
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor(PDF_AUTHOR);
        $pdf->SetTitle($doc_title);
        $pdf->SetSubject($doc_subject);
        $pdf->SetKeywords($doc_keywords);

        //set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);

        //set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        $pdf->setHeaderFont(Array('FreeSerif', 'I', 11));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->setHeaderData('','','', _TEST.": ".$test_info['common_info']['name']);
        $pdf->setLanguageArray($l); //set language items
        //initialize document
        $pdf->AliasNbPages();
        $pdf->AddPage('L');
        $pdf->SetFont("FreeSerif","B",12);
        $pdf->SetTextColor(0,0,0);
        $pdf -> Cell(100, 10, _INFO, 0, 1, L, 0);
        $pdf->SetFont("FreeSerif","",10);
        $pdf->Cell(80, 5, _LESSON, 0, 0, L, 0);
        $pdf->SetTextColor(0,0,255);
        $pdf->Cell(100, 5, $test_info['common_info']['lesson_name'], 0, 1, L, 0);
        $pdf->SetTextColor(0,0,0);
        $pdf->Cell(80, 5, _DURATION, 0, 0, L, 0);
        $pdf->SetTextColor(0,0,255);
        $pdf->Cell(100, 5, $test_info['common_info']['duration'], 0, 1, L, 0);
        $pdf->SetTextColor(0,0,0);

        $pdf->SetFont("FreeSerif","B",12);
        $pdf -> Cell(100, 10, _QUESTIONS, 0, 1, L, 0);
        $keys = array_keys($users_done_tests_info[0]);
        $pdf->SetFont("FreeSerif","B",11);

        $pdf -> Cell(170, 5, _QUESTIONTEXT, 0, 0, L, 0);
        $pdf -> Cell(50, 5, _CORRECTANSWERS, 0, 0, C, 0);
        $pdf -> Cell(50, 5, _FALSEANSWERS, 0, 1, C, 0);
        $pdf->SetFont("FreeSerif","",10);
        for ($i=0; $i < sizeof($test_info['questions']); $i++)
        {
            $pdf -> Cell(170, 5, trim(strip_tags($test_info['questions'][$i]['text'])), 0, 0, L, 0);
            if ($test_info['questions'][$i]['correct'] > 0)
                $pdf -> Cell(50, 5, $test_info['questions'][$i]['correct'], 0, 0, C, 0);
            else
                $pdf -> Cell(50, 5, "0", 0, 0, C, 0);
            if ($test_info['questions'][$i]['false'] > 0)
                $pdf -> Cell(50, 5, $test_info['questions'][$i]['false'], 0, 1, C, 0);
            else
                $pdf -> Cell(50, 5, "0", 0, 1, C, 0);
        }
        $pdf -> Output();
        exit(0);
    }
    if( isset($_GET['oper']) && $_GET['oper'] == 'lesson_tests_export'){
        $lesson_id = $_GET['sel_lesson'];
        $lesson_name = ef_getTableData("lessons","name","id=$lesson_id");
        require_once 'Spreadsheet/Excel/Writer.php';
        $eF_WorkBook = new Spreadsheet_Excel_Writer();
        $eF_WorkBook -> setVersion(8);
        $eF_WorkBook ->send('tests_lesson'.$lesson_id.'_export.xls');

        $eF_formatExcelHeaders = & $eF_WorkBook -> addFormat();
        $eF_formatExcelHeaders ->setSize(12);
        $eF_formatExcelHeaders ->setBold();
        $eF_formatExcelHeaders ->setAlign('merge');
        $eF_formatExcelHeaders ->setHAlign('left');

        $eF_formatFields = & $eF_WorkBook -> addFormat();
        $eF_formatFields ->setItalic();
        $eF_formatFields ->setAlign('merge');
        $eF_formatFields ->setHAlign('left');

        $eF_formatHeader = & $eF_WorkBook -> addFormat();
        $eF_formatHeader ->setBold();
        $eF_formatHeader ->setFgColor('blue');
        $eF_formatHeader ->setColor('white');
        $eF_formatHeader ->setAlign('merge');
        $eF_formatHeader ->setHAlign('left');

        $eF_formatHeader ->setTextRotation(90);

        $eF_formatRowHeader = & $eF_WorkBook -> addFormat();
        $eF_formatRowHeader ->setBold();
        $eF_formatRowHeader ->setFgColor('green');
        $eF_formatRowHeader ->setColor('white');
        $eF_formatRowHeader ->setAlign('merge');
        $eF_formatRowHeader ->setHAlign('left');

        $eF_formatContent = & $eF_WorkBook -> addFormat();
        $eF_formatContent ->setAlign('merge');
        $eF_formatContent ->setHAlign('right');
        $eF_formatContent ->setVAlign('top');

        $eF_workSheetOverall = & $eF_WorkBook ->addWorkSheet("1");
        $eF_workSheetOverall -> setInputEncoding('utf-8');
        $eF_workSheetOverall -> write(0, 0, $lesson_name[0]['name'],$eF_formatExcelHeaders);
        $write_row = 2;

        $tests = ef_getTableData("tests t, content c", "t.id, c.name", "t.content_ID = c.id and c.lessons_ID=$lesson_id");
        $write_column = 1;

        $sum = array();
        $cnt = array();

        for ($i=0; $i<sizeof($tests); $i++){
            $eF_workSheetOverall -> write($write_row, $write_column, $tests[$i]['name'], $eF_formatHeader);
            $write_column++;
            $sum[$i] = 0;
            $cnt[$i] = 0;
        }
        if (isset($_GET['group_filter']) && $_GET['group_filter'] > 0){
            $lesson_users = ef_getTableData("users_to_lessons ul, users u, users_to_groups g", "ul.users_LOGIN, u.name, u.surname", "g.users_LOGIN = u.login and g.groups_id=".$_GET['group_filter']." and ul.lessons_ID=$lesson_id and u.login = ul.users_LOGIN and ul.user_type = 'student'");
        }else{
            $lesson_users = ef_getTableData("users_to_lessons ul, users u", "ul.users_LOGIN, u.name, u.surname", "ul.lessons_ID=$lesson_id and u.login = ul.users_LOGIN and ul.user_type = 'student'");
        }

        for ($i = 0; $i < sizeof($lesson_users); $i++ ){
            $login = $lesson_users[$i]['users_LOGIN'];
            $name = $lesson_users[$i]['surname']." ".$lesson_users[$i]['name'];
            $write_row = 3+$i;
            $eF_workSheetOverall -> write($write_row, 0, $name, $eF_formatRowHeader);
            for ($j = 0; $j<sizeof($tests); $j++){
                $test_id = $tests[$j]['id'];
                $score = ef_getTableData("done_tests", "score", "users_LOGIN='".$login."' and tests_ID=$test_id");

                $write_column = $j+1;
                if (sizeof($score)>0){
                    $wr_score = 100*$score[0]['score'];
                    $sum[$j] +=  $wr_score;
                    $cnt[$j]++;
                    $eF_workSheetOverall -> writeNumber($write_row, $write_column, $wr_score, $eF_formatContent);
                }
                else {
                    $wr_score = "---";
                    $eF_workSheetOverall -> write($write_row, $write_column, $wr_score, $eF_formatContent);
                }

            }
        }

        $write_row++;
        $eF_workSheetOverall->write($write_row, 0, _AVERAGESCORE, $ef_FormatRowHeader);
        $write_column = 1;
        for ($i=0; $i<sizeof($tests); $i++){
            $eF_workSheetOverall -> writeNumber($write_row, $write_column, $sum[$i]/$cnt[$i], $eF_formatContent);
            $write_column++;
        }

        $eF_WorkBook ->close();
        exit(0);
    }
    if( isset($_GET['oper']) && $_GET['oper'] == 'lesson_tests_pdf_export'){
        $lesson_id = $_GET['sel_lesson'];
        $lesson_name = ef_getTableData("lessons","name","id=$lesson_id");
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true);
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor(PDF_AUTHOR);
        $pdf->SetTitle($doc_title);
        $pdf->SetSubject($doc_subject);
        $pdf->SetKeywords($doc_keywords);

        //set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);

        //set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

        $pdf->setHeaderFont(Array('FreeSerif', 'I', 11));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->setHeaderData('','','', _STATISTICSFORLESSON.": ".$lesson_name[0]['name']);
        $pdf->setLanguageArray($l); //set language items
        //initialize document
        $pdf->AliasNbPages();
        $pdf->AddPage();
        $pdf->SetFont("FreeSerif","B",12);
        $pdf->SetTextColor(0,0,0);


        $tests = ef_getTableData("tests t, content c", "t.id, c.name", "t.content_ID = c.id and c.lessons_ID=$lesson_id");

        $sum = array();
        $cnt = array();
        $pdf -> Cell(60, 7, " ", 0, 0, C, 0);
        for ($i = 0; $i < sizeof($tests); $i++){
            $pdf -> Cell(60, 7, $tests[$i]['name'], 0, 0, C, 0);
            $sum[$i] = 0;
            $cnt[$i] = 0;
        }
        $pdf -> Ln();
        if (isset($_GET['group_filter']) && $_GET['group_filter'] > 0){
            $lesson_users = ef_getTableData("users_to_lessons ul, users u, users_to_groups g", "ul.users_LOGIN, u.name, u.surname", "g.users_LOGIN = u.login and g.groups_id=".$_GET['group_filter']." and ul.lessons_ID=$lesson_id and u.login = ul.users_LOGIN and ul.user_type = 'student'");
        }else{
            $lesson_users = ef_getTableData("users_to_lessons ul, users u", "ul.users_LOGIN, u.name, u.surname", "ul.lessons_ID=$lesson_id and u.login = ul.users_LOGIN and ul.user_type = 'student'");
        }

        for ($i = 0; $i < sizeof($lesson_users); $i++ ){
            $login = $lesson_users[$i]['users_LOGIN'];
            $name = $lesson_users[$i]['surname']." ".$lesson_users[$i]['name'];
            $pdf -> SetTextColor(0, 0, 255);
            $pdf->SetFont("FreeSerif","B",10);
            $pdf -> Cell(60, 7, $name, 0, 0, L, 0);
            for ($j = 0; $j < sizeof($tests); $j++){
                $pdf -> SetTextColor(0, 0, 0);
                $test_id = $tests[$j]['id'];
                $score = ef_getTableData("done_tests", "score", "users_LOGIN='".$login."' and tests_ID=$test_id");
                $pdf->SetFont("FreeSerif","",10);
                if (sizeof($score)>0){
                    $wr_score = 100*$score[0]['score'];
                    $sum[$j] +=  $wr_score;
                    $cnt[$j]++;
                    if ($wr_score == 0)
                        $pdf -> Cell(60, 7, "0", 0, 0, C, 0);
                    else
                        $pdf -> Cell(60, 7, $wr_score, 0, 0, C, 0);
                }
                else {
                    $wr_score = "---";
                    $pdf -> Cell(60, 7, $wr_score, 0, 0, C, 0);
                }

            }
            $pdf -> Ln();
        }
        $pdf -> SetTextColor(0, 0, 0);
        $pdf -> SetFont("FreeSerif","B",10);
        $pdf -> Cell(60, 7, _AVERAGESCORE, 0, 0, C, 0);
        for ($i=0; $i<sizeof($tests); $i++){
            if ($sum[$i] == 0)
                $pdf -> Cell(60, 7, "0", 0, 0, C, 0);
            else
                $pdf -> Cell(60, 7, $sum[$i]/$cnt[$i], 0, 0, C, 0);
        }
        $pdf -> Output();
        exit(0);
    }
    if( isset($_GET['oper']) && $_GET['oper'] == 'questions_export'){
        $lesson_id = $_GET['sel_lesson'];
        $lesson_name = ef_getTableData("lessons","name","id=$lesson_id");
        require_once 'Spreadsheet/Excel/Writer.php';
        $eF_WorkBook = new Spreadsheet_Excel_Writer();
        $eF_WorkBook -> setVersion(8);
        $eF_WorkBook ->send('questions_lesson'.$lesson_id.'_export.xls');

        $eF_formatExcelHeaders = & $eF_WorkBook -> addFormat();
        $eF_formatExcelHeaders ->setSize(12);
        $eF_formatExcelHeaders ->setBold();
        $eF_formatExcelHeaders ->setAlign('merge');
        $eF_formatExcelHeaders ->setHAlign('left');

        $eF_formatFields = & $eF_WorkBook -> addFormat();
        $eF_formatFields ->setItalic();
        $eF_formatFields ->setAlign('merge');
        $eF_formatFields ->setHAlign('left');

        $eF_formatHeader = & $eF_WorkBook -> addFormat();
        $eF_formatHeader ->setBold();
        $eF_formatHeader ->setFgColor('blue');
        $eF_formatHeader ->setColor('white');
        $eF_formatHeader ->setAlign('merge');
        $eF_formatHeader ->setHAlign('left');

        $eF_formatContent = & $eF_WorkBook -> addFormat();
        $eF_formatContent ->setAlign('merge');
        $eF_formatContent ->setHAlign('left');
        $eF_formatContent ->setVAlign('top');

        $eF_workSheetOverall = & $eF_WorkBook ->addWorkSheet("1");
        $eF_workSheetOverall -> setInputEncoding('utf-8');


        $eF_workSheetOverall->write(0,0,_LESSON, $eF_formatExcelHeaders);
        $eF_workSheetOverall->write(0,1,$lesson_name[0]['name'], $eF_formatExcelHeaders);

        $eF_workSheetOverall->write(2,0,_QUESTIONTEXT, $eF_formatHeader);
        $eF_workSheetOverall->write(2,1,_QUESTIONTYPE, $eF_formatHeader);
        $eF_workSheetOverall->write(2,2,_DIFFICULTY, $eF_formatHeader);
        $eF_workSheetOverall->write(2,3,_TIMESDONE, $eF_formatHeader);
        $eF_workSheetOverall->write(2,4,_AVERAGESCORE, $eF_formatHeader);

        $write_row = 4;
        $write_column = 0;

        $questions = ef_getTableData("questions q, content c","q.id, q.text, q.type, q.difficulty","q.content_ID = c.id and c.lessons_ID=$lesson_id");
        for ($i=0; $i < sizeof($questions); $i++){
            $question_id = $questions[$i]['id'];
            if (!isset($_GET['group_filter'])){
               $score = eF_getTableData("done_questions q","sum(q.score) as sum, count(q.score) as num","q.questions_ID =$question_id");
            }
            else{
                $score = eF_getTableData("done_questions q, done_tests t, users_to_groups g","sum(q.score) as sum, count(q.score) as num","q.questions_ID =$question_id and q.done_tests_ID = t.ID and t.users_LOGIN = g.users_LOGIN and g.groups_ID=".$_GET['group_filter']);
            }
            $avg_score  = round(100 * $score[0]['sum'] / $score[0]['num'], 2) / 100;
            $times_done = $score[0]['num'];
            $eF_workSheetOverall->write($write_row, 0, strip_tags($questions[$i]['text']), $eF_formatContent);
            $eF_workSheetOverall->write($write_row, 1, $questions[$i]['type'], $eF_formatContent);
            $eF_workSheetOverall->write($write_row, 2, $questions[$i]['difficulty'], $eF_formatContent);
            $eF_workSheetOverall->writeNumber($write_row, 3, $times_done, $eF_formatContent);
            $eF_workSheetOverall->writeNumber($write_row, 4, $avg_score, $eF_formatContent);

            $write_row++;
        }
        $eF_WorkBook ->close();
        exit(0);
    }
    if( isset($_GET['oper']) && $_GET['oper'] == 'questions_pdf_export'){
        $lesson_id = $_GET['sel_lesson'];
        $lesson_name = ef_getTableData("lessons","name","id=$lesson_id");
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true);
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor(PDF_AUTHOR);
        $pdf->SetTitle($doc_title);
        $pdf->SetSubject($doc_subject);
        $pdf->SetKeywords($doc_keywords);

        //set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        //set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); //set image scale factor

        $pdf->setHeaderFont(Array('FreeSerif', 'I', 11));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->setHeaderData('','','', _STATISTICSFORLESSON.": ".$lesson_name[0]['name']);
        $pdf->setLanguageArray($l); //set language items
        //initialize document
        $pdf->AliasNbPages();
        $pdf->AddPage('L');
        $pdf->SetTextColor(0,0,0);

        $pdf->SetFont("FreeSerif","B",10);
        $pdf->Cell(90, 10, _QUESTIONTEXT, 0, 0, L, 0);
        $pdf->Cell(40, 10, _QUESTIONTYPE, 0, 0, C, 0);
        $pdf->Cell(40, 10, _DIFFICULTY, 0, 0, C, 0);
        $pdf->Cell(60, 10, _TIMESDONE, 0, 0, C, 0);
        $pdf->Cell(40, 10, _AVERAGESCORE, 0, 1, C, 0);

        $questions = ef_getTableData("questions q, content c","q.id, q.text, q.type, q.difficulty","q.content_ID = c.id and c.lessons_ID=$lesson_id");
        $pdf->SetFont("FreeSerif","",10);
        for ($i=0; $i < sizeof($questions); $i++){
            $question_id = $questions[$i]['id'];
            if (!isset($_GET['group_filter'])){
               $score = eF_getTableData("done_questions q","sum(q.score) as sum, count(q.score) as num","q.questions_ID =$question_id");
            }
            else{
                $score = eF_getTableData("done_questions q, done_tests t, users_to_groups g","sum(q.score) as sum, count(q.score) as num","q.questions_ID =$question_id and q.done_tests_ID = t.ID and t.users_LOGIN = g.users_LOGIN and g.groups_ID=".$_GET['group_filter']);
            }
            $avg_score  = round(100 * $score[0]['sum'] / $score[0]['num'], 2) / 100;
            $times_done = $score[0]['num'];
            $pdf->Cell(90, 5, trim(strip_tags($questions[$i]['text'])), 0, 0, L, 0);
            $pdf->Cell(40, 5, $questions[$i]['type'], 0, 0, C, 0);
            $pdf->Cell(40, 5, $questions[$i]['difficulty'], 0, 0, C, 0);
            if ($times_done == 0)
                $pdf->Cell(60, 5, "0", 0, 0, C, 0);
            else
                $pdf->Cell(60, 5, $times_done, 0, 0, C, 0);
            if ($avg_score == 0)
                $pdf->Cell(40, 5, "0", 0, 1, C, 0);
            else
                $pdf->Cell(40, 5, $avg_score, 0, 1, C, 0);
        }
        $pdf -> Output();
        exit(0);
    }
    if( isset($_GET['oper']) && $_GET['oper'] == 'all_tests_export'){
        $login = $_GET['login'];
        require_once 'Spreadsheet/Excel/Writer.php';
        $eF_WorkBook = new Spreadsheet_Excel_Writer();
        $eF_WorkBook -> setVersion(8);
        $eF_WorkBook ->send('tests_user_'.$login.'_export.xls');
        $eF_formatExcelHeaders = & $eF_WorkBook -> addFormat();
        $eF_formatExcelHeaders ->setSize(12);
        $eF_formatExcelHeaders ->setBold();
        $eF_formatExcelHeaders ->setAlign('merge');
        $eF_formatExcelHeaders ->setHAlign('left');

        $eF_formatFields = & $eF_WorkBook -> addFormat();
        $eF_formatFields ->setItalic();
        $eF_formatFields ->setAlign('merge');
        $eF_formatFields ->setHAlign('left');

        $eF_formatHeader = & $eF_WorkBook -> addFormat();
        $eF_formatHeader ->setBold();
        $eF_formatHeader ->setFgColor('blue');
        $eF_formatHeader ->setColor('white');
        $eF_formatHeader ->setAlign('merge');
        $eF_formatHeader ->setHAlign('left');

        $eF_formatContent = & $eF_WorkBook -> addFormat();
        $eF_formatContent ->setAlign('merge');
        $eF_formatContent ->setHAlign('left');
        $eF_formatContent ->setVAlign('top');

        $eF_workSheetOverall = & $eF_WorkBook ->addWorkSheet("1");
        $eF_workSheetOverall -> setInputEncoding('utf-8');


        $eF_workSheetOverall->write(0,0,_USER, $eF_formatExcelHeaders);
        $eF_workSheetOverall->write(0,1,$login, $eF_formatExcelHeaders);

        $eF_workSheetOverall->write(2,0,_TEST, $eF_formatHeader);
        $eF_workSheetOverall->write(2,1,_SCORE, $eF_formatHeader);
        $write_row = 3;
        $write_column = 0;
        $done_tests = ef_getTableData("done_tests d, tests t, content c", "d.score, c.name", "c.id = t.content_ID and d.tests_ID = t.id and d.users_LOGIN='".$login."'");

        for ($i = 0; $i < sizeof($done_tests); $i++){
            $eF_workSheetOverall->write($write_row, 0, $done_tests[$i]['name'], $eF_formatContent);
            $eF_workSheetOverall->write($write_row, 1, 100*$done_tests[$i]['score']."%", $eF_formatContent);
            $write_row++;
        }

        $eF_WorkBook ->close();
        exit(0);
    }
    if( isset($_GET['oper']) && $_GET['oper'] == 'all_tests_pdf_export'){
        $login = $_GET['login'];
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true);
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor(PDF_AUTHOR);
        $pdf->SetTitle($doc_title);
        $pdf->SetSubject($doc_subject);
        $pdf->SetKeywords($doc_keywords);

        //set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        //set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); //set image scale factor

        $pdf->setHeaderFont(Array('FreeSerif', 'I', 11));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->setHeaderData('','','', _STATISTICSFORUSER.": ".$login);
        $pdf->setLanguageArray($l); //set language items
        //initialize document
        $pdf->AliasNbPages();
        $pdf->AddPage();
        $pdf->SetFont("FreeSerif","B",12);
        $pdf->SetTextColor(0,0,0);


        $pdf->SetTextColor(0,0,0);
        $pdf->SetFont("FreeSerif","B",10);
        $pdf->Cell(60, 7, _TEST, 0, 0, C, 0);
        $pdf->Cell(40, 7, _SCORE, 0, 1, C, 0);
        $done_tests = ef_getTableData("done_tests d, tests t, content c", "d.score, c.name", "c.id = t.content_ID and d.tests_ID = t.id and d.users_LOGIN='".$login."'");
        $pdf->SetFont("FreeSerif","",10);
        for ($i = 0; $i < sizeof($done_tests); $i++){
            $pdf->Cell(60, 7, $done_tests[$i]['name'], 0, 0, C, 0);
            $pdf->Cell(40, 7, 100*$done_tests[$i]['score']."%", 0, 1, C, 0);
        }

        $pdf->Output();
        exit(0);
    }
    if( isset($_GET['oper']) && strcmp($_GET['oper'],"project_export") == 0){
        require_once 'Spreadsheet/Excel/Writer.php';
        $eF_WorkBook = new Spreadsheet_Excel_Writer();
        $eF_WorkBook -> setVersion(8);
        $eF_WorkBook ->send('project_'.$_GET['title'].'_export.xls');

        $eF_formatExcelHeaders = & $eF_WorkBook -> addFormat();
        $eF_formatExcelHeaders ->setSize(12);
        $eF_formatExcelHeaders ->setBold();
        $eF_formatExcelHeaders ->setAlign('merge');
        $eF_formatExcelHeaders ->setHAlign('left');

        $eF_formatFields = & $eF_WorkBook -> addFormat();
        $eF_formatFields ->setItalic();
        $eF_formatFields ->setAlign('merge');
        $eF_formatFields ->setHAlign('left');

        $eF_formatHeader = & $eF_WorkBook -> addFormat();
        $eF_formatHeader ->setBold();
        $eF_formatHeader ->setFgColor('blue');
        $eF_formatHeader ->setColor('white');
        $eF_formatHeader ->setAlign('merge');
        $eF_formatHeader ->setHAlign('left');

        $eF_formatContent = & $eF_WorkBook -> addFormat();
        $eF_formatContent ->setAlign('merge');
        $eF_formatContent ->setHAlign('left');
        $eF_formatContent ->setVAlign('top');

        $eF_workSheetOverall = & $eF_WorkBook ->addWorkSheet("1");
        $eF_workSheetOverall -> setInputEncoding('utf-8');

        $eF_workSheetOverall -> write(0,0,_PROJECT.":", $eF_formatHeader);
        $eF_workSheetOverall -> write(0,1,$_GET['title'],$eF_formatExcelHeaders);
        $write_row = 4;
        $write_column = 0;

        $users = ef_getTableData("users_to_projects", "users_LOGIN, grade, comments", "projects_ID='".$_GET['projects_ID']."'");
        if (sizeof($users) > 0){
            $eF_workSheetOverall -> write($write_row, 0, _LOGIN, $eF_formatHeader);
            $eF_workSheetOverall -> write($write_row, 1, _GRADE."(%)", $eF_formatHeader);
            $eF_workSheetOverall -> write($write_row, 2, _COMMENTS, $eF_formatHeader);
            $write_row++;
        }

        for ($i=0; $i<sizeof($users); $i++){
           $write_column = 0;
           foreach ($users[$i] as $value){
                if (strlen($value) > 0){
                    $eF_workSheetOverall -> write($write_row, $write_column, $value, $eF_formatFields);
                }
                else{
                    $eF_workSheetOverall -> write($write_row, $write_column, "----", $eF_formatFields);
                }
                $write_column++;
            }
            $write_row++;
        }

        $eF_WorkBook ->close();
        exit(0);
    }
    if( isset($_GET['oper']) && strcmp($_GET['oper'],"project_pdf_export") == 0){
        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true);
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor(PDF_AUTHOR);
        $pdf->SetTitle($doc_title);
        $pdf->SetSubject($doc_subject);
        $pdf->SetKeywords($doc_keywords);

        //set margins
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        //set auto page breaks
        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO); //set image scale factor

        $pdf->setHeaderFont(Array('FreeSerif', 'I', 11));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->setHeaderData('','','', _PROJECT.":".$_GET['title']);
        $pdf->setLanguageArray($l); //set language items
        //initialize document
        $pdf->AliasNbPages();
        $pdf->AddPage('L');
        $pdf->SetFont("FreeSerif","B",11);
        $pdf->SetTextColor(0,0,0);

        $users = ef_getTableData("users_to_projects", "users_LOGIN, grade, comments", "projects_ID='".$_GET['projects_ID']."'");
        if (sizeof($users) > 0){
            $pdf->Cell(100, 10, _LOGIN, 0, 0, L, 0);
            $pdf->Cell(40, 10, _GRADE."(%)", 0, 0, C, 0);
            $pdf->Cell(300, 10, _COMMENTS, 0, 1, L, 0);
        }
        $pdf->SetFont("FreeSerif","",10);
        for ($i=0; $i<sizeof($users); $i++){
            $j = 0;
            foreach ($users[$i] as $value){
                if ($j == 0)
                    $pdf->Cell(100, 10, $value, 0, 0, L, 0);
                else if ($j == 1)
                    $pdf->Cell(40, 10, $value, 0, 0, C, 0);
                else if ($j == 2)
                    $pdf->Cell(300, 10, $value, 0, 1, L, 0);
                $j++;
            }
        }
        $pdf -> Output();
        exit(0);
}



?>
