<?php
/**
* Sets language options
* 
* This file sets whether a system language is active. It provides also links to other language related tasks
*
* @package efront
* @version 1.0
*/

session_cache_limiter('none');
session_start();

$path = "../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";


$languages = eF_getTableData("languages");                    //Get available languages

for ($i=0;$i<count($languages);$i++){
    $upload_form[$i] = new HTML_QuickForm("upload_language_form".$i, "post", $_SERVER['PHP_SELF'].'?ctg=control_panel&op=languages', "", null, true);
    $upload_form[$i] -> registerRule('checkParameter', 'callback', 'eF_checkParameter');                   //Register this rule for checking user input with our function, eF_checkParameter
    $upload_form[$i] -> addElement('file', 'language_upload', null, 'class = "inputText"');
    $upload_form[$i] -> addElement('submit', 'submit_upload_language', _UPLOAD, 'class = "flatButton"');      
    $upload_form[$i] -> setDefaults(array('overwrite' => true));
    if ($upload_form[$i] -> isSubmitted() && $upload_form[$i] -> validate()) {
        if (!eF_checkParameter($_FILES['language_upload']['name'], 'filename')) {                    //Make sure this is a well formed file name
                $message = _ILLEGALFILENAME;
                $message_type = 'failure';            
        }
        else{
            if ($_FILES['language_upload']['error'] == 0) { 
                $l_name  = $languages[$i]['name'];
                $flg = move_uploaded_file($_FILES['language_upload']['tmp_name'],$path."language/lang-".$l_name.".tmp");
                if ($flg){
                    if (ef_checkLanguageFile($path."language/lang-".$l_name.".tmp")){
                        if (unlink($path."language/lang-".$l_name.".php"))
                            if(rename($path."language/lang-".$l_name.".tmp",$path."language/lang-".$l_name.".php")){
                                $message = _FILEUPLOADEDSUCCESFULLY;
                                $message_type = 'success';                        
                                header("location:administrator.php?ctg=control_panel&op=languages&message=".$message."&message_type=".$message_type);   
                            }
                            else{
                                $message = _UNABLETOCREATELANGFILE;
                                $message_type = 'failure';
                                header("location:administrator.php?ctg=control_panel&op=languages&message=".$message."&message_type=".$message_type);   
                            }                       
                        else{
                            $message = _UNABLETOCREATELANGFILE;
                            $message_type = 'failure';
                            header("location:administrator.php?ctg=control_panel&op=languages&message=".$message."&message_type=".$message_type);  
                        }                
                    }
                    else{
                        unlink($path."language/lang-".$l_name.".tmp");
                        $message = _NOTALANGFILE;
                        $message_type = 'failure';
                        header("location:administrator.php?ctg=control_panel&op=languages&message=".$message."&message_type=".$message_type);     
                    }            
                }
                else{
                    $message = _COULDNOTUPLOADFILECONTACTADMIN;
                    $message_type = 'failure';
                    header("location:administrator.php?ctg=control_panel&op=languages&message=".$message."&message_type=".$message_type);         
                }
            } else {
               $message = _COULDNOTUPLOADFILECONTACTADMIN;
               $message_type = 'failure';
               header("location:administrator.php?ctg=control_panel&op=languages&message=".$message."&message_type=".$message_type);         
           
            }            
        }        
    }
    $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
    $upload_form[$i] -> accept($renderer);
    $form[$i] = $renderer -> toArray();
    
}
$smarty -> assign('T_UPLOAD_LANGUAGE_FORM', $form );

$smarty -> assign("T_LANGUAGES", $languages);



if (isset($_GET['activate_language'])) {
    $language_name = $_GET['activate_language'];
    $fields['active'] = "1";
    $ok = eF_updateTabledata("languages", $fields, 'name="'.$language_name.'"');
    if ($ok){
        $message = _LANGUAGEACTIVATED;
        $message_type = 'success';            
        header("location:administrator.php?ctg=control_panel&op=languages&message=".$message."&message_type=".$message_type);
    }
    else{
        $message = _ERROROCCURED;
        $message_type = 'failure';            
        header("location:administrator.php?ctg=control_panel&op=languages&message=".$message."&message_type=".$message_type);
    }
}

if (isset($_GET['deactivate_language'])) {
    $language_name = $_GET['deactivate_language'];
    $fields['active'] = "0";
    $ok = eF_updateTabledata("languages", $fields, 'name="'.$language_name.'"');
    if ($ok){
        $message = _LANGUAGEDEACTIVATED;
        $message_type = 'success';            
        header("location:administrator.php?ctg=control_panel&op=languages&message=".$message."&message_type=".$message_type);
    }
    else{
        $message = _ERROROCCURED;
        $message_type = 'failure';            
        header("location:administrator.php?ctg=control_panel&op=languages&message=".$message."&message_type=".$message_type);
    }
}


if (isset($_GET['add_language'])){
    $smarty->assign("T_ADDLANGUAGE","true");    
}

if (isset($_POST['submit_add'])){
    $res = copy($path."language/lang-".$_POST['sourcelang'].".php",$path."language/lang-".$_POST['new_language_name'].".php");
    if ($res){
        $fields['name']   = $_POST['new_language_name'];
        $fields['active'] = "1";
        $result           = eF_insertTableData("languages", $fields);
        if ($result){
            $message = _UPDATESUCCESFULLYMADE;
            $message_type = 'success';                
        }
        else{
            unlink($path."language/lang-".$_POST['new_language_name'].".php");
            $message = _SOMEPROBLEMUPDATEINGFILES;
            $message_type = 'failure';    
        }
    }
    else{
        $message = _UNABLETOCREATELANGFILE;
        $message_type = 'failure';    
    }
    header("location:administrator.php?ctg=control_panel&op=languages&message=".$message."&message_type=".$message_type);
}

if (isset($_POST['submit_cancel'])){
    header("location:administrator.php?ctg=control_panel&op=languages");
}

?>