<?php
/**
* forum admin page
*
* This page is used to configure forum
*
* @package efront
* @version 1.0
*/

session_cache_limiter('none');
session_start();

$path = "../../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";

if (eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']) != 'administrator' || $_SESSION['s_role_options']['forum'] != 1) {                   //Only a valid user may access this page
    header("location: index.php");
    exit;
}

$form = new HTML_QuickForm("forum_admin_form", "post", $_SERVER['PHP_SELF'], "", null, true);  //Build the form
$form -> addElement('select', 'allow_html',        _ALLOWHTMLFPM,  array(1 => _YES, 0 => _NO));
$form -> addElement('select', 'polls',             _ACTIVATEPOLLS, array(1 => _YES, 0 => _NO));
$form -> addElement('select', 'forum_attachments', _ALLOWATTACHMENTSINF, array(1 => _YES, 0 => _NO));
$form -> addElement('select', 'students_add_forums', _USERSMAYADDFORUMS, array(0 => _NO, 1 => _YES, ));
$form -> addElement('text', 'pm_quota',          _PMQUOTA,             'class = "inputText" style = "width:40px"');
$form -> addElement('text', 'pm_attach_quota',   _PMATTACHMENTSQUOTA,  'class = "inputText" style = "width:40px"');
$form -> addRule('pm_quota',        _THEFIELD.' "'._PMQUOTA.'" '._MUSTBENUMERIC,            'numeric', null, 'client');
$form -> addRule('pm_attach_quota', _THEFIELD.' "'._PMATTACHMENTSQUOTA.'" '._MUSTBENUMERIC, 'numeric', null, 'client');

$form -> addElement('submit', 'submit_settings', _SUBMIT, 'class = "flatButton"');

$current_values = eF_getTableDataFlat("f_configuration", "*");
$current_values = array_combine($current_values['name'], $current_values['value']);
$form -> setDefaults($current_values);

if ($form -> isSubmitted() && $form -> validate()) {                                                              //If the form is submitted and validated
    $values = $form -> exportValues();
    eF_deleteTableData("f_configuration");

    $fields[] = array('name' => 'allow_html',          "value" => $values['allow_html']          ? 1 : 0);
    $fields[] = array('name' => 'polls',               "value" => $values['polls']               ? 1 : 0);
    $fields[] = array('name' => 'forum_attachments',   "value" => $values['forum_attachments']   ? 1 : 0);
    $fields[] = array('name' => 'students_add_forums', "value" => $values['students_add_forums'] ? 1 : 0);
    $fields[] = array('name' => 'pm_quota',            "value" => $values['pm_quota']);
    $fields[] = array('name' => 'pm_attach_quota',     "value" => $values['pm_attach_quota']);

    foreach ($fields as $field) {
        eF_insertTableData("f_configuration", array("name" => $field['name'], "value" => $field['value']));
    }
    
    $message      = _SUCCESSFULLYINSERTEDVALUES;
    $message_type = 'success';
}

$renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);                  //Create a smarty renderer

$renderer -> setRequiredTemplate (
   '{if $required}
        {$html}&nbsp;<span class = "formRequired">*</span>
    {/if}');
$form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);          //Set javascript error messages
$form -> setRequiredNote(_REQUIREDNOTE);
$form -> accept($renderer);                                                     //Assign this form to the renderer, so that corresponding template code is created

$smarty -> assign('T_CONFIGURATION_FORM', $renderer -> toArray());                     //Assign the form to the template



$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);
$smarty -> display("forum/forum_admin.tpl");

?>

