<?php
/**
* Recreates the search table
* 
* This page reconstructs the search table, by deleting all search terms and rebuilding term tables
* @package efront
* @version 1.0
*/

//General initialization and parameters
session_cache_limiter('none');
session_start();

$path = "../libraries/";

/** Configuration file.*/
include_once $path."configuration.php";

$message = '';$message_type = '';
//eF_printHeader(); 
//error_reporting(E_ALL);
//echo "<pre>";print_r($_POST);print_r($_GET);

if (eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']) != "administrator") {                               //Only an administrator may access this page
    header("location:index.php");
    exit;
}

$form = new HTML_QuickForm("logout_user_form", "post", $_SERVER['PHP_SELF'], "", null, true);
$form -> addElement('submit', 'submit_create_search', _RECREATESEARCHTABLE, 'class = "flatButton"');

if ($form -> isSubmitted() && $form -> validate()) {

    eF_deleteTableData("search_keywords");                                              //Delete old search terms

    $content = eF_getTableData("content", "id,name,data");                              //Get all the content
    for ($i = 0; $i < sizeof($content); $i++) {
		EfrontSearch :: insertText($content[$i]['name'], $content[$i]['id'], "content", "title");
		EfrontSearch :: insertText(strip_tags($content[$i]['data']), $content[$i]['id'], "content", "data");
    }

    $news = eF_getTableData("news", "id, title, data");                                 //Get all the news
    for ($i = 0; $i < sizeof($news); $i++) {
		EfrontSearch :: insertText($news[$i]['title'], $news[$i]['id'], "news", "title");
		EfrontSearch :: insertText($news[$i]['data'], $news[$i]['id'], "news", "data");
    }

    $comments = eF_getTableData("comments", "id, data");                                //Get all the comments
    for ($i = 0; $i < sizeof($comments); $i++) {
		EfrontSearch :: insertText($comments[$i]['data'], $comments[$i]['id'], "comments", "data");
    }

    $forum_messages = eF_getTableData("f_messages", "id, title, body");                       //Get all the forum messages
    for ($i = 0; $i < sizeof($forum_messages); $i++) {
		EfrontSearch :: insertText($forum_messages[$i]['body'], $forum_messages[$i]['id'], "f_messages", "data");
		EfrontSearch :: insertText($forum_messages[$i]['title'], $forum_messages[$i]['id'], "f_messages", "title");
    }

    $personal_messages = eF_getTableData("f_personal_messages", "id, title, body");           //Get all the personal messages
    for ($i = 0; $i < sizeof($personal_messages); $i++) {
		EfrontSearch :: insertText($personal_messages[$i]['body'], $personal_messages[$i]['id'], "f_personal_messages", "data");
		EfrontSearch :: insertText($personal_messages[$i]['title'], $personal_messages[$i]['id'], "f_personal_messages", "title");
    }

    $message      = _SEARCHTABLERECREATED;
    $message_type = 'success';
}

$renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
$form -> accept($renderer);
$smarty -> assign('T_CREATE_SEARCH_FORM', $renderer -> toArray());    

$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);

$smarty -> display("create_search.tpl");

?>