<?php

session_cache_limiter('none');          //Initialize session
session_start();
$path = "../libraries/";                //Define default path
/** The configuration file.*/
require_once $path."configuration.php";  //Because this file is also called as separate file

if (isset($_GET['tab'])){
    $smarty->assign('T_TAB',$_GET['tab']);
}
$default_file = "data_".time().".tgz";
$options = array ("1" => _CONTENTDATAANDDATABASE);

$backup_form = new HTML_QuickForm("backup_form", "post", $_SERVER['PHP_SELF'].'?ctg=control_panel&op=backup', "", null, true);
$backup_form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');                   //Register this rule for checking user input with our function, eF_checkParameter
$backup_form -> addElement('text', 'backupname', null, 'class = "inputText" value="'.$default_file.'"');
$backup_form -> addRule('backupname', _THEFIELD.' '._FILENAME.' '._ISMANDATORY, 'required', null, 'client');
$backup_form -> addElement('select', 'backuptype', null, $options);
$backup_form -> addElement('submit', 'submit_backup', _TAKEBACKUP, 'class = "flatButton"');         
if ($backup_form -> isSubmitted() && $backup_form -> validate()) {
   $backupname = $backup_form->exportValue('backupname');
   $backuptype = $backup_form->exportValue('backuptype');
   if (!eF_checkParameter($backupname, 'filename')) {                 //make sure this a right formed file name
        $message      = _ILLEGALFILENAME;
        $message_type = 'failure';        
        header("location:administrator.php?ctg=control_panel&op=backup&message=".$message."&message_type=".$message_type);
    }
    
    $backup_filename = G_BACKUPPATH.$backupname;                               //The backup file name
    if (is_file($backup_filename)) {    
        unlink ($backup_filename);                                              //If the file already exists, delete it.
    }
    
    $backup_folder = G_LESSONSPATH.'db_backup/';                                //The temporary database backup folder
    if (is_dir($backup_folder)) {                                            
        eF_deleteFolder($backup_folder);                                        //If the backup directory already exists, delete it to erase old backup files
    }
    
    $old_umask = umask(0);                                                      //See php documentation user notes (28/6/03) on mkdir and permissions 
    $ok = mkdir($backup_folder, 0777, true);
    umask($old_umask);
    if (!$ok) {
        $message = _PROBLEMCREATINGBACKUPDIRECTORY;
        $message_type = 'failure';
        header("location:administrator.php?ctg=control_panel&op=backup&message=".$message."&message_type=".$message_type);                       //Create temporary database backup directory
    }
    
    $result = eF_executeNew("show tables");                                        //Get table names, so as we may back them up
    
    while (list($table) = mysql_fetch_row($result)) {
        $tables[] = $table;
    }
     
    foreach ($tables as $table_name) {
         $res = eF_executeNew("SELECT * FROM ".$table_name." INTO OUTFILE '".$backup_folder.$table_name."'");    //files to store the database data into
    }

    $current_dir = getcwd();
    switch ($backuptype) {
        case 1:
            chdir(G_LESSONSPATH);                                               //The user asked for a content backup
            $filelist = eF_getDirContents();       
            chdir(G_AVATARSPATH);   //this takes avatars in backup in order to restore them 
            $filelist2 = eF_getDirContents(false, array('png', 'gif', 'jpg', 'PNG', 'GIF', 'JPG', 'jpeg', 'JPEG'));
            chdir(G_ADMINPATH);
            $filelist3 = eF_getDirContents();
            chdir(G_LESSONSPATH); 
            break;
        default:
            $message = _NOBACKUPMETHODSELECTED;
            $message_type = 'failure';
            header("location:administrator.php?ctg=control_panel&op=backup&message=".$message."&message_type=".$message_type);
            break;
    }    
    $tar = new Archive_Tar($backup_filename, true);                             //Create the tar archive
    $tar -> create($filelist);
    chdir(G_AVATARSPATH);
    $tar -> addModify($filelist2,"avatars"); //this adds a folder with avatars in backup in order to restore them
    chdir(G_ADMINPATH);
    $tar -> addModify($filelist3,"admin"); //this adds a folder with avatars in backup in order to restore them

    chdir(G_LESSONSPATH); 
    eF_deleteFolder($backup_folder);                                            //Delete the backup directory
    chdir($current_dir);
    $message = _SUCCESFULLYBACKEDUP;
    $message_type = 'success';
    header("location:administrator.php?ctg=control_panel&op=backup&message=".$message."&message_type=".$message_type);
}
$renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
$backup_form -> accept($renderer);
$smarty -> assign('T_BACKUP_FORM', $renderer -> toArray());



$restore_form = new HTML_QuickForm("restore_form", "post", $_SERVER['PHP_SELF'].'?ctg=control_panel&op=backup', "", null, true);
$restore_form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');                   //Register this rule for checking user input with our function, eF_checkParameter
$restore_form -> addElement('file', 'file_upload', null, 'class = "inputText"');
$restore_form -> addElement('submit', 'submit_file', _SENDFILE, 'class = "flatButton"');         
if ($restore_form -> isSubmitted() && $restore_form -> validate()) {
    
    if (!eF_checkParameter($_FILES['file_upload']['name'], 'filename')) {                    //Make sure this is a well formed file name
        $message = _ILLEGALFILENAME;
        $message_type = 'failure';
        header("location:administrator.php?ctg=control_panel&op=backup&message=".$message."&message_type=".$message_type);         
    }

    if ($_FILES['file_upload']['error'] == 0) { 
        eF_deleteFolder(G_LESSONSPATH);   //added in v3 21/6/2007 lessons folders must delete during restore....
        mkdir(G_LESSONSPATH,0777,true); 
        eF_deleteFolder(G_ADMINPATH);   //added in v3 21/6/2007 admin folders must delete during restore....
        mkdir(G_ADMINPATH,0777,true); 
        $flg = move_uploaded_file($_FILES['file_upload']['tmp_name'],G_LESSONSPATH."backup_tmp.tgz");
        if ($flg){
            $tar = new Archive_Tar(G_LESSONSPATH."backup_tmp.tgz", true);               //Uncompress all files   
            $tar -> extract(G_LESSONSPATH);  
            unlink(G_LESSONSPATH."backup_tmp.tgz");
            $db_filelist = eF_getDirContents(G_LESSONSPATH.'db_backup/');               //The contents of database backup directory
            if ($db_filelist){
                foreach ($db_filelist as $filename) {
                    $table_name = basename($filename);
                    if (is_file($filename)) {                                               //restore db tables
                        eF_deleteTableData($table_name);
                        eF_executeNew("LOAD DATA INFILE '".$filename."' INTO TABLE ".$table_name);
                    }
                }     
                $profile_fields = eF_getTableData("user_profile");
                for($i = 0; $i < sizeof($profile_fields); $i++){                //For synchronazing tables users and user_profile
                    $temp = $profile_fields[$i];
                    eF_structureTableUsers($temp);  
                }
                eF_deleteFolder(G_LESSONSPATH.'db_backup/');                                //Erase the database backup directory
                
                if (file_exists(G_LESSONSPATH.'avatars')){  //restores avatars
                    $ok =  eF_copyFolder(G_LESSONSPATH.'avatars', G_AVATARSPATH);
                    eF_deleteFolder(G_LESSONSPATH.'avatars/');
                
                }
                if (file_exists(G_LESSONSPATH.'admin')){  //restores admin folder
                    $ok =  eF_copyFolder(G_LESSONSPATH.'admin', G_ADMINPATH);
                    eF_deleteFolder(G_LESSONSPATH.'admin/');
                
                }                                
                $message = _SUCCESFULLYRESTOREDDATA;
                $message_type = 'success';
                header("location:administrator.php?ctg=control_panel&op=backup&message=".$message."&message_type=".$message_type);         
            }
            else{
                $message = _COULDNOTUNCOMPRESS;
                $message_type = 'failure';
                header("location:administrator.php?ctg=control_panel&op=backup&message=".$message."&message_type=".$message_type);         
            }
            
        }
        else{
            $message = _COULDNOTUPLOADFILECONTACTADMIN;
            $message_type = 'failure';
            header("location:administrator.php?ctg=control_panel&op=backup&message=".$message."&message_type=".$message_type);         
        }
    } else {
       $message = _COULDNOTUPLOADFILECONTACTADMIN;
       $message_type = 'failure';
       header("location:administrator.php?ctg=control_panel&op=backup&message=".$message."&message_type=".$message_type);         
   
    }
}
$renderer2 =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
$restore_form -> accept($renderer2);
$smarty -> assign('T_RESTORE_FORM', $renderer2 -> toArray());


if (isset($_POST['submit_delete'])) {                                           //Delete the designated files
    if (isset($_POST['filename'])){                                  
        if (eF_checkParameter($_POST['filename'], 'filename')) {                            //Check if asked to delete well formed filenames
            unlink(G_BACKUPPATH.$_POST['filename']);
            $message .= _SUCCESFULLYDELETEDFILE.' '.$value.'<br/>';
            $message_type = 'success';
            header("location:administrator.php?ctg=control_panel&op=backup&tab=restore&message=".$message."&message_type=".$message_type);
        } else {
            $message = _ILLEGALFILENAME;
            $message_type = 'failure';            
            header("location:administrator.php?ctg=control_panel&op=backup&tab=restore&message=".$message."&message_type=".$message_type);
        }
    }else{
        $message = _ILLEGALFILENAME;
        $message_type = 'failure';            
        header("location:administrator.php?ctg=control_panel&op=backup&tab=restore&message=".$message."&message_type=".$message_type);
    }  
    
} elseif (isset($_POST['submit_restore'])) {

    if (!eF_checkParameter($_POST['filename'], 'filename')) {                    //Make sure this is a well formed file name
        $message = _ILLEGALFILENAME;
        $message_type = 'success';
        header("location:administrator.php?ctg=control_panel&op=backup&tab=restore&message=".$message."&message_type=".$message_type);
    } 

    eF_deleteFolder(G_LESSONSPATH);   //added in v3 21/6/2007 lessons folders must delete during restore....
    mkdir(G_LESSONSPATH,0755,true); 
    eF_deleteFolder(G_ADMINPATH);   //added in v3 21/6/2007 admin folder must delete during restore....
    mkdir(G_ADMINPATH,0755,true); 

    $tar = new Archive_Tar(G_BACKUPPATH.$_POST['filename'], true);               //Uncompress all files 

    $tar -> extract(G_LESSONSPATH);

    $db_filelist = eF_getDirContents(G_LESSONSPATH.'db_backup/');
                //The contents of database backup directory
    foreach ($db_filelist as $filename) {
        $table_name = basename($filename);
        if (is_file($filename)) {                                               //restore db tables
            eF_deleteTableData($table_name);
            eF_executeNew("LOAD DATA INFILE '".$filename."' INTO TABLE ".$table_name);
        }
    }
    $profile_fields = eF_getTableData("user_profile");
    for($i = 0; $i < sizeof($profile_fields); $i++){                            //For synchronazing tables users and user_profile
        $temp = $profile_fields[$i];
        eF_structureTableUsers($temp);  
    }
    eF_deleteFolder(G_LESSONSPATH.'db_backup/');                                //Erase the database backup directory
    
    if (file_exists(G_LESSONSPATH.'avatars')){  //restores avatars
        $ok =  eF_copyFolder(G_LESSONSPATH.'avatars', G_AVATARSPATH);
        eF_deleteFolder(G_LESSONSPATH.'avatars/');
    }
    if (file_exists(G_LESSONSPATH.'admin')){  
        $ok =  eF_copyFolder(G_LESSONSPATH.'admin', G_CONTENTPATH);
        eF_deleteFolder(G_LESSONSPATH.'admin/');
    }   
    $message = _SUCCESFULLYRESTOREDDATA;
    $message_type = 'success';
    header("location:administrator.php?ctg=control_panel&op=backup&tab=restore&message=".$message."&message_type=".$message_type);
    
} 
$filenames = array();                                                           //array initializations
$filesizes = array();
$filetimes = array();
$fileurls = array();
$selected  = 'checked';
$count     = 1;

 
if (!is_dir(G_BACKUPPATH)) {
    eF_printMessage(_BACKUPFOLDERDOESNOTEXIST);
    exit;
}

$d = dir(G_BACKUPPATH);
while (false !== ($entry = $d->read())) {                                       //read backup directory contents
    $ext = explode('.', basename($entry));                                      //Make sure that only tgz files appear.
    if ($entry != '..' && $entry != '.' && end($ext) == 'tgz') {
        $filestats = stat(G_BACKUPPATH.$entry);                                 //get statistics for each file, such as its size and modification time
        $filenames[] = $entry;
        $filesizes[] = ceil($filestats['size'] / 1024);
        $filetimes[] = $filestats['mtime'];
    }
}

array_multisort($filetimes, SORT_DESC, $filesizes, $filenames);      
for ($i=0;$i<sizeof($filenames);$i++){
    $fileurls[] = urlencode($filenames[$i]);
    $filetimes_human[] = eF_timestampToTime($filetimes[$i]);
}
//sort files by modification time, display newer ones first
$smarty->assign('T_FILETIMES',$filetimes_human);
$smarty->assign('T_FILENAMES',$filenames);
$smarty->assign('T_FILEURLS',$fileurls);
$smarty->assign('T_FILESIZES',$filesizes);
$smarty->assign('T_FILESTATS',$filestats);

$d->close();


?>