<?php


session_cache_limiter('none');
session_start();

$path = "../libraries/";

include_once $path."configuration.php";

eF_printHeader(); 

//error_reporting(E_ALL);

if (eF_checkUser($_SESSION['s_login'], $_SESSION['s_password']) != "administrator" || $_SESSION['s_role_options']['directions'] != 1) {                           
    header("location:index.php");
    exit;
}
    
if (isset($_GET['id'])) {
    $id = eF_checkParameter($_GET['id'], 'uint');
    if ($id === false || !isset($_GET['id'])) {
        eF_printMessage(_INVALIDID);
        exit;
    }
}

if (isset($_GET['op']) && ($_GET['op'] == 'insert' || $_GET['op'] == 'change')) {
    if (isset($_GET['op']) && $_GET['op'] == 'change' && isset($id)) {
        $form = new HTML_QuickForm("change_directions_form", "post", $_SERVER['PHP_SELF']."?op=change&id=$id", "", null, true);
    } else {
        $form = new HTML_QuickForm("add_news_form", "post", $_SERVER['PHP_SELF']."?op=insert", "", null, true);
    }
    $form -> registerRule('checkParameter', 'callback', 'eF_checkParameter');           //Register this rule for checking user input with our function, eF_checkParameter

    $form -> addElement('text', 'name', _DIRECTIONNAME, 'class = "inputText"');    
    $form -> addRule('name', _THEFIELD.' '._ISMANDATORY, 'required', null, 'client');
    $form -> addRule('name', _INVALIDFIELDDATA, 'checkParameter', 'text');

    if (isset($_GET['op']) && $_GET['op'] == 'insert'){
        $dir_ids = eF_getTableData("directions","id,name"); 
    }elseif (isset($_GET['op']) && $_GET['op'] == 'change'){
        $dir_ids = eF_getTableData("directions","id,name","id!=$id");
    }

    if (isset($_GET['op']) && $_GET['op'] == 'change' && isset($id)) {
        $direction_content = eF_getTableData("directions", "*", "id=".$id);
        $form -> setDefaults(array('name' => $direction_content[0]['name'], 'active' => $direction_content[0]['active'],'parent_direction_ID' => $direction_content[0]['parent_direction_ID']));
    }else{
         $form -> setDefaults(array('active' => 1));    
    }

    $directions[0] = _ROOTDIRECTION;    
        
    for($k=0; $k < sizeof($dir_ids); $k++){
        $directions_tree    = eF_getDirectionsTree($dir_ids[$k]['id']);
        for($j=0; $j < sizeof($directions_tree); $j++){
            //print_r($directions_tree);
            if($directions_tree[$j]['name'] == $direction_content[0]['name']){
                unset($dir_str);
                continue 2;
            }else{
                if($j == sizeof($directions_tree)-1){
                    $dir_str .= $directions_tree[$j]['name'];
                }else{
                    $dir_str .= $directions_tree[$j]['name']."->";
                }
            }
        }
            $directions[$dir_ids[$k]['id']] = $dir_str;

            
        unset($dir_str);
    }

    $form -> addElement('select', 'parent_direction_ID', _PARENTDIRECTION, $directions);  

    $form -> addElement('checkbox', 'active', _ACTIVEFEM);
    
    $form -> addElement('submit', 'submit_direction', _ADD, 'class = "flatButton"');

/*    if (isset($_GET['op']) && $_GET['op'] == 'change' && isset($id)) {
        $direction_content = eF_getTableData("directions", "*", "id=".$id);
        $form -> setDefaults(array('name' => $direction_content[0]['name'], 'active' => $direction_content[0]['active'],'parent_direction_ID' => $direction_content[0]['parent_direction_ID']));
    }else{
         $form -> setDefaults(array('active' => 1));    
    }*/
    
    if ($form -> isSubmitted()) {
        if ($form -> validate()) {
            if (isset($_GET['op']) && $_GET['op'] == 'change' && isset($id)) {
                $direction_content = array("name" => $form -> exportValue('name'),
                                            "parent_direction_ID" => $form -> exportValue('parent_direction_ID'),
                                            "active"  => $form -> exportValue('active'));

                if (eF_updateTableData("directions", $direction_content, "id=".$id)) {
                    $message      = _SUCCESFULLYUPDATEDDIRECTIONWINDOWCLOSE5SECONDS;
                    $message_type = 'success';
                } else {
                    $message      = _SOMEPROBLEMEMERGED;
                    $message_type = 'failure';
                }
            } elseif (isset($_GET['op']) && $_GET['op'] == 'insert') {
                $direction_content = array( "name"                  => $form -> exportValue('name'),
                                            "parent_direction_ID"   => $form -> exportValue('parent_direction_ID'),
                                            "active"                => $form -> exportValue('active'));

                if (eF_insertTableData("directions", $direction_content)) {
                    $message      = _SUCCESFULLYADDEDDIRECTIONWINDOWCLOSE5SECONDS;
                    $message_type = 'success';
                } else {
                    $message      = _SOMEPROBLEMEMERGED;
                    $message_type = 'failure';
                }
            }
        }
    }
    
    
    
    $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);

    $form -> setJsWarnings(_BEFOREJAVASCRIPTERROR, _AFTERJAVASCRIPTERROR);
    $form -> setRequiredNote(_REQUIREDNOTE);
    $form -> accept($renderer);

    $smarty -> assign('T_DIRECTIONS_FORM', $renderer -> toArray());  
    
    
}


$smarty -> assign("T_HEADER_CSS", eF_getCustomCss());
$smarty -> assign("T_HEADER_EDITOR", $load_editor);
$smarty -> assign("T_MESSAGE", $message);
$smarty -> assign("T_MESSAGE_TYPE", $message_type);

$smarty -> display("add_direction.tpl");

?>