<?php
/**
*
* @package efront
* @todo Incorporate changes from version 1
*/

abstract class EF_Question 
{
    public abstract function create($question);    
    public abstract function shuffle();
    public abstract function correct($answer_given);
}

class EF_MultipleOne extends EF_Question
{
    public function create($question) {
        $options = unserialize(urldecode($question['options']));//pr($options);
        foreach ($options as $option) {
            $choices[] = & HTML_QuickForm :: createElement('radio', 'q['.$question['id'].']', $option);
        }
        
        return $choices;
    }
    
    public function shuffle() {
    }
    
    public function correct($answer_given) {
    }
}

function eF_createQuestion($question) {
//pr($question);
    switch ($question['type']) {
        case 'multiple_one':
            $options = unserialize(urldecode($question['options']));//pr($options);
            foreach ($options as $option) {
                $choices[] = & HTML_QuickForm :: createElement('radio', 'q['.$question['id'].']', $option);
            }
            break;
        case 'multiple_many':
            $options = unserialize(urldecode($question['options']));//pr($options);
            foreach ($options as $option) {
                $choices[] = & HTML_QuickForm :: createElement('checkbox', 'q['.$question['id'].']', $option);
            }
            break;
        case 'match':
            $options = unserialize(urldecode($question['options']));//pr($options);
            foreach ($options as $option) {
                $choices[] = & HTML_QuickForm :: createElement('text', 'q['.$question['id'].']', $option);
            }
            break;
        case 'empty_spaces':
            $excerpts = explode("###", $question['text']);
            for ($i = 0; $i < sizeof($excerpts); $i++) {
                $choices[] = & HTML_QuickForm :: createElement('text', 'q['.$question['id'].']', $excerpts[$i]);
            }
            break;
        case 'true_false':
            $choices[] = & HTML_QuickForm :: createElement('radio', 'q['.$question['id'].']', _CORRECT);
            $choices[] = & HTML_QuickForm :: createElement('radio', 'q['.$question['id'].']', _WRONG);
            break;
        case 'raw_text':
            $choices[] = & HTML_QuickForm :: createElement('textarea', 'q['.$question['id'].']');
            break;
        default:
            break;
    }
    
    return $choices;
}

/**
* Prints a test question
*
* This function is used to print a test question. It is called by eF_printUnsolvedTest()
* for each of the questions included in a test.
*
* @param array $questions The questions array
* @param int $i The offset inside the questions array, denoting the question to print
* @param int $tests_ID The id of the test
* @param array $answer If the test questions appear one by one, then answer is an array, where each element contains
*                 the asnwered to the corresponding question (serialized).
* @return string The question HTML code
* @version 1.0
* @todo $i argument is useless, we may just pass $questions[$i]
*/
function eF_printTestQuestion($questions, $i, $tests_ID, $answer = false, $one_by_one = false)
{
    $data       = "";
    $id         = $questions[$i]['id'];
    $res0       = eF_getTableData("tests_to_questions","SUM(weight) AS all_weight","tests_ID=$tests_ID");
    $all_weight = $res0[0]['all_weight'];
    
    $res             = eF_getTableData("tests", "shuffle_answers", "id=$tests_ID");
    
    if($res[0]['shuffle_answers'] ==1 ){    
        $res_order = eF_getTableData("users_to_done_tests","tests_ID,answers_order","users_LOGIN='".$_SESSION['s_login']."' AND tests_ID=$tests_ID");
        $answers_order  = unserialize($res_order[0]['answers_order']);
    }

    if ($questions[$i]['type'] == "raw_text") {
        $data .= '<table width="100%"><tr><td class="questionWeight">
            <B>'._QUESTION.'&nbsp;'.($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.'&nbsp;'.eF_percent($questions[$i]['weight'] / $all_weight).')</td></tr><tr><td>'.$questions[$i]['text'].'</td></tr><tr><td>
            <textarea name="q['.$id.']" cols="80" rows="7">'.unserialize(urldecode($answer[$id])).'</textarea><br/>
            <a href = "send_file.php?tests_ID='.$tests_ID.'&q_ID='.$id.'" onClick = "eF_js_showDivPopup(\''._SENDFILEASANSWER.'\', new Array(\'400px\', \'150px\'))" target = "POPUP_FRAME">('._SENDFILEASANSWER.')</a></td></tr></table>';
    
    } elseif ($questions[$i]['type'] == "multiple_one") {
        if($answer[$id]) {
            $given_answer = unserialize(urldecode($answer[$id]));
        } else {
            $given_answer = 0;
        }
        $data   .= '
            <table width="100%">
                <tr><td class = "questionWeight"><B>'._QUESTION.'&nbsp;'. ($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.'&nbsp;'.eF_percent($questions[$i]['weight'] / $all_weight).')</td></tr>
                <tr><td>'.$questions[$i]['text'].'</td></tr>
                <tr><td>';                
        $options = unserialize($questions[$i]['options']);
        if($res[0]['shuffle_answers'] ==1 && $one_by_one == false){
            $dbase_order = $options;
            shuffle($options);
        }
        for ($k = 0; $k < sizeof($options); $k++) {
            $data .= '
                <input type = "radio" value = "'.$k.'" name="q['.$id.']"';
            if ($k == $given_answer) {
                $data .= ' checked';
            }
            $data .= '>&nbsp;'.$options[$k].'<br/>';
            if($res[0]['shuffle_answers'] ==1 && $one_by_one == false){
                $index = array_search($options[$k],$dbase_order);
                $array_index[] = $index;
            }
        }
        if($res[0]['shuffle_answers'] ==1 && $one_by_one == false){
            $answers_order[$questions[$i]['id']] = $array_index; 
        }        
        $data .= '</td></tr></table>';
    } elseif($questions[$i]['type'] == "multiple_many") {
        if($answer[$id]) {
            $given_answer = unserialize(urldecode($answer[$id]));
        } else {
            $given_answer = false;
        }
        $data .= '<table width="100%"><tr><td class="questionWeight">
            <B>'._QUESTION.'&nbsp;'. ($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.'&nbsp;'.eF_percent($questions[$i]['weight'] / $all_weight).')</td></tr><tr><td>'.$questions[$i]['text'].'</td></tr><tr><td>';
        $options = unserialize($questions[$i]['options']);
        if($res[0]['shuffle_answers'] ==1 && $one_by_one == false){
            $dbase_order = $options;
            shuffle($options); 
        }
        for ($k = 0; $k < sizeof($options); $k++) {
            $data .= '
                <input type="checkbox" value="'.$k.'" name="q['.$id.']['.$k.']"';
            if ($given_answer AND $given_answer[$k] == $k AND $given_answer[$k] != "") {
                $data .= ' checked';
            }
            $data .= '>&nbsp;'.$options[$k].'<BR>';
            if($res[0]['shuffle_answers'] ==1 && $one_by_one == false){
                $index = array_search($options[$k],$dbase_order);
                $array_index[] = $index;
            }
        }
        if($res[0]['shuffle_answers'] ==1 && $one_by_one == false){
            $answers_order[$questions[$i]['id']] = $array_index;
        }
        $data .= '</td></tr></table>';
    } elseif ($questions[$i]['type'] == "true_false") {
        if($answer[$id]) {
            $given_answer = unserialize(urldecode($answer[$id]));
        } else {
            $given_answer = 0;
        }
        $data   .= '<table width="100%"><tr><td class="questionWeight">
            <B>'._QUESTION.'&nbsp;'. ($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.'&nbsp;'.eF_percent($questions[$i]['weight'] / $all_weight).')</td></tr><tr><td>'.$questions[$i]['text'].'</td></tr><tr><td>';
            $data .= '
                <select name="q['.$id.']"><option value="1"';
            if ($given_answer == "1") {
                $data .= ' selected';
            }
            $data .= '>'._TRUE.'</option><option value="0"';
            if ($given_answer == "0") {
                $data .= ' selected';
            }            
            $data .= '>'._FALSE.'</option></select></td></tr></table>';            

    }elseif($questions[$i]['type'] == "match") {
        if($answer[$id]) {
            $given_answer = unserialize(urldecode($answer[$id]));
        } else {
            $given_answer = false;
        }
        $data .= '<table width="100%"><tr><td class="questionWeight">
            <B>'._QUESTION.'&nbsp;'. ($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.'&nbsp;'.eF_percent($questions[$i]['weight'] / $all_weight).')</td></tr><tr><td>'.$questions[$i]['text'].'</td></tr><tr><td>';
        $options1  = unserialize($questions[$i]['options']);
        $options2  = unserialize($questions[$i]['answer']);
        $rand_keys = array_rand($options2, sizeof($options2));
        $data     .= '
            <table>';
        
        for ($k = 0; $k < sizeof($options1); $k++) {
            $data .= '
                <tr><td align="left">'.($k+1).' - '.$options1[$k].'</td>
                    <td> <-> </td>
                    <td align="right">';
            $data .= '
                        <select name="q['.$id.']['.$k.']">';
            for ($j = 0; $j < sizeof($options1); $j++) {
                $data .= '
                            <option value="'.$options2[$rand_keys[$j]].'"';   //pleon, stelnoyme tim timi. allakse o tropos gia to recalculate. (prin itan $rand_keys[$j] )
                if ($given_answer) {
                    if ($given_answer[$k] == $options2[$rand_keys[$j]]) {   //pleon, stelnoyme tim timi. allakse o tropos gia to recalculate
                        $data .= ' selected';
                    }
                } elseif($j == $k) {
                    $data .= ' selected';
                }
                $data .= '>'.$options2[$rand_keys[$j]].'</option>';
            }
            $data .= '
                        </select>
                    </td></tr>';
        }
        $data .= '
            </table></td></tr></table>';
    } elseif ($questions[$i]['type'] == "empty_spaces") {
        $given_answer = unserialize(urldecode($answer[$id]));
        $j = 0;
        while (strstr($questions[$i]['text'], '###')) {
            $questions[$i]['text'] = preg_replace("'###'",'<input type="text" name="q['.$id.']['.$j.']" size="10" value="'.$given_answer[$j].'">',$questions[$i]['text'],1);
            $j++;
        }
        $data .= '<table width="100%"><tr><td class="questionWeight">
            <B>'._QUESTION.'&nbsp;'. ($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.'&nbsp;'.eF_percent($questions[$i]['weight'] / $all_weight).')</td></tr><tr><td>'.$questions[$i]['text'].'</td></tr></table>';
    }
    if($_SESSION['s_type'] == "student" && ($res[0]['shuffle_answers'] == 1)) {
        eF_updateTableData("users_to_done_tests", array('answers_order' => serialize($answers_order)),"users_LOGIN='".$_SESSION['s_login']."' AND tests_ID=".$tests_ID);
    }    
    return $data;
}


/**
* Prints a solved test
*
* This function prints a test that a student has already done, displaying all the student's answers
* along with the correct answers. If the test is redoale, then an option to redo the test is provided 
* to the student. 
*
* @param string $login The user that has done the test login name
* @param int $tests_ID The test id.
* @return string The html code corresponding to the solved test.
* @version 1.0
*/
function eF_printSolvedTest($login, $tests_ID)
{ 
    $res             = eF_getTableData("tests", "duration, content_ID, answers, given_answers, shuffle_questions, shuffle_answers, onebyone", "id=$tests_ID");
    $questions       = eF_getTestQuestionsForSolved($login, $tests_ID, $res[0]['shuffle_questions']);  
    $duration        = $res[0]['duration'];
    $answers         = $res[0]['answers'];  //new... an tha emfanizontai oi sostes apantiseis...
    $show_given_answers = $res[0]['given_answers'];
    $shuffle_answers = $res[0]['shuffle_answers'];
    $onebyone        = $res[0]['onebyone'];
    $res0            = eF_getTableData("content", "lessons_ID", "id=".$res[0]['content_ID']);
    $lessons_ID      = $res0[0]['lessons_ID'];
    $res             = eF_getTableData("questions, tests_to_questions, done_questions AS d_q, done_tests AS d_t", "COUNT(questions.id) AS text_questions", "questions.type='raw_text' AND tests_to_questions.tests_ID=$tests_ID AND tests_to_questions.questions_ID=questions.id AND d_q.score=-1 AND d_q.questions_ID=questions.id AND d_t.id=d_q.done_tests_ID AND d_t.users_LOGIN='$login'");
    //$res             = eF_getTableData("questions as q, done_questions AS d_q, done_tests AS d_t", "COUNT(questions.id) AS text_questions", "d_q.done_tests_ID=d_t.id and d_q.questions_ID=q.id and q.type='raw_text' and d_t.users_LOGIN='student2' and d_t.tests_ID=35");
    $text_questions  = $res[0]['text_questions'];
    $count_questions = sizeof($questions);
    $res             = eF_getTableData("done_tests", "id, timestamp, score, duration", "tests_ID=$tests_ID AND users_LOGIN='$login'");
    $done_tests_ID   = $res[0]['id'];
    $score           = $res[0]['score'];
    $res0            = eF_getTableData("tests_to_questions", "SUM(weight) AS all_weight", "tests_ID=$tests_ID");
    $all_weight      = $res0[0]['all_weight'];

    /*$data = "<table width=\"100%\" border = \"0\" valign = \"top\">
            <tr><td align =\"left\">
                    <img src = \"images/32x32/edit.png\" width = \"32\" height = \"32\" title = "._SOLVEDTESTS."><hr/>
                 </td><tr><td>"; 
*/
$youdiditin = eF_convertIntervalToTime($res[0]['duration']);
$maxduration = eF_convertIntervalToTime($duration);
//print_r($duration);
    $data .="<table width=\"100%\" border = \"0\" valign = \"top\">
            <tr><td align =\"left\">
                    <img src = \"images/32x32/desktop.png\"  title = "._SOLVEDTESTS." alt = "._SOLVEDTESTS."></td><td align =\"left\">"._TESTHADAT." ".eF_timestampToDate($res[0]['timestamp']).".<BR>";
    $data .= _HASMAXIMUMDURATION." ";
    $data .= ($maxduration['hours'] != 0) ? $maxduration['hours']."&nbsp;"._HOURS."&nbsp;" : " ";
    $data .= "&nbsp;".$maxduration['minutes']."&nbsp;"._MINUTES." "._ANDYOUDIDITIN." ";
    if($res[0]['duration'] >= $duration){
        $data .= ($maxduration['hours'] != 0) ? $maxduration['hours']."&nbsp;"._HOURS."&nbsp;" : " ";
        $data .= "&nbsp;".$maxduration['minutes']."&nbsp;"._MINUTES."<BR>";
    }else{
        $data .= ($youdiditin['hours'] != 0) ? $youdiditin['hours']."&nbsp;"._HOURS."&nbsp;" : " ";
        $data .= ($youdiditin['minutes'] != 0) ? $youdiditin['minutes']."&nbsp;"._MINUTES."&nbsp;" : " ";
        $data .= "&nbsp;".$youdiditin['seconds']."&nbsp;"._SECONDS."<BR>";
    }
    if ($show_given_answers ==1 || $_SESSION['s_type'] == "professor") {
        $data .= _YOURSCOREIS." <b>".eF_percent($score)."</b>.<BR>";
        if ($text_questions > 0) {
            $data .= _FINALSCOREWILLBEFROM." ".eF_percent($score)." "._TO." ".eF_percent($score + $text_questions / $count_questions).", "._DEPENDSONQUESTIONS."<BR>";
        }
    }
    //makriria lines ....
    $res = eF_getTableData("users_to_done_tests","tests_ID,times,answers_order","users_LOGIN='$login' AND tests_ID=".$tests_ID);
    $answers_order = unserialize($res[0]['answers_order']);
    $res0 = eF_getTableData("tests", "redoable, content_ID, description", "id=$tests_ID");    
    ($res0[0]['redoable'] == 0) ? $redoable = 1000000 : $redoable = $res0[0]['redoable'];   

    if ($redoable > $res[0]['times'] && $_SESSION['s_type'] == 'student') {
        $data .= '
            <br/><b><a href="/student.php?ctg=tests&view_unit='.$res0[0]['content_ID'].'&redo_tests_ID='.$tests_ID.'">'._WANTTOREDOTEST.'</a></b>';
        if($res0[0]['redoable'] != 0) { 
            $data .= ' <b>(<font color="red">'._YOUCANDOTEST.' '.($redoable-$res[0]['times']).' '._TIMESMORE.'</font>)</b>';  
        }
    
    }
    // ...makriria lines

    
    $data .= '</td></tr></table><table width = "100%"><tr><td class = "horizontalSeparator"></td></tr></table><br/>';
    
    if($res0[0]['description'] != "") { 
        $data .= '<br/><div class = "horizontalSeparator" >'.html_entity_decode($res0[0]['description'], ENT_QUOTES).'</div><br/>'; 
    }

//pr(eF_createQuestion($questions[2]));
//pr($questions);
  if ($show_given_answers ==1 || $_SESSION['s_type'] == "professor") { 
    for ($i = 0; $i < sizeof($questions); $i++) {
        $id   = $questions[$i]['id'];
        $res  = eF_getTableData("done_questions","answer,score","questions_ID=$id AND done_tests_ID=$done_tests_ID");
        $res1 = eF_getTableData("tests_to_questions","weight","questions_ID=$id AND tests_ID=$tests_ID");
        
        $q_weight     = $res1[0]['weight'];
        $answer_given = unserialize($res[0]['answer']);
        $score        = $res[0]['score'];
        $right_answer = $questions[$i]['answer'];
        $explanation = $questions[$i]['explanation'];
        unset($options_reorder);  
        unset($question_order); 
        
        if ($questions[$i]['type'] == "raw_text") {
            //$filename = strrev(mb_substr(strrchr(strrev(mb_substr(stristr($answer_given, '<:file:'), 7)), '>'), 1));
            //if ($filename) {
            //    $answer_given = str_replace("<:file:$filename>","",$answer_given).' ['._FILEUPLOADED.': <a href="'.G_LESSONSLINK.$lessons_ID.'/Students/'.$login.'/Tests/'.$filename.'" class="small" target="_blank">'.mb_substr(strstr(strstr($filename,$id),"_"),1).'</a>]';
            //}
            $answer_given = preg_replace("/<:file:>/", "<br/><br/>", $answer_given);
            $answer_given = preg_replace("/<:elif:>/", "", $answer_given);
            
          /*  $data .= '
                <B>['.($i+1).']</b>&nbsp;'.$questions[$i]['text'].'<br/>
                <font color = "red">&nbsp;&nbsp;&nbsp;'._YOUANSWERED.': '.$answer_given.'</font>
                <br/><font color = "green">&nbsp;&nbsp;&nbsp;'._EXAMPLEANSWER.': '.$right_answer.'</font>';  */
           $data .= '<table width="100%"><tr><td class="questionWeight">
                <B>'._QUESTION.'&nbsp;'.($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight).')</td></tr><tr><td>'.$questions[$i]['text'].'</td></tr><tr><td>
                <font color = "red">&nbsp;&nbsp;&nbsp;'._YOUANSWERED.': '.$answer_given.'</font></td></tr><tr><td>';
            if($answers == 1) {
                $data .= '<font color = "green">&nbsp;&nbsp;&nbsp;'._EXAMPLEANSWER.': '.$right_answer.'</font></td></tr><tr><td>';
                if($explanation != ""){
                    $data .= '&nbsp;&nbsp;&nbsp;<span class="questionExplanation">'._EXPLANATION.': '.$explanation.'</span></td></tr><tr><td>';     
                }
            }
            if ($score == -1) {
                $data .= "
                    <br/>&nbsp;&nbsp;&nbsp;"._SCORE.": <B>"._THISQUESTIONCORRECTEDPROFESSOR."</B>";
            } else {
                $title_message = _PERCENTCORRECT.":".eF_percent($score)." * "._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight)." = ".eF_percent(($score * $q_weight) / $all_weight);
             $question_score = eF_percent(($score * $q_weight) / $all_weight);
                        $data .= "<br/>&nbsp;&nbsp;&nbsp;"._SCORE.":<b>".$question_score."</b>&nbsp;<img src=\"images/16x16/about.png\" title='".$title_message."' alt='".$title_message."'>";
            }
            $data .='</td></tr></table>';
        } elseif($questions[$i]['type'] == "multiple_one") {
  
            $options = unserialize($questions[$i]['options']);            
            $right_answer = unserialize($right_answer);
            $right_answer = $right_answer[0] + 1;
            
            if ($shuffle_answers == 1 && $onebyone == 0){ 
                $question_order = $answers_order[$id];            //takes the mapping array from db
                for ($l = 0; $l < sizeof($options); $l++) {
                    $options_reorder[$l] = $options[$question_order[$l]];   //reorders options
                }
                $options   = $options_reorder ; 
//print_r($options); 
                $temp =$right_answer-1;
                $temp  =array_search($temp, $question_order);     //maps correct answer's options with reordered array
                $right_answer = $temp+1;           
            
            }            


            $data .= '<table width="100%"><tr><td class="questionWeight"><table><tr><td>';
            if($answers == 1){  
                if (((unserialize($answer_given) + 1)) == $right_answer) {
                    $data .= "<img src=\"images/16x16/check.png\" title='"._RIGHTANSWER."' alt='"._RIGHTANSWER."'></td>";
                }else {
                    $data .= "<img src=\"images/16x16/delete.png\" title='"._FALSEANSWER."' alt='"._FALSEANSWER."'></td>"; 
                }
             
             } 
            
            $data   .= '<td valign="center">
                 <B>'._QUESTION.'&nbsp;'.($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight).')</td></tr></table></td></tr><tr><td>'.$questions[$i]['text'].'</td></tr><tr><td>';

            
            for ($k = 0; $k < sizeof($options); $k++) {
                $data .= '&nbsp;&nbsp;'.($k+1).'&nbsp;'.$options[$k].'<BR>';
            }
                
             $data .= "
                <font color=red>&nbsp;&nbsp;&nbsp;"._YOUANSWERED.": ".(unserialize($answer_given) + 1)."</font>
                </td></tr><tr><td>";
                
             if($answers == 1){
                $data .= "<font color=green>&nbsp;&nbsp;&nbsp;"._RIGHTANSWER.": ".$right_answer."</font></td></tr><tr><td>";           
                if($explanation != ""){
                    $data .= '<br/>&nbsp;&nbsp;&nbsp;<span class="questionExplanation">'._EXPLANATION.': '.$explanation.'</span></td></tr><tr><td>';        
                }
             }  
            
                $title_message = _PERCENTCORRECT.":".eF_percent($score)." * "._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight)." = ".eF_percent(($score * $q_weight) / $all_weight);
             $question_score = eF_percent(($score * $q_weight) / $all_weight);
                        $data .= "<br/>&nbsp;&nbsp;&nbsp;"._SCORE.":<b>".$question_score."</b>&nbsp;<img src=\"images/16x16/about.png\" title='".$title_message."' alt='".$title_message."'></td></tr></table>";
             
        } elseif ($questions[$i]['type'] == "multiple_many") {
            unset($temp_array);
            
            if ($answer_given) {
                $answer_given = unserialize($answer_given);
                foreach ($answer_given AS $key => $value) {
                    $temp_array[] = $value + 1;
                }
                $str_answer_given = implode(", ", $temp_array);
            }

            if ($right_answer) {
                $right_answer     = array_keys(unserialize($right_answer));
                array_walk($right_answer, create_function('&$v,$k', '$v = $v+1;'));     //Increment by 1 the right answers, because they are in the range 0:n-1 and we need them in the range 1:n (where n the numner of answers)
                $str_right_answer = implode(", ", $right_answer);
            }

            $options = unserialize($questions[$i]['options']);
            if($shuffle_answers == 1 && $onebyone == 0){ 
                $question_order = $answers_order[$id];            //takes the mapping array from db
                for ($l = 0; $l < sizeof($options); $l++) {
                    $options_reorder[$l] = $options[$question_order[$l]];   //reorders options
                }
                $options   = $options_reorder ; 

                $right_answer_temp="";
                foreach($right_answer as $key => $value){
                    $temp  = $value-1;
                    $temp  = array_search($temp, $question_order);   //maps correct answer's options with reordered array
                    $right_answer_temp[$key] = $temp+1; 
                
                }
                    $right_answer = $right_answer_temp;
                    $str_right_answer = implode(", ", $right_answer);
            }
            
            $data .= '<table width="100%"><tr><td class="questionWeight"><table><tr><td>';
            if($answers == 1) {  
                
                if ($str_answer_given == $str_right_answer) {
                    $data .= "<img src=\"images/16x16/check.png\" title='"._RIGHTANSWER."' alt='"._RIGHTANSWER."'></td>";
                }else {
                    $data .= "<img src=\"images/16x16/delete.png\" title='"._FALSEANSWER."' alt='"._FALSEANSWER."'></td>"; 
                }
             }
                        
            $data .= '<td valign="center">
                <B>'._QUESTION.'&nbsp;'.($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight).')</td></tr></table></td></tr><tr><td>'.$questions[$i]['text'].'</td></tr><tr><td>';
            
            for ($k = 0; $k < sizeof($options); $k++) {
                $data .= '&nbsp;&nbsp;'.($k+1).'&nbsp;'.$options[$k].'<BR>';
            }
                
             $data .= "
                <font color=red>&nbsp;&nbsp;&nbsp;"._YOUANSWERED.": ".$str_answer_given."</font>
                </td></tr><tr><td>";
             if($answers == 1) {  
                $data .= "<font color=green>&nbsp;&nbsp;&nbsp;"._RIGHTANSWER.": ".$str_right_answer."</font></td></tr><tr><td>";
                if($explanation != ""){
                    $data .= '&nbsp;&nbsp;&nbsp;<span class="questionExplanation">'._EXPLANATION.': '.$explanation.'</span></td></tr><tr><td>';     
                }
             }
             $title_message = _PERCENTCORRECT.":".eF_percent($score)." * "._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight)." = ".eF_percent(($score * $q_weight) / $all_weight);
             $question_score = eF_percent(($score * $q_weight) / $all_weight);
            $data .= "<br/>&nbsp;&nbsp;&nbsp;"._SCORE.":<b>".$question_score."</b>&nbsp;<img src=\"images/16x16/about.png\" title='".$title_message."' alt='".$title_message."'></td></tr></table>";
             
        } elseif($questions[$i]['type'] == "true_false") {
  
            //$options = unserialize($questions[$i]['options']);            
            $right_answer = unserialize($right_answer);
            //$right_answer = $right_answer;
            $answer_given = unserialize($answer_given);
            //$answer_given = $answer_given[0];  

             $data .= '<table width="100%"><tr><td class="questionWeight"><table><tr><td>';
            if ($answers == 1) {  
                if ($answer_given  == $right_answer) {
                    $data .= "<img src=\"images/16x16/check.png\" title='"._RIGHTANSWER."' alt='"._RIGHTANSWER."'></td>";
                }else {
                    $data .= "<img src=\"images/16x16/delete.png\" title='"._FALSEANSWER."' alt='"._FALSEANSWER."'></td>"; 
                }
             } 
            
            $data .= '<td valign="center">
                <B>'._QUESTION.'&nbsp;'.($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight).')</td></tr></table></td></tr><tr><td>'.$questions[$i]['text'].'</td></tr><tr><td>';

            if($answer_given == "1"){
                $display_answer_given = _TRUE;
            }else{
                $display_answer_given = _FALSE; 
            }
            if($right_answer == "1"){
                $display_right_answer = _TRUE;
            }else{
                $display_right_answer = _FALSE; 
            }
                
             $data .= "
                <font color=red>&nbsp;&nbsp;&nbsp;"._YOUANSWERED.": ".$display_answer_given."</font></td></tr><tr><td>";
                
             if($answers == 1){
                $data .= "<font color=green>&nbsp;&nbsp;&nbsp;"._RIGHTANSWER.": ".$display_right_answer."</font></td></tr><tr><td>";           
                if($explanation != ""){
                    $data .= '<br/>&nbsp;&nbsp;&nbsp;<span class="questionExplanation">'._EXPLANATION.': '.$explanation.'</span></td></tr><tr><td>';        
                }
             }  
            
                $title_message = _PERCENTCORRECT.":".eF_percent($score)." * "._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight)." = ".eF_percent(($score * $q_weight) / $all_weight);
             $question_score = eF_percent(($score * $q_weight) / $all_weight);
             $data .= "<br/>&nbsp;&nbsp;&nbsp;"._SCORE.":<b>".$question_score."</b>&nbsp;<img src=\"images/16x16/about.png\" title='".$title_message."' alt='".$title_message."'></td></tr></table>";
             
        }elseif($questions[$i]['type'] == "match") {
            //$data .= '<B>['.($i+1).']</b>&nbsp;'.$questions[$i]['text'].'<BR>';
            $options1 = unserialize($questions[$i]['options']);
            $options2 = unserialize($questions[$i]['answer']);
            $answer_given = unserialize($answer_given);
            
            if($answers ==1) {
              
            $right_counter=0;
                for ($k = 0; $k < sizeof($options1); $k++) {
                    if($answer_given[$k] == $options2[$k]){
                        $right_counter++; 
                    }
                
                }
                 $data .= '<table width="100%"><tr><td class="questionWeight"><table><tr><td>';
                if ($right_counter == sizeof($options1)) {
                    $data .= "<img src=\"images/16x16/check.png\" title='"._RIGHTANSWER."' alt='"._RIGHTANSWER."'></td>";
                }else {
                    $data .= "<img src=\"images/16x16/delete.png\"  title='"._FALSEANSWER."' alt='"._FALSEANSWER."'></td>"; 
                }

              
              
            $data .= '<td valign="center">
                <B>'._QUESTION.'&nbsp;'.($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight).')</td></tr></table></td></tr><tr><td>'.$questions[$i]['text'].'</td></tr><tr><td>';
              
              
                $data .= '
                    <table>
                        <tr><td colspan="3" align="center"><font color=red>'._YOUANSWERED.'</font></td>
                            <td>&nbsp;&nbsp;&nbsp;</td>
                            <td colspan="3" align="center"><font color=green>'._RIGHTANSWER.'</font></td></tr>';
            
                for ($k = 0; $k < sizeof($options1); $k++) {
                    $data .= '
                        <tr><td align="left">&nbsp;'.$options1[$k].'</td><td> <-> </td>
                            <td align="right"><font color=red>'.$answer_given[$k].'</font></td>
                            <td></td>
                            <td align="left">&nbsp;'.$options1[$k].'</td>
                            <td> <-> </td>
                            <td align="right"><font color=green>'.$options2[$k].'</font></td></tr>';                
                }
                
                $data .= '</table>';
                if($explanation != ""){
                    $data .= '&nbsp;&nbsp;&nbsp;<span class="questionExplanation">'._EXPLANATION.': '.$explanation.'</span></td></tr><tr><td>';     
                }    
            
            } elseif($answers ==0) {
               $data .= '<B>['.($i+1).']</b>&nbsp;'.$questions[$i]['text'].'<BR>';  
              
                $data .= '
                    <table>
                        <tr><td colspan="3" align="center"><font color=red>'._YOUANSWERED.'</font></td></tr>';
                for ($k = 0; $k < sizeof($options1); $k++) {
                    $data .= '
                        <tr><td align="left">&nbsp;'.$options1[$k].'</td><td> <-> </td>
                            <td align="right"><font color=red>'.$answer_given[$k].'</font></td>
                        </tr>';
                }
              
            }
            $data .='</td></tr><tr><td>';
            $title_message = _PERCENTCORRECT.":".eF_percent($score)." * "._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight)." = ".eF_percent(($score * $q_weight) / $all_weight);
            $question_score = eF_percent(($score * $q_weight) / $all_weight);
            $data .= "&nbsp;&nbsp;&nbsp;"._SCORE.":<b>".$question_score."</b>&nbsp;<img src=\"images/16x16/about.png\" title='".$title_message."' alt='".$title_message."'>
            </td></tr></table>";
        
        } elseif($questions[$i]['type'] == "empty_spaces") {
            $answer_given = unserialize($answer_given);
            $right_answer = unserialize($right_answer);
            $answer_given_text = $questions[$i]['text'];
            $right_answer_text = $questions[$i]['text'];
            $j = 0;
            while (strstr($answer_given_text, '###')) {
                $answer_given_text = preg_replace("'###'",'<b><font color=red>'.$answer_given[$j].'</font></b>',$answer_given_text,1);
                $j++;
            }
            $j = 0;
            while (strstr($right_answer_text, '###')) {
                $right_answer_text = preg_replace("'###'",'<b><font color=green>'.$right_answer[$j].'</font></b>',$right_answer_text,1);
                $j++;
            }            

          $data .= '<table width="100%"><tr><td class="questionWeight"><table><tr><td>';
            if($answers == 1) {
            
                $right_counter=0;
                for ($k = 0; $k < sizeof($right_answer); $k++) {
                    if($right_answer[$k] == $answer_given[$k]){
                        $right_counter++; 
                    }
                }
                if ($right_counter == sizeof($right_answer)) {
                        $data .= "<img src=\"images/16x16/check.png\" title='"._RIGHTANSWER."' alt='"._RIGHTANSWER."'>";
                }else {
                        $data .= "<img src=\"images/16x16/delete.png\" title='"._FALSEANSWER."' alt='"._FALSEANSWER."'>"; 
                }
            }
        
        
         $data .= '</td><td align="center">
                 <B>'._QUESTION.'&nbsp;'.($i+1).'</b>&nbsp;&nbsp;('._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight).')</td></tr></table></td></tr><tr><td><font color=red>'._YOUANSWERED.'</font></td></tr><tr><td>'.$answer_given_text.'</td></tr><tr><td>';
        if($answers == 1) {
            $data .= "<font color=green>"._RIGHTANSWER."</font></td></tr><tr><td>&nbsp;&nbsp;&nbsp;".$right_answer_text."</td></tr><tr><td>";
            if($explanation != ""){
                $data .= '&nbsp;&nbsp;&nbsp;<span class="questionExplanation">'._EXPLANATION.': '.$explanation.'<br/></span></td></tr><tr><td>';        
            }
        }      
             $title_message = _PERCENTCORRECT.":".eF_percent($score)." * "._WEIGHT.":".sprintf("%.2f", $q_weight / $all_weight)." = ".eF_percent(($score * $q_weight) / $all_weight);
             $question_score = eF_percent(($score * $q_weight) / $all_weight);
                        $data .= "<br/>&nbsp;&nbsp;&nbsp;"._SCORE.":<b>".$question_score."</b>&nbsp;<img src=\"images/16x16/about.png\" title='".$title_message."' alt='".$title_message."'></td></tr></table>";
        }
        if ($i < sizeof($questions) - 1) {
            $data .= "<br/>";
        }
    }
    //$data .= "</td></tr></table>";
  }
    return $data;
}


/**
* Prints an unsolved test
*
* This function prints the test that a student has asked to solve. 
*
* @param int $tests_ID The id of the test
* @param string $formaction The action of the form
* @param int $question_num The number of the question to display (effective only if questions are shown one by one)
* @param int $time_start The timestamp corresponding to the time the student started the test
* @param array $answer If the test questions appear one by one, then answer is an array, where each element contains
*                 the asnwered to the corresponding question (serialized).
* @param array $q The student answer to this question.
* @param bool $goback If the student asked to move to the previous question
* @param bool $must_submit If the test must be submitted (The time is up)
* from 16/3/2007 it calls  eF_getTestQuestions to get questions of test in correct order
*/

function eF_printUnsolvedTest($tests_ID, $formaction = "", $question_num = false, $time_start = false, $answer = false, $q = false, $goback = false, $must_submit = false, $gonext = false)
{
    srand ((float) microtime() * 1000000);
 
    $res = eF_getTableData("tests", "content_ID,duration,onebyone,description,shuffle_questions", "id=$tests_ID");
    
    $questions = eF_getTestQuestions($tests_ID);
    //$questions = eF_getTableData("questions, tests_to_questions", "questions.*,tests_to_questions.weight AS weight", "tests_to_questions.tests_ID=$tests_ID AND tests_to_questions.questions_ID=questions.id","questions.content_ID, questions.id ASC");

    if ($res[0]['shuffle_questions']) {
        foreach ($questions as $value) {
            $temp[$value['id']] = $value;
        }
        if (!$_POST['questions_order']) {
            shuffle($questions); 
        } else {
            $questions_order = unserialize(urldecode($_POST['questions_order']));//echo "@@";pr($questions);echo "%%";

            foreach ($questions_order as $value) {
                $temp2[] = $temp[$value];
            }
            $questions = $temp2;
        }

        for ($j = 0; $j < sizeof($questions); $j++){
            $questions_to_done_tests_order[] = $questions[$j]['id'];
        }
        $questions_order_serialized = serialize($questions_to_done_tests_order);
    }


    if($_SESSION['s_type'] == "student") { //save display order of questions
        
        $res_to = eF_getTableData("users_to_done_tests","tests_ID,times","users_LOGIN='".$_SESSION['s_login']."' AND tests_ID=$tests_ID");
         if (sizeof($res_to) == 0 ) {
            eF_insertTableData("users_to_done_tests", array('questions_order' => serialize($questions_to_done_tests_order),'users_LOGIN' => $_SESSION['s_login'],'tests_ID' =>$tests_ID)); 
        } else {
            eF_updateTableData("users_to_done_tests", array('questions_order' => serialize($questions_to_done_tests_order),'answers_order' => ""),"users_LOGIN='".$_SESSION['s_login']."' AND tests_ID=".$tests_ID); 
        }
    
    }   
    $res1 = eF_getTableData("content","name","id=".$res[0]['content_ID']);
       
    $data .= '
        <br/>
        <form action = "'.$formaction.'" method = "post" name = "form_test">';
    if ($res[0]['shuffle_questions']) {
        $data .= '<input type = "hidden" name = "questions_order" value = "'.urlencode($questions_order_serialized).'" />';
    }
    $data .= '<table border = "0" width = "100%">
            <tr><td>
                    <table>
                        <tr><td><img src = "images/32x32/desktop.png"  title = '._UNSOLVEDTESTS.' alt = '._UNSOLVEDTESTS.'></td>
                            <td><span class="test_title">'.$res1[0]['name'].'</span><br/><br/> '._TESTSHOULDCOMPLETEIN.' <b>'.($res[0]['duration']/60).'</b> '._MINUTES.'.</td></tr>
                    </table>';
    if(!$time_start) {     
        $seconds_left = $res[0]['duration'];
    } else {
        $seconds_left = $res[0]['duration'] - (time() - $time_start);
    }
    $data .= '
            </td><td align = "right" valign = "bottom">
                <img  style = "position:relative; top: 8px;" src = "images/32x32/stopwatch.png" title="'._TIMELEFT.'" alt="'._TIMELEFT.'">'.eF_timer($seconds_left).'
            </td></tr>';
    if ($res[0]['onebyone'] == 1) {
        $data .= '
            <tr><td>'._TOTALQUESTIONNUMBER.': <b>'.sizeof($questions).'</b></td></tr>';
    }
    $data .= '
        </table>
        <table width = "100%">
            <tr><td class = "horizontalSeparator"></td></tr>
        </table><br/>';
    if($res[0]['description'] != "") { 
        $data .= '<br/><div class = "horizontalSeparator" >'.html_entity_decode($res[0]['description'], ENT_QUOTES).'</div><br/>'; 
    }
    
    
    
    if ($res[0]['onebyone'] == 0) {
        for ($i = 0; $i < sizeof($questions); $i++) {
            $data .= eF_printTestQuestion($questions, $i, $tests_ID);
            if ($i < sizeof($questions) - 1) {
                $data .= "<br/>";
            }
        }
        $data .= '
            <input type = "hidden" name = "tests_ID" value = "'.$tests_ID.'">
            <input type = "hidden" name = "time_start" value = "'.$time_start.'">
            <input type = "hidden" name = "submit_test_done" value = ""><br/>
            <input class = "flatButton" type = "submit" name = "submit_test" value = "'._SENDTEST.'">';
    } else {
        if ($goback == true) {
            $show_question_num = $question_num - 2;
        } else {
            $show_question_num = $question_num;
        }
        if($gonext == true)
            $show_question_num = $question_num;

        if ($question_num == false) {
            $question_num      = 0;
            $show_question_num = 0;
        }
        
        $data .= eF_printTestQuestion($questions, $show_question_num, $tests_ID, $answer, true);
        
        if ($answer) {
            foreach ($answer AS $q_id => $q_answer) {
                $data .= '
                <input type="hidden" name="answer['.$q_id.']" value="'.$q_answer.'">';
            }
        }
        if($question_num>0) {
            $data .= '
                <input type="hidden" name="answer['.$questions[$question_num-1]['id'].']" value="'.urlencode(serialize($q[$questions[$question_num - 1]['id']])).'">';
        }
        
        $questions_to_test = eF_getTableData("tests_to_questions","tests_ID,questions_ID","tests_ID=".$tests_ID);
        $data .= '
            <input type = "hidden" name = "question_num" value = "'.($show_question_num+1).'">
            <input type = "hidden" name = "tests_ID" value = "'.$tests_ID.'">
            <input type = "hidden" name = "time_start" value = "'.$time_start.'">
            <input type = "hidden" name = "submit_test_done" value = "">
            <input type = "hidden" name = "submit_test_partial" value = "true"><br/><br/>';

        if ($show_question_num != 0) {
            $data .= '
                <input class = "flatButton" type="submit" name="submit_previous_question" value="&nbsp;&larr;'._PREVIOUSQUESTION.'" style = "vertical-align:middle">';
        }
        
//        $data .= '&nbsp;&nbsp;<select name="questnum" style = "vertical-align:middle">';
//        for ($i = 1 ; $i <= sizeof($questions_to_test) ; $i++) {
//            $data .='<option value="'.$i.'" '.($show_question_num == $i - 1 ? "selected" : "").'>'.$i.'</option>';
//        }
//        $data .= '</select><input type = "image" name = "goto_question" value = "goto_question" src = "images/16x16/arrow_right_blue.png" style = "vertical-align:middle" title = "'._GOTOQUESTION.'" alt = "'._GOTOQUESTION.'"/>&nbsp;&nbsp;';

        if ($show_question_num != sizeof($questions) - 1) {
            $data .= '
                <input class = "flatButton" type="submit" name="submit_test_question" value="'._NEXTQUESTION.'&nbsp;&rarr;" style = "vertical-align:middle">';
        }
        $data .= '
            <br/><br/><br/><input class = "flatButton" type="submit" name="submit_test" value="'._SENDTEST.'">';
    }
    
    if ($must_submit) {
        $data .= '
            <script language="Javascript">document.form_test.submit_test_done.value = "true"; document.form_test.submit(); alert("'._YOURTIMEISUP.'!");</script>';
    }
        
    $data .= '
        </form>';
    //$data .= "</td></tr></table>";
    return $data;
}

/**
* Delete test question
*
* This function deletes a test question from all the database tables 
* that it may be associated with
*
* @param int $question_id The question id
* @return bool true if everything is ok
* @version 1.0
* @since 3.0
* @author Periklis Venakis <pvenakis@efront.gr>
*/
function eF_deleteTestQuestion($question_id) {
    eF_deleteTableData("done_questions", "questions_ID=".$question_id);
    eF_deleteTableData("tests_to_questions", "questions_ID=".$question_id);
    eF_deleteTableData("questions", "id=".$question_id);
    
    return true;
}

?>