{* Smarty template for chat_room_options.php *}

{if $T_MESSAGE_TYPE == 'success'}
    <script>
        re = /\?/;
        !re.test(parent.location) ? parent.location = parent.location+'?message={$T_MESSAGE}&message_type={$T_MESSAGE_TYPE}' : parent.location = parent.location+'&message={$T_MESSAGE}&message_type={$T_MESSAGE_TYPE}';            
    </script>
{/if}

{include file = "includes/header.tpl"}          {*The inclusion is put here instead of the beginning in order to speed up reloading, in case of success*}

{if $T_MESSAGE}
        {eF_template_printMessage message = $T_MESSAGE type = $T_MESSAGE_TYPE}    
{/if}
                             

{if $smarty.post.chat_room_submit}
    {if $T_MESSAGE_TYPE == 'success'}
        {eF_template_printCloseButton reload = true}
        <meta http-equiv = "refresh" content = "5;url=chat_room_options.php?close=true">
    {else}
        {eF_template_printBackButton}
    {/if}
{else}


    {if $smarty.get.new_public_room || $smarty.get.new_private_room}
        <form name = "new_room_form" method = "post" action = "">
        <table>
            <tr><td> {$smarty.const._ROOMNAME}:</td>
                <td>&nbsp;<input type = "text" name = "chat_room_name" /></td></tr>
            <tr><td> {$smarty.const._ACTIVENEUTRAL}:</td>
                <td>&nbsp;<input type = "checkbox" name = "chat_room_active" /></td></tr>
            <tr><td colspan = "2" align = "center">&nbsp;<input class = "flatButton" type = "submit" name = "chat_room_submit" value = "{$smarty.const._CREATE}"/></td></tr>
        </table>
        <input type = "hidden" name = "chat_room_type" value = "{$T_ROOM_TYPE}" />
        </form>
    {/if}

    {if $smarty.get.past_messages}
        <form name = "chat_show_messages_form" method = "post" action = "">
        <table>
            <tr><td>{$smarty.const._SHOWCONVERSATIONSFORROOM}:</td>
                <td><select name = "select_chat_room">
        {section name = 'chatroom_list' loop = $T_CHATROOMS}
                        <option value = "{$T_CHATROOMS[chatroom_list].id}" {if $smarty.post.select_chat_room == $T_CHATROOMS[chatroom_list].id}selected{/if}>{$T_CHATROOMS[chatroom_list].name}</option>
        {/section}
                    </select>
            </td></tr>
            <tr><td>{$smarty.const._FROM}</td>
                <td>{eF_template_html_select_date prefix="from_date_" time = $T_DAY_BEFORE start_year="-2" field_order = 'YDM'}, {html_select_time prefix="from_time_"}</td>
            <tr><td>{$smarty.const._TOCAPITAL}</td>
                <td>{eF_template_html_select_date prefix="to_date_" start_year="-2" field_order = 'YDM'}, {html_select_time prefix="to_time_"}
            </td></tr>
            <tr><td>{$smarty.const._ANDTHEMESSAGESOFUSER}:</td>
                <td><select name = "select_user">
                        <option value = "0">{$smarty.const._ALLUSERS}</option>
                        {eF_template_printUsersList data = $T_USERS selected = $smarty.post.select_user}
                    </select>
            </td></tr>        
            <tr><td>&nbsp;</td></tr>
            <tr><td colspan = "2" align = "center"><input class = "flatButton" type = "submit" name = "chat_submit_show_messages" value = "{$smarty.const._SHOW}" /></td></tr>        
        </table>
        </form>
    {/if}

    {if $smarty.post.chat_submit_show_messages}
        <table border = "0" align = "center">

        {foreach name = 'messages_list' item = 'message' from = $T_MESSAGES}
            {if $message.users_LOGIN == $smarty.session.s_login}
                {assign var = 'span_class' value = 'chatMyMessages'}
            {elseif $message.users_USER_TYPE == 'student'}
                {assign var = 'span_class' value = 'chatStudentMessages'}
            {elseif $message.users_USER_TYPE == 'professor'}
                {assign var = 'span_class' value = 'chatProfessorMessages'}
            {elseif $message.users_USER_TYPE == 'administrator'}
                {assign var = 'span_class' value = 'chatAdministratorMessages'}
            {else}
                {assign var = 'span_class' value = ''}
            {/if}
            <tr><td nowrap class = "{$span_class}">#filter:timestamp_time-{$message.timestamp}#, <span class = "boldFont">{$message.users_LOGIN}</span>: </td><td class = "{$span_class}">{$message.content}</td></tr>
        {foreachelse}
            <tr><td align = "center" class = "emptyCategory">{$smarty.const._NOMESSAGESFOUNDFORTHISINTERVALANDUSER}</td></tr>
        {/foreach}
        </table>
    {/if}

    {if $smarty.get.show_users}
        <table border = "0" align = "center">
            <td align = "center" class = "horizontalSeparator"><span class = "boldFont">{$T_CHATROOM_NAME}</span></td>
        {section name = "users_list" loop = $T_USERS_LIST}
            <tr><td align = "center">{$T_USERS_LIST[users_list]}</td></tr>
        {/section}
        </table>
    {/if}

{/if}