/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.gen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.common.ui.internal.util.SWTUtil;
import org.eclipse.jpt.common.ui.internal.util.TableLayoutComposite;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.gen.internal.ORMGenCustomizer;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.JptUiEntityGenMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.NewAssociationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.gen.NewAssociationWizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinColumnsPage
extends NewAssociationWizardPage {
    private Label joinColumnsDescLabel1;
    private TableViewer joinColumnsTable1;
    private ArrayList<SimpleJoin> tableDataModel1 = new ArrayList();
    private Composite tablesGroup1;
    private Label joinColumnsDescLabel2;
    private TableViewer joinColumnsTable2;
    private ArrayList<SimpleJoin> tableDataModel2 = new ArrayList();
    private Composite tablesGroup2;
    static final String[] JOINCOLUMNS_TABLE_COLUMN_PROPERTIES = new String[]{"referrerColumn", "referencedColumn"};
    private static final int JOINCOLUMN1_COLUMN_INDEX = 0;
    private static final int JOINCOLUMN2_COLUMN_INDEX = 1;

    protected JoinColumnsPage(ORMGenCustomizer customizer) {
        super(customizer, "JoinColumnsPage");
        this.setTitle(JptUiEntityGenMessages.GenerateEntitiesWizard_newAssoc_colsPage_title);
        this.setDescription(JptUiEntityGenMessages.GenerateEntitiesWizard_newAssoc_colsPage_desc);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.jpa.ui.dialog_joinColumnsPage");
        this.tablesGroup1 = new Composite(composite, 16);
        this.tablesGroup1.setLayoutData((Object)new GridData());
        this.tablesGroup1.setLayout((Layout)new GridLayout(2, false));
        this.createJoinColumnsTableControl1(this.tablesGroup1);
        this.setControl((Control)composite);
        this.setPageComplete(false);
        ((WizardDialog)this.getContainer()).addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                if (event.getSelectedPage() == JoinColumnsPage.this) {
                    ((Composite)JoinColumnsPage.this.getControl()).getParent().layout();
                }
            }
        });
    }

    private void createMtmJoinColumnsTable2(Composite composite) {
        this.tablesGroup2 = new Composite(composite, 16);
        this.tablesGroup2.setLayoutData((Object)new GridData());
        this.tablesGroup2.setLayout((Layout)new GridLayout(2, false));
        this.createJoinColumnsTableControl2(this.tablesGroup2);
    }

    @Override
    public void updateWithNewTables() {
        String cardinality = this.getCardinality();
        if ("many-to-many".equals(cardinality)) {
            this.updateWithMtmTables();
        } else {
            this.updateWithOtmTables();
        }
    }

    public void updateWithOtmTables() {
        TableColumn[] columns = this.joinColumnsTable1.getTable().getColumns();
        String table1Name = this.getReferrerTableName();
        String table2Name = this.getReferencedTableName();
        if (table1Name == null || table2Name == null) {
            return;
        }
        columns[0].setText(table1Name);
        columns[1].setText(table2Name);
        if (this.tablesGroup2 != null) {
            this.tablesGroup2.setVisible(false);
        }
        this.tableDataModel1.clear();
        this.joinColumnsTable1.refresh();
        String msg = String.format(JptUiEntityGenMessages.GenerateEntitiesWizard_newAssoc_colsPage_label, table1Name, table2Name);
        this.joinColumnsDescLabel1.setText(msg);
        this.joinColumnsDescLabel1.setToolTipText(msg);
        this.tablesGroup1.layout();
        String[] referrerColumnValues = this.getTableColumns(table1Name);
        String[] referencedColumnValues = this.getTableColumns(table2Name);
        this.updateCellEditors(this.joinColumnsTable1, referrerColumnValues, referencedColumnValues);
        ((Composite)this.getControl()).layout();
    }

    public void updateWithMtmTables() {
        TableColumn[] columns = this.joinColumnsTable1.getTable().getColumns();
        String table1Name = this.getReferrerTableName();
        String table2Name = this.getReferencedTableName();
        String joinTableName = this.getJoinTableName();
        if (table1Name == null || table2Name == null || joinTableName == null) {
            return;
        }
        if (this.tablesGroup2 == null) {
            this.createMtmJoinColumnsTable2(this.tablesGroup1.getParent());
        }
        columns[0].setText(table1Name == null ? "" : table1Name);
        columns[1].setText(table2Name == null ? "" : joinTableName);
        this.tableDataModel1.clear();
        this.joinColumnsTable1.refresh();
        String msg = String.format(JptUiEntityGenMessages.GenerateEntitiesWizard_newAssoc_colsPage_label, table1Name, joinTableName);
        this.joinColumnsDescLabel1.setText(msg);
        this.joinColumnsDescLabel1.setToolTipText(msg);
        String[] referrerColumnValues = this.getTableColumns(table1Name);
        String[] referencedColumnValues = this.getTableColumns(joinTableName);
        this.updateCellEditors(this.joinColumnsTable1, referrerColumnValues, referencedColumnValues);
        columns = this.joinColumnsTable2.getTable().getColumns();
        columns[0].setText(joinTableName == null ? "" : joinTableName);
        columns[1].setText(table2Name == null ? "" : table2Name);
        this.tablesGroup1.layout();
        this.tableDataModel2.clear();
        this.joinColumnsTable2.refresh();
        msg = String.format(JptUiEntityGenMessages.GenerateEntitiesWizard_newAssoc_colsPage_label, joinTableName, table2Name);
        this.joinColumnsDescLabel2.setText(msg);
        this.joinColumnsDescLabel2.setToolTipText(msg);
        referrerColumnValues = this.getTableColumns(joinTableName);
        referencedColumnValues = this.getTableColumns(table2Name);
        this.updateCellEditors(this.joinColumnsTable2, referrerColumnValues, referencedColumnValues);
        this.tablesGroup2.layout();
        this.tablesGroup2.setVisible(true);
        ((Composite)this.getControl()).layout(new Control[]{this.tablesGroup1, this.tablesGroup2});
    }

    private void createAddRemoveButtonComposite(Composite tablesGroup, final TableViewer joinColumnsTable, final ArrayList<SimpleJoin> tableDataModel) {
        Composite buttonComposite = new Composite(tablesGroup, 0);
        GridLayout buttonLayout = new GridLayout(1, false);
        buttonComposite.setLayout((Layout)buttonLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)data);
        Button addButton = new Button(buttonComposite, 8);
        addButton.setText(JptUiEntityGenMessages.add);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        addButton.setLayoutData((Object)gridData);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SimpleJoin join = JoinColumnsPage.this.getDefaultNewJoin(joinColumnsTable);
                tableDataModel.add(join);
                joinColumnsTable.refresh();
                TreeMap joins = null;
                joins = joinColumnsTable == JoinColumnsPage.this.joinColumnsTable1 ? (TreeMap)JoinColumnsPage.this.getWizardDataModel().get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS1) : (TreeMap)JoinColumnsPage.this.getWizardDataModel().get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS2);
                joins.put(join.foreignKey, join.primaryKey);
                JoinColumnsPage.this.updatePageComplete();
            }
        });
        Button removeButton = new Button(buttonComposite, 8);
        removeButton.setText(JptUiEntityGenMessages.remove);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        removeButton.setLayoutData((Object)gridData);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)joinColumnsTable.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                SimpleJoin join = (SimpleJoin)selection.getFirstElement();
                tableDataModel.remove(join);
                TreeMap joins = null;
                joins = joinColumnsTable == JoinColumnsPage.this.joinColumnsTable1 ? (TreeMap)JoinColumnsPage.this.getWizardDataModel().get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS1) : (TreeMap)JoinColumnsPage.this.getWizardDataModel().get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS2);
                joins.remove(join.foreignKey);
                joinColumnsTable.refresh();
            }
        });
        addButton.setFocus();
    }

    protected SimpleJoin getDefaultNewJoin(TableViewer joinColumnsTable) {
        String table1Name = "";
        String table2Name = "";
        TreeMap existingJoins = null;
        if (joinColumnsTable == this.joinColumnsTable1) {
            existingJoins = (TreeMap)this.getWizardDataModel().get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS1);
            if (this.getJoinTableName() == null) {
                table1Name = this.getReferrerTableName();
                table2Name = this.getReferencedTableName();
            } else {
                table1Name = this.getReferrerTableName();
                table2Name = this.getJoinTableName();
            }
        } else {
            existingJoins = (TreeMap)this.getWizardDataModel().get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS2);
            table1Name = this.getJoinTableName();
            table2Name = this.getReferencedTableName();
        }
        String[] table1ColumnValues = this.getTableColumns(table1Name);
        String nextCol1 = "";
        String[] stringArray = table1ColumnValues;
        int n = table1ColumnValues.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!existingJoins.keySet().contains(s)) {
                nextCol1 = s;
                break;
            }
            ++n2;
        }
        String[] table2ColumnValues = this.getTableColumns(table2Name);
        String nextCol2 = "";
        String[] stringArray2 = table2ColumnValues;
        int n3 = table2ColumnValues.length;
        int n4 = 0;
        while (n4 < n3) {
            String s = stringArray2[n4];
            if (!existingJoins.values().contains(s)) {
                nextCol2 = s;
                break;
            }
            ++n4;
        }
        return new SimpleJoin(nextCol1, nextCol2);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void updatePageComplete() {
        boolean ret = this.tableDataModel1.size() > 0;
        this.setPageComplete(ret);
    }

    private Label createLabel(Composite container, int span, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        return label;
    }

    private void createJoinColumnsTableControl1(Composite tablesGroup) {
        this.joinColumnsDescLabel1 = this.createLabel(tablesGroup, 2, JptUiEntityGenMessages.GenerateEntitiesWizard_newAssoc_colsPage_label);
        this.joinColumnsTable1 = this.createJoinColumnsTableControl(tablesGroup, this.tableDataModel1);
        this.createAddRemoveButtonComposite(tablesGroup, this.joinColumnsTable1, this.tableDataModel1);
    }

    private void createJoinColumnsTableControl2(Composite tablesGroup) {
        this.joinColumnsDescLabel2 = this.createLabel(tablesGroup, 2, JptUiEntityGenMessages.GenerateEntitiesWizard_newAssoc_colsPage_label);
        this.joinColumnsTable2 = this.createJoinColumnsTableControl(tablesGroup, this.tableDataModel2);
        this.createAddRemoveButtonComposite(tablesGroup, this.joinColumnsTable2, this.tableDataModel2);
    }

    private TableViewer createJoinColumnsTableControl(Composite parent, ArrayList<SimpleJoin> tableDataModel) {
        TableLayoutComposite layout = new TableLayoutComposite(parent, 0);
        this.addColumnLayoutData(layout);
        Table table = new Table((Composite)layout, 68356);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn referrerColumn = new TableColumn(table, 0, 0);
        referrerColumn.setText("%table1");
        referrerColumn.setResizable(true);
        TableColumn referencedColumn = new TableColumn(table, 0, 1);
        referencedColumn.setText("%table2");
        referencedColumn.setResizable(true);
        GridData gd = new GridData(1808);
        gd.heightHint = SWTUtil.getTableHeightHint((Table)table, (int)3);
        gd.widthHint = 300;
        layout.setLayoutData((Object)gd);
        TableViewer newJoinColumnsTable = new TableViewer(table);
        newJoinColumnsTable.setUseHashlookup(true);
        newJoinColumnsTable.setLabelProvider(this.buildTableTableLabelProvider());
        newJoinColumnsTable.setContentProvider(this.buildTableTableContentProvider());
        newJoinColumnsTable.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((SimpleJoin)e1).foreignKey.compareTo(((SimpleJoin)e2).foreignKey);
            }
        });
        newJoinColumnsTable.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.populateTableDataModel();
        newJoinColumnsTable.setInput(tableDataModel);
        return newJoinColumnsTable;
    }

    public void populateTableDataModel() {
        TreeMap joinColumns2;
        HashMap<String, Object> dataModel = this.getWizardDataModel();
        TreeMap joinColumns = (TreeMap)dataModel.get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS1);
        if (joinColumns != null) {
            for (String referrerColumn : joinColumns.keySet()) {
                this.tableDataModel1.add(new SimpleJoin(referrerColumn, (String)joinColumns.get(referrerColumn)));
            }
        }
        if ((joinColumns2 = (TreeMap)dataModel.get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS2)) != null) {
            for (String referrerColumn : joinColumns2.keySet()) {
                this.tableDataModel2.add(new SimpleJoin(referrerColumn, (String)joinColumns2.get(referrerColumn)));
            }
        }
    }

    private IContentProvider buildTableTableContentProvider() {
        return new JoinColumnsContentProvider();
    }

    private IBaseLabelProvider buildTableTableLabelProvider() {
        return new JoinColumnsTableLabelProvider();
    }

    private void addColumnLayoutData(TableLayoutComposite layout) {
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
    }

    private void updateCellEditors(TableViewer joinColumnsTable, String[] referrerColumnValues, String[] referencedColumnValues) {
        joinColumnsTable.setColumnProperties(JOINCOLUMNS_TABLE_COLUMN_PROPERTIES);
        ComboBoxCellEditor[] editors = new ComboBoxCellEditor[JOINCOLUMNS_TABLE_COLUMN_PROPERTIES.length];
        editors[0] = new ComboBoxCellEditor((Composite)joinColumnsTable.getTable(), referrerColumnValues, 4);
        editors[1] = new ComboBoxCellEditor((Composite)joinColumnsTable.getTable(), referencedColumnValues, 4);
        joinColumnsTable.setCellEditors((CellEditor[])editors);
        joinColumnsTable.setCellModifier(this.buildTableTableCellModifier(joinColumnsTable, referrerColumnValues, referencedColumnValues));
    }

    public String[] getTableColumns(String tableName) {
        Schema schema = (Schema)this.getWizardDataModel().get(NewAssociationWizard.ASSOCIATION_SCHEMA);
        org.eclipse.jpt.jpa.db.Table table = schema.getTableNamed(tableName);
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            list.add(column.getName());
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    private ICellModifier buildTableTableCellModifier(TableViewer joinColumnsTable, String[] referrerColumnValues, String[] referencedColumnValues) {
        return new JoinColumnsCellModifier(joinColumnsTable, referrerColumnValues, referencedColumnValues);
    }

    private class JoinColumnsCellModifier
    implements ICellModifier {
        private TableViewer joinColumnsTable;
        private String[] referrerColumnValues;
        private String[] referencedColumnValues;

        JoinColumnsCellModifier(TableViewer joinColumnsTable, String[] referrerColumnValues, String[] referencedColumnValues) {
            this.joinColumnsTable = joinColumnsTable;
            this.referrerColumnValues = referrerColumnValues;
            this.referencedColumnValues = referencedColumnValues;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            ArrayList tableDataModel = (ArrayList)this.joinColumnsTable.getInput();
            int i = 0;
            while (i < tableDataModel.size()) {
                if (tableDataModel.get(i) == element) {
                    return new Integer(i);
                }
                ++i;
            }
            return new Integer(0);
        }

        public void modify(Object element, String property, Object value) {
            if (!(element instanceof TableItem)) {
                return;
            }
            Integer index = (Integer)value;
            TableItem item = (TableItem)element;
            boolean unchanged = false;
            SimpleJoin join = (SimpleJoin)item.getData();
            if (property.equals(JOINCOLUMNS_TABLE_COLUMN_PROPERTIES[0])) {
                unchanged = join.foreignKey.equals(this.referrerColumnValues[index]);
                if (!unchanged) {
                    TreeMap joins = null;
                    joins = this.joinColumnsTable == JoinColumnsPage.this.joinColumnsTable1 ? (TreeMap)JoinColumnsPage.this.getWizardDataModel().get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS1) : (TreeMap)JoinColumnsPage.this.getWizardDataModel().get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS2);
                    joins.remove(join.foreignKey);
                    joins.put(this.referrerColumnValues[index], join.primaryKey);
                    join.foreignKey = this.referrerColumnValues[index];
                    this.joinColumnsTable.refresh();
                }
                return;
            }
            if (property.equals(JOINCOLUMNS_TABLE_COLUMN_PROPERTIES[1]) && !(unchanged = join.primaryKey.equals(this.referencedColumnValues[index]))) {
                join.primaryKey = this.referencedColumnValues[index];
                TreeMap joins = null;
                joins = this.joinColumnsTable == JoinColumnsPage.this.joinColumnsTable1 ? (TreeMap)JoinColumnsPage.this.getWizardDataModel().get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS1) : (TreeMap)JoinColumnsPage.this.getWizardDataModel().get(NewAssociationWizard.ASSOCIATION_JOIN_COLUMNS2);
                joins.put(join.foreignKey, join.primaryKey);
                this.joinColumnsTable.refresh();
            }
        }
    }

    private class JoinColumnsContentProvider
    implements IStructuredContentProvider {
        JoinColumnsContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }
    }

    private final class JoinColumnsTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private JoinColumnsTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof SimpleJoin)) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return ((SimpleJoin)element).foreignKey;
                }
                case 1: {
                    return ((SimpleJoin)element).primaryKey;
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    private class SimpleJoin {
        public String foreignKey;
        public String primaryKey;

        public SimpleJoin(String foreignKey, String primaryKey) {
            this.foreignKey = foreignKey;
            this.primaryKey = primaryKey;
        }

        public String toString() {
            return "[" + this.foreignKey + " = " + this.primaryKey + "]";
        }
    }
}

