/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.xsd;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.xsd.XsdAttributeDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdAttributeGroupDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdAttributeUse;
import org.eclipse.jpt.jaxb.core.xsd.XsdComplexTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdModelGroup;
import org.eclipse.jpt.jaxb.core.xsd.XsdModelGroupDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdParticle;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdSimpleTypeDefinition;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xsd.contentmodel.internal.util.XSDSchemaLocatorAdapterFactory;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSwitch;

public class XsdUtil {
    static final XsdAdapterFactoryImpl adapterFactory = new XsdAdapterFactoryImpl();

    public static boolean namespaceEquals(XSDNamedComponent comp, String namespace) {
        String xsdNamespace = comp.getTargetNamespace();
        return xsdNamespace == null ? StringTools.stringIsEmpty((String)namespace) : xsdNamespace.equals(namespace);
    }

    public static String getResolvedUri(String namespace, String location) {
        String resolvedUri = null;
        ICatalog catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        if (!StringTools.stringIsEmpty((String)location)) {
            try {
                resolvedUri = catalog.resolveSystem(location);
                if (resolvedUri == null) {
                    resolvedUri = catalog.resolveURI(location);
                }
            }
            catch (MalformedURLException me) {
                JptJaxbCorePlugin.log(me);
                resolvedUri = null;
            }
            catch (IOException ie) {
                JptJaxbCorePlugin.log(ie);
                resolvedUri = null;
            }
        }
        if (!(resolvedUri != null || namespace == null || location != null && location.endsWith(".xsd"))) {
            try {
                resolvedUri = catalog.resolvePublic(namespace, location);
                if (resolvedUri == null) {
                    resolvedUri = catalog.resolveURI(namespace);
                }
            }
            catch (MalformedURLException me) {
                JptJaxbCorePlugin.log(me);
                resolvedUri = null;
            }
            catch (IOException ie) {
                JptJaxbCorePlugin.log(ie);
                resolvedUri = null;
            }
        }
        return resolvedUri != null ? resolvedUri : location;
    }

    public static XSDSchema buildXSDModel(String uriString) {
        XSDSchema xsdSchema = null;
        if (uriString.endsWith("2001/XMLSchema.xsd")) {
            xsdSchema = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
        } else {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getAdapterFactories().add((Object)new XSDSchemaLocatorAdapterFactory());
            URI uri = URI.createURI((String)uriString);
            String physicalLocation = URIResolverPlugin.createResolver().resolvePhysicalLocation("", "", uriString);
            XSDResourceImpl resource = null;
            try {
                InputStream inputStream = resourceSet.getURIConverter().createInputStream(URI.createURI((String)physicalLocation));
                resource = (XSDResourceImpl)resourceSet.createResource(URI.createURI((String)"*.xsd"));
                resource.setURI(uri);
                resource.load(inputStream, null);
            }
            catch (IOException iOException) {
                return null;
            }
            xsdSchema = resource.getSchema();
        }
        XsdUtil.handleImports(xsdSchema);
        return xsdSchema;
    }

    private static void handleImports(XSDSchema xsdSchema) {
        if (xsdSchema != null) {
            for (XSDSchemaContent content : xsdSchema.getContents()) {
                if (!(content instanceof XSDImportImpl)) continue;
                XSDImportImpl anImport = (XSDImportImpl)content;
                try {
                    if (anImport.getSchemaLocation() == null) continue;
                    anImport.importSchema();
                }
                catch (Exception e) {
                    JptJaxbCorePlugin.log(e);
                }
            }
        }
    }

    public static Object getAdapter(Notifier notifier) {
        return adapterFactory.adapt(notifier);
    }

    public static class XsdAdapterFactoryImpl
    extends AdapterFactoryImpl {
        public Adapter createAdapter(Notifier target) {
            XSDSwitch xsdSwitch = new XSDSwitch(){

                public Object caseXSDSchema(XSDSchema object) {
                    return new XsdSchema(object);
                }

                public Object caseXSDAttributeDeclaration(XSDAttributeDeclaration object) {
                    return new XsdAttributeDeclaration(object);
                }

                public Object caseXSDAttributeGroupDefinition(XSDAttributeGroupDefinition object) {
                    return new XsdAttributeGroupDefinition(object);
                }

                public Object caseXSDAttributeUse(XSDAttributeUse object) {
                    return new XsdAttributeUse(object);
                }

                public Object caseXSDComplexTypeDefinition(XSDComplexTypeDefinition object) {
                    return new XsdComplexTypeDefinition(object);
                }

                public Object caseXSDElementDeclaration(XSDElementDeclaration object) {
                    return new XsdElementDeclaration(object);
                }

                public Object caseXSDModelGroup(XSDModelGroup object) {
                    return new XsdModelGroup(object);
                }

                public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition object) {
                    return new XsdModelGroupDefinition(object);
                }

                public Object caseXSDParticle(XSDParticle object) {
                    return new XsdParticle(object);
                }

                public Object caseXSDSimpleTypeDefinition(XSDSimpleTypeDefinition object) {
                    return new XsdSimpleTypeDefinition(object);
                }
            };
            Object o = xsdSwitch.doSwitch((EObject)target);
            Adapter result = null;
            if (o instanceof Adapter) {
                result = (Adapter)o;
            }
            return result;
        }

        public Adapter adapt(Notifier target) {
            return this.adapt(target, (Object)this);
        }
    }
}

