/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.libval;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jpt.jaxb.core.GenericJaxbPlatform;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.libval.JaxbLibValUtil;
import org.eclipse.jpt.jaxb.core.libprov.JaxbLibraryProviderInstallOperationConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JaxbJreLibraryValidator
implements LibraryValidator {
    public IStatus validate(JptLibraryProviderInstallOperationConfig config) {
        JaxbLibraryProviderInstallOperationConfig jaxbConfig = (JaxbLibraryProviderInstallOperationConfig)config;
        if (!jaxbConfig.getJaxbPlatform().getGroup().equals(GenericJaxbPlatform.GROUP)) {
            return new Status(4, "org.eclipse.jpt.jaxb.core", JptJaxbCoreMessages.JreLibraryValidator_invalidPlatform);
        }
        IProjectFacetVersion jaxbVersion = config.getProjectFacetVersion();
        IProjectFacetVersion javaVersion = JaxbLibValUtil.getJavaVersion(jaxbConfig);
        IProjectFacetVersion javaJaxbVersion = JaxbLibValUtil.findJavaJaxbVersion(jaxbConfig);
        IProjectFacetVersion jreJaxbVersion = JaxbLibValUtil.findJreJaxbVersion(jaxbConfig);
        if (jreJaxbVersion == null || jreJaxbVersion.compareTo((Object)jaxbVersion) < 0) {
            String message = NLS.bind((String)JptJaxbCoreMessages.JreLibraryValidator_invalidJavaLibrary, (Object[])new String[]{jaxbVersion.getVersionString()});
            return new Status(4, "org.eclipse.jpt.jaxb.core", message);
        }
        if (javaJaxbVersion == null || javaJaxbVersion.compareTo((Object)jaxbVersion) < 0) {
            String message = NLS.bind((String)JptJaxbCoreMessages.JreLibraryValidator_invalidJavaFacet, (Object[])new String[]{javaVersion.getVersionString(), jaxbVersion.getVersionString()});
            return new Status(2, "org.eclipse.jpt.jaxb.core", message);
        }
        return Status.OK_STATUS;
    }
}

