/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.libval;

import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jpt.common.core.internal.libval.LibValUtil;
import org.eclipse.jpt.common.core.libprov.JptLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.common.core.libval.LibraryValidator;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.JaxbFacet;
import org.eclipse.jpt.jaxb.core.internal.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.internal.libprov.JaxbUserLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jaxb.core.internal.libval.JaxbLibValUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class GenericJaxbUserLibraryValidator
implements LibraryValidator {
    public synchronized IStatus validate(JptLibraryProviderInstallOperationConfig config) {
        JaxbUserLibraryProviderInstallOperationConfig jaxbConfig = (JaxbUserLibraryProviderInstallOperationConfig)config;
        IProjectFacetVersion jaxbVersion = config.getProjectFacetVersion();
        IProjectFacetVersion javaVersion = JaxbLibValUtil.getJavaVersion(jaxbConfig);
        IProjectFacetVersion javaJaxbVersion = JaxbLibValUtil.findJavaJaxbVersion(jaxbConfig);
        TransformationIterable<IClasspathEntry, IPath> libraryPaths = new TransformationIterable<IClasspathEntry, IPath>((Iterable)jaxbConfig.resolve()){

            protected IPath transform(IClasspathEntry o) {
                return o.getPath();
            }
        };
        IProjectFacetVersion jreJaxbVersion = JaxbLibValUtil.findJreJaxbVersion(jaxbConfig);
        if (jreJaxbVersion != null) {
            if (jreJaxbVersion.compareTo((Object)jaxbVersion) < 0) {
                String message = NLS.bind((String)JptJaxbCoreMessages.UserLibraryValidator_incompatibleJavaLibrary, (Object[])new String[]{jaxbVersion.getVersionString()});
                return new Status(4, "org.eclipse.jpt.jaxb.core", message);
            }
        } else {
            IStatus status;
            HashSet<String> classNames = new HashSet<String>();
            classNames.add("javax.xml.bind.annotation.XmlSeeAlso");
            if (jaxbVersion.compareTo((Object)JaxbFacet.VERSION_2_2) >= 0) {
                classNames.add("javax.xml.bind.JAXBPermission");
            }
            if (!(status = LibValUtil.validate((Iterable)libraryPaths, classNames)).isOK()) {
                return status;
            }
        }
        if (javaJaxbVersion != null && javaJaxbVersion.compareTo((Object)jaxbVersion) < 0) {
            String message = NLS.bind((String)JptJaxbCoreMessages.UserLibraryValidator_incompatibleJavaFacet, (Object[])new String[]{javaVersion.getVersionString(), jaxbVersion.getVersionString()});
            return new Status(2, "org.eclipse.jpt.jaxb.core", message);
        }
        return Status.OK_STATUS;
    }
}

