/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlNsForm;
import org.eclipse.jpt.jaxb.core.internal.context.AbstractJaxbContextNode;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.xsd.XSDSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPackage
extends AbstractJaxbContextNode
implements JaxbPackage {
    protected final String name;
    protected JaxbPackageInfo packageInfo;

    public GenericPackage(JaxbContextRoot parent, String name) {
        super(parent);
        this.name = name;
        JavaResourcePackage jrp = this.getJaxbProject().getAnnotatedJavaResourcePackage(this.name);
        if (jrp != null) {
            this.packageInfo = this.buildPackageInfo(jrp);
        }
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        if (this.packageInfo != null) {
            this.packageInfo.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        JavaResourcePackage jrp = this.getJaxbProject().getAnnotatedJavaResourcePackage(this.name);
        if (jrp == null) {
            this.setPackageInfo_(null);
        } else if (this.packageInfo == null) {
            this.setPackageInfo_(this.buildPackageInfo(jrp));
        } else {
            this.packageInfo.update();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JaxbPackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    protected void setPackageInfo_(JaxbPackageInfo packageInfo) {
        JaxbPackageInfo old = this.packageInfo;
        this.packageInfo = packageInfo;
        this.firePropertyChanged("package-info", old, this.packageInfo);
    }

    protected JaxbPackageInfo buildPackageInfo(JavaResourcePackage resourcePackage) {
        return this.getFactory().buildJavaPackageInfo(this, resourcePackage);
    }

    @Override
    public boolean isEmpty() {
        return this.getPackageInfo() == null;
    }

    @Override
    public String getNamespace() {
        return this.getPackageInfo() == null ? "" : this.getPackageInfo().getXmlSchema().getNamespace();
    }

    @Override
    public XmlNsForm getAttributeFormDefault() {
        return this.getPackageInfo() == null ? XmlNsForm.UNSET : this.getPackageInfo().getXmlSchema().getAttributeFormDefault();
    }

    @Override
    public XmlNsForm getElementFormDefault() {
        return this.getPackageInfo() == null ? XmlNsForm.UNSET : this.getPackageInfo().getXmlSchema().getElementFormDefault();
    }

    @Override
    public XsdSchema getXsdSchema() {
        XSDSchema emfSchema = this.getJaxbProject().getSchemaLibrary().getSchema(this.getNamespace());
        return emfSchema == null ? null : (XsdSchema)((Object)XsdUtil.getAdapter((Notifier)emfSchema));
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (!this.getJaxbProject().getSchemaLibrary().getSchemaLocations().containsKey(this.getNamespace())) {
            messages.add(DefaultValidationMessages.buildMessage(2, "PACKAGE_NO_SCHEMA_FOR_NAMESPACE", new String[]{this.getNamespace(), this.name}, this));
        }
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        if (this.packageInfo != null) {
            this.packageInfo.validate(messages, reporter);
        }
    }
}

