/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.annotations.core.utils;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jst.ws.annotations.core.AnnotationDefinition;
import org.eclipse.jst.ws.annotations.core.AnnotationsCorePlugin;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationUtils {
    private AnnotationUtils() {
    }

    public static void addImport(IJavaElement javaElement, String qualifiedName) throws CoreException {
        TextFileChange change = new TextFileChange("Add Import", (IFile)javaElement.getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        TextEdit annotationEdit = AnnotationUtils.createAddImportTextEdit(javaElement, qualifiedName);
        change.addEdit(annotationEdit);
        AnnotationUtils.applyChange(null, (Change)change);
    }

    public static void removeImport(IJavaElement javaElement, String qualifiedName) throws CoreException {
        TextFileChange change = new TextFileChange("Remove Import", (IFile)javaElement.getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        TextEdit annotationEdit = AnnotationUtils.createRemoveImportTextEdit(javaElement, qualifiedName);
        change.addEdit(annotationEdit);
        AnnotationUtils.applyChange(null, (Change)change);
    }

    public static void addAnnotation(IJavaElement javaElement, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        TextFileChange change = new TextFileChange("Add annotation", (IFile)javaElement.getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        TextEdit annotationEdit = AnnotationUtils.createAddAnnotationTextEdit(javaElement, annotation);
        change.addEdit(annotationEdit);
        AnnotationUtils.applyChange(null, (Change)change);
    }

    public static void removeAnnotation(IJavaElement javaElement, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        TextFileChange change = new TextFileChange("Remove annotation", (IFile)javaElement.getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        TextEdit textEdit = AnnotationUtils.createRemoveAnnotationTextEdit(javaElement, annotation);
        change.addEdit(textEdit);
        AnnotationUtils.applyChange(null, (Change)change);
    }

    public static void addMemberValuePair(NormalAnnotation annotation, MemberValuePair memberValuePair) throws JavaModelException {
        if (annotation.getRoot() instanceof CompilationUnit) {
            CompilationUnit compilationUnit = (CompilationUnit)annotation.getRoot();
            TextFileChange change = new TextFileChange("Add Member Value Pair", (IFile)compilationUnit.getJavaElement().getResource());
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            change.setEdit((TextEdit)multiTextEdit);
            TextEdit annotationEdit = AnnotationUtils.createAddMemberValuePairTextEdit(annotation, memberValuePair);
            change.addEdit(annotationEdit);
            AnnotationUtils.applyChange(null, (Change)change);
        }
    }

    public static void removeMemberValuePair(NormalAnnotation annotation, MemberValuePair memberValuePair) throws JavaModelException {
        if (annotation.getRoot() instanceof CompilationUnit) {
            CompilationUnit compilationUnit = (CompilationUnit)annotation.getRoot();
            TextFileChange change = new TextFileChange("Remove Member Value Pair", (IFile)compilationUnit.getJavaElement().getResource());
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            change.setEdit((TextEdit)multiTextEdit);
            TextEdit annotationEdit = AnnotationUtils.createRemoveMemberValuePairTextEdit(annotation, memberValuePair);
            change.addEdit(annotationEdit);
            AnnotationUtils.applyChange(null, (Change)change);
        }
    }

    public static void updateMemberValuePair(MemberValuePair memberValuePair, ASTNode value) throws JavaModelException {
        if (memberValuePair.getRoot() instanceof CompilationUnit) {
            CompilationUnit compilationUnit = (CompilationUnit)memberValuePair.getRoot();
            TextFileChange change = new TextFileChange("Update Member Value Pair", (IFile)compilationUnit.getJavaElement().getResource());
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            change.setEdit((TextEdit)multiTextEdit);
            TextEdit annotationEdit = AnnotationUtils.createUpdateMemberValuePairTextEdit(memberValuePair, value);
            change.addEdit(annotationEdit);
            AnnotationUtils.applyChange(null, (Change)change);
        }
    }

    public static void updateSingleMemberAnnotation(SingleMemberAnnotation annotation, ASTNode value) throws JavaModelException {
        if (annotation.getRoot() instanceof CompilationUnit) {
            CompilationUnit compilationUnit = (CompilationUnit)annotation.getRoot();
            TextFileChange change = new TextFileChange("Update Single Member Annotation", (IFile)compilationUnit.getJavaElement().getResource());
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            change.setEdit((TextEdit)multiTextEdit);
            TextEdit annotationEdit = AnnotationUtils.createUpdateSingleMemberAnnotationTextEdit(annotation, value);
            change.addEdit(annotationEdit);
            AnnotationUtils.applyChange(null, (Change)change);
        }
    }

    public static TextEdit createAddImportTextEdit(IJavaElement javaElement, String qualifiedName) throws CoreException {
        CompilationUnit compilationUnit = SharedASTProvider.getAST((ITypeRoot)AnnotationUtils.getCompilationUnitFromJavaElement(javaElement), (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)compilationUnit, (boolean)true);
        importRewrite.addImport(qualifiedName);
        return importRewrite.rewriteImports(null);
    }

    public static TextEdit createRemoveImportTextEdit(IJavaElement javaElement, String qualifiedName) throws CoreException {
        CompilationUnit compilationUnit = SharedASTProvider.getAST((ITypeRoot)AnnotationUtils.getCompilationUnitFromJavaElement(javaElement), (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)compilationUnit, (boolean)true);
        final String annotationSimpleName = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
        final ArrayList occurences = new ArrayList();
        AnnotationDefinition annotationDefinition = AnnotationsManager.getAnnotationDefinitionForClass(qualifiedName);
        annotationDefinition.setJavaProject(javaElement.getJavaProject());
        List<Object> elementTypes = Collections.emptyList();
        if (annotationDefinition != null) {
            elementTypes = annotationDefinition.getAnnotationTypeTargets();
        }
        for (ElementType elementType : elementTypes) {
            if (elementType == ElementType.PACKAGE) {
                compilationUnit.accept(new ASTVisitor(){

                    public boolean visit(PackageDeclaration packageDeclaration) {
                        AnnotationUtils.countAnnotationOccurrences(packageDeclaration.annotations(), annotationSimpleName, occurences);
                        return false;
                    }
                });
            }
            if (elementType == ElementType.TYPE) {
                compilationUnit.accept(new ASTVisitor(){

                    public boolean visit(TypeDeclaration typeDeclaration) {
                        AnnotationUtils.countAnnotationOccurrences(typeDeclaration.modifiers(), annotationSimpleName, occurences);
                        return false;
                    }
                });
            }
            if (elementType == ElementType.FIELD) {
                compilationUnit.accept(new ASTVisitor(){

                    public boolean visit(FieldDeclaration fieldDeclaration) {
                        AnnotationUtils.countAnnotationOccurrences(fieldDeclaration.modifiers(), annotationSimpleName, occurences);
                        return false;
                    }
                });
            }
            if (elementType == ElementType.METHOD) {
                compilationUnit.accept(new ASTVisitor(){

                    public boolean visit(org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration) {
                        AnnotationUtils.countAnnotationOccurrences(methodDeclaration.modifiers(), annotationSimpleName, occurences);
                        return false;
                    }
                });
            }
            if (elementType != ElementType.PARAMETER) continue;
            compilationUnit.accept(new ASTVisitor(){

                public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
                    AnnotationUtils.countAnnotationOccurrences(singleVariableDeclaration.modifiers(), annotationSimpleName, occurences);
                    return false;
                }
            });
        }
        if (occurences.size() == 1) {
            importRewrite.removeImport(qualifiedName);
        }
        return importRewrite.rewriteImports(null);
    }

    private static void countAnnotationOccurrences(List<IExtendedModifier> modifiers, String annotationSimpleName, List<String> occurences) {
        for (IExtendedModifier extendedModifier : modifiers) {
            org.eclipse.jdt.core.dom.Annotation existingAnnotation;
            if (!(extendedModifier instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.getAnnotationName(existingAnnotation = (org.eclipse.jdt.core.dom.Annotation)extendedModifier).equals(annotationSimpleName)) continue;
            occurences.add(annotationSimpleName);
        }
    }

    public static TextEdit createAddAnnotationTextEdit(IJavaElement javaElement, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        switch (javaElement.getElementType()) {
            case 11: {
                return AnnotationUtils.createAddAnnotationTextEdit((IPackageDeclaration)javaElement, annotation);
            }
            case 7: {
                return AnnotationUtils.createAddAnnotationTextEdit((IType)javaElement, annotation);
            }
            case 8: {
                return AnnotationUtils.createAddAnnotationTextEdit((IField)javaElement, annotation);
            }
            case 9: {
                return AnnotationUtils.createAddAnnotationTextEdit((IMethod)javaElement, annotation);
            }
            case 14: {
                return AnnotationUtils.createAddAnnotationTextEdit((ILocalVariable)javaElement, annotation);
            }
        }
        return new MultiTextEdit();
    }

    public static TextEdit createRemoveAnnotationTextEdit(IJavaElement javaElement, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        switch (javaElement.getElementType()) {
            case 11: {
                return AnnotationUtils.createRemoveAnnotationTextEdit((IPackageDeclaration)javaElement, annotation);
            }
            case 7: {
                return AnnotationUtils.createRemoveAnnotationTextEdit((IType)javaElement, annotation);
            }
            case 8: {
                return AnnotationUtils.createRemoveAnnotationTextEdit((IField)javaElement, annotation);
            }
            case 9: {
                return AnnotationUtils.createRemoveAnnotationTextEdit((IMethod)javaElement, annotation);
            }
            case 14: {
                return AnnotationUtils.createRemoveAnnotationTextEdit((ILocalVariable)javaElement, annotation);
            }
        }
        return new MultiTextEdit();
    }

    private static void applyChange(IProgressMonitor monitor, Change change) {
        Change undoChange;
        IUndoManager manager;
        block9: {
            if (change == null) {
                return;
            }
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            manager = RefactoringCore.getUndoManager();
            boolean successful = false;
            undoChange = null;
            try {
                try {
                    change.initializeValidationData(monitor);
                    RefactoringStatus valid = change.isValid(monitor);
                    if (valid.isOK()) {
                        manager.aboutToPerformChange(change);
                        undoChange = change.perform(monitor);
                        successful = true;
                    }
                }
                catch (CoreException ce) {
                    AnnotationsCorePlugin.log(ce.getStatus());
                    manager.changePerformed(change, successful);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                manager.changePerformed(change, successful);
                throw throwable;
            }
            manager.changePerformed(change, successful);
        }
        if (undoChange != null) {
            undoChange.initializeValidationData(monitor);
            manager.addUndo(undoChange.getName(), undoChange);
        }
    }

    private static TextEdit createAddAnnotationTextEdit(IPackageDeclaration packageDeclaration, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        if (packageDeclaration != null && !AnnotationUtils.isAnnotationPresent((IJavaElement)packageDeclaration, AnnotationUtils.getAnnotationName(annotation))) {
            ICompilationUnit source = AnnotationUtils.getCompilationUnitFromJavaElement((IJavaElement)packageDeclaration);
            CompilationUnit compilationUnit = SharedASTProvider.getAST((ITypeRoot)source, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
            ASTRewrite rewriter = ASTRewrite.create((AST)compilationUnit.getAST());
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)compilationUnit.getPackage(), PackageDeclaration.ANNOTATIONS_PROPERTY);
            listRewrite.insertFirst((ASTNode)annotation, null);
            return rewriter.rewriteAST();
        }
        return new MultiTextEdit();
    }

    private static TextEdit createRemoveAnnotationTextEdit(IPackageDeclaration packageDeclaration, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        if (packageDeclaration != null && AnnotationUtils.isAnnotationPresent((IJavaElement)packageDeclaration, AnnotationUtils.getAnnotationName(annotation))) {
            ICompilationUnit source = AnnotationUtils.getCompilationUnitFromJavaElement((IJavaElement)packageDeclaration);
            CompilationUnit compilationUnit = SharedASTProvider.getAST((ITypeRoot)source, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
            ASTRewrite rewriter = ASTRewrite.create((AST)compilationUnit.getAST());
            PackageDeclaration pkgDeclaration = compilationUnit.getPackage();
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)pkgDeclaration, PackageDeclaration.ANNOTATIONS_PROPERTY);
            List originalList = listRewrite.getOriginalList();
            for (Object object : originalList) {
                if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames((org.eclipse.jdt.core.dom.Annotation)object, annotation)) continue;
                listRewrite.remove((ASTNode)((org.eclipse.jdt.core.dom.Annotation)object), null);
            }
            return rewriter.rewriteAST();
        }
        return new MultiTextEdit();
    }

    private static TextEdit createAddAnnotationTextEdit(IType type, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        AbstractTypeDeclaration typeDeclaration = AnnotationUtils.getTypeDeclaration(type);
        if (typeDeclaration != null && !AnnotationUtils.isAnnotationPresent((IJavaElement)type, annotation)) {
            ASTRewrite rewriter = ASTRewrite.create((AST)typeDeclaration.getAST());
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)typeDeclaration, AnnotationUtils.getChildListPropertyDescriptorForType(typeDeclaration));
            listRewrite.insertFirst((ASTNode)annotation, null);
            return rewriter.rewriteAST();
        }
        return new MultiTextEdit();
    }

    private static TextEdit createRemoveAnnotationTextEdit(IType type, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        AbstractTypeDeclaration typeDeclaration = AnnotationUtils.getTypeDeclaration(type);
        if (typeDeclaration != null && AnnotationUtils.isAnnotationPresent((IJavaElement)type, annotation)) {
            ASTRewrite rewriter = ASTRewrite.create((AST)typeDeclaration.getAST());
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)typeDeclaration, AnnotationUtils.getChildListPropertyDescriptorForType(typeDeclaration));
            List originalList = listRewrite.getOriginalList();
            for (Object object : originalList) {
                if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames((org.eclipse.jdt.core.dom.Annotation)object, annotation)) continue;
                listRewrite.remove((ASTNode)((org.eclipse.jdt.core.dom.Annotation)object), null);
            }
            return rewriter.rewriteAST();
        }
        return new MultiTextEdit();
    }

    private static TextEdit createAddAnnotationTextEdit(IMethod method, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration = AnnotationUtils.getMethodDeclaration(method);
        if (methodDeclaration != null && !AnnotationUtils.isAnnotationPresent((IJavaElement)method, annotation)) {
            ASTRewrite rewriter = ASTRewrite.create((AST)methodDeclaration.getAST());
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)methodDeclaration, org.eclipse.jdt.core.dom.MethodDeclaration.MODIFIERS2_PROPERTY);
            listRewrite.insertAt((ASTNode)annotation, 0, null);
            return rewriter.rewriteAST();
        }
        return new MultiTextEdit();
    }

    private static TextEdit createRemoveAnnotationTextEdit(IMethod method, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration = AnnotationUtils.getMethodDeclaration(method);
        if (methodDeclaration != null && AnnotationUtils.isAnnotationPresent((IJavaElement)method, annotation)) {
            ASTRewrite rewriter = ASTRewrite.create((AST)methodDeclaration.getAST());
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)methodDeclaration, org.eclipse.jdt.core.dom.MethodDeclaration.MODIFIERS2_PROPERTY);
            List originalList = listRewrite.getOriginalList();
            for (Object object : originalList) {
                if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames((org.eclipse.jdt.core.dom.Annotation)object, annotation)) continue;
                listRewrite.remove((ASTNode)((org.eclipse.jdt.core.dom.Annotation)object), null);
            }
            return rewriter.rewriteAST();
        }
        return new MultiTextEdit();
    }

    private static TextEdit createAddAnnotationTextEdit(IField field, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        FieldDeclaration fieldDeclaration = AnnotationUtils.getFieldDeclaration(field);
        if (fieldDeclaration != null && !AnnotationUtils.isAnnotationPresent((IJavaElement)field, annotation)) {
            ASTRewrite rewriter = ASTRewrite.create((AST)fieldDeclaration.getAST());
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)fieldDeclaration, FieldDeclaration.MODIFIERS2_PROPERTY);
            listRewrite.insertAt((ASTNode)annotation, 0, null);
            return rewriter.rewriteAST();
        }
        return new MultiTextEdit();
    }

    private static TextEdit createRemoveAnnotationTextEdit(IField field, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        FieldDeclaration fieldDeclaration = AnnotationUtils.getFieldDeclaration(field);
        if (fieldDeclaration != null && AnnotationUtils.isAnnotationPresent((IJavaElement)field, annotation)) {
            ASTRewrite rewriter = ASTRewrite.create((AST)fieldDeclaration.getAST());
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)fieldDeclaration, FieldDeclaration.MODIFIERS2_PROPERTY);
            List originalList = listRewrite.getOriginalList();
            for (Object object : originalList) {
                if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames((org.eclipse.jdt.core.dom.Annotation)object, annotation)) continue;
                listRewrite.remove((ASTNode)((org.eclipse.jdt.core.dom.Annotation)object), null);
            }
            return rewriter.rewriteAST();
        }
        return new MultiTextEdit();
    }

    private static TextEdit createAddAnnotationTextEdit(ILocalVariable methodParameter, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        SingleVariableDeclaration parameter = AnnotationUtils.getSingleVariableDeclaration(methodParameter);
        if (parameter != null && !AnnotationUtils.isAnnotationPresent((IJavaElement)methodParameter, AnnotationUtils.getAnnotationName(annotation))) {
            ASTRewrite rewriter = ASTRewrite.create((AST)parameter.getAST());
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)parameter, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            listRewrite.insertAt((ASTNode)annotation, -1, null);
            return rewriter.rewriteAST();
        }
        return new MultiTextEdit();
    }

    private static TextEdit createRemoveAnnotationTextEdit(ILocalVariable methodParameter, org.eclipse.jdt.core.dom.Annotation annotation) throws JavaModelException {
        SingleVariableDeclaration parameter = AnnotationUtils.getSingleVariableDeclaration(methodParameter);
        if (AnnotationUtils.isAnnotationPresent((IJavaElement)methodParameter, AnnotationUtils.getAnnotationName(annotation))) {
            ASTRewrite rewriter = ASTRewrite.create((AST)parameter.getAST());
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)parameter, SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            List originalList = listRewrite.getOriginalList();
            for (Object object : originalList) {
                if (!(object instanceof org.eclipse.jdt.core.dom.Annotation) || !AnnotationUtils.compareAnnotationNames((org.eclipse.jdt.core.dom.Annotation)object, annotation)) continue;
                listRewrite.remove((ASTNode)((org.eclipse.jdt.core.dom.Annotation)object), null);
            }
            return rewriter.rewriteAST();
        }
        return new MultiTextEdit();
    }

    public static TextEdit createAddMemberValuePairTextEdit(NormalAnnotation annotation, MemberValuePair memberValuePair) throws JavaModelException {
        ASTRewrite rewriter = ASTRewrite.create((AST)annotation.getAST());
        ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)annotation, NormalAnnotation.VALUES_PROPERTY);
        listRewrite.insertLast((ASTNode)memberValuePair, null);
        return rewriter.rewriteAST();
    }

    public static TextEdit createRemoveMemberValuePairTextEdit(NormalAnnotation annotation, MemberValuePair memberValuePair) throws JavaModelException {
        ASTRewrite rewriter = ASTRewrite.create((AST)annotation.getAST());
        ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)annotation, NormalAnnotation.VALUES_PROPERTY);
        List originalList = listRewrite.getOriginalList();
        for (Object object : originalList) {
            MemberValuePair mvp;
            if (!(object instanceof MemberValuePair) || !(mvp = (MemberValuePair)object).getName().getIdentifier().equals(memberValuePair.getName().getIdentifier())) continue;
            listRewrite.remove((ASTNode)mvp, null);
        }
        return rewriter.rewriteAST();
    }

    public static TextEdit createUpdateMemberValuePairTextEdit(MemberValuePair memberValuePair, ASTNode value) throws JavaModelException {
        ASTRewrite rewriter = ASTRewrite.create((AST)memberValuePair.getAST());
        rewriter.set((ASTNode)memberValuePair, (StructuralPropertyDescriptor)MemberValuePair.VALUE_PROPERTY, (Object)value, null);
        return rewriter.rewriteAST();
    }

    public static TextEdit createUpdateSingleMemberAnnotationTextEdit(SingleMemberAnnotation annotation, ASTNode value) throws JavaModelException {
        ASTRewrite rewriter = ASTRewrite.create((AST)annotation.getAST());
        rewriter.set((ASTNode)annotation, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, (Object)value, null);
        return rewriter.rewriteAST();
    }

    public static ICompilationUnit getCompilationUnitFromJavaElement(IJavaElement javaElement) {
        switch (javaElement.getElementType()) {
            case 5: {
                return (ICompilationUnit)javaElement;
            }
            case 11: {
                IPackageDeclaration packageDeclaration = (IPackageDeclaration)javaElement;
                return (ICompilationUnit)packageDeclaration.getParent();
            }
            case 7: {
                IType type = (IType)javaElement;
                return type.getCompilationUnit();
            }
            case 9: {
                IMethod method = (IMethod)javaElement;
                return method.getCompilationUnit();
            }
            case 8: {
                IField field = (IField)javaElement;
                return field.getCompilationUnit();
            }
            case 14: {
                ILocalVariable localVariable = (ILocalVariable)javaElement;
                if (!(localVariable.getParent() instanceof IMethod)) break;
                return AnnotationUtils.getCompilationUnitFromJavaElement(localVariable.getParent());
            }
        }
        return JavaCore.createCompilationUnitFrom((IFile)((IFile)javaElement.getResource()));
    }

    public static AbstractTypeDeclaration getTypeDeclaration(IType type) {
        CompilationUnit compilationUnit = SharedASTProvider.getAST((ITypeRoot)type.getCompilationUnit(), (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        List types = compilationUnit.types();
        for (AbstractTypeDeclaration abstractTypeDeclaration : types) {
            if (!AnnotationUtils.compareTypeNames(abstractTypeDeclaration, type)) continue;
            return abstractTypeDeclaration;
        }
        return null;
    }

    public static org.eclipse.jdt.core.dom.MethodDeclaration getMethodDeclaration(IMethod method) {
        AbstractTypeDeclaration typeDeclaration = AnnotationUtils.getTypeDeclaration(method.getDeclaringType());
        if (typeDeclaration != null) {
            List bodyDeclarations = typeDeclaration.bodyDeclarations();
            for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration;
                if (!(bodyDeclaration instanceof org.eclipse.jdt.core.dom.MethodDeclaration) || !AnnotationUtils.compareMethods(methodDeclaration = (org.eclipse.jdt.core.dom.MethodDeclaration)bodyDeclaration, method)) continue;
                return methodDeclaration;
            }
        }
        return null;
    }

    public static FieldDeclaration getFieldDeclaration(IField field) {
        AbstractTypeDeclaration typeDeclaration = AnnotationUtils.getTypeDeclaration(field.getDeclaringType());
        if (typeDeclaration != null) {
            List bodyDeclarations = typeDeclaration.bodyDeclarations();
            for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                FieldDeclaration fieldDeclaration;
                if (!(bodyDeclaration instanceof FieldDeclaration) || !AnnotationUtils.compareFieldNames(fieldDeclaration = (FieldDeclaration)bodyDeclaration, field)) continue;
                return fieldDeclaration;
            }
        }
        return null;
    }

    public static SingleVariableDeclaration getSingleVariableDeclaration(ILocalVariable javaElement) {
        if (javaElement instanceof ILocalVariable && javaElement.getParent() instanceof IMethod) {
            ILocalVariable localVariable = javaElement;
            IMethod method = (IMethod)localVariable.getParent();
            org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration = AnnotationUtils.getMethodDeclaration(method);
            List parameters = methodDeclaration.parameters();
            for (SingleVariableDeclaration singleVariableDeclaration : parameters) {
                if (!singleVariableDeclaration.getName().getIdentifier().equals(localVariable.getElementName())) continue;
                return singleVariableDeclaration;
            }
        }
        return null;
    }

    private static ChildListPropertyDescriptor getChildListPropertyDescriptorForType(AbstractTypeDeclaration abstractTypeDeclaration) {
        ChildListPropertyDescriptor childListPropertyDescriptor = null;
        if (abstractTypeDeclaration instanceof TypeDeclaration) {
            childListPropertyDescriptor = TypeDeclaration.MODIFIERS2_PROPERTY;
        }
        if (abstractTypeDeclaration instanceof EnumDeclaration) {
            childListPropertyDescriptor = EnumDeclaration.MODIFIERS2_PROPERTY;
        }
        if (abstractTypeDeclaration instanceof org.eclipse.jdt.core.dom.AnnotationTypeDeclaration) {
            childListPropertyDescriptor = org.eclipse.jdt.core.dom.AnnotationTypeDeclaration.MODIFIERS2_PROPERTY;
        }
        return childListPropertyDescriptor;
    }

    public static String getAnnotationName(org.eclipse.jdt.core.dom.Annotation annotation) {
        Name annotationTypeName = annotation.getTypeName();
        return annotationTypeName.getFullyQualifiedName();
    }

    public static boolean compareTypeNames(AbstractTypeDeclaration abstractTypeDeclaration, IType type) {
        return abstractTypeDeclaration.getName().getIdentifier().equals(type.getElementName());
    }

    public static boolean compareMethods(org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration, IMethod method) {
        List methodDeclarationParameters;
        String[] parametetTypes;
        if (methodDeclaration.getName().getIdentifier().equals(method.getElementName()) && (parametetTypes = method.getParameterTypes()).length == (methodDeclarationParameters = methodDeclaration.parameters()).size()) {
            int i = 0;
            while (i < parametetTypes.length) {
                String simpleName2;
                String simpleName1 = Signature.toString((String)parametetTypes[i]);
                if (!simpleName1.equals(simpleName2 = ((SingleVariableDeclaration)methodDeclarationParameters.get(i)).getType().toString())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean compareMethods(org.eclipse.jdt.core.dom.MethodDeclaration methodOne, org.eclipse.jdt.core.dom.MethodDeclaration methodTwo) {
        if (methodOne.getName().getIdentifier().equals(methodTwo.getName().getIdentifier())) {
            List methodParametersOne = methodOne.parameters();
            List methodParametersTwo = methodTwo.parameters();
            if (methodParametersOne.size() == methodParametersTwo.size()) {
                int i = 0;
                while (i < methodParametersOne.size()) {
                    String simpleName2;
                    String simpleName1 = ((SingleVariableDeclaration)methodParametersOne.get(i)).getType().toString();
                    if (!simpleName1.equals(simpleName2 = ((SingleVariableDeclaration)methodParametersTwo.get(i)).getType().toString())) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean compareMethods(MethodDeclaration methodOne, MethodDeclaration methodTwo) {
        return AnnotationUtils.compareMethodNames(methodOne, methodTwo) && AnnotationUtils.compareMethodParameterTypes(methodOne, methodTwo);
    }

    private static boolean compareMethodNames(MethodDeclaration methodOne, MethodDeclaration methodTwo) {
        return methodOne.getSimpleName().equals(methodTwo.getSimpleName());
    }

    private static boolean compareMethodParameterTypes(MethodDeclaration methodOne, MethodDeclaration methodTwo) {
        int numberOfParametersTwo;
        int numberOfParametersOne = methodOne.getParameters().size();
        if (numberOfParametersOne == (numberOfParametersTwo = methodTwo.getParameters().size())) {
            List parametersOne = (List)methodOne.getParameters();
            List parametersTwo = (List)methodTwo.getParameters();
            int i = 0;
            while (i < parametersOne.size()) {
                if (!((ParameterDeclaration)parametersOne.get(i)).getType().equals((Object)((ParameterDeclaration)parametersTwo.get(i)).getType())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean compareFieldNames(FieldDeclaration fieldDeclaration, IField field) {
        List fragments = fieldDeclaration.fragments();
        for (VariableDeclarationFragment variableDeclarationFragment : fragments) {
            if (!variableDeclarationFragment.getName().getIdentifier().equals(field.getElementName())) continue;
            return true;
        }
        return false;
    }

    private static boolean compareAnnotationNames(org.eclipse.jdt.core.dom.Annotation newAnnotation, org.eclipse.jdt.core.dom.Annotation existingAnnotation) {
        return AnnotationUtils.getAnnotationName(existingAnnotation).equals(AnnotationUtils.getAnnotationName(newAnnotation));
    }

    public static boolean isAnnotationPresent(IJavaElement javaElement, org.eclipse.jdt.core.dom.Annotation annotation) {
        return AnnotationUtils.isAnnotationPresent(javaElement, AnnotationUtils.getAnnotationName(annotation));
    }

    public static boolean isAnnotationPresent(IJavaElement javaElement, String annotationName) {
        if (javaElement.getElementType() == 5) {
            return AnnotationUtils.isAnnotationPresent((IJavaElement)((ICompilationUnit)javaElement).findPrimaryType(), annotationName);
        }
        int elementType = javaElement.getElementType();
        if (elementType == 11 || elementType == 7 || elementType == 9 || elementType == 14 || elementType == 8) {
            List<org.eclipse.jdt.core.dom.Annotation> annotations = AnnotationUtils.getAnnotations(javaElement);
            for (org.eclipse.jdt.core.dom.Annotation annotation : annotations) {
                if (!AnnotationUtils.getAnnotationName(annotation).equals(annotationName)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<org.eclipse.jdt.core.dom.Annotation> getAnnotations(IJavaElement javaElement) {
        SingleVariableDeclaration singleVariableDeclaration;
        IField field;
        FieldDeclaration fieldDeclaration;
        IMethod method;
        org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration;
        IType type;
        AbstractTypeDeclaration typeDeclaration;
        ICompilationUnit source = AnnotationUtils.getCompilationUnitFromJavaElement(javaElement);
        CompilationUnit compilationUnit = SharedASTProvider.getAST((ITypeRoot)source, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        if (javaElement.getElementType() == 11) {
            PackageDeclaration packageDeclaration = compilationUnit.getPackage();
            return packageDeclaration.annotations();
        }
        if (javaElement.getElementType() == 7 && (typeDeclaration = AnnotationUtils.getTypeDeclaration(type = (IType)javaElement)) != null) {
            return AnnotationUtils.extractAnnotations(typeDeclaration.modifiers());
        }
        if (javaElement.getElementType() == 9 && (methodDeclaration = AnnotationUtils.getMethodDeclaration(method = (IMethod)javaElement)) != null) {
            return AnnotationUtils.extractAnnotations(methodDeclaration.modifiers());
        }
        if (javaElement.getElementType() == 8 && (fieldDeclaration = AnnotationUtils.getFieldDeclaration(field = (IField)javaElement)) != null) {
            return AnnotationUtils.extractAnnotations(fieldDeclaration.modifiers());
        }
        if (javaElement.getElementType() == 14 && (singleVariableDeclaration = AnnotationUtils.getSingleVariableDeclaration((ILocalVariable)javaElement)) != null) {
            return AnnotationUtils.extractAnnotations(singleVariableDeclaration.modifiers());
        }
        return Collections.emptyList();
    }

    private static List<org.eclipse.jdt.core.dom.Annotation> extractAnnotations(List<IExtendedModifier> extendedModifiers) {
        ArrayList<org.eclipse.jdt.core.dom.Annotation> annotations = new ArrayList<org.eclipse.jdt.core.dom.Annotation>();
        for (IExtendedModifier extendedModifier : extendedModifiers) {
            if (!extendedModifier.isAnnotation()) continue;
            annotations.add((org.eclipse.jdt.core.dom.Annotation)extendedModifier);
        }
        return annotations;
    }

    public static List<SingleVariableDeclaration> getSingleVariableDeclarations(final IMethod method) {
        ICompilationUnit source = method.getCompilationUnit();
        CompilationUnit compilationUnit = SharedASTProvider.getAST((ITypeRoot)source, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        final ArrayList<SingleVariableDeclaration> parameters = new ArrayList<SingleVariableDeclaration>();
        compilationUnit.accept(new ASTVisitor(){

            public boolean visit(org.eclipse.jdt.core.dom.MethodDeclaration methodDeclaration) {
                if (AnnotationUtils.compareMethods(methodDeclaration, method)) {
                    parameters.addAll(methodDeclaration.parameters());
                }
                return false;
            }
        });
        return parameters;
    }

    public static ILocalVariable getLocalVariable(IMethod method, int offset) {
        List<SingleVariableDeclaration> parameters = AnnotationUtils.getSingleVariableDeclarations(method);
        for (SingleVariableDeclaration parameter : parameters) {
            int parameterStartPosition = parameter.getStartPosition();
            int parameterLength = parameter.getLength();
            if (offset < parameterStartPosition || offset > parameterStartPosition + parameterLength) continue;
            return (ILocalVariable)parameter.resolveBinding().getJavaElement();
        }
        return null;
    }

    public static ILocalVariable getLocalVariable(IMethod method, String paramName) {
        List<SingleVariableDeclaration> parameters = AnnotationUtils.getSingleVariableDeclarations(method);
        for (SingleVariableDeclaration parameter : parameters) {
            if (!parameter.getName().getIdentifier().equals(paramName)) continue;
            return (ILocalVariable)parameter.resolveBinding().getJavaElement();
        }
        return null;
    }

    public static org.eclipse.jdt.core.dom.Annotation getAnnotation(IJavaElement javaElement, Class<? extends Annotation> annotation) {
        List<org.eclipse.jdt.core.dom.Annotation> annotations = AnnotationUtils.getAnnotations(javaElement);
        for (org.eclipse.jdt.core.dom.Annotation astAnnotation : annotations) {
            String typeName = astAnnotation.getTypeName().getFullyQualifiedName();
            if (!typeName.equals(annotation.getCanonicalName()) && !typeName.equals(annotation.getSimpleName())) continue;
            return astAnnotation;
        }
        return null;
    }

    public static AnnotationMirror getAnnotation(Declaration declaration, Class<? extends Annotation> annotation) {
        Collection aannotationMirrors = declaration.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : aannotationMirrors) {
            AnnotationTypeDeclaration annotationTypeDeclaration = annotationMirror.getAnnotationType().getDeclaration();
            if (annotationTypeDeclaration == null || !annotationTypeDeclaration.getQualifiedName().equals(annotation.getCanonicalName())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static IAnnotation getAnnotation(Class<? extends Annotation> annotation, IAnnotatable annotatable) throws JavaModelException {
        IAnnotation[] annotations;
        IAnnotation[] iAnnotationArray = annotations = annotatable.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation jdtAnnotation = iAnnotationArray[n2];
            String annotationName = jdtAnnotation.getElementName();
            if (annotationName.equals(annotation.getCanonicalName()) || annotationName.equals(annotation.getSimpleName())) {
                return jdtAnnotation;
            }
            ++n2;
        }
        return null;
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror mirror, String memberName) {
        Map values = mirror.getElementValues();
        Set entrySet = values.entrySet();
        for (Map.Entry entry : entrySet) {
            AnnotationTypeElementDeclaration element = (AnnotationTypeElementDeclaration)entry.getKey();
            if (!element.getSimpleName().equals(memberName)) continue;
            return (AnnotationValue)entry.getValue();
        }
        return null;
    }

    public static Expression getAnnotationValue(NormalAnnotation normalAnnotation, String memberName) {
        List memberValuePairs = normalAnnotation.values();
        for (MemberValuePair memberValuePair : memberValuePairs) {
            if (!memberValuePair.getName().getIdentifier().equals(memberName)) continue;
            return memberValuePair.getValue();
        }
        return null;
    }

    public static Object getAnnotationValue(IAnnotation annotation, String memberName) throws JavaModelException {
        IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
        if (memberValuePairs.length > 0) {
            IMemberValuePair[] iMemberValuePairArray = memberValuePairs;
            int n = memberValuePairs.length;
            int n2 = 0;
            while (n2 < n) {
                IMemberValuePair memberValuePair = iMemberValuePairArray[n2];
                if (memberValuePair.getMemberName().equals(memberName)) {
                    return memberValuePair.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    public static MemberValuePair getMemberValuePair(NormalAnnotation normalAnnotation, String memberName) {
        List memberValuesPairs = normalAnnotation.values();
        for (MemberValuePair memberValuePair : memberValuesPairs) {
            if (!memberValuePair.getName().getIdentifier().equals(memberName)) continue;
            return memberValuePair;
        }
        return null;
    }

    public static String getStringValue(AnnotationMirror mirror, String memberName) {
        AnnotationValue annotationValue = AnnotationUtils.getAnnotationValue(mirror, memberName);
        if (annotationValue != null) {
            return annotationValue.getValue().toString();
        }
        return null;
    }

    public static String getStringValue(org.eclipse.jdt.core.dom.Annotation annotation, String memberName) {
        Expression expression;
        if (annotation instanceof NormalAnnotation && (expression = AnnotationUtils.getAnnotationValue((NormalAnnotation)annotation, memberName)) != null && expression instanceof StringLiteral) {
            return ((StringLiteral)expression).getLiteralValue();
        }
        return null;
    }

    public static String getStringValue(IAnnotation annotation, String memberName) throws JavaModelException {
        Object value = AnnotationUtils.getAnnotationValue(annotation, memberName);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static Boolean getBooleanValue(AnnotationMirror mirror, String memberName) {
        String value = AnnotationUtils.getStringValue(mirror, memberName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static Boolean getBooleanValue(org.eclipse.jdt.core.dom.Annotation annotation, String memberName) {
        Expression expression;
        if (annotation instanceof NormalAnnotation && (expression = AnnotationUtils.getAnnotationValue((NormalAnnotation)annotation, memberName)) != null && expression instanceof BooleanLiteral) {
            return ((BooleanLiteral)expression).booleanValue();
        }
        return null;
    }

    public static Boolean getBooleanValue(IAnnotation annotation, String memberName) throws JavaModelException {
        String value = AnnotationUtils.getStringValue(annotation, memberName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static String getEnumValue(org.eclipse.jdt.core.dom.Annotation annotation, String memberName) {
        Expression expression;
        if (annotation instanceof NormalAnnotation && (expression = AnnotationUtils.getAnnotationValue((NormalAnnotation)annotation, memberName)) != null && expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getName().getIdentifier();
        }
        return null;
    }

    public static String getEnumValue(IAnnotation annotation, String memberName) throws JavaModelException {
        String value = AnnotationUtils.getStringValue(annotation, memberName);
        if (value != null && value.indexOf(".") != -1) {
            return value.substring(value.lastIndexOf(".") + 1);
        }
        return null;
    }
}

