/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.gen.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.gen.internal.util.ForeignKeyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTPUtil {
    public static boolean isAutoIncrement(Column c) {
        return false;
    }

    public static List<ForeignKeyInfo> getForeignKeys(Table dbTable) {
        ArrayList<ForeignKeyInfo> ret = new ArrayList<ForeignKeyInfo>();
        if (dbTable != null) {
            for (ForeignKey fk : dbTable.getForeignKeys()) {
                Iterator columnPaires = fk.getColumnPairs().iterator();
                ForeignKeyInfo fkInfo = null;
                while (columnPaires.hasNext()) {
                    ForeignKey.ColumnPair columnPair = (ForeignKey.ColumnPair)columnPaires.next();
                    if (fkInfo == null) {
                        String tableName = dbTable.getName();
                        String referencedTableName = "";
                        Table referencedTable = fk.getReferencedTable();
                        referencedTableName = referencedTable.getName();
                        fkInfo = new ForeignKeyInfo(fk, tableName, referencedTableName);
                    }
                    String baseColName = columnPair.getBaseColumn().getName();
                    String referencedColName = columnPair.getReferencedColumn().getName();
                    fkInfo.addColumnMapping(baseColName, referencedColName);
                }
                if (fkInfo == null) continue;
                ret.add(fkInfo);
            }
        }
        return ret;
    }

    public static String getJavaType(Column dbColumn) {
        return dbColumn.isPartOfPrimaryKey() ? dbColumn.getPrimaryKeyJavaTypeDeclaration() : dbColumn.getJavaTypeDeclaration();
    }

    public static boolean isDefaultSchema(Table dbTable) {
        String schemaName = dbTable.getSchema().getName();
        Schema defaultSchema = dbTable.getSchema().getDatabase().getDefaultSchema();
        return defaultSchema.getName() == schemaName;
    }
}

