/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTFieldAttribute;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTMethodAttribute;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.MethodAttribute;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.CommandExecutor;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.ClassName;
import org.eclipse.jpt.common.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.common.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourcePersistentMember;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.Access2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AccessType;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourcePersistentAttribute
extends SourcePersistentMember<Attribute>
implements JavaResourcePersistentAttribute {
    private int modifiers;
    private String typeName;
    private boolean typeIsInterface;
    private boolean typeIsEnum;
    private final Vector<String> typeSuperclassNames = new Vector();
    private final Vector<String> typeInterfaceNames = new Vector();
    private final Vector<String> typeTypeArgumentNames = new Vector();

    static JavaResourcePersistentAttribute newInstance(JavaResourcePersistentType parent, Type declaringType, String name, int occurrence, JavaResourceCompilationUnit javaResourceCompilationUnit, CompilationUnit astRoot) {
        JDTFieldAttribute attribute = new JDTFieldAttribute(declaringType, name, occurrence, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourcePersistentAttribute jrpa = new SourcePersistentAttribute(parent, (Attribute)attribute);
        jrpa.initialize(astRoot);
        return jrpa;
    }

    static JavaResourcePersistentAttribute newInstance(JavaResourcePersistentType parent, Type declaringType, MethodSignature signature, int occurrence, JavaResourceCompilationUnit javaResourceCompilationUnit, CompilationUnit astRoot) {
        JDTMethodAttribute attribute = JDTMethodAttribute.newInstance((Type)declaringType, (MethodSignature)signature, (int)occurrence, (ICompilationUnit)javaResourceCompilationUnit.getCompilationUnit(), (CommandExecutor)javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), (AnnotationEditFormatter)javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourcePersistentAttribute jrpa = new SourcePersistentAttribute(parent, (Attribute)attribute);
        jrpa.initialize(astRoot);
        return jrpa;
    }

    private SourcePersistentAttribute(JavaResourcePersistentType parent, Attribute attribute) {
        super((JavaResourceNode)parent, attribute);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        ITypeBinding typeBinding = this.getTypeBinding(astRoot);
        this.modifiers = this.buildModifiers(astRoot);
        this.typeName = this.buildTypeName(typeBinding);
        this.typeIsInterface = this.buildTypeIsInterface(typeBinding);
        this.typeIsEnum = this.buildTypeIsEnum(typeBinding);
        this.typeSuperclassNames.addAll(this.buildTypeSuperclassNames(typeBinding));
        this.typeInterfaceNames.addAll(this.buildTypeInterfaceNames(typeBinding));
        this.typeTypeArgumentNames.addAll(this.buildTypeTypeArgumentNames(typeBinding));
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        ITypeBinding typeBinding = this.getTypeBinding(astRoot);
        this.syncTypeName(this.buildTypeName(typeBinding));
        this.syncTypeSuperclassNames(this.buildTypeSuperclassNames(typeBinding));
        this.syncTypeInterfaceNames(this.buildTypeInterfaceNames(typeBinding));
        this.syncTypeTypeArgumentNames(this.buildTypeTypeArgumentNames(typeBinding));
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        ITypeBinding typeBinding = this.getTypeBinding(astRoot);
        this.syncModifiers(this.buildModifiers(astRoot));
        this.syncTypeName(this.buildTypeName(typeBinding));
        this.syncTypeIsInterface(this.buildTypeIsInterface(typeBinding));
        this.syncTypeIsEnum(this.buildTypeIsEnum(typeBinding));
        this.syncTypeSuperclassNames(this.buildTypeSuperclassNames(typeBinding));
        this.syncTypeInterfaceNames(this.buildTypeInterfaceNames(typeBinding));
        this.syncTypeTypeArgumentNames(this.buildTypeTypeArgumentNames(typeBinding));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    Iterator<String> validAnnotationNames() {
        return this.getAnnotationProvider().attributeAnnotationNames();
    }

    @Override
    Annotation buildAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildAttributeAnnotation(this, (Attribute)this.annotatedElement, annotationName);
    }

    private Annotation buildNullAnnotation_(String annotationName) {
        return this.getAnnotationProvider().buildNullAttributeAnnotation(this, annotationName);
    }

    @Override
    public JavaResourcePersistentType getParent() {
        return (JavaResourcePersistentType)super.getParent();
    }

    @Override
    public JavaResourcePersistentType getResourcePersistentType() {
        return this.getParent();
    }

    @Override
    public String getName() {
        return ((Attribute)this.annotatedElement).getAttributeName();
    }

    @Override
    public boolean isFor(MethodSignature signature, int occurrence) {
        return ((MethodAttribute)this.annotatedElement).matches(signature, occurrence);
    }

    @Override
    public Annotation buildNullAnnotation(String annotationName) {
        return annotationName == null ? null : this.buildNullAnnotation_(annotationName);
    }

    @Override
    public boolean isField() {
        return ((Attribute)this.annotatedElement).isField();
    }

    @Override
    public boolean isProperty() {
        return !this.isField();
    }

    @Override
    public AccessType getSpecifiedAccess() {
        Access2_0Annotation accessAnnotation = this.getAccessAnnotation();
        return accessAnnotation == null ? null : accessAnnotation.getValue();
    }

    private Access2_0Annotation getAccessAnnotation() {
        return (Access2_0Annotation)this.getAnnotation("javax.persistence.Access");
    }

    @Override
    public boolean typeIsSubTypeOf(String tn) {
        if (this.typeName == null) {
            return false;
        }
        return this.typeName.equals(tn) || this.typeInterfaceNames.contains(tn) || this.typeSuperclassNames.contains(tn);
    }

    @Override
    public boolean typeIsVariablePrimitive() {
        return this.typeName != null && ClassName.isVariablePrimitive((String)this.typeName);
    }

    private ITypeBinding getTypeBinding(CompilationUnit astRoot) {
        return ((Attribute)this.annotatedElement).getTypeBinding(astRoot);
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    private void syncModifiers(int astModifiers) {
        int old = this.modifiers;
        this.modifiers = astModifiers;
        this.firePropertyChanged("modifiers", old, astModifiers);
    }

    private int buildModifiers(CompilationUnit astRoot) {
        IBinding binding = ((Attribute)this.annotatedElement).getBinding(astRoot);
        return binding == null ? 0 : binding.getModifiers();
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    private void syncTypeName(String astTypeName) {
        String old = this.typeName;
        this.typeName = astTypeName;
        this.firePropertyChanged("typeName", old, astTypeName);
    }

    private String buildTypeName(ITypeBinding typeBinding) {
        String tbName;
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isTypeVariable()) {
            typeBinding = typeBinding.getErasure();
        }
        return (tbName = typeBinding.getTypeDeclaration().getQualifiedName()).length() == 0 ? null : tbName;
    }

    @Override
    public boolean typeIsInterface() {
        return this.typeIsInterface;
    }

    private void syncTypeIsInterface(boolean astTypeIsInterface) {
        boolean old = this.typeIsInterface;
        this.typeIsInterface = astTypeIsInterface;
        this.firePropertyChanged("typeIsInterface", old, astTypeIsInterface);
    }

    private boolean buildTypeIsInterface(ITypeBinding typeBinding) {
        return typeBinding != null && !typeBinding.isArray() && typeBinding.isInterface();
    }

    @Override
    public boolean typeIsEnum() {
        return this.typeIsEnum;
    }

    private void syncTypeIsEnum(boolean astTypeIsEnum) {
        boolean old = this.typeIsEnum;
        this.typeIsEnum = astTypeIsEnum;
        this.firePropertyChanged("typeIsEnum", old, astTypeIsEnum);
    }

    private boolean buildTypeIsEnum(ITypeBinding typeBinding) {
        return typeBinding != null && !typeBinding.isArray() && typeBinding.isEnum();
    }

    @Override
    public ListIterator<String> typeSuperclassNames() {
        return new CloneListIterator(this.typeSuperclassNames);
    }

    private void syncTypeSuperclassNames(List<String> astTypeSuperclassNames) {
        this.synchronizeList(astTypeSuperclassNames, this.typeSuperclassNames, "typeSuperclassNames");
    }

    private List<String> buildTypeSuperclassNames(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        typeBinding = typeBinding.getSuperclass();
        while (typeBinding != null) {
            names.add(typeBinding.getQualifiedName());
            typeBinding = typeBinding.getSuperclass();
        }
        return names;
    }

    @Override
    public Iterator<String> typeInterfaceNames() {
        return new CloneIterator(this.typeInterfaceNames);
    }

    private void syncTypeInterfaceNames(Collection<String> astTypeInterfaceNames) {
        this.synchronizeCollection(astTypeInterfaceNames, this.typeInterfaceNames, "typeInterfaceNames");
    }

    private Collection<String> buildTypeInterfaceNames(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>();
        while (typeBinding != null) {
            this.addInterfaceNamesTo(typeBinding, names);
            typeBinding = typeBinding.getSuperclass();
        }
        return names;
    }

    private void addInterfaceNamesTo(ITypeBinding typeBinding, HashSet<String> names) {
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding interfaceBinding = iTypeBindingArray[n2];
            names.add(interfaceBinding.getTypeDeclaration().getQualifiedName());
            this.addInterfaceNamesTo(interfaceBinding, names);
            ++n2;
        }
    }

    @Override
    public ListIterator<String> typeTypeArgumentNames() {
        return new CloneListIterator(this.typeTypeArgumentNames);
    }

    @Override
    public int typeTypeArgumentNamesSize() {
        return this.typeTypeArgumentNames.size();
    }

    @Override
    public String getTypeTypeArgumentName(int index) {
        return this.typeTypeArgumentNames.get(index);
    }

    private void syncTypeTypeArgumentNames(List<String> astTypeTypeArgumentNames) {
        this.synchronizeList(astTypeTypeArgumentNames, this.typeTypeArgumentNames, "typeTypeArgumentNames");
    }

    private List<String> buildTypeTypeArgumentNames(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return Collections.emptyList();
        }
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        if (typeArguments.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(typeArguments.length);
        ITypeBinding[] iTypeBindingArray = typeArguments;
        int n = typeArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeArgument = iTypeBindingArray[n2];
            if (typeArgument == null) {
                names.add(null);
            } else {
                ITypeBinding erasure = typeArgument.getErasure();
                names.add(erasure.getTypeDeclaration().getQualifiedName());
            }
            ++n2;
        }
        return names;
    }
}

