/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.EnumType;
import org.eclipse.jpt.jpa.core.context.EnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaEnumeratedConverter;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.AbstractJavaConverter;
import org.eclipse.jpt.jpa.core.resource.java.EnumeratedAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaEnumeratedConverter
extends AbstractJavaConverter
implements JavaEnumeratedConverter {
    protected final EnumeratedAnnotation enumeratedAnnotation;
    protected EnumType specifiedEnumType;
    protected EnumType defaultEnumType;

    public GenericJavaEnumeratedConverter(JavaAttributeMapping parent, EnumeratedAnnotation enumeratedAnnotation) {
        super(parent);
        this.enumeratedAnnotation = enumeratedAnnotation;
        this.specifiedEnumType = this.buildSpecifiedEnumType();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedEnumType_(this.buildSpecifiedEnumType());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultEnumType(this.buildDefaultEnumType());
    }

    @Override
    public EnumType getEnumType() {
        return this.specifiedEnumType != null ? this.specifiedEnumType : this.defaultEnumType;
    }

    @Override
    public EnumType getSpecifiedEnumType() {
        return this.specifiedEnumType;
    }

    @Override
    public void setSpecifiedEnumType(EnumType enumType) {
        this.enumeratedAnnotation.setValue(EnumType.toJavaResourceModel(enumType));
        this.setSpecifiedEnumType_(enumType);
    }

    protected void setSpecifiedEnumType_(EnumType enumType) {
        EnumType old = this.specifiedEnumType;
        this.specifiedEnumType = enumType;
        this.firePropertyChanged("specifiedEnumType", (Object)old, (Object)enumType);
    }

    protected EnumType buildSpecifiedEnumType() {
        return EnumType.fromJavaResourceModel(this.enumeratedAnnotation.getValue());
    }

    @Override
    public EnumType getDefaultEnumType() {
        return this.defaultEnumType;
    }

    protected void setDefaultEnumType(EnumType enumType) {
        EnumType old = this.defaultEnumType;
        this.defaultEnumType = enumType;
        this.firePropertyChanged("defaultEnumType", (Object)old, (Object)enumType);
    }

    protected EnumType buildDefaultEnumType() {
        return DEFAULT_ENUM_TYPE;
    }

    @Override
    public Class<? extends Converter> getType() {
        return EnumeratedConverter.class;
    }

    @Override
    protected String getAnnotationName() {
        return "javax.persistence.Enumerated";
    }

    @Override
    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        return this.enumeratedAnnotation.getTextRange(astRoot);
    }
}

