/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

class CodeAssistFavoritesConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_FAVORITE_STATIC_MEMBERS = CodeAssistFavoritesConfigurationBlock.getJDTUIKey("content_assist_favorite_static_members");
    private static final String WILDCARD = ".*";
    private static final int IDX_NEW_TYPE = 0;
    private static final int IDX_NEW_MEMBER = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 3;
    private ListDialogField fList;

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_CODEASSIST_FAVORITE_STATIC_MEMBERS};
    }

    public CodeAssistFavoritesConfigurationBlock(IStatusChangeListener statusListener, IWorkbenchPreferenceContainer workbenchcontainer) {
        super(statusListener, null, CodeAssistFavoritesConfigurationBlock.getAllKeys(), workbenchcontainer);
    }

    protected Control createContents(Composite parent) {
        ScrolledPageContent scrolled = new ScrolledPageContent(parent, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        Composite control = new Composite((Composite)scrolled, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        control.setLayout((Layout)layout);
        this.createFavoriteList(control);
        this.initialize();
        scrolled.setContent((Control)control);
        Point size = control.computeSize(-1, -1);
        scrolled.setMinSize(size.x, size.y);
        Dialog.applyDialogFont((Control)scrolled);
        return scrolled;
    }

    private void createFavoriteList(Composite parent) {
        String[] buttonLabels = new String[]{PreferencesMessages.CodeAssistStaticMembersConfigurationBlock_newType_button, PreferencesMessages.CodeAssistStaticMembersConfigurationBlock_newMember_button, PreferencesMessages.CodeAssistStaticMembersConfigurationBlock_edit_button, PreferencesMessages.CodeAssistStaticMembersConfigurationBlock_remove_button};
        ListAdapter adapter = new ListAdapter();
        this.fList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)new ListLabelProvider());
        this.fList.setDialogFieldListener(adapter);
        this.fList.setLabelText(PreferencesMessages.CodeAssistStaticMembersConfigurationBlock_description);
        this.fList.setRemoveButtonIndex(3);
        this.fList.enableButton(2, false);
        this.fList.setViewerComparator(new ViewerComparator());
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        this.fList.doFillIntoGrid(parent, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fList.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fList.getLabelControl(null), pixelConverter.convertWidthInCharsToPixels(60));
        LayoutUtil.setHorizontalGrabbing(this.fList.getListControl(null));
        Control listControl = this.fList.getListControl(null);
        GridData gd = (GridData)listControl.getLayoutData();
        gd.verticalAlignment = 1;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(7);
    }

    public void initialize() {
        this.initializeFields();
    }

    private void initializeFields() {
        this.fList.setElements(Arrays.asList(this.getFavoriteStaticMembersPreference()));
    }

    public void performDefaults() {
        super.performDefaults();
        this.initializeFields();
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    protected void validateSettings(OptionsConfigurationBlock.Key key, String oldValue, String newValue) {
    }

    protected void setControlEnabled(OptionsConfigurationBlock.Key key, boolean enabled) {
        Control control = this.getControl(key);
        control.setEnabled(enabled);
        Label label = (Label)this.fLabels.get(control);
        if (label != null) {
            label.setEnabled(enabled);
        }
    }

    private Control getControl(OptionsConfigurationBlock.Key key) {
        OptionsConfigurationBlock.ControlData data;
        Control curr;
        int i = this.fComboBoxes.size() - 1;
        while (i >= 0) {
            curr = (Control)this.fComboBoxes.get(i);
            data = (OptionsConfigurationBlock.ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        i = this.fCheckBoxes.size() - 1;
        while (i >= 0) {
            curr = (Control)this.fCheckBoxes.get(i);
            data = (OptionsConfigurationBlock.ControlData)curr.getData();
            if (key.equals(data.getKey())) {
                return curr;
            }
            --i;
        }
        i = this.fTextBoxes.size() - 1;
        while (i >= 0) {
            curr = (Control)this.fTextBoxes.get(i);
            OptionsConfigurationBlock.Key currKey = (OptionsConfigurationBlock.Key)curr.getData();
            if (key.equals(currKey)) {
                return curr;
            }
            --i;
        }
        return null;
    }

    private void doButtonPressed(int index) {
        if (index == 0 || index == 1) {
            List existing = this.fList.getElements();
            FavoriteStaticMemberInputDialog dialog = new FavoriteStaticMemberInputDialog(this.getShell(), existing, index == 1);
            if (dialog.open() == 0) {
                this.fList.addElement(dialog.getResult());
            }
        } else if (index == 2) {
            List selected = this.fList.getSelectedElements();
            if (selected.isEmpty()) {
                return;
            }
            String editedEntry = (String)selected.get(0);
            List existing = this.fList.getElements();
            existing.remove(editedEntry);
            boolean isType = editedEntry.endsWith(WILDCARD);
            FavoriteStaticMemberInputDialog dialog = new FavoriteStaticMemberInputDialog(this.getShell(), existing, !isType);
            if (isType) {
                dialog.setInitialSelection(editedEntry.substring(0, editedEntry.length() - 2));
            } else {
                dialog.setInitialSelection(editedEntry);
            }
            if (dialog.open() == 0) {
                this.fList.replaceElement(editedEntry, dialog.getResult());
            }
        }
    }

    protected final void doDialogFieldChanged(DialogField field) {
        if (field == this.fList) {
            this.setValue(PREF_CODEASSIST_FAVORITE_STATIC_MEMBERS, CodeAssistFavoritesConfigurationBlock.serializeFavorites(this.fList.getElements()));
        }
    }

    private String[] getFavoriteStaticMembersPreference() {
        String str = this.getValue(PREF_CODEASSIST_FAVORITE_STATIC_MEMBERS);
        if (str != null && str.length() > 0) {
            return CodeAssistFavoritesConfigurationBlock.deserializeFavorites(str);
        }
        return new String[0];
    }

    private static String[] deserializeFavorites(String str) {
        return str.split(";");
    }

    private static String serializeFavorites(List favorites) {
        int size = favorites.size();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < size) {
            buf.append((String)favorites.get(i));
            if (i < size - 1) {
                buf.append(';');
            }
            ++i;
        }
        return buf.toString();
    }

    private static class FavoriteStaticMemberInputDialog
    extends StatusDialog {
        private StringButtonDialogField fNameDialogField;
        private List fExistingEntries;
        private final boolean fIsEditingMember;

        public FavoriteStaticMemberInputDialog(Shell parent, List existingEntries, boolean isEditingMember) {
            super(parent);
            String label;
            String title;
            this.fIsEditingMember = isEditingMember;
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.fExistingEntries = existingEntries;
            if (isEditingMember) {
                title = PreferencesMessages.FavoriteStaticMemberInputDialog_member_title;
                label = PreferencesMessages.FavoriteStaticMemberInputDialog_member_labelText;
            } else {
                title = PreferencesMessages.FavoriteStaticMemberInputDialog_type_title;
                label = PreferencesMessages.FavoriteStaticMemberInputDialog_type_labelText;
            }
            this.setTitle(title);
            StringButtonAdapter adapter = new StringButtonAdapter();
            this.fNameDialogField = new StringButtonDialogField(adapter);
            this.fNameDialogField.setLabelText(label);
            this.fNameDialogField.setButtonLabel(PreferencesMessages.FavoriteStaticMemberInputDialog_browse_button);
            this.fNameDialogField.setDialogFieldListener(adapter);
            this.fNameDialogField.setText("");
        }

        public void setInitialSelection(String editedEntry) {
            Assert.isNotNull((Object)editedEntry);
            if (editedEntry.length() == 0) {
                this.fNameDialogField.setText("");
            } else {
                this.fNameDialogField.setText(editedEntry);
            }
        }

        public String getResult() {
            String val = this.fNameDialogField.getText();
            if (!this.fIsEditingMember) {
                val = String.valueOf(val) + CodeAssistFavoritesConfigurationBlock.WILDCARD;
            }
            return val;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.initializeDialogUnits((Control)parent);
            GridLayout layout = (GridLayout)composite.getLayout();
            layout.numColumns = 2;
            this.fNameDialogField.doFillIntoGrid(composite, 3);
            this.fNameDialogField.getChangeControl(null).setVisible(!this.fIsEditingMember);
            LayoutUtil.setHorizontalSpan((Control)this.fNameDialogField.getLabelControl(null), 2);
            int fieldWidthHint = this.convertWidthInCharsToPixels(60);
            Text text = this.fNameDialogField.getTextControl(null);
            LayoutUtil.setWidthHint((Control)text, fieldWidthHint);
            LayoutUtil.setHorizontalGrabbing((Control)text);
            LayoutUtil.setHorizontalSpan((Control)text, this.fIsEditingMember ? 2 : 1);
            TextFieldNavigationHandler.install(text);
            DialogField.createEmptySpace(composite, 1);
            this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
            FavoriteStaticMemberInputDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void doBrowseTypes() {
            BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
            IJavaScriptSearchScope scope = SearchEngine.createWorkspaceScope();
            int style = 256;
            try {
                SelectionDialog dialog = JavaScriptUI.createTypeDialog(this.getShell(), context, scope, style, false, this.fNameDialogField.getText());
                dialog.setTitle(PreferencesMessages.FavoriteStaticMemberInputDialog_ChooseTypeDialog_title);
                dialog.setMessage(PreferencesMessages.FavoriteStaticMemberInputDialog_ChooseTypeDialog_description);
                if (dialog.open() == 0) {
                    IType res = (IType)dialog.getResult()[0];
                    this.fNameDialogField.setText(res.getFullyQualifiedName('.'));
                }
            }
            catch (JavaScriptModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), PreferencesMessages.FavoriteStaticMemberInputDialog_ChooseTypeDialog_title, PreferencesMessages.FavoriteStaticMemberInputDialog_ChooseTypeDialog_error_message);
            }
        }

        void doDialogFieldChanged(DialogField field) {
            this.doValidation();
        }

        private void doValidation() {
            StatusInfo status = new StatusInfo();
            String newText = this.fNameDialogField.getText();
            if (newText.length() == 0) {
                status.setError("");
            } else {
                IStatus val = JavaScriptConventions.validateJavaScriptTypeName((String)newText, (String)"1.3", (String)"1.3");
                if (val.matches(4)) {
                    if (this.fIsEditingMember) {
                        status.setError(PreferencesMessages.FavoriteStaticMemberInputDialog_error_invalidMemberName);
                    } else {
                        status.setError(PreferencesMessages.FavoriteStaticMemberInputDialog_error_invalidTypeName);
                    }
                } else if (this.doesExist(newText, this.fIsEditingMember)) {
                    status.setError(PreferencesMessages.FavoriteStaticMemberInputDialog_error_entryExists);
                }
            }
            this.updateStatus(status);
        }

        private boolean doesExist(String name, boolean isStatic) {
            int i = 0;
            while (i < this.fExistingEntries.size()) {
                String entry = (String)this.fExistingEntries.get(i);
                if (name.equals(entry)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.wst.jsdt.ui.java_editor_preference_page_context");
        }

        private class StringButtonAdapter
        implements IDialogFieldListener,
        IStringButtonAdapter {
            private StringButtonAdapter() {
            }

            public void dialogFieldChanged(DialogField field) {
                FavoriteStaticMemberInputDialog.this.doDialogFieldChanged(field);
            }

            public void changeControlPressed(DialogField field) {
                FavoriteStaticMemberInputDialog.this.doBrowseTypes();
            }
        }
    }

    private class ListAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ListAdapter() {
        }

        private boolean canEdit(ListDialogField field) {
            List selected = field.getSelectedElements();
            return selected.size() == 1;
        }

        public void customButtonPressed(ListDialogField field, int index) {
            CodeAssistFavoritesConfigurationBlock.this.doButtonPressed(index);
        }

        public void selectionChanged(ListDialogField field) {
            CodeAssistFavoritesConfigurationBlock.this.fList.enableButton(2, this.canEdit(field));
        }

        public void dialogFieldChanged(DialogField field) {
            CodeAssistFavoritesConfigurationBlock.this.doDialogFieldChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field)) {
                CodeAssistFavoritesConfigurationBlock.this.doButtonPressed(2);
            }
        }
    }

    private static class ListLabelProvider
    extends LabelProvider {
        public final Image MEMBER_ICON = JavaElementImageProvider.getDecoratedImage(JavaPluginImages.DESC_MISC_PUBLIC, 0, JavaElementImageProvider.SMALL_SIZE);
        private final Image CLASS_ICON = JavaElementImageProvider.getDecoratedImage(JavaPluginImages.DESC_OBJS_CLASS, 0, JavaElementImageProvider.SMALL_SIZE);

        public Image getImage(Object element) {
            return ((String)element).endsWith(CodeAssistFavoritesConfigurationBlock.WILDCARD) ? this.CLASS_ICON : this.MEMBER_ICON;
        }

        public String getText(Object element) {
            return (String)element;
        }
    }
}

