/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.packageview.JsGlobalScopeContainer;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;

public class ConfigureContainerAction
implements IObjectActionDelegate {
    private ISelection fCurrentSelection;
    private IWorkbenchPart fPart;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }

    public void run(IAction action) {
        if (this.fCurrentSelection instanceof IStructuredSelection) {
            CommonViewer viewer;
            JsGlobalScopeContainer container = (JsGlobalScopeContainer)((IStructuredSelection)this.fCurrentSelection).getFirstElement();
            this.openWizard(container.getClasspathEntry(), container.getLabel(), container.getJavaProject());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.StructuredViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (CommonViewer)this.fPart.getAdapter((Class)clazz)) == null) {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ui.navigator.CommonViewer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                viewer = (CommonViewer)this.fPart.getAdapter((Class)clazz2);
            }
            if (viewer != null) {
                TreePath[] expanded = null;
                if (viewer instanceof AbstractTreeViewer) {
                    expanded = ((AbstractTreeViewer)viewer).getExpandedTreePaths();
                }
                viewer.refresh((Object)container.getJavaProject().getProject(), true);
                if (expanded != null && viewer instanceof AbstractTreeViewer) {
                    ((AbstractTreeViewer)viewer).setExpandedTreePaths(expanded);
                }
            }
        }
    }

    private void openWizard(IIncludePathEntry entry, String label, final IJavaScriptProject project) {
        Shell shell = this.fPart.getSite().getShell();
        try {
            IIncludePathEntry[] entries = project.getRawIncludepath();
            IIncludePathEntry result = BuildPathDialogAccess.configureContainerEntry(shell, entry, project, entries);
            if (result == null || result.equals(entry)) {
                return;
            }
            int idx = ConfigureContainerAction.indexInClasspath(entries, entry);
            if (idx == -1) {
                return;
            }
            final IIncludePathEntry[] newEntries = new IIncludePathEntry[entries.length];
            System.arraycopy(entries, 0, newEntries, 0, entries.length);
            newEntries[idx] = result;
            IWorkbenchWindow context = this.fPart.getSite().getWorkbenchWindow();
            if (context == null) {
                context = PlatformUI.getWorkbench().getProgressService();
            }
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        project.setRawIncludepath(newEntries, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (JavaScriptModelException e) {
            String title = ActionMessages.ConfigureContainerAction_error_title;
            String message = ActionMessages.ConfigureContainerAction_error_creationfailed_message;
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, message);
        }
        catch (InvocationTargetException e) {
            String title = ActionMessages.ConfigureContainerAction_error_title;
            String message = ActionMessages.ConfigureContainerAction_error_applyingfailed_message;
            ExceptionHandler.handle(e, shell, title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected static int indexInClasspath(IIncludePathEntry[] entries, IIncludePathEntry entry) {
        int i = 0;
        while (i < entries.length) {
            if (entries[i] == entry) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fCurrentSelection = selection;
    }
}

