/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.StringTools;

public abstract class AbstractAnnotationAdapter
implements AnnotationAdapter {
    private final AnnotatedElement annotatedElement;
    private final DeclarationAnnotationAdapter daa;

    public AbstractAnnotationAdapter(AnnotatedElement annotatedElement, DeclarationAnnotationAdapter daa) {
        this.annotatedElement = annotatedElement;
        this.daa = daa;
    }

    public Annotation getAnnotation(CompilationUnit astRoot) {
        return this.daa.getAnnotation(this.annotatedElement.getModifiedDeclaration(astRoot));
    }

    public void newMarkerAnnotation() {
        this.edit(this.buildNewMarkerAnnotationEditor());
    }

    public void newSingleMemberAnnotation() {
        this.edit(this.buildNewSingleMemberAnnotationEditor());
    }

    public void newNormalAnnotation() {
        this.edit(this.buildNewNormalAnnotationEditor());
    }

    public void removeAnnotation() {
        this.edit(this.buildRemoveAnnotationEditor());
    }

    public ASTNode getAstNode(CompilationUnit astRoot) {
        return this.daa.getAstNode(this.annotatedElement.getModifiedDeclaration(astRoot));
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.daa);
    }

    protected void edit(AnnotatedElement.Editor editor) {
        this.annotatedElement.edit(editor);
    }

    protected AnnotatedElement.Editor buildNewMarkerAnnotationEditor() {
        return new NewMarkerAnnotationEditor(this.daa);
    }

    protected AnnotatedElement.Editor buildNewSingleMemberAnnotationEditor() {
        return new NewSingleMemberAnnotationEditor(this.daa);
    }

    protected AnnotatedElement.Editor buildNewNormalAnnotationEditor() {
        return new NewNormalAnnotationEditor(this.daa);
    }

    protected AnnotatedElement.Editor buildRemoveAnnotationEditor() {
        return new RemoveAnnotationEditor(this.daa);
    }

    protected static class NewMarkerAnnotationEditor
    implements AnnotatedElement.Editor {
        private final DeclarationAnnotationAdapter daa;

        NewMarkerAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.daa.newMarkerAnnotation(declaration);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    protected static class NewNormalAnnotationEditor
    implements AnnotatedElement.Editor {
        private final DeclarationAnnotationAdapter daa;

        NewNormalAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.daa.newNormalAnnotation(declaration);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    protected static class NewSingleMemberAnnotationEditor
    implements AnnotatedElement.Editor {
        private final DeclarationAnnotationAdapter daa;

        NewSingleMemberAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.daa.newSingleMemberAnnotation(declaration);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    protected static class RemoveAnnotationEditor
    implements AnnotatedElement.Editor {
        private final DeclarationAnnotationAdapter daa;

        RemoveAnnotationEditor(DeclarationAnnotationAdapter daa) {
            this.daa = daa;
        }

        public void edit(ModifiedDeclaration declaration) {
            this.daa.removeAnnotation(declaration);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

