/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.core.internal.resource.ModuleResourceLocator;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WebModuleResourceLocator
extends ModuleResourceLocator {
    protected static IPath WEB_INF_CLASSES_PATH = new Path("WEB-INF/classes");

    public IContainer getDefaultResourceLocation(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        return component.getRootFolder().getFolder(WEB_INF_CLASSES_PATH.append(META_INF_PATH)).getUnderlyingFolder();
    }

    public IPath getResourcePath(IProject project, IPath runtimePath) {
        return super.getResourcePath(project, WEB_INF_CLASSES_PATH.append(runtimePath));
    }

    public IPath getRuntimePath(IProject project, IPath resourcePath) {
        IPath runtimePath = super.getRuntimePath(project, resourcePath);
        if (WEB_INF_CLASSES_PATH.isPrefixOf(runtimePath)) {
            return runtimePath.makeRelativeTo(WEB_INF_CLASSES_PATH);
        }
        return runtimePath;
    }
}

