/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.jpt.common.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.common.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.AspectChangeSupport;
import org.eclipse.jpt.common.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.common.utility.internal.node.DefaultProblem;
import org.eclipse.jpt.common.utility.internal.node.Node;
import org.eclipse.jpt.common.utility.internal.node.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNode
extends AbstractModel
implements Node {
    private Node parent;
    private volatile boolean dirty;
    private volatile boolean dirtyBranch;
    private Vector<Problem> problems;
    private static final Object[] EMPTY_PROBLEM_MESSAGE_ARGUMENTS = new Object[0];
    private Vector<Problem> branchProblems;
    private volatile String comment;
    private static final HashMap<Class<? extends AbstractNode>, HashSet<String>> transientAspectNameSets = new HashMap();
    private static final HashMap<Class<? extends AbstractNode>, HashSet<String>> nonValidatedAspectNameSets = new HashMap();

    protected AbstractNode(Node parent) {
        this.initialize();
        this.initialize(parent);
    }

    protected void initialize() {
        this.comment = "";
        this.dirty = true;
        this.dirtyBranch = true;
        this.problems = new Vector();
        this.branchProblems = new Vector();
    }

    protected void initialize(Node parentNode) {
        this.checkParent(parentNode);
        this.parent = parentNode;
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new AspectChangeSupport(this, this.buildChangeSupportListener());
    }

    protected AspectChangeSupport.Listener buildChangeSupportListener() {
        return new AspectChangeSupport.Listener(){

            public void aspectChanged(String aspectName) {
                AbstractNode.this.aspectChanged(aspectName);
            }
        };
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    protected void checkParent(Node parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException("The parent node cannot be null");
        }
    }

    @Override
    public final Iterator<Node> children() {
        ArrayList<Node> children = new ArrayList<Node>();
        this.addChildrenTo(children);
        return children.iterator();
    }

    protected void addChildrenTo(List<Node> list) {
    }

    @Override
    public Node root() {
        Node p = this.parent;
        return p == null ? this : p.root();
    }

    @Override
    public boolean isDescendantOf(Node node) {
        return this == node || this.parentIsDescendantOf(node);
    }

    protected boolean parentIsDescendantOf(Node node) {
        return this.parent != null && this.parent.isDescendantOf(node);
    }

    public Iterator<Node.Reference> branchReferences() {
        ArrayList<Node.Reference> branchReferences = new ArrayList<Node.Reference>(1000);
        this.addBranchReferencesTo(branchReferences);
        return branchReferences.iterator();
    }

    @Override
    public void addBranchReferencesTo(Collection<Node.Reference> branchReferences) {
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.addBranchReferencesTo(branchReferences);
        }
    }

    public Iterator<Node> allNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>(1000);
        this.addAllNodesTo(nodes);
        return nodes.iterator();
    }

    @Override
    public void addAllNodesTo(Collection<Node> nodes) {
        nodes.add(this);
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.addAllNodesTo(nodes);
        }
    }

    @Override
    public void nodeRemoved(Node node) {
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.nodeRemoved(node);
        }
    }

    protected boolean nodeIsDescendantOf(Node node1, Node node2) {
        return node1 != null && node1.isDescendantOf(node2);
    }

    @Override
    public void nodeRenamed(Node node) {
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.nodeRenamed(node);
        }
    }

    @Override
    public final String comment() {
        return this.comment;
    }

    @Override
    public final void setComment(String comment) {
        String old = this.comment;
        this.comment = comment;
        this.firePropertyChanged("comment", old, comment);
    }

    protected void aspectChanged(String aspectName) {
        if (this.aspectIsPersistent(aspectName)) {
            this.markDirty();
        }
        if (this.aspectChangeRequiresValidation(aspectName)) {
            this.validate();
        }
    }

    protected void validate() {
        this.getValidator().validate();
    }

    @Override
    public Node.Validator getValidator() {
        if (this.parent == null) {
            throw new IllegalStateException("This node should not be firing change events during its construction.");
        }
        return this.parent.getValidator();
    }

    @Override
    public void setValidator(Node.Validator validator) {
        if (this.parent == null) {
            throw new IllegalStateException("This root node should implement #setValidator(Node.Validator).");
        }
        throw new UnsupportedOperationException("Only root nodes implement #setValidator(Node.Validator).");
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public final boolean isDirtyBranch() {
        return this.dirtyBranch;
    }

    public final boolean isClean() {
        return !this.dirty;
    }

    public final boolean isCleanBranch() {
        return !this.dirtyBranch;
    }

    private void setIsDirtyBranch(boolean dirtyBranch) {
        boolean old = this.dirtyBranch;
        this.dirtyBranch = dirtyBranch;
        this.firePropertyChanged("dirtyBranch", old, dirtyBranch);
    }

    private void markDirty() {
        this.dirty = true;
        this.markBranchDirty();
    }

    @Override
    public void markBranchDirty() {
        if (this.dirtyBranch) {
            return;
        }
        this.setIsDirtyBranch(true);
        this.markParentBranchDirty();
    }

    protected void markParentBranchDirty() {
        if (this.parent != null) {
            this.parent.markBranchDirty();
        }
    }

    @Override
    public final void markEntireBranchDirty() {
        this.markDirty();
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.markEntireBranchDirty();
        }
    }

    public final void markEntireBranchClean() {
        this.cascadeMarkEntireBranchClean();
        this.markParentBranchCleanIfPossible();
    }

    protected void markParentBranchCleanIfPossible() {
        if (this.parent != null) {
            this.parent.markBranchCleanIfPossible();
        }
    }

    @Override
    public final void cascadeMarkEntireBranchClean() {
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.cascadeMarkEntireBranchClean();
        }
        this.dirty = false;
        this.setIsDirtyBranch(false);
    }

    @Override
    public final void markBranchCleanIfPossible() {
        if (this.dirty) {
            return;
        }
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            if (!child.isDirtyBranch()) continue;
            return;
        }
        this.setIsDirtyBranch(false);
        this.markParentBranchCleanIfPossible();
    }

    private boolean aspectIsPersistent(String aspectName) {
        return !this.aspectIsTransient(aspectName);
    }

    private boolean aspectIsTransient(String aspectName) {
        return this.transientAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<String> transientAspectNames() {
        HashMap<Class<? extends AbstractNode>, HashSet<String>> hashMap = transientAspectNameSets;
        synchronized (hashMap) {
            HashSet<String> transientAspectNames = transientAspectNameSets.get(this.getClass());
            if (transientAspectNames == null) {
                transientAspectNames = new HashSet();
                this.addTransientAspectNamesTo(transientAspectNames);
                transientAspectNameSets.put(this.getClass(), transientAspectNames);
            }
            return transientAspectNames;
        }
    }

    protected void addTransientAspectNamesTo(Set<String> transientAspectNames) {
        transientAspectNames.add("dirtyBranch");
        transientAspectNames.add("branchProblems");
        transientAspectNames.add("hasBranchProblems");
    }

    public final Iterator<Node> allDirtyNodes() {
        return new FilteringIterator<Node>(this.allNodes()){

            @Override
            protected boolean accept(Node node) {
                return node instanceof AbstractNode && ((AbstractNode)node).isDirty();
            }
        };
    }

    public final Iterator<Problem> problems() {
        return new CloneIterator<Problem>(this.problems);
    }

    public final int problemsSize() {
        return this.problems.size();
    }

    public final boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    @Override
    public final ListIterator<Problem> branchProblems() {
        return new CloneListIterator<Problem>(this.branchProblems);
    }

    @Override
    public final int branchProblemsSize() {
        return this.branchProblems.size();
    }

    @Override
    public final boolean hasBranchProblems() {
        return !this.branchProblems.isEmpty();
    }

    @Override
    public final boolean containsBranchProblem(Problem problem) {
        return this.branchProblems.contains(problem);
    }

    protected final Problem buildProblem(String messageKey, int messageType, Object ... messageArguments) {
        return new DefaultProblem(this, messageKey, messageType, messageArguments);
    }

    protected final Problem buildProblem(String messageKey, int messageType) {
        return this.buildProblem(messageKey, messageType, EMPTY_PROBLEM_MESSAGE_ARGUMENTS);
    }

    @Override
    public void validateBranch() {
        if (this.validateBranchInternal()) {
            this.rebuildParentBranchProblems();
        }
    }

    protected void rebuildParentBranchProblems() {
        if (this.parent != null) {
            this.parent.rebuildBranchProblems();
        }
    }

    @Override
    public boolean validateBranchInternal() {
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.validateBranchInternal();
        }
        this.problems.clear();
        this.addProblemsTo(this.problems);
        return this.checkBranchProblems();
    }

    protected void addProblemsTo(List<Problem> currentProblems) {
    }

    private boolean checkBranchProblems() {
        Vector<Problem> oldBranchProblems = new Vector<Problem>(this.branchProblems);
        int oldSize = this.branchProblems.size();
        this.branchProblems.clear();
        this.branchProblems.addAll(this.problems);
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.addBranchProblemsTo(this.branchProblems);
        }
        int newSize = this.branchProblems.size();
        if (oldSize == 0 && newSize != 0) {
            this.firePropertyChanged("hasBranchProblems", false, true);
        } else if (oldSize != 0 && newSize == 0) {
            this.firePropertyChanged("hasBranchProblems", true, false);
        }
        if (oldBranchProblems.equals(this.branchProblems)) {
            return false;
        }
        this.fireListChanged("branchProblems", this.branchProblems);
        return true;
    }

    @Override
    public final void addBranchProblemsTo(List<Problem> list) {
        list.addAll(this.branchProblems);
    }

    @Override
    public final void rebuildBranchProblems() {
        if (!this.checkBranchProblems()) {
            throw new IllegalStateException("we should not get here unless our \"branch\" problems have changed");
        }
        this.rebuildParentBranchProblems();
    }

    @Override
    public final void clearAllBranchProblems() {
        if (this.clearAllBranchProblemsInternal()) {
            this.rebuildParentBranchProblems();
        }
    }

    @Override
    public final boolean clearAllBranchProblemsInternal() {
        if (this.branchProblems.isEmpty()) {
            return false;
        }
        Iterator<Node> stream = this.children();
        while (stream.hasNext()) {
            Node child = stream.next();
            child.clearAllBranchProblemsInternal();
        }
        this.problems.clear();
        this.branchProblems.clear();
        this.firePropertyChanged("hasBranchProblems", true, false);
        this.fireListChanged("branchProblems", this.branchProblems);
        return true;
    }

    private boolean aspectChangeRequiresValidation(String aspectName) {
        return !this.aspectChangeDoesNotRequireValidation(aspectName);
    }

    private boolean aspectChangeDoesNotRequireValidation(String aspectName) {
        return this.nonValidatedAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<String> nonValidatedAspectNames() {
        HashMap<Class<? extends AbstractNode>, HashSet<String>> hashMap = nonValidatedAspectNameSets;
        synchronized (hashMap) {
            HashSet<String> nonValidatedAspectNames = nonValidatedAspectNameSets.get(this.getClass());
            if (nonValidatedAspectNames == null) {
                nonValidatedAspectNames = new HashSet();
                this.addNonValidatedAspectNamesTo(nonValidatedAspectNames);
                nonValidatedAspectNameSets.put(this.getClass(), nonValidatedAspectNames);
            }
            return nonValidatedAspectNames;
        }
    }

    protected void addNonValidatedAspectNamesTo(Set<String> nonValidatedAspectNames) {
        nonValidatedAspectNames.add("comment");
        nonValidatedAspectNames.add("dirtyBranch");
        nonValidatedAspectNames.add("branchProblems");
        nonValidatedAspectNames.add("hasBranchProblems");
    }

    @Override
    public final String toString() {
        return super.toString();
    }
}

