/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterators;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> iterator;
    private final Object mutex;

    public SynchronizedIterator(Iterable<? extends E> iterable) {
        this(iterable.iterator());
    }

    public SynchronizedIterator(Iterable<? extends E> iterable, Object mutex) {
        this(iterable.iterator(), mutex);
    }

    public SynchronizedIterator(Iterator<? extends E> iterator) {
        this.iterator = iterator;
        this.mutex = this;
    }

    public SynchronizedIterator(Iterator<? extends E> iterator, Object mutex) {
        this.iterator = iterator;
        this.mutex = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasNext() {
        Object object = this.mutex;
        synchronized (object) {
            return this.iterator.hasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized E next() {
        Object object = this.mutex;
        synchronized (object) {
            return this.iterator.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void remove() {
        Object object = this.mutex;
        synchronized (object) {
            this.iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return StringTools.buildToStringFor(this, this.iterator);
        }
    }
}

