/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.JavaPackageCompletionProcessor;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jpt.common.ui.JptCommonUiPlugin;
import org.eclipse.jpt.common.ui.internal.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.listeners.SWTPropertyChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.widgets.ChooserPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackageChooserPane<T extends Model>
extends ChooserPane<T> {
    private JavaPackageCompletionProcessor javaPackageCompletionProcessor;
    private PropertyChangeListener subjectChangeListener;

    public PackageChooserPane(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    public PackageChooserPane(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.javaPackageCompletionProcessor = new JavaPackageCompletionProcessor((ILabelProvider)new JavaElementLabelProvider(64));
        this.subjectChangeListener = this.buildSubjectChangeListener();
        this.getSubjectHolder().addPropertyChangeListener("value", this.subjectChangeListener);
        this.packageChooserSubjectChanged(this.getSubject());
    }

    private PropertyChangeListener buildSubjectChangeListener() {
        return new SWTPropertyChangeListenerWrapper(this.buildSubjectChangeListener_());
    }

    private PropertyChangeListener buildSubjectChangeListener_() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                PackageChooserPane.this.packageChooserSubjectChanged((Model)e.getNewValue());
            }
        };
    }

    protected void packageChooserSubjectChanged(T newSubject) {
        IPackageFragmentRoot root = null;
        if (newSubject != null) {
            root = this.getPackageFragmentRoot();
        }
        this.javaPackageCompletionProcessor.setPackageFragmentRoot(root);
    }

    @Override
    protected final Runnable buildBrowseAction() {
        return new Runnable(){

            public void run() {
                PackageChooserPane.this.promptPackage();
            }
        };
    }

    @Override
    protected Control addMainControl(Composite container) {
        Composite subPane = this.addSubPane(container);
        Text text = this.addText(subPane, this.buildTextHolder());
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage();
        GridData data = new GridData(768);
        data.horizontalIndent = image.getBounds().width;
        text.setLayoutData((Object)data);
        ControlContentAssistHelper.createTextContentAssistant((Text)text, (IContentAssistProcessor)this.javaPackageCompletionProcessor);
        return subPane;
    }

    protected abstract WritablePropertyValueModel<String> buildTextHolder();

    protected IPackageFragment choosePackage() {
        SelectionDialog selectionDialog;
        try {
            selectionDialog = JavaUI.createPackageDialog((Shell)this.getShell(), (IPackageFragmentRoot)this.getPackageFragmentRoot());
        }
        catch (JavaModelException e) {
            JptCommonUiPlugin.log(e);
            return null;
        }
        selectionDialog.setTitle(JptCommonUiMessages.PackageChooserPane_dialogTitle);
        selectionDialog.setMessage(JptCommonUiMessages.PackageChooserPane_dialogMessage);
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            selectionDialog.setInitialSelections(new Object[]{pack});
        }
        if (selectionDialog.open() == 0) {
            return (IPackageFragment)selectionDialog.getResult()[0];
        }
        return null;
    }

    protected abstract IJavaProject getJavaProject();

    protected abstract String getPackageName();

    protected void promptPackage() {
        IPackageFragment packageFragment = this.choosePackage();
        if (packageFragment != null) {
            String packageName = packageFragment.getElementName();
            this.setPackageName(packageName);
        }
    }

    protected abstract void setPackageName(String var1);

    private IPackageFragment getPackageFragment() {
        String packageName = this.getPackageName();
        if (packageName == null) {
            return null;
        }
        return this.getPackageFragmentRoot().getPackageFragment(packageName);
    }

    protected IPackageFragmentRoot getPackageFragmentRoot() {
        try {
            return this.getJavaProject().getPackageFragmentRoots()[0];
        }
        catch (JavaModelException ex) {
            JptCommonUiPlugin.log(ex);
            return null;
        }
    }

    @Override
    public void dispose() {
        this.getSubjectHolder().removePropertyChangeListener("value", this.subjectChangeListener);
        super.dispose();
    }
}

