/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jpt.common.ui.internal.listeners.SWTCollectionChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.listeners.SWTListChangeListenerWrapper;
import org.eclipse.jpt.common.ui.internal.swt.ColumnAdapter;
import org.eclipse.jpt.common.ui.internal.swt.TableItemModelAdapter;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritableCollectionValueModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableModelAdapter<E> {
    protected final ListValueModel<E> listHolder;
    protected final ListChangeListener listChangeListener;
    protected final CollectionValueModel<E> selectedItemsHolder;
    protected final CollectionChangeListener selectedItemsChangeListener;
    protected final Table table;
    protected final SelectionListener tableSelectionListener;
    protected final ListenerList<SelectionChangeListener<E>> selectionChangeListenerList;
    protected final ListenerList<DoubleClickListener<E>> doubleClickListenerList;
    protected final DisposeListener tableDisposeListener;
    protected final ITableLabelProvider labelProvider;
    private ColumnAdapter<E> columnAdapter;
    private List<TableItemModelAdapter> tableItemModelAdapters;

    public static <T> TableModelAdapter<T> adapt(ListValueModel<T> listHolder, PropertyValueModel<T> selectedItemHolder, Table table, ColumnAdapter<T> columnAdapter, ITableLabelProvider labelProvider) {
        return new TableModelAdapter<T>(listHolder, new PropertyCollectionValueModelAdapter(selectedItemHolder), table, columnAdapter, labelProvider);
    }

    public static <T> TableModelAdapter<T> adapt(ListValueModel<T> listHolder, WritableCollectionValueModel<T> selectionModel, Table table, ColumnAdapter<T> columnAdapter, ITableLabelProvider labelProvider) {
        TableModelAdapter<T> adapter = new TableModelAdapter<T>(listHolder, selectionModel, table, columnAdapter, labelProvider);
        adapter.addSelectionChangeListener(TableModelAdapter.buildSyncListener(selectionModel));
        return adapter;
    }

    private static <T> SelectionChangeListener buildSyncListener(final WritableCollectionValueModel<T> selectionModel) {
        return new SelectionChangeListener(){

            public void selectionChanged(SelectionChangeEvent event) {
                selectionModel.setValues(CollectionTools.iterable(event.selection()));
            }
        };
    }

    protected TableModelAdapter(ListValueModel<E> listHolder, CollectionValueModel<E> selectedItemsHolder, Table table, ColumnAdapter<E> columnAdapter, ITableLabelProvider labelProvider) {
        if (listHolder == null || selectedItemsHolder == null || table == null || labelProvider == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.selectedItemsHolder = selectedItemsHolder;
        this.table = table;
        this.columnAdapter = columnAdapter;
        this.labelProvider = labelProvider;
        this.tableItemModelAdapters = new ArrayList<TableItemModelAdapter>(columnAdapter.columnCount());
        this.listChangeListener = this.buildListChangeListener();
        this.listHolder.addListChangeListener("list values", this.listChangeListener);
        this.selectedItemsChangeListener = this.buildSelectedItemsChangeListener();
        this.selectedItemsHolder.addCollectionChangeListener("values", this.selectedItemsChangeListener);
        this.tableSelectionListener = this.buildTableSelectionListener();
        this.table.addSelectionListener(this.tableSelectionListener);
        this.selectionChangeListenerList = this.buildSelectionChangeListenerList();
        this.doubleClickListenerList = this.buildDoubleClickListenerList();
        this.tableDisposeListener = this.buildTableDisposeListener();
        this.table.addDisposeListener(this.tableDisposeListener);
        this.synchronizeTable();
    }

    protected ListChangeListener buildListChangeListener() {
        return new SWTListChangeListenerWrapper(this.buildListChangeListener_());
    }

    protected ListChangeListener buildListChangeListener_() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent event) {
                TableModelAdapter.this.listItemsAdded(event);
            }

            public void itemsRemoved(ListRemoveEvent event) {
                TableModelAdapter.this.listItemsRemoved(event);
            }

            public void itemsMoved(ListMoveEvent event) {
                TableModelAdapter.this.listItemsMoved(event);
            }

            public void itemsReplaced(ListReplaceEvent event) {
                TableModelAdapter.this.listItemsReplaced(event);
            }

            public void listCleared(ListClearEvent event) {
                TableModelAdapter.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                TableModelAdapter.this.listChanged(event);
            }

            public String toString() {
                return "TableModelAdapter list listener";
            }
        };
    }

    protected CollectionChangeListener buildSelectedItemsChangeListener() {
        return new SWTCollectionChangeListenerWrapper(this.buildSelectedItemsChangeListener_());
    }

    protected CollectionChangeListener buildSelectedItemsChangeListener_() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                TableModelAdapter.this.selectedItemsAdded(event);
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                TableModelAdapter.this.selectedItemsRemoved(event);
            }

            public void collectionCleared(CollectionClearEvent event) {
                TableModelAdapter.this.selectedItemsCleared(event);
            }

            public void collectionChanged(CollectionChangeEvent event) {
                TableModelAdapter.this.selectedItemsChanged(event);
            }

            public String toString() {
                return "TableModelAdapter selected items listener";
            }
        };
    }

    protected SelectionListener buildTableSelectionListener() {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TableModelAdapter.this.tableSelectionChanged(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                TableModelAdapter.this.tableDoubleClicked(event);
            }

            public String toString() {
                return "TableModelAdapter table selection listener";
            }
        };
    }

    protected ListenerList<DoubleClickListener<E>> buildDoubleClickListenerList() {
        return new ListenerList(DoubleClickListener.class);
    }

    protected ListenerList<SelectionChangeListener<E>> buildSelectionChangeListenerList() {
        return new ListenerList(SelectionChangeListener.class);
    }

    protected DisposeListener buildTableDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                TableModelAdapter.this.tableDisposed(event);
            }

            public String toString() {
                return "TableModelAdapter table dispose listener";
            }
        };
    }

    protected void synchronizeTable() {
        this.synchronizeTableColumns();
        this.synchronizeTableItems();
        this.synchronizeTableSelection();
    }

    protected void synchronizeTableColumns() {
        if (this.table.isDisposed()) {
            return;
        }
        int columnCount = this.columnAdapter.columnCount();
        int index = 0;
        while (index < columnCount) {
            TableColumn tableColumn = new TableColumn(this.table, 0, index);
            tableColumn.setMoveable(false);
            tableColumn.setResizable(true);
            tableColumn.setWidth(100);
            String columnName = this.columnAdapter.columnName(index);
            if (columnName == null) {
                columnName = "";
            }
            tableColumn.setText(columnName);
            ++index;
        }
    }

    protected void synchronizeTableItems() {
        if (this.table.isDisposed()) {
            return;
        }
        int index = this.table.getItemCount();
        while (--index >= 0) {
            this.table.remove(index);
            this.tableItemModelAdapters.remove(index);
        }
        int itemCount = this.listHolder.size();
        int index2 = 0;
        while (index2 < itemCount) {
            TableItem tableItem = new TableItem(this.table, 0, index2);
            tableItem.setData(this.listHolder.get(index2));
            TableItemModelAdapter adapter = this.buildItemModel(tableItem);
            this.tableItemModelAdapters.add(adapter);
            ++index2;
        }
    }

    protected void listItemsAdded(ListAddEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        int index = event.getIndex();
        for (E item : this.getItems(event)) {
            TableItem tableItem = new TableItem(this.table, 0, index);
            tableItem.setData(item);
            TableItemModelAdapter adapter = this.buildItemModel(tableItem);
            this.tableItemModelAdapters.add(index++, adapter);
        }
    }

    protected void listItemsRemoved(ListRemoveEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.remove(event.getIndex(), event.getIndex() + event.getItemsSize() - 1);
        int index = event.getIndex() + event.getItemsSize();
        while (--index >= event.getIndex()) {
            this.tableItemModelAdapters.remove(index);
        }
    }

    protected void listItemsMoved(ListMoveEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        int length = event.getLength();
        int sourceIndex = event.getSourceIndex();
        int targetIndex = event.getTargetIndex();
        int lowStartIndex = Math.min(targetIndex, sourceIndex);
        int hiStartIndex = Math.max(targetIndex, sourceIndex);
        Object[] items = new Object[hiStartIndex - lowStartIndex + length];
        int itemsIndex = items.length;
        int index = hiStartIndex + length;
        while (--index >= lowStartIndex) {
            TableItemModelAdapter tableItemModel = this.tableItemModelAdapters.get(index);
            items[--itemsIndex] = tableItemModel.tableItem.getData();
            this.table.remove(index);
        }
        ArrayTools.move((Object[])items, (int)(targetIndex - lowStartIndex), (int)(sourceIndex - lowStartIndex), (int)length);
        itemsIndex = 0;
        index = lowStartIndex;
        while (index <= hiStartIndex + length - 1) {
            TableItem tableItem = new TableItem(this.table, 0, index);
            tableItem.setData(items[itemsIndex++]);
            TableItemModelAdapter adapter = this.buildItemModel(tableItem);
            this.tableItemModelAdapters.set(index, adapter);
            ++index;
        }
    }

    private TableItemModelAdapter buildItemModel(TableItem tableItem) {
        return TableItemModelAdapter.adapt(tableItem, this.columnAdapter, this.labelProvider);
    }

    protected void listItemsReplaced(ListReplaceEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        int rowIndex = event.getIndex();
        for (E item : this.getNewItems(event)) {
            TableItem tableItem = this.table.getItem(rowIndex);
            tableItem.setData(item);
            TableItemModelAdapter adapter = this.tableItemModelAdapters.get(rowIndex);
            int columnCount = this.columnAdapter.columnCount();
            boolean revalidate = columnCount == 1;
            int columnIndex = columnCount;
            while (--columnIndex >= 0) {
                adapter.tableItemChanged(columnIndex, tableItem.getData(), revalidate);
            }
            ++rowIndex;
        }
    }

    protected void listCleared(ListClearEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.removeAll();
    }

    protected void listChanged(ListChangeEvent event) {
        this.synchronizeTableItems();
    }

    protected Iterable<E> getItems(ListAddEvent event) {
        return event.getItems();
    }

    protected Iterable<E> getNewItems(ListReplaceEvent event) {
        return event.getNewItems();
    }

    protected int indexOf(E item) {
        int len = this.listHolder.size();
        int i = 0;
        while (i < len) {
            if (this.listHolder.get(i) == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void synchronizeTableSelection() {
        if (this.table.isDisposed()) {
            return;
        }
        int[] indices = new int[this.selectedItemsHolder.size()];
        int i = 0;
        for (Object selectedItemHolder : this.selectedItemsHolder) {
            indices[i++] = this.indexOf(selectedItemHolder);
        }
        this.table.deselectAll();
        this.table.select(indices);
    }

    protected void selectedItemsAdded(CollectionAddEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.select(this.getIndices(event.getItemsSize(), this.getItems(event)));
    }

    protected void selectedItemsRemoved(CollectionRemoveEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.deselect(this.getIndices(event.getItemsSize(), this.getItems(event)));
    }

    protected int[] getIndices(int itemsSize, Iterable<E> items) {
        int[] indices = new int[itemsSize];
        int i = 0;
        for (E item : items) {
            indices[i++] = this.indexOf(item);
        }
        return indices;
    }

    protected void selectedItemsCleared(CollectionClearEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        this.table.deselectAll();
    }

    protected void selectedItemsChanged(CollectionChangeEvent event) {
        this.synchronizeTableSelection();
    }

    protected Iterable<E> getItems(CollectionAddEvent event) {
        return event.getItems();
    }

    protected Iterable<E> getItems(CollectionRemoveEvent event) {
        return event.getItems();
    }

    protected void tableSelectionChanged(SelectionEvent event) {
        if (this.selectionChangeListenerList.size() > 0) {
            SelectionChangeEvent<E> scEvent = new SelectionChangeEvent<E>(this, this.selectedItems());
            for (SelectionChangeListener selectionChangeListener : this.selectionChangeListenerList.getListeners()) {
                selectionChangeListener.selectionChanged(scEvent);
            }
        }
    }

    protected Collection<E> selectedItems() {
        if (this.table.isDisposed()) {
            return Collections.emptySet();
        }
        ArrayList<Object> selectedItems = new ArrayList<Object>(this.table.getSelectionCount());
        int[] nArray = this.table.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int selectionIndex = nArray[n2];
            selectedItems.add(this.listHolder.get(selectionIndex));
            ++n2;
        }
        return selectedItems;
    }

    protected void tableDoubleClicked(SelectionEvent event) {
        if (this.table.isDisposed()) {
            return;
        }
        if (this.doubleClickListenerList.size() > 0) {
            Object selection = this.listHolder.get(this.table.getSelectionIndex());
            DoubleClickEvent<Object> dcEvent = new DoubleClickEvent<Object>(this, selection);
            for (DoubleClickListener doubleClickListener : this.doubleClickListenerList.getListeners()) {
                doubleClickListener.doubleClick(dcEvent);
            }
        }
    }

    protected void tableDisposed(DisposeEvent event) {
        this.table.removeDisposeListener(this.tableDisposeListener);
        this.table.removeSelectionListener(this.tableSelectionListener);
        this.selectedItemsHolder.removeCollectionChangeListener("values", this.selectedItemsChangeListener);
        this.listHolder.removeListChangeListener("list values", this.listChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.listHolder);
    }

    public void addDoubleClickListener(DoubleClickListener<E> listener) {
        this.doubleClickListenerList.add(listener);
    }

    public void removeDoubleClickListener(DoubleClickListener<E> listener) {
        this.doubleClickListenerList.remove(listener);
    }

    public void addSelectionChangeListener(SelectionChangeListener<E> listener) {
        this.selectionChangeListenerList.add(listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener<E> listener) {
        this.selectionChangeListenerList.remove(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleClickEvent<E>
    extends EventObject {
        private final E selection;
        private static final long serialVersionUID = 1L;

        protected DoubleClickEvent(TableModelAdapter<E> source, E selection) {
            super(source);
            if (selection == null) {
                throw new NullPointerException();
            }
            this.selection = selection;
        }

        @Override
        public TableModelAdapter<E> getSource() {
            return (TableModelAdapter)super.getSource();
        }

        public E selection() {
            return this.selection;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface DoubleClickListener<E>
    extends EventListener {
        public void doubleClick(DoubleClickEvent<E> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectionChangeEvent<E>
    extends EventObject {
        private final Collection<E> selection;
        private static final long serialVersionUID = 1L;

        protected SelectionChangeEvent(TableModelAdapter<E> source, Collection<E> selection) {
            super(source);
            if (selection == null) {
                throw new NullPointerException();
            }
            this.selection = selection;
        }

        @Override
        public TableModelAdapter<E> getSource() {
            return (TableModelAdapter)super.getSource();
        }

        public Iterator<E> selection() {
            return this.selection.iterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SelectionChangeListener<E>
    extends EventListener {
        public void selectionChanged(SelectionChangeEvent<E> var1);
    }
}

