/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.properties;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jpt.common.core.internal.utility.ICUStringCollator;
import org.eclipse.jpt.common.ui.internal.properties.JptProjectPropertiesPage;
import org.eclipse.jpt.common.ui.internal.utility.swt.SWTTools;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.BufferedWritablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SetCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticCollectionValueModel;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.jaxb.core.JaxbFacet;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JptJaxbCorePlugin;
import org.eclipse.jpt.jaxb.core.libprov.JaxbLibraryProviderInstallOperationConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDescription;
import org.eclipse.jpt.jaxb.ui.internal.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.properties.JaxbProjectModel;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderOperationConfig;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderFrameworkUi;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxbProjectPropertiesPage
extends JptProjectPropertiesPage {
    public static final String PROP_ID = "org.eclipse.jpt.jaxb.ui.jaxbProjectPropertiesPage";
    private PropertyValueModel<JaxbProject> jaxbProjectModel;
    private BufferedWritablePropertyValueModel<JaxbPlatformDescription> platformModel;
    private PropertyChangeListener platformListener;
    static final Comparator<String> STRING_COMPARATOR = new ICUStringCollator();
    private static final Comparator<JaxbPlatformDescription> JAXB_PLATFORM_COMPARATOR = new Comparator<JaxbPlatformDescription>(){

        @Override
        public int compare(JaxbPlatformDescription desc1, JaxbPlatformDescription desc2) {
            return STRING_COMPARATOR.compare(desc1.getLabel(), desc2.getLabel());
        }
    };
    private static final StringConverter<JaxbPlatformDescription> JAXB_PLATFORM_LABEL_CONVERTER = new StringConverter<JaxbPlatformDescription>(){

        public String convertToString(JaxbPlatformDescription desc) {
            return desc.getLabel();
        }
    };

    protected void buildModels() {
        this.jaxbProjectModel = new JaxbProjectModel((PropertyValueModel<IProject>)this.projectModel);
        this.platformModel = this.buildPlatformModel();
        this.platformListener = this.buildPlatformListener();
    }

    private BufferedWritablePropertyValueModel<JaxbPlatformDescription> buildPlatformModel() {
        return new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new PlatformModel(this.jaxbProjectModel), (PropertyValueModel)this.trigger);
    }

    private PropertyChangeListener buildPlatformListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                JaxbProjectPropertiesPage.this.platformChanged((JaxbPlatformDescription)event.getNewValue());
            }
        };
    }

    void platformChanged(JaxbPlatformDescription newPlatform) {
        if (!this.getControl().isDisposed()) {
            this.adjustLibraryProviders();
        }
    }

    public IProjectFacetVersion getProjectFacetVersion() {
        return this.getFacetedProject().getInstalledVersion(JaxbFacet.FACET);
    }

    protected LibraryInstallDelegate createLibraryInstallDelegate(IFacetedProject project, IProjectFacetVersion fv) {
        LibraryInstallDelegate lid = new LibraryInstallDelegate((IFacetedProjectBase)project, fv);
        lid.addListener(this.buildLibraryProviderListener(), new String[0]);
        return lid;
    }

    protected void adjustLibraryProviders() {
        LibraryInstallDelegate lid = this.getLibraryInstallDelegate();
        if (lid != null) {
            ArrayList<JaxbLibraryProviderInstallOperationConfig> jaxbConfigs = new ArrayList<JaxbLibraryProviderInstallOperationConfig>();
            JaxbLibraryProviderInstallOperationConfig currentJaxbConfig = null;
            LibraryProviderOperationConfig config = lid.getLibraryProviderOperationConfig();
            if (config instanceof JaxbLibraryProviderInstallOperationConfig) {
                currentJaxbConfig = (JaxbLibraryProviderInstallOperationConfig)config;
                jaxbConfigs.add(currentJaxbConfig);
            }
            for (ILibraryProvider lp : lid.getLibraryProviders()) {
                config = lid.getLibraryProviderOperationConfig(lp);
                if (!(config instanceof JaxbLibraryProviderInstallOperationConfig) || config.equals(currentJaxbConfig)) continue;
                jaxbConfigs.add((JaxbLibraryProviderInstallOperationConfig)config);
            }
            for (JaxbLibraryProviderInstallOperationConfig jaxbConfig : jaxbConfigs) {
                jaxbConfig.setJaxbPlatform((JaxbPlatformDescription)this.platformModel.getValue());
            }
        }
    }

    protected void createWidgets(Composite parent) {
        this.buildPlatformGroup(parent);
        Control libraryProviderComposite = LibraryProviderFrameworkUi.createInstallLibraryPanel((Composite)parent, (LibraryInstallDelegate)this.getLibraryInstallDelegate(), (String)JptJaxbUiMessages.JaxbFacetWizardPage_jaxbImplementationLabel);
        libraryProviderComposite.setLayoutData((Object)new GridData(768));
    }

    protected void engageListeners() {
        super.engageListeners();
        this.platformModel.addPropertyChangeListener("value", this.platformListener);
    }

    public void disengageListeners() {
        this.platformModel.removePropertyChangeListener("value", this.platformListener);
        super.disengageListeners();
    }

    private void buildPlatformGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(JptJaxbUiMessages.JaxbFacetWizardPage_platformLabel);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        Combo platformDropDown = this.buildDropDown((Composite)group);
        SWTTools.bind(this.buildPlatformChoicesModel(), this.platformModel, (Combo)platformDropDown, JAXB_PLATFORM_LABEL_CONVERTER);
        this.buildFacetsPageLink((Composite)group, JptJaxbUiMessages.JaxbFacetWizardPage_facetsPageLink);
    }

    private ListValueModel<JaxbPlatformDescription> buildPlatformChoicesModel() {
        return new SortedListValueModelAdapter((CollectionValueModel)new SetCollectionValueModel((CollectionValueModel)new CompositeCollectionValueModel((Object[])new CollectionValueModel[]{new PropertyCollectionValueModelAdapter(this.platformModel), this.buildRegistryPlatformsModel()})), JAXB_PLATFORM_COMPARATOR);
    }

    private CollectionValueModel<JaxbPlatformDescription> buildRegistryPlatformsModel() {
        FilteringIterable<JaxbPlatformDescription> enabledPlatforms = new FilteringIterable<JaxbPlatformDescription>(JptJaxbCorePlugin.getJaxbPlatformManager().getJaxbPlatforms()){

            protected boolean accept(JaxbPlatformDescription o) {
                return o.supportsJaxbFacetVersion(JaxbProjectPropertiesPage.this.getProjectFacetVersion());
            }
        };
        return new StaticCollectionValueModel((Iterable)enabledPlatforms);
    }

    protected boolean projectRebuildRequired() {
        return this.platformModel.isBuffering();
    }

    protected void rebuildProject() {
        JptJaxbCorePlugin.getProjectManager().rebuildJaxbProject(this.getProject());
    }

    protected BufferedWritablePropertyValueModel<?>[] buildBufferedModels() {
        return new BufferedWritablePropertyValueModel[]{this.platformModel};
    }

    protected Model[] buildValidationModels() {
        return new Model[]{this.platformModel};
    }

    protected void performValidation(Map<Integer, ArrayList<IStatus>> statuses) {
        super.performValidation(statuses);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PlatformModel
    extends AspectPropertyValueModelAdapter<JaxbProject, JaxbPlatformDescription> {
        PlatformModel(PropertyValueModel<JaxbProject> jaxbProjectModel) {
            super(jaxbProjectModel);
        }

        protected JaxbPlatformDescription buildValue_() {
            return ((JaxbProject)this.subject).getPlatform().getDescription();
        }

        public void setValue_(JaxbPlatformDescription newPlatform) {
            JptJaxbCorePlugin.setJaxbPlatform((IProject)((JaxbProject)this.subject).getProject(), (JaxbPlatformDescription)newPlatform);
        }

        protected void engageSubject_() {
        }

        protected void disengageSubject_() {
        }
    }
}

