/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;

public class SuperTypeReferencePattern
extends JavaSearchPattern {
    public char[] superQualification;
    public char[] superSimpleName;
    public char[] pkgName;
    public char[] simpleName;
    public char[] enclosingTypeName;
    public int modifiers;
    protected static char[][] CATEGORIES = new char[][]{SUPER_REF};

    public static char[] createIndexKey(int modifiers, char[] packageName, char[] typeName, char[][] enclosingTypeNames, char[] superTypeName) {
        if (superTypeName == null) {
            superTypeName = OBJECT;
        }
        char[] superSimpleName = superTypeName;
        char[] superQualification = null;
        char[] superTypeSourceName = CharOperation.lastSegment(superSimpleName, '$');
        if (superTypeSourceName != superSimpleName) {
            int start = superQualification == null ? 0 : superQualification.length + 1;
            int prefixLength = superSimpleName.length - superTypeSourceName.length;
            char[] mangledQualification = new char[start + prefixLength];
            if (superQualification != null) {
                System.arraycopy(superQualification, 0, mangledQualification, 0, start - 1);
                mangledQualification[start - 1] = 46;
            }
            System.arraycopy(superSimpleName, 0, mangledQualification, start, prefixLength);
            superQualification = mangledQualification;
            superSimpleName = superTypeSourceName;
        }
        char[] simpleName = CharOperation.lastSegment(typeName, '.');
        char[] simpleNameTemp = new char[simpleName.length + packageName.length + 1];
        System.arraycopy(packageName, 0, simpleNameTemp, 0, packageName.length);
        simpleNameTemp[packageName.length] = 46;
        System.arraycopy(simpleName, 0, simpleNameTemp, packageName.length + 1, simpleName.length);
        simpleName = simpleNameTemp;
        char[] enclosingTypeName = CharOperation.concatWith(enclosingTypeNames, '$');
        if (superQualification != null && CharOperation.equals(superQualification, packageName)) {
            packageName = ONE_ZERO;
        }
        int superLength = superSimpleName == null ? 0 : superSimpleName.length;
        int superQLength = superQualification == null ? 0 : superQualification.length;
        int simpleLength = simpleName == null ? 0 : simpleName.length;
        int enclosingLength = enclosingTypeName == null ? 0 : enclosingTypeName.length;
        int packageLength = packageName == null ? 0 : packageName.length;
        char[] result = new char[superLength + superQLength + simpleLength + enclosingLength + packageLength + 9];
        int pos = 0;
        if (superLength > 0) {
            System.arraycopy(superSimpleName, 0, result, pos, superLength);
            pos += superLength;
        }
        result[pos++] = 47;
        if (superQLength > 0) {
            System.arraycopy(superQualification, 0, result, pos, superQLength);
            pos += superQLength;
        }
        result[pos++] = 47;
        if (simpleLength > 0) {
            System.arraycopy(simpleName, 0, result, pos, simpleLength);
            pos += simpleLength;
        }
        result[pos++] = 47;
        if (enclosingLength > 0) {
            System.arraycopy(enclosingTypeName, 0, result, pos, enclosingLength);
            pos += enclosingLength;
        }
        result[pos++] = 47;
        if (packageLength > 0) {
            System.arraycopy(packageName, 0, result, pos, packageLength);
            pos += packageLength;
        }
        result[pos++] = 47;
        result[pos] = (char)modifiers;
        return result;
    }

    public SuperTypeReferencePattern(char[] superQualification, char[] superSimpleName, int matchRule) {
        this(matchRule);
        this.superQualification = this.isCaseSensitive() ? superQualification : CharOperation.toLowerCase(superQualification);
        this.superSimpleName = this.isCaseSensitive() || this.isCamelCase() ? superSimpleName : CharOperation.toLowerCase(superSimpleName);
        this.mustResolve = superQualification != null;
    }

    SuperTypeReferencePattern(int matchRule) {
        super(16, matchRule);
    }

    public void decodeIndexKey(char[] key) {
        char[] names;
        int slash = CharOperation.indexOf('/', key, 0);
        this.superSimpleName = CharOperation.subarray(key, 0, slash);
        int start = slash + 1;
        this.superQualification = (slash = CharOperation.indexOf('/', key, start)) == start ? null : CharOperation.subarray(key, start, slash);
        start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        this.simpleName = CharOperation.subarray(key, start, slash);
        if (key[start = ++slash] == '/') {
            this.enclosingTypeName = null;
        } else {
            slash = CharOperation.indexOf('/', key, start);
            if (slash == start + 1 && key[start] == '0') {
                this.enclosingTypeName = ONE_ZERO;
            } else {
                names = CharOperation.subarray(key, start, slash);
                this.enclosingTypeName = names;
            }
        }
        start = ++slash;
        if (key[start] == '/') {
            this.pkgName = null;
        } else {
            slash = CharOperation.indexOf('/', key, start);
            if (slash == start + 1 && key[start] == '0') {
                this.pkgName = this.superQualification;
            } else {
                names = CharOperation.subarray(key, start, slash);
                this.pkgName = names;
            }
        }
        this.modifiers = key[slash + 3];
    }

    public SearchPattern getBlankPattern() {
        return new SuperTypeReferencePattern(8);
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        SuperTypeReferencePattern pattern = (SuperTypeReferencePattern)decodedPattern;
        if (pattern.superQualification != null && !this.matchesName(this.superQualification, pattern.superQualification)) {
            return false;
        }
        return this.matchesName(this.superSimpleName, pattern.superSimpleName);
    }

    EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.superSimpleName;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.isCamelCase) break;
                matchRule &= 0xFFFFFFFF;
                matchRule |= 1;
                if (this.superSimpleName == null) break;
                key = CharOperation.append(this.superSimpleName, '/');
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    protected StringBuffer print(StringBuffer output) {
        output.append("SuperClassReferencePattern: <");
        if (this.superSimpleName != null) {
            output.append(this.superSimpleName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }
}

