/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.wizard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.dtd.core.internal.DTDCorePlugin;
import org.eclipse.wst.dtd.core.internal.provisional.contenttype.ContentTypeIdForDTD;
import org.eclipse.wst.dtd.ui.internal.DTDUIMessages;
import org.eclipse.wst.dtd.ui.internal.Logger;
import org.eclipse.wst.dtd.ui.internal.editor.DTDEditorPluginImageHelper;
import org.eclipse.wst.dtd.ui.internal.wizard.NewDTDTemplatesWizardPage;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;

public class NewDTDWizard
extends Wizard
implements INewWizard {
    private WizardNewFileCreationPage fNewFilePage;
    private NewDTDTemplatesWizardPage fNewFileTemplatesPage;
    private IStructuredSelection fSelection;
    private static final String defaultName = "NewFile";
    private IContentType fContentType;
    private List fValidExtensions = null;

    String addDefaultExtension(String filename) {
        StringBuffer newFileName = new StringBuffer(filename);
        Preferences preference = DTDCorePlugin.getInstance().getPluginPreferences();
        String ext = preference.getString("defaultExtension");
        newFileName.append(".");
        newFileName.append(ext);
        return newFileName.toString();
    }

    IContentType getContentType() {
        if (this.fContentType == null) {
            this.fContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForDTD.ContentTypeID_DTD);
        }
        return this.fContentType;
    }

    List getValidExtensions() {
        if (this.fValidExtensions == null) {
            IContentType type = this.getContentType();
            this.fValidExtensions = new ArrayList<String>(Arrays.asList(type.getFileSpecs(8)));
        }
        return this.fValidExtensions;
    }

    private String applyLineDelimiter(IFile file, String text) {
        String lineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", System.getProperty("line.separator"), new IScopeContext[]{new ProjectScope(file.getProject()), new InstanceScope()});
        String convertedText = StringUtils.replace((String)text, (String)"\r\n", (String)"\n");
        convertedText = StringUtils.replace((String)convertedText, (String)"\r", (String)"\n");
        convertedText = StringUtils.replace((String)convertedText, (String)"\n", (String)lineDelimiter);
        return convertedText;
    }

    boolean extensionValidForContentType(String fileName) {
        boolean valid = false;
        IContentType type = this.getContentType();
        if (fileName.lastIndexOf(46) != -1) {
            IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileName);
            int i = 0;
            while (i < types.length && !valid) {
                valid = types[i].isKindOf(type);
                ++i;
            }
        } else {
            valid = true;
        }
        return valid;
    }

    public void addPages() {
        this.fNewFilePage = new WizardNewFileCreationPage("DTDWizardNewFileCreationPage", (IStructuredSelection)new StructuredSelection(IDE.computeSelectedResources((IStructuredSelection)this.fSelection))){

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.setFileName(this.computeDefaultFileName());
                this.setPageComplete(this.validatePage());
            }

            protected String computeDefaultFileName() {
                int count = 0;
                String fileName = NewDTDWizard.this.addDefaultExtension(NewDTDWizard.defaultName);
                IPath containerFullPath = this.getContainerFullPath();
                if (containerFullPath != null) {
                    while (true) {
                        IPath path = containerFullPath.append(fileName);
                        if (!ResourcesPlugin.getWorkspace().getRoot().exists(path)) break;
                        fileName = NewDTDWizard.this.addDefaultExtension(NewDTDWizard.defaultName + ++count);
                    }
                }
                return fileName;
            }

            protected boolean validatePage() {
                String fileName = this.getFileName();
                IPath fullPath = this.getContainerFullPath();
                if (fullPath != null && !fullPath.isEmpty() && fileName != null) {
                    if (!NewDTDWizard.this.extensionValidForContentType(fileName)) {
                        this.setErrorMessage(NLS.bind((String)DTDUIMessages._ERROR_FILENAME_MUST_END_DTD, (Object)NewDTDWizard.this.getValidExtensions().toString()));
                        return false;
                    }
                    if (fileName.lastIndexOf(46) == -1) {
                        String newFileName = NewDTDWizard.this.addDefaultExtension(fileName);
                        IPath resourcePath = fullPath.append(newFileName);
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        IStatus result = workspace.validatePath(resourcePath.toString(), 2);
                        if (!result.isOK()) {
                            this.setErrorMessage(result.getMessage());
                            return false;
                        }
                        if (workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists()) {
                            this.setErrorMessage(DTDUIMessages.ResourceGroup_nameExists);
                            return false;
                        }
                    }
                }
                this.setErrorMessage(null);
                return super.validatePage();
            }
        };
        this.fNewFilePage.setTitle(DTDUIMessages._UI_CREATE_NEW_DTD_FILE);
        this.fNewFilePage.setDescription(DTDUIMessages._UI_WIZARD_NEW_DTD_EXPL);
        this.addPage((IWizardPage)this.fNewFilePage);
        this.fNewFileTemplatesPage = new NewDTDTemplatesWizardPage();
        this.addPage((IWizardPage)this.fNewFileTemplatesPage);
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection aSelection) {
        this.fSelection = aSelection;
        this.setWindowTitle(DTDUIMessages._UI_WIZARD_NEW_DTD_TITLE);
        ImageDescriptor descriptor = DTDEditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/wizban/newdtdfile_wiz.png");
        this.setDefaultPageImageDescriptor(descriptor);
    }

    private void openEditor(final IFile file) {
        if (file != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        Logger.log(202, e.getMessage(), e);
                    }
                }
            });
        }
    }

    public boolean performFinish() {
        IFile file;
        boolean performedOK = false;
        this.fNewFileTemplatesPage.saveLastSavedPreferences();
        String fileName = this.fNewFilePage.getFileName();
        if (fileName.lastIndexOf(46) == -1) {
            String newFileName = this.addDefaultExtension(fileName);
            this.fNewFilePage.setFileName(newFileName);
        }
        if ((file = this.fNewFilePage.createNewFile()) != null) {
            String templateString = this.fNewFileTemplatesPage.getTemplateString();
            if (templateString != null) {
                templateString = this.applyLineDelimiter(file, templateString);
                String charSet = this.getAppropriateCharset();
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    OutputStreamWriter outputStreamWriter = null;
                    outputStreamWriter = charSet == null || charSet.trim().equals("") ? new OutputStreamWriter(outputStream) : new OutputStreamWriter((OutputStream)outputStream, charSet);
                    outputStreamWriter.write(templateString);
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                    file.setContents((InputStream)inputStream, true, false, null);
                    inputStream.close();
                }
                catch (Exception e) {
                    Logger.log(202, "Could not create contents for new DTD file", e);
                }
            }
            this.openEditor(file);
            performedOK = true;
        }
        return performedOK;
    }

    private String getAppropriateCharset() {
        String charset = DTDCorePlugin.getInstance().getPluginPreferences().getString("outputCodeset");
        if (charset == null || charset.trim().equals("")) {
            charset = XMLCorePlugin.getDefault().getPluginPreferences().getString("outputCodeset");
        }
        return charset;
    }
}

