/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.wst.xml.xpath2.api.CollationProvider;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.Function;
import org.eclipse.wst.xml.xpath2.api.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.StaticVariableResolver;
import org.eclipse.wst.xml.xpath2.api.typesystem.ItemType;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.internal.DefaultStaticContext;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeItemTypeImpl;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.SimpleAtomicItemTypeImpl;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticContextAdapter
implements org.eclipse.wst.xml.xpath2.api.StaticContext {
    private final StaticContext sc;

    public StaticContextAdapter(StaticContext sc) {
        this.sc = sc;
    }

    @Override
    public boolean isXPath1Compatible() {
        return this.sc.xpath1_compatible();
    }

    @Override
    public StaticVariableResolver getInScopeVariables() {
        return new StaticVariableResolver(){

            public boolean isVariablePresent(javax.xml.namespace.QName name) {
                return StaticContextAdapter.this.sc.variable_exists(StaticContextAdapter.this.qn(name));
            }

            public ItemType getVariableType(javax.xml.namespace.QName name) {
                return new SimpleAtomicItemTypeImpl(BuiltinTypeLibrary.XS_ANYTYPE);
            }
        };
    }

    private QName qn(javax.xml.namespace.QName name) {
        return new QName(name);
    }

    @Override
    public TypeDefinition getInitialContextType() {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public Map<String, FunctionLibrary> getFunctionLibraries() {
        if (this.sc instanceof DefaultStaticContext) {
            DefaultStaticContext dsc = (DefaultStaticContext)this.sc;
            return dsc.get_function_libraries();
        }
        return Collections.emptyMap();
    }

    @Override
    public CollationProvider getCollationProvider() {
        if (this.sc instanceof DynamicContext) {
            final DynamicContext dc = (DynamicContext)this.sc;
            return new CollationProvider(){

                public String getDefaultCollation() {
                    return dc.default_collation_name();
                }

                public Comparator getCollation(String name) {
                    return dc.get_collation(name);
                }
            };
        }
        return new CollationProvider(){

            public String getDefaultCollation() {
                return null;
            }

            public Comparator getCollation(String name) {
                return null;
            }
        };
    }

    @Override
    public URI getBaseUri() {
        try {
            return new URI(this.sc.base_uri().getStringValue());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return new NamespaceContext(){

            public Iterator getPrefixes(String arg0) {
                return Collections.emptyList().iterator();
            }

            public String getPrefix(String arg0) {
                return "x";
            }

            public String getNamespaceURI(String prefix) {
                String ns = StaticContextAdapter.this.sc.resolve_prefix(prefix);
                return ns != null ? ns : "";
            }
        };
    }

    @Override
    public String getDefaultNamespace() {
        return this.sc.default_namespace();
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return this.sc.default_function_namespace();
    }

    @Override
    public TypeModel getTypeModel() {
        return this.sc.getTypeModel(null);
    }

    @Override
    public Function resolveFunction(javax.xml.namespace.QName name, int arity) {
        if (this.sc.function_exists(new QName(name), arity)) {
            if (this.sc instanceof DefaultDynamicContext) {
                DefaultDynamicContext dc = (DefaultDynamicContext)this.sc;
                return dc.function(new QName(name), arity);
            }
            return new Function(){

                public String getName() {
                    return null;
                }

                public int getMinArity() {
                    return 0;
                }

                public int getMaxArity() {
                    return 0;
                }

                public boolean isVariableArgument() {
                    return false;
                }

                public boolean canMatchArity(int actualArity) {
                    return false;
                }

                public TypeDefinition getResultType() {
                    return null;
                }

                public TypeDefinition getArgumentType(int index) {
                    return null;
                }

                public String getArgumentNameHint(int index) {
                    return null;
                }

                public ResultSequence evaluate(Collection args, EvaluationContext evaluationContext) {
                    return null;
                }

                public TypeDefinition computeReturnType(Collection args, org.eclipse.wst.xml.xpath2.api.StaticContext sc) {
                    return null;
                }
            };
        }
        return null;
    }

    @Override
    public TypeDefinition getCollectionType(String collectionName) {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public TypeDefinition getDefaultCollectionType() {
        return BuiltinTypeLibrary.XS_UNTYPED;
    }

    @Override
    public ItemType getDocumentType(URI documentUri) {
        return new NodeItemTypeImpl(0, 9);
    }
}

