/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.v2_0.context.persistence.options;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jpt.common.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.persistence.options.EclipseLinkOptions;
import org.eclipse.jpt.jpa.eclipselink.core.v2_0.context.persistence.options.Options2_0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkOptions2_0
extends EclipseLinkOptions
implements Options2_0 {
    private Integer lockTimeout;
    private Integer queryTimeout;
    private List<String> validationGroupPrePersists;
    private List<String> validationGroupPreUpdates;
    private List<String> validationGroupPreRemoves;

    public EclipseLinkOptions2_0(PersistenceUnit2_0 parent) {
        super((PersistenceUnit)parent);
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.lockTimeout = this.getIntegerValue("javax.persistence.lock.timeout");
        this.queryTimeout = this.getIntegerValue("javax.persistence.query.timeout");
        this.validationGroupPrePersists = this.getCompositeValue("javax.persistence.validation.group.pre-persist");
        this.validationGroupPreUpdates = this.getCompositeValue("javax.persistence.validation.group.pre-update");
        this.validationGroupPreRemoves = this.getCompositeValue("javax.persistence.validation.group.pre-remove");
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        super.propertyValueChanged(propertyName, newValue);
        if (propertyName.equals("javax.persistence.lock.timeout")) {
            this.lockTimeoutChanged(newValue);
        } else if (propertyName.equals("javax.persistence.query.timeout")) {
            this.queryTimeoutChanged(newValue);
        } else if (propertyName.equals("javax.persistence.validation.group.pre-persist")) {
            this.validationGroupPrePersistsChanged();
        } else if (propertyName.equals("javax.persistence.validation.group.pre-update")) {
            this.validationGroupPreUpdatesChanged();
        } else if (propertyName.equals("javax.persistence.validation.group.pre-remove")) {
            this.validationGroupPreRemovesChanged();
        }
    }

    @Override
    public void propertyRemoved(String propertyName) {
        super.propertyRemoved(propertyName);
        if (propertyName.equals("javax.persistence.lock.timeout")) {
            this.lockTimeoutChanged(null);
        } else if (propertyName.equals("javax.persistence.query.timeout")) {
            this.queryTimeoutChanged(null);
        } else if (propertyName.equals("javax.persistence.validation.group.pre-persist")) {
            this.validationGroupPrePersistsChanged();
        } else if (propertyName.equals("javax.persistence.validation.group.pre-update")) {
            this.validationGroupPreUpdatesChanged();
        } else if (propertyName.equals("javax.persistence.validation.group.pre-remove")) {
            this.validationGroupPreRemovesChanged();
        }
    }

    @Override
    protected void addPropertyNames(Map<String, String> propertyNames) {
        super.addPropertyNames(propertyNames);
        propertyNames.put("javax.persistence.lock.timeout", "lockTimeout");
        propertyNames.put("javax.persistence.query.timeout", "queryTimeout");
        propertyNames.put("javax.persistence.validation.group.pre-persist", "validationGroupPrePersist");
        propertyNames.put("javax.persistence.validation.group.pre-update", "validationGroupPreUpdate");
        propertyNames.put("javax.persistence.validation.group.pre-remove", "validationGroupPreRemove");
    }

    public PersistenceUnit2_0 getPersistenceUnit() {
        return (PersistenceUnit2_0)super.getPersistenceUnit();
    }

    public Integer getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(Integer newLockTimeout) {
        Integer old = this.lockTimeout;
        this.lockTimeout = newLockTimeout;
        this.putProperty("lockTimeout", newLockTimeout);
        this.firePropertyChanged("lockTimeout", old, newLockTimeout);
    }

    private void lockTimeoutChanged(String stringValue) {
        Integer newValue = EclipseLinkOptions2_0.getIntegerValueOf((String)stringValue);
        Integer old = this.lockTimeout;
        this.lockTimeout = newValue;
        this.firePropertyChanged("lockTimeout", old, newValue);
    }

    public Integer getDefaultLockTimeout() {
        return DEFAULT_LOCK_TIMEOUT;
    }

    public Integer getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(Integer newQueryTimeout) {
        Integer old = this.queryTimeout;
        this.queryTimeout = newQueryTimeout;
        this.putProperty("queryTimeout", newQueryTimeout);
        this.firePropertyChanged("queryTimeout", old, newQueryTimeout);
    }

    private void queryTimeoutChanged(String stringValue) {
        Integer newValue = EclipseLinkOptions2_0.getIntegerValueOf((String)stringValue);
        Integer old = this.queryTimeout;
        this.queryTimeout = newValue;
        this.firePropertyChanged("queryTimeout", old, newValue);
    }

    public Integer getDefaultQueryTimeout() {
        return DEFAULT_QUERY_TIMEOUT;
    }

    public ListIterator<String> validationGroupPrePersists() {
        return new CloneListIterator(this.validationGroupPrePersists);
    }

    public int validationGroupPrePersistsSize() {
        return this.validationGroupPrePersists.size();
    }

    public boolean validationGroupPrePersistExists(String validationGroupPrePersistClassName) {
        for (String validationGroupPrePersist : this.validationGroupPrePersists) {
            if (!validationGroupPrePersist.equals(validationGroupPrePersistClassName)) continue;
            return true;
        }
        return false;
    }

    public String addValidationGroupPrePersist(String newPrePersistClassName) {
        if (!this.validationGroupPrePersistExists(newPrePersistClassName)) {
            this.validationGroupPrePersists.add(newPrePersistClassName);
            this.putPropertyCompositeValue("validationGroupPrePersist", newPrePersistClassName);
            this.fireListChanged("validationGroupPrePersists", this.validationGroupPrePersists);
            return newPrePersistClassName;
        }
        return null;
    }

    public void removeValidationGroupPrePersist(String className) {
        if (this.removeValidationGroupPrePersist_(className) != null) {
            this.removePropertyCompositeValue("validationGroupPrePersist", className);
            this.fireListChanged("validationGroupPrePersists", this.validationGroupPrePersists);
        }
    }

    private String removeValidationGroupPrePersist_(String className) {
        ListIterator<String> i = this.validationGroupPrePersists();
        while (i.hasNext()) {
            String validationGroupPrePersist = i.next();
            if (!validationGroupPrePersist.equals(className)) continue;
            this.validationGroupPrePersists.remove(validationGroupPrePersist);
            return validationGroupPrePersist;
        }
        return null;
    }

    private void validationGroupPrePersistsChanged() {
        this.validationGroupPrePersists = this.getCompositeValue("javax.persistence.validation.group.pre-persist");
        this.fireListChanged("validationGroupPrePersists", this.validationGroupPrePersists);
    }

    public ListIterator<String> validationGroupPreUpdates() {
        return new CloneListIterator(this.validationGroupPreUpdates);
    }

    public int validationGroupPreUpdatesSize() {
        return this.validationGroupPreUpdates.size();
    }

    public boolean validationGroupPreUpdateExists(String validationGroupPreUpdateClassName) {
        for (String validationGroupPreUpdate : this.validationGroupPreUpdates) {
            if (!validationGroupPreUpdate.equals(validationGroupPreUpdateClassName)) continue;
            return true;
        }
        return false;
    }

    public String addValidationGroupPreUpdate(String newPreUpdateClassName) {
        if (!this.validationGroupPreUpdateExists(newPreUpdateClassName)) {
            this.validationGroupPreUpdates.add(newPreUpdateClassName);
            this.putPropertyCompositeValue("validationGroupPreUpdate", newPreUpdateClassName);
            this.fireListChanged("validationGroupPreUpdates", this.validationGroupPreUpdates);
            return newPreUpdateClassName;
        }
        return null;
    }

    public void removeValidationGroupPreUpdate(String className) {
        if (this.removeValidationGroupPreUpdate_(className) != null) {
            this.removePropertyCompositeValue("validationGroupPreUpdate", className);
            this.fireListChanged("validationGroupPreUpdates", this.validationGroupPreUpdates);
        }
    }

    private String removeValidationGroupPreUpdate_(String className) {
        ListIterator<String> i = this.validationGroupPreUpdates();
        while (i.hasNext()) {
            String validationGroupPreUpdate = i.next();
            if (!validationGroupPreUpdate.equals(className)) continue;
            this.validationGroupPreUpdates.remove(validationGroupPreUpdate);
            return validationGroupPreUpdate;
        }
        return null;
    }

    private void validationGroupPreUpdatesChanged() {
        this.validationGroupPreUpdates = this.getCompositeValue("javax.persistence.validation.group.pre-update");
        this.fireListChanged("validationGroupPreUpdates", this.validationGroupPreUpdates);
    }

    public ListIterator<String> validationGroupPreRemoves() {
        return new CloneListIterator(this.validationGroupPreRemoves);
    }

    public int validationGroupPreRemovesSize() {
        return this.validationGroupPreRemoves.size();
    }

    public boolean validationGroupPreRemoveExists(String validationGroupPreRemoveClassName) {
        for (String validationGroupPreRemove : this.validationGroupPreRemoves) {
            if (!validationGroupPreRemove.equals(validationGroupPreRemoveClassName)) continue;
            return true;
        }
        return false;
    }

    public String addValidationGroupPreRemove(String newPreRemoveClassName) {
        if (!this.validationGroupPreRemoveExists(newPreRemoveClassName)) {
            this.validationGroupPreRemoves.add(newPreRemoveClassName);
            this.putPropertyCompositeValue("validationGroupPreRemove", newPreRemoveClassName);
            this.fireListChanged("validationGroupPreRemoves", this.validationGroupPreRemoves);
            return newPreRemoveClassName;
        }
        return null;
    }

    public void removeValidationGroupPreRemove(String className) {
        if (this.removeValidationGroupPreRemove_(className) != null) {
            this.removePropertyCompositeValue("validationGroupPreRemove", className);
            this.fireListChanged("validationGroupPreRemoves", this.validationGroupPreRemoves);
        }
    }

    private String removeValidationGroupPreRemove_(String className) {
        ListIterator<String> i = this.validationGroupPreRemoves();
        while (i.hasNext()) {
            String validationGroupPreRemove = i.next();
            if (!validationGroupPreRemove.equals(className)) continue;
            this.validationGroupPreRemoves.remove(validationGroupPreRemove);
            return validationGroupPreRemove;
        }
        return null;
    }

    private void validationGroupPreRemovesChanged() {
        this.validationGroupPreRemoves = this.getCompositeValue("javax.persistence.validation.group.pre-remove");
        this.fireListChanged("validationGroupPreRemoves", this.validationGroupPreRemoves);
    }
}

