/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm;

import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.PrimaryKeyTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmEntity;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmCacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmCacheableHolder2_0;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlClassReference;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlCacheable_2_0;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.JavaEclipseLinkEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.OrmEclipseLinkCaching;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.OrmEclipseLinkConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.OrmEclipseLinkEntity;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkCachingImpl;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkConverterContainerImpl;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.OrmEclipseLinkReadOnly;
import org.eclipse.jpt.jpa.eclipselink.core.internal.v1_1.context.EclipseLinkEntityPrimaryKeyValidator;
import org.eclipse.jpt.jpa.eclipselink.core.internal.v1_1.context.EclipseLinkTypeMappingValidator;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConvertersHolder;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.v2_0.resource.java.EclipseLinkClassExtractorAnnotation2_1;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmEclipseLinkEntityImpl
extends AbstractOrmEntity<XmlEntity>
implements OrmEclipseLinkEntity {
    protected final OrmEclipseLinkReadOnly readOnly;
    protected final OrmEclipseLinkCustomizer customizer;
    protected final OrmEclipseLinkChangeTracking changeTracking;
    protected final OrmEclipseLinkCaching caching = this.buildCaching();
    protected final OrmEclipseLinkConverterContainer converterContainer;

    public OrmEclipseLinkEntityImpl(OrmPersistentType parent, XmlEntity xmlEntity) {
        super(parent, (org.eclipse.jpt.jpa.core.resource.orm.XmlEntity)xmlEntity);
        this.readOnly = this.buildReadOnly();
        this.converterContainer = this.buildConverterContainer();
        this.changeTracking = this.buildChangeTracking();
        this.customizer = this.buildCustomizer();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.caching.synchronizeWithResourceModel();
        this.readOnly.synchronizeWithResourceModel();
        this.converterContainer.synchronizeWithResourceModel();
        this.changeTracking.synchronizeWithResourceModel();
        this.customizer.synchronizeWithResourceModel();
    }

    public void update() {
        super.update();
        this.caching.update();
        this.readOnly.update();
        this.converterContainer.update();
        this.changeTracking.update();
        this.customizer.update();
    }

    @Override
    public OrmEclipseLinkCaching getCaching() {
        return this.caching;
    }

    protected OrmEclipseLinkCaching buildCaching() {
        return new OrmEclipseLinkCachingImpl(this);
    }

    @Override
    public OrmEclipseLinkReadOnly getReadOnly() {
        return this.readOnly;
    }

    protected OrmEclipseLinkReadOnly buildReadOnly() {
        return new OrmEclipseLinkReadOnly(this);
    }

    @Override
    public OrmEclipseLinkConverterContainer getConverterContainer() {
        return this.converterContainer;
    }

    protected OrmEclipseLinkConverterContainer buildConverterContainer() {
        return new OrmEclipseLinkConverterContainerImpl((XmlContextNode)this, (XmlConvertersHolder)this.xmlTypeMapping);
    }

    @Override
    public EclipseLinkChangeTracking getChangeTracking() {
        return this.changeTracking;
    }

    protected OrmEclipseLinkChangeTracking buildChangeTracking() {
        return new OrmEclipseLinkChangeTracking(this);
    }

    @Override
    public EclipseLinkCustomizer getCustomizer() {
        return this.customizer;
    }

    protected OrmEclipseLinkCustomizer buildCustomizer() {
        return new OrmEclipseLinkCustomizer(this);
    }

    @Override
    public JavaEclipseLinkEntity getJavaTypeMapping() {
        return (JavaEclipseLinkEntity)super.getJavaTypeMapping();
    }

    @Override
    public JavaEclipseLinkEntity getJavaTypeMappingForDefaults() {
        return (JavaEclipseLinkEntity)super.getJavaTypeMappingForDefaults();
    }

    @Override
    public boolean usesPrimaryKeyColumns() {
        return ((XmlEntity)this.getXmlTypeMapping()).getPrimaryKey() != null || this.usesJavaPrimaryKeyColumns();
    }

    protected boolean usesJavaPrimaryKeyColumns() {
        JavaEclipseLinkEntity javaEntity = this.getJavaTypeMappingForDefaults();
        return javaEntity != null && javaEntity.usesPrimaryKeyColumns();
    }

    protected boolean buildSpecifiedDiscriminatorColumnIsAllowed() {
        return super.buildSpecifiedDiscriminatorColumnIsAllowed() && !this.classExtractorIsUsed();
    }

    protected boolean classExtractorIsUsed() {
        return this.getXmlClassExtractor() != null || this.getClassExtractorAnnotation() != null;
    }

    protected XmlClassReference getXmlClassExtractor() {
        return ((XmlEntity)this.getXmlTypeMapping()).getClassExtractor();
    }

    protected EclipseLinkClassExtractorAnnotation2_1 getClassExtractorAnnotation() {
        if (this.getJavaTypeMappingForDefaults() != null) {
            JavaResourcePersistentType jrpt = this.getJavaPersistentType().getResourcePersistentType();
            return (EclipseLinkClassExtractorAnnotation2_1)jrpt.getAnnotation("org.eclipse.persistence.annotations.ClassExtractor");
        }
        return null;
    }

    public OrmCacheable2_0 getCacheable() {
        return this.getCacheableHolder().getCacheable();
    }

    public boolean calculateDefaultCacheable() {
        return this.getCacheableHolder().calculateDefaultCacheable();
    }

    protected OrmCacheableHolder2_0 getCacheableHolder() {
        return (OrmCacheableHolder2_0)this.caching;
    }

    public XmlCacheable_2_0 getXmlCacheable() {
        return (XmlCacheable_2_0)this.getXmlTypeMapping();
    }

    protected JavaResourcePersistentType getResourceClassExtractorPersistentType() {
        XmlClassReference classExtractorClassRef = this.getXmlClassExtractor();
        if (classExtractorClassRef == null) {
            return null;
        }
        String className = classExtractorClassRef.getClassName();
        if (className == null) {
            return null;
        }
        return this.getEntityMappings().resolveJavaResourcePersistentType(className);
    }

    protected boolean classExtractorIsFor(String typeName) {
        JavaResourcePersistentType classExtractorType = this.getResourceClassExtractorPersistentType();
        return classExtractorType != null && classExtractorType.getQualifiedName().equals(typeName);
    }

    protected boolean classExtractorIsIn(IPackageFragment packageFragment) {
        JavaResourcePersistentType classExtractorType = this.getResourceClassExtractorPersistentType();
        return classExtractorType != null && classExtractorType.isIn(packageFragment);
    }

    protected EntityMappings getEntityMappings() {
        return this.getMappingFileRoot();
    }

    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return new CompositeIterable(new Iterable[]{super.createRenameTypeEdits(originalType, newName), this.createCustomizerRenameTypeEdits(originalType, newName), this.createConverterHolderRenameTypeEdits(originalType, newName), this.createClassExtractorRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createCustomizerRenameTypeEdits(IType originalType, String newName) {
        return this.customizer.createRenameTypeEdits(originalType, newName);
    }

    protected Iterable<ReplaceEdit> createConverterHolderRenameTypeEdits(IType originalType, String newName) {
        return this.converterContainer.createRenameTypeEdits(originalType, newName);
    }

    protected Iterable<ReplaceEdit> createClassExtractorRenameTypeEdits(IType originalType, String newName) {
        return this.classExtractorIsFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.getXmlClassExtractor().createRenameEdit(originalType, newName)) : EmptyIterable.instance();
    }

    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return new CompositeIterable(new Iterable[]{super.createMoveTypeEdits(originalType, newPackage), this.createCustomizerMoveTypeEdits(originalType, newPackage), this.createConverterHolderMoveTypeEdits(originalType, newPackage), this.createClassExtractorMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createCustomizerMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.customizer.createMoveTypeEdits(originalType, newPackage);
    }

    protected Iterable<ReplaceEdit> createConverterHolderMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.converterContainer.createMoveTypeEdits(originalType, newPackage);
    }

    protected Iterable<ReplaceEdit> createClassExtractorMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.classExtractorIsFor(originalType.getFullyQualifiedName('.')) ? new SingleElementIterable((Object)this.getXmlClassExtractor().createRenamePackageEdit(newPackage.getElementName())) : EmptyIterable.instance();
    }

    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{super.createRenamePackageEdits(originalPackage, newName), this.createCustomizerRenamePackageEdits(originalPackage, newName), this.createConverterHolderRenamePackageEdits(originalPackage, newName), this.createClassExtractorRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createCustomizerRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.customizer.createRenamePackageEdits(originalPackage, newName);
    }

    protected Iterable<ReplaceEdit> createConverterHolderRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.converterContainer.createRenamePackageEdits(originalPackage, newName);
    }

    protected Iterable<ReplaceEdit> createClassExtractorRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.classExtractorIsIn(originalPackage) ? new SingleElementIterable((Object)this.getXmlClassExtractor().createRenamePackageEdit(newName)) : EmptyIterable.instance();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.caching.validate(messages, reporter);
        this.readOnly.validate(messages, reporter);
        this.converterContainer.validate(messages, reporter);
        this.changeTracking.validate(messages, reporter);
        this.customizer.validate(messages, reporter);
    }

    protected JptValidator buildPrimaryKeyValidator() {
        return new EclipseLinkEntityPrimaryKeyValidator(this, (PrimaryKeyTextRangeResolver)this.buildTextRangeResolver());
    }

    protected JptValidator buildTypeMappingValidator() {
        return new EclipseLinkTypeMappingValidator(this, this.getJavaResourcePersistentType(), (TypeMappingTextRangeResolver)this.buildTextRangeResolver());
    }
}

