/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkPrivateOwned;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.EclipseLinkPrivateOwnedAnnotation;

public class JavaEclipseLinkPrivateOwned
extends AbstractJavaJpaContextNode
implements EclipseLinkPrivateOwned {
    protected boolean privateOwned = this.buildPrivateOwned();

    public JavaEclipseLinkPrivateOwned(JavaAttributeMapping parent) {
        super((JpaContextNode)parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setPrivateOwned_(this.buildPrivateOwned());
    }

    public boolean isPrivateOwned() {
        return this.privateOwned;
    }

    public void setPrivateOwned(boolean privateOwned) {
        if (privateOwned != this.privateOwned) {
            EclipseLinkPrivateOwnedAnnotation annotation = this.getPrivateOwnedAnnotation();
            if (privateOwned) {
                if (annotation == null) {
                    this.addPrivateOwnedAnnotation();
                }
            } else if (annotation != null) {
                this.removePrivateOwnedAnnotation();
            }
            this.setPrivateOwned_(privateOwned);
        }
    }

    protected void setPrivateOwned_(boolean privateOwned) {
        boolean old = this.privateOwned;
        this.privateOwned = privateOwned;
        this.firePropertyChanged("privateOwned", old, privateOwned);
    }

    protected boolean buildPrivateOwned() {
        return this.getPrivateOwnedAnnotation() != null;
    }

    protected EclipseLinkPrivateOwnedAnnotation getPrivateOwnedAnnotation() {
        return (EclipseLinkPrivateOwnedAnnotation)this.getResourcePersistentAttribute().getAnnotation(this.getPrivateOwnedAnnotationName());
    }

    protected EclipseLinkPrivateOwnedAnnotation addPrivateOwnedAnnotation() {
        return (EclipseLinkPrivateOwnedAnnotation)this.getResourcePersistentAttribute().addAnnotation(this.getPrivateOwnedAnnotationName());
    }

    protected void removePrivateOwnedAnnotation() {
        this.getResourcePersistentAttribute().removeAnnotation(this.getPrivateOwnedAnnotationName());
    }

    protected String getPrivateOwnedAnnotationName() {
        return "org.eclipse.persistence.annotations.PrivateOwned";
    }

    public JavaAttributeMapping getParent() {
        return (JavaAttributeMapping)super.getParent();
    }

    protected JavaAttributeMapping getAttributeMapping() {
        return this.getParent();
    }

    protected JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.getAttributeMapping().getResourcePersistentAttribute();
    }

    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getAnnotationTextRange(astRoot);
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange(astRoot);
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        EclipseLinkPrivateOwnedAnnotation annotation = this.getPrivateOwnedAnnotation();
        return annotation == null ? null : annotation.getTextRange(astRoot);
    }
}

