/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationPropertyValueModel<T1, T2>
extends PropertyValueModelWrapper<T1>
implements PropertyValueModel<T2> {
    protected final Transformer<T1, T2> transformer;

    public TransformationPropertyValueModel(PropertyValueModel<? extends T1> valueHolder) {
        super(valueHolder);
        this.transformer = this.buildTransformer();
    }

    public TransformationPropertyValueModel(PropertyValueModel<? extends T1> valueHolder, Transformer<T1, T2> transformer) {
        super(valueHolder);
        this.transformer = transformer;
    }

    protected Transformer<T1, T2> buildTransformer() {
        return new DefaultTransformer();
    }

    @Override
    public T2 getValue() {
        return this.transform(this.valueHolder.getValue());
    }

    @Override
    protected void valueChanged(PropertyChangeEvent event) {
        Object eventOldValue = event.getOldValue();
        T2 oldValue = this.transformOld(eventOldValue);
        Object eventNewValue = event.getNewValue();
        T2 newValue = this.transformNew(eventNewValue);
        this.firePropertyChanged("value", oldValue, newValue);
    }

    protected T2 transform(T1 value) {
        return this.transformer.transform(value);
    }

    protected T2 transform_(T1 value) {
        throw new RuntimeException("This method was not overridden.");
    }

    protected T2 transformOld(T1 value) {
        return this.transform(value);
    }

    protected T2 transformNew(T1 value) {
        return this.transform(value);
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DefaultTransformer
    implements Transformer<T1, T2> {
        protected DefaultTransformer() {
        }

        @Override
        public T2 transform(T1 value) {
            return value == null ? null : (Object)TransformationPropertyValueModel.this.transform_(value);
        }
    }
}

