/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyAspectAdapter<S extends Model, V>
extends AspectPropertyValueModelAdapter<S, V> {
    protected final String[] propertyNames;
    protected static final String[] EMPTY_PROPERTY_NAMES = new String[0];
    protected final PropertyChangeListener propertyChangeListener;

    protected PropertyAspectAdapter(String propertyName, S subject) {
        this(new String[]{propertyName}, subject);
    }

    protected PropertyAspectAdapter(String[] propertyNames, S subject) {
        this(new StaticPropertyValueModel<S>(subject), propertyNames);
    }

    protected PropertyAspectAdapter(PropertyValueModel<? extends S> subjectHolder, String ... propertyNames) {
        super(subjectHolder);
        this.propertyNames = propertyNames;
        this.propertyChangeListener = this.buildPropertyChangeListener();
    }

    protected PropertyAspectAdapter(PropertyValueModel<? extends S> subjectHolder, Collection<String> propertyNames) {
        this(subjectHolder, propertyNames.toArray(new String[propertyNames.size()]));
    }

    protected PropertyAspectAdapter(PropertyValueModel<? extends S> subjectHolder) {
        this(subjectHolder, EMPTY_PROPERTY_NAMES);
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                PropertyAspectAdapter.this.propertyChanged(event);
            }

            public String toString() {
                return "property change listener: " + Arrays.asList(PropertyAspectAdapter.this.propertyNames);
            }
        };
    }

    @Override
    protected void engageSubject_() {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ((Model)this.subject).addPropertyChangeListener(propertyName, this.propertyChangeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageSubject_() {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            ((Model)this.subject).removePropertyChangeListener(propertyName, this.propertyChangeListener);
            ++n2;
        }
    }

    protected void propertyChanged(PropertyChangeEvent event) {
        this.propertyChanged();
    }
}

