/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.utility.internal.model.value.AspectListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ListAddEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.ListClearEvent;
import org.eclipse.jpt.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListAspectAdapter<S extends Model, E>
extends AspectListValueModelAdapter<S, E> {
    protected final String[] listNames;
    protected static final String[] EMPTY_LIST_NAMES = new String[0];
    protected final ListChangeListener listChangeListener;

    protected ListAspectAdapter(String listName, S subject) {
        this(new String[]{listName}, subject);
    }

    protected ListAspectAdapter(String[] listNames, S subject) {
        this(new StaticPropertyValueModel<S>(subject), listNames);
    }

    protected ListAspectAdapter(PropertyValueModel<? extends S> subjectHolder, String ... listNames) {
        super(subjectHolder);
        this.listNames = listNames;
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ListAspectAdapter(PropertyValueModel<? extends S> subjectHolder, Collection<String> listNames) {
        this(subjectHolder, listNames.toArray(new String[listNames.size()]));
    }

    protected ListAspectAdapter(PropertyValueModel<? extends S> subjectHolder) {
        this(subjectHolder, EMPTY_LIST_NAMES);
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent event) {
                ListAspectAdapter.this.itemsAdded(event);
            }

            public void itemsRemoved(ListRemoveEvent event) {
                ListAspectAdapter.this.itemsRemoved(event);
            }

            public void itemsReplaced(ListReplaceEvent event) {
                ListAspectAdapter.this.itemsReplaced(event);
            }

            public void itemsMoved(ListMoveEvent event) {
                ListAspectAdapter.this.itemsMoved(event);
            }

            public void listCleared(ListClearEvent event) {
                ListAspectAdapter.this.listCleared(event);
            }

            public void listChanged(ListChangeEvent event) {
                ListAspectAdapter.this.listChanged(event);
            }

            public String toString() {
                return "list change listener: " + Arrays.asList(ListAspectAdapter.this.listNames);
            }
        };
    }

    @Override
    protected void engageSubject_() {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.subject).addListChangeListener(listName, this.listChangeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageSubject_() {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            ((Model)this.subject).removeListChangeListener(listName, this.listChangeListener);
            ++n2;
        }
    }

    protected void itemsAdded(ListAddEvent event) {
        this.fireItemsAdded(event.clone(this, "list values"));
    }

    protected void itemsRemoved(ListRemoveEvent event) {
        this.fireItemsRemoved(event.clone(this, "list values"));
    }

    protected void itemsReplaced(ListReplaceEvent event) {
        this.fireItemsReplaced(event.clone(this, "list values"));
    }

    protected void itemsMoved(ListMoveEvent event) {
        this.fireItemsMoved(event.clone(this, "list values"));
    }

    protected void listCleared(ListClearEvent event) {
        this.fireListCleared(event.clone(this, "list values"));
    }

    protected void listChanged(ListChangeEvent event) {
        this.fireListChanged(event.clone(this, "list values"));
    }
}

